;;; Disarchive
;;; Copyright © 2020, 2022 Timothy Sample <samplet@ngyro.com>
;;;
;;; This file is part of Disarchive.
;;;
;;; Disarchive is free software: you can redistribute it and/or modify
;;; it under the terms of the GNU General Public License as published by
;;; the Free Software Foundation, either version 3 of the License, or
;;; (at your option) any later version.
;;;
;;; Disarchive is distributed in the hope that it will be useful,
;;; but WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with Disarchive.  If not, see <http://www.gnu.org/licenses/>.

(define-module (disarchive config)
  #:export (%package-name
            %version
            version-message
            %tar
            %gzip
            %xz
            %bzip2
            %zgz
            %disarchive-directory-cache))

;;; Commentary:
;;;
;;; This module provides system-specific values.
;;;
;;; Code:

(define %package-name "Disarchive")
(define %version "0.6.0")

(define version-message (format #f "~a ~a~%" %package-name %version))

(define DISARCHIVE_O_NOFOLLOW 32768)

;; Older versions of Guile do not have O_NOFOLLOW, but newer ones do.
;; Hence, we check for O_NOFOLLOW and use the Guile version if we can.
(unless (and=> (module-variable (resolve-interface '(guile)) 'O_NOFOLLOW)
               variable-bound?)
  (export (DISARCHIVE_O_NOFOLLOW . O_NOFOLLOW)))

(define %tar "/gnu/store/ky4lfv9q7m6s70vprs5b201s9dqslp0f-tar-1.35/bin/tar")

(define %gzip "/gnu/store/vhbjx6ksg5r5vi3cxdc04xalw51kwms6-gzip-1.14/bin/gzip")

(define %xz "/gnu/store/mcycir1b1r34mk81wfjayz6hnkdq3j1p-xz-5.4.5/bin/xz")

(define %bzip2 "/gnu/store/190q5r2x05mp87gvkablws47cxlcwagl-bzip2-1.0.8/bin/bzip2")

(define (%zgz)
  (or (getenv "DISARCHIVE_ZGZ")
      "/gnu/store/2cfa8g44wxfz3l33iafjgsiba6pmjy2p-disarchive-0.6.0/libexec/disarchive-zgz"))

(define %disarchive-directory-cache (make-parameter #f))
