;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2015-2025 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2015 Andreas Enge <andreas@enge.fr>
;;; Copyright © 2015, 2016 Pjotr Prins <pjotr.guix@thebird.nl>
;;; Copyright © 2016, 2017 Ben Woodcroft <donttrustben@gmail.com>
;;; Copyright © 2016, 2017, 2018, 2020, 2021 Roel Janssen <roel@gnu.org>
;;; Copyright © 2017, 2018, 2019, 2020 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2017 Raoul Bonnal <ilpuccio.febo@gmail.com>
;;; Copyright © 2018 Vijayalakshmi Vedantham <vijimay12@gmail.com>
;;; Copyright © 2018 Sahithi Yarlagadda <sahi@swecha.net>
;;; Copyright © 2018 Sandeep Subramanian <sandeepsubramanian94@gmail.com>
;;; Copyright © 2018 Charlie Ritter <chewzeirta@posteo.net>
;;; Copyright © 2018 Konrad Hinsen <konrad.hinsen@fastmail.net>
;;; Copyright © 2018, 2020-2024 Mădălin Ionel Patrașcu <madalinionel.patrascu@mdc-berlin.de>
;;; Copyright © 2018 Laura Lazzati <laura.lazzati.15@gmail.com>
;;; Copyright © 2018 Leo Famulari <leo@famulari.name>
;;; Copyright © 2018 Marius Bakke <mbakke@fastmail.com>
;;; Copyright © 2018, 2019 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019 Nicolò Balzarotti <anothersms@gmail.com>
;;; Copyright © 2019, 2020, 2021, 2022 Wiktor Żelazny <wzelazny@vurv.cz>
;;; Copyright © 2019 Arne Babenhauserheide <arne_bab@web.de>
;;; Copyright © 2019, 2020, 2023 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2020 Todor Kondić <tk.code@protonmail.com>
;;; Copyright © 2020 Danjela Lura <danielaluraa@gmail.com>
;;; Copyright © 2020 Naga Malleswari <nagamalli@riseup.net>
;;; Copyright © 2020 Eric Brown <ecbrown@ericcbrown.com>
;;; Copyright © 2020 Peter Lo <peterloleungyau@gmail.com>
;;; Copyright © 2020 Rafael Luque Leiva <rafael.luque@osoco.es>
;;; Copyright © 2020, 2021 Lars-Dominik Braun <ldb@leibniz-psychology.org>
;;; Copyright © 2020 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Antoine Côté <antoine.cote@posteo.net>
;;; Copyright © 2020 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2020 Magali Lemes <magalilemes00@gmail.com>
;;; Copyright © 2020-2023, 2025 Simon Tournier <zimon.toutoune@gmail.com>
;;; Copyright © 2020 Aniket Patil <aniket112.patil@gmail.com>
;;; Copyright © 2021 Marcel Schilling <marcel.schilling@uni-luebeck.de>
;;; Copyright © 2021 Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2022-2024 Navid Afkhami <navid.afkhami@mdc-berlin.de>
;;; Copyright © 2022 Greg Hogan <code@greghogan.com>
;;; Copyright © 2023 Kyle Andrews <kyle@posteo.net>
;;; Copyright © 2024 Marco Baggio <guix@mawumag.com>
;;; Copyright © 2024, 2025 Spencer King <spencer.king@wustl.edu>
;;; Copyright © 2024-2025 Tor-björn Claesson <tclaesson@gmail.com>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages cran)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (guix packages)
  #:use-module (guix download)
  #:use-module (guix gexp)
  #:use-module (guix git-download)
  #:use-module (guix utils)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system r)
  #:use-module (gnu packages)
  #:use-module (gnu packages algebra)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages base)
  #:use-module (gnu packages bioinformatics)
  #:use-module (gnu packages c)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages curl)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages fribidi)
  #:use-module (gnu packages gawk)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages geo)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages gl)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages image)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages java)
  #:use-module (gnu packages javascript)
  #:use-module (gnu packages jupyter)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages machine-learning)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages mpi)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages node)
  #:use-module (gnu packages ocr)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages pulseaudio)  ;libsndfile
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-xyz)
  #:use-module (gnu packages rdf)
  #:use-module (gnu packages rust)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages sqlite)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages tbb)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages textutils)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xorg)
  #:use-module ((srfi srfi-1) #:hide (zip))
  #:use-module (ice-9 match))

(define-public r-abbreviate
  (package
    (name "r-abbreviate")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abbreviate" version))
       (sha256
        (base32 "1cvjdbi17qz8gr5898zchm5fyz4n51z66lwps25v8a9mhwab8imi"))))
    (properties `((upstream-name . "abbreviate")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/sigbertklinke/abbreviate")
    (synopsis "Readable string abbreviation")
    (description
     "This package abbreviates strings to a specified minimum number of
characters, such that the strings remain unique (if they originally were).")
    (license license:gpl3)))

(define-public r-acepack
  (package
    (name "r-acepack")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "acepack" version))
       (sha256
        (base32
         "00z5pv28liyrxwhaizsp5g6kn7qd6qghmmyaka43i7jsh8fy06xw"))))
    (properties
     `((upstream-name . "acepack")
       (updater-extra-inputs . ("gfortran"))))
    (build-system r-build-system)
    (inputs
     (list gfortran))
    (native-inputs (list gfortran r-testthat))
    (home-page "https://cran.r-project.org/web/packages/acepack")
    (synopsis "Functions for regression transformations")
    (description
     "This package provides ACE and AVAS methods for choosing regression
transformations.")
    (license license:expat)))

(define-public r-ade4
  (package
    (name "r-ade4")
    (version "1.7-23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ade4" version))
       (sha256
        (base32
         "0zv7fsa3b7j0y84hc99m0r32m1irp51pyh47hg14zwk8iykcb4ih"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-pixmap r-rcpp r-rcpparmadillo r-sp))
    (home-page "https://pbil.univ-lyon1.fr/ADE-4")
    (synopsis "Multivariate data analysis and graphical display")
    (description
     "The ade4 package contains data analysis functions to analyze ecological
and environmental data in the framework of Euclidean exploratory methods.")
    (license license:gpl2+)))

(define-public r-aer
  (package
    (name "r-aer")
    (version "1.2-14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "AER" version))
              (sha256
               (base32
                "06l7h1gdyc007hx5xavkb879mgqnskcq2zrbr0xbm88rv1b63a26"))))
    (properties `((upstream-name . "AER")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-formula
           r-lmtest
           r-sandwich
           r-survival
           r-zoo))
    (native-inputs (list r-foreign))
    (home-page "https://cran.r-project.org/package=AER")
    (synopsis "Applied econometrics with R")
    (description
     "This package provides functions, data sets, examples, demos, and
vignettes for the book Christian Kleiber and Achim Zeileis (2008), Applied
Econometrics with R, Springer-Verlag, New York.  ISBN 978-0-387-77316-2. (See
the vignette \"AER\" for a package overview.)")
    ;; Either version of the GPL
    (license (list license:gpl2 license:gpl3))))

(define-public r-afpt
  (package
    (name "r-afpt")
    (version "1.1.0.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "afpt" version))
              (sha256
               (base32
                "15pa4p78p6r478l05481lzx6z4ahswj728s1sb3xp3pvn6rv4jfj"))))
    (properties `((upstream-name . "afpt")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/MarcoKlH/afpt-r/")
    (synopsis "Tools for modelling of animal flight performance")
    (description
     "This package allows estimation and modelling of flight costs in animal
(vertebrate) flight, implementing the aerodynamic power model.  Flight
performance is estimated based on basic morphological measurements such as
body mass, wingspan and wing area.  @code{Afpt} can be used to make
predictions on how animals should adjust their flight behaviour and wingbeat
kinematics to varying flight conditions.")
    (license license:gpl3+)))

(define-public r-aod
  (package
    (name "r-aod")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aod" version))
       (sha256
        (base32 "0zh8sjzbsq3sjzayv8wa0n1vh654g47xkxklgzxcsy3xpy55w95p"))))
    (properties `((upstream-name . "aod")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=aod")
    (synopsis "Analysis of overdispersed data")
    (description
     "This package provides a set of functions to analyze overdispersed counts
or proportions.  Most of the methods are already available elsewhere but are
scattered in different packages.  The proposed functions should be considered
as complements to more sophisticated methods such as @dfn{generalized
estimating equations} (GEE) or @dfn{generalized linear mixed effect
models} (GLMM).")
    (license license:gpl2+)))

(define-public r-asioheaders
  (package
    (name "r-asioheaders")
    (version "1.30.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AsioHeaders" version))
       (sha256
        (base32 "0cdbw8w9mj2a6syqvhb11pyhjdrjg3yb8wsn9gw4ww6cli43pr0v"))))
    (properties `((upstream-name . "AsioHeaders")))
    (build-system r-build-system)
    (home-page "https://github.com/eddelbuettel/asioheaders")
    (synopsis "Asio C++ header files")
    (description
     "Asio is a cross-platform C++ library for network and low-level I/O
programming that provides developers with a consistent asynchronous model
using a modern C++ approach.  It is also included in Boost but requires
linking when used with Boost.  Standalone it can be used header-only (provided
a recent compiler).  Asio is written and maintained by Christopher
M. Kohlhoff, and released under the Boost Software License', Version 1.0.")
    (license license:boost1.0)))

(define-public r-assertthat
  (package
    (name "r-assertthat")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "assertthat" version))
              (sha256
               (base32
                "17wy5bdfzg73sg2clisg1k3zyn1adkj59x56m5nwia2k8z67zkw5"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/assertthat")
    (synopsis "Easy pre and post assertions")
    (description
     "Assertthat is an extension to @code{stopifnot()} that makes it easy to
declare the pre and post conditions that your code should satisfy, while also
producing friendly error messages so that your users know what they've done
wrong.")
    (license license:gpl3+)))

(define-public r-aster
  (package
    (name "r-aster")
    (version "1.3-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aster" version))
       (sha256
        (base32 "0inj8gn29z6apjh9h2ps26j7077k91l9m637rsdav2b8a87anw5h"))))
    (properties `((upstream-name . "aster")))
    (build-system r-build-system)
    (propagated-inputs (list r-trust))
    (native-inputs (list r-numderiv))
    (home-page "http://www.stat.umn.edu/geyer/aster/")
    (synopsis "Aster Models")
    (description
     "Aster models (Geyer, Wagenius, and Shaw, 2007,
<doi:10.1093/biomet/asm030>; Shaw, Geyer, Wagenius, Hangelbroek, and Etterson,
2008, <doi:10.1086/588063>; Geyer, Ridley, Latta, Etterson, and Shaw, 2013,
<doi:10.1214/13-AOAS653>) are exponential family regression models for life
history analysis.  They are like generalized linear models except that
elements of the response vector can have different families (e.2g., some
Bernoulli, some Poisson, some zero-truncated Poisson, some normal) and can be
dependent, the dependence indicated by a graphical structure.  Discrete time
survival analysis, life table analysis, zero-inflated Poisson regression, and
generalized linear models that are exponential family (e.g., logistic
regression and Poisson regression with log link) are special cases.  Main use
is for data in which there is survival over discrete time periods and there is
additional data about what happens conditional on survival (e.g., number of
offspring).  Uses the exponential family canonical parameterization (aster
transform of usual parameterization).  There are also random effects versions
of these models.")
    (license license:expat)))

(define-public r-autometric
  (package
    (name "r-autometric")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "autometric" version))
       (sha256
        (base32 "1dk2k78niqx9n8pq95cyx4qw00cmic47lyrg5ac0ghr25539jrld"))))
    (properties `((upstream-name . "autometric")))
    (build-system r-build-system)
    (native-inputs (list r-callr r-ps r-tinytest))
    (home-page "https://wlandau.github.io/autometric/")
    (synopsis "Background resource logging")
    (description
     "Intense parallel workloads can be difficult to monitor.  Packages
@code{crew.cluster}, @code{clustermq}, and @code{future.batchtools} distribute
hundreds of worker processes over multiple computers.  If a worker process
exhausts its available memory, it may terminate silently, leaving the
underlying problem difficult to detect or troubleshoot.  Using the autometric
package, a worker can proactively monitor itself in a detached background
thread.  The worker process itself runs normally, and the thread writes to a
log every few seconds.  If the worker terminates unexpectedly, autometric can
read and visualize the log file to reveal potential resource-related reasons
for the crash.  The autometric package borrows heavily from the methods of
packages @code{ps} and @code{psutil}.")
    (license license:expat)))

(define-public r-backports
  (package
    (name "r-backports")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "backports" version))
       (sha256
        (base32
         "18kwi50bvha6p5jfl833grmhqzi55adnd3glcy4yh18mizdxjghd"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/backports")
    (synopsis "Reimplementations of functions introduced since R 3.0.0")
    (description
     "Provides implementations of functions which have been introduced in R
since version 3.0.0.  The backports are conditionally exported which results
in R resolving the function names to the version shipped with R (if available)
and uses the implemented backports as fallback.  This way package developers
can make use of the new functions without worrying about the minimum required
R version.")
    (license license:gpl2+)))

(define-public r-base64
  (package
    (name "r-base64")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "base64" version))
       (sha256
        (base32
         "030f8ynlga2qych88d45hk491cfi25hrjwl2gj4gsphljvi7ps5i"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-openssl))
    (home-page "https://cran.r-project.org/web/packages/base64")
    (synopsis "Base64 encoder and decoder")
    (description
     "This package is a compatibility wrapper to replace the orphaned package
by Romain Francois.  New applications should use the openssl or base64enc
package instead.")
    (license license:expat)))

(define-public r-base64enc
  (package
    (name "r-base64enc")
    (version "0.1-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "base64enc" version))
              (sha256
               (base32
                "13b89fhg1nx7zds82a0biz847ixphg9byf5zl2cw9kab6s56v1bd"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/base64enc")
    (synopsis "Tools for Base64 encoding")
    (description
     "This package provides tools for handling Base64 encoding.  It is more
flexible than the orphaned \"base64\" package.")
    (license license:gpl2+)))

(define-public r-batchjobs
  (package
    (name "r-batchjobs")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BatchJobs" version))
       (sha256
        (base32
         "0xsw25j2ks9bqgz189qdcyj8hzz93snknlik83nj04s6vy0w7aax"))))
    (properties
     '((upstream-name . "BatchJobs")
       (updater-extra-native-inputs . ("r-mass"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports
           r-bbmisc
           r-brew
           r-checkmate
           r-data-table
           r-dbi
           r-digest
           r-rsqlite
           r-sendmailr
           r-stringi))
    (native-inputs (list r-mass r-testthat))
    (home-page "https://github.com/tudo-r/BatchJobs")
    (synopsis "Batch computing with R")
    (description
     "This package provides @code{Map}, @code{Reduce} and @code{Filter}
variants to generate jobs on batch computing systems like PBS/Torque, LSF,
SLURM and Sun Grid Engine.  Multicore and SSH systems are also supported.")
    (license license:bsd-2)))

(define-public r-bayesfactor
  (package
    (name "r-bayesfactor")
    (version "0.9.12-4.7")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "BayesFactor" version))
        (sha256
          (base32
            "0z9p9vdcmcdwqmixaiqnhli2b06whbap6y4pqx4a5gcdgxlj09zr"))))
    (properties `((upstream-name . "BayesFactor")))
    (build-system r-build-system)
    ;; Tests fail with: could not find function "context"
    (arguments (list #:test-types '(list "vignettes")))
    (propagated-inputs
     (list r-coda
           r-hypergeo
           r-matrix
           r-matrixmodels
           r-mvtnorm
           r-pbapply
           r-rcpp
           r-rcppeigen
           r-stringr))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://richarddmorey.github.io/BayesFactor/")
    (synopsis "Computation of Bayes factors for common designs")
    (description
     "This package provides a suite of functions for computing various Bayes
factors for simple designs, including contingency tables, one- and two-sample
designs, one-way designs, general ANOVA designs, and linear regression.")
    (license license:gpl2)))

(define-public r-bbmisc
  (package
    (name "r-bbmisc")
    (version "1.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BBmisc" version))
       (sha256
        (base32
         "01a43raxj374cg6khs14r0bxvfm8v1sp0p2ambp7npnizvwxqi8i"))))
    (properties
     '((upstream-name . "BBmisc")
       (updater-extra-native-inputs . ("r-codetools"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate r-data-table))
    (native-inputs (list r-codetools r-testthat))
    (home-page "https://github.com/berndbischl/BBmisc")
    (synopsis "Miscellaneous functions for R package development")
    (description
     "This package provides miscellaneous helper functions for the development
of R packages.")
    (license license:bsd-3)))

(define-public r-beepr
  (package
    (name "r-beepr")
    (version "2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "beepr" version))
       (sha256
        (base32 "0xq4qs06f61m1q6gb157n4c3j7pf7wanh27nr2lr228s7k4mw3k2"))))
    (properties `((upstream-name . "beepr")))
    (build-system r-build-system)
    (propagated-inputs (list r-audio))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rasmusab/beepr")
    (synopsis "Easily play notification sounds on any platform")
    (description
     "The main function of this package is @code{beep()}, with the purpose to
make it easy to play notification sounds on whatever platform you are on.  It
is intended to be useful, for example, if you are running a long analysis in
the background and want to know when it is ready.")
    (license license:gpl3)))

(define-public r-beeswarm
  (package
    (name "r-beeswarm")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "beeswarm" version))
              (sha256
               (base32
                "016mqcbdksialkmap56rprzna9b6cd6896ml9gl2n2h8yjdk7x2i"))))
    (build-system r-build-system)
    (home-page "https://www.cbs.dtu.dk/~eklund/beeswarm/")
    (synopsis "Implementation of bee swarm plots")
    (description
     "This package provides an implementation of bee swarm plots.  The bee
swarm plot is a one-dimensional scatter plot like stripchart, but with
closely-packed, non-overlapping points.")
    (license license:artistic2.0)))

(define-public r-betareg
  (package
    (name "r-betareg")
    (version "3.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "betareg" version))
       (sha256
        (base32 "0iizgzlsk4gm6pjb4i4qwcig2c4crngxkrmdasnr0qzc0piq5dnw"))))
    (properties
     '((upstream-name . "betareg")
       (updater-extra-native-inputs . ("r-partykit"))))
    (build-system r-build-system)
    ;; Vignettes need r-quarto.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-flexmix r-formula r-lmtest r-modeltools
                             r-sandwich))
    (native-inputs (list r-partykit r-quarto))
    (home-page "https://topmodels.R-Forge.R-project.org/betareg/")
    (synopsis "Beta regression")
    (description
     "This package implements beta regression for modeling beta-distributed
dependent variables on the open unit interval (0, 1), e.g., rates and
proportions, see Cribari-Neto and Zeileis (2010) <doi:10.18637/jss.v034.i02>.
Moreover, extended-support beta regression models can accommodate dependent
variables with boundary observations at 0 and/or 1.  For the classical beta
regression model, alternative specifications are provided: Bias-corrected and
bias-reduced estimation, finite mixture models, and recursive partitioning for
beta regression, see <doi:10.18637/jss.v048.i11>.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-bh
  (package
    (name "r-bh")
    (version "1.87.0-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "BH" version))
              (sha256
               (base32
                "14q3wq9aix8fsbd09dj3nbhh89wpbxzn2l8wk8l26apl6pk9m0jr"))))
    (build-system r-build-system)
    (home-page "https://github.com/eddelbuettel/bh")
    (synopsis "R package providing subset of Boost headers")
    (description
     "This package aims to provide the most useful subset of Boost libraries
for template use among CRAN packages.")
    (license license:boost1.0)))

(define-public r-biased-urn
  (package
   (name "r-biased-urn")
   (version "2.0.12")
   (source
    (origin
     (method url-fetch)
     (uri (cran-uri "BiasedUrn" version))
     (sha256
      (base32
       "14jpijms81pgl4zyqrhwwdfj0jmlmml21blspvin8lqw8fbbbcr9"))))
   (properties `((upstream-name . "BiasedUrn")))
   (build-system r-build-system)
   (home-page "https://www.agner.org/random/")
   (synopsis "Biased urn model distributions")
   (description
    "This package provides statistical models of biased sampling in the form
of univariate and multivariate noncentral hypergeometric distributions,
including Wallenius' noncentral hypergeometric distribution and Fisher's
noncentral hypergeometric distribution (also called extended hypergeometric
distribution).")
   (license license:gpl3+)))

(define-public r-bigassertr
  (package
    (name "r-bigassertr")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigassertr" version))
       (sha256
        (base32 "0bk11jinlc1cvm6aaq9mccs9i328b8s2lbwq63a42fgf1qng103p"))))
    (properties `((upstream-name . "bigassertr")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/privefl/bigassertr")
    (synopsis "Assertion and message functions")
    (description
     "This package provides enhanced message functions @code{(cat()} /
@code{message()} / @code{warning()} / @code{error()}) using wrappers around
@code{sprintf()}.  It also provides multiple assertion functions (e.g. to
check class, length, values, files, arguments, etc.).")
    (license license:gpl3)))

(define-public r-bigmemory
  (package
    (name "r-bigmemory")
    (version "4.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigmemory" version))
       (sha256
        (base32
         "0b80c2nsgphgr3cnvf75a0z3bzqx4q1a4dplq0h2izc71mn5fgzy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh r-bigmemory-sri r-rcpp r-uuid))
    (inputs
     (list `(,util-linux "lib"))) ;for -luuid
    (native-inputs (list r-testthat))
    (supported-systems
     (fold delete
           %supported-systems
           ;; Build fails on these systems
           '("armhf-linux"
             "aarch64-linux"
             "powerpc64le-linux")))
    (home-page "http://www.bigmemory.org")
    (synopsis "Manage large matrices with shared memory or memory-mapped files")
    (description "This package provides methods to create, store, access, and
manipulate large matrices.  Matrices are allocated to shared memory and may use
memory-mapped files.")
    ;; Users can choose either LGPLv3 or ASL2.0.
    (license (list license:lgpl3 license:asl2.0))))

(define-public r-bigmemory-sri
  (package
    (name "r-bigmemory-sri")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigmemory.sri" version))
       (sha256
        (base32 "0wbpk3naipl0ab3wnixnp2n874kazrapv1c31fi3cxm19b94x6h2"))))
    (properties
     `((upstream-name . "bigmemory.sri")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bigmemory.sri")
    (synopsis "Shared resource interface for the bigmemory package")
    (description "This package provides a shared resource interface for the
bigmemory and synchronicity packages.")
    ;; Users can choose either LGPLv3 or ASL2.0.
    (license (list license:lgpl3 license:asl2.0))))

(define-public r-bigparallelr
  (package
    (name "r-bigparallelr")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigparallelr" version))
       (sha256
        (base32 "14rkcig4j93c231sfm43331ykmvxjx2fiz5nhblj2rfzkxli4css"))))
    (properties `((upstream-name . "bigparallelr")))
    (build-system r-build-system)
    (propagated-inputs (list r-bigassertr
                             r-doparallel
                             r-flock
                             r-foreach
                             r-parallelly
                             r-rhpcblasctl))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/privefl/bigparallelr")
    (synopsis "Easy parallel tools")
    (description
     "This package provides utility functions for easy parallelism in R.  This
includes some reexports from other packages, utility functions for splitting
and parallelizing over blocks, and choosing and setting the number of cores
used.")
    (license license:gpl3)))

(define-public r-bigreadr
  (package
    (name "r-bigreadr")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigreadr" version))
       (sha256
        (base32 "15wy5rphk2l59k8fk68a15xsvy8nxj1srnc2c86i7y5ym04a856k"))))
    (properties `((upstream-name . "bigreadr")))
    (build-system r-build-system)
    (arguments (list #:tests? #false)) ;tests attempt to read from GitHub.
    (propagated-inputs (list r-bigassertr r-data-table r-parallelly r-rcpp))
    (native-inputs (list r-spelling r-testthat))
    (home-page "https://github.com/privefl/bigreadr")
    (synopsis "Read large text files")
    (description
     "Read large text files by splitting them in smaller files.  This package
also provides some convenient wrappers around @code{fread()} and
@code{fwrite()} from package @code{data.table}.")
    (license license:gpl3)))

(define-public r-bigstatsr
  (package
    (name "r-bigstatsr")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigstatsr" version))
       (sha256
        (base32 "1c445mm11gsvs2sqmrblig1d3456vwb1n3rz08mhkpxghjaf4dci"))))
    (properties `((upstream-name . "bigstatsr")))
    (build-system r-build-system)
    (propagated-inputs (list r-bigassertr
                             r-bigparallelr
                             r-cowplot
                             r-foreach
                             r-ggplot2
                             r-ps
                             r-rcpp
                             r-rcpparmadillo
                             r-rmio
                             r-rspectra
                             r-tibble))
    (native-inputs (list r-bigmemory
                         r-bigreadr
                         r-dplyr
                         r-modelmetrics
                         r-ppcor
                         r-psychometric
                         r-spelling
                         r-testthat))
    (home-page "https://privefl.github.io/bigstatsr/")
    (synopsis "Statistical tools for file-backed big matrices")
    (description
     "This package aims to provide easy-to-use, efficient, flexible and
scalable statistical tools.  It provides and uses file-backed big matrices via
memory-mapping.  It provides for instance matrix operations, Principal
Component Analysis, sparse linear supervised models, utility functions and
more.")
    (license license:gpl3)))

(define-public r-binom
  (package
    (name "r-binom")
    (version "1.1-1.1")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "binom" version))
        (sha256
          (base32 "1yxyhsd0savwirlmgnq6973slfakqyfvjm0zz60cmc9v490my8gf"))))
    (properties `((upstream-name . "binom")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=binom")
    (synopsis "Binomial confidence intervals for several parameterizations")
    (description
      "Constructs confidence intervals on the probability of success in a
binomial experiment via several parameterizations")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-bit
  (package
    (name "r-bit")
    (version "4.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bit" version))
       (sha256
        (base32
         "026y8la4g4nyflh4w8zvlwqwdh4m8c3n1ssyd56p4yscs32j3zj8"))))
    (build-system r-build-system)
    ;; Tests require r-ff, which depends on this package.
    (arguments (list #:tests? #false))
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://ff.r-forge.r-project.org")
    (synopsis "Class for vectors of 1-bit booleans")
    (description
     "This package provides bitmapped vectors of booleans (no @code{NA}s),
coercion from and to logicals, integers and integer subscripts, fast boolean
operators and fast summary statistics.  With @code{bit} class vectors of true
binary booleans, @code{TRUE} and @code{FALSE} can be stored with 1 bit only.")
    (license license:gpl2)))

(define-public r-bit64
  (package
    (name "r-bit64")
    (version "4.6.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bit64" version))
       (sha256
        (base32
         "1dqr2g43rhiryzgpfsjb7mb4idnz2jl31jdsvjgrlb625wacxh7v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bit))
    (native-inputs (list r-testthat))
    (home-page "https://ff.r-forge.r-project.org/")
    (synopsis "S3 class for vectors of 64 bit integers")
    (description
     "The bit64 package provides serializable S3 atomic 64 bit (signed)
integers that can be used in vectors, matrices, arrays and @code{data.frames}.
Methods are available for coercion from and to logicals, integers, doubles,
characters and factors as well as many elementwise and summary functions.
Many fast algorithmic operations such as @code{match} and @code{order} support
interactive data exploration and manipulation and optionally leverage
caching.")
    (license license:gpl2)))

(define-public r-bitops
  (package
    (name "r-bitops")
    (version "1.0-9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bitops" version))
              (sha256
               (base32
                "020dfk0pmiz739rnpb9yi8hnsih3z3891dljvs7kpfvjgfvsbwyg"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bitops")
    (synopsis "Bitwise operations")
    (description
     "This package provides functions for bitwise operations on integer
vectors.")
    (license license:gpl2+)))

(define-public r-blob
  (package
    (name "r-blob")
    (version "1.2.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "blob" version))
              (sha256
               (base32
                "13vjy9f3zki8w1damz6kqq47689mk4l1navnwh7r6z8lqkmj52fh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rlang r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/blob")
    (synopsis "Simple S3 Class for representing vectors of binary data")
    (description "Raw vectors in R are useful for storing a single binary
object.  What if you want to put a vector of them in a data frame?  The blob
package provides the blob object, a list of raw vectors, suitable for use as
a column in data frame.")
    (license license:gpl3+)))

(define-public r-bigd
  (package
    (name "r-bigd")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bigD" version))
       (sha256
        (base32 "1lc8c3g22sb3mkmr0vjw6x92cs04gdfsny1iii0v3xj9337v1cc6"))))
    (properties
     '((upstream-name . "bigD")
       (updater-extra-native-inputs . ("r-vctrs"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat r-vctrs))
    (home-page "https://cran.r-project.org/package=bigD")
    (synopsis "Flexibly format dates and times to a given locale")
    (description
     "Format dates and times flexibly and to whichever locales make sense.
This package parses dates, times, and date-times in various formats (including
string-based ISO 8601 constructions).  The formatting syntax gives the user
many options for formatting the date and time output in a precise manner.
Time zones in the input can be expressed in multiple ways and there are many
options for formatting time zones in the output as well.  Several of the
provided helper functions allow for automatic generation of locale-aware
formatting patterns based on date/time skeleton formats and standardized
date/time formats with varying specificity.")
    (license license:expat)))

(define-public r-bma
  (package
    (name "r-bma")
    (version "3.18.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BMA" version))
       (sha256
        (base32 "18rhz04ykd4gpf8wkj93x5q64ng0x44w7bakhjrsigrcpxnajwid"))))
    (properties `((upstream-name . "BMA")))
    (build-system r-build-system)
    (propagated-inputs (list r-inline r-leaps r-robustbase r-rrcov r-survival))
    (native-inputs (list gfortran r-mass))
    (home-page "https://github.com/hanase/BMA")
    (synopsis "Bayesian model averaging")
    (description
     "This is a package for Bayesian model averaging and variable selection
for linear models, generalized linear models and survival models (cox
regression).")
    (license license:gpl2+)))

(define-public r-boot
  (package
    (name "r-boot")
    (version "1.3-31")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "boot" version))
       (sha256
        (base32
         "1ln8079g7l6yxdh7bmcn2acjlln0hvrhhjbp5r0wl0xms662wm6q"))))
    (build-system r-build-system)
    (native-inputs (list r-survival))
    (home-page "https://cran.r-project.org/web/packages/boot")
    (synopsis "Bootstrap functions for R")
    (description
     "This package provides functions and datasets for bootstrapping from the
book \"Bootstrap Methods and Their Application\" by A.C. Davison and
D.V. Hinkley (1997, CUP), originally written by Angelo Canty for S.")
    ;; Unlimited distribution
    (license (license:non-copyleft "file://R/bootfuns.q"))))

(define-public r-box
  (package
    (name "r-box")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "box" version))
       (sha256
        (base32 "00g5ik3f6260m38jl8k4s8nycmy7mzdwr7qslrl66phpg84xzmln"))))
    (properties `((upstream-name . "box")))
    (arguments
     ;; Tests don't work because of this error:
     ;; the ‘box’ package is not supposed to be attached!
     (list #:test-types '(list "vignettes")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://klmr.me/box/")
    (synopsis "Write reusable, composable and modular R code")
    (description
     "This package provides a modern module system for R.  Organize code into
hierarchical, composable, reusable modules, and use it effortlessly across
projects via a flexible, declarative dependency loading syntax.")
    (license license:expat)))

(define-public r-bread
  (package
    (name "r-bread")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bread" version))
       (sha256
        (base32 "0vsxmqpgi2yjcpdpgdz6gzqkpjsq5ax4qkpys60bwmxyp1ahv90r"))))
    (properties `((upstream-name . "bread")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-locations
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((gawk (search-input-file inputs "bin/gawk"))
                   (grep (search-input-file inputs "bin/grep"))
                   (head (search-input-file inputs "bin/head"))
                   (sed  (search-input-file inputs "bin/sed"))
                   (tail (search-input-file inputs "bin/tail"))
                   (wc   (search-input-file inputs "bin/wc")))
               (substitute* "R/helper_functions.R"
                 (("'grep ")
                  (string-append "'" grep " "))
                 (("'sed ")
                  (string-append "'" sed " "))
                 (("'tail ")
                  (string-append "'" tail " "))
                 (("'awk ")
                  (string-append "'" gawk " ")))
               (substitute* "R/bnrow.R"
                 (("'wc ")
                  (string-append "'" wc " ")))
               (substitute* "R/bsep.R"
                 (("'head ")
                  (string-append "'" head " ")))))))))
    (inputs (list coreutils gawk grep sed))
    (propagated-inputs (list r-data-table))
    (home-page "https://github.com/MagicHead99/bread/")
    (synopsis "Analyze big files without loading them in memory")
    (description
     "This package provides a simple set of wrapper functions for
@code{data.table::fread()} that allows subsetting or filtering rows and
selecting columns of table-formatted files too large for the available RAM.")
    (license license:gpl3+)))

(define-public r-brew
  (package
    (name "r-brew")
    (version "1.0-10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "brew" version))
              (sha256
               (base32
                "13x3vnrhfcvr479r4dya61a5vcky2gb4kv2xbivy0ah39qrzg0a1"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/brew")
    (synopsis "Templating framework for report generation")
    (description
     "The brew package implements a templating framework for mixing text and R
code for report generation.  The template syntax is similar to PHP, Ruby's erb
module, Java Server Pages, and Python's psp module.")
    (license license:gpl2+)))

(define-public r-brio
  (package
    (name "r-brio")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brio" version))
       (sha256
        (base32
         "1f6hh7mck4bb1caivcvr6ms2pyqzzzawqyxjbgi9s0rrx8sj7wm9"))))
    (properties
     ;; We can't add testthat here because of a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))
       (upstream-name . "brio")))
    (build-system r-build-system)
    ;; Tests require r-testthat, which uses r-brio as an input.
    (arguments (list #:tests? #false))
    (home-page "https://github.com/r-lib/brio")
    (synopsis "Basic R input output")
    (description
     "This package provides functions to handle basic input output.  These
functions always read and write UTF-8 (8-bit Unicode Transformation Format)
files and provide more explicit control over line endings.")
    (license license:expat)))

(define-public r-broom-helpers
  (package
    (name "r-broom-helpers")
    (version "1.21.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "broom.helpers" version))
       (sha256
        (base32 "1b3zk163fwkba8bfa08wrailapnh7iqvr02pv2nlwkyzk710rzja"))))
    (properties `((upstream-name . "broom.helpers")))
    (build-system r-build-system)
    ;; Tests require gtsummary, which cannot be packaged due to massive
    ;; amounts of minified JavaScript.
    (arguments (list #:test-types '(list "vignettes")))
    (propagated-inputs (list r-broom
                             r-cards
                             r-cli
                             r-dplyr
                             r-labelled
                             r-lifecycle
                             r-purrr
                             r-rlang
                             r-stringr
                             r-tibble
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://larmarange.github.io/broom.helpers/")
    (synopsis "Helpers for Model Coefficients Tibbles")
    (description
     "This package provides suite of functions to work with regression model
@code{broom::tidy()} tibbles.  The suite includes functions to group
regression model terms by variable, insert reference and header rows for
categorical variables, add variable labels, and more.")
    (license license:gpl3+)))

(define-public r-ca
  (package
    (name "r-ca")
    (version "0.71.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ca" version))
              (sha256
               (base32
                "095lk7p2b9835hc3a03c4019wg0baf0dhz6c2vqpaq1m9k4jy304"))))
    (properties `((upstream-name . "ca")))
    (build-system r-build-system)
    (home-page "http://www.carme-n.org/")
    (synopsis "Simple, multiple and joint correspondence analysis")
    (description
     "This is a package for computation and visualization of simple,
multiple and joint correspondence analysis.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-cachem
  (package
    (name "r-cachem")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cachem" version))
       (sha256
        (base32
         "089f963h59z4n0sj3isjq2h7zw2485qw38jv8zdnbn755by3j22m"))))
    (properties `((upstream-name . "cachem")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastmap r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://cachem.r-lib.org/")
    (synopsis "Cache R objects with automatic pruning")
    (description
     "This package provides key-value stores with automatic pruning.  Caches
can limit either their total size or the age of the oldest object (or both),
automatically pruning objects to maintain the constraints.")
    (license license:expat)))

(define-public r-caic4
  (package
    (name "r-caic4")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cAIC4" version))
       (sha256
        (base32 "0ixkhnsbpqx5pw0r3dvrwymbwr2k7xlv5gwp7cyd2rxafsqrp5m9"))))
    (properties `((upstream-name . "cAIC4")))
    (build-system r-build-system)
    (propagated-inputs (list r-lme4
                             r-matrix
                             r-mgcv
                             r-mvtnorm
                             r-nlme
                             r-rlrsim))
    (home-page "https://cran.r-project.org/package=cAIC4")
    (synopsis "Conditional AIC for lme4 and nlme")
    (description
     "This package estimates conditional Akaike information in mixed-effect
models.  These models are fitted using @code{(g)lmer()} from lme4,
@code{lme()} from nlme, and @code{gamm()} from mgcv.  The provided functions
facilitate the computation of the conditional Akaike information for model
evaluation.")
    (license license:gpl2+)))

(define-public r-cairo
  (package
    (name "r-cairo")
    (version "1.6-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Cairo" version))
       (sha256
        (base32
         "0qjdsj6mpbwvnp8cimc4yrqfq3z68pfcd78ahsai52hpjdplqvvb"))))
    (properties `((upstream-name . "Cairo")))
    (build-system r-build-system)
    (inputs
     (list cairo harfbuzz icu4c libjpeg-turbo libtiff zlib))
    (native-inputs
     (list pkg-config))
    (home-page "https://www.rforge.net/Cairo/")
    (synopsis "R graphics device using Cairo graphics library")
    (description
     "This package provides a Cairo graphics device that can be use to create
high-quality vector (PDF, PostScript and SVG) and bitmap output (PNG, JPEG,
TIFF), and high-quality rendering in displays (X11 and Win32).  Since it uses
the same back-end for all output, copying across formats is WYSIWYG.  Files
are created without the dependence on X11 or other external programs.  This
device supports alpha channel (semi-transparent drawing) and resulting images
can contain transparent and semi-transparent regions.  It is ideal for use in
server environments (file output) and as a replacement for other devices that
don't have Cairo's capabilities such as alpha support or anti-aliasing.
Backends are modular such that any subset of backends is supported.")
    (license license:gpl2)))

(define-public r-car
  (package
    (name "r-car")
    (version "3.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "car" version))
       (sha256
        (base32 "1gs9prinmxn4l6w8lyig3mzm1j2zfq3yhkznm1igd5ar74jc1wjr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-cardata
           r-formula
           r-lme4
           r-mass
           r-mgcv
           r-nlme
           r-nnet
           r-pbkrtest
           r-quantreg
           r-scales))
    (native-inputs (list r-knitr))
    (home-page "https://r-forge.r-project.org/projects/car/")
    (synopsis "Companion to applied regression")
    (description
     "This package provides functions and datasets from book Companion to
Applied regression, Second Edition, Sage, 2011.")
    (license license:gpl2+)))

(define-public r-cardata
  (package
    (name "r-cardata")
    (version "3.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "carData" version))
       (sha256
        (base32 "06j52rpbqi6fj7chfjwjbwbr6slrbb7i3aygv66gnfiyndcp3rq2"))))
    (properties `((upstream-name . "carData")))
    (build-system r-build-system)
    (home-page "https://r-forge.r-project.org/projects/car/")
    (synopsis "Data sets for the book Companion to Applied Regression")
    (description
     "This package provides datasets to accompany J. Fox and S. Weisberg, An R
Companion to Applied Regression, Third Edition, Sage.")
    (license license:gpl2+)))

(define-public r-cards
  (package
    (name "r-cards")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cards" version))
       (sha256
        (base32 "1g41i4nqkgzb1sv2f9hy06h0m2hmlcpqgc2ssjm2l7dcbgy5534f"))))
    (properties
     `((upstream-name . "cards")
       ;; Do not create dependency cycle.
       (updater-ignored-native-inputs . ("r-cardx"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dplyr
                             r-glue
                             r-lifecycle
                             r-rlang
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-testthat r-withr))
    (home-page "https://github.com/insightsengineering/cards")
    (synopsis "Analysis Results Data")
    (description
     "This package lets you construct @dfn{Clinical Data Interchange Standards
Consortium} (CDISC) compliant Analysis Results Data objects.  These objects
are used and re-used to construct summary tables, visualizations, and written
reports.  The package also exports utilities for working with these objects
and creating new Analysis Results Data objects.")
    (license license:asl2.0)))

(define-public r-cardx
  (package
    (name "r-cardx")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cardx" version))
       (sha256
        (base32 "1qbfa2kbxbc7lnrajj79dgz2nkjf4616ngha1yk9fl6f10qmsk24"))))
    (properties
     '((upstream-name . "cardx")
       (updater-ignored-native-inputs . ("r-mixed"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cards
                             r-cli
                             r-dplyr
                             r-glue
                             r-lifecycle
                             r-rlang
                             r-tidyr))
    (native-inputs (list r-broom
                         r-effectsize
                         r-emmeans
                         r-geepack
                         r-ggsurvfit
                         r-lme4
                         r-parameters
                         r-smd
                         r-survey
                         r-survival
                         r-testthat
                         r-withr))
    (home-page "https://insightsengineering.github.io/cardx/")
    (synopsis "Extra analysis results data utilities")
    (description
     "This package lets you create extra Analysis Results Data (ARD) summary
objects.  The package supplements the simple ARD functions from the
@code{cards} package, exporting functions to put statistical results in the
ARD format.  These objects are used and re-used to construct summary tables,
visualizations, and written reports.")
    (license license:asl2.0)))

(define-public r-castor
  (package
    (name "r-castor")
    (version "1.8.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "castor" version))
              (sha256
               (base32
                "1hq6j8zvv01lbi8q2bcn2jz6xm1iv8lylsw20a9yaagw3xkvbgw2"))))
    (properties `((upstream-name . "castor")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite r-matrix r-naturalsort r-rcpp
                             r-rspectra))
    (home-page "https://cran.r-project.org/package=castor")
    (synopsis "Efficient phylogenetics on large trees")
    (description
     "This tool supports analyses on massive phylogenies comprising up to
millions of tips.  Functions include pruning, rerooting, calculation of
most-recent common ancestors, calculating distances from the tree root and
calculating pairwise distances.  In addition, this tool takes care of
calculation of phylogenetic signal and mean trait depth (trait conservatism),
ancestral state reconstruction and hidden character prediction of discrete
characters, simulating and fitting models of trait evolution, fitting and
simulating diversification models, dating trees, comparing trees, and
reading/writing trees in Newick format.")
    (license license:gpl2+)))

(define-public r-catools
  (package
    (name "r-catools")
    (version "1.18.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "caTools" version))
              (sha256
               (base32
                "1n380hnddj29nrzsqf462a1h3xy55qk4q45i5287ffd2lx13j6z7"))))
    (properties `((upstream-name . "caTools")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bitops))
    (home-page "https://cran.r-project.org/web/packages/caTools")
    (synopsis
     "Various tools including functions for moving window statistics")
    (description
     "This package contains several basic utility functions including:
moving (rolling, running) window statistic functions, read/write for GIF and
ENVI binary files, fast calculation of AUC, LogitBoost classifier, base64
encoder/decoder, round-off-error-free sum and cumsum, etc.")
    (license license:gpl3+)))

(define-public r-cellranger
  (package
    (name "r-cellranger")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cellranger" version))
       (sha256
        (base32
         "16fgi3annn34c3cxi0pxf62mmmmxi21hp0zzlv7bkfsjqy4g4f2x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rematch r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/rsheets/cellranger")
    (synopsis "Translate spreadsheet cell ranges to rows and columns")
    (description
     "This package provides helper functions to work with spreadsheets and the
@code{A1:D10} style of cell range specification.")
    (license license:expat)))

(define-public r-cftime
  (package
    (name "r-cftime")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CFtime" version))
       (sha256
        (base32 "1kb8q2g0685f4gyjn0bjay9zirkxwn8via4bdqdaiyph0qshc8hh"))))
    (properties
     '((upstream-name . "CFtime")
       ;; Avoid dependency cycle.
       (updater-ignored-native-inputs . ("r-ncdfcf"))
       (updater-extra-native-inputs . ("r-stringr"))))
    (build-system r-build-system)
    (propagated-inputs (list r-r6))
    (native-inputs (list r-knitr r-stringr r-testthat))
    (home-page "https://github.com/pvanlaake/CFtime")
    (synopsis "Using CF-compliant calendars with climate projection data")
    (description
     "This package provides support for all calendars as specified in the
@dfn{Climate and Forecast} (CF) Metadata Conventions for climate and
forecasting data.  The CF Metadata Conventions is widely used for distributing
files with climate observations or projections, including the @dfn{Coupled
Model Intercomparison Project} (CMIP) data used by climate change scientists
and the @dfn{Intergovernmental Panel on Climate Change} (IPCC).  This package
specifically allows the user to work with any of the CF-compliant
calendars (many of which are not compliant with POSIXt).  The CF time
coordinate is formally defined in the
@url{https://cfconventions.org/Data/cf-conventions/cf-conventions-1.12/cf-conventions.html#time-coordinate,CF
Metadata Conventions document}.")
    (license license:expat)))

(define-public r-chameleon
  (package
    (name "r-chameleon")
    (version "0.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chameleon" version))
       (sha256
        (base32 "0a3azp0zaakpqqx0pp94hkj3vgb2apnf8gb5ga0as4i8lrn9dz8i"))))
    (properties `((upstream-name . "chameleon")))
    (build-system r-build-system)
    (propagated-inputs (list r-clue r-ggplot2 r-umap))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=chameleon")
    (synopsis "Automatic colors for multi-dimensional data")
    (description
     "This package lets you assign distinct colors to arbitrary
multi-dimensional data, considering its structure.")
    (license license:expat)))

(define-public r-changepoint
  (package
    (name "r-changepoint")
    (version "2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "changepoint" version))
              (sha256
               (base32
                "0bb8pcfwb8vjmg7n7giad1vi1s6ix486lcsb28zvxih7v04v1a0r"))))
    (properties `((upstream-name . "changepoint")))
    (build-system r-build-system)
    (propagated-inputs (list r-zoo))
    (native-inputs (list r-testthat r-vdiffr))
    (home-page "https://github.com/rkillick/changepoint/")
    (synopsis "Methods for changepoint detection")
    (description
     "Changepoint implements various mainstream and specialised changepoint
methods.  These methods are suitable for finding single and multiple
changepoints within data.  Many popular non-parametric and frequentist methods
are included as well.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-checkmate
  (package
    (name "r-checkmate")
    (version "2.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "checkmate" version))
       (sha256
        (base32
         "1qw81bs3lhwr1m6wlbs0l0j669051n60x4ca2821599ddhnp6mbj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/mllg/checkmate")
    (synopsis "Fast and versatile argument checks")
    (description
     "This package provides tests and assertions to perform frequent argument
checks.  A substantial part of the package was written in C to minimize any
worries about execution time overhead.")
    (license license:bsd-3)))

(define-public r-chorddiag
  (package
    (name "r-chorddiag")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mattflor/chorddiag")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1bpy9q861l1hyyiqbx2f7qzp7j7im8bkcfdwgxzk5fm0250p359a"))
       ;; Delete minified JavaScript file
       (snippet
        '(delete-file "inst/htmlwidgets/lib/d3/d3.min.js"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/d3"
               (let ((source (assoc-ref inputs "d3.v4.js"))
                     (target "d3.min.js"))
                 (format #true "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-htmlwidgets r-rcolorbrewer))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("r-knitr" ,r-knitr)
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))))
    (home-page "https://github.com/mattflor/chorddiag")
    (synopsis "Create D3 chord diagram")
    (description
     "This package provides tools to create interactive chords diagrams via
the D3 Javascript library.  Chord diagrams show directed relationships among a
group of entities.  This package is based on
@url{http://bl.ocks.org/mbostock/4062006} with some modifications (fading) and
additions (tooltips, bipartite diagram type).")
    (license license:gpl3+)))

(define-public r-chron
  (package
    (name "r-chron")
    (version "2.3-62")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "chron" version))
              (sha256
               (base32
                "18dyy4fn48d4m7azqbqpazhvy9mwl1k494zl7gxckfrx4ivjrb87"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/chron")
    (synopsis "Chronological R objects which can handle dates and times")
    (description
     "This package provides chronological R objects which can handle dates and
times.")
    (license license:gpl2)))

(define-public r-clubsandwich
  (package
    (name "r-clubsandwich")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clubSandwich" version))
       (sha256
        (base32
         "025njaxmf0pa3lzrxkffj219rs3wyfp59q52h1v6hwbxa48gh7hg"))))
    (properties `((upstream-name . "clubSandwich")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lifecycle r-sandwich))
    (native-inputs
     ;; There are lots of optional test inputs, but these two are enough.
     (list r-knitr r-testthat))
    (home-page "https://github.com/jepusto/clubSandwich")
    (synopsis
     "Cluster-robust (Sandwich) variance estimators with small-sample corrections")
    (description
     "This package provides several cluster-robust variance estimators (i.e.,
sandwich estimators) for ordinary and weighted least squares linear regression
models, including the bias-reduced linearization estimator introduced by Bell
and McCaffrey (2002)
@url{http://www.statcan.gc.ca/pub/12-001-x/2002002/article/9058-eng.pdf} and
developed further by Pustejovsky and Tipton (2017)
@url{doi:10.1080/07350015.2016.1247004}.  The package includes functions for
estimating the variance- covariance matrix and for testing single- and
multiple-contrast hypotheses based on Wald test statistics.  Tests of single
regression coefficients use Satterthwaite or saddle-point corrections.  Tests
of multiple-contrast hypotheses use an approximation to Hotelling's T-squared
distribution.  Methods are provided for a variety of fitted models, including
@code{lm()} and @code{mlm} objects, @code{glm()}, ivreg (from package
@code{AER}), @code{plm()} (from package @code{plm}), @code{gls()} and
@code{lme()} (from @code{nlme}), @code{robu()} (from @code{robumeta}), and
@code{rma.uni()} and @code{rma.mv()} (from @code{metafor}).")
    (license license:gpl3)))

(define-public r-celestial
  (package
    (name "r-celestial")
    (version "1.4.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "celestial" version))
       (sha256
        (base32 "1gls0qvr8mxz79lsmk76v253f747g0cqys8p8wjmpijs8r0pyr4z"))))
    (properties `((upstream-name . "celestial")))
    (build-system r-build-system)
    (propagated-inputs (list r-nistunits r-pracma r-rann))
    (home-page "https://cran.r-project.org/package=celestial")
    (synopsis
     "Collection of common astronomical conversion routines and functions")
    (description
     "This package contains a number of common astronomy conversion routines,
particularly the HMS and degrees schemes, which can be fiddly to convert between
on mass due to the textural nature of the former.  It allows users to coordinate
match datasets quickly.  It also contains functions for various cosmological
calculations.")
    (license license:gpl3)))

(define-public r-censreg
  (package
    (name "r-censreg")
    (version "0.5-38")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "censReg" version))
       (sha256
        (base32 "1rrgvq883970zp311lmkvxxky29w48p54xa4hq7iaa33yq7dbmmb"))))
    (properties `((upstream-name . "censReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-glmmml r-maxlik r-misctools r-plm r-sandwich))
    (native-inputs (list r-aer))
    (home-page "http://www.sampleSelection.org")
    (synopsis "Censored regression (Tobit) models")
    (description
     "This is a package for maximum likelihood estimation of censored
regression (Tobit) models with cross-sectional and panel data.")
    (license license:gpl2+)))

(define-public r-cetcolor
  (package
    (name "r-cetcolor")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cetcolor" version))
       (sha256
        (base32 "0kygdcr9ldanr0z4qpygwh0padki7s2ad0j6myky601g4228z79q"))))
    (properties `((upstream-name . "cetcolor")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/coatless-rpkg/cetcolor")
    (synopsis "CET perceptually uniform color maps")
    (description
     "This package provides a collection of perceptually uniform color maps
made by Peter Kovesi (2015) \"Good Colour Maps: How to Design Them\"
<arXiv:1509.03700> at the Centre for Exploration Targeting (CET).")
    (license license:cc-by-sa4.0)))

;; The package sources include multiple non-minified JavaScript files and the
;; v5.1.0 variant of d3.js.  The d3.js file is not minified.
(define-public r-chromomap
  (package
    (name "r-chromomap")
    (version "4.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "chromoMap" version))
       (sha256
        (base32 "1067h5d6jdbm811n7ayikhqfbcqmxbz5jgp05vf1sbln7qgn9l43"))))
    (properties `((upstream-name . "chromoMap")))
    (build-system r-build-system)
    (propagated-inputs (list r-htmltools r-htmlwidgets))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=chromoMap")
    (synopsis "Interactive genomic visualization of biological data")
    (description
     "This package provides interactive, configurable and graphics
visualization of the chromosome regions of any living organism allowing users
to map chromosome elements (like genes, SNPs etc.) on the chromosome plot.  It
introduces a special plot viz. the \"chromosome heatmap\" that, in addition to
mapping elements, can visualize the data associated with chromosome
elements (like gene expression) in the form of heat colors.  Users can
investigate the detailed information about the mappings (like gene names or
total genes mapped on a location) or can view the magnified single or double
stranded view of the chromosome at a location showing each mapped element in
sequential order.  The package provide multiple features like visualizing
multiple sets, chromosome heat-maps, group annotations, adding hyperlinks, and
labelling.  The plots can be saved as HTML documents that can be customized
and shared easily.  In addition, you can include them in R Markdown or in R
Shiny applications.")
    (license (list license:gpl3
                   license:isc)))) ;for bundled d3js

(define-public r-coda
  (package
    (name "r-coda")
    (version "0.19-4.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "coda" version))
              (sha256
               (base32
                "1mlaf3ffql3phc12vlfss0vqqdj415mxsg84vsdgymmvdzc53d7l"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (home-page "https://cran.r-project.org/web/packages/coda")
    (synopsis "Package for output analysis and diagnostics for MCMC")
    (description "This package provides functions for summarizing and plotting
the output from Markov Chain Monte Carlo (MCMC) simulations, as well as
diagnostic tests of convergence to the equilibrium distribution of the Markov
chain.")
    (license license:gpl2+)))

(define-public r-codetools
  (package
    (name "r-codetools")
    (version "0.2-20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "codetools" version))
       (sha256
        (base32
         "0qx8zrlickl45wzzbydsbx5f1vmzhn71x7amzpfj71qpxisz7riv"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/codetools")
    (synopsis "Code analysis tools for R")
    (description "This package provides code analysis tools for R to check R
code for possible problems.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-colorout
  (package
    (name "r-colorout")
    (version "1.2-2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jalvesaq/colorout")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rsx69wjpa73c6x2hacvvvbzdzxn7wg06gizf97kasjdlb7azmp3"))))
    (build-system r-build-system)
    (home-page "https://github.com/jalvesaq/colorout")
    (synopsis "Colorize output in the R REPL")
    (description "@code{colorout} is an R package that colorizes R output when
running in terminal emulator.

R STDOUT is parsed and numbers, negative numbers, dates in the standard
format, strings, and R constants are identified and wrapped by special ANSI
scape codes that are interpreted by terminal emulators as commands to colorize
the output.  R STDERR is also parsed to identify the expressions warning and
error and their translations to many languages.  If these expressions are
found, the output is colorized accordingly; otherwise, it is colorized as
STDERROR (blue, by default).

You can customize the colors according to your taste, guided by the color
table made by the command @code{show256Colors()}.  You can also set the colors
to any arbitrary string.  In this case, it is up to you to set valid values.")
    (license license:gpl3+)))

(define-public r-colorsgen
  (package
    (name "r-colorsgen")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorsGen" version))
       (sha256
        (base32 "0w4qkl4fw7pjfcd2z3nhpkxh8kv3bbq19bi2cg0ivfr83kxa44fj"))))
    (properties `((upstream-name . "colorsGen")))
    (build-system r-build-system)
    (propagated-inputs (list r-colorspace))
    (home-page "https://github.com/stla/colorsGen")
    (synopsis "Generation of random colors")
    (description
     "This package lets you generate random colors, possibly with a given hue
or a given luminosity.")
    (license license:cc0)))

(define-public r-commonmark
  (package
    (name "r-commonmark")
    (version "1.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "commonmark" version))
       (sha256
        (base32
         "0radgpdvpzhw3615jmjac7vhqnq0j6dfi9avhw4q4zz12vwrdgzs"))))
    (properties
     ;; We can't have r-testthat among the inputs here to avoid a dependency
     ;; cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (arguments (list #:tests? #false))
    (home-page "https://cran.r-project.org/web/packages/commonmark")
    (synopsis "CommonMark and Github Markdown rendering in R")
    (description
     "The CommonMark specification defines a rationalized version of markdown
syntax.  This package uses the @code{cmark} reference implementation for
converting markdown text into various formats including HTML, LaTeX and groff
man.  In addition, it exposes the markdown parse tree in XML format.  The
latest version of this package also adds support for Github extensions
including tables, autolinks and strikethrough text.")
    (license license:bsd-2)))

(define-public r-compquadform
  (package
    (name "r-compquadform")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CompQuadForm" version))
       (sha256
        (base32
         "1i30hrqdk64q17vsn918c3q79brchgx2wzh1gbsgbn0dh1ncabq4"))))
    (properties `((upstream-name . "CompQuadForm")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/CompQuadForm")
    (synopsis "Distribution function of quadratic forms in normal variables")
    (description
     "This package provides functions to compute the distribution function of
quadratic forms in normal variables using Imhof's method, Davies's algorithm,
Farebrother's algorithm or Liu et al.'s algorithm.")
    (license license:gpl2+)))

(define-public r-consort
  (package
    (name "r-consort")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "consort" version))
              (sha256
               (base32
                "12gr1diyy2azy1fbh8z129lkm0ahwvm98j5hqxv93yp089a02l8c"))))
    (properties `((upstream-name . "consort")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/adayim/consort/")
    (synopsis "Create Consort Diagrams")
    (description
     "To make it easy to create CONSORT diagrams for the transparent reporting of
participant allocation in randomized, controlled clinical trials.  This is done
by creating a standardized disposition data, and using this data as the source
for the creation a standard CONSORT diagram.  Human effort by supplying text
labels on the node can also be achieved.")
    (license license:expat)))

(define-public r-collapse
  (package
    (name "r-collapse")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collapse" version))
       (sha256
        (base32 "0qffq6gzh3yslj0zjkvsc7cz5wlczlpm6ag47cjszyjzb4wh2qiq"))))
    (properties `((upstream-name . "collapse")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-bit64
                         r-data-table
                         r-dplyr
                         r-fixest
                         r-kit
                         r-knitr
                         r-magrittr
                         r-matrixstats
                         r-testthat
                         r-withr
                         r-zoo))
    (home-page "https://sebkrantz.github.io/collapse/")
    (synopsis "Advanced and fast data transformation")
    (description
     "This is a C/C++ based package for advanced data transformation and
statistical computing in R that is extremely fast, class-agnostic, robust and
programmer friendly.  Core functionality includes a rich set of S3 generic
grouped and weighted statistical functions for vectors, matrices and data
frames, which provide efficient low-level vectorizations, @code{OpenMP}
multithreading, and skip missing values by default.  These are integrated with
fast grouping and ordering algorithms (also callable from C), and efficient
data manipulation functions.  The package also provides a flexible and
rigorous approach to time series and panel data in R.  It further includes
fast functions for common statistical procedures, detailed (grouped, weighted)
summary statistics, powerful tools to work with nested data, fast data object
conversions, functions for memory efficient R programming, and helpers to
effectively deal with variable labels, attributes, and missing data.")
    (license (list license:gpl2+))))

(define-public r-collections
  (package
    (name "r-collections")
    (version "0.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collections" version))
       (sha256
        (base32 "0dlz7x68gynvc4bk13a05vjzxb0d71km4133qxz912azjw9ik5ql"))))
    (properties `((upstream-name . "collections")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/randy3k/collections")
    (synopsis "High performance container data types")
    (description
     "This package provides high performance container data types such as
queues, stacks, deques, dicts and ordered dicts.")
    (license license:expat)))

(define-public r-correlation
  (package
    (name "r-correlation")
    (version "0.8.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "correlation" version))
              (sha256
               (base32
                "0r0mvhmywzic3dfx49y1z9pbkwm3mwy9k6f04ywidi04sk759za0"))))
    (properties `((upstream-name . "correlation")))
    (build-system r-build-system)
    (propagated-inputs (list r-bayestestr r-datawizard r-insight r-parameters))
    (native-inputs
     ;; The importer/updater adds a lot of optional inputs, that we can
     ;; happily do without.
     (list r-knitr r-testthat))
    (home-page "https://easystats.github.io/correlation/")
    (synopsis "Methods for correlation analysis")
    (description
     "This is a lightweight package for computing different kinds of
correlations.  These correlations include partial correlations, Bayesian
correlations, multilevel correlations, polychoric correlations, biweight
correlations, distance correlations and more.")
    (license license:gpl3)))

(define-public r-cosinor
  (package
    (name "r-cosinor")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cosinor" version))
       (sha256
        (base32 "0nyvzmqk0rhx10fki29hcrz014bv3r40adqd5d6rbcz66kc4sjy3"))))
    (properties `((upstream-name . "cosinor")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-shiny))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/sachsmc/cosinor")
    (synopsis "Tools for estimating and predicting the Cosinor model")
    (description
     "This package provides a set of simple functions that transforms
longitudinal data to estimate the cosinor linear model as described in
Tong (1976).  Methods are given to summarize the mean, amplitude and
acrophase, to predict the mean annual outcome value, and to test the
coefficients.")
    (license license:expat)))

(define-public r-cosinor2
  (package
    (name "r-cosinor2")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cosinor2" version))
       (sha256
        (base32 "1pp0z86fflqkkllfrzx3vj98kzxjwnawr4a2d8z5q6zhq6v5qrvf"))))
    (properties `((upstream-name . "cosinor2")))
    (build-system r-build-system)
    (propagated-inputs (list r-cosinor
                             r-cowplot
                             r-ggplot2
                             r-hmisc
                             r-magrittr
                             r-matrixstats
                             r-purrr
                             r-scales
                             r-stringr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/amutak/cosinor2")
    (synopsis "Extended tools for Cosinor analysis of rhythms")
    (description
     "This package provides statistical procedures for calculating
population-mean cosinor, non-stationary cosinor, estimation of best-fitting
period, tests of population rhythm differences and more.")
    (license license:gpl3)))

(define-public r-countrycode
  (package
    (name "r-countrycode")
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "countrycode" version))
       (sha256
        (base32 "051j7va5qv46qf9543nscinxibk2mz3sxgbfpniwi9qyjh3878s5"))))
    (properties `((upstream-name . "countrycode")))
    (build-system r-build-system)
    (native-inputs (list r-testthat r-tibble r-utf8))
    (home-page "https://vincentarelbundock.github.io/countrycode/")
    (synopsis "Convert country names and country codes")
    (description
     "This package lets you standardize country names, convert them into one
of 40 different coding schemes, convert between coding schemes, and assign
region descriptors.")
    (license license:gpl3)))

(define-public r-cowplot
  (package
    (name "r-cowplot")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cowplot" version))
       (sha256
        (base32
         "0wxjynpbamyimpms7psbac7xgwswzlidczpc037q20y5yld9fml7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gtable r-rlang r-scales))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/wilkelab/cowplot")
    (synopsis "Streamlined plot theme and plot annotations for ggplot2")
    (description
     "This package provides some helpful extensions and modifications to the
ggplot2 package to combine multiple ggplot2 plots into one and label them with
letters, as is often required for scientific publications.")
    (license license:gpl2)))

(define-public r-cplm
  (package
    (name "r-cplm")
    (version "0.7-12.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cplm" version))
       (sha256
        (base32 "0z99fnmadjpx7d41p575dypy3pgsxxzani9npyishv5719hw35cf"))))
    (properties `((upstream-name . "cplm")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; GET_SLOT is only found in Rdefines.h
         (add-after 'unpack 'compatibility
           (lambda _
             (substitute* "src/common.h"
               (("#include <Rinternals.h>" m)
                (string-append m "\n#include <Rdefines.h>"))))))))
    (propagated-inputs
     (list r-biglm
           r-coda
           r-ggplot2
           r-matrix
           r-minqa
           r-nlme
           r-reshape2
           r-statmod
           r-tweedie))
    (home-page "https://github.com/actuaryzhang/cplm")
    (synopsis "Compound Poisson linear models")
    (description "The Tweedie compound Poisson distribution is a mixture of a
degenerate distribution at the origin and a continuous distribution on the
positive real line.  It has been applied in a wide range of fields in which
continuous data with exact zeros regularly arise.  The cplm package provides
likelihood based and Bayesian procedures for fitting common Tweedie compound
Poisson linear models.  In particular, models with hierarchical structures or
extra zero inflation can be handled.  Further, the package implements the Gini
index based on an ordered version of the Lorenz curve as a robust model
comparison tool involving zero-inflated and highly skewed distributions.")
    (license license:gpl2+)))

(define-public r-crayon
  (package
    (name "r-crayon")
    (version "1.5.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "crayon" version))
              (sha256
               (base32
                "0sfsx4k77fsx1dx9c186dg273psrr3awz4ivfvmbbvs1amla0x1y"))))
    (properties
     ;; We can't have r-testthat among the inputs here to avoid a dependency
     ;; cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests need r-testthat, which would lead to a dependency cycle.
    ;; r-crayon@1.5.3 -> r-diffobj@0.3.5 -> r-waldo@0.6.1 -> r-testthat@3.2.1.1
    (arguments (list #:tests? #false))
    (home-page "https://github.com/gaborcsardi/crayon")
    (synopsis "Colored terminal output for R")
    (description
     "Colored terminal output on terminals that support ANSI color and
highlight codes.  It also works in Emacs ESS.  ANSI color support is
automatically detected.  Colors and highlighting can be combined and nested.
New styles can also be created easily.  This package was inspired by the
\"chalk\" JavaScript project.")
    (license license:expat)))

(define-public r-crew
  (package
    (name "r-crew")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "crew" version))
       (sha256
        (base32 "03ygyvwh418mp0vx98vdavyr6xdwi9qcb7pyj56xxba06cymdgch"))))
    (properties `((upstream-name . "crew")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; Some tests use "ip_internal", which fails in the build
             ;; container.
             (delete-file "tests/testthat/test-crew_controller_sequential.R"))))))
    (propagated-inputs (list r-cli
                             r-data-table
                             r-getip
                             r-later
                             r-mirai
                             r-nanonext
                             r-processx
                             r-promises
                             r-ps
                             r-r6
                             r-rlang
                             r-tibble
                             r-tidyselect))
    (native-inputs (list r-autometric r-dplyr r-knitr r-testthat))
    (home-page "https://wlandau.github.io/crew/")
    (synopsis "Distributed worker launcher framework")
    (description
     "In computationally demanding analysis projects, statisticians and data
scientists asynchronously deploy long-running tasks to distributed systems,
ranging from traditional clusters to cloud services.  The NNG-powered mirai R
package by Gao (2023) <doi:10.5281/zenodo.7912722> is a scheduler that
efficiently processes these intense workloads.  The crew package extends mirai
with a unifying interface for third-party worker launchers.")
    (license license:expat)))

(define-public r-cubelyr
  (package
    (name "r-cubelyr")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cubelyr" version))
       (sha256
        (base32 "154vwf5pj2jh66wqdh78nc0v722b4rh88hss24g5lc31wlghzc8q"))))
    (properties `((upstream-name . "cubelyr")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-glue
                             r-pillar
                             r-purrr
                             r-rlang
                             r-tibble
                             r-tidyselect))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/cubelyr")
    (synopsis "Data cube dplyr backend")
    (description
     "This package provides an implementation of a data cube extracted out of
dplyr for backward compatibility.")
    (license license:expat)))

(define-public r-cubist
  (package
    (name "r-cubist")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Cubist" version))
       (sha256
        (base32 "0m3jwhpa6kmaiqknms49rh0mjsrmh1cimy06gfdyjx5kcv1an4kw"))))
    (properties `((upstream-name . "Cubist")))
    (build-system r-build-system)
    (propagated-inputs (list r-lattice r-reshape2))
    (native-inputs (list r-knitr r-modeldata r-testthat))
    (home-page "https://topepo.github.io/Cubist/")
    (synopsis "Rule- and instance-based regression modeling")
    (description
     "This is package for regression modeling using rules with added
instance-based corrections.")
    (license license:gpl3)))

(define-public r-curry
  (package
    (name "r-curry")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "curry" version))
       (sha256
        (base32
         "1ps9hvbnb02m0b8hlw4admwbziyjvswj08ldi2dk3ymnrpawcc29"))))
    (properties `((upstream-name . "curry")))
    (build-system r-build-system)
    (home-page "https://github.com/thomasp85/curry")
    (synopsis "Partial function application")
    (description
     "Partial application is the process of reducing the arity of a function
by fixing one or more arguments, thus creating a new function lacking the
fixed arguments.  The @code{curry} package provides three different ways of
performing partial function application by fixing arguments from either end of
the argument list (currying and tail currying) or by fixing multiple named
arguments (partial application).  This package provides this functionality
through the @code{%<%}, @code{%-<%}, and @code{%><%} operators which allows
for a programming style comparable to modern functional languages.  Compared
to other implementations such a @code{purrr::partial()} the operators in
@code{curry} composes functions with named arguments, aiding in autocomplete
etc.")
    (license license:gpl2+)))

(define-public r-cutpointr
  (package
    (name "r-cutpointr")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cutpointr" version))
       (sha256
        (base32 "14zvdq5p1hhd6y0xzf761q2kh217rra25ihl17jipakf61zbf88m"))))
    (properties `((upstream-name . "cutpointr")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; This requires the fANCOVA package
             (substitute* "tests/testthat/test-cutpointr.R"
               ((".*LOESS smoothing does not return warnings or errors.*" m)
                (string-append m "skip('skip');\n"))))))))
    (propagated-inputs (list r-dplyr
                             r-foreach
                             r-ggplot2
                             r-gridextra
                             r-purrr
                             r-rcpp
                             r-rlang
                             r-tibble
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-knitr r-rocr r-testthat))
    (home-page "https://github.com/thie1e/cutpointr")
    (synopsis "Determine optimal cutpoints for binary classification")
    (description
     "This package estimates optimal cutpoints for binary classification metrics.
It also validates performance using bootstrapping.  Some methods for more
robust cutpoint estimation are supported, e.g. a parametric method assuming
normal distributions, bootstrapped cutpoints, and smoothing of the metric
values per cutpoint using Generalized Additive Models.  Various plotting
functions are included.")
    (license license:gpl3)))

(define-public r-datapasta
  (package
    (name "r-datapasta")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "datapasta" version))
       (sha256
        (base32 "0sqv29iv2rv50rbw1601rn8p7gv7rsw00djhl7h1znr0igzi5b82"))))
    (properties `((upstream-name . "datapasta")))
    (build-system r-build-system)
    (propagated-inputs (list r-clipr r-readr r-rstudioapi))
    (native-inputs (list r-data-table r-knitr r-testthat r-tibble))
    (home-page "https://github.com/milesmcbain/datapasta")
    (synopsis "R tools for data copy-pasta")
    (description
     "This package provides RStudio addins and R functions that make
copy-pasting vectors and tables to text painless.")
    (license license:expat)))

(define-public r-datasaurus
  (package
    (name "r-datasaurus")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "datasauRus" version))
       (sha256
        (base32
         "0lkf32py342nswm8k4x1hf9j5pnbx2xipzfaj54z6d58a2nlgii1"))))
    (properties `((upstream-name . "datasauRus")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/lockedata/datasauRus")
    (synopsis "Datasets from the Datasaurus Dozen")
    (description
     "The Datasaurus Dozen is a set of datasets with the same summary
statistics.  They retain the same summary statistics despite having radically
different distributions.  The datasets represent a larger and quirkier object
lesson that is typically taught via Anscombe's Quartet (available in the
'datasets' package).  Anscombe's Quartet contains four very different
distributions with the same summary statistics and as such highlights the
value of visualisation in understanding data, over and above summary
statistics.  As well as being an engaging variant on the Quartet, the data is
generated in a novel way.  The simulated annealing process used to derive
datasets from the original Datasaurus is detailed in \"Same Stats, Different
Graphs: Generating Datasets with Varied Appearance and Identical Statistics
through Simulated Annealing\" @url{doi:10.1145/3025453.3025912}.")
    (license license:expat)))

(define-public r-data-table
  (package
    (name "r-data-table")
    (version "1.17.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "data.table" version))
              (sha256
               (base32
                "0lq774b5nyjc5k30mbg6834wzwihx72cc35nf0032jc2wfhb4vir"))))
    (properties
     `((upstream-name . "data.table")
       (updater-extra-native-inputs . ("r-r-utils" "tzdata-for-tests"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; These two phases are needed for 3 otherwise failing tests
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp")))
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC+1")
             (setenv "TZDIR"
                     (search-input-directory inputs "share/zoneinfo")))))))
    (inputs
     (list zlib))
    (native-inputs
     (list pkg-config r-knitr r-r-utils tzdata-for-tests))
    (home-page "https://github.com/Rdatatable/data.table/wiki")
    (synopsis "Enhanced version of data.frame R object")
    (description
     "The R package @code{data.table} is an extension of @code{data.frame}
providing functions for fast aggregation of large data (e.g. 100GB in RAM),
fast ordered joins, fast add/modify/delete of columns by group, column listing
and fast file reading.")
    (license license:gpl3+)))

(define-public r-datawizard
  (package
    (name "r-datawizard")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "datawizard" version))
       (sha256
        (base32
         "1zwl59852fi89nn696a1awf84qxcn1zjmmkcfp3rzpl0zm8mszg3"))))
    (properties
     `((upstream-name . "datawizard")
       (updater-ignored-native-inputs
        ;; Avoid dependency cycles
        . ("r-bayestestr" "r-effectsize" "r-parameters"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; Fails with "NA in coercion to boolean"
             (substitute* "tests/testthat/test-data_rename.R"
               ((".*data_rename: multiple selection types.*" m)
                (string-append m "skip('skip');\n"))))))))
    (propagated-inputs
     (list r-insight))
    (native-inputs
     (list r-brms
           r-dplyr
           r-ggplot2
           r-haven
           r-httr
           r-knitr
           r-mediation
           r-poorman
           r-psych
           r-testthat
           r-tibble
           r-tidyr
           r-withr))
    (home-page "https://easystats.github.io/datawizard/")
    (synopsis "Easy data wrangling")
    (description
     "This package provides a lightweight package to easily manipulate,
clean, transform, and prepare your data for analysis.  It also forms the data
wrangling backend for the packages in the @code{easystats} ecosystem.")
    (license license:gpl3)))

(define-public r-dbi
  (package
    (name "r-dbi")
    (version "1.2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "DBI" version))
              (sha256
               (base32
                "1gid1mfzq1j3n5fsnpzdb50p2m73z92s6njp0sgr503aaskhhryg"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/rstats-db/DBI")
    (synopsis "R database interface")
    (description
     "The DBI package provides a database interface (DBI) definition for
communication between R and relational database management systems.  All
classes in this package are virtual and need to be extended by the various
R/DBMS implementations.")
    (license license:lgpl2.0+)))

(define-public r-dbitest
  (package
    (name "r-dbitest")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DBItest" version))
       (sha256
        (base32 "1zm3y5fsmsyz4bi3fqvl3zp13jjbi029i21xi4l81h7wxrc8p5y5"))))
    (properties
     `((upstream-name . "DBItest")
       ;; Avoid dependency cycle.
       (updater-ignored-native-inputs . ("r-rsqlite"))))
    (build-system r-build-system)
    (propagated-inputs (list r-blob
                             r-callr
                             r-dbi
                             r-desc
                             r-hms
                             r-lubridate
                             r-magrittr
                             r-nanoarrow
                             r-palmerpenguins
                             r-rlang
                             r-testthat
                             r-withr))
    (native-inputs (list r-knitr r-lintr))
    (home-page "https://dbitest.r-dbi.org")
    (synopsis "Testing DBI backends")
    (description
     "This package provides a helper that tests DBI back ends for conformity
to the interface.")
    (license license:lgpl2.1+)))

(define-public r-dbplyr
  (package
    (name "r-dbplyr")
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dbplyr" version))
       (sha256
        (base32
         "1zxw4ignzm2fzixsf6n80f44b9q7434vamy2xj4v31wlx3dmnixv"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for one failing test.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC+1")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-blob
           r-cli
           r-dbi
           r-dplyr
           r-glue
           r-lifecycle
           r-magrittr
           r-pillar
           r-purrr
           r-r6
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr r-rsqlite r-testthat tzdata-for-tests))
    (home-page "https://github.com/tidyverse/dbplyr")
    (synopsis "Dplyr back end for databases")
    (description
     "This package provides a dplyr back end for databases that allows you to
work with remote database tables as if they are in-memory data frames.  Basic
features works with any database that has a @code{DBI} back end; more advanced
features require SQL translation to be provided by the package author.")
    (license license:expat)))

(define-public r-dbscan
  (package
    (name "r-dbscan")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dbscan" version))
       (sha256
        (base32 "0hz31yp2p4zx82qzv4q4s2iiivqq3alqjdfvrgl9n7aj4b8vsfhc"))))
    (properties `((upstream-name . "dbscan")))
    (build-system r-build-system)
    (propagated-inputs (list r-generics r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mhahsler/dbscan")
    (synopsis "Density-based spatial clustering of applications with noise")
    (description
     "This package provides a fast reimplementation of several density-based
algorithms of the DBSCAN family.  It includes the clustering algorithms DBSCAN
(density-based spatial clustering of applications with noise) and
@dfn{hierarchical DBSCAN} (HDBSCAN), the ordering algorithm @dfn{ordering
points to identify the clustering structure} (OPTICS), shared nearest neighbor
clustering, and the outlier detection algorithms @dfn{local outlier
factor} (LOF) and @dfn{global-local outlier score from hierarchies} (GLOSH).
The implementations use the kd-tree data structure for faster k-nearest
neighbor search.  An R interface to fast kNN and fixed-radius NN search is
also provided.")
    (license license:gpl2+)))

(define-public r-deoptimr
  (package
    (name "r-deoptimr")
    (version "1.1-3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DEoptimR" version))
       (sha256
        (base32
         "18kjq2gcqnicmbdpg5pkzsa4wvy20fprqdkh115k34l6pm176ssq"))))
    (properties `((upstream-name . "DEoptimR")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/DEoptimR")
    (synopsis "Differential evolution optimization in pure R")
    (description
     "This package provides a @dfn{differential evolution} (DE) stochastic
algorithms for global optimization of problems with and without constraints.
The aim is to curate a collection of its state-of-the-art variants that

@enumerate
@item do not sacrifice simplicity of design,
@item are essentially tuning-free, and
@item can be efficiently implemented directly in the R language.
@end enumerate")
    (license license:gpl2+)))

(define-public r-desc
  (package
    (name "r-desc")
    (version "1.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "desc" version))
       (sha256
        (base32
         "09ig14bm68cps6d1mrmj6hhjr01i6gz1ri35qpkwk3yp7nkqsijl"))))
    (properties
     ;; We can't have r-testthat among the inputs here to avoid a dependency
     ;; cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli r-r6))
    (home-page "https://github.com/r-pkgs/desc")
    (synopsis "Manipulate DESCRIPTION Files")
    (description
     "This package provides tools to read, write, create, and manipulate
DESCRIPTION files.  It is intended for packages that create or manipulate
other packages.")
    (license license:expat)))

(define-public r-desctools
  (package
    (name "r-desctools")
    (version "0.99.60")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DescTools" version))
       (sha256
        (base32 "1g5wffssvbsqkzh6r5fcing2vxk0lx3dbmls0vhphqnwkmbxh81c"))))
    (properties `((upstream-name . "DescTools")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'pre-check
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-boot
           r-cli
           r-data-table
           r-exact
           r-expm
           r-fs
           r-gld
           r-haven
           r-httr
           r-mass
           r-mvtnorm
           r-rcpp
           r-readr
           r-readxl
           r-rstudioapi
           r-withr))
    (native-inputs (list gfortran r-r-rsp))
    (home-page "https://andrisignorell.github.io/DescTools/")
    (synopsis "Tools for descriptive statistics")
    (description
     "This package provides a collection of miscellaneous basic statistic
functions and convenience wrappers for efficiently describing data.
The author's intention was to create a toolbox, which facilitates the
(notoriously time consuming) first descriptive tasks in data analysis,
consisting of calculating descriptive statistics, drawing graphical summaries
and reporting the results.  The package contains furthermore functions to
produce documents using MS Word (or PowerPoint) and functions to import data
from Excel.  Many of the included functions can be found scattered in other
packages and other sources written partly by Titans of R.  The reason for
collecting them here, was primarily to have them consolidated in ONE instead
of dozens of packages (which themselves might depend on other packages which
are not needed at all), and to provide a common and consistent interface as
far as function and arguments naming, NA handling, recycling rules etc.  are
concerned.  Google style guides were used as naming rules (in absence of
convincing alternatives).  The BigCamelCase style was consequently applied to
functions borrowed from contributed R packages as well.")
    (license license:gpl2+)))

(define-public r-devtools
  (package
    (name "r-devtools")
    (version "2.4.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "devtools" version))
              (sha256
               (base32
                "0jwh14clyj5flygpmifk01avs7mbnj2s1686pxzfrkcshfyhw5iq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-desc
           r-ellipsis
           r-fs
           r-lifecycle
           r-memoise
           r-miniui
           r-pkgbuild
           r-pkgdown
           r-pkgload
           r-profvis
           r-rcmdcheck
           r-remotes
           r-rlang
           r-roxygen2
           r-rversions
           r-sessioninfo
           r-testthat
           r-urlchecker
           r-usethis
           r-withr))
    (native-inputs
     (list r-knitr r-mockery r-testthat))
    (home-page "https://github.com/hadley/devtools")
    (synopsis "Tools to make developing R packages easier")
    (description "The devtools package is a collection of package development
tools to simplify the devolpment of R packages.")
    (license license:gpl2+)))

(define-public r-dfidx
  (package
    (name "r-dfidx")
    (version "0.1-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dfidx" version))
       (sha256
        (base32 "0ygbw1z0v2s2w7d45b09x54xycfglpd1ipgkgxq8w2q004rkdp9d"))))
    (properties `((upstream-name . "dfidx")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-formula
                             r-glue
                             r-pillar
                             r-rdpack
                             r-tidyselect
                             r-vctrs))
    (native-inputs (list r-quarto))
    (home-page "https://cran.r-project.org/package=dfidx")
    (synopsis "Indexed data frames")
    (description
     "This package provides extended data frames, with a special data frame
column which contains two indexes, with potentially a nesting structure.")
    (license license:gpl2+)))

(define-public r-dharma
  (package
    (name "r-dharma")
    (version "0.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DHARMa" version))
       (sha256
        (base32 "0mfywr4pshnd13xs2zdhd8xvbc43qxaj075jhy8lrlg1agmc6gya"))))
    (properties `((upstream-name . "DHARMa")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape
                             r-gap
                             r-lme4
                             r-lmtest
                             r-matrix
                             r-qgam))
    (native-inputs (list r-devtools
                         r-glmmadaptive
                         r-glmmtmb
                         r-knitr
                         r-mass
                         r-mgcv
                         r-phylolm
                         r-rhub
                         r-spamm
                         r-testthat))
    (home-page "https://florianhartig.github.io/DHARMa/")
    (synopsis "Residual diagnostics for hierarchical regression models")
    (description
     "The DHARMa package uses a simulation-based approach to create readily
interpretable scaled (quantile) residuals for fitted (generalized) linear
mixed models.  Moreover, externally created simulations, e.g. posterior
predictive simulations from Bayesian software such as JAGS, STAN, or BUGS can
be processed as well.  The resulting residuals are standardized to values
between 0 and 1 and can be interpreted as intuitively as residuals from a
linear regression.  The package also provides a number of plot and test
functions for typical model misspecification problems, such as
over/underdispersion, zero-inflation, and residual spatial, phylogenetic and
temporal autocorrelation.")
    (license license:gpl3+)))

(define-public r-dichromat
  (package
    (name "r-dichromat")
    (version "2.0-0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dichromat" version))
       (sha256
        (base32 "10b0avdar3d1y8x2ya3x5kqxqg0z0mq872hdzvc1nn4amplph1d1"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/dichromat")
    (synopsis "Color schemes for dichromats")
    (description
     "Dichromat collapses red-green or green-blue distinctions to simulate the
effects of different types of color-blindness.")
    (license license:gpl2+)))

(define-public r-diffobj
  (package
    (name "r-diffobj")
    (version "0.3.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "diffobj" version))
       (sha256
        (base32
         "11qjwm58lf9r3qy33z89jy801dlss1r2i8wvygkrrcbpf71xj5mk"))))
    (properties `((upstream-name . "diffobj")))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/brodieG/diffobj")
    (synopsis "Diffs for R objects")
    (description
     "Generate a colorized diff of two R objects for an intuitive
visualization of their differences.")
    (license license:gpl2+)))

(define-public r-digest
  (package
    (name "r-digest")
    (version "0.6.37")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "digest" version))
       (sha256
        (base32 "0883iyjbd50f0gwz6hgdmcsrk0i0fkjaix9hz6d4m2jbk54x3i42"))))
    (build-system r-build-system)
    ;; Vignettes require r-knitr, which requires r-digest, so we have to
    ;; disable them and the tests.
    (arguments
     `(#:tests? #f
       #:configure-flags (list "--no-build-vignettes")))
    (native-inputs (list r-simplermarkdown))
    (home-page "https://dirk.eddelbuettel.com/code/digest.html")
    (synopsis "Create cryptographic hash digests of R objects")
    (description
     "This package contains an implementation of a function @code{digest()} for
the creation of hash digests of arbitrary R objects (using the md5, sha-1,
sha-256, crc32, xxhash and murmurhash algorithms) permitting easy comparison
of R language objects, as well as a function @code{hmac()} to create hash-based
message authentication code.

Please note that this package is not meant to be deployed for cryptographic
purposes for which more comprehensive (and widely tested) libraries such as
OpenSSL should be used.")
    (license license:gpl2+)))

(define-public r-dint
  (package
    (name "r-dint")
    (version "2.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dint" version))
       (sha256
        (base32 "0qfvxzix6k24xnjxh9nhz9dq3qfwl14mnd7rp03l8yvh6frws8fh"))))
    (properties `((upstream-name . "dint")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/s-fleck/dint")
    (synopsis "Toolkit for year-quarter, year-month and year-isoweek dates")
    (description
     "This package provides S3 classes and methods to create and work with
year-quarter, year-month and year-isoweek vectors.  Basic arithmetic
operations (such as adding and subtracting) are supported, as well as
formatting and converting to and from standard R date types.")
    (license license:expat)))

(define-public r-diptest
  (package
    (name "r-diptest")
    (version "0.77-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "diptest" version))
       (sha256
        (base32
         "04r8c6xy5vympxaxmgnjib4pqh97f9k6b43i66qhzkl3yh0awki2"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/diptest")
    (synopsis "Hartigan's dip test statistic for unimodality")
    (description
     "This package computes Hartigan's dip test statistic for unimodality,
multimodality and provides a test with simulation based p-values, where the
original public code has been corrected.")
    (license license:gpl2+)))

(define-public r-dirichletreg
  (package
    (name "r-dirichletreg")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DirichletReg" version))
       (sha256
        (base32 "1ql5mwb7zb06y9j6inrlngq7c15as4j17wd8kc71fxs0a2jdj7xi"))))
    (properties `((upstream-name . "DirichletReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-maxlik))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=DirichletReg")
    (synopsis "Dirichlet regression")
    (description "This package implements Dirichlet regression models.")
    (license license:gpl2+)))

(define-public r-dirmult
  (package
    (name "r-dirmult")
    (version "0.1.3-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "dirmult" version))
              (sha256
               (base32
                "05whzhl81nyag7321hw98xa63r440s9bgj1764346yvm9bvzjqi4"))))
    (properties `((upstream-name . "dirmult")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=dirmult")
    (synopsis "Estimation in Dirichlet-Multinomial distribution")
    (description
     "This package estimates the parameters in Dirichlet-Multinomial and
computes log-likelihoods.")
    (license license:gpl2+)))

(define-public r-dixontest
  (package
    (name "r-dixontest")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dixonTest" version))
       (sha256
        (base32 "0gz39s1z987bg56vwrpcs14wzyf7p07s7l7z9napz0i38564wsdq"))))
    (properties `((upstream-name . "dixonTest")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=dixonTest")
    (synopsis "Dixon's ratio test for outlier detection")
    (description
     "For outlier detection in small and normally distributed samples the ratio
test of Dixon (Q-test) can be used.  Density, distribution function, quantile
function and random generation for Dixon's ratio statistics are provided as
wrapper functions.  The core applies McBane's Fortran functions that use
Gaussian quadrature for a numerical solution.")
    (license license:gpl3)))

(define-public r-dmwr2
  (package
    (name "r-dmwr2")
    (version "0.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "DMwR2" version))
              (sha256
               (base32
                "1vzfbz2k05j8r2hpig3d2grb99rnnh2s1sviii3prcyqicxfh0i9"))))
    (properties `((upstream-name . "DMwR2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-dbi
           r-dplyr
           r-quantmod
           r-readr
           r-rpart
           r-xts
           r-zoo))
    (home-page "https://github.com/ltorgo/DMwR2")
    (synopsis
     "Functions and data for the second edition of \"Data Mining with R\"")
    (description
     "This package provides functions and data accompanying the second
edition of the book \"Data Mining with R, learning with case studies\"
by Luis Torgo, published by CRC Press.")
    (license license:gpl2+)))

(define-public r-domc
  (package
    (name "r-domc")
    (version "1.3.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doMC" version))
       (sha256
        (base32
         "18qrcvqwm4cclvk8spvyi281y8prwzivj52xmzk1l9a82j2ny65j"))))
    (properties `((upstream-name . "doMC")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators))
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/doMC")
    (synopsis "Foreach parallel adaptor for the 'parallel' package")
    (description
     "This package provides a parallel backend for the @code{%dopar%} function
using the multicore functionality of the parallel package.")
    (license license:gpl2+)))

(define-public r-doparallel
  (package
    (name "r-doparallel")
    (version "1.0.17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doParallel" version))
       (sha256
        (base32
         "1mxbg2qqda1775vb4s26gz27p5n91lljgjmlqxq4sras22njasmr"))))
    (properties `((upstream-name . "doParallel")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators))
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/doParallel")
    (synopsis "Foreach parallel adaptor for the 'parallel' package")
    (description
     "This package provides a parallel backend for the @code{%dopar%} function
using the parallel package.")
    (license license:gpl2+)))

(define-public r-dplyr
  (package
    (name "r-dplyr")
    (version "1.1.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "dplyr" version))
              (sha256
               (base32
                "1jsq8pj12bngy66xms486j8a65wxvyqs944q9rxkiaylsla08wyg"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-failing-tests
           (lambda _
             ;; 2 tests fail because of unexpected but harmless warnings.
             (delete-file "tests/testthat/test-rows.R"))))))
    (propagated-inputs
     (list r-cli
           r-generics
           r-glue
           r-lifecycle
           r-magrittr
           r-pillar
           r-r6
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/hadley/dplyr")
    (synopsis "Tools for working with data frames in R")
    (description
     "dplyr is the next iteration of plyr.  It is focused on tools for working
with data frames.  It has three main goals: 1) identify the most important
data manipulation tools needed for data analysis and make them easy to use in
R; 2) provide fast performance for in-memory data by writing key pieces of
code in C++; 3) use the same code interface to work with data no matter where
it is stored, whether in a data frame, a data table or database.")
    (license license:expat)))

(define-public r-dt
  (let* ((extension-origin
          (lambda (name version hash)
            (origin
              (method git-fetch)
              (uri (git-reference
                    (url
                     (format #false "https://github.com/DataTables/~a" name))
                    (commit version)))
              (file-name
               (format #false "datatables-~a-~a-checkout" name version))
              (sha256
               (base32 hash)))))
         (extensions
          '(((name . "AutoFill")
             (version . "2.6.0")
             (hash . "0dmhp7vcg9l2qwcvn8w605n9yz38b3k9j907j4i495577mk6cqb0"))
            ((name . "Buttons")
             (version . "2.4.2")
             (hash . "0zr7k5ginsfrg0nxayyd68z410ymxa6qs5n7zqjbzaydf5na2rk3"))
            ((name . "ColReorder")
             (version . "1.7.0")
             (hash . "1z152xhncmr7612wxn6p94m8330d31kdrial86zr2bj77ix571pl"))
            ((name . "DateTime")
             (version . "1.5.1")
             (hash . "11wj2pbisymp148jwg2r05ppa6c2swpip6k04q8f324ma4wy83c5"))
            ((name . "FixedHeader")
             (version . "3.4.0")
             (hash . "0vfgxmg11mbvzvi25c88a611nz53qi88j5jnmpwjag584b90a6bj"))
            ((name . "KeyTable")
             (version . "2.10.0")
             (hash . "18a0pz76532lyn9xsa079ibbfb8rrd2wbv4c8pk9npxc6j1ml0j1"))
            ((name . "Responsive")
             (version . "2.5.0")
             (hash . "04njvyab7hv61nrxs8g7nyxnxjljhnd22kmhahhdz34xf54ydy01"))
            ((name . "RowGroup")
             (version . "1.4.0")
             (hash . "0anvrw096k3pj1k7gkvyhpgchh3jzk2r6j48ywfssgqh38x41byr"))
            ((name . "RowReorder")
             (version . "1.4.1")
             (hash . "0zg7vz19hapgfivjc98fliz59zfwidx9fg42rj5zkamdn18gm8sm"))
            ((name . "Scroller")
             (version . "2.2.0")
             (hash . "1wzla8710986kax63a3r48a5j5ddkbn9fd36pdy778xb9qp766iq"))
            ((name . "Select")
             (version . "1.7.0")
             (hash . "1rb6ik3cd5zijlm95d0fl93bvan6j3bdbj83lrdzhb419qs3v3bf"))))
         (ts-extensions
          '(((name . "FixedColumns")
             (version . "4.3.0")
             (hash . "0z31qw3nz1arccg1zwkdnla98mws7c49gsyncv61c3ghh5b0qlcg"))
            ((name . "SearchBuilder")
             (version . "1.6.0")
             (hash . "10df2jrc3z2v44alwl45cp1qr96b49ai8x7kspqn6ha816lwjqrv"))
            ((name . "SearchPanes")
             (version . "2.2.0")
             (hash . "0pkcxyy357zd722bz1jnbn0dmccpwfpy6qca5cpyl97mdmmprpi9"))
            ((name . "StateRestore")
             (version . "1.3.0")
             (hash . "0zj7idfyj02hynd02w2gjrnp0m8krhzrkwn5fjadfs7gq4i21ial"))))
         (javascript-sources
          `(("https://cdn.datatables.net/1.13.6/js/jquery.dataTables.js"
             "15yjj5s1nkf9f1llmjbjgbw380gl1v35psab4qd7l18gvrspaf5k"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap.js"
             "064a4vm2wd2qhf1szkppvh80fzqpyrm0xjzfcqrg1x9mr8xfs06p"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.js"
             "0w2s6zs7bwlxdzc2z67pj49naqs2kh7xgmxmh1a4d42x3fpxacgy"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.js"
             "1c1bnaq35w37iq214gq8rsd4rx0wp1c46054w9h21vqpf2xiy79i"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.bulma.js"
             "0d7ylp4qgkzkrfc5y7p0nzxxxqibynz8ijsrkvc65jbcbccxglsd"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.foundation.js"
             "0s6r8pc7rdic4qifwc0x3q9i737930wfqh27yycksrbv7i96w2s7"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.jqueryui.js"
             "09cwapax46yf2qz9w50wq9yqzysgfqfnmm9s2ixlafzhzdlx5nw5"
             "datatables")
            ("https://cdn.datatables.net/1.13.6/js/dataTables.semanticui.js"
             "09q31xdgnyc0fsi81qg6a2rfivgncm7jk7x2idm7b1pip8d58j74"
             "datatables")
            ("https://cdnjs.cloudflare.com/ajax/libs/jszip/3.10.1/jszip.js"
             "01l5lw49jz2qn6k9i63dk4llar4lvvpd6xp6i45mpwfk49fbxqg2"
             "datatables-extensions/Buttons"))))
    (package
      (name "r-dt")
      (version "0.33")
      (source (origin
                (method url-fetch)
                (uri (cran-uri "DT" version))
                (sha256
                 (base32
                  "1f17gdqjk1aj7vwjvv3363k8lnsvc6ssh4s3gy1prnz33kdxlig1"))
                (modules '((guix build utils)
                           (ice-9 match)))
                (snippet
                 `(with-directory-excursion "inst/htmlwidgets/lib"
                    (for-each (match-lambda
                                ((url hash dir)
                                 (let ((file (string-append dir "/js/" (basename url ".js") ".min.js")))
                                   (delete-file file))))
                              ',javascript-sources)
                    ;; Preserve pdfmake.js and vfs_fonts.js
                    (copy-file "datatables-extensions/Buttons/js/pdfmake.js"
                               "/tmp/pdfmake.js")
                    (copy-file "datatables-extensions/Buttons/js/vfs_fonts.js"
                               "/tmp/vfs_fonts.js")
                    (for-each (lambda (extension)
                                (let ((name (assoc-ref extension 'name)))
                                  (delete-file-recursively
                                   (string-append "datatables-extensions/" name "/js"))))
                              (append ',extensions ',ts-extensions))
                    (mkdir-p "datatables-extensions/Buttons/js/")
                    (copy-file "/tmp/pdfmake.js"
                               "datatables-extensions/Buttons/js/pdfmake.js")
                    (copy-file "/tmp/vfs_fonts.js"
                               "datatables-extensions/Buttons/js/vfs_fonts.js")
                    (delete-file "nouislider/jquery.nouislider.min.js")
                    (delete-file "selectize/selectize.min.js")
                    (with-directory-excursion "datatables-plugins/features/"
                      (for-each delete-file
                                '("scrollResize/source.min.js"
                                  "searchHighlight/source.min.js")))))))
      (properties
       `((upstream-name . "DT")))
      (build-system r-build-system)
      (arguments
       `(#:modules
         ((guix build r-build-system)
          (guix build minify-build-system)
          (guix build utils)
          (ice-9 match))
         #:imported-modules
         (,@%r-build-system-modules
          (guix build minify-build-system))
         #:phases
         (modify-phases (@ (guix build r-build-system) %standard-phases)
           (add-after 'unpack 'process-javascript
             (lambda* (#:key inputs #:allow-other-keys)
               (with-directory-excursion "inst/htmlwidgets/lib/"
                 (for-each (match-lambda
                             ((url hash dir)
                              (let* ((input (string-append "js:" (basename url)))
                                     (source (assoc-ref inputs input))
                                     (target (string-append dir "/js/"
                                                            (basename url ".js")
                                                            ".min.js")))
                                (mkdir-p dir)
                                (minify source #:target target))))
                           ',javascript-sources)

                 ;; Minify JS for each extension
                 (for-each (lambda (extension)
                             (let* ((name    (assoc-ref extension 'name))
                                    (version (assoc-ref extension 'version))
                                    (hash    (assoc-ref extension 'hash))
                                    (label   (string-append "js:" name))
                                    (dir     (string-append "datatables-extensions/"
                                                            name "/js")))
                               (mkdir-p dir)
                               (with-directory-excursion dir
                                 (for-each
                                  (lambda (file)
                                    (minify file
                                            #:target
                                            (string-append (basename file ".js") ".min.js")))
                                  (find-files (string-append (assoc-ref inputs label) "/js")
                                              "\\.js$")))))
                           ',extensions)
                 ;; Process typescript extensions
                 (for-each (lambda (extension)
                             (let* ((name    (assoc-ref extension 'name))
                                    (version (assoc-ref extension 'version))
                                    (hash    (assoc-ref extension 'hash))
                                    (label   (string-append "ts:" name))
                                    (dir     (string-append "datatables-extensions/"
                                                            name "/js")))
                               (mkdir-p dir)
                               (with-directory-excursion dir
                                 (apply invoke "esbuild"
                                        "--bundle"
                                        (string-append
                                         "--tsconfig="
                                         (string-append (assoc-ref inputs label)
                                                        "/tsconfig.json"))
                                        (string-append "--outdir=" (getcwd))
                                        (find-files
                                         (string-append (assoc-ref inputs label) "/src/")
                                         "\\.ts$"))
                                 (rename-file "index.js" (string-append "dataTables."
                                                                        (string-downcase name 0 1)
                                                                        ".js"))
                                 (for-each
                                  (lambda (file)
                                    (minify file
                                            #:target
                                            (string-append (basename file ".js") ".min.js"))
                                    (delete-file file))
                                  (find-files "." "\\.js$")))))
                           ',ts-extensions)
                 (minify (string-append (assoc-ref inputs "datatables-plugins")
                                        "/dataRender/ellipsis.js")
                         #:target "datatables-plugins/dataRender/ellipsis/source.min.js")
                 (minify (string-append (assoc-ref inputs "datatables-plugins")
                                        "/filtering/type-based/accent-neutralise.js")
                         #:target "datatables-plugins/filtering/accent-neutralise/source.min.js")
                 (minify (string-append (assoc-ref inputs "datatables-plugins")
                                        "/filtering/type-based/diacritics-neutralise.js")
                         #:target "datatables-plugins/filtering/diacritics-neutralise/source.min.js")
                 (minify (string-append (assoc-ref inputs "datatables-plugins")
                                        "/sorting/natural.js")
                         #:target "datatables-plugins/sorting/natural/source.min.js")
                 (minify (string-append (assoc-ref inputs "datatables-plugins")
                                        "/features/scrollResize/dataTables.scrollResize.js")
                         #:target "datatables-plugins/features/scrollResize/source.min.js")
                 (minify (string-append (assoc-ref inputs "datatables-plugins")
                                        "/features/searchHighlight/dataTables.searchHighlight.js")
                         #:target "datatables-plugins/features/searchHighlight/source.min.js")
                 (minify (assoc-ref inputs "js-nouislider")
                         #:target "nouislider/jquery.nouislider.min.js")

                 (let ((replace-file (lambda (old new)
                                       (format #t "replacing ~a with ~a\n" old new)
                                       (symlink new old))))
                   (replace-file "selectize/selectize.min.js"
                                 (string-append (assoc-ref inputs "js-selectize")
                                                "/share/javascript/selectize.min.js")))))))))
      (propagated-inputs
       (list r-crosstalk
             r-htmltools
             r-htmlwidgets
             r-httpuv
             r-jquerylib
             r-jsonlite
             r-magrittr
             r-promises))
      (inputs
       (list js-selectize))
      (native-inputs
       `(("r-knitr" ,r-knitr)
         ("r-testit" ,r-testit)
         ("esbuild" ,esbuild)
         ("datatables-plugins"
          ,(let ((version "1.13.6"))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/DataTables/Plugins.git")
                     (commit version)))
               (file-name (git-file-name "datatables-plugins" version))
               (sha256
                (base32
                 "02ijp9671al2fpb5sahy1z4nx1q75jp8p0i77vv87r8lqmsvsjis")))))
         ("js-nouislider"
          ,(let ((version "7.0.10"))
             (origin
               (method url-fetch)
               (uri (string-append "https://raw.githubusercontent.com/leongersen/noUiSlider/"
                                   version "/distribute/jquery.nouislider.js"))
               (sha256
                (base32
                 "1f7vsfcn7wwzngib6j0wpl0psd6qriiaa6kv728ynfn5da73zfxm")))))
         ,@(map (match-lambda
                  ((url hash dir)
                   `(,(string-append "js:" (basename url))
                     ,(origin (method url-fetch)
                              (uri url)
                              (sha256 (base32 hash))))))
                javascript-sources)
         ,@(map (lambda (extension)
                  (let ((name    (assoc-ref extension 'name))
                        (version (assoc-ref extension 'version))
                        (hash    (assoc-ref extension 'hash)))
                    `(,(string-append "js:" name)
                      ,(extension-origin name version hash))))
                extensions)
         ,@(map (lambda (extension)
                  (let ((name    (assoc-ref extension 'name))
                        (version (assoc-ref extension 'version))
                        (hash    (assoc-ref extension 'hash)))
                    `(,(string-append "ts:" name)
                      ,(extension-origin name version hash))))
                ts-extensions)))
      (home-page "https://rstudio.github.io/DT")
      (synopsis "R wrapper of the DataTables JavaScript library")
      (description
       "This package allows for data objects in R to be rendered as HTML
tables using the JavaScript library @code{DataTables} (typically via R
Markdown or Shiny).  The @code{DataTables} library has been included in this R
package.")
      ;; The DT package as a whole is distributed under GPLv3.  The DT package
      ;; inludes other software components under different licenses:
      ;;
      ;;   * Expat: jquery.highlight.js, DataTables
      ;;   * WTFPL: noUiSlider
      (license (list license:gpl3
                     license:expat
                     license:wtfpl2)))))

(define-public r-dynamictreecut
  (package
    (name "r-dynamictreecut")
    (version "1.63-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dynamicTreeCut" version))
       (sha256
        (base32
         "1fadbql7g5r2vvlkr89nlrjxwp4yx4xrdqmv077qvmnx9vv0f4w3"))))
    (properties `((upstream-name . "dynamicTreeCut")))
    (build-system r-build-system)
    (home-page
     "https://cran.r-project.org/web/packages/dynamicTreeCut/index.html")
    (synopsis "Detect clusters in hierarchical clustering dendrograms")
    (description
     "This package contains methods for the detection of clusters in
hierarchical clustering dendrograms.")
    (license license:gpl2+)))

(define-public r-e1071
  (package
    (name "r-e1071")
    (version "1.7-16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "e1071" version))
       (sha256
        (base32
         "0krsgkcvs16jixmjwjl05aggpz02hahg2j8ydk4r9nrz0ginbm8j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class r-proxy))
    ;; For vignettes
    (native-inputs (list r-mlbench r-randomforest r-xtable))
    (home-page "https://cran.r-project.org/web/packages/e1071")
    (synopsis "Miscellaneous functions for probability theory")
    (description
     "This package provides functions for latent class analysis, short time
Fourier transform, fuzzy clustering, support vector machines, shortest path
computation, bagged clustering, naive Bayes classifier, and more.")
    (license license:gpl2+)))

(define-public r-eaf
  (package
    (name "r-eaf")
    (version "2.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "eaf" version))
       (sha256
        (base32 "14mfcc7lacaghfxiq3x7zmbvk2ink3xkkbiky1bfv9dgwbmic8dr"))))
    (properties `((upstream-name . "eaf")))
    (build-system r-build-system)
    (inputs (list gsl))
    (propagated-inputs (list r-matrixstats r-modeltools r-rdpack))
    (native-inputs (list pkg-config r-spelling r-testthat r-withr))
    (home-page "https://mlopez-ibanez.github.io/eaf/")
    (synopsis "Plots of the empirical attainment function")
    (description
     "This is a package for computation and visualization of the
@dfn{empirical attainment function} (EAF) for the analysis of random sets in
multi-criterion optimization.")
    (license license:gpl2+)))

(define-public r-earlywarnings
  (package
    (name "r-earlywarnings")
    (version "1.1.29")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "earlywarnings" version))
              (sha256
               (base32
                "1xa9rijqqxa5l253dg8dn1jjhdakf8krl5rflq5v9gybfyrq1885"))))
    (properties `((upstream-name . "earlywarnings")))
    (build-system r-build-system)
    (propagated-inputs (list r-fields
                             r-ggplot2
                             r-kendall
                             r-kernsmooth
                             r-knitr
                             r-lmtest
                             r-moments
                             r-nortest
                             r-quadprog
                             r-som
                             r-spam
                             r-tgp
                             r-tseries))
    (native-inputs (list r-knitr))
    (home-page "https://www.early-warning-signals.org")
    (synopsis "Early warning signals for critical transitions in time series")
    (description
     "This package offers methods for estimating statistical changes in time
series.  These are used for identifying nearby critical transitions.")
    (license license:bsd-2)))

(define-public r-earth
  (package
    (name "r-earth")
    (version "5.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "earth" version))
       (sha256
        (base32 "1g6ywsmdp7qlp0rql6f07j9hih45w9jm7b90sgkjpylqan94zy9s"))))
    (properties `((upstream-name . "earth")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-plotmo))
    (native-inputs (list gfortran))
    (home-page "http://www.milbo.users.sonic.net/earth/")
    (synopsis "Multivariate adaptive regression splines")
    (description
     "This package lets you build regression models using the techniques in
Friedman's papers \"Fast MARS\" and \"Multivariate Adaptive Regression
Splines\" <doi:10.1214/aos/1176347963>. The term \"MARS\" is trademarked and
thus not used in the name of the package.")
    (license license:gpl3)))

(define-public r-effects
  (package
    (name "r-effects")
    (version "4.2-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "effects" version))
       (sha256
        (base32
         "0nlj79am9a1yg737dhfa8dj1kj2hly9pfknmphsbcvlgxqn35vig"))))
    (properties `((upstream-name . "effects")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cardata
           r-colorspace
           r-estimability
           r-insight
           r-lattice
           r-lme4
           r-nnet
           r-survey))
    (native-inputs
     (list r-knitr))
    (home-page "https://www.r-project.org")
    (synopsis
     "Effect displays for linear, generalized linear, and other models")
    (description
     "Graphical and tabular effect displays, e.g., of interactions, for
various statistical models with linear predictors.")
    (license license:gpl2+)))

(define-public r-embedsom
  (package
    (name "r-embedsom")
    (version "2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "EmbedSOM" version))
              (sha256
               (base32
                "1ilsrb53x4zf0r8jc7csbdnnd8a903qkx09aakw8diif38s72rjy"))))
    (properties `((upstream-name . "EmbedSOM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2
           r-igraph
           r-matrix
           r-rtsne
           r-umap
           r-uwot))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/exaexa/EmbedSOM")
    (synopsis "Fast embedding guided by self-organizing map")
    (description
     "This package provides a smooth mapping of multidimensional points into
low-dimensional space defined by a self-organizing map.  It is designed to
work with FlowSOM and flow-cytometry use-cases.")
    (license license:gpl3+)))

(define-public r-emdist
  (package
    (name "r-emdist")
    (version "0.3-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emdist" version))
       (sha256
        (base32
         "0jmnz612pjad3p1zk0qiljcbf0zbxfi4zcw2jqwg8ncjsifhr3mp"))))
    (properties `((upstream-name . "emdist")))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/emd")
    (synopsis "Earth mover's distance")
    (description
     "This package provides tools to calculate the Earth Mover's
Distance (EMD).")
    (license license:expat)))

(define-public r-emulator
  (package
    (name "r-emulator")
    (version "1.2-24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emulator" version))
       (sha256
        (base32 "0sd45wjdb00iyj8n16kqxypisam7ibwvpcaxsi1z56yzlzp93p4i"))))
    (properties `((upstream-name . "emulator")))
    (build-system r-build-system)
    (propagated-inputs (list r-mvtnorm))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/RobinHankin/emulator")
    (synopsis "Bayesian emulation of computer programs")
    (description
     "This package allows one to estimate the output of a computer program, as
a function of the input parameters, without actually running it.  The computer
program is assumed to be a Gaussian process, whose parameters are estimated
using Bayesian techniques that give a PDF of expected program output.  This
PDF is conditional on a training set of runs, each consisting of a point in
parameter space and the model output at that point.  The emphasis is on
complex codes that take weeks or months to run, and that have a large number
of undetermined input parameters; many climate prediction models fall into
this class.  The emulator essentially determines Bayesian posterior estimates
of the PDF of the output of a model, conditioned on results from previous runs
and a user-specified prior linear model.  The package includes functionality
to evaluate quadratic forms efficiently.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-esc
  (package
    (name "r-esc")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "esc" version))
       (sha256
        (base32
         "0gns7gz55p6pha05413r3hlvd7f2v1amxkg13d197mab1ypqic7q"))))
    (properties `((upstream-name . "esc")))
    (build-system r-build-system)
    (home-page "https://strengejacke.github.io/esc/")
    (synopsis "Effect size computation for meta analysis")
    (description
     "Implementation of the web-based
@url{http://www.campbellcollaboration.org/escalc/html/EffectSizeCalculator-Home.php,Practical
Meta-Analysis Effect Size Calculator} from David B. Wilson in R.  Based on the
input, the effect size can be returned as standardized mean difference,
Cohen's f, Hedges' g, Pearson's r or Fisher's transformation z, odds ratio or
log odds, or eta squared effect size.")
    (license license:gpl3)))

(define-public r-estimability
  (package
    (name "r-estimability")
    (version "1.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "estimability" version))
              (sha256
               (base32
                "1sa42rczhzfj0dkn8v1pq6b752rh6h7x553gcgl7g27x75mbk9iw"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/estimability")
    (synopsis "Tools for assessing estimability of linear predictions")
    (description "This package provides tools for determining estimability of
linear functions of regression coefficients, and @code{epredict} methods that
handle non-estimable cases correctly.")
    (license license:gpl2+)))

(define-public r-evaluate
  (package
    (name "r-evaluate")
    (version "1.0.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "evaluate" version))
              (sha256
               (base32
                "1qm2vz8a1hjgqyidaf3favzbp7fjka3m6qdq9yxjjmhf2gdfvzxv"))))
    (properties
     ;; We can't have r-testthat among the inputs here to avoid a dependency
     ;; cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (home-page "https://github.com/hadley/evaluate")
    (synopsis "Parsing and evaluation tools for R")
    (description
     "This package provides tools that allow you to recreate the parsing,
evaluation and display of R code, with enough information that you can
accurately recreate what happens at the command line.  The tools can easily be
adapted for other output formats, such as HTML or LaTeX.")
    (license license:gpl3+)))

(define-public r-exact
  (package
    (name "r-exact")
    (version "3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Exact" version))
       (sha256
        (base32 "0hikz8f19blywxs66xj6zf4krwyivsy3w165qvrnb0m2l6dx1l7v"))))
    (properties `((upstream-name . "Exact")))
    (build-system r-build-system)
    (propagated-inputs (list r-rootsolve))
    (home-page "https://cran.r-project.org/package=Exact")
    (synopsis "Unconditional exact test")
    (description
     "Performs unconditional exact tests and power calculations for 2x2
contingency tables.  For comparing two independent proportions, performs
@url{doi:10.1038/156177a0, Barnard's test (1945)} using the original CSM
test (@url{doi:10.1093/biomet/34.1-2.123, Barnard (1947)}), using Fisher's
p-value referred to as @url{doi:10.1111/j.1467-9574.1970.tb00104.x,
Boschloo's test (1970)}, or using a Z-statistic (@url{doi:10.2307/2981892,
Suissa and Shuster (1985)}).  For comparing two binary proportions,
performs unconditional exact test using McNemar's Z-statistic
(@url{doi:10.1191/0962280203sm312ra, Berger and Sidik (2003)}), using
McNemar's Z-statistic with continuity correction, or using CSM test.
Calculates confidence intervals for the difference in proportion.")
    (license license:gpl2)))

(define-public r-fail
  (package
    (name "r-fail")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fail" version))
       (sha256
        (base32
         "0vfm6kmpmgsamda5p0sl771kbnsscan31l2chzssyw93kwmams7d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bbmisc r-checkmate))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mllg/fail")
    (synopsis "File abstraction interface layer (FAIL)")
    (description
     "This package provides a more comfortable interface to work with R data
or source files in a key-value fashion.")
    (license license:bsd-3)))

(define-public r-fastcluster
  (package
    (name "r-fastcluster")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastcluster" version))
       (sha256
        (base32
         "1yv3nd8s9f45pqkv4srv41chh8ij0vikprfwgyphakc0xc9lj8gw"))))
    (build-system r-build-system)
    (home-page "http://danifold.net/fastcluster.html")
    (synopsis "Fast hierarchical clustering routines")
    (description
     "This package implements fast hierarchical, agglomerative clustering
routines.  Part of the functionality is designed as drop-in replacement for
existing routines: @code{linkage()} in the SciPy package
@code{scipy.cluster.hierarchy}, @code{hclust()} in R's @code{stats} package,
and the @code{flashClust} package.  It provides the same functionality with
the benefit of a much faster implementation.  Moreover, there are
memory-saving routines for clustering of vector data, which go beyond what the
existing packages provide.")
    (license license:bsd-2)))

(define-public r-fastica
  (package
    (name "r-fastica")
    (version "1.2-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastICA" version))
       (sha256
        (base32
         "08cw1aszsi4i8asfrzyyz66wl70g50y1dndmf8j8kqvhw1r6kdxw"))))
    (properties `((upstream-name . "fastICA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/fastICA")
    (synopsis "FastICA algorithms to perform ICA and projection pursuit")
    (description
     "This package provides an implementation of the FastICA algorithm to
perform @dfn{independent component analysis} (ICA) and projection pursuit.")
    ;; Any GPL version.
    (license license:gpl3+)))

(define-public r-fateid
  (package
    (name "r-fateid")
    (version "0.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FateID" version))
       (sha256
        (base32 "0sgvaqhqkmmkcsl53bm1jlfpzrvzfb5cz8k513nizfsi638vydlm"))))
    (properties `((upstream-name . "FateID")))
    (build-system r-build-system)
    (propagated-inputs (list r-locfit
                             r-matrixstats
                             r-pheatmap
                             r-princurve
                             r-randomforest
                             r-rcolorbrewer
                             r-rtsne
                             r-som
                             r-umap))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=FateID")
    (synopsis "Quantification of fate bias in multipotent progenitors")
    (description
     "This package computes cell fate bias for multi-lineage single-cell data.
It also provides visualization tools for analyzing these biases.")
    (license license:gpl3)))

(define-public r-fdrtool
  (package
    (name "r-fdrtool")
    (version "1.2.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fdrtool" version))
       (sha256
        (base32
         "1vxswr56c63vvl2q6m0j0a5psdw724vspf6zxlr1k9zsdfcnd6b4"))))
    (build-system r-build-system)
    (home-page "https://strimmerlab.org/software/fdrtool/")
    (synopsis "Estimation of false discovery rates and higher criticism")
    (description
     "This package provides tools to estimate tail area-based false discovery
rates as well as local false discovery rates for a variety of null
models (p-values, z-scores, correlation coefficients, t-scores).  The
proportion of null values and the parameters of the null distribution are
adaptively estimated from the data.  In addition, the package contains
functions for non-parametric density estimation (Grenander estimator), for
monotone regression (isotonic regression and antitonic regression with
weights), for computing the @dfn{greatest convex minorant} (GCM) and the
@dfn{least concave majorant} (LCM), for the half-normal and correlation
distributions, and for computing empirical @dfn{higher criticism} (HC) scores
and the corresponding decision threshold.")
    (license license:gpl3+)))

(define-public r-fit-models
  (package
    (name "r-fit-models")
    (version "0.64")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fit.models" version))
       (sha256
        (base32
         "1nk4x2q8cv79zcls61saf627ac0fci6jcrd6lmzk61asm2zhc27p"))))
    (properties `((upstream-name . "fit.models")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (native-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/fit.models")
    (synopsis "Compare fitted models")
    (description
     "The @code{fit.models} function and its associated methods (coefficients,
print, summary, plot, etc.) were originally provided in the @code{robust}
package to compare robustly and classically fitted model objects.  The aim of
the @code{fit.models} package is to separate this fitted model object
comparison functionality from the robust package and to extend it to support
fitting methods (e.g., classical, robust, Bayesian, regularized, etc.) more
generally.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fivethirtyeight
  (package
    (name "r-fivethirtyeight")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://mran.microsoft.com/src/contrib/"
                           "fivethirtyeight_" version ".tar.gz"))
       (sha256
        (base32
         "0fcc8rq745nsghp27dk0lgih90y4zx8hrzcvsn6ih786yv7qxhvl"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-knitr
           r-rmarkdown
           r-dplyr
           r-readr
           r-ggplot2
           r-magrittr
           r-stringr))
    (home-page "https://mran.microsoft.com/package/fivethirtyeight/")
    (synopsis "Data and code behind the stories at FiveThirtyEight")
    (description "This R package provides access to the code and data sets
published by the statistics blog FiveThirtyEight.")
    (license license:expat)))

(define-public r-flexmix
  (package
    (name "r-flexmix")
    (version "2.3-20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flexmix" version))
       (sha256
        (base32
         "1s160zi8bsdwk2vq0f0a3cbki1j42zk14dp2abxbpfjzhxyl7621"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-modeltools r-nnet))
    (home-page "https://cran.r-project.org/web/packages/flexmix")
    (synopsis "Flexible mixture modeling")
    (description
     "This package implements a general framework for finite mixtures of
regression models using the EM algorithm.  FlexMix provides the E-step and all
data handling, while the M-step can be supplied by the user to easily define
new models.  Existing drivers implement mixtures of standard linear models,
generalized linear models and model-based clustering.")
    (license license:gpl2+)))

(define-public r-forcats
  (package
    (name "r-forcats")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "forcats" version))
       (sha256
        (base32
         "0ki5c84n7xm4iw4aj629l51hm84f6p5wa3bw88d1wbnr15wibfy5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-glue
           r-lifecycle
           r-magrittr
           r-rlang
           r-tibble))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://forcats.tidyverse.org")
    (synopsis "Tools for working with factors")
    (description "This package provides helpers for reordering factor
levels (including moving specified levels to front, ordering by first
appearance, reversing, and randomly shuffling), and tools for modifying factor
levels (including collapsing rare levels into other, \"anonymizing\", and
manually \"recoding\").")
    (license license:gpl3)))

(define-public r-foreach
  (package
    (name "r-foreach")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "foreach" version))
       (sha256
        (base32
         "1r5gdf9fp3rprvrhf0gzl9qmmqhgdn5gscpm5hk8zxpraf3qscsn"))))
    (build-system r-build-system)
    ;; Tests require doparallel, which we cannot add because of a dependency
    ;; cycle.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-codetools r-iterators))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/foreach")
    (synopsis "Foreach looping construct for R")
    (description
     "This package provides support for the @code{foreach} looping construct.
@code{foreach} is an idiom that allows for iterating over elements in a
collection, without the use of an explicit loop counter.  This package in
particular is intended to be used for its return value, rather than for its
side effects.  In that sense, it is similar to the standard @code{lapply}
function, but doesn't require the evaluation of a function.  Using
@code{foreach} without side effects also facilitates executing the loop in
parallel.")
    (license license:asl2.0)))

(define-public r-formatr
  (package
    (name "r-formatr")
    (version "1.14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "formatR" version))
              (sha256
               (base32
                "0k271w4bhlj7r9igkiyfw7d7bg30s2mn4sr4alb8f9w57wnapfjf"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testit))
    (home-page "https://yihui.org/formatr/")
    (synopsis "Format R code automatically")
    (description
     "This package provides a function to format R source code.  Spaces and
indent will be added to the code automatically, and comments will be preserved
under certain conditions, so that R code will be more human-readable and tidy.
There is also a Shiny app as a user interface in this package.")
    (license license:gpl3+)))

(define-public r-formula
  (package
    (name "r-formula")
    (version "1.2-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Formula" version))
       (sha256
        (base32
         "0p1m9pqcn8ns0sn67js53677q8gwxgbl4bymcn5y2r0dc1s4c9c6"))))
    (properties `((upstream-name . "Formula")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/Formula")
    (synopsis "Extended model formulas")
    (description
     "This package provides a new class @code{Formula}, which extends the base
class @code{formula}.  It supports extended formulas with multiple parts of
regressors on the right-hand side and/or multiple responses on the left-hand
side.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fpc
  (package
    (name "r-fpc")
    (version "2.2-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fpc" version))
       (sha256
        (base32
         "0irzsl1g71z7kl0qrklkv0rv9byv017lh5klp5hfw3xw8zw3sm2g"))))
    (build-system r-build-system)
    ;; FIXME Test fails with this message:
    ;; attempt to select less than one element in get1index <real>
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-class
           r-cluster
           r-diptest
           r-flexmix
           r-kernlab
           r-mass
           r-mclust
           r-prabclus
           r-robustbase))
    (home-page "https://cran.r-project.org/web/packages/fpc")
    (synopsis "Flexible procedures for clustering")
    (description
     "This package provides various methods for clustering and cluster
validation.  For example, it provides fixed point clustering, linear
regression clustering, clustering by merging Gaussian mixture components, as
well as symmetric and asymmetric discriminant projections for visualisation of
the separation of groupings.")
  (license license:gpl2+)))

(define-public r-futile-logger
  (package
    (name "r-futile-logger")
    (version "1.4.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "futile.logger" version))
              (sha256
               (base32
                "1r3nayk0z9n1svbf8640vw90dal5q07nkn0gv4bnva3pbzb352sy"))))
    (properties `((upstream-name . "futile.logger")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-futile-options r-lambda-r))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/futile.logger")
    (synopsis "Logging utility for R")
    (description
     "This package provides a simple yet powerful logging utility.  Based
loosely on log4j, futile.logger takes advantage of R idioms to make logging a
convenient and easy to use replacement for @code{cat} and @code{print}
statements.")
    (license license:lgpl3+)))

(define-public r-futile-options
  (package
    (name "r-futile-options")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "futile.options" version))
              (sha256
               (base32
                "0w15agpi88y3qkv6fl72zy2pzyplzgvnj41a4ixhg64mw1sck73s"))))
    (properties
     `((upstream-name . "futile.options")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/futile.options")
    (synopsis "Options management framework")
    (description
     "The futile.options subsystem provides an easy user-defined options
management system that is properly scoped.  This means that options created
via @code{futile.options} are fully self-contained and will not collide with
options defined in other packages.")
    (license license:lgpl3+)))

(define-public r-fuzzyjoin
  (package
    (name "r-fuzzyjoin")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fuzzyjoin" version))
       (sha256
        (base32 "0s5rhqz8vih4za3a8k1k7i3gq8hj0w7bqnakw40k6mg87jvyzsj7"))))
    (properties `((upstream-name . "fuzzyjoin")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-geosphere
                             r-purrr
                             r-stringdist
                             r-stringr
                             r-tibble
                             r-tidyr))
    (native-inputs (list r-ggplot2 r-knitr r-testthat))
    (home-page "https://github.com/dgrtwo/fuzzyjoin")
    (synopsis "Join tables together on inexact matching")
    (description
     "Join tables together based not on whether columns match exactly, but
whether they are similar by some comparison.  Implementations include string
distance and regular expression matching.")
    (license license:expat)))

(define-public r-gdata
  (package
    (name "r-gdata")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gdata" version))
       (sha256
        (base32
         "0qiqfrk0qi8k1f6kvfkgp43algjdgfx6w5xmqrpyzh535gfrcfnv"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gtools))
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/gdata")
    (synopsis "Various R programming tools for data manipulation")
    (description
     "This package provides various R programming tools for data manipulation,
including:

@itemize
@item medical unit conversions
@item combining objects
@item character vector operations
@item factor manipulation
@item obtaining information about R objects
@item generating fixed-width format files
@item extricating components of date and time objects
@item operations on columns of data frames
@item matrix operations
@item operations on vectors and data frames
@item value of last evaluated expression
@item wrapper for @code{sample} that ensures consistent behavior for
  both scalar and vector arguments
@end itemize\n")
    (license license:gpl2+)))

(define-public r-gdtools
  (package
    (name "r-gdtools")
    (version "0.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gdtools" version))
       (sha256
        (base32
         "0dj7xzvmkl82c8ghm4p7km1f13a34zm4nlhx4yj4ipmjqxalkrzd"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; This is needed for tests.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list pkg-config r-gfonts r-testthat))
    (inputs
     (list cairo fontconfig freetype zlib))
    (propagated-inputs
     (list r-fontquiver r-htmltools r-rcpp r-systemfonts))
    (home-page "https://cran.r-project.org/web/packages/gdtools")
    (synopsis "Utilities for graphical rendering")
    (description
     "The @code{gdtools} package provides functionalities to get font metrics
and to generate base64 encoded string from raster matrix.")
    (license license:gpl3)))

(define-public r-gfonts
  (package
    (name "r-gfonts")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gfonts" version))
              (sha256
               (base32
                "19ja087k767bq71v2w4jcpynd62ysrqmjf6rpfnmmd40aanyxqkj"))))
    (properties `((upstream-name . "gfonts")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-crul
           r-glue
           r-htmltools
           r-jsonlite
           r-shiny))
    (native-inputs (list r-knitr r-testthat r-vcr))
    (home-page "https://dreamrs.github.io/gfonts/")
    (synopsis "Offline Google fonts for Markdown and Shiny")
    (description
     "This package lets you download Google fonts and generate CSS to use in
rmarkdown documents and Shiny applications.  Some popular fonts are included
and ready to use.")
    (license license:gpl3)))

(define-public r-ggalt
  (package
    (name "r-ggalt")
    (version "0.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggalt" version))
              (sha256
               (base32
                "0ssa274d41vhd6crzjz7jqzbwgnjimxwxl23p2cx35aqs5wdfjpc"))))
    (properties `((upstream-name . "ggalt")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ash
           r-dplyr
           r-extrafont
           r-ggplot2
           r-gtable
           r-kernsmooth
           r-maps
           r-mass
           r-plotly
           r-proj4
           r-rcolorbrewer
           r-scales
           r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/hrbrmstr/ggalt")
    (synopsis
     "Geometries, coordinate systems, fonts and more for ggplot2")
    (description
     "This package provides a compendium of new geometries, coordinate systems,
statistical transformations, scales and fonts for ggplot2, including splines,
1d and 2d densities, univariate average shifted histograms, a new map
coordinate system based on the PROJ.4-library along with
@code{geom_cartogram()} that mimics the original functionality of
@code{geom_map()}, formatters for \"bytes\", a @code{stat_stepribbon()}
function, increased @code{plotly} compatibility and the @code{StateFace} open
source font ProPublica.  Further new functionality includes lollipop charts,
dumbbell charts, the ability to encircle points and coordinate-system-based
text annotations.")
    (license license:agpl3)))

(define-public r-ggbeeswarm
  (package
    (name "r-ggbeeswarm")
    (version "0.7.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggbeeswarm" version))
              (sha256
               (base32
                "1rcw54isai05np4fj19vcxx2vcxq7y2nm3az9m8xwbc9pdjs4z7x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-beeswarm r-cli r-ggplot2 r-lifecycle r-vipor))
    (home-page "https://github.com/eclarke/ggbeeswarm")
    (synopsis "Categorical scatter (violin point) plots")
    (description
     "This package provides two methods of plotting categorical scatter plots
such that the arrangement of points within a category reflects the density of
data at that region, and avoids over-plotting.")
    (license license:gpl2+)))

(define-public r-ggbreak
  (package
    (name "r-ggbreak")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggbreak" version))
       (sha256
        (base32 "0paqjx3jlnnwgy7iaaqlslcmngcdprwf1pxknazcj2v91yal40v8"))))
    (properties `((upstream-name . "ggbreak")))
    (build-system r-build-system)
    (propagated-inputs (list r-aplot
                             r-ggfun
                             r-ggplot2
                             r-ggplotify
                             r-rlang
                             r-yulab-utils))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/YuLab-SMU/ggbreak")
    (synopsis "Set axis break for ggplot2")
    (description
     "This package provides an implementation of scale functions for setting
axis breaks of a ggplot.")
    (license license:artistic2.0)))

(define-public r-ggdendro
  (package
    (name "r-ggdendro")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggdendro" version))
              (sha256
               (base32
                "0sdayyzvhkbli0ha68mc0f7cgp36njv9ign37d63l21hvd6w6h0r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-mass))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/andrie/ggdendro")
    (synopsis "Create dendrograms and tree diagrams using ggplot2")
    (description "This is a set of tools for dendrograms and tree plots using
ggplot2.  The ggplot2 philosophy is to clearly separate data from the
presentation.  Unfortunately the plot method for dendrograms plots directly to
a plot device with out exposing the data.  The ggdendro package resolves this
by making available functions that extract the dendrogram plot data.  The
package provides implementations for tree, rpart, as well as diana and agnes
cluster diagrams.")
    (license license:gpl2+)))

(define-public r-ggdist
  (package
    (name "r-ggdist")
    (version "3.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggdist" version))
       (sha256
        (base32 "0wrnzl6m221k2h7rv5vf88va83yc6hsdm45fp5yz96cpmfr66mgk"))))
    (properties
     '((upstream-name . "ggdist")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-distributional
                             r-ggplot2
                             r-glue
                             r-gtable
                             r-numderiv
                             r-quadprog
                             r-rcpp
                             r-rlang
                             r-scales
                             r-tibble
                             r-vctrs
                             r-withr))
    (native-inputs
     (list r-dplyr
           r-knitr
           r-posterior
           r-testthat
           r-tidyr
           r-vdiffr))
    (home-page "https://mjskay.github.io/ggdist/")
    (synopsis "Visualizations of distributions and uncertainty")
    (description
     "This package provides primitives for visualizing distributions using
ggplot2 that are particularly tuned for visualizing uncertainty in either a
frequentist or Bayesian mode.  Both analytical distributions (such as
frequentist confidence distributions or Bayesian priors) and distributions
represented as samples (such as bootstrap distributions or Bayesian posterior
samples) are easily visualized.")
    (license license:gpl3+)))

(define-public r-ggfittext
  (package
    (name "r-ggfittext")
    (version "0.10.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggfittext" version))
              (sha256
               (base32
                "0glc4wh8flryv4mydzgk8a3lj7dzg2ip45gsxr472jgbg56a95mp"))))
    (properties `((upstream-name . "ggfittext")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-ggplot2 r-gridtext r-shades r-stringi))
    (native-inputs (list r-knitr r-testthat r-vdiffr))
    (home-page "https://wilkox.org/ggfittext/")
    (synopsis "Ggfittext is a ggplot2 extension for fitting text into boxes")
    (description
     "Ggfittext is a ggplot2 extension for fitting text into boxes.")
    (license license:gpl2)))

(define-public r-ggplot2
  (package
    (name "r-ggplot2")
    (version "3.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggplot2" version))
       (sha256
        (base32 "1gq63zz76pqv5pj07pji10z4yl7dcd2z3j13490nkrgk5x504c0a"))))
    (properties
     '((updater-extra-native-inputs . ("r-mapproj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-glue
           r-gtable
           r-isoband
           r-lifecycle
           r-mass
           r-mgcv
           r-rlang
           r-scales
           r-svglite ; Needed for 'ggsave'
           r-tibble
           r-vctrs
           r-withr))
    (native-inputs
     ;; We don't need any of the other inputs that the importer adds.
     (list r-knitr r-mapproj r-testthat))
    (home-page "https://ggplot2.tidyverse.org")
    (synopsis "Implementation of the grammar of graphics")
    (description
     "Ggplot2 is an implementation of the grammar of graphics in R.  It
combines the advantages of both base and lattice graphics: conditioning and
shared axes are handled automatically, and you can still build up a plot step
by step from multiple data sources.  It also implements a sophisticated
multidimensional conditioning system and a consistent interface to map data to
aesthetic attributes.")
    (license license:gpl2+)))

(define-public r-ggstats
  (package
    (name "r-ggstats")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggstats" version))
       (sha256
        (base32 "110c9xcrc7rvn4lw8z0lnza3zi327biqbkg90idpjj7gzmwkf3v1"))))
    (properties
     '((upstream-name . "ggstats")
       (updater-extra-native-inputs . ("r-broom-helpers"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dplyr
                             r-forcats
                             r-ggplot2
                             r-lifecycle
                             r-patchwork
                             r-purrr
                             r-rlang
                             r-scales
                             r-stringr
                             r-tidyr))
    (native-inputs (list r-broom
                         r-broom-helpers
                         r-knitr
                         r-labelled
                         r-nnet
                         r-pscl
                         r-survey
                         r-survival
                         r-testthat
                         r-vdiffr))
    (home-page "https://larmarange.github.io/ggstats/")
    (synopsis "Extension to ggplot2 for plotting stats")
    (description
     "This package provides new statistics, new geometries and new positions
for ggplot2 and a suite of functions to facilitate the creation of statistical
plots.")
    (license license:gpl3+)))

(define-public r-ggstatsplot
  (package
    (name "r-ggstatsplot")
    (version "0.13.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggstatsplot" version))
              (sha256
               (base32
                "0qqlfq6w3z1qb09laibf9c4w7cgnz063i8kr3yrqnr5076ww3kqf"))))
    (properties `((upstream-name . "ggstatsplot")))
    (build-system r-build-system)
    (propagated-inputs (list r-correlation
                             r-datawizard
                             r-dplyr
                             r-ggcorrplot
                             r-ggplot2
                             r-ggrepel
                             r-ggside
                             r-ggsignif
                             r-glue
                             r-insight
                             r-paletteer
                             r-parameters
                             r-patchwork
                             r-performance
                             r-purrr
                             r-rlang
                             r-statsexpressions
                             r-tidyr))
    (native-inputs (list r-knitr
                         r-survival
                         r-testthat
                         r-tibble
                         r-vdiffr
                         r-withr
                         r-wrs2))
    (home-page "https://indrajeetpatil.github.io/ggstatsplot/")
    (synopsis "Based plots with statistical details")
    (description
     "This package generates graphics with embedded details from statistical tests.
Statistical tests included in the plots themselves.  It provides an easier
syntax to generate information-rich plots for statistical analysis of
continuous or categorical data.  Currently, it supports the most common
types of statistical approaches and tests: parametric, nonparametric,
robust, and Bayesian versions of t-test/ANOVA, correlation analyses,
contingency table analysis, meta-analysis, and regression analyses.")
    (license license:gpl3)))

(define-public r-ggsurvfit
  (package
    (name "r-ggsurvfit")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsurvfit" version))
       (sha256
        (base32 "0c3qv9gii3ndqip3nxs08bx7lvh6sm46mxz8nyi627zbgqmhwrr5"))))
    (properties
     '((upstream-name . "ggsurvfit")
       (updater-ignored-native-inputs . ("r-tidycmprsk"))))
    (build-system r-build-system)
    ;; Some 20 tests require tidycmprsk, which pulls in React.  So I'm happy
    ;; to ignore the tests.
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-broom
                             r-cli
                             r-dplyr
                             r-ggplot2
                             r-glue
                             r-gtable
                             r-patchwork
                             r-rlang
                             r-survival
                             r-tidyr))
    (native-inputs (list r-knitr
                         r-scales
                         r-spelling
                         r-testthat
                         r-vdiffr
                         r-withr))
    (home-page "https://github.com/pharmaverse/ggsurvfit")
    (synopsis "Flexible time-to-event figures")
    (description
     "This package is meant to ease the creation of
time-to-event (i.e. survival) endpoint figures.  The modular functions create
figures ready for publication.  Each of the functions that add to or modify
the figure are written as proper ggplot2 @code{geoms} or @code{stat} methods,
allowing the functions from this package to be combined with any function or
customization from ggplot2 and other ggplot2 extension packages.")
    (license license:expat)))

(define-public r-ggthemes
  (package
    (name "r-ggthemes")
    (version "5.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggthemes" version))
              (sha256
               (base32
                "03mxigi34nd05wjigm8lpcbyhp4c8jxz7zm04qs27clbzsn1jj07"))))
    (properties
     '((updater-extra-native-inputs . ("r-dplyr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2
           r-lifecycle
           r-purrr
           r-scales
           r-stringr
           r-tibble))
    (native-inputs (list r-dplyr r-testthat))
    (home-page "https://cran.rstudio.com/web/packages/ggthemes")
    (synopsis "Extra themes, scales and geoms for @code{ggplot2}")
    (description "This package provides extra themes and scales for
@code{ggplot2} that replicate the look of plots by Edward Tufte and Stephen
Few in Fivethirtyeight, The Economist, Stata, Excel, and The Wall Street
Journal, among others.  This package also provides @code{geoms} for Tufte's
box plot and range frame.")
    (license license:gpl2)))

(define-public r-ggupset
  (package
    (name "r-ggupset")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggupset" version))
       (sha256
        (base32 "08kk3hc0ipkpkwr90kkjfgz6r8rjjfbdmrzawrkg8j51a8h0lyp8"))))
    (properties `((upstream-name . "ggupset")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-gtable r-rlang r-scales r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/const-ae/ggupset")
    (synopsis "Combination matrix axis for ggplot2 to create UpSet plots")
    (description
     "This package lets you replace the standard x-axis in ggplots with a
combination matrix to visualize complex set overlaps.  UpSet has introduced a
new way to visualize the overlap of sets as an alternative to Venn diagrams.
This package provides a simple way to produce such plots using ggplot2.  In
addition it can convert any categorical axis into a combination matrix axis.")
    (license license:gpl3)))

(define-public r-git2r
  (package
    (name "r-git2r")
    (version "0.36.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "git2r" version))
              (sha256
               (base32
                "1b6ccsvaab63vyb04jszs352fk03hazg6cav4wv8h1f4al2z1m4c"))))
    (properties
     '((updater-extra-native-inputs . ("tzdata-for-tests"))
       (updater-ignored-native-inputs . ("openssh" "openssl" "pcre2"))))
    (build-system r-build-system)
    (inputs
     (list libgit2 zlib))
    (native-inputs
     (list pkg-config tzdata-for-tests))
    (home-page "https://github.com/ropensci/git2r")
    (synopsis "Access Git repositories with R")
    (description
     "This package provides an R interface to the libgit2 library, which is a
pure C implementation of the Git core methods.")
    ;; GPLv2 only with linking exception.
    (license license:gpl2)))

(define-public r-glba
  (package
    (name "r-glba")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glba" version))
       (sha256
        (base32 "0dilf144xfn454xfsndbddhc28gzf36fiknc2qwcx3bp7z5caqjn"))))
    (properties `((upstream-name . "glba")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=glba")
    (synopsis "General linear ballistic accumulator models")
    (description
     "This package lets you analyze response times and accuracies from
psychological experiments with the @dfn{linear ballistic accumulator} (LBA)
model from Brown and Heathcote (2008).  The LBA model is optionally fitted
with explanatory variables on the parameters such as the drift rate, the
boundary and the starting point parameters.  A log-link function on the linear
predictors can be used to ensure that parameters remain positive when
needed.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-gld
  (package
    (name "r-gld")
    (version "2.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gld" version))
       (sha256
        (base32 "0w50nn1cp8mzjxp8403ymqh7f3iz0nk5wa8ms97d02lqp2jgfvyc"))))
    (properties `((upstream-name . "gld")))
    (build-system r-build-system)
    (propagated-inputs (list r-e1071 r-lmom))
    (home-page "https://cran.r-project.org/package=gld")
    (synopsis
     "Estimation and use of the generalised (Tukey) lambda distribution")
    (description
     "The generalised lambda distribution, or Tukey lambda distribution,
provides a wide variety of shapes with one functional form.  This package
provides random numbers, quantiles, probabilities, densities and
density quantiles for four different types of the distribution, the FKML
(Freimer et al 1988), RS (Ramberg and Schmeiser 1974), GPD (van Staden and
Loots 2009) and FM5 - see documentation for details.  It provides the density
function, distribution function, and Quantile-Quantile plots.  It implements a
variety of estimation methods for the distribution, including diagnostic
plots.  Estimation methods include the starship (all 4 types), method of
L-Moments for the GPD and FKML types, and a number of methods for only the
FKML type.  These include maximum likelihood, maximum product of spacings,
Titterington's method, Moments, Trimmed L-Moments and Distributional Least
Absolutes.")
    (license license:gpl2+)))

(define-public r-glinternet
  (package
    (name "r-glinternet")
    (version "1.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glinternet" version))
       (sha256
        (base32
         "0aphdscj0s6kqxlkgqkw2d6snrylz6hiis6307pl8ldh7q5cvm33"))))
    (build-system r-build-system)
    (home-page "http://web.stanford.edu/~hastie/Papers/glinternet_jcgs.pdf")
    (synopsis "Learning interactions via hierarchical group-lasso regularization")
    (description "Group-Lasso INTERaction-NET.  Fits linear
pairwise-interaction models that satisfy strong hierarchy: if an interaction
coefficient is estimated to be nonzero, then its two associated main effects
also have nonzero estimated coefficients.  Accommodates categorical
variables (factors) with arbitrary numbers of levels, continuous variables,
and combinations thereof.  Implements the machinery described in the paper
\"Learning interactions via hierarchical group-lasso regularization\" (JCGS
2015, Volume 24, Issue 3).  Michael Lim & Trevor Hastie (2015)")
    (license license:gpl2)))

(define-public r-glmnet
  (package
   (name "r-glmnet")
   (version "4.1-8")
   (source
    (origin
     (method url-fetch)
     (uri (cran-uri "glmnet" version))
     (sha256
      (base32 "1znw1p1mi7nv39l7albcg6sfxj7a1jyjw85hb3ginv870z7fbnqx"))))
   (build-system r-build-system)
   (native-inputs
    (list gfortran r-knitr r-testthat))
   (propagated-inputs
    (list r-foreach
          r-matrix
          r-rcpp
          r-rcppeigen
          r-shape
          r-survival))
   (home-page "https://www.jstatsoft.org/article/view/v033i01")
   (synopsis "Lasso and elastic-net regularized generalized linear models")
   (description
    "The glmnet package provides efficient procedures for fitting the entire
lasso or elastic-net regularization path for linear and Poisson regression, as
well as logistic, multinomial, Cox, multiple-response Gaussian and grouped
multinomial models.  The algorithm uses cyclical coordinate descent in a
path-wise fashion.")
   (license license:gpl2+)))

(define-public r-glmpca
  (package
    (name "r-glmpca")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "glmpca" version))
              (sha256
               (base32
                "02xjf0gg52925hw9nw2j0znfmzfzfwbv0fxjl9d2fy9j63drr2h4"))))
    (properties `((upstream-name . "glmpca")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/willtownes/glmpca")
    (synopsis "Dimension Reduction of Non-Normally Distributed Data")
    (description
     "This package implements a generalized version of principal components
analysis (GLM-PCA) for dimension reduction of non-normally distributed data
such as counts or binary matrices.")
    (license license:lgpl3+)))

(define-public r-gmm
  (package
    (name "r-gmm")
    (version "1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gmm" version))
       (sha256
        (base32 "1n45dls7632b11bg6pipamp2zmp8j1hp4nlrj91r4schd9fgr6bh"))))
    (properties `((upstream-name . "gmm")))
    (build-system r-build-system)
    (propagated-inputs (list r-sandwich))
    (native-inputs (list gfortran r-knitr))
    (home-page "https://cran.r-project.org/package=gmm")
    (synopsis
     "Generalized method of moments and generalized empirical likelihood")
    (description
     "This is a complete suite to estimate models based on moment conditions.
It includes the two step Generalized method of moments (Hansen 1982;
<doi:10.2307/1912775>), the iterated GMM and continuous updated estimator
(Hansen, Eaton and Yaron 1996; <doi:10.2307/1392442>) and several methods that
belong to the Generalized Empirical Likelihood family of estimators (Smith
1997; <doi:10.1111/j.0013-0133.1997.174.x>, Kitamura 1997;
<doi:10.1214/aos/1069362388>, Newey and Smith 2004;
<doi:10.1111/j.1468-0262.2004.00482.x>, and Anatolyev 2005
<doi:10.1111/j.1468-0262.2005.00601.x>).")
    (license license:gpl2+)))

(define-public r-googledrive
  (package
    (name "r-googledrive")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googledrive" version))
       (sha256
        (base32
         "10pv70nvsqh1yc12g5fj7avfihjzpj02m8s9f8sb0c1np9s4z2qb"))))
    (properties
     '((upstream-name . "googledrive")
       (updater-extra-native-inputs . ("r-mockr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-gargle
           r-glue
           r-httr
           r-jsonlite
           r-lifecycle
           r-magrittr
           r-pillar
           r-purrr
           r-rlang
           r-tibble
           r-uuid
           r-vctrs
           r-withr))
    (native-inputs
     (list r-knitr r-mockr r-testthat))
    (home-page "https://googledrive.tidyverse.org")
    (synopsis "Interface to Google Drive")
    (description "This package lets you manage Google Drive files from R.")
    (license license:expat)))

(define-public r-googlesheets
  (package
    (name "r-googlesheets")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googlesheets" version))
       (sha256
        (base32 "13n6vkdcbz78sbxq5xrj0zhq0dpriz6cyq13v3raa92152l88rm5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger
           r-dplyr
           r-httr
           r-jsonlite
           r-purrr
           r-readr
           r-stringr
           r-tibble
           r-tidyr
           r-xml2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/jennybc/googlesheets")
    (synopsis "Manage Google spreadsheets from R")
    (description "This package provides tools to interact with Google Sheets
from within R.")
    (license license:expat)))

(define-public r-googlevis
  (package
    (name "r-googlevis")
    (version "0.7.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googleVis" version))
       (sha256
        (base32 "0swcf2vl3mvp2bsd7nra917pajyh27j2k3vmmrb6n8g55mazyisn"))))
    (properties `((upstream-name . "googleVis")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://mages.github.io/googleVis/")
    (synopsis "R interface to Google Charts")
    (description
     "The @code{googleVis} package provides an interface between R and the Google
Charts API.  Google Charts offer interactive charts which can be embedded into
web pages.  The functions of the @code{googleVis} package allow the user to
visualise data stored in R data frames with Google Charts without uploading
the data to Google.  The output of a @code{googleVis} function is HTML code
that contains the data and references to JavaScript functions hosted by
Google.  @code{googleVis} makes use of the internal R HTTP server to display
the output locally.")
    (license license:gpl2+)))

(define-public r-gpg
  (package
    (name "r-gpg")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gpg" version))
              (sha256
               (base32
                "04hnmxvnxligd93vzvp38wpxpyxvqz5qd5084awklim846v3dg03"))))
    (properties
     '((upstream-name . "gpg")
       (updater-extra-inputs . ("gpgme"))))
    (build-system r-build-system)
    (inputs (list gpgme))
    (propagated-inputs (list r-askpass r-curl))
    (native-inputs (list pkg-config r-knitr))
    (home-page "https://github.com/jeroen/gpg")
    (synopsis "GNU Privacy Guard for R")
    (description
     "This package provides bindings to GnuPG for working with
OpenGPG (RFC4880) cryptographic methods.  It includes utilities for public key
encryption, creating and verifying digital signatures, and managing your local
keyring.  Some functionality depends on the version of GnuPG that is installed
on the system.")
    (license license:expat)))

(define-public r-gplots
  (package
    (name "r-gplots")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gplots" version))
       (sha256
        (base32
         "0isgbzsj0zkbzp5zvcz4nkc70rm33pcvcmfd6jiiqiw7nilirqqj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-catools r-gtools r-kernsmooth))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/gplots")
    (synopsis "Various R programming tools for plotting data")
    (description
     "This package provides various R programming tools for plotting data,
including:

@itemize
@item calculating and plotting locally smoothed summary function
@item enhanced versions of standard plots
@item manipulating colors
@item calculating and plotting two-dimensional data summaries
@item enhanced regression diagnostic plots
@item formula-enabled interface to @code{stats::lowess} function
@item displaying textual data in plots
@item balloon plots
@item plotting \"Venn\" diagrams
@item displaying Open-Office style plots
@item plotting multiple data on same region, with separate axes
@item plotting means and confidence intervals
@item spacing points in an x-y plot so they don't overlap
@end itemize\n")
    (license license:gpl2+)))

(define-public r-gridbase
  (package
    (name "r-gridbase")
    (version "0.4-7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gridBase" version))
              (sha256
               (base32
                "09jzw4rzwf2y5lcz7b16mb68pn0fqigv34ff7lr6w3yi9k91i1xy"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/gridBase")
    (synopsis "Integration of base and grid graphics")
    (description "This package provides an integration of base and grid
graphics for R.")
    (license license:gpl2+)))

(define-public r-gridextra
  (package
    (name "r-gridextra")
    (version "2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gridExtra" version))
              (sha256
               (base32
                "0fwfk3cdwxxim7nd55pn7m31bcaqj48y06j7an2k1v1pybk0rdl1"))))
    (properties `((upstream-name . "gridExtra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gtable))
    (native-inputs
     (list r-knitr r-testthat))         ;for building vignettes
    (home-page "https://github.com/baptiste/gridextra")
    (synopsis "Miscellaneous functions for \"Grid\" graphics")
    (description
     "This package provides a number of user-level functions to work with
@code{grid} graphics, notably to arrange multiple grid-based plots on a page,
and draw tables.")
    (license license:gpl2+)))

(define-public r-gsignal
  (package
    (name "r-gsignal")
    (version "0.3-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsignal" version))
       (sha256
        (base32 "1chkzv3bx1nas1yc6l5i3hgc8m40n1lm1y3c8577l8sqi89hnhs3"))))
    (properties `((upstream-name . "gsignal")))
    (build-system r-build-system)
    (propagated-inputs (list r-pracma r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/gjmvanboxtel/gsignal")
    (synopsis "Signal processing")
    (description
     "This package provides an R implementation of the Octave package
@code{signal}, containing a variety of signal processing tools, such as signal
generation and measurement, correlation and convolution, filtering, filter
design, filter analysis and conversion, power spectrum analysis, system
identification, decimation and sample rate change, and windowing.")
    (license license:gpl3)))

(define-public r-gson
  (package
    (name "r-gson")
    (version "0.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gson" version))
              (sha256
               (base32
                "10d3v543bvsyrwg3dm04xpzxjvmba1d1fhcf2zfb3l36pvjvxp8l"))))
    (properties `((upstream-name . "gson")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite r-rlang r-tidyr))
    (home-page "https://cran.r-project.org/package=gson")
    (synopsis "Base Class and Methods for 'gson' Format")
    (description
     "This package proposes a new file format named @code{gson} for storing
gene set and related information, and provides read, write and other utilities
to process this file format.")
    (license license:artistic2.0)))

(define-public r-gtable
  (package
    (name "r-gtable")
    (version "0.3.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gtable" version))
              (sha256
               (base32
                "1vz0kpj1hh3iz27yaax4i3l9n018py455p4f5nfn92r727xaa1fk"))))
    (properties `((upstream-name . "gtable")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-glue r-lifecycle r-rlang))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/gtable")
    (synopsis "R library to arrange grobs in tables")
    (description
     "Gtable is a collection of tools to make it easier to work with
\"tables\" of grobs.")
    (license license:gpl2+)))

(define-public r-gtools
  (package
    (name "r-gtools")
    (version "3.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gtools" version))
       (sha256
        (base32
         "0jqpvygxgr4m1rgaj5rzd048fwxvpcr4n1vx8bfabc9d2p0vdsfy"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/gtools")
    (synopsis "Various R programming tools")
    (description
     "This package contains a collection of various functions to assist in R
programming, such as tools to assist in developing, updating, and maintaining
R and R packages, calculating the logit and inverse logit transformations,
tests for whether a value is missing, empty or contains only @code{NA} and
@code{NULL} values, and many more.")
    (license license:gpl2)))

(define-public r-guix-install
  (package
    (name "r-guix-install")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "guix.install" version))
       (sha256
        (base32 "0s3wb5781yc43c9zwrn7i87zcbrlx7xr0ms0v9hvgs7qsv02id9j"))))
    (properties `((upstream-name . "guix.install")))
    (build-system r-build-system)
    (propagated-inputs (list r-runit))
    (home-page "https://github.com/BIMSBbioinfo/guix.install")
    (synopsis "Install R packages with GNU Guix")
    (description
     "This R package provides a single procedure @code{guix.install()}, which
allows users to install R packages via Guix right from within their running R
session.  If the requested R package does not exist in Guix at this time, the
package and all its missing dependencies will be imported recursively and the
generated package definitions will be written to @file{~/.Rguix/packages.scm}.
This record of imported packages can be used later to reproduce the
environment, and to add the packages in question to a proper Guix channel (or
Guix itself).  @code{guix.install()} not only supports installing packages
from CRAN, but also from Bioconductor or even arbitrary git or mercurial
repositories, replacing the need for installation via @code{devtools}.")
    (license license:gpl3+)))

(define-public r-gunifrac
  (package
    (name "r-gunifrac")
    (version "1.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GUniFrac" version))
              (sha256
               (base32
                "1yw0d8hb7s662xy0dny9ygvx9gwh7yj8dxw4897zy7zyjhzim95f"))))
    (properties `((upstream-name . "GUniFrac")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ape
           r-dirmult
           r-foreach
           r-ggplot2
           r-ggrepel
           r-inline
           r-mass
           r-matrix
           r-matrixstats
           r-modeest
           r-rcpp
           r-rmutil
           r-statmod
           r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=GUniFrac")
    (synopsis
     "Generalized UniFrac distances and methods for microbiome data analysis")
    (description
     "This package provides a suite of methods for powerful and robust
microbiome data analysis, including data normalization, data simulation,
community-level association testing and differential abundance analysis.  It
implements generalized UniFrac distances, @dfn{Geometric Mean of Pairwise
Ratios} (GMPR) normalization, semiparametric data simulator, distance-based
statistical methods, and feature- based statistical methods.  The
distance-based statistical methods include three extensions of PERMANOVA:

@itemize
@item PERMANOVA using the Freedman-Lane permutation scheme,
@item PERMANOVA omnibus test using multiple matrices, and
@item analytical approach to approximating PERMANOVA p-value.
@end itemize

Feature-based statistical methods include linear model-based methods for
differential abundance analysis of zero-inflated high-dimensional
compositional data.")
    (license license:gpl3)))

(define-public r-gwasexacthw
  (package
    (name "r-gwasexacthw")
    (version "1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GWASExactHW" version))
              (sha256
               (base32
                "1xzcvmbh27ibd7g9zlqyp215q4yfkhdypcvm5gjkvw1qhd3pl4yk"))))
    (properties `((upstream-name . "GWASExactHW")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=GWASExactHW")
    (synopsis
     "Exact Hardy-Weinburg testing for Genome Wide Association Studies")
    (description
     "This package contains a function to do exact Hardy-Weinburg
testing (using Fisher's test) for SNP genotypes as typically obtained in a
@dfn{Genome Wide Association Study} (GWAS).")
    (license license:gpl3)))

(define-public r-gwidgets2
  (package
    (name "r-gwidgets2")
    (version "1.0-10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gWidgets2" version))
              (sha256
               (base32
                "04wqyyk7wj808035862vsrmmhpvcailnscycpc83qfrkpqkr15v6"))))
    (properties `((upstream-name . "gWidgets2")))
    (build-system r-build-system)
    ;; Tests fail with: could not find function "gwindow"
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-digest))
    (home-page "https://github.com/gWidgets3/gWidgets2")
    (synopsis "Rewrite of gWidgets API for simplified GUI construction")
    (description
     "This package provides a re-implementation of the @code{gWidgets} API.
The API is defined in this package.  A second, toolkit-specific package is
required to use it.")
    (license license:gpl3+)))

(define-public r-gwidgets2tcltk
  (package
    (name "r-gwidgets2tcltk")
    (version "1.0-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gWidgets2tcltk" version))
              (sha256
               (base32
                "02ic4avpa33dnqsnm1mzg7ci1psngk1p169pqf259szf6v39qf8h"))))
    (properties `((upstream-name . "gWidgets2tcltk")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'start-x-server
            (lambda _
              ;; Tests require a running X server.
              (system "Xvfb :1 +extension GLX &")
              (setenv "DISPLAY" ":1"))))))
    (propagated-inputs (list r-digest r-gwidgets2 r-memoise))
    (native-inputs
     (list r-testthat xorg-server-for-tests))
    (home-page "https://github.com/jverzani/gWidgets2tcltk")
    (synopsis "Toolkit implementation of gWidgets2 for tcltk")
    (description "This package is a port of the @code{gWidgets2} API for the
@code{tcltk} package.")
    (license license:gpl2+)))

(define-public r-ids
  (package
    (name "r-ids")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ids" version))
       (sha256
        (base32
         "1s6ga94gds5ydr9f8qbjfgfpg2dvbnkcrlybqlb33hk3c0c2l8dn"))))
    (properties `((upstream-name . "ids")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-openssl r-uuid))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/richfitz/ids")
    (synopsis "Generate random identifiers")
    (description
     "This package lets you generate random or human readable and
pronounceable identifiers.")
    (license license:expat)))

(define-public r-irlba
  (package
    (name "r-irlba")
    (version "2.3.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "irlba" version))
       (sha256
        (base32
         "1ky5nlmyrnwz6121wwqd8p8r1ycnjkl5r290k4x2477rzs267zic"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (home-page "https://cran.r-project.org/web/packages/irlba")
    (synopsis "Methods for eigendecomposition of large matrices")
    (description
     "This package provides fast and memory efficient methods for truncated
singular and eigenvalue decompositions, as well as for principal component
analysis of large sparse or dense matrices.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-iterators
  (package
    (name "r-iterators")
    (version "1.0.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "iterators" version))
       (sha256
        (base32
         "0yv7rh6ghlfx727xy2aq64a7skyxp9msakaffs641q9h15d0gwyf"))))
    (build-system r-build-system)
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/iterators")
    (synopsis "Iterator construct for R")
    (description
     "This package provides support for iterators, which allow a programmer to
traverse through all the elements of a vector, list, or other collection of
data.")
    (license license:asl2.0)))

(define-public r-googlesheets4
  (package
    (name "r-googlesheets4")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "googlesheets4" version))
       (sha256
        (base32
         "1kzwhs9zrx1i4kqhdqrkzyhnwx25j8j2pcg7ja2dxfalihs67k65"))))
    (properties `((upstream-name . "googlesheets4")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger
           r-cli
           r-curl
           r-gargle
           r-glue
           r-googledrive
           r-httr
           r-ids
           r-lifecycle
           r-magrittr
           r-purrr
           r-rematch2
           r-rlang
           r-tibble
           r-vctrs
           r-withr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/tidyverse/googlesheets4")
    (synopsis "Access Google Sheets using the Sheets API V4")
    (description
     "This package lets you interact with Google Sheets through the
@url{https://developers.google.com/sheets/api,Sheets API v4}.  This package
can read and write both the metadata and the cell data in a Sheet.")
    (license license:expat)))

(define-public r-pbapply
  (package
    (name "r-pbapply")
    (version "1.7-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbapply" version))
       (sha256
        (base32
         "04xf1p7c0066cwnxfmzaikbc322bxnw022ziv8kkhzlc6268rvdf"))))
    (build-system r-build-system)
    (native-inputs (list r-future))
    (home-page "https://github.com/psolymos/pbapply")
    (synopsis "Adding progress bar to apply functions")
    (description
     "This lightweight package that adds progress bar to vectorized R
functions apply.  The implementation can easily be added to functions where
showing the progress is useful e.g. bootstrap.")
    (license license:gpl2)))

(define-public r-pbkrtest
  (package
    (name "r-pbkrtest")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pbkrtest" version))
       (sha256
        (base32
         "08nq4fjgh4156cpw1y9x10bk13j98ix5xr36cdbhyd3cfvskyind"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-doby
           r-dplyr
           r-lme4
           r-mass
           r-matrix
           r-numderiv))
    (native-inputs
     (list r-knitr))
    (home-page "https://people.math.aau.dk/~sorenh/software/pbkrtest/")
    (synopsis "Methods for linear mixed model comparison")
    (description
     "This package implements a parametric bootstrap test and a Kenward Roger
modification of F-tests for linear mixed effects models and a parametric
bootstrap test for generalized linear mixed models.")
    (license license:gpl2+)))

(define-public r-pcapp
  (package
    (name "r-pcapp")
    (version "2.0-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pcaPP" version))
       (sha256
        (base32
         "043w3g3f57j2d0irnrxm58mzzisg7xmnsl17v7wijsh1czcswkv7"))))
    (properties `((upstream-name . "pcaPP")))
    (build-system r-build-system)
    ;; Vignettes attempt to load the missing file "load.package.name.R".
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs
     (list r-mvtnorm))
    (home-page "https://cran.r-project.org/web/packages/pcaPP")
    (synopsis "Robust PCA by projection pursuit")
    (description
     "This package provides functions for robust @dfn{principal component
analysis} (PCA) by projection pursuit.")
    (license license:gpl3+)))

(define-public r-permute
  (package
   (name "r-permute")
   (version "0.9-7")
   (source
    (origin
     (method url-fetch)
     (uri (cran-uri "permute" version))
     (sha256
      (base32
       "1h4dyhcsv8p3h3qxsy98pib9v79dddvrnq7qx6abkblsazxqzy7g"))))
   (build-system r-build-system)
   (native-inputs (list r-knitr r-testthat))
   ;; Tests do not run correctly, but running them properly would entail a
   ;; circular dependency with vegan.
   (home-page "https://github.com/gavinsimpson/permute")
   (synopsis "Functions for generating restricted permutations of data")
   (description
    "This package provides a set of restricted permutation designs for freely
exchangeable, line transects (time series), spatial grid designs and permutation
of blocks (groups of samples).  @code{permute} also allows split-plot designs,
in which the whole-plots or split-plots or both can be freely exchangeable.")
   (license license:gpl2+)))

(define-public r-pkgconfig
  (package
    (name "r-pkgconfig")
    (version "2.0.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pkgconfig" version))
              (sha256
               (base32
                "0l1qph8zyi2sic3k2qcd7vlfl7rzfh1q7z7zvjkl5f7y1x2fy3rk"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gaborcsardi/pkgconfig")
    (synopsis "Private configuration for R packages")
    (description "This package provides the functionality to set configuration
options on a per-package basis.  Options set by a given package only apply to
that package, other packages are unaffected.")
    (license license:expat)))

(define-public r-pkgmaker
  (package
    (name "r-pkgmaker")
    (version "0.32.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgmaker" version))
       (sha256
        (base32
         "0cr95vmsb4gkl917wg4wwq8jihvwasdg18qzhk2cq224lrrh8awp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-codetools
           r-digest
           r-registry
           r-stringr
           r-withr
           r-xtable))
    (native-inputs (list r-testthat))
    (home-page "https://renozao.github.io/pkgmaker")
    (synopsis "Package development utilities")
    (description
     "This package provides some low-level utilities to use for R package
development.  It currently provides managers for multiple package specific
options and registries, vignette, unit test and bibtex related utilities.")
    (license license:gpl2+)))

(define-public r-plotly
  (package
    (name "r-plotly")
    (version "4.10.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "plotly" version))
              (sha256
               (base32
                "0ryqcs9y7zan36zs6n1hxxy91pajldpax8q7cwcimlsmxnvrbafg"))
              (modules '((guix build utils)))
              (snippet
               '(with-directory-excursion "inst/htmlwidgets/lib/"
                  (for-each delete-file
                            '("plotlyjs/plotly-latest.min.js"
                              "colourpicker/colourpicker.min.js"
                              "typedarray/typedarray.min.js"
                              "selectize/selectize.min.js"))))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Tests require internet access.
      #:tests? #false
      #:modules '((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/"
               (symlink (string-append (assoc-ref inputs "js-selectize")
                                       "/share/javascript/selectize.min.js")
                        "selectize/selectize.min.js")
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-plotly")
                         "plotlyjs/plotly-latest.min.js")
                        (,(string-append (assoc-ref inputs "js-colourpicker")
                                         "/js/colourpicker.js")
                         "colourpicker/colourpicker.min.js")
                        (,(string-append (assoc-ref inputs "js-typedarray")
                                         "/typedarray.js")
                         "typedarray/typedarray.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-base64enc
           r-crosstalk
           r-data-table
           r-digest
           r-dplyr
           r-ggplot2
           r-htmltools
           r-htmlwidgets
           r-httr
           r-jsonlite
           r-lazyeval
           r-magrittr
           r-promises
           r-purrr
           r-rcolorbrewer
           r-rlang
           r-scales
           r-tibble
           r-tidyr
           r-vctrs
           r-viridislite))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-colourpicker"
        ,(let ((commit "27c2a266d51e18a9fe6d7542264152b27c7d34e0")
               (version "1.1")
               (revision "0"))
           (origin
             (method git-fetch)
             (uri (git-reference
                   (url "https://github.com/daattali/jquery-colourpicker")
                   (commit commit)))
             (file-name (git-file-name "jquery-colourpicker"
                                       (git-version version revision commit)))
             (sha256
              (base32
               "0lg8amh8xh6p246j38rqghrljd7v5z34i169ra6403z8ga33wiqb")))))
       ("js-plotly"
        ,(let ((version "2.11.1"))
           (origin
             (method url-fetch)
             (uri (string-append "https://raw.githubusercontent.com/plotly/plotly.js/v"
                                 version "/dist/plotly.js"))
             (sha256
              (base32
               "1mxd8s4v3i885w5i02cyzqsrvqfr9w0svdclvqxbd05dly4bdkbj")))))
       ("js-selectize" ,js-selectize)
       ;; This is not quite the same as the bundled minified script from 2016,
       ;; but it seems to be the original with fixes from late 2017.
       ("js-typedarray"
        ,(let ((commit "9f7d4168657e2c164d647a6959f402f2c33eb5b4")
               (version "0")
               (revision "0"))
           (origin
             (method git-fetch)
             (uri (git-reference
                   (url "https://github.com/inexorabletash/polyfill/")
                   (commit commit)))
             (file-name (git-file-name "typedarray-polyfill"
                                       (git-version version revision commit)))
             (sha256
              (base32
               "0f9np4mmyhny03n3xpwzs07rld30lnfqsnh97x1v7xm0qy0zjanf")))))))
    (home-page "https://plot.ly/r")
    (synopsis "Create interactive web graphics")
    (description
     "This package enables the translation of ggplot2 graphs to an interactive
web-based version and/or the creation of custom web-based visualizations
directly from R.  Once uploaded to a plotly account, plotly graphs (and the
data behind them) can be viewed and modified in a web browser.")
    (license license:x11)))

(define-public r-plotrix
  (package
    (name "r-plotrix")
    (version "3.8-4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "plotrix" version))
              (sha256
               (base32
                "1mp8mb79prgf5fzlaix4fvslr4q67hrzxqdv3kr7mik1mf9jv8p6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/plotrix")
    (synopsis "Various plotting functions")
    (description
     "This package provides lots of plotting, various labeling, axis and color
scaling functions for R.")
    (license license:gpl2+)))

(define-public r-plyr
  (package
    (name "r-plyr")
    (version "1.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plyr" version))
       (sha256
        (base32 "00z1mvqisnzbbwcwax1gm9ilahpgp21kk4l7hqdz8fym27vygd8m"))))
    (build-system r-build-system)
    (properties
     '((updater-extra-native-inputs . ("r-abind"))))
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-abind r-testthat))
    (home-page "http://had.co.nz/plyr")
    (synopsis "Tools for splitting, applying and combining data")
    (description
     "Plyr is a set of tools that solves a common set of problems: you need to
break a big problem down into manageable pieces, operate on each piece and
then put all the pieces back together.  For example, you might want to fit a
model to each spatial location or time point in your study, summarise data by
panels or collapse high-dimensional arrays to simpler summary statistics.")
    (license license:expat)))

(define-public r-pma
  (package
    (name "r-pma")
    (version "1.2-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PMA" version))
       (sha256
        (base32 "0mq0mchvl4zlj1sgnq7z5ccm0f4lhxajqvk9w265axs0s49g76ry"))))
    (properties `((upstream-name . "PMA")))
    (build-system r-build-system)
    (home-page "https://github.com/bnaras/PMA")
    (synopsis "Penalized multivariate analysis")
    (description
     "This package performs penalized multivariate analysis: a penalized
matrix decomposition, sparse principal components analysis, and sparse
canonical correlation analysis.")
    (license license:gpl2+)))

(define-public r-pmml
  (package
    (name "r-pmml")
    (version "2.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pmml" version))
       (sha256
        (base32 "1faad5yqyh6dx40056w74vlyw4wxjgh41jv8b2vf2gh26laf22kk"))))
    (properties `((upstream-name . "pmml")))
    (build-system r-build-system)
    (propagated-inputs (list r-stringr r-xml))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://open-source.softwareag.com/r-pmml/")
    (synopsis "Generate PMML for various models")
    (description
     "The Predictive Model Markup Language (PMML) is an XML-based language
which provides a way for applications to define machine learning, statistical
and data mining models and to share models between PMML compliant
applications.  More information about the PMML industry standard and the Data
Mining Group can be found at @url{http://dmg.org/}.  The generated PMML can be
imported into any PMML consuming application, such as Zementis Predictive
Analytics products.")
    (license license:gpl3)))

(define-public r-prabclus
  (package
    (name "r-prabclus")
    (version "2.3-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prabclus" version))
       (sha256
        (base32
         "0wmcw0iz0a4q0x83v36ldv8b67czcpw3g18v68i3v9284rbj6xnd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-mclust))
    (native-inputs (list r-spatialreg r-spdep))
    (home-page "https://cran.r-project.org/web/packages/prabclus")
    (synopsis "Parametric bootstrap tests for spatial neighborhood clustering")
    (description
     "This package provides distance-based parametric bootstrap tests for
clustering with spatial neighborhood information.  It implements some distance
measures, clustering of presence-absence, abundance and multilocus genetical
data for species delimitation, nearest neighbor based noise detection.")
    (license license:gpl2+)))

(define-public r-praise
  (package
    (name "r-praise")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "praise" version))
       (sha256
        (base32
         "1gfyypnvmih97p2r0php9qa39grzqpsdbq5g0fdsbpq5zms5w0sw"))))
    (properties
     ;; We can't have r-testthat among the inputs here to avoid a dependency
     ;; cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, which depends on r-praise.
    (arguments (list #:tests? #false))
    (home-page "https://github.com/gaborcsardi/praise")
    (synopsis "Functions to praise users")
    (description
     "This package provides template functions to assist in building friendly
R packages that praise their users.")
    (license license:expat)))

(define-public r-propcis
  (package
    (name "r-propcis")
    (version "0.3-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PropCIs" version))
       (sha256
        (base32 "1ywzi88igzaj2wnbrqa08cy7pw886z2m0x3j7rk45rin9mgpfdfd"))))
    (properties `((upstream-name . "PropCIs")))
    (build-system r-build-system)
    (home-page "https://github.com/shearer/PropCIs")
    (synopsis "Various confidence interval methods for proportions")
    (description
     "This package computes two-sample confidence intervals for single, paired
and independent proportions.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-proto
  (package
    (name "r-proto")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "proto" version))
       (sha256
        (base32 "1l843p8vckjckdhgv37ngv47fga5jzy0n00pmipvp05nnaixk54j"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/proto")
    (synopsis "Prototype object-based programming")
    (description
     "Proto is an object oriented system using object-based, also called
prototype-based, rather than class-based object oriented ideas.")
    (license license:gpl2+)))

(define-public r-pryr
  (package
    (name "r-pryr")
    (version "0.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pryr" version))
              (sha256
               (base32
                "013p2xxd51kr9ddx051cvn45mzgj44fm47nkchdb13l0885a7hb8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-codetools r-lobstr r-rcpp r-stringr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/pryr")
    (synopsis "Tools for computing on the R language")
    (description
     "This package provides useful tools to pry back the covers of R and
understand the language at a deeper level.")
    (license license:gpl2)))

(define-public r-puniform
  (package
    (name "r-puniform")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "puniform" version))
       (sha256
        (base32
         "15q5wlcps7387rjz7p1f5kifg1fl5yxxy7gjx6fvspvqwjkjbs4z"))))
    (properties `((upstream-name . "puniform")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-adgoftest r-metafor r-numderiv r-rcpp r-rcpparmadillo))
    (home-page
     "https://github.com/RobbievanAert/puniform")
    (synopsis
     "Meta-Analysis Methods Correcting for Publication Bias")
    (description
     "This package provides meta-analysis methods that correct for publication
bias and outcome reporting bias.  Four methods and a visual tool are currently
included in the package.

@enumerate
@item The p-uniform method as described in van Assen, van Aert, and Wicherts
(2015) @url{doi:10.1037/met0000025} can be used for estimating the average
effect size, testing the null hypothesis of no effect, and testing for
publication bias using only the statistically significant effect sizes of
primary studies.

@item The p-uniform* method as described in van Aert and van Assen (2019)
@url{doi:10.31222/osf.io/zqjr9}.  This method is an extension of the p-uniform
method that allows for estimation of the average effect size and the
between-study variance in a meta-analysis, and uses both the statistically
significant and nonsignificant effect sizes.

@item The hybrid method as described in van Aert and van Assen (2017)
@url{doi:10.3758/s13428-017-0967-6}.  The hybrid method is a meta-analysis
method for combining an original study and replication and while taking into
account statistical significance of the original study.  The p-uniform and
hybrid method are based on the statistical theory that the distribution of
p-values is uniform conditional on the population effect size.

@item The fourth method in the package is the Snapshot Bayesian Hybrid
Meta-Analysis Method as described in van Aert and van Assen (2018)
@url{doi:10.1371/journal.pone.0175302}.  This method computes posterior
probabilities for four true effect sizes (no, small, medium, and large) based
on an original study and replication while taking into account publication
bias in the original study.  The method can also be used for computing the
required sample size of the replication akin to power analysis in null
hypothesis significance testing.  @end enumerate

The meta-plot is a visual tool for meta-analysis that provides information on
the primary studies in the meta-analysis, the results of the meta-analysis,
and characteristics of the research on the effect under study (van Assen and
others, 2020).

Helper functions to apply the Correcting for Outcome Reporting Bias (CORB)
method to correct for outcome reporting bias in a meta-analysis (van Aert &
Wicherts, 2020).")
    (license license:gpl2+)))

(define-public r-purrr
  (package
    (name "r-purrr")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "purrr" version))
       (sha256
        (base32
         "0m4fkd047z0p7pd0vp819h6x6n7rmrmi53kvdbjslp8wclj3f0bc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-lifecycle r-magrittr r-rlang r-vctrs))
    (native-inputs
     (list r-knitr r-lubridate r-testthat r-tibble r-tidyselect))
    (home-page "https://github.com/hadley/purrr")
    (synopsis "Functional programming tools")
    (description
     "This package completes R's functional programming tools with missing
features present in other programming languages.")
    (license license:gpl3+)))

(define-public r-rcolorbrewer
  (package
    (name "r-rcolorbrewer")
    (version "1.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RColorBrewer" version))
       (sha256
        (base32 "1h0s0f4vvlk40cagp3qwhd0layzkjcnqkiwjyhwqns257i1gahjg"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/RColorBrewer")
    (synopsis "ColorBrewer palettes")
    (description
     "This package provides color schemes for maps (and other graphics)
designed by Cynthia Brewer as described at http://colorbrewer2.org")
    ;; Includes code licensed under bsd-4
    (license license:asl2.0)))

(define-public r-reshape2
  (package
    (name "r-reshape2")
    (version "1.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reshape2" version))
       (sha256
        (base32 "1n0jrajpvc8hjkh9z4g8bwq63qy5vy5cgl2pzjardyih4ngcz3fq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcpp r-stringr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/reshape")
    (synopsis "Flexibly reshape data: a reboot of the \"reshape\" package")
    (description
     "Reshape2 is an R library to flexibly restructure and aggregate data
using just two functions: melt and dcast (or acast).")
    (license license:expat)))

(define-public r-robslopes
  (package
    (name "r-robslopes")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "robslopes" version))
       (sha256
        (base32 "0hhdpp03ybf71x6wz766glqlq4ywc4v65mj0ca3idv69p488mvb5"))))
    (properties `((upstream-name . "robslopes")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo))
    (home-page "https://cran.r-project.org/package=robslopes")
    (synopsis "Fast algorithms for robust slopes")
    (description
     "This package provides fast algorithms for the Theil-Sen estimator,
Siegel's repeated median slope estimator, and Passing-Bablok regression.  The
implementation is based on algorithms by Dillencourt et al. (1992)
<doi:10.1142/S0218195992000020> and Matousek et al. (1998)
<doi:10.1007/PL00009190>.  The implementations are detailed in
Raymaekers (2023) <doi:10.32614/RJ-2023-012> and Raymaekers J., Dufey
F. (2022) <@code{arXiv:2202.08060>}.  All algorithms run in quasilinear
time.")
    (license license:gpl2+)))

(define-public r-robustrankaggreg
  (package
    (name "r-robustrankaggreg")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RobustRankAggreg" version))
       (sha256
        (base32 "0p2nbgxv2132gcyx7zq2gzl6ipsxndx64i7y8v9nh5awcdy8v44p"))))
    (properties `((upstream-name . "RobustRankAggreg")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=RobustRankAggreg")
    (synopsis "Methods for robust rank aggregation")
    (description
     "This tool provides methods for aggregating ranked lists, especially
lists of genes.  It implements the Robust Rank Aggregation and other simple
algorithms for the task.  RRA method uses a probabilistic model for
aggregation that is robust to noise and also facilitates the calculation of
significance probabilities for all the elements in the final ranking.")
    (license license:gpl2)))

(define-public r-rose
  (package
    (name "r-rose")
    (version "0.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROSE" version))
       (sha256
        (base32 "0y3v9zkgaxpv4f4zn22ra1gkkqg5hdz8js47ppciqahfydjbfl3p"))))
    (properties `((upstream-name . "ROSE")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=ROSE")
    (synopsis "Random over-sampling examples")
    (description
     "This package provides functions to deal with binary classification
problems in the presence of imbalanced classes.  Synthetic balanced samples
are generated according to ROSE (Menardi and Torelli, 2013).  Functions that
implement more traditional remedies to the class imbalance are also provided,
as well as different metrics to evaluate a learner accuracy.  These are
estimated by holdout, bootstrap or cross-validation methods.")
    (license license:gpl2)))

(define-public r-rotor
  (package
    (name "r-rotor")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rotor" version))
       (sha256
        (base32 "02mzcwd94hykysz3cv0q3dlhbbd4k3rm1di7dcw6m4masgzy05zb"))))
    (properties
     `((upstream-name . "rotor")
       (updater-extra-native-inputs . ("r-data-table"))))
    (build-system r-build-system)
    (propagated-inputs (list r-dint r-r6))
    (native-inputs (list r-data-table r-testthat))
    (home-page "https://s-fleck.github.io/rotor/")
    (synopsis "Log rotation and conditional backups")
    (description
     "This package provides tools to conditionally rotate or back-up files
based on their size or the date of the last backup; inspired by the utility
@code{logrotate}'.")
    (license license:expat)))

(define-public r-rpart
  (package
    (name "r-rpart")
    (version "4.1.24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rpart" version))
       (sha256
        (base32
         "0a9gwwbq2ksx2v7kgrbn0liakkjbfvky1ahkjclpv1frcjknkcaa"))))
    (build-system r-build-system)
    (native-inputs (list r-survival))
    (home-page "https://cran.r-project.org/web/packages/rpart")
    (synopsis "Recursive partitioning and regression trees")
    (description
     "This package provides recursive partitioning functions for
classification, regression and survival trees.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-rpresto
  (package
    (name "r-rpresto")
    (version "1.4.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPresto" version))
       (sha256
        (base32 "0r4ajzd3ciicvsydacvm8gywhcr64mh1g5p2hjl1lrxzj09x4ckw"))))
    (properties
     '((upstream-name . "RPresto")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for failing tests, because lubridate needs these
         ;; variables.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-bit64
           r-dbi
           r-dbplyr
           r-dplyr
           r-httr
           r-jsonlite
           r-lifecycle
           r-lubridate
           r-openssl
           r-progress
           r-purrr
           r-rlang
           r-stringi
           r-tibble
           r-vctrs))
    (native-inputs (list r-hms r-knitr r-testthat r-withr tzdata-for-tests))
    (home-page "https://github.com/prestodb/RPresto")
    (synopsis "DBI connector to Presto")
    (description
     "This package implements a DBI compliant interface to
@url{https://prestodb.io/, Presto}, a distributed SQL query engine for running
interactive analytic queries against data sources of all sizes ranging from
gigabytes to petabytes.")
    (license license:bsd-3)))

(define-public r-rpushbullet
  (package
    (name "r-rpushbullet")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPushbullet" version))
       (sha256
        (base32 "1mx433hvx660a63s5dzn655zmqv1c1qij0hzddl9z38032brc4ii"))))
    (properties `((upstream-name . "RPushbullet")))
    (build-system r-build-system)
    (propagated-inputs (list r-curl r-jsonlite))
    (home-page "https://cran.r-project.org/package=RPushbullet")
    (synopsis "R interface to the Pushbullet messaging service")
    (description
     "An R interface to the Pushbullet messaging service which provides fast
and efficient notifications (and file transfer) between computers, phones and
tablets.")
    (license license:gpl2+)))

(define-public r-runner
  (package
    (name "r-runner")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "runner" version))
       (sha256
        (base32 "0vhqjnwcx3z3i74p26divx6palx1rwvk4jpqn64jrqlzaw9qich4"))))
    (properties `((upstream-name . "runner")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=runner")
    (synopsis "Running operations for vectors")
    (description
     "This package provides a library for rolling windows operations.
The package enables full control over the window length, window lag, and time
indices.  With a runner one can apply any R function on rolling windows.  The
package eases work with equally and unequally spaced time series.")
    (license license:gpl2+)))

(define-public r-rush
  (package
    (name "r-rush")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rush" version))
       (sha256
        (base32 "115k13k6qj8pq0h58y7qcknfw53x0qv4z0nrs446knc90rcwjscx"))))
    (properties `((upstream-name . "rush")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate
                             r-data-table
                             r-ids
                             r-jsonlite
                             r-lgr
                             r-mirai
                             r-mlr3misc
                             r-processx
                             r-r6
                             r-redux
                             r-uuid))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mlr-org/rush")
    (synopsis "Rapid parallel and distributed computing")
    (description
     "This is a package for parallel computing with a network of local and
remote workers.  It enables fast exchange of results between the workers
through a Redis database.  Key features include task queues, local caching,
and sophisticated error handling.")
    (license license:expat)))

(define-public r-prettydoc
  (package
    (name "r-prettydoc")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prettydoc" version))
              (sha256
               (base32
                "0aa89jnqhz0l69inrgm1f1riq5bm3ksb8wjl8d4x2f320adsd50h"))
              (snippet
               '(for-each delete-file
                          '("inst/resources/js/auto-render.min.js"
                            "inst/resources/js/katex.min.js")))))
    (properties `((upstream-name . "prettydoc")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/resources/js/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(search-input-file inputs "dist/katex.js")
                         "katex.min.js")
                        (,(search-input-file inputs "dist/contrib/auto-render.js")
                         "auto-render.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (inputs (list pandoc))
    (propagated-inputs (list r-rmarkdown))
    (native-inputs
     (list esbuild
           r-knitr
           r-rmarkdown
           (let ((version "0.12.0"))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/KaTeX/KaTeX")
                     (commit (string-append "v" version))))
               (file-name (git-file-name "js-katex" version))
               (sha256
                (base32
                 "0pdfw28affnfpqpnf244acf5rkxdy2gk63669myy7ysg4z0i1n8j"))))))
    (home-page "https://github.com/yixuan/prettydoc")
    (synopsis "Create pretty documents from R markdown")
    (description
     "This is a package for creating tiny yet beautiful documents and
vignettes from R Markdown.  The package provides the @code{html_pretty} output
format as an alternative to the @code{html_document} and @code{html_vignette}
engines that convert R Markdown into HTML pages.  Various themes and syntax
highlight styles are supported.")
    (license license:asl2.0)))

(define-public r-profmem
  (package
    (name "r-profmem")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "profmem" version))
       (sha256
        (base32 "1jy3d7sxmy4nqlrcrqqahgiy0lf0cb7pmh2iknf92y2b7zqwbvqn"))))
    (properties `((upstream-name . "profmem")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'install 'set-HOME
           (lambda _
             ;; Needed for building vignettes
             (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list r-r-rsp)) ;for vignettes
    (home-page "https://github.com/HenrikBengtsson/profmem")
    (synopsis "Simple memory profiling for R")
    (description
     "This package provides a simple and light-weight API for memory profiling
of R expressions.  The profiling is built on top of R's built-in memory
profiler @code{utils::Rprofmem()}, which records every memory allocation done
by R (also native code).")
    (license license:lgpl2.1+)))

(define-public r-proj4
  (package
    (name "r-proj4")
    (version "1.0-15")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "proj4" version))
              (sha256
               (base32
                "056ki0z22wqsp5d89ihrsb3xf2h1jiabgy420vc51qcikl27vk7f"))))
    (properties
     '((upstream-name . "proj4")
       (updater-extra-inputs . ("proj"))
       (updater-ignored-inputs . ("curl" "openssh" "openssl"))))
    (build-system r-build-system)
    (inputs (list proj zlib))
    (native-inputs (list pkg-config))
    (home-page "https://www.rforge.net/proj4/")
    (synopsis "Simple interface to the PROJ.4 cartographic projections library")
    (description
     "This package provides a simple interface to lat/long projection and
datum transformation of the PROJ.4 cartographic projections library.  It
allows transformation of geographic coordinates from one projection and/or
datum to another.")
    (license license:gpl2)))

(define-public r-rocit
  (package
    (name "r-rocit")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROCit" version))
       (sha256
        (base32 "17s7wi248vj6wbcxb6z0fdsw8bijjxva4sldlqcz4m73ccnrdikf"))))
    (properties `((upstream-name . "ROCit")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=ROCit")
    (synopsis "Performance Assessment of Binary Classifier with Visualization")
    (description
     "Sensitivity (or recall or true positive rate), false positive rate,
specificity, precision (or positive predictive value), negative predictive
value, misclassification rate, accuracy, F-score---these are popular metrics
for assessing performance of binary classifiers for certain thresholds.  These
metrics are calculated at certain threshold values.  @dfn{Receiver operating
characteristic} (ROC) curve is a common tool for assessing overall diagnostic
ability of the binary classifier.  Unlike depending on a certain threshold,
area under ROC curve (also known as AUC), is a summary statistic about how
well a binary classifier performs overall for the classification task.  The
ROCit package provides flexibility to easily evaluate threshold-bound
metrics.")
    (license license:gpl3)))

(define-public r-roi-plugin-lpsolve
  (package
    (name "r-roi-plugin-lpsolve")
    (version "1.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROI.plugin.lpsolve" version))
       (sha256
        (base32 "0xgg1fzq5sba3yvvrci3iw97p31walpnhv4zwnd39gw8v5z6f9dj"))))
    (properties `((upstream-name . "ROI.plugin.lpsolve")))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolveapi r-roi))
    (home-page "https://roigrp.gitlab.io")
    (synopsis "Plugin of lp_solve for the R optimization infrastructure")
    (description
     "This package enhances the @acronym{ROI, R Optimization Infrastructure} with
the lp_solve solver.")
    (license license:gpl3)))

(define-public r-rorcid
  (package
    (name "r-rorcid")
    (version "0.7.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rorcid" version))
              (sha256
               (base32
                "1d0s5w48ksyj152nc4xq5w0nsimab8jc5fgspdwnbas2g8a52igr"))))
    (properties `((upstream-name . "rorcid")))
    (build-system r-build-system)
    (propagated-inputs (list r-crul
                             r-data-table
                             r-fauxpas
                             r-httr
                             r-jsonlite
                             r-tibble
                             r-xml2))
    (native-inputs (list r-testthat r-vcr))
    (home-page "https://github.com/ropensci/rorcid")
    (synopsis "Interface to the @url{Orcid.org, https://orcid.org} API")
    (description
     "This package provides an API for @url{Orcid.org, https://orcid.org}.
Functions include searching for people, searching by DOI, or searching by
Orcid ID.")
    (license license:expat)))

(define-public r-rrna
  (package
    (name "r-rrna")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RRNA" version))
       (sha256
        (base32 "05ijsnxxylfan4c4hnl20655qjzix2l43i5qmdzm19wqcf4ipylp"))))
    (properties `((upstream-name . "RRNA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=RRNA")
    (synopsis "Secondary structure plotting for RNA")
    (description "This package facilitates RNA secondary structure plotting.")
    (license license:gpl3)))

(define-public r-ruv
  (package
    (name "r-ruv")
    (version "0.9.7.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ruv" version))
              (sha256
               (base32
                "1n4q9mrp9f644spbns6bbnzmlabrg90hwkdfg3hnm3rxp9b4xid0"))))
    (properties `((upstream-name . "ruv")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-gridextra r-scales))
    (home-page "https://cran.r-project.org/web/packages/ruv/index.html")
    (synopsis "Detect and remove unwanted variation using negative controls")
    (description
     "This package implements the RUV (Remove Unwanted Variation) algorithms.
These algorithms attempt to adjust for systematic errors of unknown origin in
high-dimensional data.  The algorithms were originally developed for use with
genomic data, especially microarray data, but may be useful with other types
of high-dimensional data as well.  The algorithms require the user to specify
a set of negative control variables, as described in the references.  The
algorithms included in this package are RUV-2, RUV-4, RUV-inv, RUV-rinv,
RUV-I, and RUV-III, along with various supporting algorithms.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-waldo
  (package
    (name "r-waldo")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "waldo" version))
       (sha256
        (base32
         "1jbn3vfykyv8czwqs6wbb8m172cl2fqgggy86n3h1rrg59rz7hy9"))))
    (properties
     ;; We can't add testthat here because of a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))
       (upstream-name . "waldo")))
    (build-system r-build-system)
    ;; Tests require r-testthat, which depends on this package.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli r-diffobj r-glue r-rlang))
    (home-page "https://github.com/r-lib/waldo")
    (synopsis "Find differences between R objects")
    (description
     "Compare complex R objects and reveal the key differences.  This package
was designed particularly for use in testing packages where being able to
quickly isolate key differences makes understanding test failures much
easier.")
    (license license:expat)))

;; We use the git repository, because it contains the JavaScript source code.
;; We have to use this seemingly arbitrary commit after 0.2.5, because the
;; sources for placeholder.js were not included in the latest release.
(define-public r-waiter
  (let ((commit "927501bfa41c37e33d13a90bbc329a2887e0cec0")
        (revision "1"))
    (package
      (name "r-waiter")
      (version (git-version "0.2.5" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/JohnCoene/waiter")
                      (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0s5d09srd1d1s35lp2fb93dvyfkjv1rasbl25ps1p137jv7zn079"))
                (modules '((guix build utils)))
                (snippet
                 '(delete-file-recursively "inst/packer"))))
      (properties `((upstream-name . "waiter")))
      (build-system r-build-system)
      (arguments
       (list
        #:modules
        '((guix build r-build-system)
          (guix build minify-build-system)
          (guix build utils))
        #:imported-modules
        `(,@%r-build-system-modules
          (guix build minify-build-system))
        #:phases
        '(modify-phases (@ (guix build r-build-system) %standard-phases)
           (add-after 'unpack 'process-javascript
             (lambda* (#:key inputs #:allow-other-keys)
               (mkdir-p "inst/packer")
               (call-with-output-file "build.js"
                 (lambda (port)
                   (display "\
const esbuild = require('esbuild');
const path = require('path');
const fs = require('fs');

// Define the entries and output directory
const entries = {
  'waiter': './srcjs/exts/waiter/waiter.js',
  'waitress': './srcjs/exts/waitress/waitress.js',
  'hostess': './srcjs/exts/hostess/hostess.js',
  'attendant': './srcjs/exts/attendant/attendant.js',
  'placeholder': './srcjs/exts/placeholder/placeholder.js'
};

// A little plugin to inject the CSS into the generated JavaScript file.
let style = {
  name: 'style',
  setup(build) {
    const cwd = process.cwd();
    const opt = {
      logLevel: 'silent',
      bundle: true,
      write: false,
      minify: true,
      charset: 'utf8'
    };

    build.onResolve({ filter: /\\.css$/, namespace: 'file' }, args => {
      const absPath = path.join(args.resolveDir, args.path);
      const relPath = path.relative(cwd, absPath);
      const resolved = fs.existsSync(absPath) ? relPath : args.path;
      return { path: resolved, namespace: 'style-stub' };
    });

    build.onResolve({ filter: /\\.css$/, namespace: 'style-stub' }, args => {
      return { path: args.path, namespace: 'style-content' };
    });

    build.onResolve({ filter: /^__style_helper__$/, namespace: 'style-stub' }, args => ({
      path: args.path,
      namespace: 'style-helper',
      sideEffects: false,
    }));

    build.onLoad({ filter: /.*/, namespace: 'style-helper' }, async () => ({
      contents: `
        export function injectStyle(text) {
          if (typeof document !== 'undefined') {
            var style = document.createElement('style')
            var node = document.createTextNode(text)
            style.appendChild(node)
            document.head.appendChild(style)
          }
        }
      `,
    }));

    build.onLoad({ filter: /.*/, namespace: 'style-stub' }, async args => ({
      contents: `
        import { injectStyle } from \"__style_helper__\"
        import css from ${JSON.stringify(args.path)}
        injectStyle(css)
      `,
    }));

    build.onLoad({ filter: /.*/, namespace: 'style-content' }, async args => {
      const options = { entryPoints: [args.path], ...opt };
      const { errors, warnings, outputFiles } = await esbuild.build(options);
      return { errors, warnings, contents: outputFiles[0].text, loader: \"text\" };
    });
  },
};

esbuild.build({
  entryPoints: Object.values(entries),
  entryNames: '[name]',
  outdir: './inst/packer',
  bundle: true,
  minify: true,
  format: 'iife',
  globalName: 'waiter',
  external: ['shiny', 'jquery'],
  loader: {
    '.js': 'js',
  },
  plugins: [style]
})
" port)))
               (install-file (search-input-file inputs "/dist/loading-bar.js")
                             "srcjs/exts/hostess")
               (install-file (search-input-file inputs "/dist/loading-bar.css")
                             "srcjs/exts/hostess")
               (substitute* "srcjs/exts/hostess/hostess.js"
                 (("@loadingio/loading-bar/lib/") "./")
                 (("@loadingio/loading-bar/dist/") "./"))
               (setenv "ESBUILD_BINARY_PATH" (search-input-file inputs "/bin/esbuild"))
               (invoke "node" "build.js")

               ;; Almost forgot this one...
               (minify (search-input-file inputs "loadgo-nojquery.js")
                       #:target
                       "inst/assets/garcon/garcon.min.js"))))))
      (propagated-inputs (list r-htmltools r-r6 r-shiny))
      (native-inputs
       (list node-esbuild node-lts r-knitr
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/loadingio/loading-bar")
                     (commit "0.1.0")))
               (file-name (git-file-name "js-loading-bar" "0.1.0"))
               (sha256
                (base32
                 "12z8m362k3gldkjhx3l65zrw7ifqkz21zgv9b2hw6ai5blkd33nv")))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/franverona/loadgo")
                     (commit "2.2.1")))
               (file-name (git-file-name "js-loadgo" "2.2.1"))
               (sha256
                (base32
                 "1n11lhlv5i48xm0x7hj296lv363dbx4cldg12vr07q01pvj5fbdl")))))
      (home-page "https://waiter.john-coene.com/")
      (synopsis "Loading screen for Shiny")
      (description
       "This package provides full screen and partial loading screens for
Shiny with spinners, progress bars, and notifications.")
      (license license:expat))))

(define-public r-wheatmap
  (package
    (name "r-wheatmap")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "wheatmap" version))
              (sha256
               (base32
                "064idlrnb85xxav39gp3n854fic6514khvazrf5d0x48crpzyvdp"))))
    (properties `((upstream-name . "wheatmap")))
    (build-system r-build-system)
    (propagated-inputs (list r-colorspace r-rcolorbrewer))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/zwdzwd/wheatmap")
    (synopsis "Incrementally build complex plots using natural semantics")
    (description
     "This package lets you build complex plots, heatmaps in particular, using
natural semantics.  Bigger plots can be assembled using directives such as
@code{LeftOf}, @code{RightOf}, @code{TopOf}, and @code{Beneath} and more.
Other features include clustering, dendrograms and integration with ggplot2
generated grid objects.  This package is particularly designed for
bioinformaticians to assemble complex plots for publication.")
    (license license:gpl3)))

(define-public r-whoami
  (package
    (name "r-whoami")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "whoami" version))
       (sha256
        (base32 "19fwl7z55s4kl2xzwqwh8iwg13kdrv222vyl3kibxgwrjcjwj2y2"))))
    (properties `((upstream-name . "whoami")))
    (build-system r-build-system)
    (propagated-inputs (list r-httr r-jsonlite))
    (native-inputs (list r-mockery r-testthat r-withr))
    (home-page "https://github.com/r-lib/whoami#readme")
    (synopsis
     "Username, full name, email address, GitHub username of the current user")
    (description
     "Look up the username and full name of the current user, the current
user's email address and GitHub username, using various sources of system and
configuration information.")
    (license license:expat)))

(define-public r-rtdists
  (package
    (name "r-rtdists")
    (version "0.11-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rtdists" version))
       (sha256
        (base32 "1v8yhyvliw3dm3ciwxxaa9spfw05wp334l7gmvgv20mab2kjxkwp"))))
    (properties `((upstream-name . "rtdists")))
    (build-system r-build-system)
    (propagated-inputs (list r-evd r-gsl r-msm r-rcpp))
    (native-inputs (list r-devtools r-glba r-knitr r-rwiener r-testthat))
    (home-page "https://github.com/rtdists/rtdists/")
    (synopsis "Response Time Distributions")
    (description
     "This package provides response time distributions (density/PDF,
distribution function/CDF, quantile function, and random generation):

@itemize
@item Ratcliff diffusion model (Ratcliff & @code{McKoon}, 2008,
<doi:10.1162/neco.2008.12-06-420>) based on C code by Andreas and Jochen Voss
and
@item linear ballistic accumulator (LBA; Brown & Heathcote, 2008,
<doi:10.1016/j.cogpsych.2007.12.002>) with different distributions underlying
the drift rate.
@end itemize
")
    (license license:gpl3+)))

(define-public r-rticles
  (package
    (name "r-rticles")
    (version "0.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rticles" version))
       (sha256
        (base32
         "1a5i8vzcf058dqk30yir3ngs02f17s4d0b0px31pxa0d1ak1yfh7"))))
    (properties `((upstream-name . "rticles")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-knitr r-lifecycle r-rmarkdown r-tinytex r-xfun r-yaml))
    (native-inputs (list r-testit r-testthat r-withr))
    (home-page "https://github.com/rstudio/rticles")
    (synopsis "Article formats for R Markdown")
    (description
     "This package provides a suite of custom R Markdown formats and templates
for authoring journal articles and conference submissions.")
    (license license:gpl3)))

(define-public r-rtk
  (package
    (name "r-rtk")
    (version "0.2.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rtk" version))
       (sha256
        (base32 "1xafmp5y5p8fnsh16wj8n08x69v2hawnsvsy7g4dcz1i5xkhyc0m"))))
    (properties `((upstream-name . "rtk")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp zlib))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=rtk")
    (synopsis "Rarefaction tool kit")
    (description "This package lets you rarefy data, calculate diversity and
plot the results.")
    (license license:gpl2+)))

(define-public r-babelwhale
  (package
    (name "r-babelwhale")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "babelwhale" version))
       (sha256
        (base32 "0m5q83ykz5w1fsjsk2vyrnv21cg4n075kbvfvw4k22c61p78shdl"))))
    (properties `((upstream-name . "babelwhale")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-digest
           r-dplyr
           r-dynutils
           r-fs
           r-glue
           r-processx
           r-purrr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dynverse/babelwhale")
    (synopsis "Talking to Docker and Singularity containers")
    (description
     "This package provides a unified interface to interact with Docker and
Singularity containers.  You can execute a command inside a container, mount a
volume or copy a file.")
    (license license:expat)))

(define-public r-bench
  (package
    (name "r-bench")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bench" version))
       (sha256
        (base32 "10yhn778l8am8fq9gfb6n5gfd4nf6bls9k3da5mwrvldcjvza8mq"))))
    (properties `((upstream-name . "bench")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue r-pillar r-profmem r-rlang r-tibble))
    (native-inputs (list r-ggplot2 r-testthat r-tidyr r-vctrs r-withr))
    (home-page "https://bench.r-lib.org/")
    (synopsis "High precision timing of R expressions")
    (description
     "This package provides tools to accurately benchmark and analyze execution
times for R expressions.")
    (license license:expat)))

(define-public r-benchmarkmedata
  (package
    (name "r-benchmarkmedata")
    (version "1.0.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "benchmarkmeData" version))
              (sha256
               (base32
                "1n4vjkagqlm6kw2hilf4gjfcdjad0bcg652j9nl2ygbq3kdnh1vf"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/csgillespie/benchmarkme-data")
    (synopsis "Data set for the @code{benchmarkme} package")
    (description "This package contains the data set for the crowd-sourced
benchmarks from running the @code{benchmarkme} package.")
    (license license:gpl2+)))

(define-public r-benchmarkme
  (package
    (name "r-benchmarkme")
    (version "1.0.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "benchmarkme" version))
              (sha256
               (base32
                "0qaz8wy3n08k9lr8qljk5i8z8db18scbdc8m734aymd307h00w8x"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (propagated-inputs
     (list r-benchmarkmedata
           r-doparallel
           r-dplyr
           r-foreach
           r-httr
           r-matrix
           r-stringr
           r-tibble))
    (home-page "https://csgillespie.github.io/benchmarkme/")
    (synopsis "Crowd-sourced system benchmarks")
    (description "This package provides functionality to benchmark your CPU
and compare against other CPUs.  Also provides functions for obtaining system
specifications, such as RAM, CPU type, and R version.")
    (license license:gpl2+)))

(define-public r-bestnormalize
  (package
    (name "r-bestnormalize")
    (version "1.9.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bestNormalize" version))
              (sha256
               (base32
                "1lryl23jvf51n7ka58ncwhjglk0zzm18wik962h403j4mph1jjly"))))
    (properties `((upstream-name . "bestNormalize")))
    (build-system r-build-system)
    (propagated-inputs (list r-butcher
                             r-doparallel
                             r-dorng
                             r-dplyr
                             r-foreach
                             r-generics
                             r-lambertw
                             r-nortest
                             r-purrr
                             r-recipes
                             r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://petersonr.github.io/bestNormalize/")
    (synopsis "Normalizing transformation functions")
    (description
     "Estimate a suite of normalizing transformations, including a new
adaptation of a technique based on ranks which can guarantee normally
distributed transformed data if there are no ties: @dfn{ordered quantile
normalization} (ORQ).  ORQ normalization combines a rank-mapping approach with
a shifted logit approximation that allows the transformation to work on data
outside the original domain.  It is also able to handle new data within the
original domain via linear interpolation.  The package is built to estimate
the best normalizing transformation for a vector consistently and accurately.
It implements the Box-Cox transformation, the Yeo-Johnson transformation,
three types of Lambert WxF transformations, and the ordered quantile
normalization transformation.  It estimates the normalization efficacy of
other commonly used transformations, and it allows users to specify custom
transformations or normalization statistics.  Finally, functionality can be
integrated into a machine learning workflow via recipes.")
    (license license:gpl3)))

(define-public r-bezier
  (package
    (name "r-bezier")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "bezier" version))
              (sha256
               (base32
                "1vw5128v8h973xwa1fdm9cw2jvrldj87nd55lddlp3qsz3ag4br6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bezier/")
    (synopsis "Bezier curve and spline toolkit")
    (description
     "This package is a toolkit for working with Bezier curves and splines.
The package provides functions for point generation, arc length estimation,
degree elevation and curve fitting.")
    (license license:gpl2+)))

(define-public r-bife
  (package
    (name "r-bife")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bife" version))
       (sha256
        (base32 "0xikxniwzcv6jc64rgx39hddqchxk6c43h45algssbz2vaxvc4zg"))))
    (properties `((upstream-name . "bife")))
    (build-system r-build-system)
    (propagated-inputs (list r-data-table r-formula r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/amrei-stammann/bife")
    (synopsis "Binary choice models with fixed effects")
    (description
     "This package lets you estimate fixed effects binary choice models (logit
and probit) with potentially many individual fixed effects and compute average
partial effects.  Incidental parameter bias can be reduced with an asymptotic
bias correction proposed by Fernandez-Val (2009)
<doi:10.1016/j.jeconom.2009.02.007>.")
    (license license:gpl2+)))

(define-public r-biglm
  (package
    (name "r-biglm")
    (version "0.9-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "biglm" version))
       (sha256
        (base32 "0n0dkazq74s3lml0ds9l38kzgapckjrvwyi62qb1y14cqlylhpc0"))))
    (properties `((upstream-name . "biglm")))
    (build-system r-build-system)
    (propagated-inputs (list r-dbi))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=biglm")
    (synopsis "Bounded memory linear and generalized linear models")
    (description "The biglm package lets you create a linear model object that
uses only code{p^2} memory for @code{p} variables.  It can be updated with
more data using @code{update}. This allows linear regression on data sets
larger than memory.")
    ;; Expanded from GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-bipartite
  (package
    (name "r-bipartite")
    (version "2.21")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bipartite" version))
       (sha256
        (base32 "191jr9675fjjhsrk5kvs0qngq7sg6yr8wsh78g5zk0g4qi6rbrwx"))))
    (properties `((upstream-name . "bipartite")))
    (build-system r-build-system)
    (propagated-inputs (list r-corpcor
                             r-fields
                             r-igraph
                             r-mass
                             r-permute
                             r-sna
                             r-vegan))
    (native-inputs (list r-devtools r-hmisc r-knitr))
    (home-page "https://github.com/biometry/bipartite")
    (synopsis
     "Visualising bipartite networks and calculating ecological indices")
    (description
     "This package provides functions to visualise webs and calculate a series
of indices commonly used to describe pattern in (ecological) webs.  It focuses
on webs consisting of only two levels (bipartite), e.g. pollination webs or
predator-prey-webs.  Visualisation is important to get an idea of what we are
actually looking at, while the indices summarise different aspects of the
web's topology.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-bwstest
  (package
    (name "r-bwstest")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BWStest" version))
       (sha256
        (base32 "1chlszmshda84000jj4q5j2swflj512vfj3h97361aphzhkwri2b"))))
    (properties `((upstream-name . "BWStest")))
    (build-system r-build-system)
    (propagated-inputs (list r-memoise r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/shabbychef/BWStest")
    (synopsis "Baumgartner Weiss Schindler Test of equal distributions")
    (description
     "This package performs the Baumgartner-Weiss-Schindler two-sample test of
equal probability distributions (doi:10.2307/2533862).  It also performs
similar rank-based tests for equal probability distributions due to Neuhauser
(doi:10.1080/10485250108832874) and Murakami
(doi:10.1080/00949655.2010.551516).")
    (license license:lgpl3)))

(define-public r-v8
  (package
    (name "r-v8")
    (version "6.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "V8" version))
       (sha256
        (base32
         "1kwwmgnn2qbr8avgmaxdp0gg4rwqzra8x5w13bhd4vfw9jh5mpvv"))))
    (properties
     `((upstream-name . "V8")
       (updater-extra-inputs . ("libnode"))))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'find-v8
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "configure"
               (("^PKG_LIBS=.*")
                (string-append "PKG_LIBS="
                               (assoc-ref inputs "libnode")
                               "/lib/libnode.so.127\n")))
             (setenv "INCLUDE_DIR"
                     (string-append
                      (assoc-ref inputs "libnode")
                      "/include/node"))
             (setenv "LIB_DIR"
                     (string-append
                      (assoc-ref inputs "libnode") "/lib")))))))
    (inputs
     (list libnode zlib))
    (propagated-inputs
     (list r-curl r-jsonlite r-rcpp))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://jeroen.cran.dev/V8")
    (synopsis "Embedded JavaScript and WebAssembly engine for R")
    (description
     "This package provides an R interface to V8: Google's JavaScript and
WebAssembly engine.")
    (license license:expat)))

(define-public r-vcr
  (package
    (name "r-vcr")
    (version "1.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vcr" version))
       (sha256
        (base32 "0spz4wfglj7gd3fh1cv4bc1lf98m1ialay3vzyhzb1n2fq6812k7"))))
    (properties '((upstream-name . "vcr")))
    (build-system r-build-system)
    ;; Some tests require Internet access.
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-base64enc
                             r-crul
                             r-httr
                             r-httr2
                             r-r6
                             r-rprojroot
                             r-urltools
                             r-webmockr
                             r-yaml))
    (native-inputs (list r-curl
                         r-jsonlite
                         r-knitr
                         r-testthat
                         r-webfakes
                         r-withr))
    (home-page "https://github.com/ropensci/vcr/")
    (synopsis "Record HTTP calls to disk")
    (description
     "This package lets you record test suite HTTP requests and replay them
during future runs.  It works by hooking into the @code{webmockr} R package
for matching HTTP requests by various rules, and then caching real HTTP
responses on disk in cassettes.  Subsequent HTTP requests matching any
previous requests in the same cassette use a cached HTTP response.")
    (license license:expat)))

(define-public r-venn
  (package
    (name "r-venn")
    (version "1.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "venn" version))
       (sha256
        (base32 "07bjv0m21gljdr3sj1z9rp6xhgxspah9j1m3a8rskvlwv6dvd1pd"))))
    (properties `((upstream-name . "venn")))
    (build-system r-build-system)
    (propagated-inputs (list r-admisc))
    (home-page "https://github.com/dusadrian/venn")
    (synopsis "Draw Venn diagrams")
    (description
     "This package provides a close to zero dependency package to draw and
display Venn diagrams up to 7 sets, and any Boolean union of set
intersections.")
    (license license:gpl3+)))

(define-public r-rvenn
  (package
    (name "r-rvenn")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RVenn" version))
       (sha256
        (base32
         "016m00xv59lkwm2is32v5nr4lw5a1ymdnz34r3ffflcv9bfrc6n4"))))
    (properties `((upstream-name . "RVenn")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggforce
           r-ggplot2
           r-magrittr
           r-pheatmap
           r-purrr
           r-rlang
           r-vegan))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=RVenn")
    (synopsis "Set operations for many sets")
    (description
     "The base functions for set operations in @code{R} can be used for only two
sets.  This package @code{RVenn} provides functions for dealing with multiple sets.
It uses @code{purr} to find the union, intersection and difference of three or
more sets.  This package also provides functions for pairwise set operations among
several sets.  Further, based on @code{ggplot2} and @code{ggforce}, a Venn diagram
can be drawn for two or three sets.  For bigger data sets, a clustered heatmap
showing the presence or absence of the elements of the sets can be drawn based on
the @code{pheatmap} package.  Finally, enrichment test can be applied to two sets
whether an overlap is statistically significant or not.")
    (license license:gpl3)))

(define-public r-dot
  (package
    (name "r-dot")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DOT" version))
       (sha256
        (base32
         "0qh5n57cp9c2n5yn59q4wggz82943pwfanp3kx869aba2x3sj30i"))))
    (properties `((upstream-name . "DOT")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-v8))
    (home-page "http://haghish.com/dot")
    (synopsis "Render and Export DOT Graphs in R")
    (description
     "This package provides tools to render DOT diagram markup language in R
and also provides the possibility to export the graphs in PostScript and
SVG (Scalable Vector Graphics) formats.  In addition, it supports literate
programming packages such as @code{knitr} and @code{rmarkdown}.")
    (license license:expat)))

(define-public r-carrier
  (package
    (name "r-carrier")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "carrier" version))
       (sha256
        (base32 "155zna5bv6ybb6hr3lsv8dn67lkbbvn3dbihfw2s6ajkzvms9x13"))))
    (properties `((upstream-name . "carrier")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lobstr r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/carrier")
    (synopsis "Isolate functions for remote execution")
    (description
     "Sending functions to remote processes can be wasteful of resources
because they carry their environments with them.  With this package, it is
easy to create functions that are isolated from their environment.  These
isolated functions, also called crates, print to the console with their total
size and can be easily tested locally before being sent to a remote.")
    (license license:gpl3)))

(define-public r-class
  (package
    (name "r-class")
    (version "7.3-23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "class" version))
       (sha256
        (base32
         "1wci521c81q500rwcsm8q1s307fxfx8pjvai85bg2ig0x89dn6jd"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://www.stats.ox.ac.uk/pub/MASS4/")
    (synopsis "R functions for classification")
    (description
     "This package provides various functions for classification, including
k-nearest neighbour, Learning Vector Quantization and Self-Organizing Maps.")
    ;; Either of the two versions can be picked.
    (license (list license:gpl2 license:gpl3))))

(define-public r-climaemet
  (package
    (name "r-climaemet")
    (version "1.4.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "climaemet" version))
              (sha256
               (base32
                "0pf4xck985hin5qsvg3yyh4sqainjm47ml19fla6z08l3q1qvyx7"))))
    (properties
     '((upstream-name . "climaemet")
       (updater-ignored-native-inputs . ("r-mapspain"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-dplyr
           r-ggplot2
           r-httr2
           r-jsonlite
           r-rappdirs
           r-readr
           r-rlang
           r-tibble
           r-tidyr
           r-xml2))
    (native-inputs (list r-knitr r-sf r-terra r-testthat))
    (home-page "https://ropenspain.github.io/climaemet/")
    (synopsis "Climate AEMET Tools")
    (description
     "This package provides tools to download the climatic data of the Spanish
Meteorological Agency (AEMET) directly from R using their API and create
scientific graphs (climate charts, trend analysis of climate time series,
temperature and precipitation anomalies maps, warming stripes graphics,
climatograms, etc.).")
    (license license:gpl3)))

(define-public r-climatol
  (package
    (name "r-climatol")
    (version "4.2-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "climatol" version))
              (sha256
               (base32
                "0xg433g07mzjyqj6lxy0xmzvj2pq9s3kxxjzgdghji7d1hdxiz63"))))
    (properties `((upstream-name . "climatol")))
    (build-system r-build-system)
    (home-page "http://www.climatol.eu/")
    (synopsis "Climate tools")
    (description
     "This package provides functions for the quality control, homogenization
and missing data infilling of climatological series, and to obtain
climatological summaries and grids from the results.  Also functions to draw
wind-roses and Walter&Lieth climate diagrams are included.")
    (license license:gpl2+)))

(define-public r-clipr
  (package
    (name "r-clipr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clipr" version))
       (sha256
        (base32
         "1s9vvv3cxnz8w11gsi8z9ddv9jzib5qf5qqxnwqrrv7vj8cr7hij"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/mdlincoln/clipr")
    (synopsis "Read and write from the system clipboard")
    (description
     "This package provides simple utility functions to read from and write to
the system clipboards.")
    (license license:gpl3)))

(define-public r-clock
  (package
    (name "r-clock")
    (version "0.7.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clock" version))
              (sha256
               (base32
                "0vjni8ci8y5aih104rbca5dqrsdsnpxwrqahmr3ncv3qp0krx82s"))))
    (properties
     '((upstream-name . "clock")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for tests.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-cli
           r-cpp11
           r-lifecycle
           r-rlang
           r-tzdb
           r-vctrs))
    (native-inputs (list r-knitr r-slider r-testthat tzdata-for-tests))
    (home-page "https://clock.r-lib.org")
    (synopsis "Date-Time types and tools")
    (description
     "This package provides a comprehensive library for date-time
manipulations using a new family of orthogonal date-time
classes (durations, time points, zoned-times, and calendars) that
partition responsibilities so that the complexities of time zones are
only considered when they are really needed.  Capabilities include:
date-time parsing, formatting, arithmetic, extraction and updating of
components, and rounding.")
    (license license:expat)))

(define-public r-cluster
  (package
    (name "r-cluster")
    (version "2.1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cluster" version))
       (sha256
        (base32
         "0mqy8izwf6j5w09fphv15znh9h2kqy0b22yw5skxqzdi167bg5ab"))))
    (properties
     '((updater-extra-native-inputs . ("r-matrix"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-tests
           (lambda _
             ;; Tests insist on loading Matrix not from the locations
             ;; specified with R_LIBS_SITE.
             (substitute* "inst/test-tools.R"
               ((", lib.loc = .Library") "")))))))
    (native-inputs
     (list r-matrix))
    (home-page "https://cran.r-project.org/web/packages/cluster")
    (synopsis "Methods for cluster analysis")
    (description
     "This package provides methods for cluster analysis.  It is a much
extended version of the original from Peter Rousseeuw, Anja Struyf and Mia
Hubert, based on Kaufman and Rousseeuw (1990) \"Finding Groups in Data\".")
    (license license:gpl2+)))

(define-public r-clustmixtype
  (package
    (name "r-clustmixtype")
    (version "0.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "clustMixType" version))
       (sha256
        (base32 "1clby7x9jz0jpzmzni6g8zicysnf7ccxliglxr6ljigvkf747bg1"))))
    (properties `((upstream-name . "clustMixType")))
    (build-system r-build-system)
    (propagated-inputs (list r-combinat r-dplyr r-rcolorbrewer r-rlang
                             r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=clustMixType")
    (synopsis "k-prototypes clustering for mixed variable-type data")
    (description
     "This package provides functions to perform k-prototypes partitioning
clustering for mixed variable-type data according to Z.Huang (1998):
Extensions to the k-Means Algorithm for Clustering Large Data Sets with
Categorical Variables, Data Mining and Knowledge Discovery 2, 283-304.")
    (license license:gpl2+)))

(define-public r-clvalid
  (package
    (name "r-clvalid")
    (version "0.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "clValid" version))
              (sha256
               (base32
                "18aiyjhnh5mfdxbzns4cy0r8bymfikhwkybpn4g04qhli5ls8z83"))))
    (properties `((upstream-name . "clValid")))
    (build-system r-build-system)
    (propagated-inputs (list r-class r-cluster))
    (home-page "https://cran.r-project.org/package=clValid")
    (synopsis "Validation of clustering results")
    (description
     "Statistical and biological validation of clustering results.  This
package implements Dunn Index, Silhouette, Connectivity, Stability, BHI and
BSI.  Further information can be found in Brock, G et al. (2008) <doi:
10.18637/jss.v025.i04>.")
    (license license:lgpl3)))

(define-public r-dlm
  (package
    (name "r-dlm")
    (version "1.1-6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dlm" version))
       (sha256
        (base32 "0hsz1xavzbylqb33c0qzalcqmq4g4i1c38wd351zjj88dvg73qvk"))))
    (properties `((upstream-name . "dlm")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=dlm")
    (synopsis "Bayesian and Likelihood Analysis of Dynamic Linear Models")
    (description
     "This package provides routines for Maximum likelihood, Kalman filtering
and smoothing, and Bayesian analysis of Normal linear State Space models, also
known as Dynamic Linear Models.")
    (license license:gpl2+)))

(define-public r-zcompositions
  (package
    (name "r-zcompositions")
    (version "1.5.0-4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zCompositions" version))
              (sha256
               (base32
                "1bvaw6m95hz8hd5p8h1d482b45r3w82dyj3sxlijf12s0qg8w63k"))))
    (properties `((upstream-name . "zCompositions")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-nada r-truncnorm))
    (home-page "https://github.com/Japal/zCompositions")
    (synopsis
     "Treatment of zeros, left-censored and missing values in compositional data")
    (description
     "This is an R package for the imputation of left-censored data
under a compositional approach.  The implemented methods consider
aspects of relevance for a compositional approach such as scale
invariance, subcompositional coherence or preserving the multivariate
relative structure of the data.  Based on solid statistical
frameworks, it comprises the ability to deal with single and varying
censoring thresholds, consistent treatment of closed and non-closed
data, exploratory tools, multiple imputation, @dfn{Markov Chain Monte
Carlo} (MCMC), robust and non-parametric alternatives, and recent
proposals for count data.")
    (license license:gpl2+)))

(define-public r-zoo
  (package
    (name "r-zoo")
    (version "1.8-14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zoo" version))
              (sha256
               (base32
                "15i784lcbd5m02l00bjr0c081b5zzqjgjy684nqlias2bi9vcax8"))))
    (properties
     '((updater-ignored-native-inputs . ("r-strucchange" "r-tseries"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Vignettes require r-tseries, which depends on r-zoo.
      #:test-types '(list "tests")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; These tests require r-tseries, which depends on r-zoo.
             (for-each delete-file
                       '("tests/vignette-zoo-quickref.R"
                         "tests/vignette-zoo.R")))))))
    (propagated-inputs
     (list r-lattice))
    (native-inputs (list r-chron
                         r-mondate
                         r-quantreg
                         r-timedate
                         r-timeseries
                         r-tis))
    (home-page "https://zoo.R-Forge.R-project.org/")
    (synopsis "S3 infrastructure for regular and irregular time series")
    (description "This package contains an S3 class with methods for totally
ordered indexed observations.  It is particularly aimed at irregular time
series of numeric vectors/matrices and factors.")
    (license license:gpl2+)))

(define-public r-fontawesome
  (package
    (name "r-fontawesome")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fontawesome" version))
       (sha256
        (base32 "0kzvh7xlq8lpx1l7x5gs99a3vncvbccqlqjwixjlrv6mzb80j68v"))))
    (properties `((upstream-name . "fontawesome")))
    (build-system r-build-system)
    ;; Some tests require r-dplyr; adding it to the inputs would lead to a
    ;; dependency cycle.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-htmltools r-rlang))
    (home-page "https://github.com/rstudio/fontawesome")
    (synopsis "Easily work with Font Awesome icons")
    (description
     "Easily and flexibly insert Font Awesome icons into R Markdown documents
and Shiny apps.  These icons can be inserted into HTML content through inline
SVG tags or @code{i} tags.  There is also a utility function for exporting
Font Awesome icons as PNG images for those situations where raster graphics
are needed.")
    (license license:expat)))

(define-public r-foreign
  (package
    (name "r-foreign")
    (version "0.8-90")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "foreign" version))
       (sha256
        (base32
         "15m1g7khwv73psrs194ip7zfc3s5qb020bbs48a902x50a07kihx"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/foreign")
    (synopsis "Read data stored by other statistics software")
    (description
     "This package provides functions for reading and writing data stored by
some versions of Epi Info, Minitab, S, SAS, SPSS, Stata, Systat and Weka and
for reading and writing some dBase files.")
    (license license:gpl2+)))

(define-public r-fingerprint
  (package
    (name "r-fingerprint")
    (version "3.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fingerprint" version))
       (sha256
        (base32 "04jcwkydjrs31pia6kq8z2n9s54im950q08hs2ay15xjxxkmb8ic"))))
    (properties `((upstream-name . "fingerprint")))
    (build-system r-build-system)
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/package=fingerprint")
    (synopsis "Functions to Operate on Binary Fingerprint Data")
    (description
     "This package provides functions to manipulate binary fingerprints of
arbitrary length.  A fingerprint is represented by an object of S4 class
@code{fingerprint}.  The bitwise logical functions in R are overridden so that
they can be used directly with @code{fingerprint} objects.  A number of
distance metrics are also available.  Fingerprints can be converted to
Euclidean vectors (i.e., points on the unit hypersphere) and can also be
folded.  Arbitrary fingerprint formats can be handled via line handlers.
Currently handlers are provided for CDK, MOE and BCI fingerprint data.")
    ;; Any version of the GPL
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-fishmethods
  (package
    (name "r-fishmethods")
    (version "1.13-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fishmethods" version))
       (sha256
        (base32 "07y58zr4m2nb9q3m3rqjxbxysf9br6ss22l4857w59mcnjfrx8c7"))))
    (properties `((upstream-name . "fishmethods")))
    (build-system r-build-system)
    (propagated-inputs (list r-boot
                             r-bootstrap
                             r-data-table
                             r-lme4
                             r-mass
                             r-numderiv
                             r-tmb))
    (home-page "https://cran.r-project.org/package=fishmethods")
    (synopsis "Fishery science methods and models")
    (description
     "This package provides functions for applying a wide range of fisheries
stock assessment methods.")
    (license license:gpl2+)))

(define-public r-fixest
  (package
    (name "r-fixest")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fixest" version))
       (sha256
        (base32 "1pqkwzcv8mjh00k0cl0na7izwhwsp6qpimbxmq5005vbhnwimrvw"))))
    (properties `((upstream-name . "fixest")))
    (build-system r-build-system)
    (propagated-inputs (list r-dreamerr
                             r-nlme
                             r-numderiv
                             r-rcpp
                             r-sandwich
                             r-stringmagic))
    (native-inputs (list r-data-table
                         r-knitr
                         r-mass))
    (home-page "https://lrberge.github.io/fixest/")
    (synopsis "Fast fixed-effects estimations")
    (description
     "This is a package for fast and user-friendly estimation of econometric
models with multiple fixed-effects.  It includes ordinary least squares (OLS),
generalized linear models (GLM) and the negative binomial.  The core of the
package is based on optimized parallel C++ code, scaling especially well for
large data sets.  The method to obtain the fixed-effects coefficients is based
on Berge (2018).  It further provides tools to export and view the results of
several estimations with intuitive design to cluster the standard-errors.")
    (license license:gpl3)))

(define-public r-fpeek
  (package
    (name "r-fpeek")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fpeek" version))
       (sha256
        (base32 "0kv46g21ndxchg3q8ynq7hjjkh6i2zlc21axn5y1jjzigrw047ii"))))
    (properties `((upstream-name . "fpeek")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/davidgohel/fpeek")
    (synopsis "Check text files content at a glance")
    (description
     "This package provides tools to help working with text files.  It can
return the number of lines; print the first and last lines; convert encoding.
Operations are made without reading the entire file before starting, resulting
in good performances with large files.")
    (license license:expat)))

(define-public r-ggalluvial
  (package
   (name "r-ggalluvial")
   (version "0.12.5")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ggalluvial" version))
            (sha256
             (base32
              "0wax853pi3ghqv5alfkx9rgfb3sm3sqh3miklwvn22bh1s44q14h"))))
   (properties
    '((upstream-name . "ggalluvial")
      (updater-extra-native-inputs . ("r-alluvial"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-dplyr
          r-ggplot2
          r-lazyeval
          r-rlang
          r-tidyr
          r-tidyselect))
   (native-inputs
    (list r-alluvial r-knitr r-testthat))
   (home-page "https://corybrunson.github.io/ggalluvial/")
   (synopsis "Alluvial plots for ggplot2")
   (description "This package provides alluvial plots for @code{ggplot2}.
Alluvial plots use variable-width ribbons and stacked bar plots to represent
multi-dimensional or repeated-measures data with categorical or ordinal
variables.")
   (license license:gpl3)))

(define-public r-ggpp
  (package
    (name "r-ggpp")
    (version "0.5.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpp" version))
       (sha256
        (base32
         "1jk3x679rvkj3if14cai99w5sk0nj07rhppwwd7i7a1daal0grh5"))))
    (properties
     '((upstream-name . "ggpp")
       (updater-extra-native-inputs . ("r-vdiffr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-glue
           r-gridextra
           r-lubridate
           r-magrittr
           r-mass
           r-polynom
           r-rlang
           r-scales
           r-stringr
           r-tibble
           r-vctrs
           r-xts
           r-zoo))
    (native-inputs
     (list r-knitr r-testthat r-vdiffr))
    (home-page "https://docs.r4photobiology.info/ggpp/")
    (synopsis "Grammar extensions to ggplot2")
    (description
     "This package contains extensions to ggplot2.

@enumerate
@item Geomas: @code{geom_table}, @code{geom_plot} and @code{geom_grob} add
  insets to plots using native data coordinates, while @code{geom_table_npc},
  @code{geom_plot_npc} and @code{geom_grob_npc} do the same using @code{npc}
  coordinates through new aesthetics @code{npcx} and @code{npcy}.
@item Statistics: select observations based on 2D density.
@item Positions: radial nudging away from a center point and nudging away from
  a line or curve.
@end enumerate
")
    (license license:gpl2+)))

(define-public r-ggprism
  (package
    (name "r-ggprism")
    (version "1.0.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggprism" version))
              (sha256
               (base32
                "1jp6vxydcs1hqg2p11x3llpnrkxdky0lixsywrhyncw44y18mid3"))))
    (properties `((upstream-name . "ggprism")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest
           r-ggplot2
           r-glue
           r-gtable
           r-rlang
           r-scales
           r-tibble))
    (native-inputs (list r-knitr r-tinytest))
    (home-page "https://csdaw.github.io/ggprism/")
    (synopsis "ggplot2 extension inspired by GraphPad Prism")
    (description
     "This package provides various themes, palettes, and other functions that are
used to customise ggplots to look like they were made in GraphPad Prism.  The
Prism-look is achieved with @code{theme_prism()} and
@code{scale_fill|colour_prism()}, axes can be changed with custom guides like
@code{guide_prism_minor()}, and significance indicators added with
@code{add_pvalue()}.")
    (license license:gpl3+)))

(define-public r-ggrastr
  (package
    (name "r-ggrastr")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggrastr" version))
              (sha256
               (base32
                "1l90mlb6bqq98ifmlbs5481vch9inmzdnvnz192adklrr9nl09yb"))))
    (properties `((upstream-name . "ggrastr")))
    (build-system r-build-system)
    (propagated-inputs (list r-cairo r-ggbeeswarm r-ggplot2 r-png r-ragg))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/VPetukhov/ggrastr")
    (synopsis "Rasterize layers for ggplot2")
    (description
     "Rasterize only specific layers of a ggplot2 plot while simultaneously keeping
all labels and text in vector format.  This allows users to keep plots within
the reasonable size limit without losing vector properties of the
scale-sensitive information.")
    (license license:expat)))

(define-public r-ggvenn
  (package
    (name "r-ggvenn")
    (version "0.1.10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggvenn" version))
              (sha256
               (base32
                "0gl7z8hrn2wmmb59fvfv2hsw40p629aj086dv0kwlv162zqidqfd"))))
    (properties `((upstream-name . "ggvenn")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr r-ggplot2))
    (home-page "https://cran.r-project.org/package=ggvenn")
    (synopsis "Draw Venn diagram with ggplot2")
    (description
     "This package offers an easy to use way to draw a Venn diagram with
@code{ggplot2}.")
    (license license:expat)))

(define-public r-ggvenndiagram
  (package
    (name "r-ggvenndiagram")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggVennDiagram" version))
       (sha256
        (base32
         "0hzjbpd3f3zn169s5nvnv7b4wlrwdn3r0pk0vgkdnhchl75g0qni"))))
    (properties `((upstream-name . "ggVennDiagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-aplot
           r-dplyr
           r-forcats
           r-ggplot2
           r-tibble
           r-venn
           r-yulab-utils))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/gaospecial/ggVennDiagram")
    (synopsis "Implementention of the Venn diagram using ggplot2")
    (description
     "This package implements easy-to-use functions to generate 2-7 sets Venn
plot in publication quality.  @code{ggVennDiagram} plot Venn using
well-defined geometry dataset and @code{ggplot2}.  The shapes of 2-4 sets Venn
use circles and ellipses, while the shapes of 4-7 sets Venn use irregular
polygons (4 has both forms), which are developed and imported from another
package @code{venn}.  We provide internal functions to integrate shape data
with user provided sets data, and calculated the geometry of every
regions/intersections of them, then separately plot Venn in three components:
set edges, set labels, and regions.  From version 1.0, it is possible to
customize these components as you demand in ordinary @code{ggplot2} grammar.")
    (license license:gpl3)))

(define-public r-labeling
  (package
    (name "r-labeling")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "labeling" version))
       (sha256
        (base32 "1wk4wa1s8f17b5lf8vs5hxsmyadp2ccmyg4hamq7sdvlrk14yby6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/labeling")
    (synopsis "Axis labeling algorithms")
    (description "The labeling package provides a range of axis labeling
algorithms.")
    (license license:expat)))

(define-public r-laf
  (package
    (name "r-laf")
    (version "0.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LaF" version))
       (sha256
        (base32 "1738v1jc3diz72dc0g0fzad6pa8fyahz1qd66izj437s0xy249q6"))))
    (properties
     '((upstream-name . "LaF")
       (updater-extra-native-inputs . ("r-yaml"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat r-yaml))
    (home-page "https://github.com/djvanderlaan/LaF")
    (synopsis "Fast access to large ASCII files")
    (description
     "This package provides methods for fast access to large ASCII files.
Currently the following file formats are supported: comma separated
format (CSV) and fixed width format.  It is assumed that the files are too
large to fit into memory, although the package can also be used to efficiently
access files that do fit into memory.  Methods are provided to access and
process files blockwise.  Furthermore, an opened file can be accessed as one
would an ordinary data.frame.  The @code{LaF} vignette gives an overview of
the functionality provided.")
    (license license:gpl3)))

(define-public r-lambda-r
  (package
    (name "r-lambda-r")
    (version "1.2.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "lambda.r" version))
              (sha256
               (base32
                "1mh1g0gsd58gng0hb29vww2yqb2jfs07kba5kxnnqck5j3izwlnj"))))
    (properties `((upstream-name . "lambda.r")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-formatr))
    (native-inputs (list r-testit))
    (home-page "https://cran.r-project.org/web/packages/lambda.r")
    (synopsis "Functional programming extension for R")
    (description
     "This package provides a language extension to efficiently write
functional programs in R.  Syntax extensions include multi-part function
definitions, pattern matching, guard statements, built-in (optional) type
safety.")
    (license license:lgpl3+)))

(define-public r-lars
  (package
    (name "r-lars")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lars" version))
       (sha256
        (base32
         "17al1g0pvfz9frs2kxicqr8dyp7ciz3x87yx2l4lqd53ls6nm7n6"))))
    (build-system r-build-system)
    (inputs
     (list gfortran))
    (home-page "https://web.stanford.edu/~hastie/Papers/LARS/")
    (synopsis "Least angle regression software")
    (description
     "Least Angle Regression (\"LAR\") is a model selection algorithm; a
useful and less greedy version of traditional forward selection methods.  A
simple modification of the LAR algorithm implements Tibshirani's Lasso; the
Lasso modification of LARS calculates the entire Lasso path of coefficients
for a given problem at the cost of a single least squares fit.  Another LARS
modification efficiently implements epsilon Forward Stagewise linear
regression.")
    (license license:gpl2)))

(define-public r-lattice
  (package
    (name "r-lattice")
    (version "0.22-7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "lattice" version))
              (sha256
               (base32
                "1xzrpy30irlzf3dy6pz5jnbd8p82xgfy5kin5bai0179jlmsc3s0"))))
    (build-system r-build-system)
    (native-inputs (list r-mass))
    (home-page "https://lattice.r-forge.r-project.org/")
    (synopsis "High-level data visualization system")
    (description
     "The lattice package provides a powerful and elegant high-level data
visualization system inspired by Trellis graphics, with an emphasis on
multivariate data.  Lattice is sufficient for typical graphics needs, and is
also flexible enough to handle most nonstandard requirements.")
    (license license:gpl2+)))

(define-public r-latticeextra
  (package
    (name "r-latticeextra")
    (version "0.6-30")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "latticeExtra" version))
       (sha256
        (base32
         "1vcy4xr6c53nbvnxikjnlf5kd3n5hf4d8dzj5d41hj322dlsfl65"))))
    (properties `((upstream-name . "latticeExtra")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-interp
           r-jpeg
           r-lattice
           r-mass
           r-png
           r-rcolorbrewer))
    (home-page "https://latticeextra.r-forge.r-project.org/")
    (synopsis "Extra graphical utilities based on lattice")
    (description
     "Building on the infrastructure provided by the lattice package, this
package provides several new high-level graphics functions and methods, as
well as additional utilities such as panel and axis annotation functions.")
    (license license:gpl2+)))

(define-public r-lazyeval
  (package
    (name "r-lazyeval")
    (version "0.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "lazyeval" version))
              (sha256
               (base32
                "1m10i059csrcqkcn59a8wspn784alxsq3symzhn24mhhl894346n"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/hadley/lazyeval")
    (synopsis "Lazy (non-standard) evaluation in R")
    (description
     "This package provides the tools necessary to do non-standard
evaluation (NSE) in R.")
    (license license:gpl3+)))

(define-public r-lbfgsb3c
  (package
    (name "r-lbfgsb3c")
    (version "2024-3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lbfgsb3c" version))
       (sha256
        (base32 "0rgikv5p05rv4r55mihlbk1953jiwd95wp2rn05xqi4ix33y3vxj"))))
    (properties `((upstream-name . "lbfgsb3c")))
    (build-system r-build-system)
    (propagated-inputs (list r-numderiv r-rcpp r-rcpparmadillo))
    (native-inputs (list gfortran r-knitr r-testthat))
    (home-page "https://nlmixr2.github.io/lbfgsb3c/")
    (synopsis "Limited memory BFGS minimizer with bounds on parameters")
    (description
     "This package lets you interface to Nocedal et al. L-BFGS-B.3.0 limited
memory BFGS minimizer with bounds on parameters.  This registers a R
compatible C interface to L-BFGS-B.3.0 that uses the same function types and
optimization as the @code{optim()} function.  This package also adds more
stopping criteria as well as allowing the adjustment of more tolerances.")
    (license license:gpl2)))

(define-public r-lfc
  (package
    (name "r-lfc")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lfc" version))
       (sha256
        (base32 "1fh3i5mhzgz8k6y32m2y7lilxvm10kjkp5b70zm06iygazsk8bvz"))))
    (properties `((upstream-name . "lfc")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/erhard-lab/lfc")
    (synopsis
     "Log fold change distribution tools for working with ratios of counts")
    (description
     "This is a package for ratios of count data such as obtained from RNA-seq
are modelled using Bayesian statistics to derive posteriors for effects sizes.
This approach is described in Erhard & Zimmer (2015) <doi:10.1093/nar/gkv696>
and Erhard (2018) <doi:10.1093/bioinformatics/bty471>.")
    (license license:asl2.0)))

(define-public r-lmds
  (package
    (name "r-lmds")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmds" version))
       (sha256
        (base32 "130azb0nc2wwxv0qi8v5s4rd02p9lc92zwn634pv7b8awbw81i65"))))
    (properties `((upstream-name . "lmds")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat r-dynutils r-irlba r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dynverse/lmds")
    (synopsis "Landmark multi-dimensional scaling")
    (description
     "This package provides a fast dimensionality reduction method scalable
to large numbers of samples.  @dfn{Landmark Multi-Dimensional Scaling} (LMDS)
is an extension of classical Torgerson MDS, but rather than calculating a
complete distance matrix between all pairs of samples, only the distances
between a set of landmarks and the samples are calculated.")
    (license license:gpl3)))

(define-public r-lme4
  (package
    (name "r-lme4")
    (version "1.1-37")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lme4" version))
       (sha256
        (base32
         "037hprzv9skjcp07lhgdy9ymaihnms6pjibr61ls1paz8in7bnyg"))))
    (build-system r-build-system)
    (properties
     '((updater-ignored-native-inputs . ("r-car" "r-gamm4"))))
    (propagated-inputs
     (list r-boot
           r-lattice
           r-mass
           r-matrix
           r-minqa
           r-nlme
           r-nloptr
           r-rcpp
           r-rcppeigen
           r-reformulas))
    (native-inputs
     (list r-devtools
           r-ggplot2
           r-knitr
           r-mgcv
           r-optimx
           r-statmod
           r-testthat
           r-tibble))
    (home-page "https://cran.r-project.org/web/packages/lme4")
    (synopsis "Linear mixed-effects models using eigen and S4")
    (description
      "This package provides fit linear and generalized linear mixed-effects
models.  The models and their components are represented using S4 classes and
methods.  The core computational algorithms are implemented using the Eigen
C++ library for numerical linear algebra and RcppEigen glue.")
    (license license:gpl2+)))

(define-public r-lmeinfo
  (package
    (name "r-lmeinfo")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmeInfo" version))
       (sha256
        (base32 "11sqfb9bj7npngli4h0mzjd2pqjjkza2zmq4b9g2fhmm9r2b0zvd"))))
    (properties
     `((upstream-name . "lmeInfo")
       ;; Avoid dependency cycles.
       (updater-ignored-native-inputs . ("r-lmeinfo" "r-scdhlm"))))
    (build-system r-build-system)
    (propagated-inputs (list r-nlme))
    (native-inputs (list r-knitr r-lme4 r-testthat))
    (home-page "https://jepusto.github.io/lmeInfo/")
    (synopsis "Information matrices for lmeStruct and glsStruct objects")
    (description
     "This package provides analytic derivatives and information matrices for
fitted @dfn{linear mixed effects} (lme) models and generalized least
squares (gls) models estimated using @code{lme()} (from package @code{nlme})
and @code{gls()} (from package @code{nlme}), respectively.  The package
includes functions for estimating the sampling variance-covariance of variance
component parameters using the inverse Fisher information.  The variance
components include the parameters of the random effects structure (for lme
models), the variance structure, and the correlation structure.  The expected
and average forms of the Fisher information matrix are used in the
calculations, and models estimated by full maximum likelihood or restricted
maximum likelihood are supported.  The package also includes a function for
estimating standardized mean difference effect sizes based on fitted lme or
gls models.")
    (license license:gpl3)))

(define-public r-lmodel2
  (package
    (name "r-lmodel2")
    (version "1.7-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmodel2" version))
       (sha256
        (base32 "1rclwaq2hqn6qpkzl686sikkwc5lrmbbdgpsf8qxwqkn2f0xia4f"))))
    (properties `((upstream-name . "lmodel2")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=lmodel2")
    (synopsis "Model II regression")
    (description
     "This package computes model II simple linear regression using
@dfn{ordinary least squares} (OLS), @dfn{major axis} (MA), @dfn{standard major
axis} (SMA), and @dfn{ranged major axis} (RMA).")
    (license license:gpl2)))

(define-public r-lmom
  (package
    (name "r-lmom")
    (version "3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmom" version))
       (sha256
        (base32 "165dqz8yv3wak77935shz8axcck6jg5h7fnyy0ih9dzin3npng6s"))))
    (properties `((upstream-name . "lmom")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=lmom")
    (synopsis "L-Moments for R")
    (description
     "This package provides functions related to L-moments: computation of
L-moments and trimmed L-moments of distributions and data samples; parameter
estimation; L-moment ratio diagram; plot vs. quantiles of an extreme-value
distribution.")
    (license license:cpl1.0)))

(define-public r-locfit
  (package
    (name "r-locfit")
    (version "1.5-9.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "locfit" version))
       (sha256
        (base32
         "0hwklfvkrqx372y60z4ahvxscckan7bwn1birdpplmgk0zabjcgs"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (home-page "https://cran.r-project.org/web/packages/locfit")
    (synopsis "Local regression, likelihood and density estimation")
    (description
     "This package provides functions used for local regression, likelihood
and density estimation.")
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-logspline
  (package
    (name "r-logspline")
    (version "2.1.22")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "logspline" version))
       (sha256
        (base32
         "00pdcfj1hmafxzs7gqw3n072p6pxp9hvsdm062n0xkiby6igffkp"))))
    (properties `((upstream-name . "logspline")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/logspline/")
    (synopsis "Routines for Logspline density estimation")
    (description
     "This package contains routines for logspline density estimation.  The
function @code{oldlogspline()} uses the same algorithm as the logspline
package version 1.0.x; i.e., the Kooperberg and Stone (1992) algorithm (with
an improved interface).  The recommended routine @code{logspline()} uses an
algorithm from @url{doi:10.1214/aos/1031594728,Stone et al (1997)}.")
    (license license:asl2.0)))

(define-public r-lubridate
  (package
    (name "r-lubridate")
    (version "1.9.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lubridate" version))
       (sha256
        (base32
         "1ha68ri36gcq573j7s71m284166qd1ywran62h9d88nn4gi7wjw6"))))
    (build-system r-build-system)
    (properties
     '((updater-extra-native-inputs . ("tzdata-for-tests"))))
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for one failing test.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "LOCALTIME"
                     (search-input-file inputs
                                        "share/zoneinfo/localtime"))
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-generics r-timechange))
    (native-inputs
     (list r-knitr r-testthat r-vctrs tzdata-for-tests))
    (home-page "https://cran.r-project.org/web/packages/lubridate/")
    (synopsis "Make dealing with dates a little easier")
    (description
     "This package provides functions to work with date-times and time-spans:
fast and user friendly parsing of date-time data, extraction and updating of
components of a date-time (years, months, days, hours, minutes, and seconds),
algebraic manipulation on date-time and time-span objects.  The
@code{lubridate} package has a consistent and memorable syntax that makes
working with dates easy and fun.")
    (license license:gpl2)))

(define-public r-ggpmisc
  (package
    (name "r-ggpmisc")
    (version "0.6.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggpmisc" version))
              (sha256
               (base32
                "1ipi8dsxql94gk9h020shbvy26arpwjqlmkplyy746vmhkc03ma8"))))
    (properties
     '((updater-extra-native-inputs . ("r-vdiffr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-confintr
           r-dplyr
           r-generics
           r-ggplot2
           r-ggpp
           r-lmodel2
           r-lubridate
           r-mass
           r-multcomp
           r-multcompview
           r-plyr
           r-polynom
           r-quantreg
           r-rlang
           r-scales
           r-splus2r
           r-tibble))
    (native-inputs
     (list r-knitr r-testthat r-vdiffr))
    (home-page "https://www.r4photobiology.info/")
    (synopsis "Miscellaneous Extensions to @code{ggplot2}")
    (description "This package provides extensions to @code{ggplot2},
respecting the grammar of its graphics paradigm.")
    (license license:gpl2+)))

(define-public r-ggside
  (package
    (name "r-ggside")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ggside" version))
              (sha256
               (base32
                "1r36hsnha9bqzfb3rhpj11zg307wzacnkn4i6hi627xrx4knj5cl"))))
    (properties `((upstream-name . "ggside")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-ggplot2
           r-glue
           r-gtable
           r-rlang
           r-scales
           r-tibble
           r-vctrs))
    (native-inputs
     (list r-dplyr
           r-ggdendro
           r-knitr
           r-testthat
           r-tidyr
           r-vdiffr
           r-viridis))
    (home-page "https://cran.r-project.org/package=ggside")
    (synopsis "Side grammar graphics that extends @code{ggplot2}")
    (description
     "The grammar of graphics as shown in @code{ggplot2} has provided an
expressive API for users to build plots.  This package @code{ggside} extends
@code{ggplot2} by allowing users to add graphical information about one of the
main panel's axis using a familiar @code{ggplot2} style API with tidy data.
This package is particularly useful for visualizing metadata on a discrete
axis, or summary graphics on a continuous axis such as a boxplot or a density
distribution.")
    (license license:expat)))

(define-public r-gparotation
  (package
    (name "r-gparotation")
    (version "2025.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GPArotation" version))
       (sha256
        (base32 "12w24c0lllk9fmlaaw8j0lfz0vnggn55kcqs7qsbv6h683pdfaxz"))))
    (properties `((upstream-name . "GPArotation")))
    (build-system r-build-system)
    (home-page "https://optimizer.r-forge.r-project.org/GPArotation_www/")
    (synopsis "Gradient projection factor rotation")
    (description
     "This package provides gradient projection algorithms for factor
rotation.  For details see @code{?GPArotation}.")
    (license license:gpl2+)))

(define-public r-gprofiler
  (package
    (name "r-gprofiler")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gProfileR" version))
       (sha256
        (base32
         "1h1v0kgpsn04ald2izznh7fr2riwisj5hcgz4k7h3qc931rf0r4k"))))
    (properties `((upstream-name . "gProfileR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcurl))
    (home-page "https://cran.r-project.org/web/packages/gProfileR/")
    (synopsis "Interface to the g:Profiler toolkit")
    (description
     "This package provides tools for functional enrichment analysis,
gene identifier conversion and mapping homologous genes across related
organisms via the @code{g:Profiler} toolkit.")
    (license license:gpl2+)))

(define-public r-gprofiler2
  (package
    (name "r-gprofiler2")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gprofiler2" version))
       (sha256
        (base32
         "1klmg0zj5kr663dzgfzpy1yn161znmjcjq8pl3rahjh2lwaahbmh"))))
    (properties `((upstream-name . "gprofiler2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crosstalk
           r-dplyr
           r-ggplot2
           r-gridextra
           r-jsonlite
           r-plotly
           r-rcurl
           r-tidyr
           r-viridislite))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/web/packages/gprofiler2/")
    (synopsis "Interface to the g:Profiler toolset")
    (description
     "This package provides a toolset for functional enrichment analysis and
visualization, gene/protein/SNP identifier conversion and mapping orthologous
genes across species via @url{https://biit.cs.ut.ee/gprofiler,g:Profiler}.
The main tools are:

@enumerate
@item @code{g:GOSt}, functional enrichment analysis and visualization of gene
  lists;
@item @code{g:Convert}, gene/protein/transcript identifier conversion across
  various namespaces;
@item @code{g:Orth}, orthology search across species;
@item @code{g:SNPense}, mapping SNP rs identifiers to chromosome positions,
  genes and variant effects.
@end enumerate

This package is an R interface corresponding to the 2019 update of
@code{g:Profiler} and provides access to versions @code{e94_eg41_p11} and
higher.")
    (license license:gpl2+)))

(define-public r-oenb
  (package
    (name "r-oenb")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "oenb" version))
       (sha256
        (base32
         "1jgxw7ycx2lcdzglg9nix8k08fs4r6i5jdsjzrd6w1dg6smsinl5"))))
    (properties `((upstream-name . "oenb")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-xml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/franzmohr/oenb")
    (synopsis "Tools for the OeNB Data Web Service")
    (description
     "Tools to access data from the data web service of the
@acronym{OeNB, Oesterreichische Nationalbank},
@url{https://www.oenb.at/en/Statistics/User-Defined-Tables/webservice.html}.")
    (license license:gpl2+)))

(define-public r-oompadata
  (package
    (name "r-oompadata")
    (version "3.1.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oompaData" version))
              (sha256
               (base32
                "1rx5k1mgb0wsibiirfni5p143688h9nybl7sgp146zn0gg7983g4"))))
    (properties `((upstream-name . "oompaData")))
    (build-system r-build-system)
    (home-page "https://oompa.r-forge.r-project.org/")
    (synopsis "Data to illustrate OOMPA algorithms")
    (description
     "OOMPA offers R packages for gene expression and proteomics analysis.
OOMPA uses S4 classes to construct object-oriented tools with a consistent
user interface.  All higher level analysis tools in OOMPA are compatible with
the eSet classes defined in BioConductor.  The lower level processing tools
offer an alternative to parts of BioConductor, but can also be used to enhance
existing BioConductor packages.")
    (license license:asl2.0)))

(define-public r-oompabase
  (package
    (name "r-oompabase")
    (version "3.2.10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "oompaBase" version))
              (sha256
               (base32
                "026jd50ypwxxq29nfwx337s4x8rx8rmkjqv027apz4zqpsn94l95"))))
    (properties `((upstream-name . "oompaBase")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://oompa.r-forge.r-project.org/")
    (synopsis "Class unions, matrix operations, and color schemes for OOMPA")
    (description
     "This package preloads class unions for defining/loading core OOMPA tools.
It also includes vectorized operations for row-by-row means, variances, and
t-tests.  Finally, it provides new colorschemes.")
    (license license:asl2.0)))

(define-public r-openssl
  (package
    (name "r-openssl")
    (version "2.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "openssl" version))
       (sha256
        (base32
         "0ndzlw5whjayxiw59rn565dlyk46y3c39hmdb7n4gpn3inlhkdxn"))))
    (properties
     `((upstream-name . "openssl")
       (updater-extra-inputs . ("openssl"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'do-not-use-versioned-linking
           (lambda _
             (substitute* "configure"
               (("PKG_LIBS=\"\\$\\{PKG_LIBS_VERSIONED\\}\"")
                "PKG_LIBS=\"${PKG_LIBS}\"")))))))
    (inputs
     (list openssl))
    (native-inputs
     (list pkg-config r-curl r-knitr r-sodium r-testthat))
    (propagated-inputs
     (list r-askpass))
    (home-page "https://github.com/jeroenooms/openssl")
    (synopsis "Toolkit for encryption, signatures and certificates")
    (description
     "This package provides R bindings to OpenSSL libssl and libcrypto, plus
custom SSH pubkey parsers.  It supports RSA, DSA and NIST curves P-256, P-384
and P-521.  Cryptographic signatures can either be created and verified
manually or via x509 certificates.  AES block cipher is used in CBC mode for
symmetric encryption; RSA for asymmetric (public key) encryption.  High-level
envelope functions combine RSA and AES for encrypting arbitrary sized data.
Other utilities include key generators, hash functions (md5, sha1, sha256,
etc), base64 encoder, a secure random number generator, and @code{bignum} math
methods for manually performing crypto calculations on large multibyte
integers.")
    (license license:expat)))

(define-public r-orgmassspecr
  (package
    (name "r-orgmassspecr")
    (version "0.5-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "OrgMassSpecR" version))
              (sha256
               (base32
                "1dx9d8rb1dfqyhyc26zhfnxiv3rz2ikvs2mwqnsrq3lsjs9dvyc8"))))
    (properties `((upstream-name . "OrgMassSpecR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://OrgMassSpec.github.io/")
    (synopsis "Organic or biological mass spectrometry data analysis")
    (description
     "This package @code{OrgMassSpecR} is an extension of the @code{R}
statistical computing language.  It contains functions to assist with organic
or biological mass spectrometry data analysis.  Mass spectral libraries are
available as companion packages.")
    (license license:bsd-2)))

(define-public r-scales
  (package
    (name "r-scales")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scales" version))
       (sha256
        (base32 "1vnfhg4bg328vmvja6rzhwbsn8s70a27b8ngjmx2srcjikqgapnm"))))
    (properties
     '((updater-extra-native-inputs . ("r-stringi" "tzdata-for-tests"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for one failing test.
         (add-before 'check 'set-timezone
           ;; This package is picky about timezones.
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC+1")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs
     (list r-cli
           r-farver
           r-glue
           r-labeling
           r-lifecycle
           r-r6
           r-rcolorbrewer
           r-rlang
           r-viridislite))
    (native-inputs (list r-bit64 r-hms r-stringi r-testthat tzdata-for-tests))
    (home-page "https://github.com/hadley/scales")
    (synopsis "Scale functions for visualization")
    (description
     "This package provides graphical scales that map data to aesthetics, and
provides methods for automatically determining breaks and labels for axes and
legends.")
    (license license:expat)))

(define-public r-sendmailr
  (package
    (name "r-sendmailr")
    (version "1.4-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sendmailR" version))
       (sha256
        (base32
         "1balci88r2ci51xdh5zaqm3ss3vnry8pbkx2qngppc7n2gy932sv"))))
    (properties `((upstream-name . "sendmailR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/sendmailR")
    (synopsis "Send email using R")
    (description
     "This package contains a simple SMTP client which provides a portable
solution for sending email, including attachments, from within R.")
    (license license:gpl2+)))

(define-public r-skat
  (package
    (name "r-skat")
    (version "2.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SKAT" version))
       (sha256
        (base32 "1x2iyvzc66lmzwjdr8hy5gf3nxc7ik5vhbs40w00d2m7nr3glh8l"))))
    (properties `((upstream-name . "SKAT")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rspectra r-spatest))
    (home-page "https://cran.r-project.org/package=SKAT")
    (synopsis "SNP-Set (Sequence) kernel association test")
    (description
     "This package provides functions for kernel-regression-based association
tests including Burden test, SKAT and SKAT-O.  These methods aggregate
individual SNP score statistics in a SNP set and efficiently compute SNP-set
level p-values.")
    (license license:gpl2+)))

(define-public r-spatial
  (package
    (name "r-spatial")
    (version "7.3-18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spatial" version))
       (sha256
        (base32
         "0m9hljg8xz996rr2a3fwd7gna62fxslffmxmjpnghnkld4ynjinc"))))
    (build-system r-build-system)
    (home-page "https://www.stats.ox.ac.uk/pub/MASS4/")
    (synopsis "Functions for kriging and point pattern analysis")
    (description
     "This package provides functions for kriging and point pattern
analysis.")
    ;; Either version may be picked.
    (license (list license:gpl2 license:gpl3))))

(define-public r-stringi
  (package
    (name "r-stringi")
    (version "1.8.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stringi" version))
       (sha256
        (base32
         "1in8sn7d7lxm2zcpzm7xlrmvcb2c752nkadcg0ic9ds1rp6xw9h5"))))
    (build-system r-build-system)
    (inputs (list icu4c))
    (native-inputs (list pkg-config))
    (home-page "http://stringi.rexamine.com/")
    (synopsis "Character string processing facilities")
    (description
     "This package allows for fast, correct, consistent, portable, as well as
convenient character string/text processing in every locale and any native
encoding.  Owing to the use of the ICU library, the package provides R users
with platform-independent functions known to Java, Perl, Python, PHP, and Ruby
programmers.  Among available features there are: pattern searching
 (e.g.  via regular expressions), random string generation, string collation,
transliteration, concatenation, date-time formatting and parsing, etc.")
    (license license:bsd-3)))

(define-public r-stringr
  (package
    (name "r-stringr")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stringr" version))
       (sha256
        (base32 "1pj5xwg8kq2jllmszgkw96qj37wlb0x0vx4f3m5j211zpd8yrbd4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-glue r-lifecycle r-magrittr r-rlang r-stringi r-vctrs))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/hadley/stringr")
    (synopsis "Simple, consistent wrappers for common string operations")
    (description
     "Stringr is a consistent, simple and easy to use set of wrappers around
the fantastic @code{stringi} package.  All function and argument names (and
positions) are consistent, all functions deal with \"NA\"'s and zero length
vectors in the same way, and the output from one function is easy to feed into
the input of another.")
    (license license:gpl2+)))

(define-public r-survival
  (package
    (name "r-survival")
    (version "3.8-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "survival" version))
       (sha256
        (base32
         "05crwnjvdx2z6asjipc04534zp2jk3a16qkg8b3n399pgnjhbayw"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix))
    (home-page "https://github.com/therneau/survival")
    (synopsis "Survival analysis")
    (description
     "This package contains the core survival analysis routines, including
definition of Surv objects, Kaplan-Meier and Aalen-Johansen (multi-state)
curves, Cox models, and parametric accelerated failure time models.")
    (license license:lgpl2.0+)))

(define-public r-svglite
  (package
    (name "r-svglite")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svglite" version))
       (sha256
        (base32 "1hbgad7cgkyl6swxx69wgkva46px43fqfw9562f1g77sgi4sbvb4"))))
    (properties `((upstream-name . "svglite")))
    (build-system r-build-system)
    (inputs (list libpng zlib))
    (propagated-inputs (list r-base64enc
                             r-cli
                             r-cpp11
                             r-lifecycle
                             r-rlang
                             r-systemfonts
                             r-textshaping))
    (native-inputs (list r-fontquiver r-knitr r-testthat r-xml2))
    (home-page "https://svglite.r-lib.org")
    (synopsis "SVG graphics device")
    (description
     "@code{svglite} is a graphics device that produces clean
@dfn{SVG} (Scalable Vector Graphics) output, suitable for use on the web, or
hand editing.  Compared to the built-in @code{svg()}, @code{svglite} is
considerably faster, produces smaller files, and leaves text as is.")
    (license license:gpl2+)))

(define-public r-swagger
  (package
    (name "r-swagger")
    (version "5.17.14.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "swagger" version))
              (sha256
               (base32
                "0ykmz3j1n06w1injcnlkb3xv79vwiyv94j74m950rfrbv97dda58"))))
    (properties `((upstream-name . "swagger")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rstudio/swagger")
    (synopsis
     "Dynamically generate documentation from a Swagger-compliant API")
    (description
     "This package provides a collection of HTML, JavaScript, and CSS assets
that dynamically generate beautiful documentation from a Swagger compliant
API.")
    (license license:asl2.0)))

(define-public r-pacman
  (package
    (name "r-pacman")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pacman" version))
              (sha256
               (base32
                "0z7gngd6h83cpjhq1vg75wvzhdjbgjh7gj5d4zvvi9gd2lmagjcy"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-remotes))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/trinker/pacman")
    (synopsis "Package Management Tool")
    (description "This package provides tools to more conveniently perform
tasks associated with add-on packages.  @code{pacman} conveniently wraps
library and package related functions and names them in an intuitive and
consistent fashion.  It seeks to combine functionality from lower level
functions which can speed up workflow.")
    (license license:gpl2)))

(define-public r-pagoda2
  (package
    (name "r-pagoda2")
    (version "1.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pagoda2" version))
       (sha256
        (base32 "1kck12ri52nwsrxhjs8ghjji3rv1dxxjy8bxn1kk1hbg30265fsw"))))
    (properties `((upstream-name . "pagoda2")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dendsort
           r-drat
           r-fastcluster
           r-igraph
           r-irlba
           r-magrittr
           r-mass
           r-matrix
           r-mgcv
           r-n2r
           r-plyr
           r-r-utils
           r-r6
           r-rcpp
           r-rcpparmadillo
           r-rcppeigen
           r-rcppprogress
           r-rjson
           r-rlang
           r-rmtstat
           r-rook
           r-rtsne
           r-sccore
           r-urltools))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/kharchenkolab/pagoda2")
    (synopsis "Single cell analysis and differential expression")
    (description
     "The package offers functions for analyzing and interactively exploring
large-scale single-cell RNA-seq datasets.  Pagoda2 primarily performs
normalization and differential gene expression analysis, with an interactive
application for exploring single-cell RNA-seq datasets.  It performs basic
tasks such as cell size normalization, gene variance normalization, and can be
used to identify subpopulations and run differential expression within
individual samples.  pagoda2 was written to rapidly process modern large-scale
scRNAseq datasets of approximately 1e6 cells.  The companion web application
allows users to explore which gene expression patterns form the different
subpopulations within your data.  The package also serves as the primary
method for preprocessing data for conos.")
    (license license:gpl3)))

(define-public r-pals
  (package
    (name "r-pals")
    (version "1.10")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "pals" version))
              (sha256
               (base32
                "0gavg41kddy1i68rz2l5c9ldvvf8cw88mskdml9hxhnvnh93ff9r"))))
    (properties `((upstream-name . "pals")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-dichromat r-mapproj r-maps))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://kwstat.github.io/pals/")
    (synopsis "Color palettes, color maps, and tools to evaluate them")
    (description
     "This package provides a comprehensive collection of color
palettes, color maps, and tools to evaluate them.")
    (license license:gpl3)))

(define-public r-papaja
  (package
    (name "r-papaja")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "papaja" version))
       (sha256
        (base32 "0lknj3r4kd8i4jlfi8q7p7fi2s009q8rryf0r44zxfxvr9nkmyxv"))))
    (properties `((upstream-name . "papaja")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; This is needed for vignettes.
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp")))
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; 6 tests fail because of slight format differences.  The values
             ;; are all fine.
             (for-each delete-file
                       '("tests/testthat/test_apa_print_glm.R"
                         "tests/testthat/test_apa_print_model_comp.R")))))))
    (propagated-inputs
     (list r-bookdown
           r-broom
           r-glue
           r-knitr
           r-rmarkdown
           r-rmdfiltr
           r-tinylabels
           r-yaml
           r-zip
           texlive-amsmath
           texlive-apa6
           texlive-booktabs
           texlive-caption
           texlive-csquotes
           texlive-endfloat
           texlive-environ
           texlive-etoolbox
           texlive-fancyhdr
           texlive-framed
           texlive-geometry
           texlive-graphics
           texlive-grfext
           texlive-hyperref
           texlive-lineno
           texlive-multirow
           texlive-threeparttable
           texlive-threeparttablex
           texlive-titlesec
           texlive-tools
           texlive-trimspaces
           texlive-was                  ; upgreek.sty
           texlive-xcolor
           texlive-xpatch
           (texlive-local-tree (list
                                texlive-amsfonts
                                texlive-times
                                texlive-lm))))
    (native-inputs
     (list r-afex
           r-bayesfactor
           r-beeswarm
           r-effectsize
           r-emmeans
           r-multcomp
           r-knitr
           r-r-rsp
           r-testthat
           r-vgam))
    (home-page "https://github.com/crsh/papaja")
    (synopsis
     "Prepare American Psychological Association journal articles with R Markdown")
    (description
     "This package provides tools to create dynamic, submission-ready
manuscripts, which conform to American Psychological Association manuscript
guidelines.  It provides R Markdown document formats for manuscripts (PDF and
Word) and revision letters (PDF).  Helper functions facilitate reporting
statistical analyses or create publication-ready tables and plots.")
    (license license:expat)))

(define-public r-paralleldist
  (package
    (name "r-paralleldist")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parallelDist" version))
       (sha256
        (base32 "01ly4hxwa64a0ya5gla8rvv72s9mcknsfznivjkh937pbjwb7iih"))))
    (properties `((upstream-name . "parallelDist")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo r-rcppparallel))
    (native-inputs (list r-dtw r-ggplot2 r-proxy r-rcppxptrutils r-testthat))
    (home-page "https://github.com/alexeckert/parallelDist")
    (synopsis "Parallel Distance Matrix Computation using multiple threads")
    (description
     "This package provides a fast parallelized alternative to R's native
@code{dist} function to calculate distance matrices for continuous, binary,
and multi-dimensional input matrices, which supports a broad variety of
predefined distance functions from other R packages, as well as user- defined
functions written in C++.  For ease of use, the @code{parDist} function
extends the signature of the @code{dist} function and uses the same parameter
naming conventions as distance methods of existing R packages.")
    (license license:gpl2+)))

(define-public r-paramhelpers
  (package
    (name "r-paramhelpers")
    (version "1.14.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ParamHelpers" version))
              (sha256
               (base32
                "0x938sblzzfn7m19xcc6v9z1cpqwg0xngshnyc4hph9gs6r5js5b"))))
    (properties
     '((upstream-name . "ParamHelpers")
       (updater-extra-native-inputs
        . ("r-eaf" "r-emoa" "r-ggally" "r-gridextra" "r-plyr"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           ;; This one test fails for unclear reasons.
           (lambda _ (delete-file "tests/testthat/test_plotEAF.R"))))))
    (propagated-inputs (list r-backports r-bbmisc r-checkmate r-fastmatch))
    (native-inputs
     (list r-eaf
           r-emoa
           r-ggally
           r-ggplot2
           r-gridextra
           r-plyr
           r-irace
           r-lhs
           r-testthat))
    (home-page "https://paramhelpers.mlr-org.com")
    (synopsis
     "Helpers for parameters in black-box optimization, tuning, and machine learning")
    (description
     "This is a package for parameter description and operations in
optimization, tuning and machine learning.  Parameters can be described (type,
constraints, defaults, etc.), combined to parameter sets and can in general be
programmed on.  A useful @code{OptPath} object (archive) to log function
evaluations is also provided.")
    (license license:bsd-2)))

(define-public r-parallelmap
  (package
    (name "r-parallelmap")
    (version "1.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "parallelMap" version))
              (sha256
               (base32
                "1qg7zpz5sd9jp8wzjqahkhipwj1jn192llwg06q4gv9mlcsac261"))))
    (properties `((upstream-name . "parallelMap")))
    (build-system r-build-system)
    (propagated-inputs (list r-bbmisc r-checkmate))
    (native-inputs (list r-batchjobs r-batchtools r-rpart r-testthat))
    (home-page "https://parallelmap.mlr-org.com")
    (synopsis "Unified interface to parallelization backends")
    (description
     "This package provides a unified parallelization framework for multiple
backends.  This package is designed for internal package and interactive
usage.  The main operation is parallel mapping over lists.  It supports local,
multicore, mpi and BatchJobs mode.  It allows tagging of the parallel
operation with a level name that can be later selected by the user to switch
on parallel execution for exactly this operation.")
    (license license:bsd-2)))

(define-public r-pheatmap
  (package
    (name "r-pheatmap")
    (version "1.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pheatmap" version))
       (sha256
        (base32
         "1hdh74az3vyzz6dqa311rhxdm74n46lyr03p862kn80p0kp9d7ap"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gtable r-rcolorbrewer r-scales))
    (home-page "https://cran.r-project.org/web/packages/pheatmap")
    (synopsis "Pretty heatmaps")
    (description
     "This package provides an implementation of heatmaps that offers more
control over dimensions and appearance.")
    (license license:gpl2+)))

(define-public r-philentropy
  (package
    (name "r-philentropy")
    (version "0.9.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "philentropy" version))
              (sha256
               (base32
                "04rmhfslim3vwxi14qllp9kzjcl7fwyzczar0lb72j5vd07mmns0"))))
    (properties `((upstream-name . "philentropy")))
    (build-system r-build-system)
    (propagated-inputs (list r-kernsmooth r-poorman r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/drostlab/philentropy")
    (synopsis
     "Similarity and distance quantification between probability functions")
    (description
     "This package computes optimized distance and similarity measures for
comparing probability functions (Drost (2018) <doi:10.21105/joss.00765>).
These comparisons between probability functions have their foundations in a
broad range of scientific disciplines from mathematics to ecology.  The aim of
this package is to provide a core framework for clustering, classification,
statistical inference, goodness-of-fit, non-parametric statistics, information
theory, and machine learning tasks that are based on comparing univariate or
multivariate probability functions.")
    (license license:gpl2)))

(define-public r-pnwcolors
  (package
    (name "r-pnwcolors")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PNWColors" version))
       (sha256
        (base32
         "1phplnclkficfv8s6wsyrckk4ixzbayiy5iix6dddg40485l9nyj"))))
    (properties `((upstream-name . "PNWColors")))
    (build-system r-build-system)
    (home-page "https://github.com/jakelawlor/PNWColors")
    (synopsis "Color palettes for data visualizations")
    (description
     "This package provides color palettes.  They are checked for colorblind
accessibility from hue, saturation, and lightness value scaling using the
Chroma.js Color Palette Helper.  See @url{https://gka.github.io/palettes}.")
    (license license:cc0)))

(define-public r-plm
  (package
    (name "r-plm")
    (version "2.6-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plm" version))
       (sha256
        (base32 "1cq0hj6csfxsrm6k4qw5rds018div26mw6m34wjj45gj34l87a9m"))))
    (properties `((upstream-name . "plm")))
    (build-system r-build-system)
    (propagated-inputs (list r-bdsmatrix
                             r-collapse
                             r-formula
                             r-lattice
                             r-lmtest
                             r-mass
                             r-maxlik
                             r-nlme
                             r-rdpack
                             r-sandwich
                             r-zoo))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=plm")
    (synopsis "Linear Models for panel data")
    (description
     "This package provides a set of estimators for models and (robust)
covariance matrices, and tests for panel data econometrics, including
within/fixed effects, random effects, between, first-difference, nested random
effects as well as instrumental-variable (IV) and Hausman-Taylor-style models,
panel generalized method of moments (GMM) and general FGLS models, mean
groups (MG), demeaned MG, and common correlated effects (CCEMG) and
pooled (CCEP) estimators with common factors, variable coefficients and
limited dependent variables models.  Test functions include model
specification, serial correlation, cross-sectional dependence, panel unit root
and panel Granger (non-)causality.  Typical references are general
econometrics text books such as Baltagi (2021), Econometric Analysis of Panel
Data (<doi:10.1007/978-3-030-53953-5>), Hsiao
(2014), Analysis of Panel Data (<doi:10.1017/CBO9781139839327>), and Croissant
and Millo (2018), Panel Data Econometrics with
R (<doi:10.1002/9781119504641>).")
    (license license:gpl2+)))

(define-public r-plotfunctions
  (package
    (name "r-plotfunctions")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plotfunctions" version))
       (sha256
        (base32 "0asmxw8283fpvl83h478j5nyg59xqifqaa8f2f6l199gvvswhhg2"))))
    (properties `((upstream-name . "plotfunctions")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://jacolienvanrij.com/tutorials.html")
    (synopsis "Various functions to facilitate visualization of data and analysis")
    (description
     "When analyzing data, plots are a helpful tool for visualizing data and
interpreting statistical models.  This package provides a set of simple tools
for building plots incrementally, starting with an empty plot region, and
adding bars, data points, regression lines, error bars, gradient legends,
density distributions in the margins, and even pictures.  The package builds
further on R graphics by simply combining functions and settings in order to
reduce the amount of code to produce for the user.  As a result, the package
does not use formula input or special syntax, but can be used in combination
with default R plot functions.")
    (license license:gpl2+)))

(define-public r-plotmo
  (package
    (name "r-plotmo")
    (version "3.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plotmo" version))
       (sha256
        (base32 "0wl2xlidib4r54nm1q5zndr9iilagpyc3xlxs0cpd487hdh3zcn8"))))
    (properties `((upstream-name . "plotmo")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-plotrix))
    (native-inputs (list r-rpart))
    (home-page "http://www.milbo.users.sonic.net")
    (synopsis
     "Plot a model's residuals, response, and partial dependence plots")
    (description
     "This package lets you plot model surfaces for a wide variety of models
using partial dependence plots and other techniques.  Also plot model
residuals and other information on the model.")
    (license license:gpl3)))

(define-public r-plumber
  (package
    (name "r-plumber")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "plumber" version))
              (sha256
               (base32
                "0z9dzlmvsbqn1cykia07kpa88w5lcgrp39bqqm2d3bhnzkr5kj1s"))))
    (properties
     '((upstream-name . "plumber")
       (updater-extra-native-inputs
        . ("r-htmlwidgets" "r-readxl"))))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon
                             r-httpuv
                             r-jsonlite
                             r-lifecycle
                             r-magrittr
                             r-mime
                             r-promises
                             r-r6
                             r-rlang
                             r-sodium
                             r-stringi
                             r-swagger
                             r-webutils))
    (native-inputs
     (list r-arrow
           r-base64enc
           r-covr
           r-geojsonsf
           r-htmlwidgets
           r-knitr
           r-later
           r-mockery
           r-readr
           r-readxl
           r-rmarkdown
           r-sf
           r-spelling
           r-testthat
           r-visnetwork
           r-writexl
           r-yaml))
    (home-page "https://www.rplumber.io")
    (synopsis "API generator for R")
    (description
     "This package gives you the ability to automatically generate and serve
an HTTP API from R functions using the annotations in the R documentation
around your functions.")
    (license license:expat)))

(define-public r-polychrome
  (package
    (name "r-polychrome")
    (version "1.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Polychrome" version))
       (sha256
        (base32 "18lxkdfw37ci0y0l0wya7kr57hwn3yh2r88gjimpp4x1z833vxrw"))))
    (properties `((upstream-name . "Polychrome")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-scatterplot3d))
    (native-inputs
     (list r-knitr))
    (home-page "https://oompa.r-forge.r-project.org/")
    (synopsis "Qualitative palettes with many colors")
    (description
     "This package provides tools for creating, viewing, and assessing
qualitative palettes with many (20-30 or more) colors.  See Coombes and
colleagues (2019) @url{https://doi:10.18637/jss.v090.c01}.")
    (license license:asl2.0)))

(define-public r-polylabelr
  (package
    (name "r-polylabelr")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "polylabelr" version))
              (sha256
               (base32
                "1wxr2mhbsq7sm3byb4jn6dskmlxxjywhj453qhs0z40aaiphd49c"))))
    (properties `((upstream-name . "polylabelr")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-sf r-spelling r-testthat))
    (home-page "https://github.com/jolars/polylabelr")
    (synopsis "Finding pole of inaccessibility (visual center) of a polygon")
    (description
     "This package provides a wrapper around the @code{C++} library @code{
polylabel} from @code{Mapbox}, providing an efficient routine for finding the
approximate pole of inaccessibility of a polygon, which usually serves as an
excellent candidate for labeling of a polygon.")
    (license license:expat)))

(define-public r-poorman
  (package
    (name "r-poorman")
    (version "0.2.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "poorman" version))
              (sha256
               (base32
                "1amlcbgfnm6yh7lmlzhs7aalv4mdm2ir3s2kpx33ppnz7hlii508"))))
    (properties `((upstream-name . "poorman")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://nathaneastwood.github.io/poorman/")
    (synopsis "Dependency-free recreation of dplyr")
    (description
     "This package provides a replication of key functionality from
@code{dplyr} and the wider @code{tidyverse} using only @code{base}.")
    (license license:expat)))

(define-public r-ecdat
  (package
    (name "r-ecdat")
    (version "0.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Ecdat" version))
       (sha256
        (base32 "1vyc4ynkd65mng2x8wvzn47crsvaqfz97n89jxn12xv13bpsbs7c"))))
    (properties `((upstream-name . "Ecdat")))
    (build-system r-build-system)
    (propagated-inputs (list r-ecfun))
    (home-page "https://www.r-project.org")
    (synopsis "Data sets for econometrics")
    (description "This package provides data sets for econometrics, including
political science.")
    (license license:gpl2+)))

(define-public r-ecfun
  (package
    (name "r-ecfun")
    (version "0.3-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Ecfun" version))
       (sha256
        (base32 "0651vbb040y17sizh927vq4jfidpxilmwdgkhmr7z8p24yb588rc"))))
    (properties `((upstream-name . "Ecfun")))
    (build-system r-build-system)
    (propagated-inputs (list r-bma
                             r-fda
                             r-jpeg
                             r-mass
                             r-mvtnorm
                             r-readr
                             r-rvest
                             r-rworldmap
                             r-stringi
                             r-tis
                             r-xml2))
    (native-inputs (list r-knitr))
    (home-page "https://www.r-project.org")
    (synopsis "Functions for Ecdat")
    (description
     "This package provides functions and vignettes to update data sets in
Ecdat and to create, manipulate, plot, and analyze those and similar data
sets.")
    (license license:gpl2+)))

(define-public r-ecosolver
  (package
    (name "r-ecosolver")
    (version "0.5.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ECOSolveR" version))
              (sha256
               (base32
                "1izc8dwj438wpkmdmhwnnhkijz5skig4gwxgr6f1bzmj08bfv515"))))
    (properties `((upstream-name . "ECOSolveR")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-matrix r-testthat))
    (home-page "https://bnaras.github.io/ECOSolveR/")
    (synopsis "Embedded conic solver in R")
    (description
     "This package provides an R interface to the @dfn{Embedded COnic
Solver} (ECOS), an efficient and robust C library for convex problems.
Conic and equality constraints can be specified in addition to integer
and boolean variable constraints for mixed-integer problems.  This R
interface is inspired by the Python interface and has similar calling
conventions.")
    (license license:gpl3+)))

(define-public r-ecp
  (package
    (name "r-ecp")
    (version "3.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ecp" version))
              (sha256
               (base32
                "1imahvby3nj1b5d1x7hq6gkfg0fyyd27ghls0v35456imy1fmhz5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs (list r-r-rsp))
    (home-page "https://cran.r-project.org/web/packages/ecp/")
    (synopsis "Multiple change-point analysis of multivariate data")
    (description
     "This package implements various procedures for finding multiple
change-points.  Two methods make use of dynamic programming and pruning, with
no distributional assumptions other than the existence of certain absolute
moments in one method.  Hierarchical and exact search methods are included.
All methods return the set of estimated change-points as well as other summary
information.")
    (license license:gpl2+)))

(define-public r-ellipsis
  (package
    (name "r-ellipsis")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ellipsis" version))
       (sha256
        (base32
         "0n0mm9jngklv7j9wa64jdji035z0smmnsp2dfwcz9isrxgjnc0m9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/ellipsis")
    (synopsis "Tools for working with additional arguments")
    (description
     "In S3 generics, it's useful to take @code{...} so that methods can have
additional arguments.  But this flexibility comes at a cost: misspelled
arguments will be silently ignored.  The @code{ellipsis} package is an
experiment that allows a generic to warn if any arguments passed in @code{...}
are not used.")
    (license license:gpl3)))

(define-public r-ga
  (package
    (name "r-ga")
    (version "3.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GA" version))
       (sha256
        (base32 "1gc1n2xdzrkc9cvrm6a50c9xpwvf0isdgvs1qpm8x1afacw6d7z5"))))
    (properties `((upstream-name . "GA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-crayon
           r-foreach
           r-iterators
           r-rcpp
           r-rcpparmadillo))
    (native-inputs
     (list r-knitr))
    (home-page "https://luca-scr.github.io/GA/")
    (synopsis "Genetic algorithms for stochastic optimisation")
    (description
     "Flexible general-purpose toolbox implementing genetic algorithms (GAs)
for stochastic optimisation.  Binary, real-valued, and permutation
representations are available to optimize a fitness function, i.e., a function
provided by users depending on their objective function.  Several genetic
operators are available and can be combined to explore the best settings for
the current task.  Furthermore, users can define new genetic operators and
easily evaluate their performances.  Local search using general-purpose
optimisation algorithms can be applied stochastically to exploit interesting
regions.  GAs can be run sequentially or in parallel, using an explicit
master-slave parallelisation or a coarse-grain islands approach.")
    (license license:gpl2+)))

(define-public r-gap
  (package
    (name "r-gap")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gap" version))
       (sha256
        (base32 "1pz0j3vglccrwm3p9lj6wbq58varb8b0xg5r97gmz8c3biprpzww"))))
    (properties `((upstream-name . "gap")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr r-gap-datasets r-ggplot2 r-plotly
                             r-rdpack))
    (native-inputs (list gfortran r-knitr))
    (home-page "https://github.com/jinghuazhao/R")
    (synopsis "Genetic analysis package")
    (description
     "This package is designed as an integrated package for genetic data
analysis of both population and family data.  Currently, it contains functions
for sample size calculations of both population-based and family-based
designs, probability of familial disease aggregation, kinship calculation,
statistics in linkage analysis, and association analysis involving genetic
markers including haplotype analysis with or without environmental covariates.
Over years, the package has been developed in-between many projects hence also
in line with the name (gap).")
    (license license:gpl2+)))

(define-public r-gap-datasets
  (package
    (name "r-gap-datasets")
    (version "0.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gap.datasets" version))
       (sha256
        (base32 "1jwpsb66sgj2zzgrpgwxc22df66gbhi278ywbmaicc10mipv050y"))))
    (properties `((upstream-name . "gap.datasets")))
    (build-system r-build-system)
    (home-page "https://jinghuazhao.github.io/R/")
    (synopsis "Datasets for gap")
    (description
     "This package provides datasets associated with the gap package.
Currently, it includes an example data for regional association plot (CDKN),
an example data for a genomewide association meta-analysis (OPG), data in
studies of Parkinson's diease (PD), ALHD2 markers and alcoholism (aldh2),
APOE/APOC1 markers and Schizophrenia (apoeapoc), cystic fibrosis (cf), a
Olink/INF panel (inf1), Manhattan plots with
(hr1420, mhtdata) and without (w4) gene annotations.")
    (license license:gpl2+)))

(define-public r-grandr
  (package
    (name "r-grandr")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grandR" version))
       (sha256
        (base32 "058cvcjrqhgm14vyhlm1mdhs3z0kfpjlfc3msadsvlhlb7p676sn"))))
    (properties `((upstream-name . "grandR")))
    (build-system r-build-system)
    (propagated-inputs (list r-cowplot
                             r-ggplot2
                             r-labeling
                             r-lfc
                             r-mass
                             r-matrix
                             r-minpack-lm
                             r-numderiv
                             r-patchwork
                             r-plyr
                             r-rcurl
                             r-reshape2
                             r-rlang
                             r-scales))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/erhard-lab/grandR")
    (synopsis
     "Comprehensive analysis of nucleotide conversion sequencing data")
    (description
     "Nucleotide conversion sequencing experiments have been developed to add
a temporal dimension to RNA-seq and single-cell RNA-seq.  Such experiments
require specialized tools for primary processing such as GRAND-SLAM, and
specialized tools for downstream analyses. @code{grandR} provides a
comprehensive toolbox for quality control, kinetic modeling, differential gene
expression analysis and visualization of such data.")
    (license license:asl2.0)))

(define-public r-greg
  (package
    (name "r-greg")
    (version "2.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Greg" version))
       (sha256
        (base32 "13rsah8vf9s8wpkr5hlayyqa8v728cz80bvpg8vmlvnam8isb30s"))))
    (properties `((upstream-name . "Greg")))
    (build-system r-build-system)
    (propagated-inputs (list r-broom
                             r-dplyr
                             r-epi
                             r-forestplot
                             r-glue
                             r-gmisc
                             r-hmisc
                             r-htmltable
                             r-knitr
                             r-nlme
                             r-purrr
                             r-rlang
                             r-rms
                             r-sandwich
                             r-stringr
                             r-tibble
                             r-tidyr
                             r-tidyselect))
    (native-inputs (list r-boot r-knitr r-testthat r-tidyverse))
    (home-page "http://gforge.se")
    (synopsis "Regression helper functions")
    (description
     "This package provides methods for manipulating regression models and for
describing these in a style adapted for medical journals.  It contains
functions for generating an HTML table with crude and adjusted estimates,
plotting hazard ratio, plotting model estimates and confidence intervals using
forest plots, extending this to comparing multiple models in a single forest
plots.  In addition to the descriptive methods, there are functions for the
robust covariance matrix provided by the sandwich package, a function for
adding non-linearities to a model, and a wrapper around the Epi package's
@code{Lexis()} functions for time-splitting a dataset when modeling
non-proportional hazards in Cox regressions.")
    (license license:gpl3+)))

(define-public r-grr
  (package
    (name "r-grr")
    (version "0.9.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "grr" version))
       (sha256
        (base32
         "0arbcgrvhkwb5xk4nry1ffg2qj0v8ivhjghdr505ib4357g0c9i9"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/grr")
    (synopsis "Alternative implementations of base R functions")
    (description
     "This package provides alternative implementations of some base R
functions, including @code{sort}, @code{order}, and @code{match}.  The
functions are simplified but can be faster or have other advantages.")
    (license license:gpl3)))

(define-public r-magrittr
  (package
    (name "r-magrittr")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magrittr" version))
       (sha256
        (base32 "1ljmrrm36y31db5z4cl863ap8k3jcaxk0qzy3f0cn6iag4zzigx2"))))
    (properties
     ;; We can't have r-knitr or r-testthat among the inputs here, because
     ;; that would lead to dependency cycles.
     '((updater-ignored-native-inputs . ("r-knitr" "r-testthat"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, which uses this package.
    (arguments (list #:tests? #false))
    (home-page "https://cran.r-project.org/web/packages/magrittr/index.html")
    (synopsis "Forward-pipe operator for R")
    (description
     "Magrittr provides a mechanism for chaining commands with a new
forward-pipe operator, @code{%>%}.  This operator will forward a value, or the
result of an expression, into the next function call/expression.  There is
flexible support for the type of right-hand side expressions.  For more
information, see package vignette.  To quote Rene Magritte, \"Ceci n'est pas
un pipe.\"")
    (license license:expat)))

(define-public r-marginaleffects
  (package
    (name "r-marginaleffects")
    (version "0.26.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "marginaleffects" version))
       (sha256
        (base32 "1l78j10y1fv59wijwahb1hz919g5b0w1mi8snvb8mcrgdbwrd60j"))))
    (properties `((upstream-name . "marginaleffects")))
    (build-system r-build-system)
    (propagated-inputs (list r-backports
                             r-checkmate
                             r-data-table
                             r-formula
                             r-generics
                             r-insight
                             r-rcpp
                             r-rcppeigen
                             r-rlang))
    (native-inputs (list r-knitr r-quarto r-spelling r-tinytest))
    (home-page "https://marginaleffects.com/")
    (synopsis
     "Predictions, comparisons, slopes, marginal means, and hypothesis tests")
    (description
     "This package lets you compute and plot predictions, slopes, marginal
means, and comparisons (contrasts, risk ratios, odds, etc.) for over 100
classes of statistical and machine learning models in R.  Conduct linear and
non-linear hypothesis tests, or equivalence tests.  Calculate uncertainty
estimates using the delta method, bootstrapping, or simulation-based
inference.  Details can be found in Arel-Bundock, Greifer, and Heiss (2024)
<doi:10.18637/jss.v111.i09>.")
    (license license:gpl3+)))

(define-public r-markdown
  (package
    (name "r-markdown")
    (version "2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "markdown" version))
              (sha256
               (base32
                "0hcmpy4x2rwq061ybq1xyqxbc76jm0zfzgzy70g90y38zdsxwq55"))))
    (build-system r-build-system)
    ;; Skip check phase because the tests require the r-knitr package to be
    ;; installed. This prevents installation failures. Knitr normally
    ;; shouldn't be available since r-markdown is a dependency of the r-knitr
    ;; package.
    (arguments `(#:tests? #f))
    (propagated-inputs
     (list r-litedown r-xfun))
    (home-page "https://github.com/rstudio/markdown")
    (synopsis "Markdown rendering for R")
    (description
     "This package provides R bindings to the Sundown Markdown rendering
library (https://github.com/vmg/sundown).  Markdown is a plain-text formatting
syntax that can be converted to XHTML or other formats.")
    (license license:gpl2)))

(define-public r-mass
  (package
    (name "r-mass")
    (version "7.3-65")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MASS" version))
       (sha256
        (base32
         "0bqp73z8qmxv6ws2k4agamvci1wzricpg2jakck5dkk4qgiz2zmh"))))
    (properties `((upstream-name . "MASS")))
    (build-system r-build-system)
    (home-page "https://www.stats.ox.ac.uk/pub/MASS4/")
    (synopsis "Support functions and datasets for Venables and Ripley's MASS")
    (description
     "This package provides functions and datasets for the book \"Modern
Applied Statistics with S\" (4th edition, 2002) by Venables and Ripley.")
    ;; Either version may be picked.
    (license (list license:gpl2 license:gpl3))))

(define-public r-matrix
  (package
    (name "r-matrix")
    (version "1.7-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Matrix" version))
       (sha256
        (base32
         "0kml1zq2vsbipwwx3hn54p4vvvgp9dimmzbj342jmwyxikdyjhk6"))))
    (properties
     `((upstream-name . "Matrix")
       ;; Needed for vignettes.
       (updater-extra-native-inputs . ("r-mass"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      (if (or (target-x86-32?) (target-arm32?))
          '(modify-phases %standard-phases
             (add-after 'unpack 'disable-bad-tests
               (lambda _
                 ;; Some of these tests fail on 32 bit architectures.
                 (delete-file "tests/matprod.R"))))
          '%standard-phases)))
    (propagated-inputs
     (list r-lattice))
    (native-inputs (list r-codetools r-mass r-sfsmisc r-sparsem))
    (home-page "https://Matrix.R-forge.R-project.org/")
    (synopsis "Sparse and dense matrix classes and methods")
    (description
     "This package provides classes and methods for dense and sparse matrices
and operations on them using LAPACK and SuiteSparse.")
    (license license:gpl2+)))

(define-public r-matrixmodels
  (package
    (name "r-matrixmodels")
    (version "0.5-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MatrixModels" version))
       (sha256
        (base32
         "0g7k3kag492rbacnm6d11q6xxiy6h9j88ihfg5vylgsslghgjypm"))))
    (properties `((upstream-name . "MatrixModels")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (home-page "https://cran.r-project.org/web/packages/MatrixModels")
    (synopsis "Modelling with sparse and dense matrices")
    (description
     "This package models with sparse and dense matrix matrices,
using modular prediction and response module classes.")
    (license license:gpl2+)))

(define-public r-matrixstats
  (package
    (name "r-matrixstats")
    (version "1.5.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "matrixStats" version))
              (sha256
               (base32
                "05fcbpwrrs3y5ia15x88x7br7ympf5mg31qh7sj05hkg7rgnr68j"))))
    (properties `((upstream-name . "matrixStats")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list r-covr r-r-rsp)) ;used to build vignettes
    (home-page "https://github.com/HenrikBengtsson/matrixStats")
    (synopsis "Methods applying to vectors and matrix rows and columns")
    (description
     "This package provides methods operating on rows and columns of matrices,
e.g.  @code{rowMedians()}, @code{rowRanks()}, and @code{rowSds()}.  There are
also some vector-based methods, e.g. @code{binMeans()}, @code{madDiff()} and
@code{weightedMedians()}.  All methods have been optimized for speed and
memory usage.")
    (license license:artistic2.0)))

(define-public r-matrixtests
  (package
    (name "r-matrixtests")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "matrixTests" version))
       (sha256
        (base32 "0d7i00cxzszfdnjm8q5b72ildic8nig6fbw7rba6acdnllpp7sza"))))
    (properties `((upstream-name . "matrixTests")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrixstats))
    (native-inputs
     (list r-car r-cosinor r-cosinor2 r-moments r-nortest r-pmcmrplus))
    (home-page "https://github.com/karoliskoncevicius/matrixTests")
    (synopsis "Statistical hypothesis tests on rows and columns of matrices")
    (description
     "This package offers quick statistical hypothesis testing for matrix
rows/columns.  The main goals are speed through vectorization, detailed and
user-friendly output, and compatibility with tests implemented in R.")
    (license license:gpl2)))

(define-public r-matrix-utils
  (package
    (name "r-matrix-utils")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Matrix.utils" version))
       (sha256
        (base32
         "0a5fq1scykqk0kc9j051j6fix6j2dqwz5wbgb0amaxsiywz9vigb"))))
    (properties `((upstream-name . "Matrix.utils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-grr r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/cvarrichio/Matrix.utils")
    (synopsis
     "Data.frame-Like Operations on Sparse and Dense Matrix Objects")
    (description
     "This package implements data manipulation methods such as @code{cast},
@code{aggregate}, and @code{merge}/@code{join} for Matrix and Matrix-like
objects.")
    (license license:gpl3)))

(define-public r-mblm
  (package
    (name "r-mblm")
    (version "0.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mblm" version))
       (sha256
        (base32 "1fipb3bryaimr30lcxsxrn0ymv24z39swca7s4z7p9xcfg3ban1b"))))
    (properties `((upstream-name . "mblm")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mblm/index.html")
    (synopsis "Median-based linear models")
    (description
     "This package provides linear models based on Theil-Sen single median and
Siegel repeated medians.  They are very robust (29 or 50 percent breakdown
point, respectively), and if no outliers are present, the estimators are very
similar to OLS.")
    (license license:gpl2+)))

(define-public r-mboost
  (package
   (name "r-mboost")
   (version "2.9-11")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "mboost" version))
            (sha256
             (base32
              "0n5wpyayhdyd46vl87c9r70m13y48khmlwii58rvi57mgw6aadwz"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-lattice
          r-matrix
          r-nnls
          r-partykit
          r-quadprog
          r-stabs
          r-survival))
   (native-inputs (list r-testthat))
   (home-page "https://github.com/boost-R/mboost")
   (synopsis "Model-based boosting")
   (description
    "This package provides a functional gradient descent algorithm (boosting)
for optimizing general risk functions utilizing component-wise (penalised)
least squares estimates or regression trees as base-learners for fitting
generalized linear, additive and interaction models to potentially
high-dimensional data.")
   (license license:gpl2)))

(define-public r-mc2d
  (package
    (name "r-mc2d")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mc2d" version))
              (sha256
               (base32
                "06kva55vm2cldd95caw5hfx0xjadyhgkqi0y9pyz7hs3zg0zq9xy"))))
    (properties `((upstream-name . "mc2d")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-ggpubr r-mvtnorm))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=mc2d")
    (synopsis "Tools for two-dimensional monte-carlo simulations")
    (description
     "This is a framework for construction and analysis of 2D Monte-Carlo
simulations.  In addition, this package includes various distributions.")
    (license license:gpl2+)))

(define-public r-mclogit
  (package
    (name "r-mclogit")
    (version "0.9.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mclogit" version))
              (sha256
               (base32
                "0sbglgak6jhhpx65jnj59hbpvzs8qjsdjc4w02z0m5j9hrnmzp4s"))))
    (properties `((upstream-name . "mclogit")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-memisc))
    (home-page "https://www.elff.eu/software/mclogit/")
    (synopsis
     "Multinomial logit models, with or without random effects or overdispersion")
    (description
     "This package provides estimators for multinomial logit models in their
conditional logit and baseline logit variants, with or without random effects,
with or without overdispersion.  Random effects models are estimated using the
PQL technique (based on a Laplace approximation) or the MQL technique (based
on a Solomon-Cox approximation).  Estimates should be treated with caution if
the group sizes are small.")
    (license license:gpl2)))

(define-public r-mclust
  (package
    (name "r-mclust")
    (version "6.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mclust" version))
       (sha256
        (base32
         "0xb726ssy224mzfg37nq5hffkdwi2hwjp1y9gwngk9vfbs703myx"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran r-knitr))
    (home-page "https://www.stat.washington.edu/mclust/")
    (synopsis "Gaussian mixture modelling for model-based clustering etc.")
    (description
     "This package provides Gaussian finite mixture models fitted via EM
algorithm for model-based clustering, classification, and density estimation,
including Bayesian regularization, dimension reduction for visualisation, and
resampling-based inference.")
    (license license:gpl2+)))

(define-public r-mcmcglmm
  (package
    (name "r-mcmcglmm")
    (version "2.36")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MCMCglmm" version))
       (sha256
        (base32 "1wca9x5c9x88cryj1pkhl73chmnbc1653j08faz7lp03z2mdkzv6"))))
    (properties `((upstream-name . "MCMCglmm")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape
                             r-coda
                             r-corpcor
                             r-cubature
                             r-matrix
                             r-tensora))
    (home-page "https://github.com/jarrodhadfield/MCMCglmm")
    (synopsis "MCMC generalised linear mixed models")
    (description
     "This package fits multivariate generalized linear mixed models and
related models.  This is done using Markov chain Monte Carlo techniques.")
    (license license:gpl2+)))

(define-public r-mcr
  (package
    (name "r-mcr")
    (version "1.3.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mcr" version))
       (sha256
        (base32 "0gbpnbs8mgqpyiayddcaf1xwh908gk1n375bqpnvfppyj0wz3yr9"))))
    (properties `((upstream-name . "mcr")))
    (build-system r-build-system)
    (propagated-inputs (list r-robslopes))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=mcr")
    (synopsis "Method comparison regression")
    (description
     "Regression methods to quantify the relation between two measurement
methods are provided by this package.  In particular it addresses regression
problems with errors in both variables and without repeated measurements.  It
implements the CLSI recommendations (see J. A. Budd et al. (2018,
@url{https://clsi.org/standards/products/method-evaluation/documents/ep09/})
for analytical method comparison and bias estimation using patient samples.
Furthermore, algorithms for Theil-Sen and equivariant Passing-Bablok
estimators are implemented, see F. Dufey (2020, <doi:10.1515/ijb-2019-0157>)
and J. Raymaekers and F. Dufey (2022, <@code{arXiv:2202:08060>}).  A
comprehensive overview over the implemented methods and references can be
found in the manual pages @code{mcr-package} and @code{mcreg}.")
    (license license:gpl3+)))

(define-public r-memoise
  (package
    (name "r-memoise")
    (version "2.0.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "memoise" version))
              (sha256
               (base32
                "1srdzv2bp0splislrabmf1sfbqfi3hn189nq7kxhgjn8k3p38l7q"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cachem r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hadley/memoise")
    (synopsis "Memoise functions for R")
    (description
     "This R package caches the results of a function so that when
you call it again with the same arguments it returns the pre-computed value.")
    (license license:expat)))

(define-public r-mgcv
  (package
    (name "r-mgcv")
    (version "1.9-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mgcv" version))
       (sha256
        (base32 "079gv1gm8gvsmpkccr3hr6y1ybi2b440m6mygcfhm2bnl7dwrw23"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-nlme))
    (home-page "https://cran.r-project.org/web/packages/mgcv")
    (synopsis "Mixed generalised additive model computation")
    (description
     "GAMs, GAMMs and other generalized ridge regression with multiple smoothing
parameter estimation by GCV, REML or UBRE/AIC.  The library includes a
@code{gam()} function, a wide variety of smoothers, JAGS support and
distributions beyond the exponential family.")
    (license license:gpl2+)))

(define-public r-microbenchmark
  (package
    (name "r-microbenchmark")
    (version "1.5.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "microbenchmark" version))
              (sha256
               (base32
                "0pvn94zfv50imz5g39wyqbqaa7fkl0h5sy98ic9as4b842lr47ix"))))
    (build-system r-build-system)
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/microbenchmark/")
    (synopsis "Accurate timing functions for R")
    (description
     "This package provides infrastructure to accurately measure and compare
the execution time of R expressions.")
    (license license:bsd-2)))

(define-public r-mime
  (package
    (name "r-mime")
    (version "0.13")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mime" version))
              (sha256
               (base32
                "1szkqzily5sr1qlnrlrprid2gy5wkzb7dlxs2bzqwf63yd686cki"))))
    (build-system r-build-system)
    (home-page "https://github.com/yihui/mime")
    (synopsis "R package to map filenames to MIME types")
    (description
     "This package guesses the MIME type from a filename extension using the
data derived from /etc/mime.types in UNIX-type systems.")
    (license license:gpl2)))

(define-public r-minqa
  (package
    (name "r-minqa")
    (version "1.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "minqa" version))
       (sha256
        (base32
         "0rslvg4imaijzb5z6vzsx4zqhrna1jk6qkp2kxnzqy0rn2wy8har"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list gfortran))
    (home-page "https://optimizer.r-forge.r-project.org")
    (synopsis "Derivative-free optimization algorithms by quadratic approximation")
    (description
     "This package provides a derivative-free optimization by quadratic
approximation based on an interface to Fortran implementations by
M. J. D. Powell.")
    (license license:gpl2)))

(define-public r-mirai
  (package
    (name "r-mirai")
    (version "2.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mirai" version))
       (sha256
        (base32 "0cczacjlwrr5m2drpa62sp9bixw39qbjp5n1cihkfj1jj9jal5wz"))))
    (properties `((upstream-name . "mirai")))
    (build-system r-build-system)
    (propagated-inputs (list r-nanonext))
    (native-inputs (list r-litedown r-promises))
    (home-page "https://shikokuchuo.net/mirai/")
    (synopsis "Minimalist async evaluation framework for R")
    (description
     "Designed for simplicity, a mirai evaluates an R expression
asynchronously in a parallel process, locally or distributed over the network.
The result is automatically available upon completion.  Modern networking and
concurrency, built on nanonext and NNG (Nanomsg Next Gen), ensures reliable
and efficient scheduling over fast inter-process communications or TCP/IP
secured by TLS.  Distributed computing can launch remote resources via SSH or
cluster managers.  An inherently queued architecture handles many more tasks
than available processes, and requires no storage on the file system.
Innovative features include support for otherwise non-exportable reference
objects, event-driven promises, and asynchronous parallel map.")
    (license license:gpl3+)))

(define-public r-mixtools
  (package
    (name "r-mixtools")
    (version "2.0.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mixtools" version))
       (sha256
        (base32
         "1hcpijmddibhfxhq6d8lgi7m1x6ylf97y9ns0l8li3a1bvc438ws"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernlab
           r-mass
           r-plotly
           r-scales
           r-segmented
           r-survival))
    (home-page "https://cran.r-project.org/web/packages/mixtools")
    (synopsis "Tools for analyzing finite mixture models")
    (description
     "This package provides a collection of R functions for analyzing finite
mixture models.")
    (license license:gpl2+)))

(define-public r-mnormt
  (package
    (name "r-mnormt")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
        (uri (cran-uri "mnormt" version))
        (sha256
          (base32
           "020ka48jsxm9l109ksvy2l17xcpm51avm0l971dgs2mgg01sgz4m"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "http://azzalini.stat.unipd.it/SW/Pkg-mnormt")
    (synopsis "Multivariate normal and \"t\" distributions")
    (description
     "This package provides functions for computing the density and the
distribution function of multivariate normal and \"t\" random variables, and
for generating random vectors sampled from these distributions.  Probabilities
are computed via non-Monte Carlo methods.")
    (license license:gpl2+)))

(define-public r-modelmetrics
  (package
    (name "r-modelmetrics")
    (version "1.2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ModelMetrics" version))
       (sha256
        (base32
         "0mrlsw4c5y1vdsqynxr2dcvmhh5h37pnd71jw5a5djpbda9g21jy"))))
    (properties `((upstream-name . "ModelMetrics")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/ModelMetrics")
    (synopsis "Rapid calculation of model metrics")
    (description
     "Written in C++ using @code{Rcpp}, this package provides a collection of
metrics for evaluating models.")
    (license license:gpl2+)))

(define-public r-modeltools
  (package
    (name "r-modeltools")
    (version "0.2-24")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "modeltools" version))
       (sha256
        (base32
         "1bqyrslar36ja8gjdj3y5b82vqc2y5kbyw3vqgr2cmakgj4qbcpq"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/modeltools")
    (synopsis "Tools and classes for statistical models")
    (description
     "This package provides a collection of tools to deal with statistical
models.  The functionality is experimental and the user interface is likely to
change in the future.")
    (license license:gpl2)))

(define-public r-multilevel
  (package
    (name "r-multilevel")
    (version "2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multilevel" version))
       (sha256
        (base32 "0ds7q3q2ncldb4iik24xisyxyyv1yv8l1yz7zd7cy036bna1yp5i"))))
    (properties `((upstream-name . "multilevel")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass r-nlme))
    (home-page "https://www.r-project.org")
    (synopsis "Multilevel functions")
    (description
     "This package provides tools used by organizational researchers for the
analysis of multilevel data.  It includes four broad sets of tools.

@enumerate
@item functions for estimating within-group agreement and reliability indices.
@item functions for manipulating multilevel and longitudinal (panel) data.
@item simulations for estimating power and generating multilevel data.
@item miscellaneous functions for estimating reliability and performing simple
  calculations and data transformations.
@end enumerate")
    (license license:gpl2+)))

(define-public r-multitaper
  (package
    (name "r-multitaper")
    (version "1.0-17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "multitaper" version))
       (sha256
        (base32
         "1wqa2whcjxwjqg9z46i48dvrga17fdj63r05kg993r1fpriclc1l"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://github.com/wesleyburr/multitaper/")
    (synopsis "Multitaper spectral analysis tools")
    (description
     "This package implements multitaper spectral estimation techniques using
prolate spheroidal sequences (Slepians) and sine tapers for time series
analysis.  It includes an adaptive weighted multitaper spectral estimate, a
coherence estimate, Thomson's Harmonic F-test, and complex demodulation.  The
Slepians sequences are generated efficiently using a tridiagonal matrix
solution, and jackknifed confidence intervals are available for most
estimates.")
    (license license:gpl2+)))

(define-public r-mumin
  (package
    (name "r-mumin")
    (version "1.48.11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "MuMIn" version))
              (sha256
               (base32
                "1rzsngmnyfscr42rkb9cm85s3xisgjrax2swcab7qzzkjh355wy1"))))
    (properties `((upstream-name . "MuMIn")))
    (build-system r-build-system)
    (propagated-inputs (list r-insight r-matrix r-nlme))
    (native-inputs (list r-mgcv r-survival))
    (home-page "https://cran.r-project.org/package=MuMIn")
    (synopsis "Multi-model inference")
    (description
     "Tools for performing model selection and model averaging.  Automated
model selection through subsetting the maximum model, with optional
constraints for model inclusion.  Model parameter and prediction averaging
based on model weights derived from information criteria (AICc and alike) or
custom model weighting schemes.")
    (license license:gpl2)))

(define-public r-munsell
  (package
    (name "r-munsell")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "munsell" version))
       (sha256
        (base32 "19i9jjawlqciw4n4h99a4sm0lbc77la3pqyzjvnwsrh7qjdgv8h3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/munsell")
    (synopsis "Munsell colour system")
    (description
     "The Munsell package contains functions for exploring and using the
Munsell colour system.")
    (license license:expat)))

(define-public r-mvtnorm
  (package
    (name "r-mvtnorm")
    (version "1.3-3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mvtnorm" version))
              (sha256
               (base32
                "0wa1zal0q8zawqrjllx70kakn3ynpsm0imb3mmc956y89d9py3p2"))))
    (build-system r-build-system)
    ;; Do not build vignettes because there are weave errors in lmvnorm_src.R.
    (arguments (list #:test-types '(list "tests")))
    (native-inputs
     (list gfortran r-numderiv))
    (home-page "https://mvtnorm.R-forge.R-project.org")
    (synopsis "Package for multivariate normal and t-distributions")
    (description "This package can compute multivariate normal and
t-probabilities, quantiles, random deviates and densities.")
    (license license:gpl2)))

(define-public r-shadowtext
  (package
    (name "r-shadowtext")
    (version "0.1.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shadowtext" version))
              (sha256
               (base32
                "1s3fsh6cmblyhlqrswialc9437as306ki36dyx0dv4001slvxl47"))))
    (properties `((upstream-name . "shadowtext")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/GuangchuangYu/shadowtext/")
    (synopsis "Shadow text grob and layer")
    (description "This package implements @code{shadowtextGrob()} for
@code{grid} and @code{geom_shadowtext()} layer for @code{ggplot2}.
These functions draw text grob with background shadow.")
    (license license:artistic2.0)))

(define-public r-sys
  (package
    (name "r-sys")
    (version "3.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sys" version))
       (sha256
        (base32
         "0flihfpfawismsy5piddf2flz1i1fw35k47gxwkbhk87wcr767h5"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jeroen/sys")
    (synopsis "Powerful and reliable tools for running system commands in R")
    (description
     "This package provides drop-in replacements for the base @code{system2()}
function with fine control and consistent behavior across platforms.  It
supports clean interruption, timeout, background tasks, and streaming STDIN /
STDOUT / STDERR over binary or text connections.  The package also provides
functions for evaluating expressions inside a temporary fork.  Such
evaluations have no side effects on the main R process, and support reliable
interrupts and timeouts.  This provides the basis for a sandboxing
mechanism.")
    (license license:expat)))

(define-public r-ashr
  (package
   (name "r-ashr")
   (version "2.2-63")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ashr" version))
            (sha256
             (base32
              "1japskxfdsg91jwgf5knlwy9iaq4ziqvyvlvjch1y3ygsdz9b8bz"))))
   (properties `((upstream-name . "ashr")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-etrunct
          r-invgamma
          r-matrix
          r-mixsqp
          r-rcpp
          r-squarem
          r-truncnorm))
   (native-inputs
    (list r-knitr r-testthat))
   (home-page "https://github.com/stephens999/ashr")
   (synopsis "Methods for adaptive shrinkage, using empirical bayes")
   (description "This package implements an empirical Bayes approach for
large-scale hypothesis testing and false discovery rate estimation.")
   (license license:gpl3+)))

(define-public r-askpass
  (package
    (name "r-askpass")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "askpass" version))
       (sha256
        (base32
         "1pf7q2p0caxnb22zvg6yj250b817drldk5d7rvr4i9s49jkhc8bc"))))
    (build-system r-build-system)
    (propagated-inputs (list r-sys))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jeroen/askpass")
    (synopsis "Safe password entry for R")
    (description
     "This package provides cross-platform utilities for prompting the user
for credentials or a passphrase, for example to authenticate with a server or
read a protected key.")
    (license license:expat)))

(define-public r-astsa
  (package
    (name "r-astsa")
    (version "2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "astsa" version))
       (sha256
        (base32 "1ds94p5wiyl5jl4b8c9b2zdz9m37px5bnx3ln4288fgh8av2rscz"))))
    (properties `((upstream-name . "astsa")))
    (build-system r-build-system)
    (home-page "https://github.com/nickpoison/astsa/")
    (synopsis "Applied statistical time series analysis")
    (description
     "This package provides data sets and scripts to accompany Time Series
Analysis and Its Applications: With R Examples (4th ed), by R.H. Shumway and
D.S. Stoffer.  Springer Texts in Statistics, 2017,
@url{https://doi.org/10.1007/978-3-319-52452-8}, and Time Series: A Data
Analysis Approach Using R.  Chapman-Hall, 2019,
@url{https://doi.org/10.1201/9780429273285}.")
    (license license:gpl3)))

(define-public r-vegan
  (package
    (name "r-vegan")
    (version "2.6-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vegan" version))
       (sha256
        (base32
         "1dxwqzsmbx129lpykjb4gqvxp79qy1j41w99xdmjxs5ph42bkd5g"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran r-compositions r-knitr))
    (propagated-inputs
     (list r-cluster r-lattice r-mass r-mgcv r-permute))
    (home-page "https://cran.r-project.org/web/packages/vegan")
    (synopsis "Functions for community ecology")
    (description
     "The vegan package provides tools for descriptive community ecology.  It
has most basic functions of diversity analysis, community ordination and
dissimilarity analysis.  Most of its multivariate tools can be used for other
data types as well.")
    (license license:gpl2+)))

(define-public r-tglkmeans
  (package
    (name "r-tglkmeans")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tglkmeans" version))
       (sha256
        (base32 "0hdnxgkxpgb8jm9aygv3wlhd42blm5nz906vlpl72blgcyc77hhh"))))
    (properties `((upstream-name . "tglkmeans")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dofuture
                             r-dorng
                             r-dplyr
                             r-future
                             r-ggplot2
                             r-magrittr
                             r-matrix
                             r-plyr
                             r-purrr
                             r-rcpp
                             r-rcppparallel
                             r-tgstat
                             r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://tanaylab.github.io/tglkmeans/")
    (synopsis "Efficient implementation of K-Means++ algorithm")
    (description
     "This package provides an efficient implementation of the K-Means++
algorithm.  For more information see (1) \"kmeans++ the advantages of the
k-means++ algorithm\" by David Arthur and Sergei Vassilvitskii (2007),
Proceedings of the eighteenth annual ACM-SIAM symposium on Discrete
algorithms, Society for Industrial and Applied Mathematics, Philadelphia, PA,
USA, pp. 1027-1035, and (2) \"The Effectiveness of Lloyd-Type Methods for the
k-Means Problem\" by Rafail Ostrovsky, Yuval Rabani, Leonard J. Schulman and
Chaitanya Swamy <doi:10.1145/2395116.2395117>.")
    (license license:expat)))

(define-public r-tgp
  (package
    (name "r-tgp")
    (version "2.4-23")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tgp" version))
              (sha256
               (base32
                "074d2c88ydgmggz24hqkxb8sqvbcgf5d32dhcxwa79snv8br5aqd"))))
    (properties `((upstream-name . "tgp")))
    (build-system r-build-system)
    (propagated-inputs (list r-maptree))
    (home-page "https://bobby.gramacy.com/r_packages/tgp/")
    (synopsis "Bayesian treed Gaussian process models")
    (description
     "R-tgb provides Bayesian nonstationary regression and treed Gaussian
processes.  In addition, it provides visualization functions, tree drawing,
sensitivity analysis, multi-resolution models, and sequential experimental
design tools, including ALM, ALC, and expected improvement for optimizing
noisy black-box functions.")
    (license license:lgpl2.0+)))

(define-public r-tgstat
  (package
    (name "r-tgstat")
    (version "2.3.28")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tgstat" version))
       (sha256
        (base32 "0gn7xpbl7y86n19y8jvw00m03p3aff78yv2g62yp96bi7qygaq2a"))))
    (properties `((upstream-name . "tgstat")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=tgstat")
    (synopsis "Amos Tanay's Group High Performance Statistical Utilities")
    (description
     "This package provides a collection of high-performance utilities.
It can be used to compute distances, correlations, autocorrelations,
clustering, and other tasks.  It also contains a graph clustering
algorithm described in MetaCell analysis of single-cell RNA-seq
data using K-nn graph partitions.")
    (license license:gpl2)))

(define-public r-tictoc
  (package
    (name "r-tictoc")
    (version "1.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tictoc" version))
              (sha256
               (base32
                "0cw8r1gn4p2v1l3d80brk9sfr9nyckyyym5nr9xq3d74l74vgkcg"))))
    (properties `((upstream-name . "tictoc")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jabiru/tictoc")
    (synopsis
     "Time R scripts and implementations of stack and list structures")
    (description
     "The tictoc package provides the timing functions @code{tic} and
@code{toc} that can be nested.  It provides an alternative to
@code{system.time()} with a different syntax similar to that in another
well-known software package.  @code{tic} and @code{toc} are easy to use, and
are especially useful when timing several sections in more than a few lines of
code.")
    (license license:asl2.0)))

(define-public r-tidyclust
  (package
    (name "r-tidyclust")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidyclust" version))
       (sha256
        (base32 "09z4p01l76wyc1dzkz1ggvbwcdih1c515amwm54mx5rvpmvmdw64"))))
    (properties
     '((upstream-name . "tidyclust")
       (updater-extra-native-inputs
        . ("r-cluster" "r-clustmixtype" "r-rcpphungarian"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dials
                             r-dplyr
                             r-flexclust
                             r-foreach
                             r-generics
                             r-glue
                             r-hardhat
                             r-modelenv
                             r-parsnip
                             r-philentropy
                             r-prettyunits
                             r-rlang
                             r-rsample
                             r-tibble
                             r-tidyr
                             r-tune
                             r-vctrs))
    (native-inputs
     (list r-cluster r-clusterr r-clustmixtype r-rcpphungarian
           r-recipes r-testthat r-workflows))
    (home-page "https://github.com/tidymodels/tidyclust")
    (synopsis "Common API to clustering")
    (description
     "This package provides a common interface to specifying clustering
models, in the same style as parsnip.  It creates a unified interface across
different functions and computational engines.")
    (license license:expat)))

(define-public r-tidyft
  (package
    (name "r-tidyft")
    (version "0.9.20")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "tidyft" version))
              (sha256
               (base32
                "144w36q4yrscdvv3jq7h6s6pklm3l4m5rv005hr1akvn9d7klcq9"))))
    (properties `((upstream-name . "tidyft")))
    (build-system r-build-system)
    (propagated-inputs (list r-data-table r-fst r-stringr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/hope-data-science/tidyft")
    (synopsis "Fast and memory efficient data operations in tidy syntax")
    (description "Tidyft is an extension of @code{data.table}.  It uses
modifification by reference whenever possible.  This toolkit is designed for
big data analysis in high-performance desktop or laptop computers.  The syntax
of the package is similar or identical to tidyverse.")
    (license license:expat)))

(define-public r-tidyverse
  (package
    (name "r-tidyverse")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tidyverse" version))
       (sha256
        (base32
         "1r980y6d4a5brvxwdx41qzi8f3fck36c5l89sd3k4csna09jsg1x"))))
    (properties
     '((updater-extra-native-inputs . ("r-mockr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-cli
           r-conflicted
           r-dbplyr
           r-dplyr
           r-dtplyr
           r-forcats
           r-ggplot2
           r-googledrive
           r-googlesheets4
           r-haven
           r-hms
           r-httr
           r-jsonlite
           r-lubridate
           r-magrittr
           r-modelr
           r-pillar
           r-purrr
           r-ragg
           r-readr
           r-readxl
           r-reprex
           r-rlang
           r-rstudioapi
           r-rvest
           r-stringr
           r-tibble
           r-tidyr
           r-xml2))
    (native-inputs
     (list r-knitr r-mockr r-testthat))
    (home-page "https://tidyverse.tidyverse.org")
    (synopsis "Install and load packages from the \"Tidyverse\"")
    (description
     "The @code{tidyverse} is a set of packages that work in harmony because
they share common data representations and API design.  This package is
designed to make it easy to install and load multiple tidyverse packages in a
single step.")
    (license license:gpl3)))

(define-public r-tis
  (package
    (name "r-tis")
    (version "1.39")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tis" version))
       (sha256
        (base32 "1sq3acz8mybsbxng5fga4ynqvh1ly9hs3ca727jiyx1gam712mis"))))
    (properties `((upstream-name . "tis")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=tis")
    (synopsis "Time indexes and time indexed series")
    (description
     "This package provides functions and S3 classes for time indexes and time
indexed series, which are compatible with FAME frequencies.")
    ;; Unlimited distribution
    (license (license:non-copyleft "file://DESCRIPTION"))))

(define-public r-tkrplot
  (package
    (name "r-tkrplot")
    (version "0.0-30")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tkrplot" version))
       (sha256
        (base32 "1qfb5jiajlfa6y5hr4qwmv11fh3w0pfwdm3mrv9gw0j13xx9jv6c"))))
    (properties
     '((upstream-name . "tkrplot")
       (updater-extra-inputs . ("libx11"))))
    (build-system r-build-system)
    (inputs (list libx11))
    (home-page "https://cran.r-project.org/package=tkrplot")
    (synopsis "Place R graphics in a Tk widget")
    (description
     "The tkrplot package lets you place R graphics in a @dfn{Tk,
cross-platform graphical user interface toolkit} widget.")
    ;; Any version of the GPL.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-tmvtnorm
  (package
    (name "r-tmvtnorm")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tmvtnorm" version))
       (sha256
        (base32 "1fhvisddn3x4li2q12c3hss0cj735c0iq32c9cw646ni619jr6rd"))))
    (properties `((upstream-name . "tmvtnorm")))
    (build-system r-build-system)
    (propagated-inputs (list r-gmm r-matrix r-mvtnorm))
    (native-inputs (list gfortran))
    (home-page "https://www.r-project.org")
    (synopsis "Truncated multivariate normal and Student t distribution")
    (description
     "This is a package for random number generation for the truncated
multivariate normal and Student t distribution.  It computes probabilities,
quantiles and densities, including one-dimensional and bivariate marginal
densities.  It computes first and second moments (i.e. mean and covariance
matrix) for the double-truncated multinormal case.")
    (license license:gpl2+)))

(define-public r-rvest
  (package
    (name "r-rvest")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rvest" version))
       (sha256
        (base32 "19lw0jk8d8x88z247hz761gwbx9f5n3yqnv63mn7pkwl55mpqw3x"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; These tests require Internet access.
             (delete-file "tests/testthat/test-session.R")
             ;; This fails with "Error: object 's' not found" because a
             ;; session could not be created.
             (delete-file "tests/testthat/test-rename.R"))))))
    (propagated-inputs
     (list r-cli
           r-glue
           r-httr
           r-lifecycle
           r-magrittr
           r-rlang
           r-selectr
           r-tibble
           r-xml2))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/hadley/rvest")
    (synopsis "Simple web scraping for R")
    (description
     "@code{r-rvest} helps you scrape information from web pages.  It is
designed to work with @code{magrittr} to make it easy to express common web
scraping tasks, inspired by libraries like @code{BeautifulSoup}.")
    (license license:gpl3)))

(define-public r-secretbase
  (package
    (name "r-secretbase")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "secretbase" version))
       (sha256
        (base32 "14dhdda0skxhj3ismlwc87c0gwvqswhgvp061nsi4ajfgk0593as"))))
    (properties `((upstream-name . "secretbase")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed by tests
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (home-page "https://shikokuchuo.net/secretbase/")
    (synopsis "Cryptographic Hash and Extendable-Output Functions")
    (description
     "This package provides implementations of the SHA-3 cryptographic hash
and SHAKE256 extendable-output functions (XOF).")
    (license license:gpl3+)))

(define-public r-selectr
  (package
    (name "r-selectr")
    (version "0.4-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "selectr" version))
       (sha256
        (base32 "09y1n3iy297g49xlpl7xrjpwgnm57pskx5991lyfcpizbz8ax22m"))))
    (properties
     '((updater-extra-native-inputs . ("r-xml" "r-xml2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-r6 r-stringr))
    (native-inputs (list r-testthat r-xml r-xml2))
    (home-page "https://sjp.co.nz/projects/selectr/")
    (synopsis "Translate CSS selectors to XPath expressions")
    (description
     "@code{r-selectr} translates a CSS3 selector into an equivalent XPath
expression.  This allows you to use CSS selectors when working with the XML
package as it can only evaluate XPath expressions.  Also provided are
convenience functions useful for using CSS selectors on XML nodes.  This
package is a port of the Python package @code{cssselect}.")
    (license license:bsd-3)))

(define-public r-redland
  (package
    (name "r-redland")
    (version "1.0.17-18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "redland" version))
       (sha256
        (base32 "183m1bvgj52w74383b5v6rfm7gn4izijixans1zdycqp68ibm6g9"))))
    (properties `((upstream-name . "redland")))
    (build-system r-build-system)
    (inputs (list redland pcre2 zlib))
    (propagated-inputs (list r-roxygen2))
    (native-inputs (list r-knitr pkg-config r-spelling r-stringi r-testthat))
    (home-page "https://cran.r-project.org/package=redland")
    (synopsis "RDF library bindings in R")
    (description
     "This package provides methods to parse, query and serialize information
stored in the @dfn{Resource Description Framework} (RDF).  This package
supports RDF by implementing an R interface to the Redland RDF C library.  In
brief, RDF provides a structured graph consisting of Statements composed of
Subject, Predicate, and Object Nodes.")
    (license license:asl2.0)))

(define-public r-redux
  (package
    (name "r-redux")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "redux" version))
       (sha256
        (base32 "1cbgc39avvjx1lqfrrwyq6fjm751i10gxhsfx67njg8ghj4pq790"))))
    (properties `((upstream-name . "redux")))
    (build-system r-build-system)
    (inputs (list hiredis))
    (propagated-inputs (list r-r6 r-storr))
    (native-inputs (list r-knitr pkg-config r-sys r-testthat))
    (home-page "https://github.com/richfitz/redux")
    (synopsis "R bindings to hiredis")
    (description
     "This package provides a @code{hiredis} wrapper that includes support for
transactions, pipelining, blocking subscription, serialisation of all keys and
values, Redis error handling with R errors.  It includes an automatically
generated R6 interface to the full @code{hiredis} API.  Generated functions
are faithful to the @code{hiredis} documentation while attempting to match R's
argument semantics.  Serialization must be explicitly done by the user, but
both binary and text-mode serialisation is supported.")
    (license license:gpl2)))

(define-public r-relations
  (package
    (name "r-relations")
    (version "0.6-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "relations" version))
       (sha256
        (base32 "1qm1z4cv1m7hvq4icvdyb8n026jr1550ibazpbmqwp5qk7mf73qp"))))
    (properties `((upstream-name . "relations")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster r-sets r-slam))
    (home-page "https://cran.r-project.org/package=relations")
    (synopsis "Data structures and algorithms for relations")
    (description
     "This package provides data structures and algorithms for k-ary relations
with arbitrary domains, featuring relational algebra, predicate functions, and
fitters for consensus relations.")
    (license license:gpl2)))

(define-public r-repmis
  (package
    (name "r-repmis")
    (version "0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "repmis" version))
       (sha256
        (base32 "0z5mjbsl24yjbl0aawr35grcal44rf2xbwv1hy7bdkms94ix79b5"))))
    (properties `((upstream-name . "repmis")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'install 'change-home-dir
           (lambda _
             ;; Change from /homeless-shelter to /tmp for write permission.
             (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-data-table
           r-digest
           r-httr
           r-plyr
           r-r-cache))
    (home-page "https://cran.r-project.org/package=repmis")
    (synopsis "Miscellaneous tools for reproducible research")
    (description
     "This package is a collection of tools to load R packages and
automatically generate BibTeX files citing them as well as load and cache
plain-text and Excel formatted data stored on GitHub, and from other
sources.")
    (license license:gpl3+)))

(define-public r-reprex
  (package
    (name "r-reprex")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reprex" version))
       (sha256
        (base32
         "174705043b90phm6aj5yb199pn1clipsnqgvhskhxybypj63cq68"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr
           r-cli
           r-clipr
           r-fs
           r-glue
           r-knitr
           r-lifecycle
           r-rlang
           r-rmarkdown
           r-rstudioapi
           r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/tidyverse/reprex")
    (synopsis "Prepare reproducible R code examples for sharing")
    (description
     "This package provides a convenience wrapper that uses the
@code{rmarkdown} package to render small snippets of code to target formats
that include both code and output.  The goal is to encourage the sharing of
small, reproducible, and runnable examples on code-oriented websites or email.
@code{reprex} also extracts clean, runnable R code from various common formats,
such as copy/paste from an R session.")
    (license license:expat)))

(define-public r-reordercluster
  (package
   (name "r-reordercluster")
   (version "2.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "ReorderCluster" version))
            (sha256
             (base32
              "0zq143xvv2br7016f9b1501ymcpkjqm3al1dn5qfm21axyi2p1iq"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-gplots r-gtools r-rcpp))
   (home-page "https://cran.r-project.org/web/packages/ReorderCluster")
   (synopsis "Reordering the dendrogram according to the class labels")
   (description "This package provides tools for performing the leaf reordering
for the dendrogram that preserves the hierarchical clustering result and at the
same time tries to group instances from the same class together.")
   (license license:gpl3+)))

(define-public r-caliberrfimpute
  (package
    (name "r-caliberrfimpute")
    (version "1.0-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CALIBERrfimpute" version))
       (sha256
        (base32 "1fspn6wgr0kc7j4ixx24c706kzrgjhi1b1w28izpfxm4r89zk08s"))))
    (properties `((upstream-name . "CALIBERrfimpute")))
    (build-system r-build-system)
    (propagated-inputs (list r-mice r-mvtnorm r-randomforest))
    (home-page "https://cran.r-project.org/package=CALIBERrfimpute")
    (synopsis "Multiple imputation using MICE and random forest")
    (description
     "This package provides functions to impute using random forest.
It operates under full conditional specifications (multivariate
imputation by chained equations).")
    (license license:gpl3)))

(define-public r-callr
  (package
    (name "r-callr")
    (version "3.7.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "callr" version))
       (sha256
        (base32
         "1y2ildc0ni01lkcircbr648f5knq6ch6smh5xap2xr39x1ky7g74"))))
    (properties
     ;; Avoid dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-processx r-r6))
    (home-page "https://github.com/r-lib/callr#readme")
    (synopsis "Call R from R")
    (description
     "It is sometimes useful to perform a computation in a separate R process,
without affecting the current R process at all.  This package does exactly
that.")
    (license license:expat)))

(define-public r-deming
  (package
    (name "r-deming")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "deming" version))
       (sha256
        (base32 "1jipary7wqb9gmj4mfrz4ym5ir44q2rhknxx6ah1f5lpkcsjm6c6"))))
    (properties `((upstream-name . "deming")))
    (build-system r-build-system)
    (propagated-inputs (list r-boot))
    (home-page "https://cran.r-project.org/package=deming")
    (synopsis
     "Deming, Theil-Sen, Passing-Bablock and Total Least Squares regression")
    (description
     "This package implements generalized Deming regression, Theil-Sen
regression and Passing-Bablock regression functions.")
    (license license:lgpl2.0+)))

(define-public r-deoptim
  (package
    (name "r-deoptim")
    (version "2.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DEoptim" version))
       (sha256
        (base32 "0k7mvf7j8y1sqv8zpiwkw4xcmgki37drkxjijrsmmhkfybfan7k3"))))
    (properties `((upstream-name . "DEoptim")))
    (build-system r-build-system)
    (propagated-inputs (list r-parallelly))
    (home-page "https://github.com/ArdiaD/DEoptim")
    (synopsis "Global optimization by differential evolution")
    (description
     "This package implements the Differential Evolution algorithm.
This algorithm is used for the global optimization of a real-valued function
of a real-valued parameter vector.  The implementation of
@code{DifferentialEvolution} in DEoptim interfaces with C code for
efficiency.")
    (license license:gpl2+)))

(define-public r-depmixs4
  (package
    (name "r-depmixs4")
    (version "1.5-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "depmixS4" version))
              (sha256
               (base32
                "0dim05r9q97gamr2kviz2q4f67fhpvw5j8gf0prcg8nn64d3nw8j"))))
    (propagated-inputs
     (list r-mass r-nlme r-nnet r-rsolnp))
    (native-inputs (list r-gamlss r-gamlss-dist))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/depmixS4/")
    (synopsis "Dependent Mixture Models")
    (description "This package fits latent (hidden) Markov models on mixed
categorical and continuous (time series) data, otherwise known as dependent
mixture models.")
    (license license:gpl2+)))

(define-public r-detectseparation
  (package
    (name "r-detectseparation")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "detectseparation" version))
       (sha256
        (base32 "05z3p1z5mhmdj5qdknz1b8f6fwbghzckl88pv79v59cfwpbvgmz8"))))
    (properties `((upstream-name . "detectseparation")))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolveapi r-pkgload r-roi r-roi-plugin-lpsolve))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/ikosmidis/detectseparation")
    (synopsis
     "Detect and check for separation and infinite maximum likelihood estimates")
    (description
     "This package provides pre-fit and post-fit methods for detecting separation
and infinite maximum likelihood estimates in generalized linear models with
categorical responses.  The pre-fit methods apply on binomial-response generalized
liner models such as logit, probit and cloglog regression, and can be directly
supplied as fitting methods to the @code{glm()} function.  The post-fit methods
apply to models with categorical responses, including binomial-response
generalized linear models and multinomial-response models, such as baseline
category logits and adjacent category logits models; for example, the models
implemented in the brglm2 package.  The post-fit methods successively refit the
model with increasing number of iteratively reweighted least squares iterations,
and monitor the ratio of the estimated standard error for each parameter to what
it has been in the first iteration.")
    (license license:gpl3)))

(define-public r-readxl
  (package
    (name "r-readxl")
    (version "1.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "readxl" version))
       (sha256
        (base32
         "1pyy3g65zcq0b98xqc2v400z5l5ryvdl71vvd372kqgvp9xhvmq9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cellranger r-cpp11 r-progress r-tibble))
    (native-inputs
     (list r-knitr r-testthat r-withr r-writexls))
    (home-page "https://readxl.tidyverse.org")
    (synopsis "Read Excel files")
    (description
     "This package lets you import Excel files into R.  It supports
@file{.xls} via the embedded @code{libxls} C library and @file{.xlsx} via
the embedded @code{RapidXML} C++ library.")
    ;; XXX: This package bundles a copy of 'libxsl' which is BSD-2 and
    ;; 'rapidxml' which is Boost.
    (license (list license:gpl3 license:bsd-2 license:boost1.0))))

(define-public r-rearrr
  (package
    (name "r-rearrr")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rearrr" version))
       (sha256
        (base32 "0iwzb2l3vqs8c76d44qpkfk8hsglm9fg2y75prm6fr4n88xr82bp"))))
    (properties
     '((upstream-name . "rearrr")
       (updater-ignored-native-inputs . ("r-xpectr"))))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate
                             r-dplyr
                             r-lifecycle
                             r-plyr
                             r-purrr
                             r-r6
                             r-rlang
                             r-tibble))
    (native-inputs (list r-covr r-testthat))
    (home-page "https://github.com/ludvigolsen/rearrr")
    (synopsis "Rearranging data by a set of methods")
    (description
     "This package arranges data by a set of methods.  It uses rearrangers to
reorder data points and mutators to change their values.  From basic utilities,
to centering the greatest value, to swirling in 3-dimensional space, rearrr
enables creativity when plotting and experimenting with data.")
    (license license:expat)))

(define-public r-model4you
  (package
    (name "r-model4you")
    (version "0.9-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "model4you" version))
              (sha256
               (base32
                "17xa2lvbsbwsyy54nna99xxwjv04p7xgqa61jz1ivggq0fgrd9fg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-formula
           r-ggplot2
           r-gridextra
           r-partykit
           r-sandwich
           r-survival))
    (native-inputs
     (list r-plyr r-psychotools r-strucchange r-th-data))
    (home-page "https://cran.r-project.org/web/packages/model4you/")
    (synopsis "Stratified and personalised models based on trees and forests")
    (description
     "This package provides procedures for model-based trees for subgroup
analyses in clinical trials and model-based forests for the estimation and
prediction of personalised treatment effects.  Currently partitioning of linear
models, @code{lm()}, generalised linear models, @code{glm()}, and
Weibull models, @code{survreg()}, are supported.  Advanced plotting functionality is
supported for the trees and a test for parameter heterogeneity is provided for
the personalised models.")
    (license license:gpl2+)))

(define-public r-modelenv
  (package
    (name "r-modelenv")
    (version "0.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "modelenv" version))
              (sha256
               (base32
                "1h8vksmvdj5nv6cswr0c21fh1jcryw1lvpq9pn0n771pxybhxqbl"))))
    (properties `((upstream-name . "modelenv")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-glue r-rlang r-tibble r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/tidymodels/modelenv")
    (synopsis "Tools for registering models for use in tidymodels")
    (description
     "This is a developer-focused, low dependency package in
@code{tidymodels} that provides functions to register how models are
to be used.  Functions to register models are complimented with
accessor functions to retrieve registered model information to aid in
model fitting and error handling.")
    (license license:expat)))

(define-public r-modelr
  (package
    (name "r-modelr")
    (version "0.1.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "modelr" version))
       (sha256
        (base32
         "1lvv6gac3g4x1d58chbvlxlkd77qz21a3rlb64jvzwycx43dbswl"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-magrittr
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect
           r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/tidyverse/modelr")
    (synopsis "Helper functions for modelling in pipelines")
    (description
     "Functions for modelling that help you seamlessly integrate modelling
into a pipeline of data manipulation and visualisation.")
    (license license:gpl3)))

(define-public r-mondate
  (package
    (name "r-mondate")
    (version "1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mondate" version))
       (sha256
        (base32 "1spz3xv450mw0i984hjp6r4lk653nmjawf9cipv9z7isc4zv3ac3"))))
    (properties `((upstream-name . "mondate")))
    (build-system r-build-system)
    (home-page "https://www.r-project.org")
    (synopsis "Keep track of dates in terms of months")
    (description
     "Keep track of dates in terms of fractional calendar months per Damien
Laker \"Time Calculations for Annualizing Returns: the Need for
Standardization\", The Journal of Performance Measurement, 2008.  Model dates
as of close of business.  Perform date arithmetic in units of \"months\" and
\"years\".  Allow \"infinite\" dates to model \"ultimate\" time.")
    (license license:mpl2.0)))

(define-public r-morpho
  (package
    (name "r-morpho")
    (version "2.12")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Morpho" version))
              (sha256
               (base32
                "1hg1jr0y11v93mqg2kn8n841nbsiffhyyr2kswj7kk664vlpril0"))))
    (properties
     '((upstream-name . "Morpho")
       (updater-extra-native-inputs . ("r-shapes"))))
    (build-system r-build-system)
    (propagated-inputs (list r-bezier
                             r-colorramps
                             r-doparallel
                             r-foreach
                             r-jsonlite
                             r-mass
                             r-matrix
                             r-rcpp
                             r-rcpparmadillo
                             r-rgl
                             r-rvcg
                             r-sf))
    (native-inputs (list r-shapes r-testthat))
    (home-page "https://github.com/zarquon42b/Morpho")
    (synopsis
     "Calculations and visualizations related to geometric morphometrics")
    (description
     "This package provides a toolset for Geometric Morphometrics and mesh
processing.  This includes (among other stuff) mesh deformations based on
reference points, permutation tests, detection of outliers, processing of
sliding semi-landmarks and semi-automated surface landmark placement.")
    (license license:gpl2)))

(define-public r-hexbin
  (package
    (name "r-hexbin")
    (version "1.28.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hexbin" version))
       (sha256
        (base32
         "1rnk94mjhzfmpcq77iy8qi2j8dj8bdw9vdjmwm27s94z77b8gl1f"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (native-inputs
     (list gfortran r-knitr)) ; for vignettes
    (home-page "https://github.com/edzer/hexbin")
    (synopsis "Hexagonal binning routines")
    (description
     "This package provides binning and plotting functions for hexagonal bins.
It uses and relies on grid graphics and formal (S4) classes and methods.")
    (license license:gpl2+)))

(define-public r-hgnchelper
  (package
    (name "r-hgnchelper")
    (version "0.8.15")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "HGNChelper" version))
              (sha256
               (base32
                "063m8vyndfzbnxnbmlz772icj5y9j8gdbggss1ch1mypq9ds3y3n"))))
    (properties `((upstream-name . "HGNChelper")))
    (build-system r-build-system)
    (propagated-inputs (list r-splitstackshape))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/waldronlab/HGNChelper")
    (synopsis
     "Identification and correction of invalid gene symbols for human and mouse")
    (description
     "This package provides a set of R functions for identifying and
correcting HGNC human gene symbols.  In addition, you can identify MGI mouse
gene symbols, which have been converted to date format by Excel, withdrawn, or
aliased.  It also contains functions for reversibly converting between HGNC
symbols and valid R names.")
    (license license:gpl2+)))

(define-public r-hh
  (package
    (name "r-hh")
    (version "3.1-53")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "HH" version))
       (sha256
        (base32 "14lqyxnpx6dis5s40yrzrdqq5qvqspibzssr2bh3jkkfykjasxmj"))))
    (properties `((upstream-name . "HH")))
    (build-system r-build-system)
    (propagated-inputs (list r-abind
                             r-colorspace
                             r-gridextra
                             r-hmisc
                             r-lattice
                             r-latticeextra
                             r-leaps
                             r-multcomp
                             r-rcolorbrewer
                             r-reshape2
                             r-rmpfr
                             r-shiny
                             r-vcd))
    (home-page "https://cran.r-project.org/package=HH")
    (synopsis "Statistical analysis and data display: Heiberger and Holland")
    (description
     "This package provides support software for Statistical Analysis and Data
Display (Second Edition, Springer, ISBN 978-1-4939-2121-8, 2015) and (First
Edition, Springer, ISBN 0-387-40270-5, 2004) by Richard M. Heiberger and Burt
Holland.  This contemporary presentation of statistical methods features
extensive use of graphical displays for exploring data and for displaying the
analysis.  The second edition includes redesigned graphics and additional
chapters.  The authors emphasize how to construct and interpret graphs,
discuss principles of graphical design, and show how accompanying traditional
tabular results are used to confirm the visual impressions derived directly
from the graphs.  Many of the graphical formats are novel and appear here for
the first time in print.  All chapters have exercises.  All functions
introduced in the book are in the package.  R code for all examples, both
graphs and tables, in the book is included in the scripts directory of the
package.")
    (license license:gpl2+)))

(define-public r-hiddenmarkov
  (package
    (name "r-hiddenmarkov")
    (version "1.8-14")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "HiddenMarkov" version))
              (sha256
               (base32
                "09b0rwipvkcwrgy0mn0dcz11ijihmnabh1yw0avbk3imkv0j42r5"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/HiddenMarkov/")
    (synopsis "Hidden markov models for R")
    (description "This package contains functions for the analysis of Discrete
Time Hidden Markov Models, Markov Modulated GLMs and the Markov Modulated
Poisson Process.  It includes functions for simulation, parameter estimation,
and the Viterbi algorithm.  The algorithms are based of those of Walter
Zucchini.")
    (license license:gpl2+)))

(define-public r-highr
  (package
    (name "r-highr")
    (version "0.11")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "highr" version))
              (sha256
               (base32
                "19z0gwdy46z6gb46b3fs2ljxa2cn0bpvx7aam0jk75h180l183g9"))))
    (properties
     ;; We can't have r-knitr among the inputs here, because r-highr depends
     ;; on r-xfun, which is an input to r-knitr.
     '((updater-ignored-native-inputs . ("r-knitr"))))
    (build-system r-build-system)
    ;; Do not build vignettes as they need r-knitr.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-xfun))
    (native-inputs (list r-testit))
    (home-page "https://github.com/yihui/highr")
    (synopsis "Syntax highlighting for R source code")
    (description
     "This package provides syntax highlighting for R source code.  Currently
it supports LaTeX and HTML output.  Source code of other languages is
supported via Andre Simon's highlight package.")
    (license license:gpl3+)))

(define-public r-hmm
  (package
    (name "r-hmm")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "HMM" version))
              (sha256
               (base32
                "1rv9s058mw4sl6hvna5hdp3i2nl2z4vhgdmakbv1ldjwhhkfg5rv"))))
    (properties `((upstream-name . "HMM")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/HMM/")
    (synopsis "Hidden Markov Models")
    (description "This package provides an easy to use library to setup, apply
and make inference with discrete time and discrete space hidden Markov
models.")
    (license license:gpl2+)))

(define-public r-hmisc
  (package
    (name "r-hmisc")
    (version "5.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Hmisc" version))
       (sha256
        (base32 "0whivay0d3p00y5z7mpz14n68i1yvcfkmr6lfbvw854022yqxi0y"))))
    (properties `((upstream-name . "Hmisc")))
    (build-system r-build-system)
    ;; Tests need r-rms, which needs this package.
    (arguments (list #:test-types '(list "vignettes")))
    (native-inputs
     (list gfortran))
    (propagated-inputs
     (list r-base64enc
           r-cluster
           r-colorspace
           r-data-table
           r-foreign
           r-formula
           r-ggplot2
           r-gridextra
           r-gtable
           r-htmltable
           r-htmltools
           r-knitr
           r-nnet
           r-rmarkdown
           r-rpart
           r-viridis))
    (home-page "http://biostat.mc.vanderbilt.edu/Hmisc")
    (synopsis "Miscellaneous data analysis and graphics functions")
    (description
     "This package contains many functions useful for data analysis,
high-level graphics, utility operations, functions for computing sample size
and power, importing and annotating datasets, imputing missing values,
advanced table making, variable clustering, character string manipulation,
conversion of R objects to LaTeX code, and recoding variables.")
    (license license:gpl2+)))

(define-public r-hms
  (package
    (name "r-hms")
    (version "1.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hms" version))
       (sha256
        (base32
         "10h2k5j97fggq3hc0qzxv1q9821y21m326v3x99zsvpl1b3g89p6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lifecycle r-pkgconfig r-rlang r-vctrs))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rstats-db/hms")
    (synopsis "Pretty time of day")
    (description
     "This package implements an S3 class for storing and formatting
time-of-day values, based on the @code{difftime} class.")
    (license license:gpl3+)))

(define-public r-hsaur3
  (package
    (name "r-hsaur3")
    (version "1.0-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "HSAUR3" version))
       (sha256
        (base32 "17yg6ql9c88pg5higmrvhnavx6hcbr4nm5r65d8q3iqfkgnc6ym1"))))
    (properties `((upstream-name . "HSAUR3")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=HSAUR3")
    (synopsis "Handbook of Statistical Analyses Using R (3rd Edition)")
    (description
     "This package provides functions, data sets, analyses and examples from
the third edition of the book A Handbook of Statistical Analyses Using
R (Torsten Hothorn and Brian S. Everitt, Chapman & Hall/CRC, 2014).  The first
chapter of the book, which is entitled An Introduction to R, is completely
included in this package, for all other chapters, a vignette containing all
data analyses is available.  In addition, Sweave source code for slides of
selected chapters is included in this package.")
    (license license:gpl2)))

(define-public r-httpgd
  (package
    (name "r-httpgd")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "httpgd" version))
       (sha256
        (base32 "02p9d50gbzaz1v77ssby9fgxx8pxp4n8h50k57x9niymgi7phnmx"))))
    (properties `((upstream-name . "httpgd")))
    (build-system r-build-system)
    ;; XXX On the build farm the tests fail with "Too many open files".  It
    ;; works fine on my laptop.
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-asioheaders r-cpp11 r-unigd))
    (native-inputs (list r-future r-httr r-jsonlite r-knitr r-testthat))
    (home-page "https://github.com/nx10/httpgd")
    (synopsis "HTTP server graphics device")
    (description
     "This package provides a graphics device for R that is accessible via
network protocols.  This package was created to make it easier to embed live R
graphics in integrated development environments and other applications.  The
included HTML/@code{JavaScript} client (plot viewer) aims to provide a better
overall user experience when dealing with R graphics.  The device
asynchronously serves graphics via HTTP and @code{WebSockets}'.")
    (license license:gpl2+)))

(define-public r-httptest
  (package
    (name "r-httptest")
    (version "4.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "httptest" version))
       (sha256
        (base32 "0c370jxkd9dzqg5pdf2mcv2kjzr9zp9qai9riivjgygj6jhlcjav"))))
    (properties `((upstream-name . "httptest")))
    (build-system r-build-system)
    (propagated-inputs (list r-curl r-digest r-httr r-jsonlite r-testthat))
    (native-inputs (list r-knitr r-spelling r-testthat))
    (home-page "https://enpiar.com/r/httptest/")
    (synopsis "Test environment for HTTP requests")
    (description
     "Testing and documenting code that communicates with remote servers can
be painful.  Dealing with authentication, server state, and other
complications can make testing seem too costly to bother with.  But it doesn't
need to be that hard.  This package enables one to test all of the logic on
the R sides of the API in your package without requiring access to the remote
service.  Importantly, it provides three contexts that mock the network
connection in different ways, as well as testing functions to assert that HTTP
requests were---or were not---made.  It also allows one to safely record real
API responses to use as test fixtures.  The ability to save responses and load
them offline also enables one to write vignettes and other dynamic documents
that can be distributed without access to a live server.")
    (license license:expat)))

(define-public r-httptest2
  (package
    (name "r-httptest2")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "httptest2" version))
       (sha256
        (base32 "0vj6ynxc2xdq4xhl6df8aa3582s7jf5m71hxqxhjsjfqdzm72dv8"))))
    (properties `((upstream-name . "httptest2")))
    (build-system r-build-system)
    (propagated-inputs (list r-digest r-httr2 r-jsonlite r-rlang r-testthat))
    (native-inputs (list r-knitr r-spelling r-webfakes))
    (home-page "https://enpiar.com/httptest2/")
    (synopsis "Test Helpers for 'httr2'")
    (description
     "Testing and documenting code that communicates with remote servers can
be painful.  This package helps with writing tests for packages that use
@code{httr2}.  It enables testing all of the logic on the R sides of the API
without requiring access to the remote service, and it also allows recording
real API responses to use as test fixtures.  The ability to save responses and
load them offline also enables writing vignettes and other dynamic documents
that can be distributed without access to a live server.")
    (license license:expat)))

(define-public r-httpuv
  (package
    (name "r-httpuv")
    (version "1.6.16")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httpuv" version))
              (sha256
               (base32
                "0r1gxmxscw1znda2mjp9wl1rxkbdsn3mq826qjs13529z6p43wsi"))
              (modules '((guix build utils)))
              ;; Cannot unbundle http-parser, because it contains local
              ;; modifications.
              (snippet
               '(delete-file-recursively "src/libuv"))))
    (properties
     '((updater-ignored-native-inputs
        . ("r-callr"
           "r-close"
           "r-fe80"
           "r-httprequest"
           "r-status"
           "r-websocket"))))
    (build-system r-build-system)
    (inputs
     (list libuv-for-r-httpuv zlib))
    (propagated-inputs
     (list r-later r-promises r-r6 r-rcpp))
    (native-inputs (list pkg-config r-curl r-testthat))
    (home-page "https://github.com/rstudio/httpuv")
    (synopsis "HTTP and WebSocket server library for R")
    (description
     "The httpuv package provides low-level socket and protocol support for
handling HTTP and WebSocket requests directly from within R.  It is primarily
intended as a building block for other packages, rather than making it
particularly easy to create complete web applications using httpuv alone.")
    ;; This package includes third-party code that was originally released
    ;; under various non-copyleft licenses.  Full licensing information can be
    ;; obtained here: https://github.com/rstudio/httpuv/blob/master/LICENSE
    (license license:gpl3+)))

(define-public r-httr
  (package
    (name "r-httr")
    (version "1.4.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httr" version))
              (sha256
               (base32
                "0fisvq3zydmqagn7lj6x98zxkcl7l95gfydl27zkigb7zg1fcm8m"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl r-jsonlite r-mime r-openssl r-r6))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/hadley/httr")
    (synopsis "Tools for working with URLs and HTTP")
    (description
     "The aim of httr is to provide a wrapper for RCurl customised to the
demands of modern web APIs.  It provides useful tools for working with HTTP
organised by HTTP verbs (@code{GET()}, @code{POST()}, etc).  Configuration
functions make it easy to control additional request components.")
    (license license:expat)))

(define-public r-httr2
  (package
    (name "r-httr2")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "httr2" version))
              (sha256
               (base32
                "17bzggypradnfgrmswjlj5fd0vcvi2nhx28frfy8cr17fj15102r"))))
    (properties
     `((upstream-name . "httr2")
       ;; r-common doesn't exist, and r-nanonext isn't needed.
       (updater-ignored-native-inputs . ("r-common" "r-nanonext"))
       (updater-extra-native-inputs . ("r-docopt" "r-httpuv" "r-xml2"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; These tests need Internet access.
             (with-directory-excursion "tests/testthat/"
               (delete-file "test-oauth.R")
               (substitute* "test-req-auth-aws.R"
                 ((".*can correctly sign a request with dummy credentials.*" m)
                  (string-append m "skip('skip');\n")))
               (substitute* "test-req-body.R"
                 ((".*can send file.*" m)
                  (string-append m "skip('skip');\n")))))))))
    (propagated-inputs
     (list r-cli
           r-curl
           r-glue
           r-lifecycle
           r-magrittr
           r-openssl
           r-r6
           r-rappdirs
           r-rlang
           r-vctrs
           r-withr))
    (native-inputs (list r-clipr
                         r-docopt
                         r-httpuv
                         r-httr
                         r-jsonlite
                         r-knitr
                         r-later
                         r-promises
                         r-testthat
                         r-webfakes
                         r-xml2))
    (home-page "https://httr2.r-lib.org")
    (synopsis "Perform HTTP requests and process the responses")
    (description
     "This package provides tools for creating and modifying HTTP requests,
then performing them and processing the results.  @code{httr2} is a
re-imagining of @code{httr} that uses a pipe-based interface and solves more
of the problems that API wrapping packages face.")
    (license license:expat)))

(define-public r-jade
  (package
    (name "r-jade")
    (version "2.0-4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "JADE" version))
              (sha256
               (base32
                "0m90rnhr5vkdv1xswr5c0j06ngzvmg73nd0kmg9m9r6a6ddddcyl"))))
    (properties `((upstream-name . "JADE")))
    (build-system r-build-system)
    (propagated-inputs (list r-clue))
    (home-page "https://cran.r-project.org/package=JADE")
    (synopsis "Blind source separation methods")
    (description
     "In this package Cardoso's JADE algorithm as well as his functions for
joint diagonalization are ported to R.  Also several other @dfn{blind source
separation} (BSS) methods, like AMUSE and SOBI, and some criteria for
performance evaluation of BSS algorithms, are given.  The package is described
in Miettinen, Nordhausen and Taskinen (2017) <doi:10.18637/jss.v076.i02>.")
    (license license:gpl2+)))

(define-public r-job
  (package
    (name "r-job")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "job" version))
       (sha256
        (base32 "14i0ljq2wp9k8112fr27sz0bc0zi2a68kls8vw5h3qa5n40v27cc"))))
    (properties `((upstream-name . "job")))
    (build-system r-build-system)
    (propagated-inputs (list r-digest r-rstudioapi))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=job")
    (synopsis "Run code as an RStudio job")
    (description
     "Call @code{job::job({<code here>})} to run R code as an RStudio job and
keep your console free in the meantime.  This allows for a productive workflow
while testing (multiple) long-running chunks of code.  It can also be used to
organize results using the RStudio Jobs GUI or to test code in a clean
environment.  Two RStudio Addins can be used to run selected code as a job.")
    (license license:expat)))

(define-public r-jose
  (package
    (name "r-jose")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jose" version))
       (sha256
        (base32 "0si1mg325fwx9zgjdbqspw9v6prl5mn3iccg7vki4bpzmwhd953q"))))
    (properties `((upstream-name . "jose")))
    (build-system r-build-system)
    (propagated-inputs (list r-jsonlite r-openssl))
    (native-inputs (list r-knitr r-spelling r-testthat))
    (home-page "https://r-lib.r-universe.dev/jose")
    (synopsis "JavaScript object signing and encryption")
    (description
     "This package lets you read and write JSON Web Keys (JWK, rfc7517),
generate and verify JSON Web Signatures (JWS, rfc7515) and encode/decode JSON
Web Tokens (JWT, rfc7519).  These standards provide modern signing and
encryption formats that are natively supported by browsers via the JavaScript
@code{WebCryptoAPI}, and used by services like OAuth 2.0, LetsEncrypt, and
Github Apps.")
    (license license:expat)))

(define-public r-jsonify
  (package
    (name "r-jsonify")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jsonify" version))
              (sha256
               (base32
                "0bxgyj5b1hnijq5315g050giixy4k5mjz2zdx8yil0igb5ifji9p"))))
    (properties `((upstream-name . "jsonify")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for tests.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs (list r-rapidjsonr r-rcpp))
    (native-inputs (list r-knitr r-testthat tzdata-for-tests))
    (home-page "https://cran.r-project.org/package=jsonify")
    (synopsis
     "Convert between R objects and JavaScript Object Notation (JSON)")
    (description
     "This package enables conversions between R objects and JavaScript Object
Notation (JSON) using the rapidjsonr library.")
    (license license:expat)))

(define-public r-jsonlite
  (package
    (name "r-jsonlite")
    (version "2.0.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jsonlite" version))
              (sha256
               (base32
                "0bf87agviacnk2ff6jif4d61bzvvz2h9sxwly0ryql5kh8693svm"))))
    (properties
     '((updater-ignored-native-inputs
        . ("r-reshape2" "r-sf" "r-testthat"))))
    (build-system r-build-system)
    ;; Tests depend on r-testthat, which depends indirectly on r-jsonlite.
    (arguments (list #:tests? #false))
    (native-inputs
     (list r-knitr r-r-rsp))
    (home-page "https://arxiv.org/abs/1403.2805")
    (synopsis "Robust, high performance JSON parser and generator for R")
    (description
     "The jsonlite package provides a fast JSON parser and generator optimized
for statistical data and the web.  It offers flexible, robust, high
performance tools for working with JSON in R and is particularly powerful for
building pipelines and interacting with a web API.  In addition to converting
JSON data from/to R objects, jsonlite contains functions to stream, validate,
and prettify JSON data.  The unit tests included with the package verify that
all edge cases are encoded and decoded consistently for use with dynamic data
in systems and applications.")
    (license license:expat)))

(define-public r-jsonvalidate
  (package
    (name "r-jsonvalidate")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jsonvalidate" version))
       (sha256
        (base32 "010zcpbyja1lb4j7sbx1515scnqkaw6c7fb9g37gj1cr0ipyna9l"))))
    (properties `((upstream-name . "jsonvalidate")))
    (build-system r-build-system)
    (propagated-inputs (list r-r6 r-v8))
    (native-inputs (list r-jsonlite r-knitr r-testthat r-withr))
    (home-page "https://docs.ropensci.org/jsonvalidate/")
    (synopsis "Validate JSON schema")
    (description
     "This package uses the node library @code{is-my-json-valid} or @code{ajv}
to validate JSON against a JSON schema.  Drafts 04, 06 and 07 of JSON schema
are supported.")
    (license license:expat)))

(define-public r-servr
  (package
    (name "r-servr")
    (version "0.32")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "servr" version))
              (sha256
               (base32
                "19ixy27b87z99s1crqnmxm7vqzz4zsxpjgpy4101dic7628wlak7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httpuv r-jsonlite r-mime r-xfun))
    (home-page "https://github.com/yihui/servr")
    (synopsis "Simple HTTP server to serve static files or dynamic documents")
    (description
     "Servr provides an HTTP server in R to serve static files, or dynamic
documents that can be converted to HTML files (e.g., R Markdown) under a given
directory.")
    (license license:expat)))

(define-public r-howmany
  (package
    (name "r-howmany")
    (version "0.3-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "howmany" version))
              (sha256
               (base32
                "045ck8qahfg2swbgyf7dpl32ryq1m4sbalhr7m5qdgpm62vz8h7f"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/howmany/")
    (synopsis "Lower bound for the number of correct rejections")
    (description "When testing multiple hypotheses simultaneously, this package
provides functionality to calculate a lower bound for the number of correct
rejections (as a function of the number of rejected hypotheses), which holds
simultaneously -with high probability- for all possible number of rejections.
As a special case, a lower bound for the total number of false null hypotheses
can be inferred.  Dependent test statistics can be handled for multiple tests
of associations.  For independent test statistics, it is sufficient to provide
a list of p-values.")
    (license license:gpl2+)))

(define-public r-htmltools
  (package
    (name "r-htmltools")
    (version "0.5.8.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "htmltools" version))
              (sha256
               (base32
                "0xpi2g87vwanp0kbs22j90pa2bban3nwrdjdb3257hq6xj9j5xpr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-base64enc r-digest r-fastmap r-rlang))
    (native-inputs (list r-markdown r-testthat))
    (home-page "https://cran.r-project.org/web/packages/htmltools")
    (synopsis "R tools for HTML")
    (description
     "This package provides tools for HTML generation and output in R.")
    (license license:expat)))

(define-public r-htmlwidgets
  (package
    (name "r-htmlwidgets")
    (version "1.6.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "htmlwidgets" version))
              (sha256
               (base32
                "1l0f7bz2icixsrgg5fg8k09mv0nq9vn5ch1fywkaqpa8605qzc3w"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-jsonlite
           r-knitr r-rmarkdown
           r-yaml))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/ramnathv/htmlwidgets")
    (synopsis "HTML Widgets for R")
    (description
     "HTML widgets is a framework for creating HTML widgets that render in
various contexts including the R console, R Markdown documents, and Shiny web
applications.")
    (license license:expat)))

(define-public r-htmltable
  (package
    (name "r-htmltable")
    (version "2.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "htmlTable" version))
       (sha256
        (base32 "1pgndsyml68d9qd747043m9g0dxhaa10m533dchcsg1izwdx0f9p"))))
    (properties `((upstream-name . "htmlTable")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'replace-bundled-minified-JavaScript
            (lambda* (#:key inputs #:allow-other-keys)
              (minify (assoc-ref inputs "js-jquery")
                      #:target
                      "inst/htmlwidgets/lib/jquery/jquery.min.js"))))))
    (propagated-inputs
     (list r-checkmate
           r-htmltools
           r-htmlwidgets
           r-knitr
           r-magrittr
           r-rstudioapi
           r-stringr))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.7.1.js")
           (sha256
            (base32
             "1zicjv44sx6n83vrkd2lwnlbf7qakzh3gcfjw0lhq48b5z55ma3q"))))
       ("r-dplyr" ,r-dplyr)
       ("r-knitr" ,r-knitr)
       ("r-purrr" ,r-purrr)
       ("r-testthat" ,r-testthat)
       ("r-xml" ,r-xml)
       ("r-xml2" ,r-xml2)))
    (home-page "http://gforge.se/packages/")
    (synopsis "Advanced tables for Markdown/HTML")
    (description
     "This package provides functions to build tables with advanced layout
elements such as row spanners, column spanners, table spanners, zebra
striping, and more.  While allowing advanced layout, the underlying
CSS-structure is simple in order to maximize compatibility with word
processors such as LibreOffice.  The package also contains a few text
formatting functions that help outputting text compatible with HTML or
LaTeX.")
    (license license:gpl3+)))

(define-public r-curl
  (package
    (name "r-curl")
    (version "6.2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "curl" version))
              (sha256
               (base32
                "04r70p22r59x9paicwssfab2zq6dvzs39ygansc5swq9wvy23xlp"))))
    (properties
     `((upstream-name . "curl")
       (updater-extra-inputs . ("curl"))
       (updater-ignored-inputs . ("openssh" "openssl"))
       (updater-ignored-native-inputs . ("r-db8" "r-webutils"))))
    (build-system r-build-system)
    (inputs
     (list curl zlib))
    (native-inputs
     (list pkg-config
           r-jsonlite
           r-knitr
           r-spelling
           r-testthat))
    (home-page "https://github.com/jeroenooms/curl")
    (synopsis "HTTP client for R")
    (description
     "The @code{curl()} and @code{curl_download()} functions provide highly
configurable drop-in replacements for base @code{url()} and
@code{download.file()} with better performance, support for encryption, gzip
compression, authentication, and other @code{libcurl} goodies.  The core of
the package implements a framework for performing fully customized requests
where data can be processed either in memory, on disk, or streaming via the
callback or connection interfaces.")
    (license license:expat)))

(define-public r-hwriter
  (package
    (name "r-hwriter")
    (version "1.3.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hwriter" version))
       (sha256
        (base32
         "1wxnv8h9cs65m3z01dpnnkgn2cpwfsck70g1jz9nbkr7mdaa4bzd"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/hwriter")
    (synopsis "Output R objects in HTML format")
    (description
     "This package provides easy-to-use and versatile functions to output R
objects in HTML format.")
    (license license:lgpl2.1+)))

(define-public r-rjson
  (package
    (name "r-rjson")
    (version "0.2.23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rjson" version))
       (sha256
        (base32
         "0j0gbwd4cn1f7fb6ml14jr3m38ny1y62gnh1cxz6bvalr1sla0sm"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rjson")
    (synopsis "JSON library for R")
    (description
     "This package provides functions to convert R objects into JSON objects
and vice-versa.")
    (license license:gpl2+)))

(define-public r-fastdummies
  (package
    (name "r-fastdummies")
    (version "1.7.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fastDummies" version))
              (sha256
               (base32
                "0jmvb9j4cywq5nff7997qhv8hl8zw187c9pgdh0i1v9pmy31jymq"))))
    (properties `((upstream-name . "fastDummies")))
    (build-system r-build-system)
    (propagated-inputs (list r-data-table r-stringr r-tibble))
    (native-inputs (list r-knitr r-spelling r-testthat))
    (home-page "https://github.com/jacobkap/fastDummies")
    (synopsis "Create dummy columns and rows from categorical variables")
    (description
     "This package creates dummy columns from columns that have categorical
variables (character or factor types).  You can also specify which columns to
make dummies out of, or which columns to ignore.  Also creates dummy rows from
character, factor, and Date columns.  This package provides a significant
speed increase from creating dummy variables through @code{model.matrix()}.")
    (license license:expat)))

(define-public r-fastmap
  (package
    (name "r-fastmap")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastmap" version))
       (sha256
        (base32
         "0ilj7gcbnha6l61sqzk6wrj6l08mxyay49957izha7axj6i09nmi"))))
    (properties `((upstream-name . "fastmap")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://r-lib.github.io/fastmap/")
    (synopsis "Fast implementation of a key-value store")
    (description
     "This package provides a fast implementation of a key-value store.
Environments are commonly used as key-value stores, but every time a new key
is used, it is added to R's global symbol table, causing a small amount of
memory leakage.  This can be problematic in cases where many different keys
are used.  Fastmap avoids this memory leak issue by implementing the map using
data structures in C++.")
    (license license:expat)))

(define-public r-fastglm
  (package
    (name "r-fastglm")
    (version "0.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastglm" version))
       (sha256
        (base32 "0283kgk81cxbii7ljmp1rzqg5mzkvf7cj7lflhhhkgj5ljqina2i"))))
    (properties `((upstream-name . "fastglm")))
    (build-system r-build-system)
    (propagated-inputs (list r-bh r-bigmemory r-rcpp r-rcppeigen))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=fastglm")
    (synopsis
     "Fast and stable fitting of generalized linear models using 'RcppEigen'")
    (description
     "This package fits generalized linear models efficiently using @code{RcppEigen}'.
The iteratively reweighted least squares implementation utilizes the
step-halving approach of Marschner to help safeguard against convergence
issues.")
    (license license:gpl2+)))

(define-public r-fastghquad
  (package
    (name "r-fastghquad")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastGHQuad" version))
       (sha256
        (base32
         "1zj7nsbnx4g253m3dpz9vi3zk3jxwrixwjw1ks6n4shpb4dlkp2w"))))
    (properties `((upstream-name . "fastGHQuad")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://github.com/awblocker/fastGHQuad")
    (synopsis "Fast Rcpp implementation of Gauss-Hermite Quadrature")
    (description
     "This package implements numerically-stable Gauss-Hermite quadrature
rules and utility functions for adaptive GH quadrature.")
    (license license:expat)))

(define-public r-rstpm2
  (package
    (name "r-rstpm2")
    (version "1.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstpm2" version))
       (sha256
        (base32
         "0drcnfpccl8braxxgx5vnkzcqgdk4gla2iscpixz041sa0yhm7hd"))))
    (properties
     '((upstream-name . "rstpm2")
       (updater-extra-native-inputs . ("r-desolve"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; XXX: This one fails with the wrong result:
             ;; length(beta) == length(args$init) is not TRUE
             (substitute* "tests/testthat/test_delayed.R"
               ((".*All values zero or one.*" m)
                (string-append m "skip('skip');\n"))))))))
    (propagated-inputs
     (list r-bbmle
           r-fastghquad
           r-mgcv
           r-mvtnorm
           r-numderiv
           r-rcpp
           r-rcpparmadillo
           r-survival))
    (native-inputs
     (list gfortran r-desolve r-ggplot2 r-runit r-testthat))
    (home-page "https://github.com/mclements/rstpm2")
    (synopsis "Link-based survival models")
    (description
     "This package provides R implementations of @dfn{generalized survival
models} (GSMs), smooth @dfn{accelerated failure time} (AFT) models and Markov
multi-state models.")
    ;; One of these licenses
    (license (list license:gpl2 license:gpl3))))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-jquerylib
  (package
    (name "r-jquerylib")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jquerylib" version))
       (sha256
        (base32
         "04a40v4znpj98j7y6009d74a6g9dchj5rr3p08cgz9p3rlfw3g7h"))
       (snippet
        '(for-each delete-file
                   '("inst/lib/1.12.4/jquery-1.12.4.min.js"
                     "inst/lib/2.2.4/jquery-2.2.4.min.js"
                     "inst/lib/3.6.0/jquery-3.6.0.min.js")))))
    (properties `((upstream-name . "jquerylib")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/lib/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("1.12.4/jquery-1.12.4.js"
                         "1.12.4/jquery-1.12.4.min.js")
                        ("2.2.4/jquery-2.2.4.js"
                         "2.2.4/jquery-2.2.4.min.js")
                        ("3.6.0/jquery-3.6.0.js"
                         "3.6.0/jquery-3.6.0.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-htmltools))
    (native-inputs
     (list esbuild r-testthat))
    (home-page "https://cran.r-project.org/package=jquerylib")
    (synopsis "Obtain jQuery as an HTML dependency object")
    (description
     "Obtain any major version of jQuery and use it in any webpage generated
by htmltools (e.g. shiny, htmlwidgets, and rmarkdown).  Most R users don't
need to use this package directly, but other R packages (e.g. shiny,
rmarkdown, etc.) depend on this package to avoid bundling redundant copies of
jQuery.")
    (license license:expat)))

(define-public r-jqr
  (package
    (name "r-jqr")
    (version "1.4.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "jqr" version))
              (sha256
               (base32
                "0bnhk3p0yb30245g8fglrc88nk8xrc2k86q1wa5v3cw3rfpyhac9"))))
    (properties
     `((upstream-name . "jqr")
       (updater-extra-inputs . ("jq"))))
    (build-system r-build-system)
    (inputs (list jq))
    (propagated-inputs (list r-lazyeval r-magrittr))
    (native-inputs (list pkg-config r-jsonlite r-testthat))
    (home-page "https://docs.ropensci.org/jqr/")
    (synopsis "R client for jq, a JSON Processor")
    (description
     "This package provides an R client for @command{jq}, a JSON processor.
@command{jq} allows the following with JSON data: index into, parse, do
calculations, cut up and filter, change key names and values, perform
conditionals and comparisons, and more.")
    (license license:expat)))

(define-public r-safetensors
  (package
    (name "r-safetensors")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "safetensors" version))
       (sha256
        (base32 "0xvg5y2sd7gzcal0qqgxbx8vcvmy50jm0j2ajr8iw3wyy5qpyvkp"))))
    (properties `((upstream-name . "safetensors")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-jsonlite r-r6 r-rlang))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mlverse/safetensors")
    (synopsis "Safetensors file format")
    (description
     "This package provides a file format for storing tensors that is
secure (doesn't allow for code execution), fast and simple to implement.
@code{safetensors} also enables cross language and cross frameworks
compatibility making it an ideal format for storing machine learning model
weights.")
    (license license:expat)))

(define-public r-sass
  (package
    (name "r-sass")
    (version "0.4.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sass" version))
       (sha256
        (base32
         "0c4vnx3jqpy8iwh3gf7vvclcwjq6mbg4dqr9clki3n3l7wj4rnsa"))))
    (properties `((upstream-name . "sass")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; One test fails when the current locale is the C locale.
         (add-before 'check 'set-test-locale
           (lambda _ (setenv "LC_ALL" "en_US.UTF-8"))))))
    (propagated-inputs
     (list r-fs r-htmltools r-r6 r-rappdirs r-rlang))
    (native-inputs (list r-knitr r-testthat r-withr))
    (home-page "https://github.com/rstudio/sass")
    (synopsis "Syntactically Awesome Style Sheets (SASS)")
    (description
     "This package provides an SCSS compiler, powered by the libsass library.
With this, R developers can use variables, inheritance, and functions to
generate dynamic style sheets.  The package uses the Sass CSS extension
language, which is stable, powerful, and CSS compatible.")
    (license license:expat)))

(define-public r-saver
  (package
    (name "r-saver")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SAVER" version))
              (sha256
               (base32
                "1s1kw8idkaj7j90fw4qn9k0wd4vz0sblsk06ry6lm4afcar0p158"))))
    (properties `((upstream-name . "SAVER")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel
           r-foreach
           r-glmnet
           r-iterators
           r-matrix))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/mohuangx/SAVER")
    (synopsis
     "Recovery of gene expression profile in noisy and sparse scRNA-seq data")
    (description
     "This package is an implementation of a regularized regression prediction
and empirical Bayes method to recover the true gene expression profile in noisy
and sparse single-cell RNA-seq data.  In @dfn{single-cell RNA sequencing}
(scRNA-seq) studies, only a small fraction of the transcripts present in each
cell are sequenced.  This leads to unreliable quantification of genes with low
or moderate expression, which hinders downstream analysis.  This package
@dfn{single-cell analysis via expression recovery} (SAVER) implements an
expression recovery method for unique molecule index (UMI)-based scRNA-seq
data that borrows information across genes and cells to provide accurate
expression estimates for all genes.")
    (license license:gpl2)))

(define-public r-bsicons
  (package
    (name "r-bsicons")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bsicons" version))
       (sha256
        (base32 "1ifxb6qvm5m824n924pwa3f2ck33mzzbjq77jzdl36ikx4z0x47a"))))
    (properties `((upstream-name . "bsicons")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli r-htmltools r-rlang))
    (native-inputs (list r-bslib r-testthat))
    (home-page "https://github.com/rstudio/bsicons")
    (synopsis "Easily work with Bootstrap icons")
    (description
     "This package lets you easily use Bootstrap icons inside Shiny apps and R
Markdown documents.  More generally, icons can be inserted in any
@code{htmltools} document through inline SVG.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-bslib
  (package
    (name "r-bslib")
    (version "0.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bslib" version))
       (sha256
        (base32
         "01q9zy2dwhag0jl0dbhfhwbqj09ghd2wrkqihpv8acbazw3s3mxd"))
       (snippet
        '(for-each delete-file
                   '("inst/components/dist/components.min.js"
                     "inst/components/dist/web-components.min.js"
                     "inst/lib/bs-a11y-p/plugins/js/bootstrap-accessibility.min.js"
                     "inst/lib/bs3/assets/javascripts/bootstrap.min.js"
                     "inst/lib/bs4/dist/js/bootstrap.bundle.min.js"
                     "inst/lib/bs5/dist/js/bootstrap.bundle.min.js")))))
    (properties
     `((upstream-name . "bslib")
       (updater-ignored-native-inputs . ("r-rmarkdown" "r-shiny"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Some tests require shiny, leading to a dependency cycle.
      #:tests? #false
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/"
                (for-each (match-lambda
                            ((source . target)
                             (minify source #:target target)))
                          `(("components/dist/components.js"
                             . "components/dist/components.min.js")
                            ("components/dist/web-components.js"
                             . "components/dist/web-components.min.js")
                            ("lib/bs-a11y-p/plugins/js/bootstrap-accessibility.js"
                             . "lib/bs-a11y-p/plugins/js/bootstrap-accessibility.min.js")
                            ("lib/bs3/assets/javascripts/bootstrap.js"
                             . "lib/bs3/assets/javascripts/bootstrap.min.js")
                            (,(assoc-ref inputs "js-bootstrap4-bundle")
                             . "lib/bs4/dist/js/bootstrap.bundle.min.js")
                            (,(assoc-ref inputs "js-bootstrap5-bundle")
                             . "lib/bs5/dist/js/bootstrap.bundle.min.js")))))))))
    (propagated-inputs
     (list r-base64enc
           r-cachem
           r-fastmap
           r-htmltools
           r-jquerylib
           r-jsonlite
           r-lifecycle
           r-memoise
           r-mime
           r-rlang
           r-sass))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-bootstrap4-bundle"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v4.6.0/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "04abvgp923w36qfqkkl2syim3bl119nwxbgials90z1jyb8jgss1"))))
       ("js-bootstrap5-bundle"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v5.3.1/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "1bp0a2fin80hwxvd260r1jk57snsgz74vahid64yb2sgj0rlmj8a"))))))
    (home-page "https://rstudio.github.io/bslib/")
    (synopsis "Custom Bootstrap Sass themes for shiny and rmarkdown")
    (description
     "This package simplifies custom CSS styling of both shiny and rmarkdown
via Bootstrap Sass.  It supports both Bootstrap 3 and 4 as well as their
various Bootswatch themes.  An interactive widget is also provided for
previewing themes in real time.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-shiny
  (package
    (name "r-shiny")
    (version "1.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rstudio/shiny")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "07b4i1qcpfhyflaxxvwllnz0qw9iphnnsrr5rwa65aw7d9r2wszz"))
       (snippet
        '(for-each delete-file
                   '("inst/www/shared/bootstrap/js/bootstrap.min.js"
                     "inst/www/shared/bootstrap/accessibility/js/bootstrap-accessibility.min.js"
                     "inst/www/shared/datatables/js/jquery.dataTables.min.js"
                     "inst/www/shared/datepicker/js/bootstrap-datepicker.min.js"
                     "inst/www/shared/highlight/highlight.pack.js"
                     "inst/www/shared/ionrangeslider/js/ion.rangeSlider.min.js"
                     "inst/www/shared/jquery.min.js"
                     "inst/www/shared/jqueryui/jquery-ui.min.js"
                     "inst/www/shared/legacy/jquery.min.js"
                     "inst/www/shared/selectize/accessibility/js/selectize-plugin-a11y.min.js"
                     "inst/www/shared/selectize/js/selectize.min.js"
                     "inst/www/shared/shiny.min.js"
                     ;; These are built from TypeScript sources, which is a
                     ;; little trickier to do correctly.
                     ;; "inst/www/shared/shiny-showcase.js" ;TODO
                     ;; "inst/www/shared/shiny-autoreload.js" ;TODO
                     "inst/www/shared/showdown/compressed/showdown.js"
                     "inst/www/shared/strftime/strftime-min.js")))))
    (properties
     '((updater-extra-native-inputs . ("r-coro"))))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         ;; This is needed for some tests.
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp")))
         (add-after 'unpack 'replace-bundled-minified-JavaScript
           (lambda* (#:key inputs #:allow-other-keys)
             (let ((replace-file (lambda (old new)
                                   (format #t "replacing ~a with ~a\n" old new)
                                   (symlink new old))))
               ;; NOTE: Files in ./inst/www/shared/datepicker/js/locales/
               ;; contain just data.  They are not minified code, so we don't
               ;; replace them.
               (with-directory-excursion "inst/www/shared"
                 (replace-file "strftime/strftime-min.js"
                               (search-input-file inputs
                                                  "/share/javascript/strftime.min.js"))
                 (replace-file "highlight/highlight.pack.js"
                               (search-input-file inputs
                                                  "/share/javascript/highlight.min.js"))
                 (replace-file "datatables/js/jquery.dataTables.min.js"
                               (search-input-file inputs
                                                  "/share/javascript/jquery.dataTables.min.js"))
                 (replace-file "selectize/js/selectize.min.js"
                               (search-input-file inputs
                                                  "/share/javascript/selectize.min.js"))
                 (for-each (match-lambda
                             ((source . target)
                              (minify source #:target target)))
                           `(("jqueryui/jquery-ui.js" .
                              "jqueryui/jquery-ui.min.js")
                             ("datepicker/js/bootstrap-datepicker.js" .
                              "datepicker/js/bootstrap-datepicker.min.js")
                             ("ionrangeslider/js/ion.rangeSlider.js" .
                              "ionrangeslider/js/ion.rangeSlider.min.js")
                             ("bootstrap/js/bootstrap.js" .
                              "bootstrap/js/bootstrap.min.js")
                             (,(assoc-ref inputs "js-bootstrap-accessibility") .
                              "bootstrap/accessibility/js/bootstrap-accessibility.min.js")
                             ("shiny.js" .
                              "shiny.min.js")
                             ("jquery.js" .
                              "jquery.min.js")
                             ("legacy/jquery.js" .
                              "legacy/jquery.min.js")
                             ("selectize/accessibility/js/selectize-plugin-a11y.js" .
                              "selectize/accessibility/js/selectize-plugin-a11y.min.js")
                             ("showdown/src/showdown.js" .
                              "showdown/compressed/showdown.js"))))))))))
    (propagated-inputs
     (list r-bslib
           r-cachem
           r-commonmark
           r-crayon
           r-ellipsis
           r-fastmap
           r-fontawesome
           r-glue
           r-htmltools
           r-httpuv
           r-jsonlite
           r-later
           r-lifecycle
           r-mime
           r-promises
           r-r6
           r-rlang
           r-sourcetools
           r-withr
           r-xtable))
    (inputs
     (list js-datatables js-selectize js-strftime js-highlight))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("gfortran" ,gfortran)
       ("js-bootstrap-accessibility"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/paypal/bootstrap-accessibility-plugin/\
v1.0.7/_site/plugins/js/bootstrap-accessibility.js")
           (sha256
            (base32
             "1489wyzwrpf86y7vhc13n4v3mszmsfybhd3f75jkpnbvyp5sncm8"))))
       ("r-coro" ,r-coro)
       ("r-future" ,r-future)
       ("r-ggplot2" ,r-ggplot2)
       ("r-testthat" ,r-testthat)))
    (home-page "https://shiny.rstudio.com")
    (synopsis "Easy interactive web applications with R")
    (description
     "Makes it incredibly easy to build interactive web applications
with R.  Automatic \"reactive\" binding between inputs and outputs and
extensive prebuilt widgets make it possible to build beautiful,
responsive, and powerful applications with minimal effort.")
    (license license:artistic2.0)))

(define-public r-shinyauthr
  (package
    (name "r-shinyauthr")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyauthr" version))
       (sha256
        (base32 "0apaqjkxpr96kx9indl0pifk5y75gdx5npfcvxfg5k2crpx9vmxk"))))
    (properties `((upstream-name . "shinyauthr")))
    (build-system r-build-system)
    ;; One of the tests requires r-shinytest, which has a big JavaScript
    ;; problem.
    (arguments (list #:tests? #false))
    (native-inputs (list r-testthat))
    (propagated-inputs (list r-dplyr
                             r-glue
                             r-rlang
                             r-shiny
                             r-shinyjs
                             r-sodium))
    (home-page "https://github.com/paulc91/shinyauthr")
    (synopsis "Shiny authentication modules")
    (description
     "With this package you can add in-app user authentication to Shiny,
allowing you to secure publicly hosted apps and build dynamic user interfaces
from user information.")
    (license license:expat)))

(define-public r-shinydisconnect
  (package
    (name "r-shinydisconnect")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinydisconnect" version))
       (sha256
        (base32 "1yhppfx8jpvz48iwxnimcwqhj02vqjrfmh4z5rdn9d35p51c8zjc"))))
    (properties `((upstream-name . "shinydisconnect")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate r-glue r-htmltools r-shiny))
    (home-page "https://github.com/daattali/shinydisconnect")
    (synopsis "Show a nice message when a Shiny app disconnects or errors")
    (description
     "This package provides a Shiny app that can disconnect for a variety of
reasons: an unrecoverable error occurred in the app, the server went down, the
user lost internet connection, or any other reason that might cause the Shiny
app to lose connection to its server.  With shinydisconnect, you can call
@code{disonnectMessage} anywhere in a Shiny app's UI to add a nice message
when this happens.  It works locally (running Shiny apps within RStudio) and
on Shiny servers.")
    (license license:expat)))

(define-public r-shinyhelper
  (package
    (name "r-shinyhelper")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyhelper" version))
       (sha256
        (base32 "1c4hvf19j3yyh8r12nx85ldkxs89g98q74csnqs5ml5l79a65vgp"))))
    (properties `((upstream-name . "shinyhelper")))
    (build-system r-build-system)
    (propagated-inputs (list r-markdown r-shiny))
    (home-page "https://cran.r-project.org/package=shinyhelper")
    (synopsis "Easily add Markdown help files to shiny app elements")
    (description
     "This package creates a lightweight way to add markdown helpfiles to
Shiny apps, using modal dialog boxes, with no need to observe each help button
separately.")
    (license license:gpl3)))

(define-public r-shinymeta
  (package
    (name "r-shinymeta")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinymeta" version))
       (sha256
        (base32 "0jq4ifk59xyvjgmccgx9nhqc0pn2kbd9w1wdsr2470xdhmypvra5"))))
    (properties
     '((upstream-name . "shinymeta")
       (updater-extra-native-inputs
        . ("r-knitr" "r-rmarkdown" "r-stringr" "zip"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'find-zip
           (lambda _ (setenv "R_ZIPCMD" (which "zip"))))
         ;; Needed by styler for writing to caches.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list r-callr
                             r-fastmap
                             r-fs
                             r-htmltools
                             r-rlang
                             r-shiny
                             r-sourcetools
                             r-styler))
    (native-inputs (list r-dplyr
                         r-knitr
                         r-knitr
                         r-rmarkdown
                         r-rmarkdown
                         r-stringr
                         r-testthat
                         zip))
    (home-page "https://rstudio.github.io/shinymeta/")
    (synopsis "Export domain logic from Shiny using meta-programming")
    (description
     "This package provides tools for capturing logic in a Shiny app and
exposing it as code that can be run outside of Shiny (e.g., from an R
console).  It also provides tools for bundling both the code and results to
the end user.")
    (license license:gpl3)))

(define-public r-shiny-router
  (package
    (name "r-shiny-router")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shiny.router" version))
       (sha256
        (base32 "1zg8cdxmw620i1iv7jrghd768gw7iv52hi6lx79xvnfjz8w4si3x"))))
    (properties `((upstream-name . "shiny.router")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue r-htmltools r-rlang r-shiny))
    (native-inputs (list r-testthat))
    (home-page "https://appsilon.github.io/shiny.router/")
    (synopsis "Basic Routing for Shiny Web Applications")
    (description
     "This package provides a simple router for your Shiny apps.  The router
allows you to create dynamic web applications with a real-time User Interface
and easily share url to pages within your Shiny apps.")
    (license license:expat)))

;; This package includes minified JavaScript files.  When upgrading please
;; check that there are no new minified JavaScript files.
(define-public r-shinytree
  (package
    (name "r-shinytree")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyTree" version))
       (sha256
        (base32
         "0krffsgdv99cvyzdspb9l7cdnq1vibsbmpd4w48r5pi4v8jbvfj6"))
       (snippet
        ;; Delete minified JavaScript
        '(for-each delete-file
                   '("inst/www/jsTree-3.3.7/libs/require.js"
                     "inst/www/jsTree-3.3.7/libs/jquery.js"
                     "inst/www/jsTree-3.3.7/jstree.min.js")))))
    (properties `((upstream-name . "shinyTree")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file requires r-shinytest, which has a big JavaScript
             ;; problem.
             (delete-file "tests/testthat/test_tree_interactive.R")))
         (add-after 'unpack 'replace-minified-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www/jsTree-3.3.7/"
               (symlink (search-input-file inputs
                                           "/share/javascript/require.min.js")
                        "libs/require.js")
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "libs/jquery.js")
                        ("jstree.js"
                         "jstree.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-htmlwidgets r-jsonlite r-promises r-shiny r-stringr))
    (inputs
     (list js-requirejs))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-3.3.1.js")
           (sha256
            (base32
             "1b8zxrp6xwzpw25apn8j4qws0f6sr7qr7h2va5h1mjyfqvn29anq"))))
       ("r-testthat" ,r-testthat)))
    (home-page "https://cran.r-project.org/web/packages/shinyTree/")
    (synopsis "jsTree bindings for Shiny")
    (description
     "This package exposes R bindings to jsTree, a JavaScript library that
supports interactive trees, to enable rich, editable trees in Shiny.")
    (license license:expat)))

(define-public r-shinyvalidate
  (package
    (name "r-shinyvalidate")
    (version "0.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyvalidate" version))
       (sha256
        (base32 "01qlqzp0g6782maj73yygmwlchhv4xcnlc7j0w3lp6dcj7qkzz68"))))
    (properties `((upstream-name . "shinyvalidate")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue r-htmltools r-rlang r-shiny))
    (native-inputs (list r-testthat))
    (home-page "https://rstudio.github.io/shinyvalidate/")
    (synopsis "Input validation for Shiny apps")
    (description
     "This package improves the user experience of Shiny apps by helping to
provide feedback when required inputs are missing, or input values are not
valid.")
    (license license:expat)))

(define-public r-shinydashboard
  (package
    (name "r-shinydashboard")
    (version "0.7.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shinydashboard" version))
              (sha256
               (base32
                "0k0llpzbys0qrzv37paihibhzn2riqgl0sqj7gzfqn3ahi8yh734"))))
    (build-system r-build-system)
    ;; The directory inst/AdminLTE/ contains a minified JavaScript file.
    ;; Regenerate it from the included sources.
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'generate-minified-javascript
           (lambda _
             (with-directory-excursion "inst/AdminLTE"
               (let ((target "app.min.js")
                     (source "app.js"))
                 (format #t "Processing ~a --> ~a~%"
                         source target)
                 (delete-file target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-htmltools r-promises r-shiny))
    (native-inputs
     (list esbuild))
    (home-page "https://rstudio.github.io/shinydashboard/")
    (synopsis "Create dashboards with shiny")
    (description "This package provides an extension to the Shiny web
application framework for R, making it easy to create attractive dashboards.")
    ;; This package includes software that was released under the Expat
    ;; license, but the whole package is released under GPL version 2 or
    ;; later.
    (license license:gpl2+)))

(define-public r-shinydashboardplus
  (package
    (name "r-shinydashboardplus")
    (version "2.0.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "shinydashboardPlus" version))
              (sha256
               (base32
                "1k53ycfdv5r58rwqsk7mkrrlz72wikhrhzlfrg3dkwbdbzblrhqb"))
              (modules '((guix build utils)))
              (snippet
               `(begin
                  (with-directory-excursion
                      ,(string-append "inst/shinydashboardPlus-" version
                                      "/js/")
                    (for-each delete-file
                              '("app.min.js"
                                "shinydashboardPlus.min.js"
                                "shinydashboardPlus.min.js.map")))
                  (with-directory-excursion "inst/materialDesign-1.0/js"
                    (for-each delete-file
                              '("material.min.js"
                                "ripples.min.js")))))))
    (properties `((upstream-name . "shinydashboardPlus")))
    (build-system r-build-system)
    (arguments
     (list
      ;; The tests launch a shinyApp; they are interactive tests that
      ;; will block forever, so we just don't run them.
      #:tests? #false
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils)
        (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion
                  (string-append "inst/shinydashboardPlus-" #$version "/js/")
                (for-each
                 (match-lambda
                   ((source . target)
                    (minify source #:target target)))
                 `(("app.js" . "app.min.js")
                   ("shinydashboardPlus.js" . "shinydashboardPlus.min.js")
                   (,(search-input-file inputs "/dist/js/material.js")
                    . "materialDesign-1.0/js/material.min.js")
                   (,(search-input-file inputs "/dist/js/ripples.js")
                    . "materialDesign-1.0/js/ripples.min.js")))))))))
    (propagated-inputs
     (list r-fresh
           r-htmltools
           r-lifecycle
           r-shiny
           r-shinydashboard
           r-waiter))
    (native-inputs
     (list esbuild r-knitr
           (let ((commit "92a2284b47aed56a9d7ae92cf9b40072d27982b3"))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/DucThanhNguyen/MaterialAdminLTE")
                     (commit commit)))
               (file-name (git-file-name "MaterialAdminLTE"
                                         (git-version "0" "0" commit)))
               (sha256
                (base32
                 "0cn11hxpf25h7xj2lk473z24swgz979dz255zwk2m2fj00iljkn9"))))))
    (home-page "https://github.com/RinteRface/shinydashboardPlus")
    (synopsis "Add more AdminLTE2 components to shinydashboard")
    (description
     "This package extends shinydashboard with AdminLTE2 components.
AdminLTE2 is a Bootstrap 3 dashboard template.  Customize boxes, add timelines
and a lot more.")
    (license license:gpl2+)))

(define-public r-shinyfiles
  (package
    (name "r-shinyfiles")
    (version "0.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyFiles" version))
       (sha256
        (base32 "11kjq0vw5c98lzrg80m9w917lkgw5im2h9wgk1b84vlaxrjy2wja"))))
    (properties `((upstream-name . "shinyFiles")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fs r-htmltools r-jsonlite r-shiny r-tibble))
    (home-page "https://github.com/thomasp85/shinyFiles")
    (synopsis "Server-side file system viewer for Shiny")
    (description
     "This package provides functionality for client-side navigation of the
server side file system in shiny apps.  In case the app is running locally
this gives the user direct access to the file system without the need to
\"download\" files to a temporary location.  Both file and folder selection as
well as file saving is available.")
    (license license:gpl2+)))

(define-public r-shinythemes
  (package
    (name "r-shinythemes")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinythemes" version))
       (sha256
        (base32
         "0qr9bfxw8afxns44i2j4msignf6g5qb2nzpay2lpv343rrlqbmip"))))
    (properties `((upstream-name . "shinythemes")))
    (build-system r-build-system)
    (propagated-inputs (list r-shiny))
    (home-page "https://rstudio.github.io/shinythemes/")
    (synopsis "Themes for Shiny")
    (description
     "This package provides themes for use with Shiny.  It includes several
Bootstrap themes, which are packaged for use with Shiny applications.")
    ;; The package is released under version 3 of the GPL, but it includes
    ;; source files that are covered by the Expat license.  It also includes
    ;; fonts under SIL or the ASL.
    (license (list license:gpl3 license:expat
                   license:silofl1.1 license:asl2.0))))

;; The package sources include minified variants of d3.js and non-minified
;; source code of d3-jetpack.
(define-public r-d3r
  (package
    (name "r-d3r")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "d3r" version))
       (sha256
        (base32
         "1dcm53y3jpyswr6y368xhdnn1nkchixf4wkxnsb2mk9lzccb44y4"))
       (snippet
        '(for-each delete-file
                   '("inst/www/d3/v3/dist/d3.min.js"
                     "inst/www/d3/v4/dist/d3.min.js"
                     "inst/www/d3/v5/dist/d3.min.js"
                     "inst/www/d3/v6/dist/d3.min.js"
                     "inst/www/d3/v7/dist/d3.min.js")))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/www/d3/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "d3.v3.js")
                         "v3/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v4.js")
                         "v4/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v5.js")
                         "v5/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v6.js")
                         "v6/dist/d3.min.js")
                        (,(assoc-ref inputs "d3.v7.js")
                         "v7/dist/d3.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #t "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-dplyr r-htmltools r-tidyr))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("d3.v3.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v3.js")
           (sha256
            (base32
             "1arr7sr08vy7wh0nvip2mi7dpyjw4576vf3bm45rp4g5lc1k1x41"))))
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))
       ("d3.v5.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v5.js")
           (sha256
            (base32
             "177ypw6mjrp2ch9lj6znibwacwrvm4ypjxflsxsnl2sigx5dcwic"))))
       ("d3.v6.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v6.js")
           (sha256
            (base32
             "13hick3glizzm442b9swlwz584rzwwvhpq9qvfbh3m5jay10wxw0"))))
       ("d3.v7.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v7.js")
           (sha256
            (base32
             "1m4i3kqzkz7w06sp9zqcy9f88xpdhi7cqih3phdrf4yjmfk1pfjg"))))
       ("r-testthat" ,r-testthat)))
    (home-page "https://github.com/timelyportfolio/d3r")
    (synopsis "Data visualization utilities for R")
    (description
     "This package provides a suite of functions to help ease the use of the
d3.js visualization library in R.  These helpers include
@code{htmltools::htmlDependency} functions, hierarchy builders, and conversion
tools for @code{partykit}, @code{igraph}, @code{table}, and @code{data.frame}
R objects into the JSON format that the d3.js library expects.")
    (license license:bsd-3)))

;; We use the latest commit here because the last release was in 2016 while
;; the latest commit was in 2018.
(define-public r-sankeyd3
  (let ((commit "fd50a74e29056e0d67d75b4d04de47afb2f932bc")
        (revision "1"))
    (package
      (name "r-sankeyd3")
      (version (git-version "0.3.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/fbreitwieser/sankeyD3")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "0jrcnfax321pszbpjdifnkbrgbjr43bjzvlzv1p5a8wskksqwiyx"))))
      (build-system r-build-system)
      (propagated-inputs
       (list r-d3r r-htmlwidgets r-shiny r-magrittr))
      (home-page "https://github.com/fbreitwieser/sankeyD3")
      (synopsis "Sankey network graphs from R")
      (description
       "This package provides an R library to generate Sankey network graphs
in R and Shiny via the D3 visualization library.")
      ;; The R code is licensed under GPLv3+.  It includes the non-minified
      ;; JavaScript source code of d3-sankey, which is released under the
      ;; 3-clause BSD license.
      (license (list license:gpl3+ license:bsd-3)))))

(define-public r-webfakes
  (package
    (name "r-webfakes")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webfakes" version))
       (sha256
        (base32 "18hcr63ci5cfdd9299va4gckabwx7mypw1jv5vydn2w8x4da2s68"))))
    (properties `((upstream-name . "webfakes")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           ;; This test requires Internet access.
           (lambda _ (delete-file "tests/testthat/test-httpbin.R"))))))
    (native-inputs (list r-curl
                         r-digest
                         r-httpuv
                         r-httr
                         r-jsonlite
                         r-testthat
                         r-withr
                         r-zip))
    (home-page "https://webfakes.r-lib.org/")
    (synopsis "Fake web apps for HTTP testing")
    (description
     "This package lets you create a web app that makes it easier to test web
clients without using the internet.  It includes a web app framework with path
matching, parameters and templates.  It can parse various HTTP request bodies.
It can send JSON data or files from the disk.  It includes a web app that
implements the httpbin.org web service.")
    (license license:expat)))

(define-public r-wesanderson
  (package
    (name "r-wesanderson")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wesanderson" version))
       (sha256
        (base32
         "0kjyz5mrkrirg2glf57b0rhxj2fdp1m6q8zx947y0jg1w425cbn9"))))
    (properties `((upstream-name . "wesanderson")))
    (build-system r-build-system)
    (home-page "https://github.com/karthik/wesanderson")
    (synopsis "Wes Anderson color palette generator")
    (description
     "This package provides color palettes that have been generated mostly
from Wes Anderson movies.")
    (license license:expat)))

(define-public r-gg-gap
  (package
    (name "r-gg-gap")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gg.gap" version))
       (sha256
        (base32
         "0m66050ryn31xmsmmikjsssllasvjdmp9yjbwfdwfpwdv106zn9h"))))
    (properties `((upstream-name . "gg.gap")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot r-ggplot2))
    (home-page "https://github.com/ChrisLou-bioinfo/gg.gap")
    (synopsis "Define segments on the y-axis for ggplot2")
    (description
     "The @code{gg.gap} function enables you to define segments for the y-axis
in a ggplot2 plot.")
    (license license:gpl3)))

(define-public r-mbess
  (package
    (name "r-mbess")
    (version "4.9.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "MBESS" version))
       (sha256
        (base32 "05ph8dwigwn0c4qg8smqhsjijvsvfawbzvm74mqpasi8qifz8nd3"))))
    (properties `((upstream-name . "MBESS")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-lavaan r-mass r-mnormt r-nlme r-openmx r-sem r-semtools))
    (home-page "https://www3.nd.edu/~kkelley/site/MBESS.html")
    (synopsis "Methods for designing research studies")
    (description
     "This package implements methods that are useful in designing research
studies and analyzing data, with particular emphasis on methods that are
developed for or used within the behavioral, educational, and social
sciences (broadly defined).  That being said, many of the methods implemented
within MBESS are applicable to a wide variety of disciplines.  MBESS has a
suite of functions for a variety of related topics, such as effect sizes,
confidence intervals for effect sizes (including standardized effect sizes and
noncentral effect sizes), sample size planning (from the @dfn{accuracy in
parameter estimation} (AIPE), power analytic, equivalence, and minimum-risk
point estimation perspectives), mediation analysis, various properties of
distributions, and a variety of utility functions.")
    ;; Either version of the GPL.
    (license (list license:gpl2 license:gpl3))))

(define-public r-homologene
  (package
    (name "r-homologene")
    (version "1.4.68.19.3.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "homologene" version))
       (sha256
        (base32 "0d7wxisk0vqk1n165v1i19bc02zv78h5r5d3jqai5y6nkmwn01sh"))))
    (properties `((upstream-name . "homologene")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-magrittr r-purrr r-r-utils r-readr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/oganm/homologene")
    (synopsis "Quick access to homologene and gene annotation updates")
    (description
     "This package provides a wrapper for the homologene database by the
National Center for Biotechnology Information (NCBI).  It allows searching for
gene homologs across species.  The package also includes an updated version of
the homologene database where gene identifiers and symbols are replaced with
their latest (at the time of submission) version and functions to fetch latest
annotation data to keep updated.")
    (license license:expat)))

(define-public r-ggtangle
  (package
    (name "r-ggtangle")
    (version "0.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggtangle" version))
       (sha256
        (base32 "1q24565y2icr8cs55cni2iyh22mqlk12nll19md96g4r3hbdq0al"))))
    (properties `((upstream-name . "ggtangle")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggfun
                             r-ggplot2
                             r-ggrepel
                             r-igraph
                             r-rlang
                             r-yulab-utils))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=ggtangle")
    (synopsis "Draw network with data")
    (description
     "This package extends the ggplot2 plotting system to support network
visualization.  Inspired by ggtree, ggtangle is designed to work with network
associated data.")
    (license license:artistic2.0)))

(define-public r-ggtern
  (package
    (name "r-ggtern")
    (version "3.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggtern" version))
       (sha256
        (base32 "0ymly9vdzk7rd4p27m1262bm7fvim989yswgw3mr9y0422dn8awa"))))
    (properties `((upstream-name . "ggtern")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-compositions
           r-ggplot2
           r-gridextra
           r-gtable
           r-hexbin
           r-latex2exp
           r-lattice
           r-mass
           r-plyr
           r-proto
           r-rlang
           r-scales))
    (home-page "http://www.ggtern.com")
    (synopsis "Extension to ggplot2 for ternary diagrams")
    (description
     "This package extends the functionality of ggplot2, providing the
capability to plot ternary diagrams for (a subset of) the ggplot2 geometries.
Additionally, ggtern has implemented several new geometries which are
unavailable to the standard ggplot2 release.")
    (license license:gpl2)))

(define-public r-tableone
  (package
    (name "r-tableone")
    (version "0.13.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tableone" version))
       (sha256
        (base32 "1br78y68037g5v5jhgi9l393kj2msamdklim8ki40hmxk9bibkxi"))))
    (properties `((upstream-name . "tableone")))
    (build-system r-build-system)
    (propagated-inputs (list r-e1071
                             r-gmodels
                             r-labelled
                             r-mass
                             r-nlme
                             r-survey
                             r-zoo))
    (native-inputs (list r-geepack
                         r-knitr
                         r-lme4
                         r-lmertest
                         r-matrix
                         r-survival
                         r-testthat))
    (home-page "https://github.com/kaz-yos/tableone")
    (synopsis
     "Describe baseline characteristics with or without propensity score weights")
    (description
     "This package creates \"Table 1\", i.e., description of baseline patient
characteristics, which is essential in every medical research.  It supports
both continuous and categorical variables, as well as p-values and
standardized mean differences.  Weighted data are supported via the
@code{survey} package.")
    (license license:gpl2)))

(define-public r-tablerdash
  (package
    (name "r-tablerdash")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tablerDash" version))
       (sha256
        (base32
         "0cjidfkxwc56xj9rka0ba80hnwvm05wfvpw65wwmr3l56smnfcbz"))
       ;; Delete minified JavaScript
       (snippet
        '(for-each delete-file
                   '("inst/tablerDash-0.1.0/require.min.js"
                     "inst/bootstrap-4.0.0/bootstrap.bundle.min.js")))))
    (properties `((upstream-name . "tablerDash")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst"
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         `((,(assoc-ref inputs "js-requirejs")
                            . "tablerDash-0.1.0/require.min.js")
                           (,(assoc-ref inputs "js-bootstrap")
                            . "bootstrap-4.0.0/bootstrap.bundle.min.js")))))))))
    (propagated-inputs
     (list r-htmltools r-shiny))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("js-requirejs"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/requirejs/requirejs/2.3.5/require.js")
           (sha256
            (base32
             "06w32mwqii9cx409ivda88z58qbkcdb4p6hf6jawchsgagaziyds"))))
       ("js-bootstrap"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/\
v4.0.0/dist/js/bootstrap.bundle.js")
           (sha256
            (base32
             "0cvfqffn45vfbj3fk6wmrhkyndhk4id89vgydssbbzxjkfwprfrj"))))))
    (home-page "https://rinterface.github.io/tablerDash/")
    (synopsis "Tabler API for Shiny")
    (description
     "This package provides an R interface to the
@url{https://tabler.io,Tabler} HTML template.  tablerDash is a light Bootstrap
4 dashboard template.  There are different layouts available such as a one
page dashboard or a multi-page template, where the navigation menu is
contained in the navigation bar.")
    (license license:gpl2+)))

(define-public r-spdl
  (package
    (name "r-spdl")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spdl" version))
       (sha256
        (base32 "185qzlwac7acq126xpvcd71nv25zgkrdr8m73gv2sn1zxj78hyid"))))
    (properties `((upstream-name . "spdl")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcppspdlog))
    (home-page "https://github.com/eddelbuettel/spdl")
    (synopsis "Easier use of RcppSpdlog functions via wrapper")
    (description
     "Logging functions in @code{RcppSpdlog} provide access to the logging
functionality from the spdlog C++ library.  This package offers shorter
convenience wrappers for the R functions which match the C++ functions, namely
via, say, @code{spdl::debug()} at the debug level.  The actual formatting is
done by the @code{fmt::format()} function from the fmtlib library (that is
also @code{std::format()} in C++20 or later).")
    (license license:gpl2+)))

(define-public r-spelling
  (package
    (name "r-spelling")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "spelling" version))
       (sha256
        (base32
         "1mww2czkfrb1xvjbks7g1xhr8nx1v9mikb2lc3ynn6j2rp9zgwgp"))))
    (properties `((upstream-name . "spelling")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-commonmark r-hunspell r-knitr r-xml2))
    (home-page "https://docs.ropensci.org/spelling/")
    (synopsis "Tools for spell checking in R")
    (description
     "This is an R package for spell checking common document formats
including LaTeX, markdown, manual pages, and DESCRIPTION files.  It includes
utilities to automate checking of documentation and vignettes as a unit test
during @code{R CMD check}.  Both British and American English are supported
out of the box and other languages can be added.  In addition, packages may
define a wordlist to allow custom terminology without having to abuse
punctuation.")
    (license license:expat)))

(define-public r-caper
  (package
    (name "r-caper")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "caper" version))
       (sha256
        (base32 "1f1mw54gv1r40wrrsznhgffdj8ggrwihiwdd8wyqccyvqm49fxjg"))))
    (properties `((upstream-name . "caper")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape r-mass r-mvtnorm))
    (home-page "https://cran.r-project.org/package=caper")
    (synopsis "Comparative analyses of phylogenetics and evolution in R")
    (description
     "This package provides functions for performing phylogenetic comparative
analyses.")
    (license license:gpl2+)))

(define-public r-crosstalk
  (package
    (name "r-crosstalk")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "crosstalk" version))
       (sha256
        (base32
         "1w8lc3hcd1nlw541880vs3agk2i6bilyapnq9lcs3mfn2s2g0338"))
       (snippet
        '(for-each delete-file
                   (list "inst/lib/jquery/jquery.min.js"
                         "inst/lib/ionrangeslider/js/ion.rangeSlider.min.js"
                         "inst/lib/selectize/js/selectize.min.js"
                         "inst/www/js/crosstalk.min.js")))))
    (build-system r-build-system)
    (properties
     '((updater-extra-native-inputs . ("r-sass" "r-shiny"))))
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'replace-bundled-minified-JavaScript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/"
                (copy-file (search-input-file inputs
                                              "/share/javascript/selectize.min.js")
                           "lib/selectize/js/selectize.min.js")
                (for-each (match-lambda
                            ((source . target)
                             (minify source #:target target)))
                          `(("lib/jquery/jquery.js"
                             . "lib/jquery/jquery.min.js")
                            ("lib/ionrangeslider/js/ion.rangeSlider.js"
                             . "lib/ionrangeslider/js/ion.rangeSlider.min.js")
                            ("www/js/crosstalk.js"
                             . "www/js/crosstalk.min.js")))))))))
    (propagated-inputs
     (list r-htmltools r-jsonlite r-lazyeval r-r6))
    (native-inputs
     (list esbuild js-selectize r-sass r-shiny r-testthat))
    (home-page "https://rstudio.github.io/crosstalk/")
    (synopsis "Inter-widget interactivity for HTML widgets")
    (description
     "This package provides building blocks for allowing HTML widgets to
communicate with each other, with Shiny or without (i.e., static @code{.html}
files).  It currently supports linked brushing and filtering.")
    (license license:expat)))

(define-public r-rook
  (package
    (name "r-rook")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rook" version))
       (sha256
        (base32
         "0qjziszrrwsp1mbykps3yf5r98q83cyd4jzpgi7gvbsd2ssy96n7"))))
    (properties `((upstream-name . "Rook")))
    (build-system r-build-system)
    (propagated-inputs (list r-brew))
    (home-page "https://cran.r-project.org/web/packages/Rook")
    (synopsis "Web server interface for R")
    (description
     "This package contains the Rook specification and convenience software
for building and running Rook applications.  A Rook application is an R
reference class object that implements a @code{call} method or an R closure
that takes exactly one argument, an environment, and returns a list with three
named elements: the @code{status}, the @code{headers}, and the @code{body}.")
    (license license:gpl2)))

(define-public r-miniui
  (package
    (name "r-miniui")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "miniUI" version))
       (sha256
        (base32
         "0by2g7wfn4jwzz79hw2y72nxsdl67cr6ix902wj8blw4flglhyh1"))))
    (properties `((upstream-name . "miniUI")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-htmltools r-shiny))
    (home-page "https://cran.r-project.org/web/packages/miniUI/")
    (synopsis "Shiny UI widgets for small screens")
    (description
     "This package provides UI widget and layout functions for writing Shiny apps that
work well on small screens.")
    (license license:gpl3)))

(define-public r-minty
  (package
    (name "r-minty")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "minty" version))
       (sha256
        (base32 "0sr25z83v00hvq5c80jp70yialnay6c3fjykn1j8clr9s2z5ins7"))))
    (properties
     '((upstream-name . "minty")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cpp11 r-tzdb))
    (native-inputs (list r-hms r-testthat r-withr tzdata-for-tests))
    (home-page "https://gesistsa.github.io/minty/")
    (synopsis "Minimal type guesser")
    (description
     "This is a port of the type guesser from the @code{readr} package, the
so-called readr first edition parsing engine, now superseded by vroom.")
    (license license:expat)))

(define-public r-mirt
  (package
    (name "r-mirt")
    (version "1.44.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mirt" version))
       (sha256
        (base32 "1r8nv5669bacn3rq6lczc0fm0dgcm1kn8lxjd07lwkg2h4mjir6f"))))
    (properties `((upstream-name . "mirt")))
    (build-system r-build-system)
    (propagated-inputs (list r-dcurver
                             r-deriv
                             r-gparotation
                             r-gridextra
                             r-lattice
                             r-matrix
                             r-mgcv
                             r-pbapply
                             r-rcpp
                             r-rcpparmadillo
                             r-simdesign
                             r-vegan))
    (native-inputs (list r-boot r-knitr r-nonnest2))
    (home-page "https://philchalmers.github.io/mirt/")
    (synopsis "Multidimensional item response theory")
    (description
     "This is a package for the analysis of discrete response data using
unidimensional and multidimensional item analysis models under the Item
Response Theory paradigm (Chalmers (2012) <doi:10.18637/jss.v048.i06>).
Exploratory and confirmatory item factor analysis models are estimated with
quadrature (EM) or stochastic (MHRM) methods.  Confirmatory bi-factor and
two-tier models are available for modeling item testlets using dimension
reduction EM algorithms, while multiple group analyses and mixed effects
designs are included for detecting differential item, bundle, and test
functioning, and for modeling item and person covariates.  Finally, latent
class models such as the DINA, DINO, multidimensional latent class, mixture
IRT models, and zero-inflated response models are supported.")
    (license license:gpl3+)))

(define-public r-feather
  (package
    (name "r-feather")
    (version "0.3.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "feather" version))
       (sha256
        (base32
         "1gxd0h2m56sjjlzn4dry6s13nddxc4l5i11gsvavaf2dwbahdzsh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hms r-rcpp r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/wesm/feather")
    (synopsis "R Bindings to the Feather API")
    (description "Read and write feather files, a lightweight binary columnar
data store designed for maximum speed.")
    (license license:asl2.0)))

(define-public r-mapdata
  (package
    (name "r-mapdata")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "mapdata" version))
              (sha256
               (base32
                "1m2r4c8f7fp900g3sdjbfxxnxjla86hn75jd8hi96ms188p0j8b0"))))
    (properties `((upstream-name . "mapdata")))
    (build-system r-build-system)
    (propagated-inputs (list r-maps))
    (home-page "https://cran.r-project.org/package=mapdata")
    (synopsis "Extra map databases")
    (description
     "This is a supplement to the @code{maps} package providing the larger
and/or higher-resolution databases.")
    (license license:gpl2)))

(define-public r-maps
  (package
    (name "r-maps")
    (version "3.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "maps" version))
       (sha256
        (base32
         "1f48spc254c0gvbyi57gxx5i5kyvszhgp29zvc6jhh806d2ljv9v"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/maps")
    (synopsis "Draw geographical maps")
    (description "This package provides an R module for display of maps.
Projection code and larger maps are in separate packages (@code{mapproj} and
@code{mapdata}).")
    (license license:gpl2)))

(define-public r-mapproj
  (package
    (name "r-mapproj")
    (version "1.2.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mapproj" version))
       (sha256
        (base32
         "0xv03pbsdcnyzy0p17sdwxkyzq9zjsvab2lylhslk2692wnv240j"))))
    (build-system r-build-system)
    (propagated-inputs (list r-maps))
    (home-page "https://cran.r-project.org/web/packages/mapproj")
    (synopsis "Map projection in R")
    (description "This package converts latitude/longitude into projected
coordinates.")
    (license (list license:gpl2          ; The R interface
                   license:lpl1.02))))   ; The C code

(define-public r-rgooglemaps
  (package
    (name "r-rgooglemaps")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RgoogleMaps" version))
       (sha256
        (base32
         "197q5i2sky824dwq0x4hhrpkrsd1b6f9qg06mjlwb89mv4vnrzhl"))))
    (properties `((upstream-name . "RgoogleMaps")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-png))
    (home-page "https://cran.r-project.org/web/packages/RgoogleMaps")
    (synopsis "Use Google Maps in R")
    (description "This package serves two purposes:
@enumerate
@item Provide a comfortable R interface to query the Google server for static
  maps, and
@item Use the map as a background image to overlay plots within R.  This
  requires proper coordinate scaling.
@end enumerate\n")
    (license license:gpl2+)))

(define-public r-gensa
  (package
    (name "r-gensa")
    (version "1.1.14.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "GenSA" version))
              (sha256
               (base32
                "0zrprs5gb0pwl249gnvs675ph5f59z2dhis562xfmjbhsv5m9p9g"))))
    (properties `((upstream-name . "GenSA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=GenSA")
    (synopsis "Generalized simulated annealing")
    (description "This package performs search for the global minimum of a very
complex non-linear objective function with a very large number of optima.")
    (license license:gpl2)))

(define-public r-geojsonr
  (package
    (name "r-geojsonr")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geojsonR" version))
       (sha256
        (base32 "10li5xj0vx6a86nccwql4inwfbjycvaxqfbjdp4h1p5qxyibnls3"))))
    (properties `((upstream-name . "geojsonR")))
    (build-system r-build-system)
    (propagated-inputs (list r-r6 r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mlampros/geojsonR")
    (synopsis "GeoJson processing toolkit")
    (description
     "This package includes functions for processing @code{GeoJson} objects
relying on RFC 7946.  The geojson encoding is based on json11, a tiny JSON
library for C++11.  Furthermore, the source code is exported in R through the
Rcpp and @code{RcppArmadillo} packages.")
    (license license:expat)))

(define-public r-geos
  (package
    (name "r-geos")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geos" version))
       (sha256
        (base32 "03cxm9rby7qmk9apqk3sh373rnzqcrj23cn6q153gq93lx372b8n"))))
    (properties
     '((upstream-name . "geos")
       (updater-extra-native-inputs . ("r-vctrs"))))
    (build-system r-build-system)
    (propagated-inputs (list r-libgeos r-wk))
    (native-inputs (list r-testthat r-vctrs))
    (home-page "https://paleolimbot.github.io/geos/")
    (synopsis "Open Source Geometry Engine (GEOS) R API")
    (description
     "This package provides an R API to the Open Source Geometry Engine (GEOS)
library and a vector format with which to efficiently store GEOS geometries.
High-performance functions to extract information from, calculate
relationships between, and transform geometries are provided.  Finally,
facilities to import and export geometry vectors to other spatial formats are
provided.")
    (license license:expat)))

(define-public r-geosphere
  (package
    (name "r-geosphere")
    (version "1.5-20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geosphere" version))
       (sha256
        (base32
         "01cwlrbqi216a19h9721i0vj7vakrybybqkicbg9pwyv6c2hy8cq"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-sp))
    (home-page "https://cran.r-project.org/web/packages/geosphere")
    (synopsis "Spherical trigonometry")
    (description "This package computes spherical trigonometry for geographic
applications.  That is, compute distances and related measures for angular
(longitude/latitude) locations.")
    (license license:gpl3+)))

(define-public r-getip
  (package
    (name "r-getip")
    (version "0.1-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "getip" version))
       (sha256
        (base32 "0qyld6sy1i7kmbvcyg3vdv31qdyj81n54v6gvknb7nrqwwl8bgv3"))))
    (properties `((upstream-name . "getip")))
    (build-system r-build-system)
    (arguments (list #:tests? #false))  ;tests net networking
    (home-page "https://cran.r-project.org/package=getip")
    (synopsis "IP address lookup")
    (description
     "This package is a micro-package for getting your IP address,
either the local/internal or the public/external one.  Currently only IPv4
addresses are supported.")
    (license license:bsd-2)))

(define-public r-jpeg
  (package
    (name "r-jpeg")
    (version "0.1-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jpeg" version))
       (sha256
        (base32
         "0a9pn0rshqx1r9kqkg1n4m1i98plfdaj2h0y8055kk7v92yyyf91"))))
    (build-system r-build-system)
    (inputs (list libjpeg-turbo))
    (home-page "https://www.rforge.net/jpeg/")
    (synopsis "Read and write JPEG images with R")
    (description "This package provides a way to read, write and display
bitmap images stored in the JPEG format with R.  It can read and write both
files and in-memory raw vectors.")
    (license license:gpl2+)))

(define-public r-ggmap
  (package
    (name "r-ggmap")
    (version "4.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggmap" version))
       (sha256
        (base32
         "0ryl8zglgkq0kpkfyi9xq6kc7alv0zjaaqw21iqj7f5jj1x0l9df"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bitops
           r-cli
           r-digest
           r-dplyr
           r-ggplot2
           r-glue
           r-httr
           r-jpeg
           r-magrittr
           r-plyr
           r-png
           r-purrr
           r-rlang
           r-scales
           r-stringr
           r-tibble
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/dkahle/ggmap")
    (synopsis "Spatial visualization with ggplot2")
    (description "This package provides a collection of functions to visualize
spatial data and models on top of static maps from various online sources (e.g
Google Maps and Stamen Maps).  It includes tools common to those tasks,
including functions for geolocation and routing.")
    (license license:gpl2)))

(define-public r-ggmosaic
  (package
    (name "r-ggmosaic")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggmosaic" version))
       (sha256
        (base32 "1zm1zfbd0qk6icw65m9hz1hgyqj632ibq3qilidvx5jy7jh8nbpy"))))
    (properties `((upstream-name . "ggmosaic")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr
                             r-ggplot2
                             r-ggrepel
                             r-plotly
                             r-productplots
                             r-purrr
                             r-rlang
                             r-scales
                             r-tidyr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/haleyjeppson/ggmosaic")
    (synopsis "Mosaic plots in the ggplot2 framework")
    (description
     "This package provides mosaic plots for the ggplot2 framework.  Mosaic
plot functionality is provided in a single ggplot2 layer by calling the
@code{geom} @code{mosaic}.")
    (license license:gpl2+)))

(define-public r-haven
  (package
    (name "r-haven")
    (version "2.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "haven" version))
       (sha256
        (base32
         "19f9n7a4g90fdwhx66cjyxmzm5zdgwqkawk8ry587qb06yfcv0ll"))
       (modules '((guix build utils)))
       (snippet
        ;; unvendor readstat
        '(delete-file-recursively "src/readstat"))))
    (build-system r-build-system)
    (properties
     '((updater-extra-inputs . ("readstat"))))
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'unbundle-readstat
           (lambda _
             ;; We’re not building readstat.
             (substitute* "configure"
               (("^PKG_CONFIG_NAME=\"zlib\"")
                "PKG_CONFIG_NAME=\"readstat zlib\"")
               (("^PKG_LIBS=\"-lz\"")
                "PKG_LIBS=\"-lz -lreadstat\"\n")
               (("exit 1") "")))))))  ;don't be so dramatic!
    (inputs
     (list readstat zlib))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (propagated-inputs
     (list r-cli
           r-cpp11
           r-forcats
           r-hms
           r-lifecycle
           r-readr
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (home-page "https://haven.tidyverse.org")
    (synopsis "Import and export SPSS, Stata and SAS files")
    (description
     "This package lets you import foreign statistical formats into R via the
@url{https://github.com/WizardMac/ReadStat,ReadStat} C library.")
    (license license:expat)))

(define-public r-amap
  (package
    (name "r-amap")
    (version "0.8-20")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "amap" version))
              (sha256
               (base32
                "0w65z1jqg6c9fp6knv9ps5f22f4jk94hbihr6l0hbmijiznbffwq"))))
    (build-system r-build-system)
    (native-inputs
     (list gfortran))
    (home-page "http://mulcyber.toulouse.inra.fr/projects/amap/")
    (synopsis "Another multidimensional analysis package")
    (description "This package provides tools for clustering and principal
component analysis (with robust methods, and parallelized functions).")
    (license license:gpl2+)))

(define-public r-ape
  (package
    (name "r-ape")
    (version "5.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ape" version))
       (sha256
        (base32
         "13id88b2g2m7zgp3r8nigyainlpbld1z2d7n87bplnailzfy7kfn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest r-lattice r-nlme r-rcpp))
    (home-page "http://ape-package.ird.fr/")
    (synopsis "Analyses of phylogenetics and evolution")
    (description
     "This package provides functions for reading, writing, plotting, and
manipulating phylogenetic trees, analyses of comparative data in a
phylogenetic framework, ancestral character analyses, analyses of
diversification and macroevolution, computing distances from DNA sequences,
and several other tools.")
    (license license:gpl2+)))

(define-public r-abbyyr
  (package
    (name "r-abbyyr")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abbyyR" version))
       (sha256
        (base32
         "1vldnd3dg89aj6a73nhirirqddbfdrnzhb5m3679i60sark8nk6r"))))
    (properties `((upstream-name . "abbyyR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl
           r-httr
           r-plyr
           r-progress
           r-readr
           r-xml))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/soodoku/abbyyR")
    (synopsis "Access to Abbyy Optical Character Recognition (OCR) API")
    (description
     "This package provides tools to get text from images of text using Abbyy
Cloud Optical Character Recognition (OCR) API.  With abbyyyR, one can easily
OCR images, barcodes, forms, documents with machine readable zones, e.g.
passports and get the results in a variety of formats including plain text and
XML.  To learn more about the Abbyy OCR API, see @url{http://ocrsdk.com/}.")
    (license license:expat)))

(define-public r-colorspace
  (package
    (name "r-colorspace")
    (version "2.1-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "colorspace" version))
       (sha256
        (base32 "02ydb0vncck0l9shfbz07gymdy5l2vinb0miivyb1r6nykjww8g7"))))
    (build-system r-build-system)
    ;; Tests require r-vcd, which depends on this package.
    (arguments (list #:tests? #false))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/colorspace")
    (synopsis "Color space manipulation")
    (description
     "This package carries out a mapping between assorted color spaces
including RGB, HSV, HLS, CIEXYZ, CIELUV, HCL (polar CIELUV), CIELAB and polar
CIELAB.  Qualitative, sequential, and diverging color palettes based on HCL
colors are provided.")
    (license license:bsd-3)))

(define-public r-glue
  (package
    (name "r-glue")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "glue" version))
       (sha256
        (base32
         "183j9gpffmi30lfifl8d9sq1l25f8dgsgqd3blpndf4rm15kcvy8"))))
    (properties
     ;; knitr depends on glue, so we can't add knitr here to build the
     ;; vignettes.  Same with testthat
     '((updater-ignored-native-inputs . ("r-knitr" "r-testthat"))))
    (build-system r-build-system)
    (arguments (list #:tests? #false))
    (home-page "https://github.com/tidyverse/glue")
    (synopsis "Interpreted string literals")
    (description
     "This package provides an implementation of interpreted string literals,
inspired by Python's Literal String Interpolation (PEP-0498) and
Docstrings (PEP-0257) and Julia's Triple-Quoted String Literals.")
    (license license:expat)))

(define-public r-glmnetutils
  (package
    (name "r-glmnetutils")
    (version "1.1.9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "glmnetUtils" version))
              (sha256
               (base32
                "0rh07i9j6bxiqcl84d8jnn7dzqdwfdzak7w8bf4j4521r24mwm01"))))
    (properties `((upstream-name . "glmnetUtils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-glmnet r-matrix))
    (native-inputs (list r-knitr r-mass r-testthat))
    (home-page "https://github.com/hongooi73/glmnetUtils")
    (synopsis
     "Streamline the process of fitting elastic net models with glmnet")
    (description
     "This package provides a collection of tools to streamline the
process of fitting elastic net models with @code{glmnet}.  In addition
to providing a formula interface, it also features a function
@code{cva.glmnet} to do crossvalidation for both α and λ, as well as
some utility functions.")
    (license license:gpl2)))

(define-public r-paletteer
  (package
    (name "r-paletteer")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "paletteer" version))
              (sha256
               (base32
                "1n4jim2fgyff6c5mjridq92jgvr5m2qgwfsgvhyj1pwk1hq21pmm"))))
    (properties `((upstream-name . "paletteer")))
    (build-system r-build-system)
    (propagated-inputs (list r-prismatic r-rematch2 r-rlang r-rstudioapi))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/EmilHvitfeldt/paletteer")
    (synopsis "Comprehensive collection of color palettes")
    (description
     "The choices of color palettes in R can be quite overwhelming with palettes
spread over many packages with many different API's.  This package aims to
collect all color palettes across the R ecosystem under the same package with
a streamlined API.")
    (license license:gpl3)))

(define-public r-palmerpenguins
  (package
    (name "r-palmerpenguins")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "palmerpenguins" version))
       (sha256
        (base32
         "1d1h3bfx750is4qqj4w00rcigk9rrdy69bvd5bgqz5y7ls5x8h1a"))))
    (properties
     `((upstream-name . "palmerpenguins")))
    (build-system r-build-system)
    (home-page "https://allisonhorst.github.io/palmerpenguins/")
    (synopsis "Palmer Archipelago (Antarctica) penguin data")
    (description
     "This package includes size measurements, clutch observations, and blood
isotope ratios for adult foraging Adélie, Chinstrap, and Gentoo penguins
observed on islands in the Palmer Archipelago near Palmer Station, Antarctica.
Data were collected and made available by Dr. Kristen Gorman and the Palmer
Station Long Term Ecological Research (LTER) Program.")
    (license license:cc0)))

(define-public r-party
  (package
    (name "r-party")
    (version "1.3-18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "party" version))
       (sha256
        (base32 "19snk50f1b1sw2ysmfn2d4qqzkm0hz5qfpgahkwgi5vql89p9xqy"))))
    (properties
     '((upstream-name . "party")
       (updater-extra-native-inputs . ("r-mlbench" "r-vcd"))))
    (build-system r-build-system)
    (propagated-inputs (list r-coin
                             r-modeltools
                             r-mvtnorm
                             r-sandwich
                             r-strucchange
                             r-survival
                             r-zoo))
    (native-inputs (list r-mlbench r-vcd))
    (home-page "https://party.r-forge.r-project.org")
    (synopsis "Laboratory for recursive partitioning")
    (description
     "This package provides a computational toolbox for recursive
partitioning.  The core of the package is @code{ctree()}, an implementation of
conditional inference trees which embed tree-structured regression models into
a well defined theory of conditional inference procedures.  This
non-parametric class of regression trees is applicable to all kinds of
regression problems, including nominal, ordinal, numeric, censored as well as
multivariate response variables and arbitrary measurement scales of the
covariates.  Based on conditional inference trees, @code{cforest()} provides
an implementation of Breiman's random forests.  The function @code{mob()}
implements an algorithm for recursive partitioning based on parametric
models (e.g. linear models, GLMs or survival regression) employing parameter
instability tests for split selection.  Extensible functionality for
visualizing tree-structured regression models is available.")
    (license license:gpl2)))

(define-public r-pastecs
  (package
   (name "r-pastecs")
   (version "1.4.2")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pastecs" version))
            (sha256
             (base32
              "1y3nngdmslbs1rls0n2nbx8jpp9z3nvv11w1z6rff6v0ky05ddj3"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-boot))
   (native-inputs (list r-knitr r-svunit))
   (home-page "https://github.com/phgrosjean/pastecs")
   (synopsis "Analysis of space-time ecological series")
   (description
    "This package provides functions for regulation, decomposition and analysis
of space-time series.  The @code{pastecs} library is a PNEC-Art4 and IFREMER
initiative to bring PASSTEC 2000 functionalities to R.")
   (license license:gpl2+)))

(define-public r-partykit
  (package
   (name "r-partykit")
   (version "1.2-24")
   (source (origin
             (method url-fetch)
             (uri (cran-uri "partykit" version))
             (sha256
              (base32
               "1zy92iwhl9979mqa5bxz50k66vxysn07zd1z40z0y44g8msnph20"))))
   (properties
    '((updater-extra-native-inputs . ("r-mlbench")))) ;for tests
   (build-system r-build-system)
   ;; Vignettes require r-psychotree, which depends on this package.
   (arguments (list #:test-types '(list "tests")))
   (propagated-inputs
    (list r-formula
          r-inum
          r-libcoin
          r-mvtnorm
          r-rpart
          r-survival))
   (native-inputs (list r-coin
                        r-mlbench
                        r-party
                        r-pmml
                        r-psychotools
                        r-sandwich
                        r-strucchange
                        r-xml))
   (home-page "https://partykit.R-Forge.R-project.org/partykit")
   (synopsis "Toolkit for recursive partytioning")
   (description
    "This package provides a toolkit with infrastructure for representing,
summarizing, and visualizing tree-structured regression and classification
models.")
   (license license:gpl2+)))

(define-public r-plogr
  (package
    (name "r-plogr")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "plogr" version))
       (sha256
        (base32
         "0a8dhzlna79ggyhfr0nncgh15a9n6r0dsz664pz0ah323wpblqqf"))))
    (build-system r-build-system)
    (home-page "https://github.com/krlmlr/plogr")
    (synopsis "R bindings for the plog C++ logging library")
    (description
     "This package provides the header files for a stripped-down version of
the plog header-only C++ logging library, and a method to log to R's standard
error stream.")
    (license license:expat)))

(define-public r-pls
  (package
    (name "r-pls")
    (version "2.8-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pls" version))
       (sha256
        (base32 "1krkl11b90w4hbdj168x4x9mvifwmx8ia265gr6gl8c99j6h2ac0"))))
    (build-system r-build-system)
    (native-inputs (list r-runit r-testthat))
    (home-page "https://mevik.net/work/software/pls.html")
    (synopsis "Partial Least Squares and Principal Component Regression")
    (description
     "The pls package implements multivariate regression methods: Partial Least
Squares Regression (@dfn{PLSR}), Principal Component Regression (@dfn{PCR}), and
Canonical Powered Partial Least Squares (@dfn{CPPLS}).  It supports:

@itemize
@item several algorithms: the traditional orthogonal scores (@dfn{NIPALS}) PLS
algorithm, kernel PLS, wide kernel PLS, Simpls, and PCR through @code{svd}
@item multi-response models (or @dfn{PLS2})
@item flexible cross-validation
@item Jackknife variance estimates of regression coefficients
@item extensive and flexible plots: scores, loadings, predictions, coefficients,
(R)MSEP, R², and correlation loadings
@item formula interface, modelled after @code{lm()}, with methods for predict,
print, summary, plot, update, etc.
@item extraction functions for coefficients, scores, and loadings
@item MSEP, RMSEP, and R² estimates
@item multiplicative scatter correction (@dfn{MSC})
@end itemize\n")
    (license license:gpl2)))

(define-public r-ps
  (package
    (name "r-ps")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ps" version))
       (sha256
        (base32 "0zfzlifhg88cfk1sg4l9sgai0qinjdjy2wcb17z4ls47xc5kq2bg"))))
    (properties
     ;; We can't have r-testthat among the inputs, because that would lead to
     ;; a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests depend on r-testthat, which depends indirectly on r-ps.
    (arguments (list #:tests? #false))
    (home-page "https://ps.r-lib.org")
    (synopsis "List, query, and manipulate system processes")
    (description
     "The ps package implements an API to list, query, and manipulate system
processes.  Most of its code is based on the @code{psutil} Python package.")
    (license license:bsd-3)))

(define-public r-psychometric
  (package
    (name "r-psychometric")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psychometric" version))
       (sha256
        (base32 "1mlggzw80pb7kfykva1s4ic726l8dckrgik2519njh32ycvk9x1s"))))
    (properties `((upstream-name . "psychometric")))
    (build-system r-build-system)
    (propagated-inputs (list r-dplyr r-multilevel r-nlme r-purrr))
    (home-page "https://cran.r-project.org/package=psychometric")
    (synopsis "Applied psychometric theory")
    (description
     "This package contains functions useful for correlation theory,
meta-analysis (validity-generalization), reliability, item analysis,
inter-rater reliability, and classical utility.")
    (license license:gpl2+)))

(define-public r-pkgbuild
  (package
    (name "r-pkgbuild")
    (version "1.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgbuild" version))
       (sha256
        (base32 "1jr4k43vj62hw8ak076pky7a68gz2kz6rwqzyd9c83z95hh5jhif"))))
    (properties
     ;; We can't have r-testthat among the inputs, because that would lead to
     ;; a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"
                                         "r-knitr"
                                         "r-rmarkdown"
                                         "r-withr"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, but that package indirectly depends on
    ;; r-pkgbuild.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-callr r-cli r-desc r-processx r-r6))
    (home-page "https://github.com/r-pkgs/pkgbuild")
    (synopsis "Find tools needed to build R packages")
    (description
     "This package provides functions used to build R packages.  It locates
compilers needed to build R packages on various platforms and ensures the PATH
is configured appropriately so R can use them.")
    (license license:gpl3)))

(define-public r-pkgload
  (package
    (name "r-pkgload")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pkgload" version))
       (sha256
        (base32
         "0jbmlvii40q6ymdhislmgby6dpf9585xl9d5cf8g4nn2kig8ir09"))))
    (properties
     ;; Avoid dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    ;; Tests require r-testthat.  Adding it to the inputs would lead to a
    ;; dependency cycle.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli
           r-desc
           r-fs
           r-glue
           r-lifecycle
           r-pkgbuild
           r-processx
           r-rlang
           r-rprojroot
           r-withr))
    (home-page "https://github.com/r-lib/pkgload")
    (synopsis "Simulate package installation and attach")
    (description
     "This package simulates the process of installing a package and then
attaching it.  This is a key part of the @code{devtools} package as it allows
you to rapidly iterate while developing a package.")
    (license license:gpl3)))

(define-public r-pki
  (package
    (name "r-pki")
    (version "0.1-14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PKI" version))
       (sha256
        (base32 "0rkr3gf5aqkrxi134kwggsyj151nwcwndy8d8q2vfy5rfwcyh960"))))
    (properties `((upstream-name . "PKI")))
    (build-system r-build-system)
    (inputs (list openssl zlib))
    (propagated-inputs (list r-base64enc))
    (native-inputs (list pkg-config))
    (home-page "http://www.rforge.net/PKI")
    (synopsis "Public Key Infrastructure for R based on the X.509 standard")
    (description
     "This is a package containing Public Key Infrastructure functions such as
verifying certificates, RSA encryption and signing, which can be used to build
PKI infrastructure and perform cryptographic tasks.")
    ;; Either of these licenses.
    (license (list license:gpl2 license:gpl3))))

(define-public r-pvclust
  (package
   (name "r-pvclust")
   (version "2.2-0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pvclust" version))
            (sha256
             (base32
              "0082icm54k2yq60k06qpr92a626k39j2jr0046lva4ylmhxqb4kq"))))
   (build-system r-build-system)
   (home-page "https://github.com/shimo-lab/pvclust")
   (synopsis
    "Hierarchical clustering with P-values via multiscale bootstrap resampling")
   (description "This package provides an implementation of multiscale bootstrap
resampling for assessing the uncertainty in hierarchical cluster analysis.  It
provides an AU (approximately unbiased) P-value as well as a BP (bootstrap probability)
value for each cluster in a dendrogram.")
    (license license:gpl2+)))

(define-public r-rcpp
  (package
    (name "r-rcpp")
    (version "1.0.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rcpp" version))
       (sha256
        (base32 "00l0791grrwkg4rkqb6k6d5x9qas9cizbgnv7iqy5qxhxx94ms3l"))))
    (build-system r-build-system)
    (home-page "https://www.rcpp.org")
    (synopsis "Seamless R and C++ integration")
    (description
     "The Rcpp package provides R functions as well as C++ classes which offer
a seamless integration of R and C++.  Many R data types and objects can be
mapped back and forth to C++ equivalents which facilitates both writing of new
code as well as easier integration of third-party libraries.  Documentation
about Rcpp is provided by several vignettes included in this package, via the
@code{Rcpp Gallery} site at <http://gallery.rcpp.org>, the paper by Eddelbuettel
and Francois (2011, JSS), and the book by Eddelbuettel (2013, Springer); see
@code{citation(\"Rcpp\")} for details on these last two.")
    (license license:gpl2+)))

(define-public r-rcppcctz
  (package
    (name "r-rcppcctz")
    (version "0.2.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppCCTZ" version))
       (sha256
        (base32 "1wmbyaj08fbl4g47aq0mfkkvqwpah3d2j94fzc813dijxlsi847l"))))
    (properties
     `((upstream-name . "RcppCCTZ")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-tinytest tzdata-for-tests))
    (home-page "https://github.com/eddelbuettel/rcppcctz")
    (synopsis "Rcpp bindings for the CCTZ library")
    (description
     "Rcpp access to the CCTZ timezone library is provided.  CCTZ is a C++
library for translating between absolute and civil times using the rules of a
time zone.  The CCTZ source code is included in this package.")
    (license (list license:gpl2+
                   license:asl2.0)))) ;for CCTZ

(define-public r-rcppdate
  (package
    (name "r-rcppdate")
    (version "0.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppDate" version))
       (sha256
        (base32 "0l3bzvr50j01g0h42nhlsnlz2b9l129n24hs0sj8h918rh1a8bxk"))))
    (properties `((upstream-name . "RcppDate")))
    (build-system r-build-system)
    (home-page "https://github.com/eddelbuettel/rcppdate")
    (synopsis "date C++ header library for date and time functionality")
    (description
     "This package provides a header-only C++ library is provided with support
for dates, time zones, ISO weeks, Julian dates, and Islamic dates.
@code{date} offers extensive date and time functionality for the C++11, C++14
and C++17 standards.  A slightly modified version has been accepted (along
with @file{tz.h}) as part of C++20.  This package regroups all header files
from the upstream repository so that other R packages can use them in their
C++ code.")
    (license license:gpl2+)))

(define-public r-rcppde
  (package
    (name "r-rcppde")
    (version "0.1.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppDE" version))
              (sha256
               (base32
                "07hrfvpkddc2yzs6bq52vmdymyry250pgizfxyb6mw47lcb7jjlf"))))
    (properties `((upstream-name . "RcppDE")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-deoptim r-lattice))
    (home-page "https://cran.r-project.org/package=RcppDE")
    (synopsis "Global optimization by differential evolution in C++")
    (description
     "This package provides an iteration of the @code{DEoptim} function.  It
performs global optimization by differential evolution.")
    (license license:gpl2+)))

(define-public r-rcppdist
  (package
    (name "r-rcppdist")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppDist" version))
       (sha256
        (base32 "02g57xwfipdcljv06krhm02dbqn9kfyj2km6rdg0a7vq9prwdz1x"))))
    (properties `((upstream-name . "RcppDist")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/duckmayr/RcppDist")
    (synopsis "Integration of additional probability distributions")
    (description
     "RcppDist provides a header-only C++ library with functions for
additional statistical distributions that can be called from C++ when writing
code using Rcpp or RcppArmadillo.  Functions are available that return a
@code{NumericVector} as well as doubles, and for multivariate or matrix
distributions, Armadillo vectors and matrices.")
    (license license:gpl2+)))

(define-public r-rcpphungarian
  (package
    (name "r-rcpphungarian")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppHungarian" version))
       (sha256
        (base32 "00wxi77ajnhwds1pnmhbxaykdaiyh6ayblif58sx9r5rvv055c1a"))))
    (properties `((upstream-name . "RcppHungarian")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/jsilve24/RcppHungarian")
    (synopsis "Solve minimum cost bipartite matching problems")
    (description
     "This package provides header library and R functions to solve minimum
cost bipartite matching problem using Huhn-Munkres algorithm (Hungarian
algorithm; <https://en.wikipedia.org/wiki/Hungarian_algorithm>; Kuhn (1955)
<doi:10.1002/nav.3800020109>).")
    (license license:gpl2+)))

(define-public r-rcppint64
  (package
    (name "r-rcppint64")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppInt64" version))
       (sha256
        (base32 "1h4lshkn3p3c7swygbpmkg0pa80xcp3f9alck5q4bmml61hicwjk"))))
    (properties `((upstream-name . "RcppInt64")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-tinytest))
    (home-page "https://github.com/eddelbuettel/rcppint64")
    (synopsis
     "Rcpp-based helper functions to pass Int64 values between R and C++")
    (description
     "@code{int64} values can be created and accessed via the @code{bit64}
package and its @code{integer64} class which package the @code{int64}
representation cleverly into a @code{double}.  The @code{nanotime} package
builds on this to support nanosecond-resolution timestamps.  This package
helps conversions between R and C++ via several helper functions provided via
a single header file.  A complete example client package is included as an
illustration.")
    (license license:gpl2+)))

(define-public r-rcppml
  (package
    (name "r-rcppml")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppML" version))
       (sha256
        (base32 "1ih8i7i6m221iw227mnl3rvnaw2l53h8fpnc4f8yn9sm10anap1j"))))
    (properties `((upstream-name . "RcppML")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           ;; It is unclear why these fail.
           (lambda _ (delete-file "tests/testthat/test_bipartition.R"))))))
    (propagated-inputs (list r-matrix r-rcpp r-rcppeigen))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/zdebruine/RcppML")
    (synopsis "Rcpp machine learning library")
    (description
     "This package provides fast machine learning algorithms including matrix
factorization and divisive clustering for large sparse and dense matrices.")
    (license license:gpl2+)))

(define-public r-rcppspdlog
  (package
    (name "r-rcppspdlog")
    (version "0.0.22")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppSpdlog" version))
       (sha256
        (base32 "0ihh0g0amq69ws166p85zszm9slhr5n7i124i7k92ay394r14wh7"))))
    (properties `((upstream-name . "RcppSpdlog")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-simplermarkdown))
    (home-page "https://github.com/eddelbuettel/rcppspdlog")
    (synopsis "R and C++ interfaces to spdlog C++ header library for logging")
    (description
     "The spdlog library is a widely-used and very capable header-only C++
library for logging.  This package includes its headers as an R package to
permit other R packages to deploy it via a simple @code{LinkingTo:
RcppSpdlog}.  As of version 0.0.9, it also provides both simple R logging
functions and compiled functions callable by other packages.")
    (license license:gpl2+)))

(define-public r-rcppthread
  (package
    (name "r-rcppthread")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppThread" version))
       (sha256
        (base32
         "0dwd0nlfy3c525y4yk5j6xaqj74hd146fmkqw8j9ky1z12p5p0s4"))))
    (properties `((upstream-name . "RcppThread")))
    (build-system r-build-system)
    ;; For unknown reasons r-r-rsp is not found when building vignettes.
    (arguments (list #:test-types '(list "tests")))
    (native-inputs (list r-r-rsp r-rcpp r-testthat))
    (home-page "https://github.com/tnagler/RcppThread")
    (synopsis "R threading in C++")
    (description
     "This package provides a C++11-style thread class and thread pool that can
safely be interrupted from R.")
    (license license:expat)))

(define-public r-rcppnumerical
  (package
    (name "r-rcppnumerical")
    (version "0.6-0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RcppNumerical" version))
              (sha256
               (base32
                "11nph9fz1bzb0pcvh6xx4cb94090ahwpj21zmbi06m4pibb1a1rg"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcppeigen))
    (native-inputs
     (list r-knitr r-rmarkdown))
    (home-page "https://github.com/yixuan/RcppNumerical")
    (synopsis"Numerical computing libraries integration with @code{Rcpp}")
    (description "This package provides a collection of libraries for numerical
computing (numerical integration, optimization, etc.) and their integration
with @code{Rcpp}.")
    (license license:gpl2+)))

(define-public r-rcppxptrutils
  (package
    (name "r-rcppxptrutils")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppXPtrUtils" version))
       (sha256
        (base32 "0hm57nf4dzgsmg4hjj6wikwjx93fgfwkmybw6ly4b58wi6qwml1l"))))
    (properties `((upstream-name . "RcppXPtrUtils")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/Enchufa2/RcppXPtrUtils")
    (synopsis "XPtr add-ons for Rcpp")
    (description
     "This package provides the means to compile user-supplied C++ functions
with Rcpp and retrieve an @code{XPtr} that can be passed to other C++
components.")
    (license license:expat)))

(define-public r-bb
  (package
    (name "r-bb")
    (version "2019.10-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BB" version))
       (sha256
        (base32 "0kf9sfsm3n036a8a8gjfpc9qdryvadb019kqjh80n1szdv7bdl04"))))
    (properties `((upstream-name . "BB")))
    (build-system r-build-system)
    ;; could not find function "latex"
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-quadprog))
    (native-inputs (list r-numderiv r-setrng))
    (home-page "https://publichealth.jhu.edu/")
    (synopsis "Solving and optimizing large-scale nonlinear systems")
    (description
     "This package implements Barzilai-Borwein spectral methods for solving
nonlinear system of equations, and for optimizing nonlinear objective
functions subject to simple constraints.")
    (license license:gpl3)))

(define-public r-bindr
  (package
    (name "r-bindr")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bindr" version))
       (sha256
        (base32
         "16161y28wg40pwlvmildcgcwn5wx6hiyk8r79sd0r31w31h6q7sj"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/krlmlr/bindr")
    (synopsis "Parametrized active bindings")
    (description
     "This package provides a simple interface for creating active bindings
where the bound function accepts additional arguments.")
    (license license:expat)))

(define-public r-bindrcpp
  (package
    (name "r-bindrcpp")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bindrcpp" version))
       (sha256
        (base32
         "1yn9is89r76ay314s216whr0igych4r78kjz85amhwgfb9wawbb6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bindr r-plogr r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/krlmlr/bindrcpp")
    (synopsis "Rcpp interface to active bindings")
    (description
     "This package provides an easy way to fill an environment with active
bindings that call a C++ function.")
    (license license:expat)))

(define-public r-auc
  (package
    (name "r-auc")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AUC" version))
       (sha256
        (base32
         "07xf47kypqbsg2mixmq6mnh4s89aqan9bgl6kfv6lbx8ajv2asw3"))))
    (properties `((upstream-name . "AUC")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/AUC")
    (synopsis "Compute the area under the curve of selected measures")
    (description
     "This package includes functions to compute the area under the curve of
selected measures: the area under the sensitivity curve (AUSEC), the area
under the specificity curve (AUSPC), the area under the accuracy
curve (AUACC), and the area under the receiver operating characteristic
curve (AUROC).  The curves can also be visualized.  Support for partial areas
is provided.")
    (license license:gpl2+)))

(define-public r-audio
  (package
    (name "r-audio")
    (version "0.1-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "audio" version))
       (sha256
        (base32 "0z719jxmfzmh6c885m1yixjzdsl1wy17s1sw2hp4ppz4bcrzclhh"))))
    (properties `((upstream-name . "audio")))
    (build-system r-build-system)
    (native-inputs (list pkg-config))
    (home-page "http://www.rforge.net/audio/")
    (synopsis "Audio interface for R")
    (description
     "This package provides interfaces to audio devices (mainly sample-based)
from R to allow recording and playback of audio.")
    (license license:expat)))

(define-public r-calibrate
  (package
    (name "r-calibrate")
    (version "1.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "calibrate" version))
       (sha256
        (base32 "19kgrnsyq67iqv1biyssqi30a6v2836ql20nabpy2m692ns0jfvi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/calibrate")
    (synopsis "Calibration of scatterplot and biplot axes")
    (description
     "This is a package for drawing calibrated scales with tick marks
on (non-orthogonal) variable vectors in scatterplots and biplots.")
    (license license:gpl2)))

(define-public r-calibrator
  (package
    (name "r-calibrator")
    (version "1.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "calibrator" version))
       (sha256
        (base32 "1m9g1pmnr6d9jkg5ab0l0cbqfj7kmx7sdmcdqdhn9ifyhhn7812y"))))
    (properties `((upstream-name . "calibrator")))
    (build-system r-build-system)
    (propagated-inputs (list r-cubature r-emulator r-mvtnorm))
    (home-page "https://github.com/RobinHankin/calibrator.git")
    (synopsis "Bayesian calibration of complex computer codes")
    (description
     "This package performs Bayesian calibration of computer models as per
Kennedy and O'Hagan 2001.  The package includes routines to find the
hyperparameters and parameters; see the help page for @code{stage1()} for a
worked example using the toy dataset.  A tutorial is provided in the
@file{calex.Rnw} vignette; and a suite of especially simple one dimensional
examples appears in @file{inst/doc/one.dim/}.")
    (license license:gpl2)))

(define-public r-shape
  (package
    (name "r-shape")
    (version "1.4.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shape" version))
       (sha256
        (base32
         "1912znpk85j8c01s4m2f7x8rcqwski8b5n7g70cczmkzk47vvya3"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/shape")
    (synopsis "Functions for plotting graphical shapes")
    (description
     "This package provides functions for plotting graphical shapes such as
ellipses, circles, cylinders, arrows, ...")
    (license license:gpl3+)))

(define-public r-globaloptions
  (package
    (name "r-globaloptions")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GlobalOptions" version))
       (sha256
        (base32 "0gkm77w6db9ajyncy1xdcivplap06a51zi99m009kylccschd2a7"))))
    (properties `((upstream-name . "GlobalOptions")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/jokergoo/GlobalOptions")
    (synopsis "Generate functions to get or set global options")
    (description
     "This package provides more controls on the option values such as
validation and filtering on the values, making options invisible or private.")
    (license license:gpl2+)))

(define-public r-circlize
  (package
    (name "r-circlize")
    (version "0.4.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "circlize" version))
       (sha256
        (base32
         "0rqbcmmp4h1jjl0y59bzn6k8kywjdqwvp0ajkqxd21j9f33k5p0n"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-colorspace r-globaloptions r-shape))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/jokergoo/circlize")
    (synopsis "Circular visualization")
    (description
     "Circular layout is an efficient way to visualise huge amounts of
information.  This package provides an implementation of circular layout
generation in R as well as an enhancement of available software.  Its
flexibility is based on the usage of low-level graphics functions such that
self-defined high-level graphics can be easily implemented by users for
specific purposes.  Together with the seamless connection between the powerful
computational and visual environment in R, it gives users more convenience and
freedom to design figures for better understanding complex patterns behind
multi-dimensional data.")
    (license license:gpl2+)))

(define-public r-rcircos
  (package
    (name "r-rcircos")
    (version "1.2.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RCircos" version))
              (sha256
               (base32
                "1z0aam60p1b6q7csn50rrwdilm07myr05bw54s9ah8idzyxc7gav"))))
    (properties `((upstream-name . "RCircos")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/RCircos/")
    (synopsis "Circos 2D track plot")
    (description
     "This package provides a simple and flexible way to generate Circos 2D
track plot images.  The types of plots include: heatmap, histogram, lines,
scatterplot, tiles and plot items for further decorations include connector,
link (lines and ribbons), and text (gene) label.  All functions require only R
graphics packages that comes with the base installation.")
    (license license:gpl2+)))

(define-public r-circstats
  (package
    (name "r-circstats")
    (version "0.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CircStats" version))
       (sha256
        (base32 "07bg4zrs2iqh0pmi44pybi8hlvnxwcaa5zpg85rmf55kflxxkzlf"))))
    (properties `((upstream-name . "CircStats")))
    (build-system r-build-system)
    (arguments
     (list
      #:tests? #f))
    (propagated-inputs (list r-boot r-mass))
    (home-page "https://cran.r-project.org/package=CircStats")
    (synopsis
     "Circular Statistics, from \"Topics in Circular Statistics\" (2001)")
    (description
     "Circular Statistics, from \"Topics in Circular Statistics\" (2001) S. Rao
Jammalamadaka and A. @code{SenGupta}, World Scientific.")
    (license license:gpl2)))

(define-public r-ctrdata
  (package
    (name "r-ctrdata")
    (version "1.22.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ctrdata" version))
              (sha256
               (base32
                "1hd83s3il732yfhizw0jdbiv2vqxk5famb86372giaw0q1fm75rz"))
              ;; TODO: we should also replace these other files:
              ;; inst/htmlwidgets/lib/jstree/dist/jstree.min.js
              ;; inst/js/bundle.js (generated from inst/js/euctr2ndjson.js)
              (snippet
               '(delete-file "inst/htmlwidgets/lib/jquery/dist/jquery.min.js"))))
    (properties `((upstream-name . "ctrdata")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils)
        (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/htmlwidgets/lib/jquery/dist"
                (for-each
                 (match-lambda
                   ((source . target)
                    (minify source #:target target)))
                 `((,(assoc-ref inputs "jquery-3.7.1.js")
                    . "jquery.min.js"))))))
          ;; Needed for vignettes
          (add-after 'unpack 'set-HOME
            (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-clipr
           r-countrycode
           r-curl
           r-digest
           r-dplyr
           r-htmlwidgets
           r-httr
           r-jqr
           r-jsonlite
           r-lubridate
           r-nodbi
           r-readr
           r-rlang
           r-stringdist
           r-stringi
           r-tibble
           r-tidyr
           r-v8
           r-xml2
           r-zip))
    (native-inputs
     (list esbuild
           r-knitr
           r-r-rsp
           r-tinytest
           (origin
             (method url-fetch)
             (uri "https://code.jquery.com/jquery-3.7.1.js")
             (sha256
              (base32
               "1zicjv44sx6n83vrkd2lwnlbf7qakzh3gcfjw0lhq48b5z55ma3q")))))
    (home-page "https://cran.r-project.org/package=ctrdata")
    (synopsis "Retrieve and analyze clinical trials in public registers")
    (description
     "This package provides a system for querying, retrieving and analyzing
protocol- and results-related information on clinical trials from three public
registers, the European Union Clinical Trials Register (EUCTR),
ClinicalTrials.gov (CTGOV) and the ISRCTN.  Trial information is downloaded,
converted and stored in a database.  Functions are included to identify
deduplicated records, to easily find and extract variables (fields) of
interest even from complex nesting as used by the registers, and to update
previous queries.  The package can be used for meta-analysis and
trend-analysis of the design and conduct as well as for results of clinical
trials.")
    (license license:expat)))

(define-public r-ctrialsgov
  (package
    (name "r-ctrialsgov")
    (version "0.2.5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ctrialsgov" version))
              (sha256
               (base32
                "0hdh1fdfaja8amf7fkvk1c6yif703132bvacq0j9pk5jr97czgpw"))))
    (properties `((upstream-name . "ctrialsgov")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dbi
           r-dplyr
           r-ggplot2
           r-htmlwidgets
           r-lubridate
           r-matrix
           r-plotly
           r-purrr
           r-rlang
           r-stringi
           r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=ctrialsgov")
    (synopsis
     "Query data from U.S. National Library of Medicine's Clinical Trials Database")
    (description
     "This package provides tools to query the U.S. National Library of
Medicine's Clinical Trials database.  Functions are provided for a variety of
techniques for searching the data using range queries, categorical filtering,
and by searching for full-text keywords.  Minimal graphical tools are also
provided for interactively exploring the constructed data.")
    (license license:expat)))

(define-public r-powerlaw
  (package
    (name "r-powerlaw")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "poweRlaw" version))
       (sha256
        (base32 "1pgwa8jw2886z1qj8iyi5wr8ydqinzka1j4pfbbg7vdgmdxq2yb4"))))
    (properties `((upstream-name . "poweRlaw")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pracma))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/csgillespie/poweRlaw")
    (synopsis "Tools for the analysis of heavy tailed distributions")
    (description
     "This package provides an implementation of maximum likelihood estimators
for a variety of heavy tailed distributions, including both the discrete and
continuous power law distributions.  Additionally, a goodness-of-fit based
approach is used to estimate the lower cut-off for the scaling region.")
    ;; Any of these GPL versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-ptw
  (package
    (name "r-ptw")
    (version "1.9-16")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ptw" version))
              (sha256
               (base32
                "0rma3h9ksc5qigdvk5vappb4ipd4rpk64wckzcxvxspakr5w71vy"))))
    (properties `((upstream-name . "ptw")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcppde))
    (home-page "https://github.com/rwehrens/ptw")
    (synopsis "Parametric time warping")
    (description
     "Parametric time warping aligns patterns.  It aims to put corresponding
features at the same locations.  The algorithm searches for an optimal
polynomial describing the warping.  It is possible to align one sample to a
reference, several samples to the same reference, or several samples to
several references.  One can choose between calculating individual warpings,
or one global warping for a set of samples and one reference.  Two
optimization criteria are implemented: @acronym{RMS, Root Mean Square} error
and @acronym{WCC, Weighted Cross Correlation}.  Both warping of peak profiles
and of peak lists are supported.")
    (license license:gpl2+)))

(define-public r-compare
  (package
    (name "r-compare")
    (version "0.2-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "compare" version))
       (sha256
        (base32
         "0k9zms930b5dz9gy8414li21wy0zg9x9vp7301v5cvyfi0g7xzgw"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/compare")
    (synopsis "Comparing objects for differences")
    (description
     "This package provides functions to compare a model object to a
comparison object.  If the objects are not identical, the functions can be
instructed to explore various modifications of the objects (e.g., sorting
rows, dropping names) to see if the modified versions are identical.")
    (license license:gpl2+)))

(define-public r-compoissonreg
  (package
    (name "r-compoissonreg")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "COMPoissonReg" version))
       (sha256
        (base32 "0a03v9b3mv214y2ky94z8y363x6b97a68kvypvan56m0mg0zzq3d"))))
    (properties `((upstream-name . "COMPoissonReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-numderiv r-rcpp))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/lotze/COMPoissonReg")
    (synopsis "Conway-Maxwell Poisson (COM-Poisson) regression")
    (description
     "Fit Conway-Maxwell Poisson (COM-Poisson or CMP) regression models to
count data (Sellers & Shmueli, 2010) <doi:10.1214/09-AOAS306>.  The package
provides functions for model estimation, dispersion testing, and diagnostics.
Zero-inflated CMP regression (Sellers & Raim, 2016)
<doi:10.1016/j.csda.2016.01.007> is also supported.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-dendextend
  (package
    (name "r-dendextend")
    (version "1.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dendextend" version))
       (sha256
        (base32
         "17nvk2gqyzgiwd62z2jw56rvlc14m1m5wx41xhc2p1wbl60s5njq"))))
    (properties
     ;; Ignore packages that have been removed from CRAN, or that would cause
     ;; a dependency cycle.
     '((updater-ignored-native-inputs
        . ("r-dendextendrcpp" "r-seriation" "r-table"))
       (updater-extra-native-inputs
        . ("r-circlize" "r-data-table"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; Needs package seriation, but adding it would lead to a
             ;; dependency cycle.
             (delete-file "tests/testthat/test-seriate_dendrogram.R")
             ;; XXX Test fails with: `best_entanglement` not identical to 0.
             (delete-file "tests/testthat/test-untangle.R")
             ;; XXX Test fails with: !opt$warn is not TRUE
             (delete-file "tests/testthat/test-zzz.R"))))))
    (propagated-inputs
     (list r-ggplot2 r-magrittr r-viridis))
    (native-inputs
     (list r-ape
           r-circlize
           r-cluster
           r-data-table
           r-fpc
           r-knitr
           r-pvclust
           r-testthat))
    (home-page "https://cran.r-project.org/web/packages/dendextend")
    (synopsis "Extending 'dendrogram' functionality in R")
    (description
     "This package offers a set of functions for extending @code{dendrogram}
objects in R, letting you visualize and compare trees of hierarchical
clusterings.  You can adjust a tree's graphical parameters (the color, size,
type, etc of its branches, nodes and labels) and visually and statistically
compare different dendrograms to one another.")
    ;; Any of these versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-dendsort
  (package
    (name "r-dendsort")
    (version "0.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dendsort" version))
       (sha256
        (base32 "0rs7y471wrhkgibxdmfh5xhp3pa004rrlm2w08b6qli5gq4im5d2"))))
    (properties `((upstream-name . "dendsort")))
    (build-system r-build-system)
    ;; Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/evanbiederstedt/dendsort")
    (synopsis "Modular leaf ordering methods for dendrogram nodes")
    (description
     "This package represents an implementation of functions to optimize
ordering of nodes in a dendrogram, without affecting the meaning of the
dendrogram.  A dendrogram can be sorted based on the average distance of
subtrees, or based on the smallest distance value.  These sorting methods
improve readability and interpretability of tree structure, especially for
tasks such as comparison of different distance measures or linkage types and
identification of tight clusters and outliers.  As a result, it also
introduces more meaningful reordering for a coupled heatmap visualization.")
    ;; Any of these versions
    (license (list license:gpl2 license:gpl3))))

(define-public r-getoptlong
  (package
    (name "r-getoptlong")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GetoptLong" version))
       (sha256
        (base32
         "00fpm6nd3kqa2ikasxa62jzywi46fvvmx1mdavcp5yrxxn37j8wc"))))
    (properties `((upstream-name . "GetoptLong")))
    (build-system r-build-system)
    (inputs
     (list perl))
    (propagated-inputs
     (list r-crayon r-globaloptions r-rjson))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/jokergoo/GetoptLong")
    (synopsis "Parsing command-line arguments and variable interpolation")
    (description
     "This is yet another command-line argument parser which wraps the
powerful Perl module @code{Getopt::Long} and with some adaptation for easier
use in R.  It also provides a simple way for variable interpolation in R.")
    (license license:gpl2+)))

(define-public r-fastmatch
  (package
    (name "r-fastmatch")
    (version "1.1-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fastmatch" version))
       (sha256
        (base32
         "0rjd9yk2v0q44j8f2y4chc0rlc20ay5zqgz185pxl6yz4vzlgc8h"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/fastmatch")
    (synopsis "Fast match function")
    (description
     "This package provides a fast @code{match} replacement for cases that
require repeated look-ups.  It is slightly faster that R's built-in
@code{match} function on first match against a table, but extremely fast on
any subsequent lookup as it keeps the hash table in memory.")
    (license license:gpl2)))

(define-public r-ff
  (package
    (name "r-ff")
    (version "4.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ff" version))
       (sha256
        (base32
         "0b1mqs98vqr67zxnf36vhzk9frd9ndq9ajsvv0z5zc67ziygal85"))))
    (build-system r-build-system)
    (propagated-inputs (list r-bit))
    (native-inputs (list r-testthat))
    (home-page "https://ff.r-forge.r-project.org/")
    (synopsis "Memory-efficient storage of large data on disk and access functions")
    (description
     "This package provides data structures that are stored on disk but
behave (almost) as if they were in RAM by transparently mapping only a section
in main memory.")
    ;; error Architecture not supported.
    (supported-systems (delete "aarch64-linux" %supported-systems))
    (license license:gpl2)))

(define-public r-ffbase
  (package
    (name "r-ffbase")
    (version "0.13.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ffbase" version))
       (sha256
        (base32
         "1dp6lblfq2j7r1b4b8ls47jlx8j27n88d5vp8w116lb8pa01zxmk"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; R 4.3.0 removed the typedef for Sint, which used to be just int.
         (add-after 'unpack 'r-compatibility
           (lambda _
             (substitute* '("src/grouprunningcumsum.c"
                            "src/grouprunningcumsumindex.c")
               (("\\bSint ") "int ")))))))
    (propagated-inputs
     (list r-bit r-fastmatch r-ff))
    (native-inputs (list r-laf r-testthat))
    (home-page "https://github.com/edwindj/ffbase")
    (synopsis "Basic statistical functions for package 'ff'")
    (description
     "This package extends the out of memory vectors of @code{ff} with
statistical functions and other utilities to ease their usage.")
    (license license:gpl3)))

(define-public r-prettyunits
  (package
    (name "r-prettyunits")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prettyunits" version))
       (sha256
        (base32
         "1smcxrfsz6cxym9h8iaiqrrw5bzp2bbpmf05zr8y70jw59zg4ngh"))))
    (properties
     `((updater-extra-native-inputs . ("r-codetools"))))
    (build-system r-build-system)
    (native-inputs (list r-codetools r-testthat))
    (home-page "https://github.com/gaborcsardi/prettyunits")
    (synopsis "Pretty, human readable formatting of quantities")
    (description
     "This package provides tools for pretty, human readable formatting of
quantities.")
    (license license:expat)))

(define-public r-princurve
  (package
   (name "r-princurve")
   (version "2.1.6")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "princurve" version))
            (sha256
             (base32
              "0wzk329bxljkzz57y220lsfckpsn45w348m6dcxh29zbj0ik65h2"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-rcpp))
   (native-inputs (list r-testthat))
   (home-page "https://github.com/rcannood/princurve")
   (synopsis "Fit a principal curve in arbitrary dimension")
   (description "This package provides procedures for fitting a principal
curve to a data matrix in arbitrary dimensions.")
   (license license:gpl2)))

(define-public r-prismatic
  (package
    (name "r-prismatic")
    (version "1.1.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prismatic" version))
              (sha256
               (base32
                "0qg2f5d7sz6q0ijrrdmjhp1msx9n77wndphrqqhjkdf9six5pgxs"))))
    (properties `((upstream-name . "prismatic")))
    (build-system r-build-system)
    (propagated-inputs (list r-farver))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/EmilHvitfeldt/prismatic")
    (synopsis "Color manipulation tools")
    (description
     "Manipulate and visualize colors in a intuitive, low-dependency and functional
way.")
    (license license:expat)))

(define-public r-reshape
  (package
    (name "r-reshape")
    (version "0.8.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reshape" version))
       (sha256
        (base32
         "0j203qmc076x5lp6q2xi4dq4xdb73jmsa42rpxp1c37knnrph4br"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr))
    (home-page "http://had.co.nz/reshape")
    (synopsis "Flexibly reshape data")
    (description
     "Flexibly restructure and aggregate data using just two functions:
@code{melt} and @code{cast}.  This package provides them.")
    (license license:expat)))

(define-public r-restrserve
  (package
    (name "r-restrserve")
    (version "1.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RestRserve" version))
       (sha256
        (base32 "13yl7638prglpqi4jq5vad5mw940k15b3n9svwmd92wmbh9ycsix"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-checkmate
           r-digest
           r-jsonlite
           r-mime
           r-r6
           r-rcpp
           r-rserve
           r-uuid))
    (native-inputs
     (list r-knitr r-tinytest))
    (home-page "https://restrserve.org")
    (synopsis "R web API framework")
    (description
     "RestRserve is an R web API framework for building high-performance AND
robust microservices and app backends.  With Rserve backend on UNIX-like
systems it is parallel by design.  It will handle incoming requests in
parallel - each request in a separate fork.")
    (license license:gpl2+)))

(define-public r-progress
  (package
    (name "r-progress")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "progress" version))
       (sha256
        (base32
         "0xljky4ad2jbbcfrcyh48li461pc5b2wk210n4x5rs2di6dhfaza"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon r-hms r-prettyunits r-r6))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gaborcsardi/progress")
    (synopsis "Terminal progress bars")
    (description
     "This package provides configurable progress bars.  They may include
percentage, elapsed time, and/or the estimated completion time.  They work in
terminals, in Emacs ESS, RStudio, Windows Rgui, and the macOS R.app.  The
package also provides a C++ API, that works with or without Rcpp.")
    (license license:expat)))

(define-public r-ggally
  (package
    (name "r-ggally")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GGally" version))
       (sha256
        (base32
         "1il6yphqxcyj1039imi8pn6ygyni24daz8ljxxp3z9inb5k2dcwb"))))
    (properties
     '((upstream-name . "GGally")
       (updater-extra-native-inputs
        . ("r-broom" "r-network" "r-scales" "r-sna"))))
    (build-system r-build-system)
    (inputs
     (list openssl))
    (propagated-inputs
     (list r-dplyr
           r-ggplot2
           r-ggstats
           r-gtable
           r-lifecycle
           r-magrittr
           r-plyr
           r-progress
           r-rcolorbrewer
           r-rlang
           r-scales
           r-tidyr))
    (native-inputs
     (list r-broom r-network r-scales r-sna r-survival r-testthat r-vdiffr))
    (home-page "https://ggobi.github.io/ggally")
    (synopsis "Extension to ggplot2")
    (description
     "The R package ggplot2 is a plotting system based on the grammar of
graphics.  GGally extends ggplot2 by adding several functions to reduce the
complexity of combining geometric objects with transformed data.  Some of
these functions include a pairwise plot matrix, a two group pairwise plot
matrix, a parallel coordinates plot, a survival plot, and several functions to
plot networks.")
    (license license:gpl2+)))

(define-public r-proxy
  (package
    (name "r-proxy")
    (version "0.4-27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "proxy" version))
       (sha256
        (base32
         "0gsng2aggnljl4z82la9hpnd26hngzhj8fizx4wx22npqjj93694"))))
    (build-system r-build-system)
    ;; Some tests need the r-cba package, which depends on r-proxy.
    (arguments (list #:tests? #false))
    (home-page "https://cran.r-project.org/web/packages/proxy")
    (synopsis "Distance and similarity measures")
    (description
     "This package provides an extensible framework for the efficient
calculation of auto- and cross-proximities, along with implementations of the
most popular ones.")
    (license license:gpl2)))

(define-public r-sp
  (package
    (name "r-sp")
    (version "2.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sp" version))
       (sha256
        (base32 "164b2il1g2bb91zfbh5dg7wglkhzxii9wqavxn5mdv3bm69yfyxm"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/sp")
    (synopsis "Classes and methods for spatial data")
    (description
     "This package provides classes and methods for spatial data; the classes
document where the spatial location information resides, for 2D or 3D data.
Utility functions are provided, e.g. for plotting data as maps, spatial
selection, as well as methods for retrieving coordinates, for subsetting,
print, summary, etc.")
    (license license:gpl2+)))

(define-public r-lambertw
  (package
    (name "r-lambertw")
    (version "0.6.9-1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "LambertW" version))
              (sha256
               (base32
                "19j6vjhywyzmrf7rsrx5kf0hg8cpk1gn8al24q813jzp0vsv9ljj"))))
    (properties `((upstream-name . "LambertW")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2
                             r-lamw
                             r-mass
                             r-rcolorbrewer
                             r-rcpp
                             r-reshape2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=LambertW")
    (synopsis
     "Probabilistic models to analyze and Gaussianize heavy-tailed, skewed data")
    (description
     "Lambert W x F distributions are a generalized framework to analyze skewed,
heavy-tailed data.  It is based on an input/output system, where the output
random variable (RV) Y is a non-linearly transformed version of an input RV X
~ F with similar properties as X, but slightly skewed (heavy-tailed).  The
transformed RV Y has a Lambert W x F distribution.  This package contains
functions to model and analyze skewed, heavy-tailed data the Lambert Way:
simulate random samples, estimate parameters, compute quantiles, and plot/
print results nicely.  The most useful function is @code{Gaussianize}, which
works similarly to @code{scale}, but actually makes the data Gaussian.  A
do-it-yourself toolkit allows users to define their own Lambert W x
@code{MyFavoriteDistribution} and use it in their analysis right away.")
    (license license:gpl2+)))

(define-public r-lamw
  (package
    (name "r-lamw")
    (version "2.2.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "lamW" version))
              (sha256
               (base32
                "1h1plx9d6kzgdv20sx7pjfkz54jw11pkqrspgw4hh1kgk6hpbgsz"))))
    (properties `((upstream-name . "lamW")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcppparallel))
    (home-page "https://github.com/aadler/lamW")
    (synopsis "Lambert-W function")
    (description
     "This package implements both real-valued branches of the Lambert-W
function (Corless et al, 1996) <doi:10.1007/BF02124750> without the need for
installing the entire GSL.")
    (license license:bsd-2)))

(define-public r-laplacesdemon
  (package
    (name "r-laplacesdemon")
    (version "16.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "LaplacesDemon" version))
       (sha256
        (base32 "1dsfp65cg06f25zjzd5ib4qyn1alfhbhpgyvpcw5n6bszn13idap"))))
    (properties `((upstream-name . "LaplacesDemon")))
    (build-system r-build-system)
    (home-page "https://github.com/LaplacesDemonR/LaplacesDemon")
    (synopsis "Complete environment for Bayesian inference")
    (description
     "This package provides a complete environment for Bayesian inference using
a variety of different samplers.")
    (license license:expat)))

(define-public r-rmapshaper
  (package
    (name "r-rmapshaper")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmapshaper" version))
       (sha256
        (base32 "01c1sd02ws3k2dmlj964c4j5jg93x192s3brhmaw4pi4qfjzc21x"))
       (snippet
        '(delete-file "inst/mapshaper/mapshaper-browserify.min.js"))))
    (properties `((upstream-name . "rmapshaper")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils)
        (ice-9 match))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/"
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         '(("mapshaper/mapshaper-browserify.js"
                            . "mapshaper/mapshaper-browserify.min.js")))))))))
    (propagated-inputs (list r-geojsonsf
                             r-jsonify
                             r-readr
                             r-sf
                             r-sp
                             r-v8))
    (native-inputs (list esbuild r-knitr r-testthat))
    (home-page "https://github.com/ateucher/rmapshaper")
    (synopsis "Client for mapshaper for geospatial operations")
    (description
     "This package lets you edit and simplify @code{geojson}, @code{Spatial},
and @code{sf} objects.  This is a wrapper around the @code{mapshaper}
JavaScript library to perform topologically-aware polygon simplification, as
well as other operations such as clipping, erasing, dissolving, and converting
multi-part to single-part geometries.")
    (license license:expat)))

(define-public r-rmariadb
  (package
    (name "r-rmariadb")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMariaDB" version))
       (sha256
        (base32 "157qkqv3a4p3dz4l0ah4h47wdsp8z8pm6magfgm63dg6xjsrkhgp"))))
    (properties
     `((upstream-name . "RMariaDB")
       (updater-extra-inputs . ("mariadb"))))
    (build-system r-build-system)
    (inputs (list `(,mariadb "lib") `(,mariadb "dev") openssl zlib))
    (native-inputs (list pkg-config r-dbitest r-testthat r-withr))
    (propagated-inputs (list r-bit64
                             r-blob
                             r-cpp11
                             r-dbi
                             r-hms
                             r-lubridate
                             r-plogr
                             r-rlang))
    (home-page "https://rmariadb.r-dbi.org")
    (synopsis "Database interface and MariaDB driver")
    (description
     "This package implements a DBI-compliant interface to @code{MariaDB} and
@code{MySQL} databases.")
    (license license:expat)))

(define-public r-rmdfiltr
  (package
    (name "r-rmdfiltr")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmdfiltr" version))
       (sha256
        (base32 "05czq9nvs66zd8wgmy5bvk0k1qfspf3imwxs25gn4d3w188klhnv"))))
    (properties `((upstream-name . "rmdfiltr")))
    (build-system r-build-system)
    (inputs (list pandoc))
    (propagated-inputs (list r-assertthat r-rmarkdown))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/crsh/rmdfiltr")
    (synopsis "Lua filters for R Markdown")
    (description
     "This package provides a collection of Lua filters that extend the
functionality of R Markdown templates (e.g., count words or post-process
citations).")
    (license license:expat)))

(define-public r-rmio
  (package
    (name "r-rmio")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmio" version))
       (sha256
        (base32 "1gkd8nkqyfpkp6nvqb7c698difak5ymih3vy6njzqd3gwdp09mhy"))))
    (properties `((upstream-name . "rmio")))
    (build-system r-build-system)
    (propagated-inputs (list r-bigassertr r-ff))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/privefl/rmio")
    (synopsis "Provides mio C++11 header files for R")
    (description
     "This package provides the header files of mio, a cross-platform C++11
header-only library for memory mapped file IO.")
    (license license:gpl3)))

(define-public r-rmtstat
  (package
    (name "r-rmtstat")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMTstat" version))
       (sha256
        (base32
         "1r1a2sdqv64m9cpm2pz6r8abf7l810126ayd8iq3gx86c7bjfj5v"))))
    (properties `((upstream-name . "RMTstat")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/RMTstat")
    (synopsis "Distributions, statistics and tests derived from random matrix theory")
    (description
     "This package provides functions for working with the Tracy-Widom laws
and other distributions related to the eigenvalues of large Wishart
matrices.")
    (license license:bsd-3)))

(define-public r-rmpi
  (package
    (name "r-rmpi")
    (version "0.7-3.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Rmpi" version))
              (sha256
               (base32
                "07izzlr1zxf25jrgwmi9384cqmg9hqsbh673zifzb4k0lvi0ikmw"))))
    (properties
     `((upstream-name . "Rmpi")
       (updater-extra-inputs . ("openmpi"))))
    (build-system r-build-system)
    (arguments
     (list
      #:configure-flags '(list "--configure-args=\"--with-Rmpi-type=OPENMPI\"")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'install 'mpi-setup
            #$%openmpi-setup))))
    (inputs
     (list openmpi))
    (native-inputs
     (list pkg-config))
    (home-page "http://www.stats.uwo.ca/faculty/yu/Rmpi")
    (synopsis "R interface to message-passing interface (MPI)")
    (description
     "This package provides an interface (wrapper) to MPI APIs.  It also
provides an interactive R manager and worker environment.")
    (license license:gpl2+)))

(define-public r-rmumps
  (package
    (name "r-rmumps")
    (version "5.2.1-35")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rmumps" version))
       (sha256
        (base32 "0ainsg7gh5jriwxrrq24njb9va57hl24h3nzlg8i0mqddw2ix9xx"))))
    (properties
     `((upstream-name . "rmumps")
       (updater-extra-inputs . ("zlib"))))
    (build-system r-build-system)
    (inputs (list zlib))
    (propagated-inputs (list r-rcpp))
    (native-inputs (list gfortran r-matrix r-slam r-testthat))
    (home-page "https://www.mumps-solver.org/")
    (synopsis "Wrapper for MUMPS library")
    (description
     "Some basic features of @acronym{MUMPS, Multifrontal Massively Parallel
sparse direct Solver} are wrapped in a class whose methods can be used for
sequentially solving a sparse linear system (symmetric or not) with one or
many right hand sides (dense or sparse).  There is a possibility to do
separately symbolic analysis, LU (or LDL^t) factorization and system solving.
Third part ordering libraries are included and can be used: PORD, METIS,
SCOTCH.")
    (license license:gpl2+)))

(define-public r-lmoments
  (package
    (name "r-lmoments")
    (version "1.3-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Lmoments" version))
       (sha256
        (base32
         "0pc63bj9a8hzr5m3yssrc4kin39fffwkl8rggs3sagzr12d4i7bw"))))
    (properties `((upstream-name . "Lmoments")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rcpparmadillo))
    (home-page "http://www.tilastotiede.fi/juha_karvanen.html")
    (synopsis "L-moments and quantile mixtures")
    (description
     "This package contains functions to estimate L-moments and trimmed
L-moments from the data.  It also contains functions to estimate the
parameters of the normal polynomial quantile mixture and the Cauchy polynomial
quantile mixture from L-moments and trimmed L-moments.")
    (license license:gpl2)))

(define-public r-distillery
  (package
    (name "r-distillery")
    (version "1.2-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "distillery" version))
       (sha256
        (base32
         "1rsxrq5j5zzk48r27l7ns7igcij9crwi001h002h2fjcai7m03cr"))))
    (build-system r-build-system)
    (home-page "https://ral.ucar.edu/staff/ericg/")
    (synopsis "Functions for confidence intervals and object information")
    (description
     "This package provides some very simple method functions for confidence
interval calculation and to distill pertinent information from a potentially
complex object; primarily used in common with the packages extRemes and
SpatialVx.")
    (license license:gpl2+)))

(define-public r-etrunct
  (package
   (name "r-etrunct")
   (version "0.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "etrunct" version))
            (sha256
             (base32
              "0ayazgyqlc8jcqr03cwfmfhm4pck6xri1r6vkgqy4arqkrrnrcqr"))))
   (properties `((upstream-name . "etrunct")))
   (build-system r-build-system)
   (native-inputs (list r-testthat))
   (home-page "https://cran.r-project.org/web/packages/etrunct")
   (synopsis "Computes moments of univariate truncated T distribution")
   (description "This package computes moments of univariate truncated
T distribution.  There is only one exported function, @code{e_trunct},
which should be seen for details.")
   (license license:expat)))

(define-public r-evd
  (package
    (name "r-evd")
    (version "2.3-7.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "evd" version))
       (sha256
        (base32 "0y0vd2q3bjq3kwm5qlya57ijkpdipwfpgv7xs1014gdm6g639l8s"))))
    (properties `((upstream-name . "evd")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=evd")
    (synopsis "Functions for extreme value distributions")
    (description
     "This package extends simulation, distribution, quantile and density
functions to univariate and multivariate parametric extreme value distributions,
and provides fitting functions which calculate maximum likelihood estimates for
univariate and bivariate maxima models, and for univariate and bivariate
threshold models.")
    (license license:gpl3)))

(define-public r-evmix
  (package
    (name "r-evmix")
    (version "2.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "evmix" version))
       (sha256
        (base32 "02rabc9snci00s1x7h0svfr66lmw1wjcdg0149wc52mnccsdaivf"))))
    (properties `((upstream-name . "evmix")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gsl
           r-mass
           r-sparsem))
    (home-page "http://www.math.canterbury.ac.nz/~c.scarrott/evmix.shtml")
    (synopsis
     "Extreme value threshold estimation and uncertainty quantification")
    (description
     "This package provides the usual distribution functions, maximum likelihood
inference and model diagnostics for univariate stationary extreme value mixture
models.  Also, there are provided kernel density estimation including various
boundary corrected kernel density estimation methods and a wide choice of kernels,
with cross-validation likelihood based bandwidth estimator.  Reasonable
consistency with the base functions in the evd package is provided, so that users
can safely interchange most code.")
    (license license:gpl3)))

;; This package contains minified JavaScript: jExcel CE Spreadsheet,
;; version 3.9.1.  It is not clear how to obtain this particular
;; version as there is no tag for 3.9.1.  There only is 3.6.1 and
;; 4.2.0 at https://github.com/jspreadsheet/ce.
(define-public r-excelr
  (package
    (name "r-excelr")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "excelR" version))
       (sha256
        (base32 "1pb4sy54zjv5vrh7gjjv7qlpab74km6mfsmfyl0yhmr0jx01hrw0"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/jexcel/js/jexcel.min.js"))))
    (properties `((upstream-name . "excelR")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/htmlwidgets/lib/jexcel/js"
                (minify (search-input-file inputs "/dist/jexcel.js")
                        #:target "jexcel.min.js")))))))
    (propagated-inputs (list r-htmlwidgets r-jsonlite))
    (native-inputs
     (list esbuild
           ;; There is no tag for this particular commit, but comparison of
           ;; the contents of the JavaScript files point to this commit as the
           ;; most likely source.
           (let* ((commit "8af1960f76e6803bebc5750013d2ebe95354e88a")
                  (version (git-version "3.9.1" "0" commit)))
             (origin
               (method git-fetch)
               (uri (git-reference
                     (url "https://github.com/jspreadsheet/ce")
                     (commit commit)))
               (file-name (git-file-name "jexcel" version))
               (sha256
                (base32
                 "1zk0wc4h0vax7zgimhwqq2icrvjr84agm3qv42l16gim7gq7fqfq"))))
           r-testthat))
    (home-page "https://github.com/Swechhya/excelR")
    (synopsis "Wrapper of the JavaScript library jExcel")
    (description
     "This package provides an R interface to the jExcel library to create
web-based interactive tables and spreadsheets compatible with spreadsheet
software.")
    (license license:expat)))

(define-public r-extremes
  (package
    (name "r-extremes")
    (version "2.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extRemes" version))
       (sha256
        (base32
         "0sg9cbhhqmg5flwwlqn0hnybz9mycf3rf5rzssgw8dvlc0mmv3r6"))))
    (properties `((upstream-name . "extRemes")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-distillery r-lmoments))
    (home-page "https://www.assessment.ucar.edu/toolkit/")
    (synopsis "Extreme value analysis")
    (description
     "ExtRemes is a suite of functions for carrying out analyses on the
extreme values of a process of interest; be they block maxima over long blocks
or excesses over a high threshold.")
    (license license:gpl2+)))

(define-public r-lmtest
  (package
    (name "r-lmtest")
    (version "0.9-40")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lmtest" version))
       (sha256
        (base32
         "15yr2kx08wy085bnziqmj1p6hf9mg3qp2a8465jk2df6di6hsh34"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/lmtest")
    (synopsis "Testing linear regression models")
    (description
     "This package provides a collection of tests, data sets, and examples for
diagnostic checking in linear regression models.  Furthermore, some generic
tools for inference in parametric models are provided.")
    ;; Either version is okay
    (license (list license:gpl2 license:gpl3))))

(define-public r-idr
  (package
    (name "r-idr")
    (version "1.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "idr" version))
              (sha256
               (base32
                "1r6icxf0c0y9wvihwmkk5xqscr1qhacqk3w2076kjm2993f10fbb"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/idr/")
    (synopsis "Irreproducible discovery rate")
    (description
     "This is a package for estimating the copula mixture model and plotting
correspondence curves in \"Measuring reproducibility of high-throughput
experiments\" (2011), Annals of Applied Statistics, Vol. 5, No. 3, 1752-1779,
by Li, Brown, Huang, and Bickel")
    (license license:gpl2+)))

(define-public r-imola
  (package
    (name "r-imola")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "imola" version))
       (sha256
        (base32 "087zdzn1vkyvqrdlwnackr6jyacrhg69q4b77s8z477kplickw8x"))))
    (properties `((upstream-name . "imola")))
    (build-system r-build-system)
    (propagated-inputs (list r-glue
                             r-htmltools
                             r-magrittr
                             r-shiny
                             r-stringi
                             r-yaml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/pedrocoutinhosilva/imola")
    (synopsis "CSS layouts (grid and flexbox) for R/Shiny")
    (description
     "This package allows users to create CSS grid and flexbox layouts for
R/Shiny without needing to write custom CSS.")
    (license license:expat)))

(define-public r-inext
  (package
    (name "r-inext")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "iNEXT" version))
       (sha256
        (base32 "1nf4jhwqx5im966qzq7si78c5q4jgsa73d74ya8q8aj02n49jcyy"))))
    (properties `((upstream-name . "iNEXT")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-rcpp r-reshape2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "http://chao.stat.nthu.edu.tw/wordpress/software_download/")
    (synopsis "Interpolation and extrapolation for species diversity")
    (description
     "This package provides simple functions to compute and plot two types
(sample-size- and coverage-based) rarefaction and extrapolation curves for
species diversity (Hill numbers) based on individual-based abundance data or
sampling-unit- based incidence data; see Chao and others (2014, Ecological
Monographs) for pertinent theory and methodologies, and Hsieh, Ma and Chao
(2016, Methods in Ecology and Evolution) for an introduction of the R
package.")
    (license license:gpl3+)))

(define-public r-inline
  (package
    (name "r-inline")
    (version "0.3.21")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "inline" version))
              (sha256
               (base32
                "165wg1iyqrcqxrm6k4jb8sdkfc99nrahx35w8sizcirsjc543yby"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/inline")
    (synopsis "Functions to inline C, C++, Fortran function calls from R")
    (description
     "This package provides functionality to dynamically define R functions
and S4 methods with inlined C, C++ or Fortran code supporting @code{.C} and
@code{.Call} calling conventions.")
    ;; Any version of the LGPL.
    (license license:lgpl3+)))

(define-public r-inum
  (package
    (name "r-inum")
    (version "1.0-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "inum" version))
              (sha256
               (base32
                "1gbbsffbzxjrgi8yw21fl35fsbx7ns8hdrhja50byfqvnghbg5p6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-libcoin))
    (home-page "https://cran.r-project.org/web/packages/inum/")
    (synopsis "Interval and enum-type representation of vectors")
    (description
     "This package provides an enum-type representation of vectors and
representation of intervals, including a method of coercing variables
in data frames.")
    (license license:gpl2)))
(define-public r-invgamma
  (package
   (name "r-invgamma")
   (version "1.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "invgamma" version))
            (sha256
             (base32
              "12ga2y4wc9bc5zz6vimvxwgjpsx3ys3209nq63gscbw559ydxa5a"))))
   (properties `((upstream-name . "invgamma")))
   (build-system r-build-system)
   (home-page "https://github.com/dkahle/invgamma")
   (synopsis "Inverse gamma distribution")
   (description "This package provides a light weight implementation of the
standard distribution functions for the inverse gamma distribution, wrapping
those for the gamma distribution in the @code{stats} package.")
   (license license:gpl2)))

(define-public r-bdsmatrix
  (package
    (name "r-bdsmatrix")
    (version "1.3-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bdsmatrix" version))
       (sha256
        (base32
         "08krrd7454ixqv4nq55hgf3djp1pz1vl3ndslsrh2pkdq1d5wl63"))))
    (properties `((upstream-name . "bdsmatrix")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/bdsmatrix/")
    (synopsis "Routines for block diagonal symmetric matrices")
    (description
     "This package provides procedures to work with block diagonal symmetric
matrices, a special case of sparse matrices.")
    (license license:lgpl2.0)))

(define-public r-bbmle
  (package
    (name "r-bbmle")
    (version "1.0.25.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bbmle" version))
       (sha256
        (base32
         "02xnfmjr5ax5pc69jkxmygkwvb68flrf1x8pxfw0hk7y37w0qanr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bdsmatrix
           r-lattice
           r-mass
           r-matrix
           r-mvtnorm
           r-numderiv))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/web/packages/bbmle")
    (synopsis "Tools for General Maximum Likelihood Estimation")
    (description
     "This package provides methods and functions for fitting maximum
likelihood models in R.  This package modifies and extends the @code{mle}
classes in the @code{stats4} package.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-emdbook
  (package
    (name "r-emdbook")
    (version "1.3.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "emdbook" version))
       (sha256
        (base32
         "069w10i1590bcyzv4kfsg7wsr1yl9nlsyj6yvys088xll5z4n116"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bbmle r-coda r-lattice r-mass r-plyr))
    (native-inputs (list r-testthat))
    (home-page "https://www.math.mcmaster.ca/bolker/emdbook")
    (synopsis "Support functions and data for \"Ecological Models and Data\"")
    (description
     "This package provides auxiliary functions and data sets for \"Ecological
Models and Data\", a book presenting maximum likelihood estimation and related
topics for ecologists (ISBN 978-0-691-12522-0).")
    ;; Any GPL version
    (license (list license:gpl2 license:gpl3))))

(define-public r-lpsolve
  (package
    (name "r-lpsolve")
    (version "5.6.23")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lpSolve" version))
       (sha256
        (base32
         "1mx25kas78w9jygxk56qpk0r20i8fss1zj69fh0y8mpjsc3rdhs6"))))
    (properties `((upstream-name . "lpSolve")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/lpSolve")
    (synopsis "R interface to Lp_solve to solve linear/integer programs")
    (description
     "Lp_solve is software for solving linear, integer and mixed integer
programs.  This implementation supplies a \"wrapper\" function in C and some R
functions that solve general linear/integer problems, assignment problems, and
transportation problems.")
    (license license:lgpl2.0)))

(define-public r-lpsolveapi
  (package
    (name "r-lpsolveapi")
    (version "5.5.2.0-17.14")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lpSolveAPI" version))
       (sha256
        (base32 "0kxxqiiwb1aqq7pk9kv1j7m7bjbyyqrf7jnrllag8najd735nh2n"))))
    (properties `((upstream-name . "lpSolveAPI")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=lpSolveAPI")
    (synopsis "Interface to lp_solve")
    (description
     "The lpSolveAPI package provides an R interface to lp_solve, a @acronym{MILP,
Mixed Integer Linear Programming}, solver with support for pure linear, (mixed)
integer/binary, semi-continuous and @acronym{SOS, special ordered sets} models.")
    (license license:lgpl2.0)))

(define-public r-limsolve
  (package
    (name "r-limsolve")
    (version "1.5.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "limSolve" version))
       (sha256
        (base32
         "1pdsvynqvx43dc0zlw9k2np3wdlr5pva8gl5b387wzglh5dyarx2"))))
    (properties `((upstream-name . "limSolve")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lpsolve r-mass r-quadprog))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/limSolve")
    (synopsis "Solving linear inverse models")
    (description
     "This package provides functions that:

@enumerate
@item find the minimum/maximum of a linear or quadratic function,
@item sample an underdetermined or overdetermined system,
@item solve a linear system Ax=B for the unknown x.
@end enumerate

It includes banded and tridiagonal linear systems.  The package calls Fortran
functions from LINPACK.")
    ;; Any GPL version.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-lintools
  (package
    (name "r-lintools")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lintools" version))
       (sha256
        (base32 "03sfx1w3kl7xk79bpw6hddk7xylh2w2fp9zsgbd50150xp49p1ah"))))
    (properties `((upstream-name . "lintools")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-tinytest))
    (home-page "https://github.com/data-cleaning/lintools")
    (synopsis "Manipulation of linear systems of (in)equalities")
    (description
     "This is a package for variable elimination (Gaussian elimination,
Fourier-Motzkin elimination), Moore-Penrose pseudoinverse, reduction to
reduced row echelon form, value substitution, projecting a vector on the
convex polytope described by a system of (in)equations, simplify systems by
removing spurious columns and rows and collapse implied equalities, test if a
matrix is totally unimodular, compute variable ranges implied by
linear (in)equalities.")
    (license license:gpl3)))

(define-public r-litedown
  (package
    (name "r-litedown")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "litedown" version))
       (sha256
        (base32 "0wdlplwiww0fb343ckmhikbk469fdwz8dj9vx0hx4sgjkmrb8b77"))))
    (properties `((upstream-name . "litedown")))
    (build-system r-build-system)
    ;; Building the vignettes requires internet access.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-commonmark r-xfun))
    (home-page "https://github.com/yihui/litedown")
    (synopsis "Lightweight version of R Markdown")
    (description
     "Render R Markdown to Markdown (without using @code{knitr}), and Markdown
to lightweight HTML or @code{LaTeX} documents with the @code{commonmark}
package (instead of Pandoc).  Some missing Markdown features in
@code{commonmark} are also supported, such as raw HTML or @code{LaTeX} blocks,
@code{LaTeX} math, superscripts, subscripts, footnotes, element attributes,
and appendices, but not all Pandoc Markdown features are (or will be)
supported.  With additional @code{JavaScript} and CSS, you can also create
HTML slides and articles.  This package can be viewed as a trimmed-down
version of R Markdown and @code{knitr}.  It does not aim at rich Markdown
features or a large variety of output formats (the primary formats are HTML
and @code{LaTeX}).  Book and website projects of multiple input documents are
also supported.")
    (license license:expat)))

(define-public r-littler
  (package
    (name "r-littler")
    (version "0.3.21")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "littler" version))
              (sha256
               (base32
                "11a0wrsrp0na5lwy33njskdgjlnzmm69aigqgb61xwvym6nfg2wy"))))
    (properties
     `((upstream-name . "littler")
       (updater-extra-inputs . ("icu4c" "libdeflate" "zlib"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-executable
            (lambda _
              (install-file "inst/bin/r"
                            (string-append #$output "/bin")))))))
    (inputs (list icu4c libdeflate zlib))
    (native-inputs
     (list r-simplermarkdown))
    (home-page "https://github.com/eddelbuettel/littler")
    (synopsis "R at the command-line via r")
    (description
     "This package provides a scripting and command-line front-end is provided
by r (aka littler) as a lightweight binary wrapper around the GNU R language
and environment for statistical computing and graphics.  While R can be used
in batch mode, the r binary adds full support for both shebang-style scripting
(i.e. using a hash-mark-exclamation-path expression as the first line in
scripts) as well as command-line use in standard pipelines.  In other words, r
provides the R language without the environment.")
    (license license:gpl2+)))

(define-public r-fitdistrplus
  (package
    (name "r-fitdistrplus")
    (version "1.2-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fitdistrplus" version))
       (sha256
        (base32
         "1ms5cisbv7k5kyn79hk13wr9dmf23lzria84w5z9h2d70zgn0hfp"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; Needs package GeneralizedHyperbolic
             (delete-file "tests/t-fitdist-customoptim.R")
             ;; Needs package rgenoud
             (delete-file "tests/t-fitdistcens.R"))))))
    (propagated-inputs
     (list r-mass r-rlang r-survival))
    (native-inputs
     (list r-actuar
           r-generalizedhyperbolic
           r-ggplot2
           r-knitr
           r-mc2d
           r-npsurv))
    (home-page "https://riskassessment.r-forge.r-project.org")
    (synopsis "Fitting a parametric distribution from data")
    (description
     "This package extends the @code{fitdistr} function of the MASS package
with several functions to help the fit of a parametric distribution to
non-censored or censored data.  Censored data may contain left-censored,
right-censored and interval-censored values, with several lower and upper
bounds.  In addition to @dfn{maximum likelihood estimation} (MLE), the package
provides moment matching (MME), quantile matching (QME) and maximum
goodness-of-fit estimation (MGE) methods (available only for non-censored
data).  Weighted versions of MLE, MME and QME are available.")
    (license license:gpl2+)))

(define-public r-energy
  (package
    (name "r-energy")
    (version "1.7-12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "energy" version))
       (sha256
        (base32
         "0wkggv423bz9awi3dnxpmf62hdgfn5qgcvw1k4pvcsjczaz288mc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-gsl r-rcpp))
    (home-page "https://cran.r-project.org/web/packages/energy")
    (synopsis "Multivariate inference via the energy of data")
    (description
     "This package provides e-statistics (energy) tests and statistics for
multivariate and univariate inference, including distance correlation,
one-sample, two-sample, and multi-sample tests for comparing multivariate
distributions, are implemented.  Measuring and testing multivariate
independence based on distance correlation, partial distance correlation,
multivariate goodness-of-fit tests, clustering based on energy distance,
testing for multivariate normality, distance components (disco) for
non-parametric analysis of structured data, and other energy
statistics/methods are implemented.")
    (license license:gpl2+)))

(define-public r-envstats
  (package
    (name "r-envstats")
    (version "3.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "EnvStats" version))
              (sha256
               (base32
                "00ndb0wfhc3mg15b8sjf6l93q7h9mx2hsv8x7n4xi4r14hrvhhy7"))))
    (properties `((upstream-name . "EnvStats")))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2 r-mass r-nortest))
    (home-page "https://github.com/alexkowa/EnvStats")
    (synopsis
     "Package for environmental statistics, including US EPA guidance")
    (description
     "This is a package for graphical and statistical analyses of
environmental data, with a focus on analyzing chemical concentrations and
physical parameters, usually in the context of mandated environmental
monitoring.  It provides major environmental statistical methods found in the
literature and regulatory guidance documents, with extensive help that
explains what these methods do, how to use them, and where to find them in the
literature.  It comes with numerous built-in data sets from regulatory
guidance documents and environmental statistics literature.  It includes
scripts reproducing analyses presented in the book \"EnvStats: An R Package
for Environmental Statistics\" (Millard, 2013, Springer, ISBN
978-1-4614-8455-4,
@url{https://link.springer.com/book/10.1007/978-1-4614-8456-1}).")
    (license license:gpl3+)))

(define-public r-suntools
  (package
    (name "r-suntools")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "suntools" version))
       (sha256
        (base32 "1j7xz3yxg1azvcshb6sp88diipjiq37895cbipxm0s22dhhx1bqv"))))
    (properties
     `((upstream-name . "suntools")
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (propagated-inputs (list r-sf))
    (native-inputs (list r-testthat tzdata-for-tests))
    (home-page "https://github.com/adokter/suntools/")
    (synopsis
     "Calculate sun position, sunrise, sunset, solar noon and twilight")
    (description
     "This package provides a set of convenient functions for calculating
sun-related information, including the sun's position (elevation and azimuth),
and the times of sunrise, sunset, solar noon, and twilight for any given
geographical location on Earth.  These calculations are based on equations
provided by the National Oceanic & Atmospheric Administration (NOAA) as
described in \"Astronomical Algorithms\" by Jean Meeus (1991).  A resource for
researchers and professionals working in fields such as climatology, biology,
and renewable energy.")
    (license license:gpl3+)))

(define-public r-suppdists
  (package
    (name "r-suppdists")
    (version "1.1-9.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SuppDists" version))
       (sha256
        (base32
         "09m9vsrzr8c5ird9avfscnib2rs12scbkmawj78vwhc8jj0hig3z"))))
    (properties `((upstream-name . "SuppDists")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/SuppDists")
    (synopsis "Supplementary distributions")
    (description
     "This package provides ten distributions supplementing those built into
R.  Inverse Gauss, Kruskal-Wallis, Kendall's Tau, Friedman's chi squared,
Spearman's rho, maximum F ratio, the Pearson product moment correlation
coefficient, Johnson distributions, normal scores and generalized
hypergeometric distributions.  In addition two random number generators of
George Marsaglia are included.")
    (license license:gpl2+)))

(define-public r-kknn
  (package
    (name "r-kknn")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kknn" version))
       (sha256
        (base32
         "0d3gljnj904j7cd0a8pffpgdlyg0kix7dj0kns8xdyf0d31dscjj"))))
    (properties `((upstream-name . "kknn")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-matrix))
    (home-page "https://github.com/KlausVigo/kknn")
    (synopsis "Weighted k-nearest neighbors")
    (description
     "This is a package providing tools for weighted k-Nearest neighbors for
classification, regression and clustering.")
    (license license:gpl2+)))

(define-public r-knitr
  (package
    (name "r-knitr")
    (version "1.50")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "knitr" version))
              (sha256
               (base32
                "0h9girrcwkswa786gy02hzpi539nrsrpqy3ap6a6qxmd4225wpqh"))))
    (properties
     ;; We can't have r-litedown among the inputs here to avoid a dependency
     ;; cycle.
     '((updater-ignored-native-inputs . ("r-litedown"))))
    (build-system r-build-system)
    ;; Tests need r-tibble, which needs r-knitr.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-evaluate r-highr r-xfun r-yaml))
    (home-page "https://yihui.org/knitr/")
    (synopsis "General-purpose package for dynamic report generation in R")
    (description
     "This package provides a general-purpose tool for dynamic report
generation in R using Literate Programming techniques.")
    ;; The code is released under any version of the GPL.  As it is used by
    ;; r-markdown which is available under GPLv2 only, we have chosen GPLv2+
    ;; here.
    (license license:gpl2+)))

(define-public r-knitrbootstrap
  (package
    (name "r-knitrbootstrap")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "knitrBootstrap" version))
       (sha256
        (base32
         "157mn2gm7djfiw1b55vdr2ylrmgxlpfg95bmm82ghv5g6vr26smd"))))
    (properties `((upstream-name . "knitrBootstrap")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-knitr r-markdown r-rmarkdown))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/jimhester/knitrBootstrap")
    (synopsis "Knitr bootstrap framework")
    (description
     "This package provides a framework to create Bootstrap 3 HTML reports
from knitr Rmarkdown.")
    (license license:expat)))

(define-public r-kit
  (package
    (name "r-kit")
    (version "0.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kit" version))
       (sha256
        (base32 "11sy1j6k20fxx7fbbdsaqzm9ax74m62534zqi6jafq643fnnzng6"))))
    (properties `((upstream-name . "kit")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=kit")
    (synopsis "Data manipulation functions implemented in C")
    (description
     "This package provides basic functions, implemented in C, for large data
manipulation.  Fast vectorised @code{ifelse()}/nested @code{if()/switch()}
functions, @code{psum()/pprod()} functions equivalent to @code{pmin()/pmax()}
plus others which are missing from base R.  Most of these functions are
callable at C level.")
    (license license:gpl3)))

(define-public r-kpmt
  (package
    (name "r-kpmt")
    (version "0.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "kpmt" version))
              (sha256
               (base32
                "15d26khc0v3kc1c7l1avqp48pfqmc6xj32029mv7myivr41ashk3"))))
    (properties `((upstream-name . "kpmt")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrixstats))
    (home-page "https://cran.r-project.org/package=kpmt")
    (synopsis "Known population median test")
    (description
     "This package provides functions that implement the known population
median test.")
    (license license:expat)))

(define-public r-ksamples
  (package
    (name "r-ksamples")
    (version "1.2-10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "kSamples" version))
       (sha256
        (base32
         "13ap5ggid3w3s3k5mzz1ir31j96hjg6msa2s1hcy66zv242wqrid"))))
    (properties `((upstream-name . "kSamples")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-suppdists))
    (home-page "https://cran.r-project.org/web/packages/kSamples")
    (synopsis "K-Sample rank tests and their combinations")
    (description
     "This package provides tools to compares k samples using the
Anderson-Darling test, Kruskal-Wallis type tests with different rank score
criteria, Steel's multiple comparison test, and the Jonckheere-Terpstra (JT)
test.  It computes asymptotic, simulated or (limited) exact P-values, all
valid under randomization, with or without ties, or conditionally under random
sampling from populations, given the observed tie pattern.  Except for Steel's
test and the JT test it also combines these tests across several blocks of
samples.")
    (license license:gpl2+)))

(define-public r-cvst
  (package
    (name "r-cvst")
    (version "0.2-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CVST" version))
       (sha256
        (base32
         "0bgk0d6w3dyhb5s30idnp6jpb3m8wf3b79wqlg127wwm0cird8pg"))))
    (properties `((upstream-name . "CVST")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernlab r-matrix))
    (home-page "https://cran.r-project.org/web/packages/CVST")
    (synopsis "Fast cross-validation via sequential testing")
    (description
     "This package implements the fast cross-validation via sequential
testing (CVST) procedure.  CVST is an improved cross-validation procedure
which uses non-parametric testing coupled with sequential analysis to
determine the best parameter set on linearly increasing subsets of the data.
Additionally to the CVST the package contains an implementation of the
ordinary k-fold cross-validation with a flexible and powerful set of helper
objects and methods to handle the overall model selection process.  The
implementations of the Cochran's Q test with permutations and the sequential
testing framework of Wald are generic and can therefore also be used in other
contexts.")
    (license license:gpl2+)))

(define-public r-cvxr
  (package
    (name "r-cvxr")
    (version "1.0-15")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "CVXR" version))
              (sha256
               (base32
                "13435gwqgdaw7xxxza5k9p10z2wjlw9x5d1znj03h44k6wm1jfy1"))))
    (properties `((upstream-name . "CVXR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bit64
           r-cli
           r-ecosolver
           r-gmp
           r-matrix
           r-osqp
           r-rcpp
           r-rcppeigen
           r-rmpfr
           r-scs))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cvxr.rbind.io")
    (synopsis "Disciplined convex optimization")
    (description
     "This package provides an object-oriented modeling language for
@dfn{disciplined convex programming} (DCP) as described in Fu,
Narasimhan, and Boyd (2020, <doi:10.18637/jss.v094.i14>).  It allows
the user to formulate convex optimization problems in a natural way
following mathematical convention and DCP rules.  The system analyzes
the problem, verifies its convexity, converts it into a canonical
form, and hands it off to an appropriate solver to obtain the
solution.  Interfaces to solvers on CRAN and elsewhere are provided.")
    (license license:asl2.0)))

(define-public r-squarem
  (package
    (name "r-squarem")
    (version "2021.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SQUAREM" version))
       (sha256
        (base32
         "0n1s32l9p4vdm3h5q6g43s0qbpzry08difsh0yay80wrla6f3rb6"))))
    (properties `((upstream-name . "SQUAREM")))
    (build-system r-build-system)
    (native-inputs (list r-setrng))
    (home-page "https://coah.jhu.edu/people/Faculty_personal_Pages/Varadhan.html")
    (synopsis "Squared Extrapolation Methods for Accelerating EM-Like Monotone Algorithms")
    (description
     "This package provides algorithms for accelerating the convergence of
slow, monotone sequences from smooth, contraction mapping such as the EM
algorithm.  It can be used to accelerate any smooth, linearly convergent
acceleration scheme.  A tutorial style introduction to this package is
available in a vignette.")
    (license license:gpl2+)))

(define-public r-progressr
  (package
    (name "r-progressr")
    (version "0.15.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "progressr" version))
       (sha256
        (base32 "09m4a21rwkm2g0z6m9di8vmammzzs391cn5ya00whps011wggn9h"))))
    (properties
     `((upstream-name . "progressr")
       ;; FIXME: these packages don't exist (yet?), but we also don't need
       ;; them for building or running tests.
       (updater-ignored-native-inputs . ("r-apply" "r-notifier"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-digest))
    (native-inputs (list r-beepr
                         r-dofuture
                         r-furrr
                         r-future
                         r-pbmcapply
                         r-plyr
                         r-progress
                         r-purrr
                         r-rstudioapi
                         r-shiny))
    (home-page "https://progressr.futureverse.org")
    (synopsis "Inclusive, unifying API for progress updates")
    (description
     "This package provides a minimal, unifying API for scripts and packages
to report progress updates from anywhere including when using parallel
processing.  The package is designed such that the developer can to focus on
what progress should be reported on without having to worry about how to
present it.  The end user has full control of how, where, and when to render
these progress updates.")
    (license license:gpl3+)))

(define-public r-lava
  (package
    (name "r-lava")
    (version "1.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "lava" version))
       (sha256
        (base32
         "10hkh96ms0c3jcwcdkqgficy2cx1qgz1kvq24b0ihgfhv946d7qq"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-future-apply
           r-numderiv
           r-progressr
           r-squarem
           r-survival))
    (native-inputs
     (list r-future
           r-geepack
           r-knitr
           r-lme4
           r-mass
           r-nlme
           r-polycor
           r-rmarkdown
           r-testthat))
    (home-page "https://github.com/kkholst/lava")
    (synopsis "Latent variable models")
    (description
     "This package provides tools for the estimation and simulation of latent
variable models.")
    (license license:gpl3)))

(define-public r-drat
  (package
    (name "r-drat")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drat" version))
       (sha256
        (base32 "1di28631gi890krazzvmfcpr2gv6gr83dzkn0rq2n2y0pmnkm2kf"))))
    (properties `((upstream-name . "drat")))
    (build-system r-build-system)
    (native-inputs (list r-simplermarkdown))
    (home-page "https://github.com/eddelbuettel/drat")
    (synopsis "Drat R archive template")
    (description
     "This package helps you with creation and use of R repositories via
helper functions to insert packages into a repository, and to add repository
information to the current R session.  Two primary types of repositories are
supported: gh-pages at GitHub, as well as local repositories on either the
same machine or a local network.  Drat is a recursive acronym: Drat R Archive
Template.")
    (license license:gpl2+)))

(define-public r-dreamerr
  (package
    (name "r-dreamerr")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dreamerr" version))
       (sha256
        (base32 "0y010ki78kvnm0mb9wmf1a3i6p3gh1kw1c33sd5d1j5s168602sr"))))
    (properties `((upstream-name . "dreamerr")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-stringmagic))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=dreamerr")
    (synopsis "Error handling made easy")
    (description
     "This package provides a set of tools to facilitate package development
and make R a more user-friendly place.  It is intended mostly for
developers (or anyone who writes/shares functions).  It provides a simple,
powerful and flexible way to check the arguments passed to functions.  The
developer can easily describe the type of argument needed.  If the user
provides a wrong argument, then an informative error message is prompted with
the requested type and the problem clearly stated--saving the user a lot of
time in debugging.")
    (license license:gpl3)))

(define-public r-drr
  (package
    (name "r-drr")
    (version "0.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "DRR" version))
       (sha256
        (base32
         "1y70si1gig4l7jx5jiqsqliyywfsvimkx53x3zh1lc3yj2j6bqwk"))))
    (properties `((upstream-name . "DRR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cvst r-kernlab r-matrix))
    (home-page "https://cran.r-project.org/web/packages/DRR")
    (synopsis "Dimensionality reduction via regression")
    (description
     "This package provides an implementation of dimensionality reduction via
regression using Kernel Ridge Regression.")
    (license license:gpl3)))

(define-public r-prodlim
  (package
    (name "r-prodlim")
    (version "2025.04.28")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prodlim" version))
       (sha256
        (base32
         "0fpw443s38893rh456cc3d3bf3p5388hq8fb3i7xazclxfd09dv2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table
           r-diagram
           r-ggplot2
           r-kernsmooth
           r-lava
           r-rcpp
           r-rlang
           r-survival))
    (home-page "https://cran.r-project.org/web/packages/prodlim")
    (synopsis "Product-limit estimation for censored event history analysis")
    (description
     "This package provides a fast and user-friendly implementation of
nonparametric estimators for censored event history (survival) analysis with
the Kaplan-Meier and Aalen-Johansen methods.")
    (license license:gpl2+)))

(define-public r-dimred
  (package
    (name "r-dimred")
    (version "0.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dimRed" version))
       (sha256
        (base32
         "1ivx02cqn5xgvbck7sdiapd4b32spc4h4fsn6n4js4c979fv8sxa"))))
    (properties `((upstream-name . "dimRed")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-drr r-magrittr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/gdkrmr/dimRed")
    (synopsis "Framework for dimensionality reduction")
    (description
     "This package provides a collection of dimensionality reduction
techniques from R packages and provides a common interface for calling the
methods.")
    (license license:gpl3)))

(define-public r-timechange
  (package
    (name "r-timechange")
    (version "0.3.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "timechange" version))
              (sha256
               (base32
                "1d26mr3avw6bpx786k223bnylzqr7z1h7rrjc38pi5db2iahnp6q"))))
    (properties `((upstream-name . "timechange")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; We need this for tests.
         (add-before 'check 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (propagated-inputs (list r-cpp11))
    (native-inputs (list r-testthat tzdata-for-tests))
    (home-page "https://github.com/vspinu/timechange/")
    (synopsis "Efficient manipulation of Date-Times")
    (description
     "This package provides efficient routines for manipulation of
date-time objects while accounting for time-zones and daylight saving
times.  The package includes utilities for updating of date-time
components (year, month, day etc.), modification of time-zones,
rounding of date-times, period addition and subtraction etc.  Parts of
the CCTZ source code, released under the Apache 2.0 License, are
included in this package.")
    (license license:gpl3)))

(define-public r-timedate
  (package
    (name "r-timedate")
    (version "4041.110")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "timeDate" version))
       (sha256
        (base32
         "1rvi1h7jm02vnsrk9mm0fldymf7zyjkv1id6xvn1iwgb5psz2syf"))))
    (properties `((upstream-name . "timeDate")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'set-TZDIR
           (lambda* (#:key inputs #:allow-other-keys)
             ;; Tests would fail without this.
             (setenv "TZDIR"
                     (search-input-directory inputs "share/zoneinfo")))))))
    (native-inputs (list r-runit tzdata-for-tests))
    (home-page "https://www.rmetrics.org")
    (synopsis "Chronological and calendar objects")
    (description
     "This package provides an environment for teaching \"Financial
Engineering and Computational Finance\" and for managing chronological and
calendar objects.")
    (license license:gpl2+)))

(define-public r-magic
  (package
    (name "r-magic")
    (version "1.6-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magic" version))
       (sha256
        (base32
         "0xkrrg5qk62pfqx0avijdjaljzslpwd0hv2m52qnqwrbx5xfqyfa"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind))
    (home-page "https://github.com/RobinHankin/magic.git")
    (synopsis "Create and investigate magic squares")
    (description
     "This package provides a collection of efficient, vectorized algorithms
for the creation and investigation of magic squares and hypercubes, including
a variety of functions for the manipulation and analysis of arbitrarily
dimensioned arrays.")
    (license license:gpl2)))

(define-public r-magicaxis
  (package
    (name "r-magicaxis")
    (version "2.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "magicaxis" version))
       (sha256
        (base32 "04wj0g345mlndd1s7v7klxldxlp293xdgjyrnfpzxckg59804j3d"))))
    (properties `((upstream-name . "magicaxis")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-celestial
           r-mapproj
           r-mass
           r-plotrix
           r-rann
           r-sm))
    (home-page "https://cran.r-project.org/package=magicaxis")
    (synopsis "Scientific plotting with minor-tick and log minor-tick support")
    (description
     "This package provides functions to make useful (and pretty) plots for
scientific plotting.  Additional plotting features are added for base plotting,
with particular emphasis on making attractive log axis plots.")
    (license license:gpl3)))

(define-public r-rmysql
  (package
    (name "r-rmysql")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RMySQL" version))
       (sha256
        (base32
         "049nd1f9h7rgci6b7h183rl5z7xgikq8l9xxkdhhbvrnybk7m3l6"))))
    (properties `((upstream-name . "RMySQL")))
    (build-system r-build-system)
    (inputs
     (list `(,mariadb "dev") zlib))
    (propagated-inputs
     (list r-dbi))
    (native-inputs (list pkg-config r-testthat))
    (home-page "https://github.com/r-dbi/RMySQL")
    (synopsis "Database interface and MySQL driver for R")
    (description
     "This package provides a DBI interface to MySQL / MariaDB.  The RMySQL
package contains an old implementation based on legacy code from S-PLUS which
is being phased out.  A modern MySQL client based on Rcpp is available from
the RMariaDB package.")
    (license license:gpl2)))

(define-public r-rpanglaodb
  (package
    (name "r-rpanglaodb")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rPanglaoDB" version))
       (sha256
        (base32 "1ykzih3idgp2yhbw4039hhhzv0nmrmn3wx2c4dxmgp5qzhrg42nf"))))
    (properties `((upstream-name . "rPanglaoDB")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-pbapply r-seurat r-xml r-xml2))
    (home-page "https://github.com/dosorio/rPanglaoDB/")
    (synopsis
     "Download and merge Single-Cell RNA-Seq data from the PanglaoDB database")
    (description
     "This R package downloads labeled single-cell RNA-seq data from PanglaoDB.
It merges the data into a Seurat object for streamlined analysis.")
    (license license:gpl3)))

(define-public r-rpmm
  (package
    (name "r-rpmm")
    (version "1.25")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "RPMM" version))
              (sha256
               (base32
                "1j48dh434wfhfzka0l21w6f73qlwfm70r9gdddhn504i2d5m4jph"))))
    (properties `((upstream-name . "RPMM")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://cran.r-project.org/package=RPMM")
    (synopsis "Recursively partitioned mixture model")
    (description
     "This package provides a recursively partitioned mixture model for Beta
and Gaussian mixtures.  This is a model-based clustering algorithm that
returns a hierarchy of classes, similar to hierarchical clustering, but also
similar to finite mixture models.")
    (license license:gpl2+)))

(define-public r-rpostgresql
  (package
    (name "r-rpostgresql")
    (version "0.7-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPostgreSQL" version))
       (sha256
        (base32
         "0g4ny3l6dl4grk99nvpm9fw3052f051bnz7h31hfacr5zrpsn5gj"))))
    (properties
     '((upstream-name . "RPostgreSQL")
       (updater-extra-inputs . ("postgresql"))
       (updater-ignored-inputs . ("openssl" "zlib"))))
    (build-system r-build-system)
    (inputs (list postgresql))
    (propagated-inputs (list r-dbi))
    (home-page "https://github.com/tomoakin/RPostgreSQL")
    (synopsis "R interface to the PostgreSQL database system")
    (description
     "This package provides a Database Interface (DBI) compliant driver for R
to access PostgreSQL database systems.")
    ;; The whole package is released under GPL version 2.  It includes code
    ;; under the PostgreSQL license.
    (license license:gpl2)))

(define-public r-rpostgres
  (package
    (name "r-rpostgres")
    (version "1.4.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RPostgres" version))
       (sha256
        (base32
         "19382zfy9mqxkw3iksmcsiknrffkxpr6c2pcykf96x9qxsd84v0c"))))
    (properties
     '((upstream-name . "RPostgres")
       (updater-extra-inputs . ("postgresql"))))
    (build-system r-build-system)
    (inputs (list openssl postgresql))
    (propagated-inputs
     (list r-bit64
           r-blob
           r-cpp11
           r-dbi
           r-hms
           r-lubridate
           r-plogr
           r-withr))
    (native-inputs
     (list pkg-config
           r-callr
           r-dbitest
           r-knitr
           r-rlang
           r-testthat))
    (home-page "https://rpostgres.r-dbi.org")
    (synopsis "Rcpp Interface to PostgreSQL")
    (description
     "This package provides a fully @code{DBI}-compliant @code{Rcpp}-backed
interface to @code{PostgreSQL}, a relational database.")
    (license license:gpl3)))

(define-public r-linprog
  (package
    (name "r-linprog")
    (version "0.9-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "linprog" version))
       (sha256
        (base32
         "1d34m2nyk7m6j2dci69bhy5mlw479xax1517j7f14pq7vhpsm9l1"))))
    (build-system r-build-system)
    (propagated-inputs (list r-lpsolve))
    (home-page "https://linprog.r-forge.r-project.org/")
    (synopsis "Linear programming and optimization")
    (description
     "This package can be used to solve Linear Programming / Linear
Optimization problems by using the simplex algorithm.")
    (license license:gpl2+)))

(define-public r-geojsonsf
  (package
    (name "r-geojsonsf")
    (version "2.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geojsonsf" version))
       (sha256
        (base32 "1la6zfzv14ascwds0bp67d7x3am0v14mylc4b2lyd0nrf93a2p17"))))
    (properties `((upstream-name . "geojsonsf")))
    (build-system r-build-system)
    (propagated-inputs (list r-geometries r-jsonify r-rapidjsonr r-rcpp
                             r-sfheaders))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/SymbolixAU/geojsonsf")
    (synopsis "GeoJSON to Simple Feature converter")
    (description "This package converts between @code{GeoJSON} and Simple
Feature objects.")
    (license license:expat)))

(define-public r-geometries
  (package
    (name "r-geometries")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geometries" version))
       (sha256
        (base32 "040ljxmzbjdr76p81ygnn5y0gzckz5k2arxkih5m5f3b6g62laf6"))))
    (properties `((upstream-name . "geometries")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://dcooley.github.io/geometries/")
    (synopsis "Convert between R objects and geometric structures")
    (description
     "Geometry shapes in R are typically represented by matrices (points,
lines), with more complex shapes being lists of matrices (polygons).
Geometries will convert various R objects into these shapes.  Conversion
functions are available at both the R level, and through Rcpp.")
    (license license:expat)))

(define-public r-geometry
  (package
    (name "r-geometry")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "geometry" version))
       (sha256
        (base32
         "19a6kgnq01s80pca9289lwdgvwg0h3dlv7fr1shi4cd8mlbiwfn8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-linprog r-lpsolve r-magic r-rcpp r-rcppprogress))
    (native-inputs (list r-spelling r-testthat))
    (home-page "https://geometry.r-forge.r-project.org/")
    (synopsis "Mesh generator and surface tessellator")
    (description
     "This package makes the qhull library available in R, in a similar manner
as in Octave.  Qhull computes convex hulls, Delaunay triangulations, halfspace
intersections about a point, Voronoi diagrams, furthest-site Delaunay
triangulations, and furthest-site Voronoi diagrams.  It runs in 2-d, 3-d, 4-d,
and higher dimensions.  It implements the Quickhull algorithm for computing
the convex hull.  Qhull does not support constrained Delaunay triangulations,
or mesh generation of non-convex objects, but the package does include some R
functions that allow for this.  Currently the package only gives access to
Delaunay triangulation and convex hull computation.")
    ;; The Qhull sources are included and are distributed under a custom
    ;; non-copyleft license.  The R sources are released under GPL version 2.
    (license (list license:gpl2
                   (license:non-copyleft "http://www.qhull.org/COPYING.txt")))))

(define-public r-ddalpha
  (package
    (name "r-ddalpha")
    (version "1.3.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ddalpha" version))
       (sha256
        (base32
         "1139a50ili4w04034fmpxsbn2j17nx1ns5f07cijgqpskxjgi41r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-bh
           r-class
           r-geometry
           r-mass
           r-rcpp
           r-robustbase
           r-sfsmisc))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ddalpha")
    (synopsis "Depth-Based classification and calculation of data depth")
    (description
     "This package contains procedures for depth-based supervised learning,
which are entirely non-parametric, in particular the DDalpha-procedure (Lange,
Mosler and Mozharovskyi, 2014).  The training data sample is transformed by a
statistical depth function to a compact low-dimensional space, where the final
classification is done.  It also offers an extension to functional data and
routines for calculating certain notions of statistical depth functions.  50
multivariate and 5 functional classification problems are included.")
    (license license:gpl2)))

(define-public r-gower
  (package
    (name "r-gower")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gower" version))
       (sha256
        (base32
         "0lap31w6y82z65r5byfpijgrn31lh42ssiwncbakn4r60fjnkmag"))))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/gower")
    (synopsis "Gower's distance")
    (description
     "This package provides tools to compute Gower's distance (or similarity)
coefficient between records, and to compute the top-n matches between records.
Core algorithms are executed in parallel on systems supporting OpenMP.")
    (license license:gpl3)))

(define-public r-rcpproll
  (package
    (name "r-rcpproll")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RcppRoll" version))
       (sha256
        (base32
         "1prnc3svhc2v1w97vbdzfyxh545zx2h0p9d1q4753f7ynrwdkxfj"))))
    (properties `((upstream-name . "RcppRoll")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/RcppRoll")
    (synopsis "Efficient rolling and windowed operations")
    (description
     "This package provides fast and efficient routines for common rolling /
windowed operations.  Routines for the efficient computation of windowed mean,
median, sum, product, minimum, maximum, standard deviation and variance are
provided.")
    (license license:gpl2+)))

(define-public r-ipred
  (package
    (name "r-ipred")
    (version "0.9-15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ipred" version))
       (sha256
        (base32
         "0jzfq06l2vxyjy46sjgqyk6l4pp06kx3w5j39hzjy9i127hjsxd4"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-class
           r-mass
           r-nnet
           r-prodlim
           r-rpart
           r-survival))
    (native-inputs (list r-mlbench r-th-data))
    (home-page "https://cran.r-project.org/web/packages/ipred")
    (synopsis "Improved predictors")
    (description
     "This package provides improved predictive models by indirect
classification and bagging for classification, regression and survival
problems as well as resampling based estimators of prediction error.")
    (license license:gpl2+)))

(define-public r-psych
  (package
    (name "r-psych")
    (version "2.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psych" version))
       (sha256
        (base32
         "1glgpbsf83b9ibj4rbxhz433634jhfx7jh4r0czfzf76w92vr76x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gparotation r-lattice r-mnormt r-nlme))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/psych/")
    (synopsis "Procedures for psychological, psychometric, and personality research")
    (description
     "This package provides a general purpose toolbox for personality,
psychometric theory and experimental psychology.  Functions are primarily for
multivariate analysis and scale construction using factor analysis, principal
component analysis, cluster analysis and reliability analysis, although others
provide basic descriptive statistics.  Item Response Theory is done using
factor analysis of tetrachoric and polychoric correlations.  Functions for
analyzing data at multiple levels include within and between group statistics,
including correlations and factor analysis.  Functions for simulating and
testing particular item and test structures are included.  Several functions
serve as a useful front end for structural equation modeling.  Graphical
displays of path diagrams, factor analysis and structural equation models are
created using basic graphics.")
    (license license:gpl2+)))

(define-public r-psychotools
  (package
    (name "r-psychotools")
    (version "0.7-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psychotools" version))
       (sha256
        (base32 "197hym0fxfsyg6kf0pf9g5wbsa1kkicd4lqrxfy2g3c7aczad9zy"))))
    (properties `((upstream-name . "psychotools")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=psychotools")
    (synopsis "Psychometric modeling infrastructure")
    (description
     "This package provides infrastructure for psychometric modeling such as
data classes (for item response data and paired comparisons), basic model
fitting functions (for Bradley-Terry, Rasch, parametric logistic IRT,
generalized partial credit, rating scale, multinomial processing tree models),
extractor functions for different types of parameters (item, person,
threshold, discrimination, guessing, upper asymptotes), unified inference and
visualizations, and various datasets for illustration.  It is intended as a
common lightweight and efficient toolbox for psychometric modeling and a
common building block for fitting psychometric mixture models in package
@code{psychomix} and trees based on psychometric models in package
@code{psychotree}.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-psychotree
  (package
    (name "r-psychotree")
    (version "0.16-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "psychotree" version))
       (sha256
        (base32 "04ipl6kadfvyl28wx8jbpisb4pcswrwq1qiqm90h47ldbnmha932"))))
    (properties `((upstream-name . "psychotree")))
    (build-system r-build-system)
    (propagated-inputs (list r-formula r-partykit r-psychotools))
    (home-page "https://cran.r-project.org/package=psychotree")
    (synopsis "Recursive Partitioning Based on Psychometric Models")
    (description
     "Recursive partitioning based on psychometric models, employing the general MOB
algorithm (from package partykit) to obtain Bradley-Terry trees, Rasch trees,
rating scale and partial credit trees, and MPT trees, trees for 1PL, 2PL, 3PL
and 4PL models and generalized partial credit models.")
    (license (list license:gpl2 license:gpl3))))

(define-public r-generalizedhyperbolic
  (package
    (name "r-generalizedhyperbolic")
    (version "0.8-7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GeneralizedHyperbolic" version))
       (sha256
        (base32 "08z4jz9lzyc0afvxqw6m2p9h54lqk6hn1a8mva5lrddxlxf04qbv"))))
    (properties `((upstream-name . "GeneralizedHyperbolic")))
    (build-system r-build-system)
    (propagated-inputs (list r-distributionutils r-mass))
    (home-page "https://r-forge.r-project.org/projects/rmetrics/")
    (synopsis "Generalized hyperbolic distribution")
    (description
     "This package provides functions for the hyperbolic and related
distributions.  Density, distribution and quantile functions and random number
generation are provided for the hyperbolic distribution, the generalized
hyperbolic distribution, the generalized inverse Gaussian distribution and the
skew-Laplace distribution.  Additional functionality is provided for the
hyperbolic distribution, normal inverse Gaussian distribution and generalized
inverse Gaussian distribution, including fitting of these distributions to
data.  Linear models with hyperbolic errors may be fitted using
@code{hyperblmFit}.")
    (license license:gpl2+)))

(define-public r-generics
  (package
    (name "r-generics")
    (version "0.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "generics" version))
       (sha256
        (base32
         "0088il4adipaicxy65shbvm6cnxry6576xz6nz1qzlwjfw4mmsdv"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/r-lib/generics")
    (synopsis "Common S3 generics not provided by base R methods")
    (description
     "In order to reduce potential package dependencies and conflicts,
generics provides a number of commonly used S3 generics that are not provided
by base R methods related to model fitting.")
    (license license:gpl2)))

(define-public r-broom
  (package
    (name "r-broom")
    (version "1.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "broom" version))
       (sha256
        (base32
         "0i4b80vs29b064930qvlhfxpkx3a49kvf4r0psnsknyayr18asfl"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports
           r-cli
           r-dplyr
           r-generics
           r-glue
           r-lifecycle
           r-purrr
           r-rlang
           r-stringr
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/tidyverse/broom")
    (synopsis "Convert statistical analysis objects into tidy data frames")
    (description
     "This package provides tools to convert statistical analysis objects from
R into tidy data frames, so that they can more easily be combined, reshaped
and otherwise processed with tools like @code{dplyr}, @code{tidyr} and
@code{ggplot2}.  The package provides three S3 generics: @code{tidy}, which
summarizes a model's statistical findings such as coefficients of a
regression; @code{augment}, which adds columns to the original data such as
predictions, residuals and cluster assignments; and @code{glance}, which
provides a one-row summary of model-level statistics.")
    (license license:expat)))

(define-public r-recipes
  (package
    (name "r-recipes")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "recipes" version))
       (sha256
        (base32
         "1i6wk6yhdmhm37vihyh1r3s1nxhihwacmhlj4yaygsfdzyqnzfnf"))))
    (properties
     ;; Avoid dependency cycle as r-workflows depends on r-recipes.  r-disp is
     ;; not packaged, but we don't seem to need it.
     '((updater-ignored-native-inputs . ("r-disp" "r-workflows"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-clock
           r-dplyr
           r-generics
           r-glue
           r-gower
           r-hardhat
           r-ipred
           r-lifecycle
           r-lubridate
           r-magrittr
           r-matrix
           r-purrr
           r-rlang
           r-sparsevctrs
           r-tibble
           r-tidyr
           r-tidyselect
           r-timedate
           r-vctrs
           r-withr))
    (native-inputs
     (list r-ddalpha
           r-dials
           r-kernlab
           r-knitr
           r-modeldata
           r-parsnip
           r-rpart
           r-rsample
           r-splines2
           r-testthat))
    (home-page "https://github.com/topepo/recipes")
    (synopsis "Preprocessing tools to create design matrices")
    (description
     "Recipes is an extensible framework to create and preprocess design
matrices.  Recipes consist of one or more data manipulation and analysis
\"steps\".  Statistical parameters for the steps can be estimated from an
initial data set and then applied to other data sets.  The resulting design
matrices can then be used as inputs into statistical or machine learning
models.")
    (license license:gpl2)))

(define-public r-pdist
  (package
    (name "r-pdist")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pdist" version))
       (sha256
        (base32
         "0bvg8si81hs79v39d7svv4zbv2p0sk2r6m9vamibvkh9qvl4x406"))))
    (build-system r-build-system)
    (home-page "https://github.com/jeffwong/pdist")
    (synopsis "Partitioned distance function")
    (description
     "Pdist computes the euclidean distance between rows of a matrix X and
rows of another matrix Y.  Previously, this could be done by binding the two
matrices together and calling @code{dist}, but this creates unnecessary
computation by computing the distances between a row of X and another row of
X, and likewise for Y.  Pdist strictly computes distances across the two
matrices, not within the same matrix, making computations significantly faster
for certain use cases.")
    (license license:gpl3+)))

(define-public r-ggrepel
  (package
    (name "r-ggrepel")
    (version "0.9.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggrepel" version))
       (sha256
        (base32
         "04kj9qzcws6wfw9pf3s6w4phpqywyv6j617l7907plkpcgd6x2i6"))))
    (build-system r-build-system)
    (properties
     '((updater-extra-native-inputs . ("v-diffr"))))
    (propagated-inputs
     (list r-ggplot2 r-rcpp r-rlang r-scales r-withr))
    (native-inputs
     (list r-knitr r-testthat r-vdiffr))
    (home-page "https://github.com/slowkow/ggrepel")
    (synopsis "Repulsive text and label geometries for ggplot2")
    (description
     "This package provides text and label geometries for ggplot2 that help to
avoid overlapping text labels.  Labels repel away from each other and away
from the data points.")
    (license license:gpl3)))

(define-public r-coro
  (package
    (name "r-coro")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "coro" version))
       (sha256
        (base32 "1kvaf5484s6dn6zm4nw0ns6fi09lcqnljb51w4fdgsm80s04k6kc"))))
    (properties
     '((upstream-name . "coro")
       (updater-extra-native-inputs . ("r-later" "r-promises"))))
    (build-system r-build-system)
    (propagated-inputs (list r-rlang))
    (native-inputs (list r-knitr r-later r-promises r-testthat))
    (home-page "https://github.com/r-lib/coro")
    (synopsis "Coroutines for R")
    (description
     "This package provides coroutines for R, a family of functions that can
be suspended and resumed later on.  This includes async functions (which
await) and generators (which yield).  Async functions are based on the
concurrency framework of the @code{promises} package.  Generators are based on
a dependency free iteration protocol defined in @code{coro} and are compatible
with iterators from the @code{reticulate} package.")
    (license license:expat)))

(define-public r-corrplot
  (package
    (name "r-corrplot")
    (version "0.95")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "corrplot" version))
       (sha256
        (base32
         "0xnpi4cqclsikd00mjn0qb611g1a619hfr2d3ch8kra1a1kiz8w4"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/taiyun/corrplot")
    (synopsis "Visualization of a correlation matrix")
    (description
     "This package provides a graphical display of a correlation matrix or
general matrix.  It also contains some algorithms to do matrix reordering.  In
addition, corrplot is good at details, including choosing color, text labels,
color labels, layout, etc.")
    ;; Any version of the GPL
    (license license:gpl2+)))

(define-public r-stable
  (package
    (name "r-stable")
    (version "1.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "stable" version))
              (sha256
               (base32
                "194xsa291v5f0jya1c3aigbclg8cci427ffpb8brxamm6n57hf12"))))
    (properties `((upstream-name . "stable")))
    (build-system r-build-system)
    (propagated-inputs (list r-rmutil))
    (home-page "https://www.commanster.eu/rcode.html")
    (synopsis
     "Probability functions and regression models for stable distributions")
    (description
     "This package provides density, distribution, quantile and hazard
functions of a stable variate, as well as generalized regression models for
the parameters of a stable distribution.")
    (license license:gpl2+)))

(define-public r-stabm
  (package
    (name "r-stabm")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabm" version))
       (sha256
        (base32 "1vslidq2pzpwhsrsklghaqsdjjf4w4wqs2dng0p68zhrv5vlivhq"))))
    (properties
     '((upstream-name . "stabm")
       (updater-extra-native-inputs
        . ("r-cowplot" "r-ggdendro" "r-ggplot2" "r-igraph"))))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate r-matrix))
    (native-inputs (list r-cowplot
                         r-ggdendro
                         r-ggplot2
                         r-igraph
                         r-knitr r-testthat))
    (home-page "https://bommert.github.io/stabm/")
    (synopsis "Stability measures for feature selection")
    (description
     "This package provides an implementation of many measures for the
assessment of the stability of feature selection.  Both simple measures and
measures which take into account the similarities between features are
available.")
    (license license:lgpl3)))

(define-public r-statip
  (package
    (name "r-statip")
    (version "0.2.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "statip" version))
              (sha256
               (base32
                "0kymc3ds1nx0h11ffmm3vmqr1w34gd0k788vf72x2v45h8c1ma2n"))))
    (properties `((upstream-name . "statip")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-clue r-rpart))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/paulponcet/statip")
    (synopsis "Statistical functions for probability distributions and regression")
    (description
     "This package provides a collection of miscellaneous statistical
functions for:
@itemize
@item probability distributions,
@item probability density estimation,
@item most frequent value estimation,
@item other statistical measures of location,
@item construction of histograms,
@item calculation of the Hellinger distance,
@item use of classical kernels, and
@item univariate piecewise-constant regression.
@end itemize")
    (license license:gpl3)))

(define-public r-statsexpressions
  (package
    (name "r-statsexpressions")
    (version "1.7.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "statsExpressions" version))
              (sha256
               (base32
                "06znshf4wlg4ffqywabxrramii919zbywapn5b5wx1mdwayxkf51"))))
    (properties `((upstream-name . "statsExpressions")))
    (build-system r-build-system)
    (propagated-inputs (list r-afex
                             r-bayesfactor
                             r-bayestestr
                             r-correlation
                             r-datawizard
                             r-dplyr
                             r-effectsize
                             r-glue
                             r-insight
                             r-magrittr
                             r-parameters
                             r-performance
                             r-pmcmrplus
                             r-purrr
                             r-rlang
                             r-rstantools
                             r-tidyr
                             r-withr
                             r-wrs2
                             r-zeallot))
    (native-inputs (list r-datapasta
                         r-ggplot2
                         r-knitr
                         r-patrick
                         r-survival
                         r-testthat))
    (home-page "https://indrajeetpatil.github.io/statsExpressions/")
    (synopsis "Dataframes and expressions with statistical details")
    (description
     "This package provides tools for creating detailed dataframes for common
statistical approaches and tests.  These include parametric, nonparametric,
robust, and Bayesian t-test, one-way ANOVA, correlation analyses, contingency
table analyses, and meta-analyses.  The functions are pipe-friendly and
provide a consistent syntax to work with tidy data.  These dataframes
additionally contain expressions with statistical details, and can be used in
graphing packages.  This package also forms the statistical processing backend
for ggstatsplot.")
    (license license:gpl3)))

(define-public r-stddiff
  (package
    (name "r-stddiff")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stddiff" version))
       (sha256
        (base32 "1lirfxqiq59vhjkq1zv27ycybbs9n62c14klkkcf74j15a54cmbn"))))
    (properties `((upstream-name . "stddiff")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=stddiff")
    (synopsis
     "Calculate standardized difference for numeric, binary and category variables")
    (description
     "This package contains three main functions including
@code{stddiff.numeric()}, @code{stddiff.binary()} and
@code{stddiff.category()}.  These are used to calculate the standardized
difference between two groups.  It is especially used to evaluate the balance
between two groups before and after propensity score matching.")
    (license license:gpl3)))

(define-public r-strawr
  (package
    (name "r-strawr")
    (version "0.0.92")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "strawr" version))
              (sha256
               (base32
                "0dy6pagwvmswmrlvb9ndy8lz3krcm8fqik83l0gmv9wjb9vba27s"))))
    (properties `((upstream-name . "strawr")))
    (build-system r-build-system)
    (inputs (list curl zlib))
    (propagated-inputs (list r-rcpp))
    (home-page "https://github.com/aidenlab/straw/tree/master/R")
    (synopsis "Fast implementation of reading / dumping of .hic files")
    (description
     "This package provides an API for efficient @file{.hic} file data
extraction with programmatic matrix access.  It doesn't store the pointer data
for all the matrices, only the one queried, and currently it only supports
matrices.")
    (license license:expat)))

(define-public r-stringdist
  (package
    (name "r-stringdist")
    (version "0.9.15")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stringdist" version))
       (sha256
        (base32 "06151jksz8iaigvi20qbcrqjh684w5gii4wmxvnm5v1iwm5bxks4"))))
    (build-system r-build-system)
    (home-page "https://github.com/markvanderloo/stringdist")
    (synopsis "Approximate string matching and string distance functions")
    (description
     "This package implements an approximate string matching version of R's
native @code{match} function.  It can calculate various string distances based
on edits (Damerau-Levenshtein, Hamming, Levenshtein, optimal string alignment),
qgrams (q- gram, cosine, jaccard distance) or heuristic metrics (Jaro,
Jaro-Winkler).  An implementation of soundex is provided as well.  Distances
can be computed between character vectors while taking proper care of encoding
or between integer vectors representing generic sequences.")
    (license license:gpl3+)))

(define-public r-stringmagic
  (package
    (name "r-stringmagic")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stringmagic" version))
       (sha256
        (base32 "180kzm9gbl4jr9vwh58r9qyp78svmakh68zkhxfb43bxk3zq20m6"))))
    (properties `((upstream-name . "stringmagic")))
    (build-system r-build-system)
    ;; There are no tests in the ./tests/ directory.
    (arguments (list #:tests? #false))
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr))
    (home-page "https://lrberge.github.io/stringmagic/")
    (synopsis "Character string operations and interpolation, magic edition")
    (description
     "This package performs complex string operations compactly and
efficiently.  It supports string interpolation jointly with over 50 string
operations.  It also enhances regular string functions (like @code{grep()} and
co).")
    (license license:gpl2+)))

(define-public r-uchardet
  (package
    (name "r-uchardet")
    (version "1.1.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "uchardet" version))
              (sha256
               (base32
                "0m3xy807smqdxhkhd9cwrcf3ljlyvfmnkd7831qzpgcadam2jcdj"))))
    (properties `((upstream-name . "uchardet")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://artemklevtsov.gitlab.io/uchardet")
    (synopsis "Universal character encoding detector")
    (description
     "This package provides R bindings to the uchardet encoding detector
library from Mozilla.  It takes a sequence of bytes in an unknown character
encoding without any additional information, and attempts to get the encoding
of the text.  All return names of the encodings are iconv-compatible.")
    (license license:gpl2)))

(define-public r-ucminf
  (package
    (name "r-ucminf")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ucminf" version))
       (sha256
        (base32
         "0adxynpi6mn5n37i1260yr6z7dm39dadr4nwrxks2jgsd7knmnsb"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/ucminf/")
    (synopsis "General-purpose unconstrained non-linear optimization")
    (description
     "This package provides an implementation of an algorithm for
general-purpose unconstrained non-linear optimization.  The algorithm is of
quasi-Newton type with BFGS updating of the inverse Hessian and soft line
search with a trust region type monitoring of the input to the line search
algorithm.  The interface of @code{ucminf} is designed for easy interchange
with the package @code{optim}.")
    (license license:gpl2+)))

(define-public r-usedist
  (package
    (name "r-usedist")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "usedist" version))
       (sha256
        (base32 "0ddf1zcalbrn293qmr9kdzz3x16fzc4k1bwb1pjmwnspisqfi8kj"))))
    (properties
     '((upstream-name . "usedist")
       (updater-extra-native-inputs . ("r-dplyr" "r-tidyr" "r-tibble"))))
    (build-system r-build-system)
    (native-inputs (list r-dplyr r-testthat r-tidyr r-tibble))
    (home-page "https://cran.r-project.org/package=usedist")
    (synopsis "Distance matrix utilities")
    (description
     "This package provides functions to re-arrange, extract, and work with
distances.")
    (license license:gpl3)))

(define-public r-useful
  (package
   (name "r-useful")
   (version "1.2.6.1")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "useful" version))
            (sha256
             (base32
              "1gb9hqvbm6pr56dfqlsgz26lan7xargfsm8jpdja18mpgli2gyvc"))))
   (properties `((upstream-name . "useful")))
   (build-system r-build-system)
   (propagated-inputs
    (list r-assertthat
          r-dplyr
          r-ggplot2
          r-magrittr
          r-matrix
          r-plyr
          r-purrr
          r-scales))
   (native-inputs (list r-testthat))
   (home-page "https://github.com/jaredlander/useful")
   (synopsis "Collection of handy, useful functions")
   (description "This package provides a set of little functions that have been
found useful to do little odds and ends such as plotting the results of K-means
clustering, substituting special text characters, viewing parts of a
@code{data.frame}, constructing formulas from text and building design and
response matrices.")
   (license license:bsd-3)))

(define-public r-ordinal
  (package
    (name "r-ordinal")
    (version "2023.12-4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ordinal" version))
       (sha256
        (base32
         "1c9qiv0zz77i80gbhljj9hm4lh2zs9chfg834lcgyr6972jcz79c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix r-nlme r-numderiv r-ucminf))
    (native-inputs (list r-lme4 r-testthat r-xtable))
    (home-page "https://github.com/runehaubo/ordinal")
    (synopsis "Regression models for ordinal data")
    (description
     "This package provides an implementation of cumulative link (mixed)
models also known as ordered regression models, proportional odds models,
proportional hazards models for grouped survival times and ordered models.
Estimation is via maximum likelihood and mixed models are fitted with the
Laplace approximation and adaptive Gauss-Hermite quadrature.")
    (license license:gpl2+)))

(define-public r-jomo
  (package
    (name "r-jomo")
    (version "2.7-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "jomo" version))
       (sha256
        (base32
         "1np2sw0kq21kdhkv227pz2rqvpxg06r3mk93ggkrz5nl45ajmyiz"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lme4 r-mass r-ordinal r-survival r-tibble))
    (home-page "https://cran.r-project.org/web/packages/jomo/")
    (synopsis "Multilevel Joint Modelling Multiple Imputation")
    (description
     "Similarly to Schafer's package pan, jomo is a package for multilevel
joint modelling multiple imputation @url{Carpenter and Kenward (2013),
http://doi.org/10.1002/9781119942283}.  Novel aspects of jomo are the
possibility of handling binary and categorical data through latent normal
variables, the option to use cluster-specific covariance matrices and to
impute compatibly with the substantive model.")
    (license license:gpl2)))

(define-public r-pan
  (package
    (name "r-pan")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pan" version))
       (sha256
        (base32 "1skfdh8mg3hs9h651shyn80maas71jlbmvn06izym0rpclnj74fd"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/pan/")
    (synopsis "Multiple imputation for multivariate panel or clustered data")
    (description
     "This package implements multiple imputation for multivariate panel or
clustered data.")
    (license license:gpl3)))

(define-public r-mitml
  (package
    (name "r-mitml")
    (version "0.4-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mitml" version))
       (sha256
        (base32
         "1szfw993ma4qn377bab08bkvm4s0sxs5x2hdcj9kgk47661fqsh5"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-haven r-jomo r-pan))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/mitml/")
    (synopsis "Tools for multiple imputation in multilevel modeling")
    (description
     "This package provides tools for multiple imputation of missing data in
multilevel modeling.  It includes a user-friendly interface to the packages
pan and jomo, and several functions for visualization, data management and the
analysis of multiply imputed data sets.")
    (license license:gpl2+)))

(define-public r-mice
  (package
    (name "r-mice")
    (version "3.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mice" version))
       (sha256
        (base32
         "18nz7v4lkicyqzdaz7992fap0vl86fqvzrm3svsd5vb8gxx0kkn0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-cpp11
           r-dplyr
           r-glmnet
           r-lattice
           r-mitml
           r-nnet
           r-rcpp
           r-rpart
           r-tidyr))
    (native-inputs (list r-lme4
                         r-lmtest
                         r-mass
                         r-pan
                         r-survival
                         r-testthat))
    (home-page "https://cran.r-project.org/web/packages/mice/")
    (synopsis "Multivariate imputation by chained equations")
    (description
     "Multiple imputation using @dfn{Fully Conditional Specification} (FCS)
implemented by the MICE algorithm as described in @url{Van Buuren and
Groothuis-Oudshoorn (2011), http://doi.org/10.18637/jss.v045.i03}.  Each
variable has its own imputation model.  Built-in imputation models are
provided for continuous data (predictive mean matching, normal), binary
data (logistic regression), unordered categorical data (polytomous logistic
regression) and ordered categorical data (proportional odds).  MICE can also
impute continuous two-level data (normal model, pan, second-level variables).
Passive imputation can be used to maintain consistency between variables.
Various diagnostic plots are available to inspect the quality of the
imputations.")
    ;; Any of these two versions.
    (license (list license:gpl2 license:gpl3))))

(define-public r-transformr
  (package
    (name "r-transformr")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "transformr" version))
       (sha256
        (base32 "125y99wpgvp92qsg7934nzjqy6irjzaj21c0dcq7apqd2hqamfxw"))))
    (properties `((upstream-name . "transformr")))
    (build-system r-build-system)
    (propagated-inputs (list r-cpp11
                             r-lpsolve
                             r-rlang
                             r-sf
                             r-tweenr
                             r-vctrs))
    (home-page "https://github.com/thomasp85/transformr")
    (synopsis "Polygon and path transformations")
    (description
     "In order to smoothly animate the transformation of polygons and paths,
many aspects needs to be taken into account, such as differing number of
control points, changing center of rotation, etc.  The transformr package
provides an extensive framework for manipulating the shapes of polygons and
paths and can be seen as the spatial brother to the tweenr package.")
    (license license:expat)))

(define-public r-truncnorm
  (package
    (name "r-truncnorm")
    (version "1.0-9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "truncnorm" version))
       (sha256
        (base32
         "0267gvcg6mmf28x26z6njw373prwpaq8aqkd6aavyhrjsv2aqmji"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/truncnorm/")
    (synopsis "Truncated normal distribution")
    (description "This package provides functions for the truncated normal
distribution with mean equal to @code{mean} and standard deviation equal to
@code{sd}.  It includes density, distribution, quantile, and expected value
functions, as well as a random generation function.")
    (license license:gpl2)))

(define-public r-truncdist
  (package
    (name "r-truncdist")
    (version "1.0-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "truncdist" version))
       (sha256
        (base32 "02ihw4ixhadwr3sqm6r264i8vpcaz8pn69vkzabd8fwqvn5vcj5q"))))
    (properties `((upstream-name . "truncdist")))
    (build-system r-build-system)
    (propagated-inputs (list r-evd))
    (home-page "https://cran.r-project.org/package=truncdist")
    (synopsis "Truncated random variables")
    (description
     "This package provides a collection of tools to evaluate probability density
functions, cumulative distribution functions, quantile functions and random
numbers for truncated random variables.  These functions are provided to also
compute the expected value and variance.  @acronym{Q-Q, quantile–quantile} plots
can be produced.  All the probability functions in the stats, stats4 and evd
packages are automatically available for truncation.")
    (license license:gpl2+)))

(define-public r-trust
  (package
    (name "r-trust")
    (version "0.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "trust" version))
       (sha256
        (base32 "1b6wsx4vybr5952ii3ska6jbcb3654iibz83n645khxfca5k8blm"))))
    (properties `((upstream-name . "trust")))
    (build-system r-build-system)
    (home-page "https://www.stat.umn.edu/geyer/trust/")
    (synopsis "Trust region optimization")
    (description
     "This package does local optimization using two derivatives and trust
regions.  Guaranteed to converge to local minimum of objective function.")
    (license license:expat)))

(define-public r-trycatchlog
  (package
    (name "r-trycatchlog")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tryCatchLog" version))
       (sha256
        (base32 "0k40a48qzwmardjnkf0h5s5zryivzvdanz61kxdqdfqlil19ma0d"))))
    (properties `((upstream-name . "tryCatchLog")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/aryoda/tryCatchLog")
    (synopsis "Advanced tryCatch and try functions")
    (description
     "This package provides advanced @code{tryCatch} and @code{try} functions
for better error handling (logging, stack trace with source code references
and support for post-mortem analysis via dump files).")
    (license license:gpl3)))

(define-public r-rsolnp
  (package
    (name "r-rsolnp")
    (version "1.16")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rsolnp" version))
       (sha256
        (base32
         "0w7nkj6igr0gi7r7jg950lsx7dj6aipgxi6vbjsf5f5yc9h7fhii"))))
    (properties `((upstream-name . "Rsolnp")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-truncnorm))
    (home-page "https://cran.r-project.org/web/packages/Rsolnp/")
    (synopsis "General non-linear optimization")
    (description "The Rsolnp package implements a general non-linear augmented
Lagrange multiplier method solver, a @dfn{sequential quadratic
programming} (SQP) based solver).")
    ;; Any version of the GPL.
    (license license:gpl2+)))

(define-public r-hardyweinberg
  (package
    (name "r-hardyweinberg")
    (version "1.7.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "HardyWeinberg" version))
       (sha256
        (base32
         "1wddy32zljyya37isqb54sqhpp07s2kizjl36i08pj37bbza7yac"))))
    (properties `((upstream-name . "HardyWeinberg")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mice r-nnet r-rcpp r-rsolnp r-shape))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/package=HardyWeinberg")
    (synopsis "Statistical tests and graphics for Hardy-Weinberg equilibrium")
    (description
     "This package contains tools for exploring Hardy-Weinberg equilibrium for
diallelic genetic marker data.  All classical tests (chi-square, exact,
likelihood-ratio and permutation tests) for Hardy-Weinberg equilibrium are
included in the package, as well as functions for power computation and for
the simulation of marker data under equilibrium and disequilibrium.  Routines
for dealing with markers on the X-chromosome are included.  Functions for
testing equilibrium in the presence of missing data by using multiple
imputation are also provided.  Implements several graphics for exploring the
equilibrium status of a large set of diallelic markers: ternary plots with
acceptance regions, log-ratio plots and Q-Q plots.")
    (license license:gpl2+)))

(define-public r-sm
  (package
    (name "r-sm")
    (version "2.2-6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sm" version))
       (sha256
        (base32
         "0q8xav1alammiyiw2p8y0qq94ag5rln910jry8q3sb2p38ly79i7"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "http://www.stats.gla.ac.uk/~adrian/sm/")
    (synopsis "Smoothing methods for nonparametric regression and density estimation")
    (description
     "This is software accompanying the book 'Applied Smoothing Techniques for
Data Analysis---The Kernel Approach with S-Plus Illustrations', Oxford
University Press.  It provides smoothing methods for nonparametric regression
and density estimation")
    (license license:gpl2+)))

(define-public r-smd
  (package
    (name "r-smd")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "smd" version))
       (sha256
        (base32 "1f5pph3728jb15bmyv0xdanww490gjm5ixz9dbvdv27av02p12js"))))
    (properties `((upstream-name . "smd")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list r-knitr r-purrr r-stddiff r-tableone r-testthat))
    (home-page "https://bsaul.github.io/smd/")
    (synopsis "Compute standardized mean differences")
    (description
     "This package computes standardized mean differences and confidence
intervals for multiple data types based on Yang, D., & Dalton, J. E. (2012)
<https://support.sas.com/resources/papers/proceedings12/335-2012.pdf>.")
    (license license:expat)))

(define-public r-smoof
  (package
    (name "r-smoof")
    (version "1.6.0.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "smoof" version))
              (sha256
               (base32
                "1cazhnd0m5jjzixaqgqh2h3rsa2sw3k8slj5cmgm8v47aaqn91mg"))))
    (properties `((upstream-name . "smoof")))
    (build-system r-build-system)
    (propagated-inputs (list r-bbmisc
                             r-checkmate
                             r-ggplot2
                             r-paramhelpers
                             r-rcpp
                             r-rcpparmadillo))
    (native-inputs (list r-testthat))
    (home-page "https://jakobbossek.github.io/smoof/")
    (synopsis "Single and multi-objective optimization test functions")
    (description
     "This tool generates high number of both single- and multi-objective test
functions.  These functions are frequently used for the benchmarking of
(numerical) optimization algorithms.  Moreover, it offers a set of convenient
functions to generate, plot and work with objective functions.")
    (license license:bsd-2)))

(define-public r-smurf
  (package
    (name "r-smurf")
    (version "1.1.7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "smurf" version))
              (sha256
               (base32
                "19b24ibx32jmrsjn47xkz3qanpx7a6kmkws1yyj8aj193mi5s0q0"))))
    (properties `((upstream-name . "smurf")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-catdata
           r-glmnet
           r-mass
           r-matrix
           r-mgcv
           r-rcolorbrewer
           r-rcpp
           r-rcpparmadillo))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://gitlab.com/TReynkens/smurf")
    (synopsis "Sparse multi-type regularized feature modeling")
    (description
     "The @code{smurf} package contains the implementation of the
@dfn{Sparse Multi-type Regularized Feature} (SMuRF) modeling algorithm
to fit @dfn{generalized linear models} (GLMs) with multiple types of
predictors via regularized maximum likelihood.  Next to the fitting
procedure, following functionality is available:

@itemize
@item Selection of the regularization tuning parameter lambda using
  three different approaches: in-sample, out-of-sample or using
  cross-validation.
@item S3 methods to handle the fitted object including visualization
  of the coefficients and a model summary.
@end itemize")
    (license license:gpl2+)))

(define-public r-venndiagram
  (package
    (name "r-venndiagram")
    (version "1.7.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "VennDiagram" version))
              (sha256
               (base32
                "0ilcxcp8qskmb5cp7fyb7i0qizg42lrx0ny8ws3if90kfrglghp7"))))
    (properties `((upstream-name . "VennDiagram")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-futile-logger))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/VennDiagram/")
    (synopsis "Generate High-Resolution Venn and Euler Plots")
    (description
     "This package provides a set of functions to generate high-resolution
Venn and Euler plots.  It includes handling for several special cases,
including two-case scaling, and extensive customization of plot shape and
structure.")
    (license license:gpl2+)))

(define-public r-vioplot
  (package
    (name "r-vioplot")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vioplot" version))
       (sha256
        (base32
         "004g8xkdj0ghp365xgvwk5pf2ahrhxxq2f8482a73h59gwr11ff3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-sm r-zoo))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "http://wsopuppenkiste.wiso.uni-goettingen.de/~dadler")
    (synopsis "Violin plot")
    (description
     "This package provides a violin plot, which is a combination of a box
plot and a kernel density plot.")
    (license license:bsd-3)))

(define-public r-rsofia
  (package
    (name "r-rsofia")
    (version "1.1")
    (source (origin
              (method url-fetch)
              ;; This package has been removed from CRAN, so we can
              ;; only fetch it from the archives.
              (uri (string-append "https://cran.r-project.org/src/"
                                  "contrib/Archive/RSofia/RSofia_"
                                  version ".tar.gz"))
              (sha256
               (base32
                "0q931y9rcf6slb0s2lsxhgqrzy4yqwh8hb1124nxg0bjbxvjbihn"))))
    (properties `((upstream-name . "RSofia")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (home-page "https://cran.r-project.org/src/contrib/Archive/RSofia")
    (synopsis "Port of sofia-ml to R")
    (description "This package is a port of sofia-ml to R.  Sofia-ml is a
suite of fast incremental algorithms for machine learning that can be used for
training models for classification or ranking.")
    (license license:asl2.0)))

(define-public r-xts
  (package
    (name "r-xts")
    (version "0.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xts" version))
       (sha256
        (base32
         "0kvz75dygr1riyijxsz8vx86fk6yyghilgc9l74lqx405yrnpaax"))
       (modules '((guix build utils)))
       (snippet
        '(with-directory-excursion "inst/doc"
           ;; These files are generated from Rnw files.
           (for-each delete-file
                     (list "xts-faq.R"
                           "xts-faq.Rnw"
                           "xts-faq.pdf"
                           "xts.R"
                           "xts.Rnw"
                           "xts.pdf"))))))
    (build-system r-build-system)
    (propagated-inputs (list r-zoo))
    (home-page "https://github.com/joshuaulrich/xts")
    (synopsis "Extensible time series")
    (description
     "This package provides for uniform handling of R's different time-based
data classes by extending @code{zoo}, maximizing native format information
preservation and allowing for user-level customization and extension, while
simplifying cross-class interoperability.")
    (license license:gpl2+)))

(define-public r-pedigreemm
  (package
    (name "r-pedigreemm")
    (version "0.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pedigreemm" version))
       (sha256
        (base32 "1bnvd25z8ff0d00wijp2vw9xw11fczqrlblw3ag39pjzn98a1zf7"))))
    (properties `((upstream-name . "pedigreemm")))
    (build-system r-build-system)
    (propagated-inputs (list r-lme4 r-matrix))
    (home-page "https://github.com/anainesvs/pedigreemm/")
    (synopsis "Pedigree-based mixed-effects models")
    (description "This package lets you fit pedigree-based mixed-effects
models.")
    (license license:gpl2+)))

(define-public r-performanceanalytics
  (package
    (name "r-performanceanalytics")
    (version "2.0.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PerformanceAnalytics" version))
       (sha256
        (base32
         "1hsycy1warjs5ffn2p3nhv455a56svwy3x5605zh7q9qh200kqk4"))))
    (properties
     `((upstream-name . "PerformanceAnalytics")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for vignettes
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-quadprog r-xts r-zoo))
    (native-inputs (list r-r-rsp r-tinytest))
    (home-page "https://r-forge.r-project.org/projects/returnanalytics/")
    (synopsis "Econometric tools for performance and risk analysis")
    (description "This is a collection of econometric functions for
performance and risk analysis.  This package aims to aid practitioners and
researchers in utilizing the latest research in analysis of non-normal return
streams.  In general, it is most tested on return (rather than price) data on
a regular scale, but most functions will work with irregular return data as
well, and increasing numbers of functions will work with P&L or price data
where possible.")
    ;; Either version may be picked.
    (license (list license:gpl2 license:gpl3))))

(define-public r-laeken
  (package
    (name "r-laeken")
    (version "0.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "laeken" version))
       (sha256
        (base32
         "02z8jyya6xv0pyfqaalbry174fw44h13s7p1jk5b4h9a9x4myjb0"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-mass))
    (home-page "https://cran.r-project.org/web/packages/laeken/")
    (synopsis "Estimation of indicators on social exclusion and poverty")
    (description "This package provides tools for the estimation of indicators
on social exclusion and poverty, as well as an implementation of Pareto tail
modeling for empirical income distributions.")
    (license license:gpl2+)))

(define-public r-vcd
  (package
    (name "r-vcd")
    (version "1.4-13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vcd" version))
       (sha256
        (base32
         "1k7q3nl437bmg1pylivfykwx4l0k104qkypml5b6xvwkwfn65b4x"))))
    (build-system r-build-system)
    ;; Vignettes require r-coin, which needs r-vcd.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs
     (list r-colorspace r-lmtest r-mass))
    (home-page "https://cran.r-project.org/web/packages/vcd/")
    (synopsis "Visualizing categorical data")
    (description "This package provides visualization techniques, data sets,
summary and inference procedures aimed particularly at categorical data.
Special emphasis is given to highly extensible grid graphics.  The package was
originally inspired by the book \"Visualizing Categorical Data\" by Michael
Friendly and is now the main support package for a new book, \"Discrete Data
Analysis with R\" by Michael Friendly and David Meyer (2015).")
    (license license:gpl2)))

(define-public r-vcfr
  (package
   (name "r-vcfr")
   (version "1.15.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "vcfR" version))
            (sha256
             (base32
              "1yj91cphin232m09wrpj8l27vxblyryh658siakz55hxjs5y85yz"))))
   (build-system r-build-system)
   (native-inputs
    (list r-adegenet r-knitr r-testthat))
   (inputs
    (list zlib))
   (propagated-inputs
    (list r-ape
          r-dplyr
          r-magrittr
          r-memuse
          r-pinfsc50
          r-rcpp
          r-stringr
          r-tibble
          r-vegan
          r-viridislite))
   (home-page "https://github.com/knausb/vcfR")
   (synopsis "Manipulate and visualize VCF data")
   (description "This package facilitates easy manipulation of variant call
format (VCF) data.  Functions are provided to rapidly read from and write to
VCF files.  Once VCF data is read into R, a parser function extracts matrices
of data.  This information can then be used for quality control or other
purposes.  Additional functions provide visualization of genomic data.  Once
processing is complete data may be written to a VCF file.  It also may be
converted into other popular R objects.  This package provides a link between
VCF data and familiar R software.")
   (license license:gpl3)))

(define-public r-rvcg
  (package
    (name "r-rvcg")
    (version "0.25")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "Rvcg" version))
              (sha256
               (base32
                "1653ra7aj9xh0bxrv8wq4p1xiw4m8401misn8lzsy5702jhv7sx0"))))
    (properties `((upstream-name . "Rvcg")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp r-rcpparmadillo r-rcppeigen))
    (home-page "https://github.com/zarquon42b/Rvcg")
    (synopsis "Manipulations of triangular meshes based on the VCGLIB API")
    (description
     "This is a package for operations on triangular meshes based on VCGLIB.
This package integrates nicely with the R-package rgl to render the meshes
processed by Rvcg.  The Visualization and Computer Graphics Library (VCG for
short) is a library for manipulation, processing and displaying with OpenGL of
triangle and tetrahedral meshes.")
    (license license:gpl2+)))

(define-public r-ica
  (package
    (name "r-ica")
    (version "1.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ica" version))
       (sha256
        (base32
         "0rdqd3kz2cv3xvf6yz55bwhsg3k7j90d450i3azs2xkbn4q3aka7"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ica/")
    (synopsis "Independent component analysis")
    (description "This package provides tools for @dfn{Independent Component
Analysis} (ICA) using various algorithms: FastICA,
Information-Maximization (Infomax), and @dfn{Joint Approximate Diagonalization
of Eigenmatrices} (JADE).")
    (license license:gpl2+)))

(define-public r-ips
  (package
    (name "r-ips")
    (version "0.0.12")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ips" version))
              (sha256
               (base32
                "0vnsalm94vzagksqv4ph6x7vdwhd1lq278sak30pr4m9bc9xxchw"))))
    (properties `((upstream-name . "ips")))
    (build-system r-build-system)
    (propagated-inputs (list r-ape r-data-table r-phangorn r-plyr r-xml))
    (home-page "https://cran.r-project.org/package=ips")
    (synopsis "Interfaces to phylogenetic software in R")
    (description
     "This package provides functions that wrap popular phylogenetic software
for sequence alignment, masking of sequence alignments, and estimation of
phylogenies and ancestral character states.")
    (license license:gpl3)))

(define-public r-dtwclust
  (package
    (name "r-dtwclust")
    (version "6.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtwclust" version))
       (sha256
        (base32 "0by01x4qpf1pin5l61wmm600bmsnlnns9knwb0qmjlj72pmwfkqh"))))
    (properties `((upstream-name . "dtwclust")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-clue
           r-cluster
           r-dplyr
           r-dtw
           r-flexclust
           r-foreach
           r-ggplot2
           r-ggrepel
           r-matrix
           r-proxy
           r-rcpp
           r-rcpparmadillo
           r-rcppparallel
           r-rcppthread
           r-reshape2
           r-rlang
           r-rspectra
           r-shiny
           r-shinyjs))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/asardaes/dtwclust")
    (synopsis
     "Clustering time series with dynamic time warping distance optimization")
    (description
     "This package implements time series clustering along with optimized
techniques related to the dynamic time warping distance and its corresponding
lower bounds.  The implementations of partitional, hierarchical, fuzzy, k-Shape
and TADPole clustering are available.  Functionality can be easily extended with
custom distance measures and centroid definitions.  Implementations of @acronym{
DTW, dynamic time warping} barycenter averaging, a distance based on global
alignment kernels, and the soft-DTW distance and centroid routines are also
provided.  All included distance functions have custom loops optimized for the
calculation of cross-distance matrices, including parallelization support.
Several cluster validity indices are included.")
    (license license:gpl3)))

(define-public r-dtw
  (package
    (name "r-dtw")
    (version "1.23-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtw" version))
       (sha256
        (base32
         "0vc2is1hf1g0sw92kzl8mddck264qwiqgm5q2wkcwwz65fss7mkf"))))
    (build-system r-build-system)
    (propagated-inputs (list r-proxy))
    (home-page "https://dtw.r-forge.r-project.org/")
    (synopsis "Dynamic Time Warping Algorithms")
    (description "This package provides a comprehensive implementation of
@dfn{dynamic time warping} (DTW) algorithms in R.  DTW computes the
optimal (least cumulative distance) alignment between points of two time
series.  Common DTW variants covered include local (slope) and global (window)
constraints, subsequence matches, arbitrary distance definitions,
normalizations, minimum variance matching, and so on.")
    (license license:gpl2+)))

(define-public r-sdmtools
  (package
    (name "r-sdmtools")
    (version "1.1-221.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SDMTools" version))
       (sha256
        (base32
         "1xvcd97ikqsfdpk2fddy3k0z1ajqga7nv9bgac9c1wnjk1gqrpgh"))))
    (properties `((upstream-name . "SDMTools")))
    (build-system r-build-system)
    (propagated-inputs (list r-r-utils))
    (home-page "https://www.rforge.net/SDMTools/")
    (synopsis "Species distribution modelling tools")
    (description "This package provides a set of tools for post processing
the outcomes of species distribution modeling exercises.  It includes novel
methods for comparing models and tracking changes in distributions through
time.  It further includes methods for visualizing outcomes, selecting
thresholds, calculating measures of accuracy and landscape fragmentation
statistics, etc.")
    (license license:gpl3+)))

(define-public r-scatterplot3d
  (package
    (name "r-scatterplot3d")
    (version "0.3-44")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "scatterplot3d" version))
       (sha256
        (base32
         "1hkfislhzx05y5qqa7pvrils3qf9rhxbf37lkpsjbn9yihs0i70w"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/scatterplot3d/")
    (synopsis "3D scatter plot")
    (description "This package provides an implementation of scatter plots for
plotting.  a three dimensional point cloud.")
    (license license:gpl2)))

(define-public r-ggridges
  (package
    (name "r-ggridges")
    (version "0.5.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggridges" version))
       (sha256
        (base32
         "0dafd10ny6l2rlr1y453rhjiy17a33k15f82nk31238mk8qamk7g"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales r-withr))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/clauswilke/ggridges")
    (synopsis "Ridgeline plots in ggplot2")
    (description
     "Ridgeline plots provide a convenient way of visualizing changes in
distributions over time or space.  This package enables the creation of such
plots in @code{ggplot2}.")
    (license license:gpl2)))

(define-public r-ggjoy
  (package
    (name "r-ggjoy")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggjoy" version))
       (sha256
        (base32
         "012md2m0jqfcccb933j423m3ck31v3p0pd41gjxpyg9082y7ixyj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ggridges))
    (home-page "https://github.com/clauswilke/ggjoy")
    (synopsis "Joyplots in ggplot2")
    (description "Joyplots provide a convenient way of visualizing changes in
distributions over time or space.  This package enables the creation of such
plots in @code{ggplot2}.")
    (license license:gpl2)))

(define-public r-gss
  (package
    (name "r-gss")
    (version "2.2-9")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "gss" version))
              (sha256
               (base32
                "0iqfx02q8rkv8s0xcc6jylbj123wnvjh0hnwjsj12xahq5cnb8bf"))))
    (properties `((upstream-name . "gss")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=gss")
    (synopsis "General smoothing splines")
    (description
     "This package provides a comprehensive collection for structural
multivariate function estimation using smoothing splines.")
    (license license:gpl2+)))

(define-public r-cli
  (package
    (name "r-cli")
    (version "3.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cli" version))
       (sha256
        (base32
         "0ycn8px9ac7iigfpzknzkiyfm44p59zgikyxss55sa3awr333glf"))))
    (properties
     ;; We can't have r-testthat among the inputs, because that would lead to
     ;; a dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; Tests require r-testthat, but that package needs r-cli.
      #:tests? #false
      #:phases
      '(modify-phases %standard-phases
         ;; Do not embed the PID of the build process.
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (setenv "GUIX_BUILD" "yes")
             (substitute* '("R/onload.R" "R/app.R")
               (("\\<- Sys\\.getpid\\(\\)")
                (lambda _
                  (string-append
                   "<- if (Sys.getenv(\"GUIX_BUILD\") == \"\") { Sys.getpid() } else { 12345 }")))))))))
    (home-page "https://github.com/r-lib/cli#readme")
    (synopsis "Helpers for developing command line interfaces")
    (description "This package provides a suite of tools designed to build
attractive command line interfaces (CLIs).  It includes tools for drawing
rules, boxes, trees, and Unicode symbols with ASCII alternatives.")
    (license license:expat)))

(define-public r-argparser
  (package
    (name "r-argparser")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argparser" version))
       (sha256
        (base32
         "0j9hnbyzbyzclgm4qwyqqkrqcrblxfm190489sgcvr5i7vg2smr8"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://bitbucket.org/djhshih/argparser")
    (synopsis "Command-line argument parser")
    (description
     "This package provides a cross-platform command-line argument parser
written purely in R with no external dependencies.  It is useful with the
Rscript front-end and facilitates turning an R script into an executable
script.")
    (license license:gpl3+)))

(define-public r-aricode
  (package
    (name "r-aricode")
    (version "1.0.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "aricode" version))
              (sha256
               (base32
                "02nrw66jfpzf6dy0zy21sbdjxjc8c11iv9fkjqj5akzb7wskk9qh"))))
    (properties `((upstream-name . "aricode")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/jchiquet/aricode")
    (synopsis "Efficient computations of standard clustering comparison measures")
    (description
     "This package implements an efficient O(n) algorithm based on
bucket-sorting for fast computation of standard clustering comparison
measures.  Available measures include @dfn{adjusted Rand index} (ARI),
@dfn{normalized information distance} (NID), @dfn{normalized mutual
information} (NMI), @dfn{adjusted mutual information} (AMI), @dfn{normalized
variation information} (NVI) and entropy.")
    (license license:gpl3+)))

(define-public r-attempt
  (package
    (name "r-attempt")
    (version "0.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "attempt" version))
              (sha256
               (base32
                "1ylgg7jcp8wqmxgf1mydnvh26k0mr8jyjla4hw06730r40yrs58m"))))
    (properties `((upstream-name . "attempt")))
    (build-system r-build-system)
    (propagated-inputs (list r-rlang))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/ColinFay/attempt")
    (synopsis "Tools for defensive programming")
    (description
     "This package provides tools for defensive programming.  It is inspired
by @code{purrr} mappers and based on @code{rlang}.  Attempt extends and
facilitates defensive programming by providing a consistent grammar, and a set
of functions for common tests and conditions.  Attempt only depends on
@code{rlang}, and focuses on speed, so it can be integrated with other
functions and used in the data analysis.")
    (license license:expat)))

(define-public r-debugme
  (package
    (name "r-debugme")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "debugme" version))
       (sha256
        (base32
         "16ghf60rj0l8ypm0hxjp23zxdi2ndq8ii74cilq61m107fnha9mj"))))
    (properties
     '((updater-extra-native-inputs . ("r-mockery"))))
    (build-system r-build-system)
    (propagated-inputs (list r-crayon))
    (native-inputs (list r-mockery r-testthat))
    (home-page "https://github.com/r-lib/debugme#readme")
    (synopsis "Debug R packages")
    (description
     "This package allows the user to specify debug messages as special string
constants, and control debugging of packages via environment variables.")
    (license license:expat)))

(define-public r-processx
  (package
    (name "r-processx")
    (version "3.8.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "processx" version))
       (sha256
        (base32 "08a2fdazjyschgr2xd0g9ldxsfvb99bqi2192bswlla31vywmwf5"))))
    (properties
     ;; We can't have testthat among the inputs, because that would lead to a
     ;; dependency cycle.
     '((updater-ignored-native-inputs . ("r-testthat" "r-callr"))))
    (build-system r-build-system)
    ;; Tests require r-testthat, which indirectly depends on this package.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-ps r-r6))
    (home-page "https://github.com/r-lib/processx3")
    (synopsis "Execute and control system processes")
    (description
     "This package provides portable tools to run system processes in the
background.  It can check if a background process is running; wait on a
background process to finish; get the exit status of finished processes; kill
background processes and their children; restart processes.  It can read the
standard output and error of the processes, using non-blocking connections.
@code{processx} can poll a process for standard output or error, with a
timeout.  It can also poll several processes at once.")
    (license license:expat)))

(define-public r-timeseries
  (package
    (name "r-timeseries")
    (version "4041.111")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "timeSeries" version))
              (sha256
               (base32
                "0hwazbv91lcxcddas7hwyc86rzl5fbyw6mrpksbyb6025ivj8g85"))))
    (properties `((upstream-name . "timeSeries")))
    (build-system r-build-system)
    ;; Vignettes require a large number of other packages.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-timedate))
    (native-inputs (list r-runit))
    (home-page
     "https://r-forge.r-project.org/scm/viewvc.php/pkg/timeSeries/?root=rmetrics")
    (synopsis "Metrics for financial time series objects")
    (description
     "This package implements S4 classes and various tools for financial time
series.  Basic functions such as scaling and sorting, subsetting, mathematical
operations and statistical functions are provided.")
    (license license:gpl2+)))

(define-public r-tsp
  (package
    (name "r-tsp")
    (version "1.2-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TSP" version))
       (sha256
        (base32
         "082cmbv943bb8ibpfvczjvkv1s9k6dzj4619b64d8sni2hawlldb"))))
    (properties `((upstream-name . "TSP")))
    (build-system r-build-system)
    (propagated-inputs (list r-foreach))
    (native-inputs (list r-maps r-testthat))
    (home-page "https://cran.r-project.org/web/packages/TSP/")
    (synopsis "Traveling salesperson problem (TSP)")
    (description "This package provides basic infrastructure and some
algorithms for the @dfn{traveling salesperson problem}(TSP) (also known as the
traveling salesman problem).")
    (license license:gpl3)))

(define-public r-qap
  (package
    (name "r-qap")
    (version "0.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qap" version))
       (sha256
        (base32
         "19adb1bw46pcnmmhqz2jklr0vmma3llxajqp0j9mqfksmsisv927"))))
    (build-system r-build-system)
    (native-inputs (list gfortran r-testthat))
    (home-page "https://cran.r-project.org/web/packages/qap/")
    (synopsis "Heuristics for the quadratic assignment problem (QAP)")
    (description "This package implements heuristics for the @dfn{quadratic
assignment problem} (QAP).  Currently only a simulated annealing heuristic is
available.")
    (license license:gpl3)))

(define-public r-gclus
  (package
    (name "r-gclus")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gclus" version))
       (sha256
        (base32
         "0542yv9gv93l41dsijkr19fpzhs42z6qhh00h13mqkwcc4d54s36"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/gclus/")
    (synopsis "Clustering graphics")
    (description "This package orders panels in scatterplot matrices and
parallel coordinate displays by some merit index.  It contains various indices
of merit, ordering functions, and enhanced versions of @code{pairs} and
@code{parcoord} which color panels according to their merit level.")
    (license license:gpl2+)))

(define-public r-webchem
  (package
    (name "r-webchem")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webchem" version))
       (sha256
        (base32 "06b9i9jipg564zyw4gkgiidz7501rlp40hxm4z3k5mzy148lr5vq"))))
    (properties `((upstream-name . "webchem")))
    (build-system r-build-system)
    (propagated-inputs (list r-base64enc
                             r-data-tree
                             r-dplyr
                             r-httr
                             r-jsonlite
                             r-purrr
                             r-rlang
                             r-rvest
                             r-stringr
                             r-tibble
                             r-xml2))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/webchem/")
    (synopsis "Chemical information from the web")
    (description
     "This package interacts with a suite of web services for chemical
information.  Sources include: Alan Wood's Compendium of Pesticide Common
Names, Chemical Identifier Resolver, ChEBI, Chemical Translation Service,
ChemSpider, ETOX, Flavornet, NIST Chemistry WebBook, OPSIN, PubChem, SRS,
Wikidata.")
    (license license:expat)))

(define-public r-webshot
  (package
    (name "r-webshot")
    (version "0.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "webshot" version))
       (sha256
        (base32
         "04xrrf72323sgzsdkbl05p2fdsi486i9avrrxvw0l3n8r8y92xfn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-callr r-jsonlite r-magrittr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/wch/webshot/")
    (synopsis "Take screenshots of web pages")
    (description
     "Webshot makes it easy to take screenshots of web pages from within R.
It can also run Shiny applications locally and take screenshots of the
application; and it can render and screenshot static as well as interactive R
Markdown documents.")
    (license license:gpl2)))

(define-public r-seriation
  (package
    (name "r-seriation")
    (version "1.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "seriation" version))
       (sha256
        (base32
         "0m98qhk3mkdny728v90cwmq24qinn7v03fyj4vmaw7hsjrzmj6kc"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ca
           r-cluster
           r-colorspace
           r-foreach
           r-gclus
           r-mass
           r-qap
           r-registry
           r-tsp
           r-vegan))
    (native-inputs (list gfortran r-dendextend r-testthat))
    (home-page "https://s2.smu.edu/IDA/seriation/")
    (synopsis "Infrastructure for ordering objects using seriation")
    (description
     "This package provides infrastructure for seriation with an
implementation of several seriation/sequencing techniques to reorder matrices,
dissimilarity matrices, and dendrograms.  It also provides (optimally)
reordered heatmaps, color images and clustering visualizations like
dissimilarity plots, and visual assessment of cluster tendency plots (VAT and
iVAT).")
    (license license:gpl3)))

(define-public r-xfun
  (package
    (name "r-xfun")
    (version "0.52")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "xfun" version))
       (sha256
        (base32 "1yls1zi47ysd6wm8yik03cjxfsi7pc7bl014yp9s6c9ivc1gy1il"))))
    (build-system r-build-system)
    (properties
     ;; knitr itself depends on xfun
     '((updater-ignored-native-inputs . ("r-knitr" "r-litedown"))
       (updater-extra-native-inputs . ("r-codetools"))))
    (arguments
     (list
      ;; Do not build vignettes, because they require r-litedown, which
      ;; depends on r-xfun.
      #:test-types '(list "tests")
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for tests
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs (list r-codetools r-testit))
    (home-page "https://github.com/yihui/xfun")
    (synopsis "Miscellaneous functions")
    (description
     "This package provides miscellaneous functions commonly used in other
packages maintained by Yihui Xie.")
    (license license:expat)))

(define-public r-utf8
  (package
    (name "r-utf8")
    (version "1.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "utf8" version))
       (sha256
        (base32
         "091xj6vhikxadqbvswx6zhnvh5yvzgpqk2kn1dcp9v8rq5iq5gig"))))
    (build-system r-build-system)
    (native-inputs
     (list r-cli
           r-knitr
           r-rlang
           r-rmarkdown
           r-testthat
           r-withr)) ; for vignettes
    (home-page "https://github.com/patperry/r-utf8")
    (synopsis "Unicode text processing")
    (description
     "This package provides tools to process and print UTF-8 encoded
international text (Unicode).  Input, validate, normalize, encode, format, and
display.")
    (license license:asl2.0)))

(define-public r-zeallot
  (package
    (name "r-zeallot")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zeallot" version))
       (sha256
        (base32
         "1fwjv8lck5jz3gd67lr5wrpj1m7k70mkx6riyxv2yxndnzdrfsvz"))))
    (build-system r-build-system)
    (native-inputs (list r-codetools r-knitr r-testthat))
    (home-page "https://github.com/nteetor/zeallot")
    (synopsis "Multiple, unpacking, and destructuring assignment")
    (description
     "This package provides a @code{%<-%} operator to perform multiple,
unpacking, and destructuring assignment in R.  The operator unpacks the
right-hand side of an assignment into multiple values and assigns these values
to variables on the left-hand side of the assignment.")
    (license license:expat)))

(define-public r-zlog
  (package
    (name "r-zlog")
    (version "1.0.2")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "zlog" version))
              (sha256
               (base32
                "0fi9aqrmikdg5ibwhn82kslj4lxih03vm27jmi14m73h09yy4in5"))))
    (properties `((upstream-name . "zlog")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=zlog")
    (synopsis "Transformation for laboratory easurements")
    (description
     "The @code{zlog} package offers functions to transform laboratory
measurements into standardised z or @math{z(log)-values}.  Therefore the lower
and upper reference limits are needed.  If these are not known they could be
estimated from a given sample.")
    (license license:gpl3+)))

(define-public r-vctrs
  (package
    (name "r-vctrs")
    (version "0.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "vctrs" version))
       (sha256
        (base32
         "00p4r1z4xc05m25y0qa7svr67lbypcfqyp2b0ja9asgx90i7s5j3"))))
    (properties
     ;; We can't have r-knitr among the inputs here, because r-vctrs ends up
     ;; being an eventual input to r-knitr.
     '((updater-ignored-native-inputs . ("r-knitr" "r-testthat"))))
    (build-system r-build-system)
    ;; Some tests require tibble, which depends on this package.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-cli r-glue r-lifecycle r-rlang))
    (home-page "https://github.com/r-lib/vctrs")
    (synopsis "Vector helpers")
    (description
     "There are three main goals to the @code{vctrs} package:

@enumerate
@item To propose @code{vec_size()} and @code{vec_type()} as alternatives to
  @code{length()} and @code{class()}.  These definitions are paired with a
  framework for type-coercion and size-recycling.
@item To define type- and size-stability as desirable function properties, use
  them to analyse existing base function, and to propose better alternatives.
  This work has been particularly motivated by thinking about the ideal
  properties of @code{c()}, @code{ifelse()}, and @code{rbind()}.
@item To provide a new @code{vctr} base class that makes it easy to create new
  S3 vectors.  @code{vctrs} provides methods for many base generics in terms of
  a few new @code{vctrs} generics, making implementation considerably simpler
  and more robust.
@end enumerate\n")
    (license license:gpl3)))

(define-public r-pillar
  (package
    (name "r-pillar")
    (version "1.10.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pillar" version))
       (sha256
        (base32
         "0ifnarggd1anxslf2yknc18dvq3lr31nzchai0q2bdi83gzf7nrc"))))
    (properties
     ;; Avoid dependency cycles.
     '((updater-ignored-native-inputs . ("r-ggplot2" "r-tibble"))
       (updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-glue
           r-lifecycle
           r-rlang
           r-utf8
           r-vctrs))
    (native-inputs
     (list r-bit64
           r-dbi
           r-evaluate
           r-knitr
           r-lubridate
           r-nanotime
           r-survival
           r-testthat
           r-vdiffr
           r-withr
           tzdata-for-tests))
    (home-page "https://github.com/r-lib/pillar")
    (synopsis "Coloured formatting for columns")
    (description
     "This package provides a @code{pillar} generic designed for formatting
columns of data using the full range of colours provided by modern
terminals.")
    (license license:gpl3)))

(define-public r-pinfsc50
  (package
   (name "r-pinfsc50")
   (version "1.3.0")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "pinfsc50" version))
            (sha256
             (base32
              "1gs9x328qqvqwx3k4z9jgzq5zb6g8kdz4430n96v7zb78p7jf5lp"))))
   (build-system r-build-system)
   (home-page "https://cran.r-project.org/web/packages/pinfsc50/")
   (synopsis "Genomic data for the plant pathogen Phytophthora infestans")
   (description "This package contains genomic data for the plant pathogen
Phytophthora infestans.  It includes a variant file, a sequence file and an
annotation file.  This package is intended to be used as example data for
packages that work with genomic data.")
   (license license:gpl2+)))

(define-public r-piton
  (package
    (name "r-piton")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "piton" version))
       (sha256
        (base32 "1krf6zi238m275nxjlpyayv8y2drbgs2kg19dpkqm0lmlz5y5ar8"))))
    (properties `((upstream-name . "piton")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/Ironholds/piton")
    (synopsis "Parsing expression grammars in Rcpp")
    (description
     "This package provides a wrapper around the Parsing Expression Grammar
Template Library, a C++11 library for generating parsing expression grammars,
that makes it accessible within Rcpp.  With this, developers can implement
their own grammars and easily expose them in R packages.")
    (license license:expat)))

(define-public r-uuid
  (package
    (name "r-uuid")
    (version "1.2-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "uuid" version))
       (sha256
        (base32
         "15jbzj0i4qphakbi8s9yk55lm8z9s2vhgp5bj77sfvkx7mrlj3pr"))))
    (build-system r-build-system)
    (home-page "https://www.rforge.net/uuid")
    (synopsis "Tools for generating and handling of UUIDs")
    (description
     "This package provides tools for generating and handling of
@dfn{Universally Unique Identifiers} (UUIDs).")
    (license license:expat)))

(define-public r-tinylabels
  (package
    (name "r-tinylabels")
    (version "0.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinylabels" version))
       (sha256
        (base32 "0jplsnqjrr0y8rbin4i3yxgv3cvb6pbmh2y2in1smmy5ywsyyz3d"))))
    (properties
     '((upstream-name . "tinylabels")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat r-vctrs))
    (home-page "https://github.com/mariusbarth/tinylabels")
    (synopsis "Lightweight variable labels")
    (description
     "This package lets you assign, extract, or remove variable labels from R
vectors.")
    (license license:expat)))

(define-public r-tinytex
  (package
    (name "r-tinytex")
    (version "0.57")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinytex" version))
       (sha256
        (base32
         "05nrmlh107g7zw2lv2r2xsvgfri66wg7fhd6z6xsj137jd8y039j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-xfun))
    (native-inputs (list r-testit))
    (home-page "https://github.com/yihui/tinytex")
    (synopsis "Helper functions for TeX Live and compiling LaTeX documents")
    (description
     "This package provides helper functions to install and maintain the LaTeX
distribution named TinyTeX, a lightweight, cross-platform, portable, and
easy-to-maintain version of TeX Live.  This package also contains helper
functions to compile LaTeX documents, and install missing LaTeX packages
automatically.")
    (license license:expat)))

(define-public r-tinytest
  (package
    (name "r-tinytest")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tinytest" version))
       (sha256
        (base32
         "0x0w1fiqd98vmpz8yrp9ig0ry1wfr16g6bkjzd2a8sq9gn417z7n"))))
    (properties `((upstream-name . "tinytest")))
    (build-system r-build-system)
    ;; Vignettes complain about a missing file, which is in fact there.
    (arguments (list #:test-types '(list "tests")))
    (home-page "https://github.com/markvanderloo/tinytest")
    (synopsis "Lightweight unit testing framework")
    (description
     "This package provides a lightweight unit testing framework.  Main
features:

@enumerate
@item install tests with the package;
@item test results are treated as data that can be stored and manipulated;
@item test files are R scripts interspersed with test commands, that can be
  programmed over;
@item fully automated build-install-test sequence for packages;
@item skip tests when not run locally (e.g. on CRAN);
@item flexible and configurable output printing;
@item compare computed output with output stored with the package;
@item run tests in parallel;
@item extensible by other packages;
@item report side effects.
@end enumerate
")
    (license license:gpl3)))

(define-public r-n2r
  (package
    (name "r-n2r")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "N2R" version))
       (sha256
        (base32 "0bbxl0y36bmsxwi4rs4f6jwhf9bhag2rkvvzcg5669vgm2p4scjr"))))
    (properties `((upstream-name . "N2R")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix
           r-rcpp
           r-rcppeigen
           r-rcppspdlog))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/kharchenkolab/N2R")
    (synopsis "Fast and scalable approximate k-Nearest Neighbor search methods")
    (description
     "This package implements methods to perform fast approximate K-nearest
neighbor search on the input matrix.  The algorithm is based on the N2
implementation of an approximate nearest neighbor search using hierarchical
@acronym{NSW, Navigable Small World} graphs.")
    (license license:asl2.0)))

(define-public r-name
  (package
    (name "r-name")
    (version "0.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "name" version))
       (sha256
        (base32 "1va2qqcxgvc4nzkylxyyzz8yx6ndgb1hx7af3qjzf8m4mzg8qnvm"))))
    (properties `((upstream-name . "name")))
    (build-system r-build-system)
    (propagated-inputs (list r-cli
                             r-dplyr
                             r-rlang
                             r-stringr
                             r-tibble
                             r-tidyselect))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/christopherkenny/name")
    (synopsis "Tools for working with names")
    (description
     "This package provides a system for organizing column names in data.
It is aimed at supporting a prefix-based and suffix-based column naming
scheme.  It extends dplyr functionality to add ordering by function and more
explicit renaming.")
    (license license:expat)))

(define-public r-naniar
  (package
    (name "r-naniar")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "naniar" version))
              (sha256
               (base32
                "0i3gijr1l7hbcp75cyj26pxmm493lnvasl8aba9vv4w8lz1lck59"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-dplyr
           r-forcats
           r-ggplot2
           r-glue
           r-lifecycle
           r-magrittr
           r-norm
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-upsetr
           r-vctrs
           r-viridis
           r-visdat))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/njtierney/naniar")
    (synopsis
     "Data structures, summaries, and visualisations for missing data")
    (description
     "Missing values are ubiquitous in data and need to be explored and
handled in the initial stages of analysis.  The package provides data
structures and functions that facilitate the plotting of missing values and
examination of imputations.  This allows missing data dependencies to be
explored with minimal deviation from the common work patterns of
@code{ggplot2} and tidy data.")
    (license license:expat)))

(define-public r-nanonext
  (package
    (name "r-nanonext")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nanonext" version))
       (sha256
        (base32 "0n2lq6czshp4r5jsrabz6al36s3d9dai8dkf80h9bskga36bfkp3"))))
    (properties `((upstream-name . "nanonext")))
    (build-system r-build-system)
    (arguments
     (list
      #:tests? #false                   ;some tests require Internet access
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'find-libraries
           (lambda _
             (setenv "INCLUDE_DIR" (getenv "C_INCLUDE_PATH"))
             (setenv "LIB_DIR" (getenv "LIBRARY_PATH")))))))
    (inputs (list mbedtls-lts nng-1.10))
    (native-inputs (list r-later r-litedown r-promises))
    (home-page "https://shikokuchuo.net/nanonext/")
    (synopsis "NNG (Nanomsg Next Gen) lightweight messaging library")
    (description
     "This package provides R bindings for NNG (Nanomsg Next Gen), a successor
to ZeroMQ.  NNG is a socket library for reliable, high-performance messaging
over in-process, IPC, TCP, WebSocket and secure TLS transports.  It implements
Scalability Protocols, a standard for common communications patterns including
publish/subscribe, request/reply and service discovery.  As its own threaded
concurrency framework, it provides a toolkit for asynchronous programming and
distributed computing.  Intuitive @code{aio} objects resolve automatically
when asynchronous operations complete, and synchronisation primitives allow R
to wait upon events signalled by concurrent threads.")
    (license license:gpl3+)))

(define-public r-nestedcv
  (package
    (name "r-nestedcv")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nestedcv" version))
       (sha256
        (base32 "1cymz961bcc9ga2dk2fnqi8iiz9da95fxw242l0brp3w0ymdcx4q"))))
    (properties `((upstream-name . "nestedcv")))
    (build-system r-build-system)
    (propagated-inputs (list r-caret
                             r-data-table
                             r-doparallel
                             r-foreach
                             r-future-apply
                             r-ggplot2
                             r-glmnet
                             r-matrixstats
                             r-matrixtests
                             r-proc
                             r-rfast
                             r-rhpcblasctl
                             r-rlang
                             r-rocr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/myles-lewis/nestedcv")
    (synopsis "Nested cross-validation with glmnet and caret")
    (description
     "This package implements nested cross-validation applied to the
@code{glmnet} and @code{caret} packages.  With glmnet this includes
cross-validation of elastic net alpha parameter.  A number of feature
selection filter functions (t-test, Wilcoxon test, ANOVA, Pearson/Spearman
correlation, random forest, ReliefF) for feature selection are provided and
can be embedded within the outer loop of the nested CV.  Nested CV can be also
be performed with the @code{caret} package giving access to the large number
of prediction methods available in @code{caret}.")
    (license license:expat)))

(define-public r-ncdfcf
  (package
    (name "r-ncdfcf")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ncdfCF" version))
       (sha256
        (base32 "00hys99h9znyx3xbzkllramaraaib6fn5rjswn2x9xy926b8q9q8"))))
    (properties `((upstream-name . "ncdfCF")))
    (build-system r-build-system)
    (propagated-inputs (list r-abind r-cftime r-r6 r-rnetcdf r-stringr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/pvanlaake/ncdfCF")
    (synopsis "Easy access to NetCDF files with CF Metadata Conventions")
    (description
     "@dfn{Network Common Data Form} (netCDF) files are widely used for
scientific data.  Library-level access in R is provided through packages
RNetCDF and ncdf4.  The package ncdfCF is built on top of RNetCDF and makes
the data and its attributes available as a set of R6 classes that are informed
by the Climate and Forecasting Metadata Conventions.  Access to the data uses
standard R subsetting operators and common function forms.")
    (license license:expat)))

(define-public r-ncmeta
  (package
    (name "r-ncmeta")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ncmeta" version))
       (sha256
        (base32 "1aamxs3yza1hsgvkp6740lv1dc21a87mzl06n6w3zxkjshri020w"))))
    (properties
     '((upstream-name . "ncmeta")
       ;; These packages do not exist.
       (updater-ignored-native-inputs
        . ("r-raadfiles" "r-raadtools"))))
    (build-system r-build-system)
    (propagated-inputs (list r-cftime
                             r-dplyr
                             r-rlang
                             r-rnetcdf
                             r-tibble
                             r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/hypertidy/ncmeta")
    (synopsis "Straightforward NetCDF metadata")
    (description
     "Extract metadata from @code{NetCDF} data sources; these can be files,
file handles or servers.  This package leverages and extends the lower level
functions of the RNetCDF package providing a consistent set of functions that
all return data frames.")
    (license license:gpl3)))

(define-public r-network
  (package
    (name "r-network")
    (version "1.19.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "network" version))
       (sha256
        (base32
         "04i02ld1wq5qij2q7sx7k1kmpz1gb2xkwbqhhvriwh8nzc3s04px"))))
    (build-system r-build-system)
    (properties
     '((updater-ignored-native-inputs . ("r-sna"))))
    (arguments
     (list
      ;; Vignettes require r-sna, which depends on r-network.
      #:test-types '(list "tests")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; One test requires access to the internet.
             (delete-file "tests/testthat/test-read.paj.R"))))))
    (propagated-inputs
     (list r-magrittr r-statnet-common r-tibble))
    (native-inputs (list r-testthat))
    (home-page "https://statnet.org/")
    (synopsis "Classes for relational data")
    (description
     "This package provides tools to create and modify network objects.  The
@code{network} class can represent a range of relational data types, and
supports arbitrary vertex/edge/graph attributes.")
    (license license:gpl2+)))

(define-public r-nistunits
  (package
    (name "r-nistunits")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NISTunits" version))
       (sha256
        (base32 "0km9l3k9p35sb1qrhrz4ijjsdihvsp6j7cz5kh46lgf7nn6xdk7a"))))
    (properties `((upstream-name . "NISTunits")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=NISTunits")
    (synopsis "Fundamental physical constants and unit conversions")
    (description
     "This package provides fundamental physical constants (quantity, value,
uncertainty, unit) for @acronym{SI, International System of Units} and non-SI
units, plus unit conversions based on the data from @acronym{NIST, National
Institute of Standards and Technology}, USA.")
    (license license:gpl3+)))

(define-public r-nlme
  (package
    (name "r-nlme")
    (version "3.1-168")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nlme" version))
       (sha256
        (base32 "0qkki4x49808cmvj1fmsivq68b836f0rq3ayxrfpgdjc6il89dr3"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/nlme")
    (synopsis "Linear and nonlinear mixed effects models")
    (description
     "This package provides tools to fit and compare Gaussian linear and
nonlinear mixed-effects models.")
    (license license:gpl2+)))

(define-public r-nloptr
  (package
    (name "r-nloptr")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nloptr" version))
       (sha256
        (base32
         "1x6pmqh3k5ckjbzkallndpqnlx61y02rwv58sqd8np271dsl1fkn"))))
    (properties
     '((updater-extra-inputs . ("nlopt"))))
    (build-system r-build-system)
    (native-inputs
     (list pkg-config r-knitr r-tinytest))
    (inputs (list nlopt))
    (home-page "https://cran.r-project.org/web/packages/nloptr")
    (synopsis "R interface to NLopt")
    (description
     "This package is interface to NLopt, a library for nonlinear
optimization.  NLopt is a library for nonlinear optimization, providing a
common interface for a number of different free optimization routines
available online as well as original implementations of various other
algorithms.")
    (license license:lgpl3)))

(define-public r-norm
  (package
    (name "r-norm")
    (version "1.0-11.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "norm" version))
              (sha256
               (base32
                "1g33g721c0f2b275b334ir6n0h81fh567vs9vrxk60y21z1ydzy2"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/norm/")
    (synopsis "Analysis of multivariate normal datasets with missing values")
    (description "This package provides an integrated set of functions for the
analysis of multivariate normal datasets with missing values, including
implementation of the EM algorithm, data augmentation, and multiple
imputation.")
    (license license:gpl2+)))

(define-public r-numderiv
  (package
    (name "r-numderiv")
    (version "2016.8-1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "numDeriv" version))
       (sha256
        (base32
         "0idk02pqkziik932bd8k72d1q775g1is3m4bc861pcxfz6gx3i6q"))))
    (properties `((upstream-name . "numDeriv")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/numDeriv")
    (synopsis "Accurate numerical derivatives")
    (description
     "This package provides methods for calculating accurate numerical first
and second order derivatives.")
    (license license:gpl2)))

(define-public r-numero
  (package
    (name "r-numero")
    (version "1.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Numero" version))
       (sha256
        (base32 "038nyc1chis326kgdbwzl0w24v7pk3cdwb5x94q2g6lvf5ffh5y3"))))
    (properties `((upstream-name . "Numero")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-knitr r-rmarkdown))
    (home-page "https://cran.r-project.org/package=Numero")
    (synopsis "Statistical framework to define subgroups in complex datasets")
    (description
     "The package includes the necessary functions to construct a
self-organizing map of data, to evaluate the statistical significance of the
observed data patterns, and to visualize the results.")
    (license license:gpl2+)))

(define-public r-nycflights13
  (package
    (name "r-nycflights13")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nycflights13" version))
       (sha256
        (base32 "07aa76c77pm1wpzkwjmzv8n6ir5i6fxawx8wx586gwc5wajcb1qf"))))
    (properties `((upstream-name . "nycflights13")))
    (build-system r-build-system)
    (propagated-inputs (list r-tibble))
    (home-page "https://github.com/hadley/nycflights13")
    (synopsis "Flights that departed NYC in 2013")
    (description
     "This package provides airline on-time data for all flights departing NYC
in 2013.  It also includes useful metadata on airlines, airports, weather, and
planes.")
    (license license:cc0)))

(define-public r-s7
  (package
    (name "r-s7")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "S7" version))
       (sha256
        (base32 "16yllj1a2m9akli5z2q8fv7jlgc2y0z3bk919d96wfbsmizmlrxq"))))
    (properties `((upstream-name . "S7")))
    (build-system r-build-system)
    (native-inputs (list r-callr
                         r-knitr
                         r-name
                         r-testthat
                         r-tibble
                         r-withr))
    (home-page "https://rconsortium.github.io/S7/")
    (synopsis
     "Object-oriented system meant to become a successor to S3 and S4")
    (description
     "This package provides a new object oriented programming system designed
to be a successor to S3 and S4.  It includes formal class, generic, and method
specification, and a limited form of multiple dispatch.  It has been designed
and implemented collaboratively by the R Consortium Object-Oriented
Programming Working Group, which includes representatives from R-Core,
Bioconductor, Posit/tidyverse, and the wider R community.")
    (license license:expat)))

(define-public r-stabs
  (package
    (name "r-stabs")
    (version "0.6-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "stabs" version))
       (sha256
        (base32
         "1nf1yg14cgxrs4np1yghpzw1nczaslfv3rvf3918wrlzg0vp6l7q"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/hofnerb/stabs")
    (synopsis "Stability selection with error control")
    (description
     "This package provides resampling procedures to assess the stability of
selected variables with additional finite sample error control for
high-dimensional variable selection procedures such as Lasso or boosting.
Both, standard stability selection (Meinshausen & Buhlmann, 2010) and
complementary pairs stability selection with improved error bounds
(Shah & Samworth, 2013) are implemented.  The package can be combined with
arbitrary user specified variable selection approaches.")
    (license license:gpl2)))

(define-public r-rle
  (package
    (name "r-rle")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rle" version))
       (sha256
        (base32
         "1arlb1lhwyk8744f1inlghd3rkmzfgmfdq7zs353v0rs1yl9j5qr"))))
    (properties `((upstream-name . "rle")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/rle/")
    (synopsis "Common functions for run-length encoded vectors")
    (description
     "This package provides common @code{base} and @code{stats} methods for
@code{rle} objects, aiming to make it possible to treat them transparently as
vectors.")
    (license license:gpl3)))

(define-public r-statnet-common
  (package
    (name "r-statnet-common")
    (version "4.12.0")
    (source
      (origin
        (method url-fetch)
        (uri (cran-uri "statnet.common" version))
        (sha256
          (base32
            "1z448l4mh4kfv79rf033hf93lg6msp6xdrrg6v1spn0bqg0wkij5"))))
    (properties
      `((upstream-name . "statnet.common")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda r-matrix))
    (home-page "https://statnet.org")
    (synopsis "R scripts and utilities used by the Statnet software")
    (description "This package provides non-statistical utilities used by the
software developed by the Statnet Project.")
    (license license:gpl3)))

(define-public r-statcheck
  (package
    (name "r-statcheck")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "statcheck" version))
       (sha256
        (base32
         "0gsr068if5k8124x1cbm48720l9qvnfmdg6rmh7rwh6jvxxgknd7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-plyr r-rlang r-rmarkdown r-stringi))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/statcheck/")
    (synopsis "Extract statistics from articles and recompute p-values")
    (description "This package can automatically extract statistical
null-hypothesis significant testing (NHST) results from articles and recompute
the p-values based on the reported test statistic and degrees of freedom to
detect possible inconsistencies.")
    (license license:gpl2)))

(define-public r-sna
  (package
    (name "r-sna")
    (version "2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sna" version))
       (sha256
        (base32
         "0k4r5a3p3ngdc8szy6xdvgaibasggcrpb5hdxplnmmawa27dn2pj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-network r-statnet-common))
    (home-page "https://statnet.org")
    (synopsis "Tools for social network analysis")
    (description
     "This package provides a range of tools for social network analysis,
including node and graph-level indices, structural distance and covariance
methods, structural equivalence detection, network regression, random graph
generation, and 2D/3D network visualization.")
    (license license:gpl2+)))

(define-public r-tfisher
  (package
    (name "r-tfisher")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TFisher" version))
       (sha256
        (base32
         "0vz74ww1lf1prfwz74hfsi3a8nzq8ss7aqjr85c1d87vss2796xx"))))
    (properties `((upstream-name . "TFisher")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrix r-mvtnorm r-sn))
    (home-page "https://cran.r-project.org/web/packages/TFisher/")
    (synopsis "Optimal thresholding Fisher's p-value combination method")
    (description
     "This package provides the @dfn{cumulative distribution function} (CDF),
quantile, and statistical power calculator for a collection of thresholding
Fisher's p-value combination methods, including Fisher's p-value combination
method, truncated product method and, in particular, soft-thresholding
Fisher's p-value combination method which is proven to be optimal in some
context of signal detection.  The p-value calculator for the omnibus version
of these tests are also included.")
    (license license:gpl2)))

(define-public r-ttr
  (package
    (name "r-ttr")
    (version "0.24.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TTR" version))
       (sha256
        (base32
         "1102f4i776asqb281mq20ymhzhcp12gn9nr3rm0jzblv6nf2nww9"))))
    (properties `((upstream-name . "TTR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-curl r-xts r-zoo))
    (native-inputs (list r-runit))
    (home-page "https://github.com/joshuaulrich/TTR")
    (synopsis "Technical trading rules")
    (description
     "This package provides functions and data to construct technical trading
rules with R.")
    (license license:gpl2)))

(define-public r-leaflet-providers
  (package
    (name "r-leaflet-providers")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaflet.providers" version))
       (sha256
        (base32 "0rl69bfx2l10x80rl8cppqch3fnd05sk9w29h8589jc8h3ffmkn5"))))
    (properties `((upstream-name . "leaflet.providers")))
    (build-system r-build-system)
    (propagated-inputs (list r-htmltools))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/rstudio/leaflet.providers")
    (synopsis "Leaflet map tile providers")
    (description
     "This package contains third-party map tile provider information from
Leaflet.js, to be used with the @code{leaflet} R package.  Additionally,
@code{leaflet.providers} enables users to retrieve up-to-date provider
information between package updates.")
    (license license:bsd-2)))

;; This package contains a lot of minified JavaScript with unclear provenance.
;; When upgrading please make sure that all minified JavaScript files are
;; removed in a snippet and that the replacement sources correspond to the
;; original minified scripts.
(define-public r-leaflet
  (package
    (name "r-leaflet")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaflet" version))
       (sha256
        (base32 "1sxq38dcjhn1bkav7fxglzk8nwi5p32jia2nhijcq5j1766pp1yj"))
       (snippet
        '(for-each
          delete-file
          (list "inst/htmlwidgets/lib/leaflet/leaflet.js"
                "inst/htmlwidgets/lib/leaflet-measure/leaflet-measure.min.js"
                "inst/htmlwidgets/lib/leaflet-omnivore/leaflet-omnivore.min.js"
                "inst/htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.min.js"
                "inst/htmlwidgets/plugins/Leaflet.awesome-markers/bootstrap.min.js"
                "inst/htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.min.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.freezable.js"
                "inst/htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.layersupport.js"
                "inst/legacy/www/leaflet.js")))))
    (properties
     '((upstream-name . "leaflet")
       (updater-extra-native-inputs . ("r-shiny"))))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             ;; The inst directory contains some minified JavaScript files.
             ;; Regenerate them from sources.
             (invoke "unzip" "-d" "/tmp" (assoc-ref inputs "js-leaflet"))
             (with-directory-excursion "inst/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `(("/tmp/leaflet-src.js"
                         "htmlwidgets/lib/leaflet/leaflet.js")
                        (,(assoc-ref inputs "js-leaflet-measure")
                         "htmlwidgets/lib/leaflet-measure/leaflet-measure.min.js")
                        (,(assoc-ref inputs "js-leaflet-omnivore")
                         "htmlwidgets/lib/leaflet-omnivore/leaflet-omnivore.min.js")
                        ("htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.js"
                         "htmlwidgets/plugins/Leaflet-MiniMap/Control.MiniMap.min.js")
                        (,(assoc-ref inputs "js-bootstrap3")
                         "htmlwidgets/plugins/Leaflet.awesome-markers/bootstrap.min.js")
                        ("htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.js"
                         "htmlwidgets/plugins/Leaflet.awesome-markers/leaflet.awesome-markers.min.js")
                        (,(string-append (assoc-ref inputs "js-leaflet-markercluster")
                                         "/dist/leaflet.markercluster-src.js")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.js")
                        (,(assoc-ref inputs "js-leaflet-markercluster-freezable")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.freezable.js")
                        (,(assoc-ref inputs "js-leaflet-markercluster-layersupport")
                         "htmlwidgets/plugins/Leaflet.markercluster/leaflet.markercluster.layersupport.js")
                        (,(assoc-ref inputs "js-proj4leaflet")
                         "htmlwidgets/plugins/Proj4Leaflet/proj4.min.js")
                        ("legacy/www/leaflet-src.js"
                         "legacy/www/leaflet.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("unzip" ,unzip)
       ("js-bootstrap3"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/twbs/bootstrap/v3.3.7/dist/js/bootstrap.js")
           (sha256
            (base32
             "1j1qjagwj0m3q322z9wxxnpkd8zbk6g3kl047dsbmqad6gmqvgha"))))
       ("js-leaflet"
        ,(origin
           (method url-fetch)
           (uri "http://cdn.leafletjs.com/leaflet/v1.3.1/leaflet.zip")
           (sha256
            (base32
             "10phzd2vczy3zm1b64whp2nna69cf9hlj2bndc9yq47vf3ddqx8f"))))
       ("js-leaflet-omnivore"
        ,(origin
           (method url-fetch)
           (uri (string-append "https://api.tiles.mapbox.com/mapbox.js/plugins/"
                               "leaflet-omnivore/v0.3.1/leaflet-omnivore.js"))
           (sha256
            (base32
             "1b8zxrp6xwzpw25apn8j4qws0f6sr7qr7h2va5h1mjyfqvn29anq"))))
       ("js-leaflet-markercluster"
        ,(origin
           (method git-fetch)
           (uri (git-reference
                 (url "https://github.com/Leaflet/Leaflet.markercluster.git")
                 (commit "v1.1.0")))
           (file-name (git-file-name "js-leaflet-markercluster" "1.1.0"))
           (sha256
            (base32
             "0ds8c7picqjmc86bm5n6hm8k71fwsa2cpgib19sbdamzr9hm0rs1"))))
       ("js-leaflet-markercluster-freezable"
        ,(origin
           (method url-fetch)
           (uri (string-append
                 "https://raw.githubusercontent.com/ghybs/Leaflet.MarkerCluster.Freezable/"
                 "9db80a3fba7dff4aee940e05d3d4dceaa1fffcf9/src/freezable.js"))
           (file-name "leaflet-markercluster-freezable.js")
           (sha256
            (base32
             "1k6sn5n0z2x3an91vwvkzmqq4b8ppswgk5hi5qrr79klas1hbx1k"))))
       ("js-leaflet-markercluster-layersupport"
        ,(origin
           (method url-fetch)
           (uri (string-append
                 "https://raw.githubusercontent.com/ghybs/Leaflet.MarkerCluster.LayerSupport/"
                 "87f3848b92e0516d9c98f6d4cd175f7b8a4e3805/src/layersupport.js"))
           (file-name "leaflet-markercluster-layersupport.js")
           (sha256
            (base32
             "15qa21xif94y762c65yxxysxykz3mma6y6agw3nxpr3s7wbb75ff"))))
       ("js-leaflet-measure"
        ,(origin
           (method url-fetch)
           (uri "https://unpkg.com/leaflet-measure@1.5.2/dist/leaflet-measure.js")
           (file-name "js-leaflet-measure-1.5.2.js")
           (sha256
            (base32
             "0ggg3ffmm7pj9ry4gssrh0a17pnad3p6gwi0dg98y819pmpqa7y0"))))
       ("js-proj4leaflet"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/kartena/Proj4Leaflet/1.0.2/lib/proj4.js")
           (file-name "js-proj4leaflet-1.0.2.js")
           (sha256
            (base32
             "0vyrbf6gv2lyh4c2bzp5349ivwvvg28gpn87y52a7jdb13rlkpab"))))
       ("r-shiny" ,r-shiny)
       ("r-testthat" ,r-testthat)))
    (propagated-inputs
     (list r-crosstalk
           r-htmltools
           r-htmlwidgets
           r-jquerylib
           r-leaflet-providers
           r-magrittr
           r-png
           r-raster
           r-rcolorbrewer
           r-scales
           r-sp
           r-viridislite
           r-xfun))
    (home-page "https://rstudio.github.io/leaflet/")
    (synopsis "Create interactive web maps with the JavaScript Leaflet library")
    (description
     "Create and customize interactive maps using the Leaflet JavaScript
library and the @code{htmlwidgets} package.  These maps can be used directly
from the R console, from RStudio, in Shiny applications and R Markdown
documents.")
    (license license:gpl3)))

(define-public r-leaps
  (package
    (name "r-leaps")
    (version "3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "leaps" version))
       (sha256
        (base32
         "1bbgm6l12gj1y28ks21awxphpmp07hb0ffiyrw7dqp3fcyxvxmm0"))))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/leaps/")
    (synopsis "Regression subset selection")
    (description
     "This package provides tools for regression subset selection, including
exhaustive search.")
    (license license:gpl2+)))

(define-public r-splus2r
  (package
    (name "r-splus2r")
    (version "1.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "splus2R" version))
       (sha256
        (base32
         "097bpzazw5ryb6izbmz2sdlghn3qvh7c7wsnn0j08j65f9bfmc77"))))
    (properties `((upstream-name . "splus2R")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/splus2R/")
    (synopsis "Supplemental S-PLUS functionality in R")
    (description
     "Currently there are many functions in S-PLUS that are missing in R.  To
facilitate the conversion of S-PLUS packages to R packages, this package
provides some missing S-PLUS functionality in R.")
    (license license:gpl2)))

(define-public r-ifultools
  (package
    (name "r-ifultools")
    (version "2.0-26")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ifultools" version))
       (sha256
        (base32
         "1lkmzrh65j6vdb8523axxk9gig5q4zxy08wiqsp16w482d2q2sl1"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      `(modify-phases %standard-phases
         (add-after 'unpack 'compatibility
           (lambda _
             ;; These definitions are no longer part of R since 4.2.0.  See
             ;; https://cran.r-project.org/doc/manuals/r-devel/NEWS.html for
             ;; details.
             (substitute* "inst/include/ut_RS.h"
               (("#include \"R.h\"" m)
                (string-append "\
#define R_PROBLEM_BUFSIZE 4096
#define PROBLEM	{char R_problem_buf[R_PROBLEM_BUFSIZE];(sprintf)(R_problem_buf,
#define MESSAGE {char R_problem_buf[R_PROBLEM_BUFSIZE];(sprintf)(R_problem_buf,
#define ERROR	),error(R_problem_buf);}
#define WARNING(x)		),warning(R_problem_buf);}
#define WARN			WARNING(NULL)
" m))))))))
    (propagated-inputs
     (list r-mass r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/ifultools/")
    (synopsis "Insightful research tools")
    (description "This package provides C code used by the wmtsa, fractal, and
sapa R packages.")
    (license license:gpl2)))

(define-public r-sapa
  (package
    (name "r-sapa")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sapa" version))
       (sha256
        (base32
         "0kj681rd4c2lvqr926lb6f4qwp281x5274dg6vbk8pf5y7s0qlpc"))
       (patches (search-patches "r-sapa-lapack.patch"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/sapa/")
    (synopsis "Spectral analysis for physical applications")
    (description "This package provides software for the book Spectral
Analysis for Physical Applications, Donald B. Percival and Andrew T. Walden,
Cambridge University Press, 1993.")
    (license license:gpl2)))

(define-public r-aggregation
  (package
    (name "r-aggregation")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "aggregation" version))
       (sha256
        (base32
         "0j9g604m2ccc7hcy02539yja9cf3xcbl25gvp838bp4x8w18my46"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/aggregation/")
    (synopsis "Methods for p-value aggregation")
    (description
     "This package contains functionality for performing the following methods
of p-value aggregation: Fisher's method, the Lancaster method (weighted
Fisher's method), and Sidak correction.")
    (license license:gpl3)))

(define-public r-quantmod
  (package
    (name "r-quantmod")
    (version "0.4.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quantmod" version))
       (sha256
        (base32
         "0h81c9jcj51r4v146z6lgpwilq1v96gas5rv5jmv2bn2c4mw1lvi"))))
    (build-system r-build-system)
    (arguments
     (list
      ;; FIXME: identical(sQuote(api.key), default.key) is not TRUE
      #:tests? #false
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (substitute* "R/buildModel.R"
               (("Sys.time\\(\\)")
                "if (\"\" != Sys.getenv(\"SOURCE_DATE_EPOCH\")) {\
 as.numeric(Sys.getenv(\"SOURCE_DATE_EPOCH\"))\
} else { Sys.time() }\n")))))))
    (propagated-inputs
     (list r-curl r-jsonlite r-ttr r-xts r-zoo))
    (home-page "https://cran.r-project.org/web/packages/quantmod/")
    (synopsis "Quantitative financial modelling framework")
    (description "This package provides a quantitative financial modelling
framework to allow users to specify, build, trade, and analyse quantitative
financial trading strategies.")
    (license license:gpl3)))

(define-public r-quantpsyc
  (package
    (name "r-quantpsyc")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "QuantPsyc" version))
       (sha256
        (base32
         "1dbj830p5837fiwa800nzsaf19lf95vc3n7jmds2q9v06mrz6syq"))))
    (properties `((upstream-name . "QuantPsyc")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot
           r-dplyr
           r-mass
           r-purrr))
    (home-page "https://cran.r-project.org/web/packages/QuantPsyc/")
    (synopsis "Quantitative psychology tools")
    (description
     "This package contains functions useful for data screening, testing
moderation, mediation and estimating power.")
    (license license:gpl2+)))

(define-public r-quantreg
  (package
    (name "r-quantreg")
    (version "6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quantreg" version))
       (sha256
        (base32 "16hnw2kynr4s75iybzgf17z95wgyx8fkk4sv54wmz895mg2r48pl"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; This is needed for building vignettes
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list gfortran r-r-rsp))           ;for vignettes
    (propagated-inputs
     (list r-mass r-matrix r-matrixmodels r-sparsem r-survival))
    (home-page "https://www.r-project.org")
    (synopsis "Quantile regression")
    (description
     "This package provides an estimation and inference methods for models
of conditional quantiles: linear and nonlinear parametric and non-parametric
models for conditional quantiles of a univariate response and several methods
for handling censored survival data.  Portfolio selection methods based on
expected shortfall risk are also included.")
    (license license:gpl2+)))

(define-public r-quarto
  (package
    (name "r-quarto")
    (version "1.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "quarto" version))
       (sha256
        (base32 "18403v03hh57fm09csg6jmxh6biih7dgq9sakn0hg6x3kn8vnnaf"))))
    (properties `((upstream-name . "quarto")))
    (build-system r-build-system)
    ;; Vignettes require the quarto binary.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-cli
                             r-jsonlite
                             r-later
                             r-processx
                             r-rlang
                             r-rmarkdown
                             r-rstudioapi
                             r-yaml))
    (native-inputs (list r-knitr r-testthat r-withr r-xfun))
    (home-page "https://github.com/quarto-dev/quarto-r")
    (synopsis "R Interface to Quarto markdown publishing system")
    (description
     "This package lets you convert R Markdown documents and Jupyter notebooks
to a variety of output formats using Quarto.")
    (license license:gpl2+)))

(define-public r-tseries
  (package
    (name "r-tseries")
    (version "0.10-58")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "tseries" version))
       (sha256
        (base32
         "0957pi65myp6qnrk710kcbw83401v226lsxdxkas73mv84cygphf"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-jsonlite r-quadprog r-quantmod r-zoo))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/tseries/")
    (synopsis "Time series analysis and computational finance")
    (description
     "This package provides functions relating to time series analysis and
computational finance.")
    (license license:gpl2)))

(define-public r-wmtsa
  (package
    (name "r-wmtsa")
    (version "2.0-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "wmtsa" version))
       (sha256
        (base32
         "1q436krz5p1f4a7a7sya6a9rh9x9mi8zzcgq66gbk9w9w4hcqcj6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools r-mass r-splus2r))
    (home-page "https://cran.r-project.org/web/packages/wmtsa/")
    (synopsis "Wavelet methods for time series analysis")
    (description
     "This package provides software to accompany the book \"Wavelet Methods
for Time Series Analysis\", Donald B. Percival and Andrew T. Walden, Cambridge
University Press, 2000.")
    (license license:gpl2)))

(define-public r-tsa
  (package
    (name "r-tsa")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "TSA" version))
       (sha256
        (base32
         "14g58s2w7wma1fgcg3b51267b3676zrv0w8v4hpypxygz023d9bx"))))
    (properties `((upstream-name . "TSA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-leaps r-locfit r-mgcv r-tseries))
    (home-page "https://homepage.divms.uiowa.edu/~kchan/TSA.htm")
    (synopsis "Time series analysis")
    (description
     "This package contains R functions and datasets detailed in the book
\"Time Series Analysis with Applications in R (second edition)\" by Jonathan
Cryer and Kung-Sik Chan.")
    (license license:gpl2+)))

(define-public r-extradistr
  (package
    (name "r-extradistr")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "extraDistr" version))
       (sha256
        (base32
         "1ad3xp4axbbid9i9vd4q8iccs3g3917yic2mas37mfwm5in4l9pl"))))
    (properties `((upstream-name . "extraDistr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/twolodzko/extraDistr")
    (synopsis "Additional univariate and multivariate distributions")
    (description
     "This package implements density, distribution functions, quantile
functions and random generation functions for a large number of univariate and
multivariate distributions.")
    (license license:gpl2)))

(define-public r-fbasics
  (package
    (name "r-fbasics")
    (version "4041.97")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fBasics" version))
              (sha256
               (base32
                "1aqm973km7z8b6r90j3dcqi7dgf8fxcjb5ps2q3f14p80rg0ahlr"))))
    (properties `((upstream-name . "fBasics")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gss
           r-mass
           r-spatial
           r-stabledist
           r-timedate
           r-timeseries))
    (native-inputs (list r-runit))
    (home-page
     "https://r-forge.r-project.org/scm/viewvc.php/pkg/fBasics/?root=rmetrics")
    (synopsis "Metrics for markets and basic statistics")
    (description
     "This package provides a collection of functions to explore and to
investigate basic properties of financial returns and related quantities.  The
covered fields include techniques of explorative data analysis and the
investigation of distributional properties, including parameter estimation and
hypothesis testing.  Even more, there are several utility functions for data
handling and management.")
    (license license:gpl2+)))

(define-public r-fractal
  (package
    (name "r-fractal")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fractal" version))
       (sha256
        (base32
         "18lr9z0gslvfc3z8vyj3krqj3bfhg60zv1fzinrwwkc4cpk1w7mp"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ifultools
           r-mass
           r-sapa
           r-scatterplot3d
           r-splus2r
           r-wmtsa))
    (home-page "https://cran.r-project.org/web/packages/fractal/")
    (synopsis "Fractal time series modeling and analysis")
    (description
     "This package provides tools for stochastic fractal and deterministic
chaotic time series analysis.")
    (license license:gpl2)))

(define-public r-fresh
  (package
    (name "r-fresh")
    (version "0.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "fresh" version))
              (sha256
               (base32
                "19ki4hxlqzshdmy981gcvbn8wxqa893p5rs55l0q7iipkcmhf9jq"))))
    (properties `((upstream-name . "fresh")))
    (build-system r-build-system)
    (propagated-inputs (list r-bslib r-htmltools r-rstudioapi r-sass r-shiny))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/dreamRs/fresh")
    (synopsis "Create custom Bootstrap themes to use in Shiny")
    (description
     "Customize Bootstrap and Bootswatch themes, like colors, fonts,
grid layout, to use in Shiny applications, rmarkdown documents and
flexdashboard.")
    (license license:gpl3)))

(define-public r-urca
  (package
    (name "r-urca")
    (version "1.3-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "urca" version))
       (sha256
        (base32
         "05nb1an5a8r0w6gca6cf40nws2v4hxhznz8kyfm7q7hz0kjnqggy"))))
    (build-system r-build-system)
    (propagated-inputs (list r-nlme))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/urca/")
    (synopsis "Unit root and cointegration tests for time series data")
    (description
     "This package provides unit root and cointegration tests encountered in
applied econometric analysis.")
    (license license:gpl2+)))

(define-public r-cubature
  (package
    (name "r-cubature")
    (version "2.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cubature" version))
       (sha256
        (base32
         "1vpiiw40kxmm0s8qfz3582f77wjzknipykx9rpmqv4p2mjcghaz6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/bnaras/cubature")
    (synopsis "Adaptive multivariate integration over hypercubes")
    (description
     "This package is an R wrapper around the cubature C library for adaptive
multivariate integration over hypercubes.  This version provides both
@code{hcubature} and @code{pcubature} routines in addition to a vector
interface.")
    ;; The included cubature C library is released under GPLv2+, but the
    ;; wrapper declares the license to be GPLv3+.
    (license (list license:gpl2+ license:gpl3+))))

(define-public r-trend
  (package
    (name "r-trend")
    (version "1.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "trend" version))
       (sha256
        (base32
         "0991fp6kjk704rfg0l1m7kwbck9fj1rg27zy4llm5ikczd55w05h"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-extradistr))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/trend/")
    (synopsis "Non-parametric trend tests and change-point detection")
    (description
     "The analysis of environmental data often requires the detection of
trends and change-points.  This package includes tests for trend
detection (Cox-Stuart Trend Test, Mann-Kendall Trend Test, (correlated)
Hirsch-Slack Test, partial Mann-Kendall Trend Test, multivariate (multisite)
Mann-Kendall Trend Test, (Seasonal) Sen's slope, partial Pearson and Spearman
correlation trend test), change-point detection (Lanzante's test procedures,
Pettitt's test, Buishand Range Test, Buishand U Test, Standard Normal
Homogeinity Test), detection of non-randomness (Wallis-Moore Phase Frequency
Test, Bartels rank von Neumann's ratio test, Wald-Wolfowitz Test) and the two
sample Robust Rank-Order Distributional Test.")
    (license license:gpl3)))

(define-public r-expm
  (package
    (name "r-expm")
    (version "1.0-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "expm" version))
       (sha256
        (base32
         "0m5jm92mjn83zvh4jz7rdf04jdaad7lv2l0a44rb2mdgyvw3di82"))))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix))
    (native-inputs (list gfortran))
    (home-page "https://r-forge.r-project.org/projects/expm/")
    (synopsis "Tools for matrix exponentials and related quantities")
    (description
     "This package provides tools for the computation of the matrix
exponential, logarithm, square root, and related quantities.")
    (license license:gpl2+)))

(define-public r-exposition
  (package
    (name "r-exposition")
    (version "2.11.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "ExPosition" version))
              (sha256
               (base32
                "1lqbvqbzzy6lxdfaaayrw5slqm3ry9p4annvx405f2sbp6dg9jgr"))))
    (properties `((upstream-name . "ExPosition")))
    (build-system r-build-system)
    (propagated-inputs (list r-prettygraphs))
    (home-page "https://cran.r-project.org/package=ExPosition")
    (synopsis "Exploratory analysis with the singular value decomposition")
    (description
     "This package provides a variety of descriptive multivariate analyses
with the singular value decomposition, such as principal components analysis,
correspondence analysis, and multidimensional scaling.  See An ExPosition of
the Singular Value Decomposition in R (Beaton et al 2014)
<doi:10.1016/j.csda.2013.11.006>.")
    (license license:gpl2)))

(define-public r-complexplus
  (package
    (name "r-complexplus")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "complexplus" version))
       (sha256
        (base32
         "16w9v7d1ckavqmr86l34frr37pkvdn0iqnb17ssb8xaggns5lgqx"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-expm r-matrix))
    (home-page "https://cran.r-project.org/web/packages/complexplus/")
    (synopsis "Functions of complex or real variables")
    (description
     "This package extends several functions to the complex domain, including
the matrix exponential and logarithm, and the determinant.")
    (license license:gpl2)))

(define-public r-complexupset
  (package
    (name "r-complexupset")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ComplexUpset" version))
       (sha256
        (base32 "1sk4v5kc2wkgfaws0hjlp30mngm907r5gz1iglf68j46lfs9jbsv"))))
    (properties `((upstream-name . "ComplexUpset")))
    (build-system r-build-system)
    (propagated-inputs (list r-colorspace r-ggplot2 r-patchwork r-scales))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/krassowski/complex-upset")
    (synopsis "Create complex UpSet plots using ggplot2 components")
    (description
     "@code{UpSet} plots are an improvement over Venn Diagram for set overlap
visualizations.  Striving to bring the best of the @code{UpSetR} and ggplot2,
this package offers a way to create complex overlap visualisations, using
simple and familiar tools.")
    (license license:expat)))

(define-public r-phontools
  (package
    (name "r-phontools")
    (version "0.2-2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "phonTools" version))
       (sha256
        (base32
         "0r5ylbxvzpa23yys4rxdlglfc5jq997ziw6yf8v9jyavy4p1ppkx"))))
    (properties `((upstream-name . "phonTools")))
    (build-system r-build-system)
    (home-page "http://www.santiagobarreda.com/rscripts.html")
    (synopsis "Tools for phonetic and acoustic analyses")
    (description
     "This package contains tools for the organization, display, and analysis
of the sorts of data frequently encountered in phonetics research and
experimentation, including the easy creation of IPA vowel plots, and the
creation and manipulation of WAVE audio files.")
    (license license:bsd-2)))

(define-public r-np
  (package
    (name "r-np")
    (version "0.60-18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "np" version))
       (sha256
        (base32
         "16ragidbi560fvkl4pwn8wxsbcj40hp03bxqhx811cicmk0m875j"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot r-cubature r-quadprog r-quantreg))
    (native-inputs
     (list r-gam r-mass r-mgcv))
    (home-page "https://github.com/JeffreyRacine/R-Package-np")
    (synopsis "Non-parametric kernel smoothing methods for mixed data types")
    (description "This package provides non-parametric (and semi-parametric)
kernel methods that seamlessly handle a mix of continuous, unordered, and
ordered factor data types.")
    ;; Any version of the GPL.
    (license license:gpl3+)))

(define-public r-powerplus
  (package
    (name "r-powerplus")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "powerplus" version))
       (sha256
        (base32
         "0ayp6x34hkzgris4j3zbbs0r23n81bhww3wgfyy630ri4sk6brrn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-complexplus r-expm r-mass r-matrix r-phontools))
    (home-page "https://cran.r-project.org/web/packages/powerplus/")
    (synopsis "Exponentiation operations")
    (description
     "This package provides tools for the computation of matrix and scalar
exponentiation.")
    (license license:gpl2)))

(define-public r-egg
  (package
    (name "r-egg")
    (version "0.4.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "egg" version))
       (sha256
        (base32
         "1fy7srpiavfn8kyrr1m84an7acgwi6ydzrg71m3b0vk7y9ybmj0m"))))
    (properties `((upstream-name . "egg")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-gridextra r-gtable))
    (home-page "https://cran.r-project.org/web/packages/egg")
    (synopsis "Extensions for ggplot2")
    (description
     "This package provides miscellaneous functions to help customize ggplot2
objects.  High-level functions are provided to post-process ggplot2 layouts
and allow alignment between plot panels, as well as setting panel sizes to
fixed values.  Other functions include a custom @code{geom}, and helper
functions to enforce symmetric scales or add tags to facetted plots.")
    (license license:gpl3)))

(define-public r-heatmap3
  (package
    (name "r-heatmap3")
    (version "1.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "heatmap3" version))
       (sha256
        (base32
         "0sfvizmmwfk1bjhn6zfx5a4qqfgj1ldg8x90b65crqibgfa36k2r"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastcluster))
    (native-inputs
     (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/heatmap3/")
    (synopsis "Improved heatmap package")
    (description
     "This package provides an improved heatmap package.  It is completely
compatible with the original R function @code{heatmap}, and provides more
powerful and convenient features.")
    (license license:gpl2+)))

(define-public r-heatmaply
  (package
    (name "r-heatmaply")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "heatmaply" version))
       (sha256
        (base32
         "1crdm7avxv3zx59byz2fqbcw95728crwf9cckjb9gal1065xv95c"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-colorspace
           r-dendextend
           r-egg
           r-ggplot2
           r-htmlwidgets
           r-magrittr
           r-plotly
           r-rcolorbrewer
           r-reshape2
           r-scales
           r-seriation
           r-viridis
           r-webshot))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=heatmaply")
    (synopsis "Interactive cluster heat maps using plotly")
    (description
     "This package enables you to create interactive cluster heatmaps that can
be saved as a stand-alone HTML file, embedded in R Markdown documents or in a
Shiny app, and made available in the RStudio viewer pane.  Hover the mouse
pointer over a cell to show details or drag a rectangle to zoom.  A heatmap is
a popular graphical method for visualizing high-dimensional data, in which a
table of numbers is encoded as a grid of colored cells.  The rows and columns
of the matrix are ordered to highlight patterns and are often accompanied by
dendrograms.")
    ;; Either version of the license.
    (license (list license:gpl2 license:gpl3))))

(define-public r-cgdsr
  (package
    (name "r-cgdsr")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cgdsr" version))
       (sha256
        (base32
         "07yc819hkabpzzh0g0cbqza6bcfy67b2marrzz1lj97f9iba78ja"))))
    (build-system r-build-system)
    ;; FIXME: Tests fail with: could not find function "context"
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-httr r-r-methodss3 r-r-oo))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/cBioPortal/cgdsr")
    (synopsis "R-based API for accessing the MSKCC Cancer Genomics Data Server")
    (description
     "This package provides a basic set of R functions for querying the Cancer
Genomics Data Server (CGDS), hosted by the Computational Biology Center at
Memorial-Sloan-Kettering Cancer Center (MSKCC).")
    (license license:lgpl3)))

(define-public r-cqrreg
  (package
    (name "r-cqrreg")
    (version "1.2.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "cqrReg" version))
              (sha256
               (base32
                "1788hnm1qd5mv5bcizz2h170jg6954sfggjnfqcwfwg167px0df2"))))
    (properties `((upstream-name . "cqrReg")))
    (build-system r-build-system)
    (propagated-inputs (list r-quantreg r-rcpp r-rcpparmadillo))
    (home-page "https://cran.r-project.org/package=cqrReg")
    (synopsis
     "Quantile, composite quantile regression and regularized versions")
    (description
     "Estimate @dfn{quantile regression} (QR) and @dfn{composite quantile
regression} (cqr) and with adaptive lasso penalty using @dfn{interior
point} (IP), @dfn{majorize and minimize} (MM), @dfn{coordinate descent} (CD),
and @dfn{alternating direction method of multipliers algorithms} (ADMM).")
    (license license:gpl2+)))

(define-public r-imifa
  (package
    (name "r-imifa")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "IMIFA" version))
       (sha256
        (base32 "08h53w1axvmvnd4z1nf5bsps5sr6g8a77q6pvg39ss7jcfqm800v"))))
    (properties `((upstream-name . "IMIFA")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-matrixstats
           r-mclust
           r-mvnfast
           r-rfast
           r-slam
           r-viridislite))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=IMIFA")
    (synopsis
     "Infinite mixtures of infinite factor analysers and related models")
    (description
     "This package provides flexible Bayesian estimation of @acronym{IMIFA,
infinite mixtures of infinite factor analysers} and related models, for
nonparametrically clustering high-dimensional data.  The IMIFA model conducts
Bayesian nonparametric model-based clustering with factor analytic covariance
structures without recourse to model selection criteria to choose the number of
clusters or cluster-specific latent factors, mostly via efficient Gibbs updates.
Model-specific diagnostic tools are also provided, as well as many options for
plotting results, conducting posterior inference on parameters of interest,
posterior predictive checking, and quantifying uncertainty.")
    (license license:gpl3+)))

(define-public r-import
  (package
    (name "r-import")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "import" version))
       (sha256
        (base32
         "0ngakg8jqn76c05hrglp4hmmwvm5a9ldc9s1i83a9rc8lni6nb1j"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://github.com/smbache/import")
    (synopsis "Import mechanism for R")
    (description
     "This is an alternative mechanism for importing objects from packages.
The syntax allows for importing multiple objects from a package with a single
command in an expressive way.  The import package bridges some of the gap
between using @code{library} (or @code{require}) and direct (single-object)
imports.  Furthermore the imported objects are not placed in the current
environment.  It is also possible to import objects from stand-alone @code{.R}
files.")
    (license license:expat)))

(define-public r-shinyace
  (package
    (name "r-shinyace")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "shinyAce" version))
       (sha256
        (base32
         "1bb2kjn3ykhz544njx48vanssh4n97kv9r0p4w6ag8ir04mwl8nw"))))
    (properties `((upstream-name . "shinyAce")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-jsonlite r-shiny))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/shinyAce/")
    (synopsis "Ace editor bindings for Shiny")
    (description
     "This package provides Ace editor bindings to enable a rich text editing
environment within Shiny.")
    (license license:expat)))

(define-public r-raceid
  (package
    (name "r-raceid")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "RaceID" version))
       (sha256
        (base32 "00c7bwjamxnhljcdgyb285zwd6sd0x81siva437d2xj21ki6ils1"))))
    (properties `((upstream-name . "RaceID")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster
                             r-coop
                             r-fateid
                             r-fnn
                             r-fpc
                             r-ggplot2
                             r-harmony
                             r-ica
                             r-igraph
                             r-irlba
                             r-leiden
                             r-locfit
                             r-mass
                             r-matrix
                             r-matrixstats
                             r-pheatmap
                             r-princurve
                             r-quadprog
                             r-randomforest
                             r-rcolorbrewer
                             r-rcpp
                             r-rtsne
                             r-runner
                             r-umap
                             r-vegan))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=RaceID")
    (synopsis
     "Algorithm for inferring cell types from single-cell RNA-seq data")
    (description
     "This tool provides an algorithm to identify rare cell types in
single-cell data.  It also identifies abundant cell types.  The method is
based on transcript counts obtained with unique molecular identifies.")
    (license license:gpl3)))

(define-public r-rafalib
  (package
    (name "r-rafalib")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rafalib" version))
       (sha256
        (base32 "04s4xyngki6szlmg0njic97z9g80nfkh2v8g79cck9g2a5x1mbg0"))))
    (properties `((upstream-name . "rafalib")))
    (build-system r-build-system)
    (propagated-inputs (list r-biocmanager r-rcolorbrewer))
    (home-page "https://cran.r-project.org/package=rafalib")
    (synopsis "Convenience functions for routine data exploration")
    (description
     "This package provides a series of shortcuts for routine tasks to
facilitate data exploration.")
    (license license:artistic2.0)))

(define-public r-random
  (package
    (name "r-random")
    (version "0.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "random" version))
       (sha256
        (base32 "0sdhagwjlhldb8hn6h4nd1sflzhwkapzybdlb8hzisy3w2ygjn9b"))))
    (properties `((upstream-name . "random")))
    (build-system r-build-system)
    ;; Vignettes require Internet access.
    (arguments (list #:test-types '(list "tests")))
    (propagated-inputs (list r-curl))
    (home-page "https://www.random.org")
    (synopsis "True random numbers using random.org")
    (description
     "The true random number service provided by the @url{random.org} website
created by Mads Haahr samples atmospheric noise via radio tuned to an unused
broadcasting frequency together with a skew correction algorithm due to John
von Neumann.  More background is available in the included vignette based on
an essay by Mads Haahr.  In its current form, the package offers functions to
retrieve random integers, randomized sequences and random strings.")
    (license license:gpl2+)))

(define-public r-randomizr
  (package
    (name "r-randomizr")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "randomizr" version))
       (sha256
        (base32
         "0r7yawh4dnxawinnlz09f57kgdwa08rpwxq3y35jam3x2q48qijn"))))
    (properties `((upstream-name . "randomizr")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://declaredesign.org/r/randomizr/")
    (synopsis "Tools for common forms of random assignment and sampling")
    (description
     "This package provides tools for generating random assignments for common
experimental designs and random samples for common sampling designs.")
    (license license:expat)))

(define-public r-roi
  (package
    (name "r-roi")
    (version "1.0-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ROI" version))
       (sha256
        (base32 "05hnj9fskfm2klz7zv97lb0r60akjq4a1cay8p62whpi0hri9zyl"))))
    (properties `((upstream-name . "ROI")))
    (build-system r-build-system)
    (propagated-inputs (list r-checkmate r-registry r-slam))
    (native-inputs (list r-r-rsp r-testthat))
    (home-page "https://roi.r-forge.r-project.org/")
    (synopsis "R optimization infrastructure")
    (description
     "The @acronym{ROI, R Optimization Infrastructure} is a framework for handling
optimization problems in R.")
    (license license:gpl3)))

(define-public r-roptim
  (package
    (name "r-roptim")
    (version "0.1.6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "roptim" version))
              (sha256
               (base32
                "11h6qdi0rsv0bpps6nxkzzapan284q0gldzkmgx3ww5kvnic5w3y"))))
    (properties `((upstream-name . "roptim")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs (list r-rcpp r-rcpparmadillo))
    (native-inputs (list r-r-rsp r-testthat))
    (home-page "https://github.com/ypan1988/roptim/")
    (synopsis "General purpose optimization in R using C++")
    (description
     "This package performs optimization in R using C++.  A unified wrapper
interface is provided to call C functions of the five optimization algorithms
(Nelder-Mead, BFGS, CG, L-BFGS-B and SANN) underlying @code{optim()}.")
    (license license:gpl2+)))

(define-public r-base64url
  (package
    (name "r-base64url")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "base64url" version))
       (sha256
        (base32
         "0n1c2b68vza1dh7sk38v6biiwm72c4jpl79kpdg1bsb0hq9qy18x"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-backports))
    (native-inputs
     (list r-base64enc r-checkmate r-knitr r-openssl r-testthat))
    (home-page "https://github.com/mllg/base64url")
    (synopsis "Fast and URL-safe base64 encoder and decoder")
    (description
     "This package provides a URL-safe base64 encoder and decoder.  In
contrast to RFC3548, the 62nd character (@code{+}) is replaced with @code{-},
the 63rd character (@code{/}) is replaced with @code{_}.  Furthermore, the
encoder does not fill the string with trailing @code{=}.  The resulting
encoded strings comply to the regular expression pattern @code{[A-Za-z0-9_-]}
and thus are safe to use in URLs or for file names.  The package also comes
with a simple base32 encoder/decoder suited for case insensitive file
systems.")
    (license license:gpl3)))

(define-public r-baseline
  (package
    (name "r-baseline")
    (version "1.3-5")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "baseline" version))
              (sha256
               (base32
                "0l0llb3pi89ixkpvfg5vbvwwv3gzldf0g98rrd3vkm7q26rqmmd2"))))
    (properties `((upstream-name . "baseline")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-gwidgets2tcltk ;for GUI
           r-limsolve
           r-sparsem))
    (home-page "https://github.com/khliland/baseline/")
    (synopsis "Baseline correction of spectra")
    (description
     "This package is a collection of baseline correction algorithms.  Beside
those it provides a framework and a Tcl/Tk enabled GUI for optimizing baseline
algorithm parameters.  Typical use is the removal of the background effects from
spectra, which are originating from various types of spectroscopy and spectrometry.
Also, there is a possibility of optimizing this with regard to regression or
classification results.  Correction methods include polynomial fitting, weighted
local smoothers and many more.")
    (license license:gpl2)))

(define-public r-radiant-data
  (package
    (name "r-radiant-data")
    (version "1.6.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "radiant.data" version))
       (sha256
        (base32
         "0p55nppclr5dzlslwrhzrg8cc4i0k3ck3076sh2fiay0qi2fh9cm"))
       (modules '((guix build utils)))
       (snippet
        '(delete-file "inst/assets/html2canvas/html2canvas.min.js"))))
    (properties `((upstream-name . "radiant.data")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules
      '((guix build r-build-system)
        (guix build minify-build-system)
        (guix build utils))
      #:imported-modules
      `(,@%r-build-system-modules
        (guix build minify-build-system))
      #:phases
      #~(modify-phases (@ (guix build r-build-system) %standard-phases)
          (add-after 'unpack 'process-javascript
            (lambda* (#:key inputs #:allow-other-keys)
              (with-directory-excursion "inst/assets/html2canvas/"
                (minify (assoc-ref inputs "html2canvas.js")
                        #:target "html2canvas.min.js")))))))
    (propagated-inputs
     (list r-base64enc
           r-broom
           r-bslib
           r-car
           r-curl
           r-dplyr
           r-dt
           r-ggplot2
           r-glue
           r-import
           r-jsonlite
           r-knitr
           r-lubridate
           r-magrittr
           r-markdown
           r-mass
           r-patchwork
           r-plotly
           r-png
           r-psych
           r-randomizr
           r-readr
           r-readxl
           r-rlang
           r-rmarkdown
           r-rstudioapi
           r-scales
           r-shiny
           r-shinyace
           r-shinyfiles
           r-stringi
           r-tibble
           r-tidyr
           r-writexl))
    (native-inputs
     (list esbuild
           (origin
             (method url-fetch)
             (uri "https://web.archive.org/web/20230428182027id_/\
https://html2canvas.hertzen.com/dist/html2canvas.js")
             (sha256
              (base32
               "0svkfnzzsydbsrwi7ky91rjqj97x5rfic69hbr9pwhm0zxlb9i81")))
           r-testthat))
    (home-page "https://github.com/radiant-rstats/radiant.data")
    (synopsis "Data menu for Radiant: business analytics using R and Shiny")
    (description
     "The Radiant Data menu includes interfaces for loading, saving, viewing,
visualizing, summarizing, transforming, and combining data.  It also contains
functionality to generate reproducible reports of the analyses conducted in
the application.")
    (license license:agpl3)))

(define-public r-algdesign
  (package
    (name "r-algdesign")
    (version "1.2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "AlgDesign" version))
       (sha256
        (base32 "09bn1d6naj05hbzkgnkv31s02w5qky74i63k391b4pkc5ahcfbb9"))))
    (properties `((upstream-name . "AlgDesign")))
    (build-system r-build-system)
    (home-page "https://github.com/jvbraun/AlgDesign")
    (synopsis "Algorithmic experimental design")
    (description
     "This package provides tools to calculate exact and approximate theory
experimental designs for D, A, and I criteria.  Very large designs may be
created.  Experimental designs may be blocked or blocked designs created from
a candidate list, using several criteria.  The blocking can be done when whole
and within plot factors interact.")
    (license license:gpl2+)))

(define-public r-alluvial
  (package
    (name "r-alluvial")
    (version "0.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "alluvial" version))
       (sha256
        (base32 "039frwrsxq1lb97s7vf2vbyyadimkigs628ymym06fxka53drdkp"))))
    (properties `((upstream-name . "alluvial")))
    (build-system r-build-system)
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/mbojan/alluvial")
    (synopsis "Create parallel sets plots (Alluvial Diagrams)")
    (description
     "This package creates alluvial diagrams (also known as parallel sets
plots) for multivariate and time series-like data.")
    (license license:expat)))

(define-public r-signal
  (package
    (name "r-signal")
    (version "1.8-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "signal" version))
       (sha256
        (base32
         "1c7fw5akdm8f44zgdafsgz2fpn6kfwifaw29yakl7zykq89vq8m3"))))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list gfortran r-pracma))
    (home-page "https://cran.r-project.org/web/packages/signal/")
    (synopsis "Signal processing")
    (description
     "This package provides a set of signal processing functions originally
written for Matlab and GNU Octave.  It includes filter generation utilities,
filtering functions, resampling routines, and visualization of filter models.
It also includes interpolation functions.")
    (license license:gpl2)))

(define-public r-simdesign
  (package
    (name "r-simdesign")
    (version "2.19.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SimDesign" version))
       (sha256
        (base32 "1pcmkkvlg4qabl06s0k2bmpi2andqf4wfpr3vnb9fmcy9dfdf7dw"))))
    (properties
     '((upstream-name . "SimDesign")
       ;; Not packaged, but also not required.
       (updater-ignored-native-inputs . ("r-dompi"))))
    (build-system r-build-system)
    (propagated-inputs (list r-beepr
                             r-dplyr
                             r-future
                             r-future-apply
                             r-parallelly
                             r-pbapply
                             r-progressr
                             r-r-utils
                             r-sessioninfo
                             r-testthat))
    (native-inputs (list r-httr r-knitr r-mockery))
    (home-page "http://philchalmers.github.io/SimDesign/")
    (synopsis "Structure for organizing Monte Carlo simulation designs")
    (description
     "This package provides tools to safely and efficiently organize and
execute Monte Carlo simulation experiments in R.  The package controls the
structure and back-end of Monte Carlo simulation experiments by utilizing a
generate-analyse-summarise workflow.  The workflow safeguards against common
simulation coding issues, such as automatically re-simulating non-convergent
results, prevents inadvertently overwriting simulation files, catches error
and warning messages during execution, implicitly supports parallel processing
with high-quality random number generation, and provides tools for managing
high-performance computing (HPC) array jobs submitted to schedulers such as
SLURM. For a pedagogical introduction to the package see Sigal and Chalmers
(2016) <doi:10.1080/10691898.2016.1246953>.  For a more in-depth overview of
the package and its design philosophy see Chalmers and Adkins (2020)
<doi:10.20982/tqmp.16.4.p248>.")
    (license license:gpl2+)))

(define-public r-simplermarkdown
  (package
    (name "r-simplermarkdown")
    (version "0.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "simplermarkdown" version))
       (sha256
        (base32 "0lffwsrhsdqcqhklh24v0y0x6w4vq9jch93m330kfdv2amab1l06"))))
    (properties `((upstream-name . "simplermarkdown")))
    (build-system r-build-system)
    (propagated-inputs
     ;; We cannot patch references to pandoc because the patched files are
     ;; compiled to an opaque rdb/rdx pair.  "guix gc" would not be able to
     ;; find the patched references in those files.
     (list pandoc
           r-rjson))
    ;; For tests
    (native-inputs (list r-mass))
    (home-page "https://github.com/djvanderlaan/simplermarkdown")
    (synopsis "Simple engine for generating reports using R")
    (description
     "This package runs R-code present in a pandoc markdown file and includes
the resulting output in the resulting markdown file.  This file can then be
converted into any of the output formats supported by pandoc.  The package can
also be used as an engine for writing package vignettes.")
    (license license:gpl3+)))

(define-public r-sitar
  (package
    (name "r-sitar")
    (version "1.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sitar" version))
       (sha256
        (base32 "14qc5qy21qyj4gml0gwfn8izbsmzwy30ddc7mazhszi487jrcrp0"))))
    (properties `((upstream-name . "sitar")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-forcats
           r-ggplot2
           r-glue
           r-magrittr
           r-nlme
           r-purrr
           r-rlang
           r-rsample
           r-tibble
           r-tidyr))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/statist7/sitar")
    (synopsis "Super imposition by translation and rotation growth curve analysis")
    (description
     "This package provides functions for fitting and plotting @acronym{SITAR, Super
Imposition by Translation And Rotation} growth curve models.  SITAR is a shape-
invariant model with a regression B-spline mean curve and subject-specific random
effects on both the measurement and age scales.")
    (license license:gpl2+)))

(define-public r-gsubfn
  (package
    (name "r-gsubfn")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gsubfn" version))
       (sha256
        (base32
         "00j6b8b6xsx6v370h220x233rpk6asca78165y3d48jpwvwisdc9"))))
    (build-system r-build-system)
    (propagated-inputs (list r-proto))
    (home-page "https://code.google.com/archive/p/gsubfn/")
    (synopsis "Utilities for strings and function arguments")
    (description
     "This package provides @code{gsubfn} which is like @code{gsub} but can
take a replacement function or certain other objects instead of the
replacement string.  Matches and back references are input to the replacement
function and replaced by the function output.  @code{gsubfn} can be used to
split strings based on content rather than delimiters and for quasi-perl-style
string interpolation.  The package also has facilities for translating
formulas to functions and allowing such formulas in function calls instead of
functions.")
    (license license:gpl2+)))

(define-public r-sqldf
  (package
    (name "r-sqldf")
    (version "0.4-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sqldf" version))
       (sha256
        (base32
         "0q12vsb53p2wchgp8wfz5bk08wfnm0jxjrakclj4jyy6x3a7ksff"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-chron r-dbi r-gsubfn r-proto r-rsqlite))
    (native-inputs (list r-svunit))
    (home-page "https://github.com/ggrothendieck/sqldf")
    (synopsis "Manipulate R data frames using SQL")
    (description
     "The @code{sqldf} function is typically passed a single argument which is
an SQL select statement where the table names are ordinary R data frame names.
@code{sqldf} transparently sets up a database, imports the data frames into
that database, performs the SQL statement and returns the result using a
heuristic to determine which class to assign to each column of the returned
data frame.  The @code{sqldf} or @code{read.csv.sql} functions can also be
used to read filtered files into R even if the original files are larger than
R itself can handle.")
    (license license:gpl2)))

(define-public r-abind
  (package
    (name "r-abind")
    (version "1.4-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abind" version))
       (sha256
        (base32
         "1q934vfyvszmy6nv13dchv2mbsj9i5vffy88b9wy3siwa8dhaji6"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abind/")
    (synopsis "Combine multidimensional arrays")
    (description
     "This package provides tools to combine multidimensional arrays into a
single array.  This is a generalization of @code{cbind} and @code{rbind}.  It
works with vectors, matrices, and higher-dimensional arrays.  It also provides
the functions @code{adrop}, @code{asub}, and @code{afill} for manipulating,
extracting and replacing data in arrays.")
    (license license:lgpl2.0+)))

(define-public r-prroc
  (package
    (name "r-prroc")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PRROC" version))
       (sha256
        (base32
         "1dlknj6q67iq4xmxj7lz8mz1hsy9qiiy4px0h7raidgckdx4mfwx"))))
    (properties `((upstream-name . "PRROC")))
    (build-system r-build-system)
    (native-inputs (list r-ggplot2 r-testthat))
    (home-page "https://cran.r-project.org/web/packages/PRROC/")
    (synopsis "Precision-Recall and ROC curves for weighted and unweighted data")
    (description
     "This package computes the areas under the @dfn{precision-recall} (PR)
and ROC curve for weighted (e.g. soft-labeled) and unweighted data.  In
contrast to other implementations, the interpolation between points of the PR
curve is done by a non-linear piecewise function.  In addition to the areas
under the curves, the curves themselves can also be computed and plotted by a
specific S3-method.")
    (license license:gpl3)))

(define-public r-vim
  (package
    (name "r-vim")
    (version "6.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "VIM" version))
       (sha256
        (base32
         "1r0myxcx8y1a3fkf9ssk882f09snn2j6zilsygpld32hahn4k9xg"))))
    (properties `((upstream-name . "VIM")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-colorspace
           r-data-table
           r-e1071
           r-laeken
           r-magrittr
           r-mass
           r-nnet
           r-ranger
           r-rcpp
           r-robustbase
           r-sp
           r-vcd))
    (native-inputs
     (list r-knitr))
    (home-page "https://github.com/alexkowa/VIM")
    (synopsis "Visualization and imputation of missing values")
    (description
     "This package provides tools for the visualization of missing and/or
imputed values are introduced, which can be used for exploring the data and
the structure of the missing and/or imputed values.  Depending on this
structure of the missing values, the corresponding methods may help to
identify the mechanism generating the missing values and explore the
data including missing values.  In addition, the quality of imputation can be
visually explored using various univariate, bivariate, multiple and
multivariate plot methods.")
    (license license:gpl2+)))

(define-public r-fnn
  (package
    (name "r-fnn")
    (version "1.1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FNN" version))
       (sha256
        (base32
         "0m5q1jkyxynjgzakzn48aqxr5cc92sgl7z9j1zlqmb1yzn3p9nbk"))))
    (properties `((upstream-name . "FNN")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/FNN")
    (synopsis "Fast nearest neighbor search algorithms and applications")
    (description
     "This package provides cover-tree and kd-tree fast k-nearest neighbor
search algorithms.  Related applications including KNN classification,
regression and information measures are implemented.")
    ;; The DESCRIPTION file erroneously states that GPL version 2.1 or
    ;; later can be used.
    (license license:gpl2+)))

(define-public r-smoother
  (package
    (name "r-smoother")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "smoother" version))
       (sha256
        (base32
         "0xw28qv8f5i05ajx32njnql6hql5njqyc47wcq6c75cxiv44ppz8"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ttr))
    (home-page "https://cran.r-project.org/web/packages/smoother")
    (synopsis "Functions relating to the smoothing of numerical data")
    (description
     "This package provides a collection of methods for smoothing numerical
data, commencing with a port of the Matlab gaussian window smoothing function.
In addition, several functions typically used in smoothing of financial data
are included.")
    (license license:gpl2)))

(define-public r-riverplot
  (package
    (name "r-riverplot")
    (version "0.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "riverplot" version))
       (sha256
        (base32
         "04ap1dsa7fx03l73jhv1ql3adaaaz2100qawdplxa9xmrllgcgbj"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer))
    (native-inputs
     (list r-knitr))
    (home-page "https://logfc.wordpress.com")
    (synopsis "Sankey or ribbon plots")
    (description
     "Sankey plots are a type of diagram that is convenient to illustrate how
flow of information, resources etc. separates and joins, much like observing
how rivers split and merge.  For example, they can be used to compare
different clusterings.  This package provides an implementation of Sankey
plots for R.")
    (license license:gpl2+)))

(define-public r-dyn
  (package
    (name "r-dyn")
    (version "0.2-9.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dyn" version))
       (sha256
        (base32
         "16fqv9k7yxdgybwzafjkyqm16qpgqz13lcjpi6a1nc8xbzlzh0gb"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-zoo))
    (native-inputs (list r-sandwich))
    (home-page "https://cran.r-project.org/web/packages/dyn")
    (synopsis "Time series regression")
    (description
     "This package provides the dyn class interfaces @code{ts}, @code{irts},
@code{zoo} and @code{zooreg} time series classes to @code{lm}, @code{glm},
@code{loess}, @code{quantreg::rq}, @code{MASS::rlm},
@code{MCMCpack::MCMCregress()}, @code{quantreg::rq()},
@code{randomForest::randomForest()} and other regression functions, allowing
those functions to be used with time series including specifications that may
contain lags, diffs and missing values.")
    ;; Any GPL version.
    (license license:gpl2+)))

(define-public r-dyngen
  (package
    (name "r-dyngen")
    (version "1.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dyngen" version))
       (sha256
        (base32
         "095jqn1rd83qm3ayca9hmv6bhlaa2c338020l46vniq8n38kbnra"))))
    (properties `((upstream-name . "dyngen")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; For vignette builder.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-assertthat
           r-dplyr
           r-dynutils
           r-ggplot2
           r-ggraph
           r-ggrepel
           r-gillespiessa2
           r-igraph
           r-lmds
           r-matrix
           r-patchwork
           r-pbapply
           r-purrr
           r-rlang
           r-tibble
           r-tidygraph
           r-tidyr
           r-viridis))
    (native-inputs (list r-r-rsp r-testthat))
    (home-page "https://github.com/dynverse/dyngen")
    (synopsis "Multi-Modal simulator for single-cell omics analyses")
    (description
     "This package provides a multi-modal simulation engine for studying
dynamic cellular processes at single-cell resolution.")
    (license license:expat)))

(define-public r-dynutils
  (package
    (name "r-dynutils")
    (version "1.0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dynutils" version))
       (sha256
        (base32 "06an2bm1d131v28m240vii2wisbz3zs32wbamm2w7r8rl3yrxkh9"))))
    (properties `((upstream-name . "dynutils")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-crayon
           r-desc
           r-dplyr
           r-magrittr
           r-matrix
           r-proxyc
           r-purrr
           r-rcpp
           r-remotes
           r-stringr
           r-tibble))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/dynverse/dynutils")
    (synopsis "Common functionality for the dynverse packages")
    (description
     "This package provides common functionality for the
@url{https://dynverse.org,dynverse} packages.  dynverse is created to support
the development, execution, and benchmarking of trajectory inference
methods.")
    (license license:expat)))

(define-public r-catdap
  (package
    (name "r-catdap")
    (version "1.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "catdap" version))
       (sha256
        (base32
         "0z84bx808hy70bkzdda9l42ljh9i9pz07isxq756axi7nr0ky6p9"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcolorbrewer))
    (native-inputs
     (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/catdap/")
    (synopsis "Tools for categorical data analysis")
    (description
     "This package provides functions for analyzing multivariate data.
Dependencies of the distribution of the specified variable (response
variable) to other variables (explanatory variables) are derived and
evaluated by the @dfn{Akaike Information Criterion} (AIC).")
    (license license:gpl2+)))

(define-public r-catdata
  (package
    (name "r-catdata")
    (version "1.2.4")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "catdata" version))
              (sha256
               (base32
                "1gvibnjfrjdsxx4jks29hhk3dfsm23nxnbwd5p8w67nxr4n6qn0w"))))
    (properties `((upstream-name . "catdata")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=catdata")
    (synopsis
     "Datasets and examples used in the book @emph{Regression for Categorical Data}")
    (description
     "This R package contains examples from the book @emph{Regression
for Categorical Data}, Tutz 2012, Cambridge University Press.  The
names of the examples refer to the chapter and the data set that is
used.")
    (license license:gpl2)))

(define-public r-arules
  (package
    (name "r-arules")
    (version "1.7-11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "arules" version))
       (sha256
        (base32
         "0p4rxd4k7j1nhz05zw2w0rqiryvrw75gcga2nrmmmp7ghd42g527"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-generics r-matrix))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/mhahsler/arules")
    (synopsis "Mining association rules and frequent itemsets")
    (description
     "This package provides an infrastructure for representing, manipulating
and analyzing transaction data and patterns (frequent itemsets and association rules).
It also provides C implementations of the association mining algorithms Apriori
and Eclat.")
    (license license:gpl3)))

(define-public r-parsedate
  (package
    (name "r-parsedate")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parsedate" version))
       (sha256
        (base32
         "0w0phy4jrhh14la507p9051skmmymbdza8kz8jpvhvkg81sdrd79"))))
    (properties
     '((updater-extra-native-inputs . ("tzdata-for-tests"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'install 'set-timezone
           (lambda* (#:key inputs #:allow-other-keys)
             (setenv "TZ" "UTC")
             (setenv "TZDIR"
                     (search-input-directory inputs
                                             "share/zoneinfo")))))))
    (native-inputs (list r-testthat r-withr tzdata-for-tests))
    (home-page "https://github.com/gaborcsardi/parsedate")
    (synopsis
     "Recognize and parse dates in various formats")
    (description
     "This package provides three functions for dealing with dates:
@code{parse_iso_8601} recognizes and parses all valid ISO 8601 date and
time formats, @code{parse_date} parses dates in unspecified formats,
and @code{format_iso_8601} formats a date in ISO 8601 format.")
    (license license:gpl2)))

(define-public r-adbcdrivermanager
  (package
    (name "r-adbcdrivermanager")
    (version "0.18.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "adbcdrivermanager" version))
       (sha256
        (base32 "16zfwk1cl76ah80q62xbrri96d4dhmi9z6674478dsnnfpqvxqh2"))))
    (properties `((upstream-name . "adbcdrivermanager")))
    (build-system r-build-system)
    (propagated-inputs (list r-nanoarrow))
    (native-inputs (list r-testthat))
    (home-page "https://arrow.apache.org/adbc/current/r/adbcdrivermanager/")
    (synopsis "Arrow Database Connectivity (ADBC) driver manager")
    (description
     "This package provides a developer-facing interface to Arrow Database
Connectivity (ADBC) for the purposes of driver development, driver testing,
and building high-level database interfaces for users.  ADBC is an API
standard for database access libraries that uses Arrow for result sets and
query parameters.")
    (license license:asl2.0)))

(define-public r-abc-data
  (package
    (name "r-abc-data")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abc.data" version))
       (sha256
        (base32
         "0zdhrnhvgnk3lp18cxgzsxa38xr7pl55g48pk373q1d6h77qbmj8"))))
    (properties `((upstream-name . "abc.data")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abc.data/")
    (synopsis "Data for Approximate Bayesian Computation (ABC) package")
    (description
     "This package contains data which are used by functions of the abc
package which implements several @dfn{Approximate Bayesian Computation} (ABC)
algorithms for performing parameter estimation, model selection, and
goodness-of-fit.")
    (license license:gpl3+)))

(define-public r-abc
  (package
    (name "r-abc")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abc" version))
       (sha256
        (base32
         "15a15y2pvrg2d7bjsavrq1wgz2fx21wa2lrzxiz6w3mp3ks1k55w"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abc-data r-locfit r-mass r-nnet r-quantreg))
    (home-page "https://cran.r-project.org/web/packages/abc/")
    (synopsis "Tools for Approximate Bayesian Computation (ABC)")
    (description
     "This package implements several @dfn{Approximate Bayesian
Computation} (ABC) algorithms for performing parameter estimation, model
selection, and goodness-of-fit.  Cross-validation tools are also available for
measuring the accuracy of ABC estimates, and to calculate the
misclassification probabilities of different models.")
    (license license:gpl3+)))

(define-public r-zip
  (package
    (name "r-zip")
    (version "2.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "zip" version))
       (sha256
        (base32
         "0lls4hllimjnl9bhr31y9x3fj8vdszxbaj6p781kgfdpz0j0nifh"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat r-withr))
    (home-page "https://github.com/gaborcsardi/zip")
    (synopsis "Cross-platform Zip compression")
    (description
     "This package provides a cross-platform Zip compression library for R.
It is a replacement for the @code{zip} function, that does not require any
additional external tools on any platform.")
    (license license:cc0)))

(define-public r-openai
  (package
    (name "r-openai")
    (version "0.4.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "openai" version))
              (sha256
               (base32
                "1fi1nc9c7kfnig6b5ifpb1v9r3gxszk984rwyq7i1lb6s5jv0b9z"))))
    (properties
     '((upstream-name . "openai")
       (updater-extra-native-inputs . ("r-purrr"))))
    (build-system r-build-system)
    (propagated-inputs (list r-assertthat
                             r-glue
                             r-httr
                             r-jsonlite
                             r-lifecycle
                             r-magrittr))
    (native-inputs (list r-purrr r-testthat))
    (home-page "https://github.com/irudnyts/openai")
    (synopsis "R Wrapper for OpenAI API")
    (description
     "This package provides an R wrapper of OpenAI API endpoints (see
@url{https://platform.openai.com/docs/introduction} for details).  This
package covers Models, Completions, Chat, Edits, Images, Embeddings, Audio,
Files, Fine-tunes, Moderations, and legacy Engines endpoints.")
    (license license:expat)))

(define-public r-operator-tools
  (package
    (name "r-operator-tools")
    (version "1.6.3")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "operator.tools" version))
              (sha256
               (base32
                "1v4dg7xhz24dnp0zxn815x1405ig64ibii6y40la1gvmzcc41dz5"))))
    (properties `((upstream-name . "operator.tools")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/decisionpatterns/operator.tools")
    (synopsis "Utilities for working with R's operators")
    (description
     "This package provides a collection of utilities that allow programming
with R's operators.  Routines allow classifying operators, translating to and
from an operator and its underlying function, and inverting some
operators (e.g. comparison operators), etc.  All methods can be extended to
custom infix operators.")
    (license license:gpl2)))

(define-public r-openxlsx
  (package
    (name "r-openxlsx")
    (version "4.2.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "openxlsx" version))
       (sha256
        (base32
         "1n74jxjvqzyvxg39qvjwsq2csl843ircdxw2ypanqzv7ifmn224a"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-stringi r-zip))
    (native-inputs
     (list r-knitr r-testthat r-writexl))
    (home-page "https://github.com/awalker89/openxlsx")
    (synopsis "Read, write and edit XLSX files")
    (description
     "This package simplifies the creation of Excel @code{.xlsx} files by
providing a high level interface to writing, styling and editing worksheets.
Through the use of Rcpp, read/write times are comparable to the @code{xlsx}
and @code{XLConnect} packages with the added benefit of removing the
dependency on Java.")
    (license license:gpl3)))

(define-public r-rio
  (package
    (name "r-rio")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rio" version))
       (sha256
        (base32
         "1annh9zsfskizr2idylgvqm41cfzldn56bh9vkzxqqvznka7k123"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'find-zip
           (lambda _
             (setenv "R_ZIPCMD" (which "zip")))))))
    (propagated-inputs
     (list r-curl
           r-data-table
           r-foreign
           r-haven
           r-lifecycle
           r-r-utils
           r-readr
           r-readxl
           r-tibble
           r-writexl))
    (native-inputs
     (list r-knitr r-stringi r-testthat r-xml2 zip))
    (home-page "https://github.com/leeper/rio")
    (synopsis "Swiss-army knife for data I/O")
    (description
     "This package provides streamlined data import and export infrastructure
by making assumptions that the user is probably willing to make: @code{import}
and @code{export} determine the data structure from the file extension,
reasonable defaults are used for data import and export (e.g.,
@code{stringsAsFactors=FALSE}), web-based import is natively
supported (including from SSL/HTTPS), compressed files can be read directly
without explicit decompression, and fast import packages are used where
appropriate.  An additional convenience function, @code{convert}, provides a
simple method for converting between file types.")
    (license license:gpl2)))

(define-public r-maptools
  (package
    (name "r-maptools")
    (version "1.1-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "maptools" version))
       (sha256
        (base32
         "1xz0cqg629vz7mawwxx650mgmvh3wzn25rnxy4sij5jrypipk1ay"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-Calloc
           (lambda _
             (substitute* "src/pip.c"
               (("# include <R.h>") "# include <R.h>\n# include <R_ext/RS.h>")
               (("Calloc") "R_Calloc")
               (("Free") "R_Free")))))))
    (propagated-inputs
     (list r-foreign r-lattice r-sp))
    (home-page "https://r-forge.r-project.org/projects/maptools/")
    (synopsis "Tools for reading and handling spatial objects")
    (description
     "This package provides a set of tools for manipulating and reading
geographic data, in particular ESRI Shapefiles.  It includes binary access to
GSHHG shoreline files.  The package also provides interface wrappers for
exchanging spatial objects with other R packages.")
    ;; The C source files from shapelib are released under the Expat license.
    ;; The R code is released under GPL version 2 or later.
    (license (list license:gpl2+
                   license:expat))))

(define-public r-maptree
  (package
    (name "r-maptree")
    (version "1.4-8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "maptree" version))
              (sha256
               (base32
                "1x35nk4fi2b62krcvcv187n5sbqrgvw4pbm7r19ps3jlanpi5ksm"))))
    (properties `((upstream-name . "maptree")))
    (build-system r-build-system)
    (propagated-inputs (list r-cluster r-rpart))
    (home-page "https://cran.r-project.org/package=maptree")
    (synopsis "Mapping, pruning, and graphing tree models")
    (description
     "This package provides a set of functions with example data for graphing,
pruning, and mapping models.  These models are from hierarchical clustering,
and classification and regression trees.")
    ;; Unlimited distribution; see
    ;; https://cran.r-project.org/web/packages/maptree/index.html
    (license (license:non-copyleft "file://DESCRIPTION"))))

(define-public r-later
  (package
    (name "r-later")
    (version "1.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "later" version))
       (sha256
        (base32
         "1lrllkh60hn8857hdyscmi0qj9jrsyjaz4w4ls0ykqbx4awj3yay"))))
    (properties
     ;; Not packaged and not needed.
     '((updater-extra-native-inputs . ("r-nanonext"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-rlang))
    (native-inputs
     (list r-knitr r-r6 r-testthat))
    (home-page "https://github.com/r-lib/later")
    (synopsis "Utilities for delaying function execution")
    (description
     "This package provides tools to execute arbitrary R or C functions some
time after the current time, after the R execution stack has emptied.")
    (license license:gpl2+)))

(define-public r-promises
  (package
    (name "r-promises")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "promises" version))
       (sha256
        (base32
         "07k4qd01kkjl983lvhnh3mcqa0ahdbpzm0ds0qfjpxphidl5g8j6"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-fastmap
           r-later
           r-magrittr
           r-r6
           r-rcpp
           r-rlang))
    (native-inputs
     (list r-future r-knitr r-spelling r-testthat))
    (home-page "https://rstudio.github.io/promises")
    (synopsis "Abstractions for promise-based asynchronous programming")
    (description
     "This package provides fundamental abstractions for doing asynchronous
programming in R using promises.  Asynchronous programming is useful for
allowing a single R process to orchestrate multiple tasks in the background
while also attending to something else.  Semantics are similar to JavaScript
promises, but with a syntax that is idiomatic R.")
    (license license:expat)))

(define-public r-dosnow
  (package
    (name "r-dosnow")
    (version "1.0.20")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doSNOW" version))
       (sha256
        (base32
         "1f5v0k2w0b2478p6iqa3hn2lwd1x3rzc348n57nd38ka2vnsnz4i"))))
    (properties `((upstream-name . "doSNOW")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach r-iterators r-snow))
    (native-inputs (list r-runit))
    (home-page "https://cran.r-project.org/web/packages/doSNOW")
    (synopsis "Foreach parallel adaptor for the snow package")
    (description
     "This package provides a parallel backend for the @code{%dopar%} function
using the @code{snow} package.")
    (license license:gpl2)))

(define-public r-flexparamcurve
  (package
    (name "r-flexparamcurve")
    (version "1.5-6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FlexParamCurve" version))
       (sha256
        (base32 "0p0c949cdb05r6xnjc7k1i47z809g4mda1l94q7f4dikpnl1h2zd"))))
    (properties `((upstream-name . "FlexParamCurve")))
    (build-system r-build-system)
    (propagated-inputs (list r-nlme))
    (home-page "https://pennstate.academia.edu:443/SteveOswald")
    (synopsis "Tools to fit flexible parametric curves")
    (description
     "This package provides model selection tools and @code{selfStart}
functions to fit parametric curves in the nls, @code{nlsList} and nlme
frameworks.")
    (license license:gpl2)))

(define-public r-fsa
  (package
    (name "r-fsa")
    (version "0.10.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "FSA" version))
              (sha256
               (base32
                "0hdmg4wjrrmng2bnr7h1x39iand34navl34vvngbcfcyjy5li407"))))
    (properties
     '((upstream-name . "FSA")))
    (build-system r-build-system)
    (propagated-inputs (list r-car
                             r-dunn-test
                             r-flexparamcurve
                             r-lmtest
                             r-plotrix
                             r-purrr
                             r-withr))
    (native-inputs (list r-desctools
                         r-fishmethods
                         r-fsadata
                         r-nlme
                         r-psych
                         r-testthat
                         r-tibble))
    (home-page "https://fishr-core-team.github.io/FSA/")
    (synopsis "Simple fisheries stock assessment methods")
    (description
     "This package provides a variety of simple fish stock assessment
methods.")
    (license license:gpl2+)))

(define-public r-fsadata
  (package
    (name "r-fsadata")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FSAdata" version))
       (sha256
        (base32 "0zh0gkylziysqjc9gn3kjz7070x2rvmi1c64kxl6q2479929hysi"))))
    (properties `((upstream-name . "FSAdata")))
    (build-system r-build-system)
    (home-page "https://fishr-core-team.github.io/FSAdata/")
    (synopsis "Data to support the fish stock assessment package")
    (description
     "This package provides the datasets to support the Fish Stock
Assessment (FSA) package.")
    (license license:gpl2+)))

(define-public r-fstcore
  (package
    (name "r-fstcore")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fstcore" version))
       (sha256
        (base32 "1k6rm3vq26v8by1wwdrw7m0d2dlxrdjhc43x79bdmk2x55nrg7hy"))))
    (properties `((upstream-name . "fstcore")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (inputs (list zlib))
    (native-inputs (list pkg-config r-lintr r-testthat))
    (home-page "https://www.fstpackage.org/fstcore/")
    (synopsis "R bindings to the fstlib library")
    (description
     "The fstlib library provides multithreaded serialization of compressed
data frames using the fst format.  The fst format allows for random access of
stored data and compression with the LZ4 and ZSTD compressors.")
    (license license:mpl2.0)))

(define-public r-fst
  (package
    (name "r-fst")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fst" version))
       (sha256
        (base32
         "0r96inwrr960m7wmc80603bw2vvvwab225bh9dq3lalwhy4yiis4"))))
    (properties `((upstream-name . "fst")))
    (build-system r-build-system)
    (propagated-inputs (list r-fstcore r-rcpp))
    (native-inputs (list r-data-table r-testthat))
    (home-page "https://www.fstpackage.org")
    (synopsis "Fast serialization of data frames")
    (description
     "The fst package for R provides a fast, easy and flexible way to
serialize data frames.  With access speeds of multiple GB/s, fst is
specifically designed to unlock the potential of high speed solid state disks.
Data frames stored in the fst format have full random access, both in column
and rows.  The fst format allows for random access of stored data and
compression with the LZ4 and ZSTD compressors.")
    (license license:agpl3)))

(define-public r-snftool
  (package
    (name "r-snftool")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "SNFtool" version))
              (sha256
               (base32
                "05hz230aq5wbzhknxzr4iqv3nqjhbpf66n6bp1rc5h2jgz2yfbwq"))))
    (properties `((upstream-name . "SNFtool")))
    (build-system r-build-system)
    (propagated-inputs (list r-alluvial r-exposition))
    (home-page "https://cran.r-project.org/package=SNFtool")
    (synopsis "Similarity network fusion")
    (description
     "Similarity Network Fusion takes multiple views of a network and fuses
them together to construct an overall status matrix.  The input to our
algorithm can be feature vectors, pairwise distances, or pairwise
similarities.  The learned status matrix can then be used for retrieval,
clustering, and classification.")
    ;; Any version of the GPL
    (license license:gpl3+)))

(define-public r-snowfall
  (package
   (name "r-snowfall")
   (version "1.84-6.3")
   (source (origin
            (method url-fetch)
            (uri (cran-uri "snowfall" version))
            (sha256
             (base32 "0hxip3rzv7slxvif1000avbcid2mjxj1y9mimyvk87h404mr6h96"))))
   (build-system r-build-system)
   (propagated-inputs
    (list r-snow))
   (home-page "https://cran.r-project.org/web/packages/snowfall/")
   (synopsis "Easier cluster computing")
   (description "This package is a usability wrapper around snow for easier
development of parallel R programs.  This package offers e.g. extended error
checks, and additional functions.  All functions work in sequential mode, too,
if no cluster is present or wished.  The package is also designed as connector
to the cluster management tool @code{sfCluster}, but can also used without
it.")
   (license license:gpl2+)))

(define-public r-rgenoud
  (package
    (name "r-rgenoud")
    (version "5.9-0.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgenoud" version))
       (sha256
        (base32 "12pf7kvyvly0aqrk84k07cx7gnqmnrpfzs41ys960gx70lzf77f6"))))
    (properties `((upstream-name . "rgenoud")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/JasjeetSekhon/rgenoud")
    (synopsis "R version of genetic optimization using derivatives")
    (description
     "This package provides a genetic algorithm plus derivative optimizer.")
    (license license:gpl3)))

(define-public r-rgexf
  (package
    (name "r-rgexf")
    (version "0.16.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rgexf" version))
       (sha256
        (base32
         "1c1rqgr7qsj61gp2frm197k396xfdspvmmwr56izwb09225cbp6d"))
       ;; Delete minified JavaScript files
       (snippet
        '(for-each delete-file
                   '("inst/gexf-js/js/jquery-2.0.2.min.js"
                     "inst/gexf-js/js/jquery-ui-1.10.3.custom.min.js"
                     "inst/gexf-js/js/jquery.mousewheel.min.js")))))
    (properties `((upstream-name . "rgexf")))
    (build-system r-build-system)
    (arguments
     `(#:modules ((guix build utils)
                  (guix build r-build-system)
                  (srfi srfi-1)
                  (ice-9 popen))
       #:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (invoke "unzip" "-d" "/tmp" (assoc-ref inputs "js-jquery-ui"))
             (with-directory-excursion "inst/gexf-js/js/"
               (call-with-values
                   (lambda ()
                     (unzip2
                      `((,(assoc-ref inputs "js-jquery")
                         "jquery-2.0.2.min.js")
                        ("/tmp/jquery-ui-1.10.3/ui/jquery-ui.js"
                         "jquery-ui-1.10.3.custom.min.js")
                        (,(assoc-ref inputs "js-jquery-mousewheel")
                         "jquery.mousewheel.min.js"))))
                 (lambda (sources targets)
                   (for-each (lambda (source target)
                               (format #true "Processing ~a --> ~a~%"
                                       source target)
                               (invoke "esbuild" source "--minify"
                                       (string-append "--outfile=" target)))
                             sources targets)))))))))
    (propagated-inputs
     (list r-igraph r-servr r-xml))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("esbuild" ,esbuild)
       ("unzip" ,unzip)
       ("js-jquery"
        ,(origin
           (method url-fetch)
           (uri "https://code.jquery.com/jquery-2.0.2.js")
           (sha256
            (base32
             "0v818bxpw48gdk8i95qqqij80r9jcgisi2r4ac6xnxca20h0gvfj"))))
       ("js-jquery-ui"
        ,(origin
           (method url-fetch)
           (uri "https://jqueryui.com/resources/download/jquery-ui-1.10.3.zip")
           (sha256
            (base32
             "00xpfy0l69nj2yan4s8k65ldsrlfsjkmyw2dwcg93dc8mv454vxx"))))
       ("js-jquery-mousewheel"
        ,(origin
           (method url-fetch)
           (uri "https://raw.githubusercontent.com/jquery/jquery-mousewheel/\
3.0.6/jquery.mousewheel.js")
           (sha256
            (base32
             "19lk5xy2s47bx8hsa7j6bg012f8yw6d770g230bcnm559kf4nc6v"))))))
    (home-page "https://gvegayon.github.io/rgexf")
    (synopsis "Build, import and export GEXF graph files")
    (description
     "Create, read and write GEXF (Graph Exchange XML Format) graph
files (used in Gephi and others).  It allows the user to easily build/read
graph files including attributes, GEXF visual attributes (such as color, size,
and position), network dynamics (for both edges and nodes) and edge weighting.
Users can build/handle graphs element-by-element or massively through
data-frames, visualize the graph on a web browser through gexf-js (a
JavaScript library) and interact with the igraph package.")
    (license license:expat)))

(define-public r-data-tree
  (package
    (name "r-data-tree")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "data.tree" version))
       (sha256
        (base32
         "0qxd1g159phc6f18iddjljdg96sh09w63xqawjwbwyhg4blm9ddh"))))
    (properties `((upstream-name . "data.tree")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; This test requires DiagrammeR, which we cannot add to Guix
             ;; because of massive amounts of minified JavaScript.
             (substitute* "tests/testthat/test-draw.R"
               ((".*grViz names with quotes.*" m)
                (string-append m "skip('skip');\n"))))))))
    (propagated-inputs
     (list r-r6 r-stringi))
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://github.com/gluc/data.tree")
    (synopsis "General purpose hierarchical data structure")
    (description
     "Create tree structures from hierarchical data, and traverse the tree in
various orders.  Aggregate, cumulate, print, plot, convert to and from
data.frame and more.  This is useful for decision trees, machine learning,
finance, conversion from and to JSON, and many other applications.")
    (license license:gpl2+)))

(define-public r-dtplyr
  (package
    (name "r-dtplyr")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "dtplyr" version))
       (sha256
        (base32
         "1rfnr1f3dzzivzmw9jjaclckkany6c625bqr8lkx32qbcjd6iad5"))))
    (properties `((upstream-name . "dtplyr")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-data-table
           r-dplyr
           r-glue
           r-lifecycle
           r-rlang
           r-tibble
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list r-knitr r-testthat r-tidyr))
    (home-page "https://github.com/tidyverse/dtplyr")
    (synopsis "Data Table back-end for dplyr")
    (description
     "This package provides a @code{data.table} backend for @code{dplyr}.  The
goal of @code{dtplyr} is to allow you to write @code{dplyr} code that is
automatically translated to the equivalent, but usually much faster,
@code{data.table} code.")
    (license license:expat)))

(define-public r-collapsibletree
  (package
    (name "r-collapsibletree")
    (version "0.1.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "collapsibleTree" version))
       (sha256
        (base32
         "1i5nmw5w7m8xdgxzim8z8n4w321f42isxbvvajl8ii59pg7drilq"))
       (snippet
        '(begin
           ;; Delete minified JavaScript file
           (delete-file "inst/htmlwidgets/lib/d3-4.10.2/d3.min.js")
           #true))))
    (properties
     `((upstream-name . "collapsibleTree")))
    (build-system r-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/d3-4.10.2/"
               (let ((source (assoc-ref inputs "d3.v4.js"))
                     (target "d3.min.js"))
                 (format #t "Processing ~a --> ~a~%"
                         source target)
                 (invoke "esbuild" source "--minify"
                         (string-append "--outfile=" target)))))))))
    (propagated-inputs
     (list r-data-tree r-htmlwidgets))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("d3.v4.js"
        ,(origin
           (method url-fetch)
           (uri "https://d3js.org/d3.v4.js")
           (sha256
            (base32
             "0y7byf6kcinfz9ac59jxc4v6kppdazmnyqfav0dm4h550fzfqqlg"))))
       ("r-colorspace" ,r-colorspace)
       ("r-testthat" ,r-testthat)
       ("r-tibble" ,r-tibble)))
    (home-page "https://github.com/AdeelK93/collapsibleTree")
    (synopsis "Interactive collapsible tree diagrams using D3.js")
    (description
     "This is a package for interactive Reingold-Tilford tree diagrams created
using D3.js, where every node can be expanded and collapsed by clicking on it.
Tooltips and color gradients can be mapped to nodes using a numeric column in
the source data frame.")
    (license license:gpl3+)))

(define-public r-rapiclient
  (package
    (name "r-rapiclient")
    (version "0.1.8")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "rapiclient" version))
              (sha256
               (base32
                "1alzkcvzaj3vr2qd8v4yw1pfg3vfvn3lvjcivsdxkwljvrv67v8w"))))
    (properties `((upstream-name . "rapiclient")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-jsonlite r-yaml))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/bergant/rapiclient")
    (synopsis "Dynamic OpenAPI/Swagger client")
    (description
     "This package lets you access services specified in OpenAPI (formerly
Swagger) format.  It is not a code generator.  The client is generated
dynamically as a list of R functions.")
    (license license:expat)))

(define-public r-rappdirs
  (package
    (name "r-rappdirs")
    (version "0.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rappdirs" version))
       (sha256
        (base32
         "1161i3jgjvzjv4p8qbz9r976fnggkcrw3mlj4yd1h2svnijrz5a9"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/rappdirs/")
    (synopsis "Determine where to save data, caches, and logs")
    (description
     "This package provides an easy way to determine which directories on the
user's computer should be used to save data, caches and logs.  It is a port of
Python's @url{https://github.com/ActiveState/appdirs,Appdirs} to R.")
    (license license:expat)))

(define-public r-rastervis
  (package
    (name "r-rastervis")
    (version "0.51.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rasterVis" version))
       (sha256
        (base32
         "12cl201gwah0bn14ji4nbygayd77w5fck9zkcikhrda5s0chvgb1"))))
    (properties `((upstream-name . "rasterVis")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-hexbin
           r-lattice
           r-latticeextra
           r-raster
           r-rcolorbrewer
           r-sp
           r-terra
           r-viridislite
           r-zoo))
    (home-page "https://oscarperpinan.github.io/rastervis/")
    (synopsis "Visualization methods for raster data")
    (description
     "This package provides methods for enhanced visualization and interaction
with raster data.  It implements visualization methods for quantitative data
and categorical data, both for univariate and multivariate rasters.  It also
provides methods to display spatiotemporal rasters, and vector fields.")
    (license license:gpl3)))

(define-public r-rentrez
  (package
    (name "r-rentrez")
    (version "1.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rentrez" version))
       (sha256
        (base32
         "0x1g2f6hvkqqlb39z8m5qxhcvsizddic5i7rpqw0wy77xfbna9gv"))))
    (properties `((upstream-name . "rentrez")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-httr r-jsonlite r-xml))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://docs.ropensci.org/rentrez/")
    (synopsis "Entrez in R")
    (description
     "This package provides an R interface to the NCBI's EUtils API,
allowing users to search databases like GenBank PubMed, process the results of
those searches and pull data into their R sessions.")
    (license license:expat)))

(define-public r-renv
  (package
    (name "r-renv")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "renv" version))
       (sha256
        (base32
         "1lwhcdjqqnv78cw88g3qvdmz89w5i0ll4z2rricikvbfsnmgw778"))))
    (properties `((upstream-name . "renv")))
    (build-system r-build-system)
    ;; Tests attempt to install packages.
    (arguments (list #:tests? #false))
    ;; Since we are not running the tests, we don't need any of the many, many
    ;; test inputs.
    (native-inputs (list r-knitr))
    (home-page "https://rstudio.github.io/renv")
    (synopsis "Project environments")
    (description
     "This package provides a dependency management toolkit for R.  Using
renv, you can create and manage project-local R libraries, save the state of
these libraries to a lockfile, and later restore your library as required.
Together, these tools can help make your projects more isolated, portable, and
reproducible.")
    (license license:expat)))

;; TODO: esbuild
(define-public r-learnr
  (package
    (name "r-learnr")
    (version "0.11.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "learnr" version))
       (sha256
        (base32
         "01xig6ijsjnkwdjh03zdp86mqm5pjlqp9br34pn644rf98qg8k2y"))))
    (build-system r-build-system)
    ;; Tests need shinytest2.
    (arguments (list #:tests? #false))
    (native-inputs (list esbuild r-knitr r-testthat))
    (propagated-inputs
     (list r-checkmate
           r-digest
           r-ellipsis
           r-evaluate
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-knitr
           r-lifecycle
           r-markdown
           r-promises
           r-rappdirs
           r-renv
           r-rlang
           r-rmarkdown
           r-rprojroot
           r-shiny
           r-withr))
    (home-page "https://rstudio.github.io/learnr/")
    (synopsis "Interactive tutorials for R")
    (description
     "This package provides tools to create interactive tutorials using R
Markdown.  Use a combination of narrative, figures, videos, exercises, and
quizzes to create self-paced tutorials for learning about R and R packages.")
    (license license:asl2.0)))

(define-public r-analytics
  (package
    (name "r-analytics")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "analytics" version))
       (sha256
        (base32
         "0js3c8lwj3knccb55nq03cbjlf4w390p9aid2mi5x80l3ayd9in1"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-cluster
           r-fractal
           r-lmtest
           r-mass
           r-np
           r-powerplus
           r-robust
           r-trend
           r-tsa
           r-urca
           r-vim))
    (home-page "https://cran.r-project.org/web/packages/analytics/")
    (synopsis "Collection of data analysis tools")
    (description
     "This package is a collection of data analysis tools.  It includes tools
for regression outlier detection in a fitted linear model, stationary
bootstrap using a truncated geometric distribution, a comprehensive test for
weak stationarity, column means by group, weighted biplots, and a heuristic to
obtain a better initial configuration in non-metric MDS.")
    (license license:gpl2)))

(define-public r-here
  (package
    (name "r-here")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "here" version))
       (sha256
        (base32 "0srlr8h8qmr0wrmp7gs4g2ry5dni2hx8n947bik3s3a26f091v88"))))
    (properties `((upstream-name . "here")))
    (build-system r-build-system)
    (propagated-inputs (list r-rprojroot))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://here.r-lib.org/")
    (synopsis "Simpler way to find files")
    (description
     "This package lets you construct paths to your project's files.  Use the
@code{here} function as a drop-in replacement for @code{file.path}, it will
always locate the files relative to your project root.")
    (license license:expat)))

(define-public r-reticulate
  (package
    (name "r-reticulate")
    (version "1.42.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reticulate" version))
       (sha256
        (base32
         "0d3xd8gk7zkcbfypmd5d1kcavcada0asvgccb27a1pghgqxw18kr"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'build-reproducibly
           (lambda _
             (setenv "PYTHONHASHSEED" "0")
             (setenv "PYTHONDONTWRITEBYTECODE" "1"))))))
    (inputs (list python))
    (propagated-inputs
     (list r-here
           r-jsonlite
           r-matrix
           r-png
           r-rappdirs
           r-rcpp
           r-rcpptoml
           r-rlang
           r-withr))
    (native-inputs
     (list r-callr
           r-glue
           r-knitr
           r-ps
           r-rmarkdown
           r-testthat))
    (home-page "https://github.com/rstudio/reticulate")
    (synopsis "R interface to Python")
    (description
     "This package provides an interface from R to Python modules, classes,
and functions.  When calling into Python, R data types are automatically
converted to their equivalent Python types.  When values are returned from
Python to R they are converted back to R types.")
    (license license:asl2.0)))

(define-public r-bibtex
  (package
    (name "r-bibtex")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "bibtex" version))
       (sha256
        (base32
         "1l9y945qmpla68rx6dnaxc83vmvkw26cw4zzfgfsvi36wsja1hgk"))))
    (build-system r-build-system)
    (propagated-inputs (list r-backports))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/romainfrancois/bibtex")
    (synopsis "Bibtex parser")
    (description "This package provides a utility for R to parse a bibtex
file.")
    (license license:gpl2+)))

(define-public r-billboarder
  (package
    (name "r-billboarder")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "billboarder" version))
       (sha256
        (base32 "07piczkr5chsxrpkmqx533nxjaw0sgrqzd7xs2779jk8184vr36a"))
       (snippet
        '(delete-file "inst/htmlwidgets/lib/billboard/billboard.pkgd.min.js"))))
    (properties `((upstream-name . "billboarder")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/htmlwidgets/lib/billboard/"
               (let ((source (assoc-ref inputs "js-billboard"))
                     (target "billboard.pkgd.min.js"))
                 (minify source #:target target))))))))
    (propagated-inputs
     (list r-ggplot2
           r-htmltools
           r-htmlwidgets
           r-jsonlite
           r-magrittr
           r-rlang
           r-scales
           r-shiny))
    (native-inputs
     `(("r-knitr" ,r-knitr)
       ("r-testthat" ,r-testthat)
       ("esbuild" ,esbuild)
       ;; It is not ideal to use this concatenated (but not minified)
       ;; JavaScript file, as the original source is written in TypeScript.
       ;; However, this can still be considered source code as it is readable
       ;; and can be modified.
       ("js-billboard"
        ,(origin
           (method url-fetch)
           (uri "https://unpkg.com/billboard.js@3.13.0/dist/billboard.js")
           (sha256
            (base32
             "0s1lcmsgcb6yjzz1k03rz2ga3hz9i3i442q30bv4p6z8dagd1akx"))))))
    (home-page "https://github.com/dreamRs/billboarder")
    (synopsis "Create interactive charts with the JavaScript Billboard library")
    (description
     "This package provides an @code{htmlwidgets} interface to billboard.js,
a re-usable easy interface JavaScript chart library, based on D3 v4+.  Chart
types include line charts, scatterplots, bar/lollipop charts,
histogram/density plots, pie/donut charts and gauge charts.  All charts are
interactive, and a proxy method is implemented to smoothly update a chart
without rendering it again in shiny apps.")
    (license license:expat)))

(define-public r-ggseqlogo
  (package
    (name "r-ggseqlogo")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggseqlogo" version))
       (sha256
        (base32
         "1drncw73950dzjx3lyyfqrxm3rdbrp44n27sl4b17m9d0crdbgqw"))))
    (build-system r-build-system)
    (propagated-inputs (list r-ggplot2))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/omarwagih/ggseqlogo")
    (synopsis "ggplot2 extension for drawing genetic sequence logos")
    (description
     "The range of functions provided by this package makes it possible to
draw highly versatile genomic sequence logos.  Features include, but are not
limited to, modifying colour schemes and fonts used to draw the logo,
generating multiple logo plots, and aiding the visualisation with annotations.
Sequence logos can easily be combined with other ggplot2 plots.")
    ;; Unspecified version of the LGPL.
    (license license:lgpl3+)))

(define-public r-ggsci
  (package
    (name "r-ggsci")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsci" version))
       (sha256
        (base32
         "0jiwkk2ij1qnsaqr6354wihj057ia1arrfpjpll00x63056fvn21"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-scales))
    (native-inputs (list r-knitr))
    (home-page "https://nanx.me/ggsci/")
    (synopsis "Scientific journal and sci-fi themed color palettes for ggplot2")
    (description
     "This package provides a collection of ggplot2 color palettes inspired by
plots in scientific journals, data visualization libraries, science fiction
movies, and TV shows.")
    (license license:gpl3)))

(define-public r-ggsignif
  (package
    (name "r-ggsignif")
    (version "0.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggsignif" version))
       (sha256
        (base32
         "02mjailzyqkdnzky60dgampw2sq6mnn7s66fk0lhy32s8apm280i"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (propagated-inputs
     (list r-ggplot2))
    (home-page "https://github.com/const-ae/ggsignif")
    (synopsis "Significance brackets for ggplot2")
    (description
     "Enrich your ggplots with group-wise comparisons.  This package provides
an easy way to indicate if two groups are significantly different.  Commonly
this is shown by a bracket on top connecting the groups of interest which
itself is annotated with the level of significance.  The package provides a
single layer that takes the groups for comparison and the test as arguments
and adds the annotation to the plot.")
    (license license:gpl3)))

(define-public r-rstatix
  (package
    (name "r-rstatix")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rstatix" version))
       (sha256
        (base32
         "1891a976k2qjrh1vkzfg8icxblxa978wbazg7mqq8pcw3nmzbip0"))))
    (properties
     '((upstream-name . "rstatix")
       (updater-extra-native-inputs . ("r-emmeans"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-broom
           r-car
           r-corrplot
           r-dplyr
           r-generics
           r-magrittr
           r-purrr
           r-rlang
           r-tibble
           r-tidyr
           r-tidyselect))
    (native-inputs (list r-emmeans r-testthat))
    (home-page "https://rpkgs.datanovia.com/rstatix/")
    (synopsis "Pipe-friendly framework for basic statistical tests")
    (description
     "This package provides a simple and intuitive pipe-friendly framework,
coherent with the @code{tidyverse} design philosophy, for performing basic
statistical tests, including t-test, Wilcoxon test, ANOVA, Kruskal-Wallis and
correlation analyses.  The output of each test is automatically transformed
into a tidy data frame to facilitate visualization.  Additional functions are
available for reshaping, reordering, manipulating and visualizing correlation
matrix.")
    (license license:gpl2)))

(define-public r-ggpubr
  (package
    (name "r-ggpubr")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggpubr" version))
       (sha256
        (base32
         "0x7p3lbh0xv5qk0shsrj1fjx382zak7mj8l3z1zd348r2pccavif"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cowplot
           r-dplyr
           r-ggplot2
           r-ggrepel
           r-ggsci
           r-ggsignif
           r-glue
           r-gridextra
           r-magrittr
           r-polynom
           r-purrr
           r-rlang
           r-rstatix
           r-scales
           r-tibble
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "http://www.sthda.com/english/rpkgs/ggpubr")
    (synopsis "ggplot2-based publication-ready plots")
    (description
     "The ggplot2 package is an excellent and flexible package for elegant
data visualization in R.  However the default generated plots require some
formatting before we can send them for publication.  The ggpubr package
provides some easy-to-use functions for creating and customizing ggplot2-based
publication-ready plots.")
    (license license:gpl2)))

(define-public r-ellipse
  (package
    (name "r-ellipse")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ellipse" version))
       (sha256
        (base32
         "1wy25kw3055zxzidzzkif6c8bmch73qkv2ri4i1w0b6ffcwmbs6d"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ellipse/")
    (synopsis "Functions for drawing ellipses and ellipse-like confidence regions")
    (description
     "This package contains various routines for drawing ellipses and
ellipse-like confidence regions, implementing the plots described in Murdoch
and Chow (1996), A graphical display of large correlation matrices, The
American Statistician 50, 178-180.  There are also routines implementing the
profile plots described in Bates and Watts (1988), Nonlinear Regression
Analysis and its Applications.")
    (license license:gpl2+)))

(define-public r-flashclust
  (package
    (name "r-flashclust")
    (version "1.01-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flashClust" version))
       (sha256
        (base32
         "0l4lpz451ll7f7lfxmb7ds24ppzhfg1c3ypvydglcc35p2dq99s8"))))
    (properties `((upstream-name . "flashClust")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/flashClust/")
    (synopsis "Implementation of optimal hierarchical clustering")
    (description
     "This package provides a fast implementation of hierarchical
clustering.")
    (license license:gpl2+)))

(define-public r-factominer
  (package
    (name "r-factominer")
    (version "2.11")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "FactoMineR" version))
       (sha256
        (base32
         "0qzhfjcz0kahqf214g4xs7gfpqx05xbfiwa5r2ldgn2drd16phij"))))
    (properties `((upstream-name . "FactoMineR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-car
           r-cluster
           r-dt
           r-ellipse
           r-emmeans
           r-flashclust
           r-ggplot2
           r-ggrepel
           r-lattice
           r-leaps
           r-mass
           r-multcompview
           r-scatterplot3d))
    (native-inputs
     (list r-knitr))
    (home-page "http://factominer.free.fr")
    (synopsis "Multivariate exploratory data analysis and data mining")
    (description
     "This package provides exploratory data analysis methods to summarize,
visualize and describe datasets.  The main principal component methods are
available, those with the largest potential in terms of applications:
principal component analysis (PCA) when variables are quantitative,
correspondence analysis (CA) and multiple correspondence analysis (MCA) when
variables are categorical, Multiple Factor Analysis when variables are
structured in groups, etc. and hierarchical cluster analysis.")
    (license license:gpl2+)))

(define-public r-factoextra
  (package
    (name "r-factoextra")
    (version "1.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "factoextra" version))
       (sha256
        (base32
         "1allvdjhd3pq8xz30b1cymwcik5iaahghrjrlnn54cwkfhfg0kv2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-cluster
           r-dendextend
           r-factominer
           r-ggplot2
           r-ggpubr
           r-ggrepel
           r-reshape2
           r-tidyr))
    (home-page "http://www.sthda.com/english/rpkgs/factoextra")
    (synopsis "Extract and visualize the results of multivariate data analyses")
    (description
     "This package provides some easy-to-use functions to extract and
visualize the output of multivariate data analyses, including
@code{PCA} (Principal Component Analysis), @code{CA} (Correspondence
Analysis), @code{MCA} (Multiple Correspondence Analysis), @code{FAMD} (Factor
Analysis of Mixed Data), @code{MFA} (Multiple Factor Analysis) and
@code{HMFA} (Hierarchical Multiple Factor Analysis) functions from different R
packages.  It contains also functions for simplifying some clustering analysis
steps and provides ggplot2-based elegant data visualization.")
    (license license:gpl2)))

(define-public r-fancova
  (package
    (name "r-fancova")
    (version "0.6-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fANCOVA" version))
       (sha256
        (base32 "04mw0blgpwdk6wdg8llrig43psgc0vb42cbimvzbnym8v503dsn3"))))
    (properties `((upstream-name . "fANCOVA")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=fANCOVA")
    (synopsis "Nonparametric analysis of covariance")
    (description
     "This package provides a collection of R functions to perform
nonparametric analysis of covariance for regression curves or surfaces.
Testing the equality or parallelism of nonparametric curves or surfaces is
equivalent to analysis of variance (ANOVA) or analysis of covariance (ANCOVA)
for one-sample functional data.  Three different testing methods are available
in the package, including one based on L-2 distance, one based on an ANOVA
statistic, and one based on variance estimators.")
    (license license:gpl3)))

(define-public r-fansi
  (package
    (name "r-fansi")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "fansi" version))
       (sha256
        (base32
         "0qqq8gz6sfr5yib4qmvk458qa0ypaz0n7f2ygjnpy2p5vy8cd7ga"))))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr)) ; for vignettes
    (home-page "https://github.com/brodieG/fansi")
    (synopsis "ANSI control sequence aware string functions")
    (description
     "This package provides counterparts to R string manipulation functions
that account for the effects of ANSI text formatting control sequences.")
    (license license:gpl2+)))

(define-public r-nbclust
  (package
    (name "r-nbclust")
    (version "3.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NbClust" version))
       (sha256
        (base32
         "0k5hr4zgx4gp1n62xchgz2zvyl35ba2cnczhhvj8rfbg2n4hx6qs"))))
    (properties `((upstream-name . "NbClust")))
    (build-system r-build-system)
    (home-page "https://sites.google.com/site/malikacharrad/research/nbclust-package")
    (synopsis "Determine the best number of clusters in a data set")
    (description
     "NbClust provides 30 indexes for determining the optimal number of
clusters in a data set and offers the best clustering scheme from different
results to the user.")
    (license license:gpl2)))

(define-public r-hdf5r
  (package
    (name "r-hdf5r")
    (version "1.3.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hdf5r" version))
       (sha256
        (base32
         "0r7z2gf6406f88s9ipsp2x1kf3ia3ksbprri7sn1dx9pd2v3drz2"))))
    (build-system r-build-system)
    (inputs
     (list hdf5 zlib))
    (propagated-inputs
     (list r-bit64 r-r6))
    (native-inputs
     (list pkg-config r-knitr r-testthat))
    (home-page "https://hhoeflin.github.io/hdf5r")
    (synopsis "Interface to the HDF5 binary data format")
    (description
     "HDF5 is a data model, library and file format for storing and managing
large amounts of data.  This package provides a nearly feature complete,
object oriented wrapper for the HDF5 API using R6 classes.  Additionally,
functionality is added so that HDF5 objects behave very similar to their
corresponding R counterparts.")
    (license license:asl2.0)))

(define-public r-itertools
  (package
    (name "r-itertools")
    (version "0.1-3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "itertools" version))
       (sha256
        (base32
         "1ls5biiva10pb1dj3ph4griykb9vam02hkrdmlr5a5wf660hg6xn"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-iterators))
    (home-page "https://cran.r-project.org/web/packages/itertools/")
    (synopsis "Iterator tools")
    (description
     "This package provides various tools for creating iterators, many
patterned after functions in the Python @code{itertools} module, and others
patterned after functions in the snow package.")
    (license license:gpl2)))

(define-public r-itsadug
  (package
    (name "r-itsadug")
    (version "2.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "itsadug" version))
       (sha256
        (base32 "1sdqs279qxr3993hw08xg7b54yq03jw1597cqn6cf24sh9vpw9m1"))))
    (properties `((upstream-name . "itsadug")))
    (build-system r-build-system)
    (propagated-inputs (list r-mgcv r-plotfunctions))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=itsadug")
    (synopsis "Interpreting time series and autocorrelated data using GAMMs")
    (description
     "@dfn{Generalized Additive Mixed Modeling} (GAMM; Lin & Zhang, 1999) as
implemented in the R package @code{mgcv} is a nonlinear regression analysis
which is particularly useful for time course data such as EEG, pupil dilation,
gaze data (eye tracking), and articulography recordings, but also for
behavioral data such as reaction times and response data.  As time course
measures are sensitive to autocorrelation problems, GAMMs implements methods
to reduce the autocorrelation problems.  This package includes functions for
the evaluation of GAMM models (e.g., model comparisons, determining regions of
significance, inspection of autocorrelational structure in residuals) and
interpreting of GAMMs (e.g., visualization of complex interactions, and
contrasts).")
    (license license:gpl2+)))

(define-public r-polynom
  (package
    (name "r-polynom")
    (version "1.4-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "polynom" version))
       (sha256
        (base32
         "0y4j07syjwpnq5w6a1d90z6h1hjzijmm42pq0f8jk2vcn5xxn7mw"))))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/web/packages/polynom/")
    (synopsis "Functions for univariate polynomial manipulations")
    (description
     "This package provides a collection of functions to implement a class for
univariate polynomial manipulations.")
    (license license:gpl2)))

(define-public r-pupillometryr
  (package
    (name "r-pupillometryr")
    (version "0.0.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "PupillometryR" version))
       (sha256
        (base32 "0jqpx5g0fjdxxp7wlgv4jm5vrhchm6r21qd7i825fi5552c46awv"))))
    (properties `((upstream-name . "PupillometryR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-fda
           r-ggplot2
           r-itsadug
           r-mgcv
           r-rlang
           r-signal
           r-stringr
           r-tidyr
           r-zoo))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=PupillometryR")
    (synopsis "Unified pipeline for pupillometry data")
    (description
     "This package provides a unified pipeline to clean, prepare, plot, and
run basic analyses on pupillometry experiments.")
    (license license:expat)))

(define-public r-gbrd
  (package
    (name "r-gbrd")
    (version "0.4.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gbRd" version))
       (sha256
        (base32
         "0f13hg6nckl4aflwd49g4x2adxjfgah2yga70z1m8jszhhm1vka8"))))
    (properties `((upstream-name . "gbRd")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/gbRd/")
    (synopsis "Utilities for processing Rd objects and files")
    (description
     "This package provides utilities for processing Rd objects and files.
Extract argument descriptions and other parts of the help pages of
functions.")
    (license license:gpl2+)))

(define-public r-rjags
  (package
    (name "r-rjags")
    (version "4-17")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rjags" version))
       (sha256
        (base32
         "0d23zzdgm0ihb8lv01wraq3b98gl9fm5jbxhp0jqpk8sgv5ff4g9"))))
    (properties
     '((updater-extra-inputs . ("jags"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-coda))
    (inputs
     (list jags))
    (native-inputs
     (list pkg-config))
    (home-page "https://mcmc-jags.sourceforge.net")
    (synopsis "Bayesian graphical models using MCMC")
    (description
     "This package provides an R interface to the JAGS MCMC library.  JAGS is
Just Another Gibbs Sampler.  It is a program for analysis of Bayesian
hierarchical models using Markov Chain Monte Carlo (MCMC) simulation.")
    (license license:gpl2)))

(define-public r-rbibutils
  (package
    (name "r-rbibutils")
    (version "2.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbibutils" version))
       (sha256
        (base32
         "0zvpa39d6a9ibaqnz6na0nm7ybmhmshr5s4vdndsmgcv45iasd8c"))))
    (properties `((upstream-name . "rbibutils")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://geobosh.github.io/rbibutils/")
    (synopsis "Convert between bibliography formats")
    (description
     "This package converts between a number of bibliography formats,
including BibTeX, BibLaTeX and Bibentry.  It includes a port of the bibutils
utilities and supports all bibliography formats and character encodings
implemented in bibutils.")
    (license license:gpl2)))

(define-public r-rbiom
  (package
    (name "r-rbiom")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rbiom" version))
       (sha256
        (base32 "1p7lh6ni8m9khwnp3iyzgdznyl09ckfyl84q4410p0lc5iqg21bh"))))
    (properties
     '((upstream-name . "rbiom")
       (updater-extra-native-inputs . ("r-testthat"))))
    (build-system r-build-system)
    (propagated-inputs (list r-ape
                             r-dplyr
                             r-emmeans
                             r-fillpattern
                             r-ggbeeswarm
                             r-ggnewscale
                             r-ggplot2
                             r-ggrepel
                             r-ggtext
                             r-jsonlite
                             r-magrittr
                             r-mgcv
                             r-parallelly
                             r-patchwork
                             r-pillar
                             r-plyr
                             r-readr
                             r-readxl
                             r-slam
                             r-vegan))
    (native-inputs (list r-testthat))
    (home-page "https://cmmr.github.io/rbiom/index.html")
    (synopsis "Read/write, transform, and summarize BIOM data")
    (description
     "This package provides a toolkit for working with @dfn{Biological
Observation Matrix} (BIOM) files.  Features include reading/writing all BIOM
formats, rarefaction, alpha diversity, beta diversity (including UniFrac),
summarizing counts by taxonomic level, and sample subsetting.  Standalone
functions for reading, writing, and subsetting phylogenetic trees are also
provided.")
    (license license:agpl3)))

(define-public r-rdpack
  (package
    (name "r-rdpack")
    (version "2.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Rdpack" version))
       (sha256
        (base32
         "04wmy10iykmvfpmlysh4dfh5khsddl4pv2g1y30xbssysizn8l81"))))
    (properties `((upstream-name . "Rdpack")))
    (build-system r-build-system)
    ;; FIXME It's unclear why the tests fail.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-rbibutils))
    (native-inputs (list r-devtools r-gbrd r-testthat r-waldo))
    (home-page "https://github.com/GeoBosh/Rdpack")
    (synopsis "Update and manipulate Rd documentation objects")
    (description
     "This package provides functions for manipulation of R documentation
objects, including functions @code{reprompt()} and @code{ereprompt()} for
updating Rd documentation for functions, methods and classes; it also includes
Rd macros for citations and import of references from bibtex files for use in
Rd files and roxygen2 comments, as well as many functions for manipulation of
references and Rd files.")
    (license license:gpl2+)))

(define-public r-officer
  (package
    (name "r-officer")
    (version "0.6.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "officer" version))
       (sha256
        (base32
         "0xqcgb7jzxggrvmh4zab67lhg938c46j0rlxhy7k66ldkkxs03l8"))))
    (properties
     '((updater-extra-native-inputs . ("r-magick"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; Needed for saving ~/dump.RDS during tests.
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-cli
           r-openssl
           r-r6
           r-ragg
           r-uuid
           r-xml2
           r-zip))
    (native-inputs (list r-gdtools
                         r-ggplot2
                         r-knitr
                         r-magick
                         r-rmarkdown
                         r-testthat
                         r-withr))
    (home-page "https://davidgohel.github.io/officer")
    (synopsis "Manipulation of Word and PowerPoint documents")
    (description
     "This package provides tools to access and manipulate Word and PowerPoint
documents from R.  The package focuses on tabular and graphical reporting from
R; it also provides two functions that let users get document content into
data objects.  A set of functions lets add and remove images, tables and
paragraphs of text in new or existing documents.  When working with PowerPoint
presentations, slides can be added or removed; shapes inside slides can also
be added or removed.  When working with Word documents, a cursor can be used
to help insert or delete content at a specific location in the document.")
    (license license:gpl3)))

(define-public r-profilemodel
  (package
    (name "r-profilemodel")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "profileModel" version))
       (sha256
        (base32
         "01m5nb8cmq0aq555pxk2a99182si65hhmn68yn9nal2j3zl2bp4i"))))
    (properties `((upstream-name . "profileModel")))
    (build-system r-build-system)
    (home-page "https://github.com/ikosmidis/profileModel")
    (synopsis "Profiling inference functions for various model classes")
    (description
     "This package provides tools that can be used to calculate, evaluate,
plot and use for inference the profiles of *arbitrary* inference functions for
arbitrary @code{glm}-like fitted models with linear predictors.  More information
on the methods that are implemented can be found in Kosmidis (2008)
@url{https://www.r-project.org/doc/Rnews/Rnews_2008-2.pdf}.")
    (license license:gpl2+)))

(define-public r-brglm
  (package
    (name "r-brglm")
    (version "0.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brglm" version))
       (sha256
        (base32
         "08shcz0j1npdn7xkhsvlzs3z4rdwq3g4rk6a4xx8wirqw8n8s2an"))))
    (properties `((upstream-name . "brglm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-profilemodel))
    (home-page "https://github.com/ikosmidis/brglm")
    (synopsis "Bias reduction in binomial-response generalized linear models")
    (description
     "Fit generalized linear models with binomial responses using either an
adjusted-score approach to bias reduction or maximum penalized likelihood
where penalization is by Jeffreys invariant prior.  These procedures return
estimates with improved frequentist properties (bias, mean squared error) that
are always finite even in cases where the maximum likelihood estimates are
infinite (data separation).  Fitting takes place by fitting generalized linear
models on iteratively updated pseudo-data.  The interface is essentially the
same as @code{glm}.  More flexibility is provided by the fact that custom
pseudo-data representations can be specified and used for model fitting.
Functions are provided for the construction of confidence intervals for the
reduced-bias estimates.")
    (license license:gpl2+)))

(define-public r-entropy
  (package
    (name "r-entropy")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "entropy" version))
       (sha256
        (base32
         "19bnml9dlm5pgfc37pl1pi377vxyjb3jzg4cjifc9c4rizg2l6lh"))))
    (properties `((upstream-name . "entropy")))
    (build-system r-build-system)
    (home-page "https://www.strimmerlab.org/software/entropy/")
    (synopsis "Estimation of entropy, mutual information and related quantities")
    (description
     "This package implements various estimators of entropy, such as the
shrinkage estimator by Hausser and Strimmer, the maximum likelihood and the
Millow-Madow estimator, various Bayesian estimators, and the Chao-Shen
estimator.  It also offers an R interface to the NSB estimator.  Furthermore,
it provides functions for estimating Kullback-Leibler divergence, chi-squared,
mutual information, and chi-squared statistic of independence.  In addition
there are functions for discretizing continuous random variables.")
    (license license:gpl3+)))

(define-public r-acd
  (package
    (name "r-acd")
    (version "1.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACD" version))
       (sha256
        (base32
         "1a67bi3hklq8nlc50r0qnyr4k7m9kpvijy8sqqpm54by5hsysfd6"))))
    (properties `((upstream-name . "ACD")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/ACD/")
    (synopsis "Categorical data analysis with complete or missing responses")
    (description
     "This package provides tools for categorical data analysis with complete
or missing responses.")
    (license license:gpl2+)))

(define-public r-acdm
  (package
    (name "r-acdm")
    (version "1.0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ACDm" version))
       (sha256
        (base32
         "0g89827az5mnllp6l71znbvwxzygb8nvnmsv6x052w2ajhd16v7v"))))
    (properties `((upstream-name . "ACDm")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr r-ggplot2 r-plyr r-rsolnp r-zoo))
    (home-page "https://cran.r-project.org/web/packages/ACDm/")
    (synopsis "Tools for Autoregressive Conditional Duration Models")
    (description
     "ACDm is a package for Autoregressive Conditional Duration (ACD, Engle
and Russell, 1998) models.  It creates trade, price or volume durations from
transactions (tic) data, performs diurnal adjustments, fits various ACD models
and tests them.")
    (license license:gpl2+)))

(define-public r-overlap
  (package
    (name "r-overlap")
    (version "0.3.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "overlap" version))
       (sha256
        (base32
         "0x6mmd7gya17saph4dncl9dspfwc8achwcg5s5f92flwis76r7km"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-suntools))
    (home-page "https://cran.r-project.org/web/packages/overlap/")
    (synopsis "Estimates of coefficient of overlapping for animal activity patterns")
    (description
     "This package provides functions to fit kernel density functions to data
on temporal activity patterns of animals; estimate coefficients of overlapping
of densities for two species; and calculate bootstrap estimates of confidence
intervals.")
    (license license:gpl3+)))

(define-public r-snakecase
  (package
    (name "r-snakecase")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "snakecase" version))
       (sha256
        (base32
         "0888fng8zwm2zmi7rap9hc2q2x2gnhz8gyr35wwjx93w6f8rfpra"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           ;; One test requires the unavailable r-purrrlyr.
           (lambda _ (delete-file "tests/testthat/test-to_any_case.R"))))))
    (propagated-inputs
     (list r-stringi r-stringr))
    (native-inputs (list r-knitr r-testthat r-tibble))
    (home-page "https://github.com/Tazinho/snakecase")
    (synopsis "Convert strings into any case")
    (description
     "This package provides a consistent, flexible and easy to use tool to
parse and convert strings into cases like snake or camel among others.")
    (license license:gpl3)))

(define-public r-prediction
  (package
    (name "r-prediction")
    (version "0.3.18")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "prediction" version))
       (sha256
        (base32
         "194p2zbypslkd7slnvqw2z456xxwfzjxd11dirhpffjcsizkgrnh"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/leeper/prediction")
    (synopsis "Tidy, type-safe prediction methods")
    (description
     "This package provides the @code{prediction()} function, a type-safe
alternative to @code{predict()} that always returns a data frame.  The package
currently supports common model types (e.g., @code{\"lm\"}, @code{\"glm\"})
from the @code{stats} package, as well as numerous other model classes from
other add-on packages.")
    (license license:expat)))

(define-public r-prettygraphs
  (package
    (name "r-prettygraphs")
    (version "2.2.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "prettyGraphs" version))
              (sha256
               (base32
                "0va69qqgbn8fxzlm5dkzmaqv1xq5zb1s79wv1f065p61akx0ma16"))))
    (properties `((upstream-name . "prettyGraphs")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/package=prettyGraphs")
    (synopsis "Publication-quality graphics")
    (description
     "This package provides simple and crisp publication-quality graphics for
the ExPosition family of packages.  See An ExPosition of the Singular Value
Decomposition in R (Beaton et al 2014) <doi:10.1016/j.csda.2013.11.006>.")
    (license license:gpl2)))

(define-public r-insight
  (package
    (name "r-insight")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "insight" version))
       (sha256
        (base32
         "19d8wglqlasm6kbgsgyg5a7q7lz5qc3g77hsyclivcidaq1108x2"))))
    (build-system r-build-system)
    (arguments
     (list #:phases
           '(modify-phases %standard-phases
              (add-after 'unpack 'disable-bad-tests
                (lambda _
                  ;; This single test fails.
                  (delete-file "tests/testthat/test-find_formula.R"))))))
    ;; Note: this package has *lots* of test-time dependencies.  Hundreds of
    ;; tests will happily pass without them, and those tests needing these
    ;; inputs are skipped automatically.  There is no need to add them.
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://easystats.github.io/insight/")
    (synopsis "Easy access to model information for various model objects")
    (description
     "This package provides a tool to provide an easy, intuitive and
consistent access to information contained in various R models, like model
formulas, model terms, information about random effects, data that was used to
fit the model or data from response variables.  The package mainly revolves
around two types of functions: Functions that find (the names of) information,
starting with @code{find_}, and functions that get the underlying data,
starting with @code{get_}.  The package has a consistent syntax and works with
many different model objects, where otherwise functions to access these
information are missing.")
    (license license:gpl3)))

(define-public r-sjlabelled
  (package
    (name "r-sjlabelled")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjlabelled" version))
       (sha256
        (base32
         "1va86q5wddyvqgdpy8d0an2c7v1qbb4hpn0ai6y1v5v1ff87w73k"))))
    (properties
     '((updater-extra-native-inputs . ("r-haven"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard r-insight))
    (native-inputs
     (list r-haven r-knitr r-testthat))
    (home-page "https://github.com/strengejacke/sjlabelled")
    (synopsis "Labelled data utility functions")
    (description
     "This package provides a collection of functions dealing with labelled
data, like reading and writing data between R and other statistical software
packages.  This includes easy ways to get, set or change value and variable
label attributes, to convert labelled vectors into factors or numeric (and
vice versa), or to deal with multiple declared missing values.")
    (license license:gpl3)))

(define-public r-sjmisc
  (package
    (name "r-sjmisc")
    (version "2.8.10")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "sjmisc" version))
       (sha256
        (base32
         "12y5aa820h95dbak9zd2rbg1hc0636b2dpg0mn9mkb76a4ssnr1d"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-datawizard
           r-dplyr
           r-insight
           r-magrittr
           r-purrr
           r-rlang
           r-sjlabelled
           r-tidyselect))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/strengejacke/sjmisc")
    (synopsis "Data and variable transformation functions")
    (description
     "This package is a collection of miscellaneous utility functions,
supporting data transformation tasks like recoding, dichotomizing or grouping
variables, setting and replacing missing values.  The data transformation
functions also support labelled data, and all integrate seamlessly into a
tidyverse workflow.")
    (license license:gpl3)))

(define-public r-nodbi
  (package
    (name "r-nodbi")
    (version "0.12.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "nodbi" version))
              (sha256
               (base32
                "0937scxibjd7l1pxf9x1a1b3l7dnfscv13mcs85xqr11y5apgbx2"))))
    (properties `((upstream-name . "nodbi")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dbi
           r-jqr
           r-jsonlite
           r-r-utils
           r-stringi
           r-uuid
           r-v8))
    (native-inputs (list r-callr
                         r-devtools
                         r-duckdb
                         r-knitr
                         r-rpostgres
                         r-rsqlite
                         r-testthat
                         r-webfakes
                         r-withr))
    (home-page "https://docs.ropensci.org/nodbi/")
    (synopsis "NoSQL database connector")
    (description
     "This is a package for simplified document database access and
manipulation, providing a common API across supported NoSQL databases
Elasticsearch, CouchDB, MongoDB as well as SQLite/JSON1, PostgreSQL, and
DuckDB.")
    (license license:expat)))

(define-public r-nortest
  (package
    (name "r-nortest")
    (version "1.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nortest" version))
       (sha256
        (base32
         "17r0wpz72z9312c70nwi1i1kp1v9fm1h6jg7q5cx1mc1h420m1d3"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/nortest/")
    (synopsis "Tests for normality")
    (description
     "This package provides five omnibus tests for testing the composite
hypothesis of normality.")
    (license license:gpl2+)))

(define-public r-moonbook
  (package
    (name "r-moonbook")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "moonBook" version))
       (sha256
        (base32
         "1ml4vvm0mvrprpyi0l50aw38brx18bk2qny4gybmkvlbakalz9bx"))))
    (properties `((upstream-name . "moonBook")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-crayon
           r-magrittr
           r-nortest
           r-sjmisc
           r-stringr
           r-survival))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/cardiomoon/moonBook")
    (synopsis "Functions and datasets for the book by Keon-Woong Moon")
    (description
     "This package provides several analysis-related functions for the book
entitled \"R statistics and graph for medical articles\" (written in Korean),
version 1, by Keon-Woong Moon with Korean demographic data with several plot
functions.")
    (license license:gpl2)))

(define-public r-flextable
  (package
    (name "r-flextable")
    (version "0.9.8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "flextable" version))
       (sha256
        (base32
         "0pvka77jg97w0fk309mpdb7qv9k3dbrzg08rq21p624c217y2wln"))))
    (properties
     '((updater-extra-native-inputs . ("r-broom"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'disable-bad-tests
           (lambda _
             ;; These all fail with: 'write_xml.xml_document(private$doc, file
             ;; = private$filename)`: Error closing file
             (substitute* "tests/testthat/test-as_flextable.R"
               ((".*grouped data structure.*" m)
                (string-append m "skip('skip');\n")))
             (substitute* "tests/testthat/test-link.R"
               ((".*URL are preserved in pptx.*" m)
                (string-append m "skip('skip');\n")))
             (substitute* "tests/testthat/test-pptx-tables.R"
               ((".*(row height is valid|location is correct).*" m)
                (string-append m "skip('skip');\n")))
             (substitute* "tests/testthat/test-rotations.R"
               ((".*pptx rotations.*" m)
                (string-append m "skip('skip');\n")))
             (substitute* "tests/testthat/test-styles.R"
               ((".*borders with office docs are sanitized.*" m)
                (string-append m "skip('skip');\n")))
             (substitute* "tests/testthat/test-text.R"
               ((".*pptx - string are html encoded.*" m)
                (string-append m "skip('skip');\n"))))))))
    (propagated-inputs
     (list r-data-table
           r-gdtools
           r-htmltools
           r-knitr
           r-officer
           r-ragg
           r-rlang
           r-rmarkdown
           r-uuid
           r-xml2))
    (native-inputs
     (list r-broom r-knitr r-testthat))
    (home-page "https://davidgohel.github.io/flextable")
    (synopsis "Functions for tabular reporting")
    (description
     "This package provides tools to create pretty tables for HTML documents
and other formats.  Functions are provided to let users create tables, modify
and format their content.  It extends the @code{officer} package and can be
used within R markdown documents when rendering to HTML and to Word
documents.")
    (license license:gpl3)))

(define-public r-writexl
  (package
    (name "r-writexl")
    (version "1.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "writexl" version))
       (sha256
        (base32
         "1lv0fr333scllranvqi1agv3c071qqiwvishbxw7ig92x8lllmyh"))))
    (build-system r-build-system)
    (inputs (list zlib))
    (native-inputs
     (list r-bit64
           r-nycflights13
           r-readxl
           r-spelling
           r-testthat))
    (home-page "https://github.com/ropensci/writexl")
    (synopsis "Export data frames to xlsx format")
    (description
     "This package provides a data frame to xlsx exporter based on
libxlsxwriter.")
    (license license:bsd-2)))

(define-public r-writexls
  (package
    (name "r-writexls")
    (version "6.8.0")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "WriteXLS" version))
              (sha256
               (base32
                "1xh93xxwa6v8bbzbz6ddn0np5isir6z1dkw3cm84zdayh69bimhb"))))
    (properties `((upstream-name . "WriteXLS")))
    (build-system r-build-system)
    (inputs (list perl))
    (home-page "https://github.com/marcschwartz/WriteXLS")
    (synopsis "Create Excel 2003 (XLS) and Excel 2007 (XLSX) files")
    (description
     "This package provides a cross-platform Perl-based R function to create
Excel 2003 (XLS) and Excel 2007 (XLSX) files from one or more data frames.
Each data frame will be written to a separate named worksheet in the Excel
spreadsheet.  The worksheet name will be the name of the data frame it
contains or can be specified by the user.")
    (license license:gpl2+)))

(define-public r-wrs2
  (package
    (name "r-wrs2")
    (version "1.1-7")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "WRS2" version))
              (sha256
               (base32
                "13z3blfvzjddlkixz9cgzni6p435ppjndifif096bic8zrx9f827"))))
    (properties `((upstream-name . "WRS2")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass r-plyr r-reshape))
    (native-inputs (list r-colorspace r-ggally r-ggplot2 r-knitr r-mediation))
    (home-page "https://r-forge.r-project.org/projects/psychor/")
    (synopsis "Collection of robust statistical methods")
    (description
     "R-wrs2 offers a range of strong stats methods from Wilcox WRS functions.
It implements robust t-tests, both independent and dependent, robust ANOVA,
including designs with between-within subjects, quantile ANOVA, robust
correlation, robust mediation, and nonparametric ANCOVA models using robust
location measures.")
    (license license:gpl3)))

(define-public r-biasedurn
  (package
    (name "r-biasedurn")
    (version "2.0.12")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BiasedUrn" version))
       (sha256
        (base32
         "14jpijms81pgl4zyqrhwwdfj0jmlmml21blspvin8lqw8fbbbcr9"))))
    (properties `((upstream-name . "BiasedUrn")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/BiasedUrn/")
    (synopsis "Biased Urn model distributions")
    (description
     "This package provides statistical models of biased sampling in the form
of univariate and multivariate noncentral hypergeometric distributions,
including Wallenius' noncentral hypergeometric distribution and Fisher's
noncentral hypergeometric distribution (also called extended hypergeometric
distribution).")
    (license license:gpl3)))

(define-public r-golem
  (package
    (name "r-golem")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "golem" version))
              (sha256
               (base32
                "079zjzqvslv8k9pj52xwdhk6a9a8sg0p9wc6s457lz0ircan9ml6"))))
    (properties `((upstream-name . "golem")))
    (build-system r-build-system)
    ;; The tests attempt to install packages and mess up the test environment.
    ;; We don't do that around here.
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-attempt
           r-config
           r-here
           r-htmltools
           r-rlang
           r-shiny
           r-yaml))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/ThinkR-open/golem")
    (synopsis "Framework for robust Shiny applications")
    (description
     "This package implements an opinionated framework for building a
production- ready Shiny application.  Golem contains a series of tools like
dependency management, version management, easy installation and deployment or
documentation management.")
    (license license:expat)))

(define-public r-goplot
  (package
    (name "r-goplot")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "GOplot" version))
       (sha256
        (base32
         "1y8dv0kbzpr9za91njw0x233vx5d13vqml9hmpddcyi9s6va5nix"))))
    (properties `((upstream-name . "GOplot")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggdendro r-ggplot2 r-gridextra r-rcolorbrewer))
    (home-page "https://github.com/wencke/wencke.github.io")
    (synopsis "Visualization of functional analysis data")
    (description
     "This package provides an implementation of multilayered visualizations
for enhanced graphical representation of functional analysis data.  It
combines and integrates omics data derived from expression and functional
annotation enrichment analyses.  Its plotting functions have been developed
with an hierarchical structure in mind: starting from a general overview to
identify the most enriched categories (modified bar plot, bubble plot) to a
more detailed one displaying different types of relevant information for the
molecules in a given set of categories (circle plot, chord plot, cluster plot,
Venn diagram, heatmap).")
    (license license:gpl2)))

(define-public r-getopt
  (package
    (name "r-getopt")
    (version "1.20.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "getopt" version))
       (sha256
        (base32
         "12qy48adnibfi9rpv5qd8k3hipbc4q85514dsz0xnhdsdnz6rlw7"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/trevorld/getopt")
    (synopsis "Command-line option processor for R")
    (description
     "This package is designed to be used with Rscript to write shebang
scripts that accept short and long options.  Many users will prefer to
use the packages @code{optparse} or @code{argparse} which add extra
features like automatically generated help options and usage texts,
support for default values, positional argument support, etc.")
    (license license:gpl2+)))

(define-public r-findpython
  (package
    (name "r-findpython")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "findpython" version))
       (sha256
        (base32
         "1jxp5hm9n3i8fl0204cpi194sp8js2m4wzkgqz7v3m6dvw65x8dn"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://github.com/trevorld/findpython")
    (synopsis "Functions to find an acceptable Python binary")
    (description
     "This package was designed to find an acceptable Python binary that
matches version and feature constraints.")
    (license license:expat)))

;; This in not the same as "r-argparser"
(define-public r-argparse
  (package
    (name "r-argparse")
    (version "2.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "argparse" version))
       (sha256
        (base32
         "194y4ablll2cqnjsy5nga0pxqcnbxca1n9ww7pmq8404a7mskj2k"))))
    (build-system r-build-system)
    (inputs (list python))
    (propagated-inputs
     (list r-findpython r-jsonlite r-r6))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/trevorld/argparse")
    (synopsis "Command line optional and positional argument parser")
    (description
     "This package provides a command line parser to be used with Rscript to
write shebang scripts that gracefully accept positional and optional arguments
and automatically generate usage notices.")
    (license license:gpl2+)))

(define-public r-hash
  (package
    (name "r-hash")
    (version "2.2.6.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "hash" version))
       (sha256
        (base32
         "044ifii4gpinzi9vbv5aw0da956ccslxg34xmx24njf6x5dhn0wa"))))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/hash/")
    (synopsis "Implementation of hash/associated arrays/dictionaries")
    (description
     "This package implements a data structure similar to hashes in Perl and
dictionaries in Python but with a purposefully R flavor.  For objects of
appreciable size, access using hashes outperforms native named lists and
vectors.")
    (license license:gpl2+)))

(define-public r-orddom
  (package
    (name "r-orddom")
    (version "3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "orddom" version))
       (sha256
        (base32
         "165axs15fvwhrp89xd87l81q3h2qjll1vrwcsap645cwvb85nwsh"))))
    (build-system r-build-system)
    (propagated-inputs (list r-psych))
    (home-page "https://cran.r-project.org/web/packages/orddom/")
    (synopsis "Ordinal dominance statistics")
    (description
     "This package provides tools to compute ordinal, statistics and effect
sizes as an alternative to mean comparison: Cliff's delta or success rate
difference (SRD), Vargha and Delaney's A or the Area Under a Receiver
Operating Characteristic Curve (AUC), the discrete type of McGraw & Wong's
Common Language Effect Size (CLES) or Grissom & Kim's Probability of
Superiority (PS), and the Number needed to treat (NNT) effect size.  Moreover,
comparisons to Cohen's d are offered based on Huberty & Lowman's Percentage of
Group (Non-)Overlap considerations.")
    (license license:gpl2)))

(define-public r-deriv
  (package
    (name "r-deriv")
    (version "4.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "Deriv" version))
       (sha256
        (base32
         "0wmslhggdhamvzfa0nvj6j5bc8jhiy3n5q0p5ha9bcsyvi92mf01"))))
    (properties `((upstream-name . "Deriv")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/Deriv")
    (synopsis "Symbolic differentiation")
    (description
     "This package provides an R-based solution for symbolic differentiation.
It admits user-defined functions as well as function substitution in arguments
of functions to be differentiated.  Some symbolic simplification is part of
the work.")
    (license license:gpl3+)))

(define-public r-doby
  (package
    (name "r-doby")
    (version "4.6.27")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doBy" version))
       (sha256
        (base32
         "1gb0907dd7n9i1k83dcljfiwxk4hcqzjw41qgwdw7pbklc6yhxg1"))))
    (properties `((upstream-name . "doBy")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-boot
           r-broom
           r-cowplot
           r-deriv
           r-dplyr
           r-ggplot2
           r-mass
           r-matrix
           r-microbenchmark
           r-modelr
           r-rlang
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-geepack r-knitr r-lme4 r-multcomp r-testthat))
    (home-page "https://people.math.aau.dk/~sorenh/software/doBy/")
    (synopsis "Groupwise statistics, LSmeans, linear contrasts, and utilities")
    (description
     "This package contains:

@itemize
@item facilities for working with grouped data: @code{do}
  something to data stratified @code{by} some variables.
@item implementations of least-squares means, general linear contrasts, and
@item miscellaneous other utilities.
@end itemize\n")
    (license license:gpl2+)))

(define-public r-refgenome
  (package
    (name "r-refgenome")
    (version "1.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "refGenome" version))
       (sha256
        (base32
         "1za89bn3am1zgvm641qi1ab6kaqpll4rb9p9f1sjwvcgqq6065g5"))))
    (properties `((upstream-name . "refGenome")))
    (build-system r-build-system)
    ;; FIXME: Tests fail with: No matches between query and reference seqid's
    ;; (wrong genome?)
    (arguments (list #:tests? #false))
    (propagated-inputs
     (list r-dbi r-doby r-rsqlite))
    (home-page "https://cran.r-project.org/web/packages/refGenome/")
    (synopsis
     "Gene and splice site annotation using annotation data from Ensembl and UCSC")
    (description
     "This package contains functionality for importing and managing of
downloaded genome annotation data from the Ensembl genome browser (European
Bioinformatics Institute) and from the UCSC genome browser (University of
California, Santa Cruz) and annotation routines for genomic positions and
splice site positions.")
    (license license:gpl2)))

(define-public r-reformulas
  (package
    (name "r-reformulas")
    (version "0.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "reformulas" version))
       (sha256
        (base32 "1pph0g306rkm5fyimbd6c0cz5wdwza1srvn6s3wg7lwihzpqbib0"))))
    (properties `((upstream-name . "reformulas")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-rdpack))
    (home-page "https://github.com/bbolker/reformulas")
    (synopsis "Machinery for processing random effect formulas")
    (description
     "This package lets you take formulas including random-effects
components (formatted as in @code{lme4}, @code{glmmTMB}, etc.) and process
them.  It includes various helper functions.")
    (license license:gpl3)))

(define-public r-basix
  (package
    (name "r-basix")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BASIX" version))
       (sha256
        (base32
         "18dkvv1iwskfnlpl6xridcgqpalbbpm2616mvc3hfrc0b26v01id"))))
    (properties `((upstream-name . "BASIX")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/BASIX/")
    (synopsis "Efficient C/C++ toolset for R")
    (description
     "BASIX provides some efficient C/C++ implementations of native R
procedures to speed up calculations in R.")
    (license license:gpl2)))

(define-public r-blackbox
  (package
    (name "r-blackbox")
    (version "1.1.46")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "blackbox" version))
       (sha256
        (base32 "03m93v5nk5zg039axkf02drdj2q165k73xk6waaiyi0b8w0sbl8l"))))
    (properties
     '((upstream-name . "blackbox")
       (updater-ignored-native-inputs . ("r-pkg"))))
    (build-system r-build-system)
    (propagated-inputs (list r-foreach
                             r-geometry
                             r-lattice
                             r-mass
                             r-matrixstats
                             r-nloptr
                             r-numderiv
                             r-pbapply
                             r-proxy
                             r-rcdd
                             r-rcpp
                             r-rcppeigen
                             r-spamm))
    (native-inputs (list r-testthat))
    (home-page "https://kimura.univ-montp2.fr/~rousset/Migraine.htm")
    (synopsis "Black box optimization and exploration of parameter space")
    (description
     "This package performs prediction of a response function from simulated
response values, allowing black-box optimization of functions estimated with
some error.  It includes a simple user interface for such applications, as
well as more specialized functions designed to be called by the Migraine
software (Rousset and Leblois, 2012 <doi:10.1093/molbev/MSR262>; Leblois et
al., 2014 <doi:10.1093/molbev/msu212>; and see URL).  The latter functions are
used for prediction of likelihood surfaces and implied likelihood ratio
confidence intervals, and for exploration of predictor space of the surface.
Prediction of the response is based on ordinary Kriging (with residual error)
of the input.  Estimation of smoothing parameters is performed by generalized
cross-validation.")
    (license license:cecill)))

(define-public r-blavaan
  (package
    (name "r-blavaan")
    (version "0.5-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "blavaan" version))
       (sha256
        (base32 "00pxi5zj68796b3qkil3w66z446ib61xl2l5v1qia1mc9fznlzri"))))
    (properties `((upstream-name . "blavaan")))
    (build-system r-build-system)
    (propagated-inputs (list r-bayesplot
                             r-bh
                             r-coda
                             r-future-apply
                             r-lavaan
                             r-loo
                             r-matrix
                             r-mnormt
                             r-nonnest2
                             r-rcpp
                             r-rcppeigen
                             r-rcppparallel
                             r-rstan
                             r-rstantools
                             r-stanheaders
                             r-tmvnsim))
    (native-inputs (list r-tinytest))
    (home-page "https://ecmerkle.github.io/blavaan/")
    (synopsis "Bayesian latent variable analysis")
    (description
     "This package lets you fit a variety of Bayesian latent variable models,
including confirmatory factor analysis, structural equation models, and latent
growth curve models.")
    (license license:gpl3+)))

(define-public r-blockfest
  (package
    (name "r-blockfest")
    (version "2.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "BlockFeST" version))
       (sha256
        (base32
         "1fcl3yc1cf09znqbj787d3fd2kl5rp63la7pxawsgmap7nxwkp65"))))
    (properties `((upstream-name . "BlockFeST")))
    (build-system r-build-system)
    (propagated-inputs (list r-basix))
    (home-page "https://cran.r-project.org/web/packages/BlockFeST/")
    (synopsis "Bayesian calculation of region-specific fixation index")
    (description
     "This package provides an R implementation of an extension of the
BayeScan software for codominant markers, adding the option to group
individual SNPs into pre-defined blocks.  A typical application of this new
approach is the identification of genomic regions, genes, or gene sets
containing one or more SNPs that evolved under directional selection.")
    (license license:gpl2)))

(define-public r-brglm2
  (package
    (name "r-brglm2")
    (version "0.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "brglm2" version))
       (sha256
        (base32 "0islmx4kdy22qn2cq7lpzqq6lc6mci5qly645nfdhad9001jmhsa"))))
    (properties `((upstream-name . "brglm2")))
    (build-system r-build-system)
    (propagated-inputs (list r-enrichwith r-mass r-matrix r-nnet r-numderiv))
    (native-inputs (list r-knitr))
    (home-page "https://github.com/ikosmidis/brglm2")
    (synopsis "Bias reduction in generalized linear models")
    (description
     "This is a package for estimation and inference from generalized linear
models based on various methods for bias reduction and maximum penalized
likelihood with powers of the Jeffreys prior as penalty.  The @code{brglmFit}
fitting method can achieve reduction of estimation bias by solving either the
mean bias-reducing adjusted score equations in Firth (1993)
<doi:10.1093/biomet/80.1.27> and Kosmidis and Firth
(2009) <doi:10.1093/biomet/asp055>, or the median bias-reduction adjusted
score equations in Kenne et al. (2017) <doi:10.1093/biomet/asx046>, or through
the direct subtraction of an estimate of the bias of the maximum likelihood
estimator from the maximum likelihood estimates as in Cordeiro and
McCullagh (1991) <https://www.jstor.org/stable/2345592>.")
    (license license:gpl3)))

(define-public r-proc
  (package
    (name "r-proc")
    (version "1.18.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "pROC" version))
       (sha256
        (base32
         "129cnh3kh9sr42nc7n9f14kr9svi3501834x40njynnzlr0wi4sm"))))
    (properties
     '((upstream-name . "pROC")
       (updater-extra-native-inputs . ("r-ggplot2" "r-mass"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-plyr r-rcpp))
    (native-inputs (list r-ggplot2 r-mass r-testthat))
    (home-page "https://web.expasy.org/pROC/")
    (synopsis "Display and analyze ROC curves")
    (description
     "This package provides tools for visualizing, smoothing and comparing
receiver operating characteristic (ROC curves).  The area under the
curve (AUC) can be compared with statistical tests based on U-statistics or
bootstrap.  Confidence intervals can be computed for (p)AUC or ROC curves.")
    (license license:gpl3+)))

(define-public r-rootsolve
  (package
    (name "r-rootsolve")
    (version "1.8.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "rootSolve" version))
       (sha256
        (base32
         "0p9qmn82bg0ks9hmh2dkygnzhxcnp5z8z8b8aq52w6clliz32sp1"))))
    (properties `((upstream-name . "rootSolve")))
    (build-system r-build-system)
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/web/packages/rootSolve/")
    (synopsis "Tools for the analysis of ordinary differential equations")
    (description
     "This package provides routines to find the root of nonlinear functions,
and to perform steady-state and equilibrium analysis of @dfn{ordinary
differential equations} (ODE).  It includes routines that:

@enumerate
@item generate gradient and jacobian matrices (full and banded),
@item find roots of non-linear equations by the Newton-Raphson method,
@item estimate steady-state conditions of a system of (differential) equations
  in full, banded or sparse form, using the Newton-Raphson method, or by
  dynamically running,
@item solve the steady-state conditions for uni- and multicomponent 1-D, 2-D,
  and 3-D partial differential equations, that have been converted to ordinary
  differential equations by numerical differencing (using the method-of-lines
  approach).
@end enumerate\n")
    (license license:gpl2+)))

(define-public r-abcanalysis
  (package
    (name "r-abcanalysis")
    (version "1.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCanalysis" version))
       (sha256
        (base32 "0wac1ksmnxa36v99ca4hv8k0rsh3igwpcllmlv9wf7i9kgqviqwi"))))
    (properties `((upstream-name . "ABCanalysis")))
    (build-system r-build-system)
    (propagated-inputs (list r-plotrix))
    (home-page "https://www.uni-marburg.de/fb12/arbeitsgruppen/datenbionik/software-en/")
    (synopsis "Computed ABC Analysis")
    (description
     "Multivariate data sets often differ in several factors or derived statistical
parameters, which have to be selected for a valid interpretation.  Basing this
selection on traditional statistical limits leads occasionally to the perception
of losing information from a data set.  This package provides tools to calculate
these limits on the basis of the mathematical properties of the distribution of
the analyzed items.")
    (license license:gpl3)))

(define-public r-slam
  (package
    (name "r-slam")
    (version "0.1-55")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "slam" version))
       (sha256
        (base32 "00qwx6yrsqxa8kk2dn8i024a2cq1hcg9801k0rari9rb006lbf0g"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/slam/")
    (synopsis "Sparse lightweight arrays and matrices")
    (description
     "This package contains data structures and algorithms for sparse arrays and matrices,
based on index arrays and simple triplet representations, respectively.")
    (license license:gpl2)))

(define-public r-slanter
  (package
    (name "r-slanter")
    (version "0.2-0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "slanter" version))
       (sha256
        (base32 "024dkman0r5qzc215gw0ds932vdaz8krrhv64fjw9pni37ixc3mf"))))
    (properties `((upstream-name . "slanter")))
    (build-system r-build-system)
    (propagated-inputs (list r-matrix r-pheatmap r-pracma))
    (native-inputs (list r-knitr))
    (home-page "https://cran.r-project.org/package=slanter")
    (synopsis "Slanted matrices and ordered clustering")
    (description
     "This is a package for slanted matrices and ordered clustering for better
visualization of similarity data.")
    (license license:expat)))

(define-public r-manipulatewidget
  (package
    (name "r-manipulatewidget")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "manipulateWidget" version))
       (sha256
        (base32 "1dpgzmiv08afm57yxr017b014lfn9h3pa4w65prk5k3dgn6p4wsv"))))
    (properties
     `((upstream-name . "manipulateWidget")))
    (build-system r-build-system)
    (arguments
     (list
      #:modules '((guix build r-build-system)
                  (guix build minify-build-system)
                  (guix build utils)
                  (ice-9 match))
      #:imported-modules `(,@%r-build-system-modules
                           (guix build minify-build-system))
      #:phases
      '(modify-phases (@ (guix build r-build-system) %standard-phases)
         (add-after 'unpack 'process-javascript
           (lambda* (#:key inputs #:allow-other-keys)
             (with-directory-excursion "inst/lib/export"
               (for-each (match-lambda
                           ((source . target)
                            (minify source #:target target)))
                         `((,(assoc-ref inputs "js-html2canvas")
                            . "html2canvas/html2canvas.js")
                           (,(search-input-file inputs "FileSaver.js")
                            . "FileSaver/FileSaver.min.js")))))))))
    (propagated-inputs
     (list r-base64enc
           r-codetools
           r-htmltools
           r-htmlwidgets
           r-knitr
           r-miniui
           r-shiny
           r-shinyjs
           r-webshot))
    (native-inputs
     `(("esbuild" ,esbuild)
       ("r-knitr" ,r-knitr)
       ("r-testthat" ,r-testthat)
       ;; inst/lib/export/html2canvas/html2canvas.js, version 1.0.0-rc.3
       ("js-html2canvas"
        ,(let ((version "1.0.0-rc.3"))
           (origin
             (method url-fetch)
             (uri (string-append
                   "https://github.com/niklasvh/html2canvas/"
                   "releases/download/v" version "/html2canvas.js"))
             (sha256
              (base32
               "0gxw8ihxkiwhh8hs8n7k1fsim7gq7v31h89fc9k2dw3namg7m2qp")))))
       ;; inst/lib/export/FileSaver/FileSaver.min.js
       ("js-filesaver"
        ,(let ((version "1.2.0"))
           (origin
             (method git-fetch)
             (uri (git-reference
                   (url "https://github.com/eligrey/FileSaver.js")
                   (commit version)))
             (file-name (git-file-name "js-filesaver" version))
             (sha256
              (base32
               "07mw01056fk36pganhs27y8rl5y5hrdsm945pwbbvmdjnzq4ijny")))))))
    (home-page "https://github.com/rte-antares-rpackage/manipulateWidget/")
    (synopsis "Add even more interactivity to interactive charts")
    (description
     "This package lets you create in just a few lines of R code a nice user interface to
modify the data or the graphical parameters of one or multiple interactive
charts.  It is useful to quickly explore visually some data or for package
developers to generate user interfaces easy to maintain.")
    (license license:gpl2+)))

(define-public r-a3
  (package
    (name "r-a3")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "A3" version))
       (sha256
        (base32 "017hq9pjsv1h9i7cqk5cfx27as54shlhdsdvr6jkhb8jfkpdb6cw"))))
    (properties `((upstream-name . "A3")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-pbapply r-xtable))
    (home-page "https://cran.r-project.org/web/packages/A3/")
    (synopsis "Error metrics for predictive models")
    (description
     "This package supplies tools for tabulating and analyzing the results of predictive
models.  The methods employed are applicable to virtually any predictive model
and make comparisons between different methodologies straightforward.")
    (license license:gpl2+)))

(define-public r-infotheo
  (package
    (name "r-infotheo")
    (version "1.2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "infotheo" version))
       (sha256
        (base32
         "1m1979vf8rvq3534mp1hihfadikhxrg3p6ac3hirz96kgb4qxyy0"))))
    (build-system r-build-system)
    (home-page "http://homepage.meyerp.com/software")
    (synopsis "Information-theoretic measures")
    (description
     "This package implements various measures of information theory based on
several entropy estimators.")
    (license license:gpl3+)))

(define-public r-nsprcomp
  (package
    (name "r-nsprcomp")
    (version "0.5.1-2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "nsprcomp" version))
       (sha256
        (base32
         "1zlc1ximx96f235c0l8qfs6vbp1kpnbf943wxsfahnnlnxvwi59f"))))
    (properties `((upstream-name . "nsprcomp")))
    (build-system r-build-system)
    (native-inputs (list r-testthat))
    (home-page "https://sigg-iten.ch/research/")
    (synopsis "Non-negative and sparse PCA")
    (description
     "This package implements two methods for performing a constrained
principal component analysis (PCA), where non-negativity and/or sparsity
constraints are enforced on the principal axes (PAs).  The function
@code{nsprcomp} computes one principal component (PC) after the other.  Each
PA is optimized such that the corresponding PC has maximum additional variance
not explained by the previous components.  In contrast, the function
@code{nscumcomp} jointly computes all PCs such that the cumulative variance is
maximal.  Both functions have the same interface as the @code{prcomp} function
from the @code{stats} package (plus some extra parameters).")
    (license license:gpl2+)))

(define-public r-cmaesr
  (package
    (name "r-cmaesr")
    (version "1.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cmaesr" version))
       (sha256
        (base32 "03zx2nrw24wmmjjpyh8pswasjjq0amf0g375fm2b3s111dx8fbj9"))))
    (properties `((upstream-name . "cmaesr")))
    (build-system r-build-system)
    (propagated-inputs (list r-bbmisc r-checkmate r-ggplot2 r-paramhelpers
                             r-smoof))
    (home-page "https://github.com/jakobbossek/cmaesr")
    (synopsis "Covariance matrix adaptation evolution strategy")
    (description
     "This is a pure R implementation of the Covariance Matrix Adaptation
Evolution Strategy (CMA-ES) with optional restarts (IPOP-CMA-ES).")
    (license license:bsd-2)))

(define-public r-cmplot
  (package
    (name "r-cmplot")
    (version "4.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "CMplot" version))
       (sha256
        (base32
         "0ml6n1wjxrnq13042jihpjlmm6vmkaiks9n49qp7v7rg47gn2ik8"))))
    (properties `((upstream-name . "CMplot")))
    (build-system r-build-system)
    (home-page "https://github.com/YinLiLin/CMplot")
    (synopsis "Circle Manhattan plot")
    (description
     "Circle Manhattan Plot is an R package that can lay out genome-wide
association study P-value results in both traditional rectangular patterns,
QQ-plot and novel circular ones.  United in only one bull's eye style plot,
association results from multiple traits can be compared interactively,
thereby to reveal both similarities and differences between signals.
Additional functions include: highlight signals, a group of SNPs, chromosome
visualization and candidate genes around SNPs.")
    (license license:gpl2+)))

(define-public r-precrec
  (package
    (name "r-precrec")
    (version "0.14.5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "precrec" version))
       (sha256
        (base32
         "1n13zfmbbw7y73j09wkdpzyh5z6vkczljv5pr75lphcawshdyfa1"))))
    (properties `((upstream-name . "precrec")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-assertthat
           r-data-table
           r-ggplot2
           r-gridextra
           r-rcpp
           r-rlang
           r-withr))
    (native-inputs (list r-knitr r-testthat r-vdiffr))
    (home-page "https://evalclass.github.io/precrec/")
    (synopsis "Calculate accurate precision-recall and ROC curves")
    (description
     "This package provides tools for accurate calculations and visualization
of precision-recall and ROC (Receiver Operator Characteristics) curves.")
    (license license:gpl3)))

(define-public r-netrep
  (package
    (name "r-netrep")
    (version "1.2.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "NetRep" version))
       (sha256
        (base32
         "02ss45giv30pi31b5rysa36bn5c4fs5x58g4vb0arz9cnicznv97"))))
    (properties `((upstream-name . "NetRep")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abind
           r-bh
           r-foreach
           r-rcolorbrewer
           r-rcpp
           r-rcpparmadillo
           r-rhpcblasctl
           r-statmod))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://cran.r-project.org/package=NetRep")
    (synopsis "Permutation testing network module preservation across datasets")
    (description
     "This package provides functions for assessing the
replication/preservation of a network module's topology across datasets
through permutation testing.")
    (license license:gpl2)))

(define-public r-intergraph
  (package
    (name "r-intergraph")
    (version "2.0-4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "intergraph" version))
       (sha256
        (base32
         "1jarzhrgm5g8z2h10h8x7jk9q2al6rx5kgnwvwi2199am6gjypsq"))))
    (properties `((upstream-name . "intergraph")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-igraph r-network))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://mbojan.github.io/intergraph")
    (synopsis "Coercion routines for network data objects")
    (description
     "Functions implemented in this package allow coercing (i.e. convert)
network data between classes provided by other R packages.  Currently
supported classes are those defined in packages @code{network} and
@code{igraph}.")
    (license license:gpl3)))

(define-public r-interp
  (package
    (name "r-interp")
    (version "1.1-6")
    (source (origin
              (method url-fetch)
              (uri (cran-uri "interp" version))
              (sha256
               (base32
                "0d6ddvm94113d9bjhghjsfbhgz44q0lkjc2l809dzv1lad708x1n"))))
    (properties `((upstream-name . "interp")))
    (build-system r-build-system)
    (propagated-inputs (list r-deldir r-rcpp r-rcppeigen))
    (native-inputs (list gfortran))
    (home-page "https://cran.r-project.org/package=interp")
    (synopsis "Interpolation methods")
    (description
     "Bivariate data interpolation on regular and irregular grids, either
linear or using splines are the main part of this package.  It is intended to
provide replacement functions for the ACM licensed @code{akima::interp} and
@code{tripack::tri.mesh} functions.")
    (license license:gpl2+)))

(define-public r-abcoptim
  (package
    (name "r-abcoptim")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCoptim" version))
       (sha256
        (base32 "1ih0xk88qhsmpvnxf56041wx5sk8as2f4f2gdnpnwdym9mbr9n4b"))))
    (properties `((upstream-name . "ABCoptim")))
    (build-system r-build-system)
    (propagated-inputs (list r-rcpp))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/gvegayon/ABCoptim/")
    (synopsis "Optimization of Artificial Bee Colony algorithm")
    (description
     "Artificial Bee Colony (ABC) is one of the most recently defined algorithms by Dervis
Karaboga in 2005, motivated by the intelligent behavior of honey bees.  It is as
simple as Particle Swarm Optimization (PSO) and Differential Evolution (DE)
algorithms, and uses only common control parameters such as colony size and
maximum cycle number.  The @code{r-abcoptim} implements the Artificial bee
colony optimization algorithm @url{http://mf.erciyes.edu.tr/abc/pub/tr06_2005.pdf}.
  This version is a work-in-progress and is written in R code.")
    (license license:expat)))

(define-public r-abcp2
  (package
    (name "r-abcp2")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABCp2" version))
       (sha256
        (base32 "1s2skkxpzss7c29i8600psgrp0hl46jcrxqrmy2b4db8hc0kcnbx"))))
    (properties `((upstream-name . "ABCp2")))
    (build-system r-build-system)
    (propagated-inputs (list r-mass))
    (home-page "https://cran.r-project.org/web/packages/ABCp2/")
    (synopsis "Approximate Bayesian Computational Model for Estimating P2")
    (description
     "This package tests the goodness of fit of a distribution of offspring to the Normal,
Poisson, and Gamma distribution and estimates the proportional paternity of the
second male (P2) based on the best fit distribution.")
    (license license:gpl2)))

(define-public r-abcrf
  (package
    (name "r-abcrf")
    (version "1.9")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abcrf" version))
       (sha256
        (base32 "08mh1a6gxp0mfx6qnp1qzcrfx7xp64qj9kad4ziyswfx22ykdsxi"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-doparallel
           r-foreach
           r-mass
           r-matrixstats
           r-ranger
           r-rcpp
           r-rcpparmadillo
           r-readr
           r-stringr))
    (home-page "https://cran.r-project.org/web/packages/abcrf/")
    (synopsis "Approximate bayesian computation via random forests")
    (description
     "This package performs approximate bayesian computation (ABC) model choice and
parameter inference via random forests.  This machine learning tool named random
forests (RF) can conduct selection among the highly complex models covered by
ABC algorithms.")
    (license license:gpl2+)))

(define-public r-abctools
  (package
    (name "r-abctools")
    (version "1.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abctools" version))
       (sha256
        (base32 "16gn5hk25glbjml7bclxqkybi90gqjijz6hl6ak8aig5wm08pgx2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-abc r-abind r-hmisc r-plyr))
    (home-page "https://github.com/dennisprangle/abctools/")
    (synopsis "Tools for ABC analyses")
    (description
     "This @code{r-abctools} package provides tools for approximate Bayesian computation
including summary statistic selection and assessing coverage.  This includes
recent dimension reduction algorithms to tune the choice of summary statistics,
and coverage methods to tune the choice of threshold.")
    (license license:gpl2+)))

(define-public r-ggstance
  (package
    (name "r-ggstance")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggstance" version))
       (sha256
        (base32 "0v25si348qdp68887yx4d652rsz8w5lfabwaq1nvglrhs6s4f9js"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli r-ggplot2 r-plyr r-rlang r-withr))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/ggstance/")
    (synopsis "Horizontal and vertical versions of @code{r-ggplot2}")
    (description
     "This package is a @code{r-ggplot2} extension that provides flipped components:
@enumerate
@item horizontal versions of @code{r-ggplot2} stats and @code{r-ggplot2} geoms;
@item vertical versions of @code{r-ggplot2} positions.
@end enumerate")
    (license license:gpl3)))

(define-public r-ggnetwork
  (package
    (name "r-ggnetwork")
    (version "0.5.13")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggnetwork" version))
       (sha256
        (base32
         "0ipxw6j36n0hfn0nsimw8jbjszvm1d0hadwg4zirvn6v36npwabc"))))
    (properties `((upstream-name . "ggnetwork")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-ggrepel r-igraph r-network r-sna))
    (native-inputs (list r-knitr r-testthat))
    (home-page "https://github.com/briatte/ggnetwork")
    (synopsis "Geometries to plot networks with ggplot2")
    (description
     "This package provides geometries to plot network objects with the
ggplot2 package.")
    (license license:gpl3)))

(define-public r-cvauc
  (package
    (name "r-cvauc")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "cvAUC" version))
       (sha256
        (base32
         "1m2y50a1yapf1c74km9a4r47ds2z2bfp4wwwkqin7swv9v1s7d28"))))
    (properties `((upstream-name . "cvAUC")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-data-table r-rocr))
    (home-page "https://github.com/ledell/cvAUC")
    (synopsis "Cross-validated area under the ROC curve confidence intervals")
    (description
     "This package contains various tools for working with and evaluating
cross-validated area under the ROC curve (AUC) estimators.  The primary
functions of the package are @code{ci.cvAUC} and @code{ci.pooled.cvAUC}, which
report cross-validated AUC and compute confidence intervals for
cross-validated AUC estimates based on influence curves for i.i.d. and pooled
repeated measures data, respectively.")
    (license license:asl2.0)))

(define-public r-gam
  (package
    (name "r-gam")
    (version "1.22-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "gam" version))
       (sha256
        (base32
         "0mg9h8hm76wz8fbppfirgmqm1x70n3q13mmy8wdpi0h9bq0a2cvx"))))
    (properties `((upstream-name . "gam")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach))
    (native-inputs
     (list gfortran r-testthat))
    (home-page "https://cran.r-project.org/package=gam")
    (synopsis "Generalized additive models")
    (description
     "This package provides functions for fitting and working with generalized
additive models, as described in chapter 7 of \"Statistical Models in
S\" (Chambers and Hastie (eds), 1991), and \"Generalized Additive
Models\" (Hastie and Tibshirani, 1990).")
    (license license:gpl2)))

(define-public r-superlearner
  (package
    (name "r-superlearner")
    (version "2.0-29")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "SuperLearner" version))
       (sha256
        (base32
         "0g1baz8jakgfwdh5bd9hrg1nm4ljpnxiiy5pmf00d27ld7wh6sr3"))))
    (properties `((upstream-name . "SuperLearner")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cvauc r-gam r-nnls))
    (native-inputs
     (list r-knitr r-rmarkdown r-testthat))
    (home-page "https://github.com/ecpolley/SuperLearner")
    (synopsis "Super learner prediction")
    (description
     "This package implements the super learner prediction method and contains
a library of prediction algorithms to be used in the super learner.")
    (license license:gpl3)))

(define-public r-drtmle
  (package
    (name "r-drtmle")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "drtmle" version))
       (sha256
        (base32
         "0qvdxzvpi7a66gx61v6fj31zy4y5cid18g4qgv5lir7qc74rbbx0"))))
    (properties
     '((upstream-name . "drtmle")
       (updater-extra-native-inputs . ("r-nloptr"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-future-apply r-np r-superlearner))
    (native-inputs
     (list r-knitr r-nloptr r-testthat))
    (home-page "https://github.com/benkeser/drtmle")
    (synopsis "Doubly-robust nonparametric estimation and inference")
    (description
     "This package implements targeted minimum loss-based estimators of
counterfactual means and causal effects that are doubly-robust with respect
both to consistency and asymptotic normality.")
    (license license:expat)))

(define-public r-dofuture
  (package
    (name "r-dofuture")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "doFuture" version))
       (sha256
        (base32
         "1bi07qs7gny79gjz3hk5m1j1aggmp9g68n0abdzimnn0wdcmvw2a"))))
    (properties `((upstream-name . "doFuture")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list r-foreach r-future r-future-apply r-globals r-iterators))
    (native-inputs
     (list r-r-rsp))                    ;vignette builder
    (home-page "https://github.com/HenrikBengtsson/doFuture")
    (synopsis "Foreach parallel adapter using the future API")
    (description
     "This package provides a @code{%dopar%} adapter such that any type of
futures can be used as backends for the @code{foreach} framework.")
    (license license:lgpl2.1+)))

(define-public r-superheat
  (package
    (name "r-superheat")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "superheat" version))
       (sha256
        (base32
         "01v8s6px1k5fajlm6py3ksr1i853kwwlky1yryzhy3p1cxhwgg83"))))
    (properties `((upstream-name . "superheat")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-ggdendro
           r-ggplot2
           r-gtable
           r-magrittr
           r-plyr
           r-scales))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/package=superheat")
    (synopsis "Graphical tool for exploring complex datasets using heatmaps")
    (description
     "This package provides a system for generating extendable and
customizable heatmaps for exploring complex datasets, including big data and
data with multiple data types.")
    (license license:cc0)))

(define-public r-qualv
  (package
    (name "r-qualv")
    (version "0.3-5")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "qualV" version))
       (sha256
        (base32
         "09qqfx94f46x585iipr9wii8ji6ih31xymbw4p5v3qixmfpja276"))))
    (properties `((upstream-name . "qualV")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-kernsmooth))
    (home-page "https://qualV.R-Forge.R-Project.org/")
    (synopsis "Qualitative Validation Methods")
    (description
     "This package provides qualitative methods for the validation of dynamic
models.  It contains

@enumerate
@item an orthogonal set of deviance measures for absolute, relative and
  ordinal scale and
@item approaches accounting for time shifts.
@end enumerate

The first approach transforms time to take time delays and speed differences
into account.  The second divides the time series into interval units
according to their main features and finds the @dfn{longest common
subsequence} (LCS) using a dynamic programming algorithm.")
    (license license:gpl2+)))

(define-public r-mosaiccore
  (package
    (name "r-mosaiccore")
    (version "0.9.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaicCore" version))
       (sha256
        (base32 "0v3xhv6yfk1hc6a40jjgp6vvq102qa1l4n787pfywx6jhzbhamp2"))))
    (properties `((upstream-name . "mosaicCore")))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; Two tests fail with accuracy problems.
             (delete-file "tests/testthat/test-interval-calculations.R"))))))
    (propagated-inputs
     (list r-dplyr r-mass r-rlang r-tidyr))
    (native-inputs (list r-mosaicdata r-testthat))
    (home-page "https://github.com/ProjectMOSAIC/mosaicCore/")
    (synopsis "Common utilities for mosaic family packages")
    (description
     "Common utilities used in other Mosaic family packages are collected here.")
    (license license:gpl2+)))

(define-public r-labelled
  (package
    (name "r-labelled")
    (version "2.14.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "labelled" version))
       (sha256
        (base32
         "01mi9vly79p5mir6wwfak0mbxnagaw01rd2fa539lfiwr49bllwc"))))
    (properties `((upstream-name . "labelled")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cli
           r-dplyr
           r-haven
           r-lifecycle
           r-rlang
           r-stringr
           r-tidyr
           r-tidyselect
           r-vctrs))
    (native-inputs
     (list r-knitr r-spelling r-testthat))
    (home-page "https://larmarange.github.io/labelled/")
    (synopsis "Manipulating labelled data")
    (description
     "This package provides useful functions to deal with the
@code{haven_labelled} and @code{haven_labelled_spss} classes introduced by the
haven package.")
    (license license:gpl3)))

(define-public r-ggformula
  (package
    (name "r-ggformula")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ggformula" version))
       (sha256
        (base32 "0vbpivyxms46px3wqkbl1wq199mqdxq94gsiplv4i7lz0lzghsfm"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file requires r-mosaic, which we can't add because of a
             ;; dependency cycle.
             (delete-file "tests/testthat/test-layer-factory.R"))))))
    (propagated-inputs
     (list r-ggplot2
           r-ggridges
           r-labelled
           r-mosaiccore
           r-rlang
           r-scales
           r-stringr
           r-tibble))
    (native-inputs
     (list r-knitr r-palmerpenguins r-testthat))
    (home-page "https://github.com/ProjectMOSAIC/ggformula/")
    (synopsis "Formula interface for the @code{r-ggplot2}")
    (description
     "The @code{r-ggformula} introduces a family of graphics functions, gf_point(),
gf_density(), and so on, bring the formula interface to ggplot().  This captures
and extends the excellent simplicity of the lattice-graphics formula interface,
while providing the intuitive capabilities of @code{r-ggplot2}.")
    (license license:expat)))

(define-public r-mosaicdata
  (package
    (name "r-mosaicdata")
    (version "0.20.4")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaicData" version))
       (sha256
        (base32 "0y6ii234paknak0p8cm5wcjia4s4wh7iixjbbvdgp0w17c05dckh"))))
    (properties `((upstream-name . "mosaicData")))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/mosaicData/")
    (synopsis "Data sets for project Mosaic")
    (description
     "This package provides data sets from project Mosaic @url{http://mosaic-web.org}
used to teach mathematics, statistics, computation and modeling.")
    (license license:gpl2+)))

(define-public r-raster
  (package
    (name "r-raster")
    (version "3.6-32")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "raster" version))
       (sha256
        (base32
         "14h61mq4jsjvpfbn023dhy8wdqlkv46md3gdv8pancczikpal2ih"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-rcpp r-sp r-terra))
    (native-inputs (list r-tinytest))
    (home-page "https://www.rspatial.org/")
    (synopsis "Geographic data analysis and modeling")
    (description
     "The package implements basic and high-level functions for reading,
writing, manipulating, analyzing and modeling of gridded spatial data.
Processing of very large files is supported.")
    (license license:gpl3+)))

(define-public r-mosaic
  (package
    (name "r-mosaic")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "mosaic" version))
       (sha256
        (base32 "0l7h3zg5izr5xxqy1sngz6fzbwdffzljnjmfbshzzbl4x80f5lwl"))))
    (build-system r-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'delete-bad-tests
           (lambda _
             ;; This file contains tests that attempt to download data files
             ;; off the internet.
             (delete-file "tests/testthat/test-read.file.R")
             ;; Unknown failure.
             (delete-file "tests/testthat/test-ladd.R"))))))
    (propagated-inputs
     (list r-dplyr
           r-ggformula
           r-ggplot2
           r-lattice
           r-mass
           r-matrix
           r-mosaiccore
           r-mosaicdata
           r-purrr
           r-rlang
           r-tibble
           r-tidyr))
    (native-inputs
     (list r-broom r-ggdendro r-ggrepel r-knitr r-latticeextra r-testthat))
    (home-page "https://github.com/ProjectMOSAIC/mosaic/")
    (synopsis "Mathematics, statistics, and computation teaching utilities")
    (description
     "This package contain data sets and utilities from
@url{http://mosaic-web.org, Project MOSAIC} used to teach mathematics,
statistics, computation and modeling.  Project MOSAIC is a community of
educators working to tie together aspects of quantitative work that students
in science, technology, engineering and mathematics will need in their
professional lives, but which are usually taught in isolation, if at all.")
    (license license:gpl2+)))

(define-public r-abd
  (package
    (name "r-abd")
    (version "0.2-8")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abd" version))
       (sha256
        (base32 "191gspqzdv573vaw624ri0f5cm6v4j524bjs74d4a1hn3kn6r9b7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-lattice r-mosaic r-nlme))
    (home-page "https://cran.r-project.org/web/packages/abd/")
    (synopsis "Analysis of biological data")
    (description
     "The @code{r-abd} package contains data sets and sample code for the Analysis of
biological data by Michael Whitlock and Dolph Schluter.")
    (license license:gpl2)))

(define-public r-svgui
  (package
    (name "r-svgui")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svGUI" version))
       (sha256
        (base32 "0ch5gdfk834xj9w3vxpm3x4770fz3nnlyn8b0jsw9f3n2as7g979"))))
    (properties `((upstream-name . "svGUI")))
    (build-system r-build-system)
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/SciViews/svGUI/")
    (synopsis "Functions for managing GUI clients in R")
    (description
     "The SciViews @code{svGUI} package eases the management of Graphical User
Interfaces (GUI) in R.  It is independent from any particular GUI widgets.  It
centralizes info about GUI elements currently used, and it dispatches GUI
calls to the particular toolkits in use in function of the context.")
    (license license:gpl2)))

(define-public r-svdialogs
  (package
    (name "r-svdialogs")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svDialogs" version))
       (sha256
        (base32 "0z3a5glsi0ab43mdk2yvslxyzg12nbqqqc35jvgzj475mpkbgjif"))))
    (properties `((upstream-name . "svDialogs")))
    (build-system r-build-system)
    (inputs
     (list yad zenity))
    (propagated-inputs
     (list r-rstudioapi r-svgui))
    (native-inputs
     (list r-knitr r-testthat))
    (home-page "https://github.com/SciViews/svDialogs/")
    (synopsis "Portable dialog boxes")
    (description
     "This package helps to construct standard dialog boxes for your GUI, including
message boxes, input boxes, list, file or directory selection, and others.  In
case R cannot display GUI dialog boxes, a simpler command line version of these
interactive elements is also provided as a fallback solution.")
    (license license:gpl2)))

(define-public r-svunit
  (package
    (name "r-svunit")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "svUnit" version))
       (sha256
        (base32 "08nmlbdrmmz04ira30721l99i74w07w2avdr4pypswf2sq1nqgi6"))))
    (properties `((upstream-name . "svUnit")))
    (build-system r-build-system)
    (native-inputs (list r-knitr))
    (home-page "https://github.com/SciViews/svUnit")
    (synopsis "Unit, integration and system testing")
    (description
     "This package provides a complete unit test system and functions to
implement its GUI part.")
    (license license:gpl2)))

(define-public r-abe
  (package
    (name "r-abe")
    (version "5.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abe" version))
       (sha256
        (base32
         "0i1ziyydma5vgr2c3qmi53cximvj2hqpfz2vzxkfby1n4cyc50y2"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-foreach
           r-ggplot2
           r-lifecycle
           r-reshape2
           r-survival
           r-tidytext))
    (native-inputs
     (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/abe/")
    (synopsis "Augmented backward elimination")
    (description
     "This package performs augmented backward elimination and checks the
stability of the obtained model.  Augmented backward elimination combines
significance or information based criteria with the change in estimate to
either select the optimal model for prediction purposes or to serve as a tool
to obtain a practically sound, highly interpretable model.")
    (license license:gpl2+)))

(define-public r-abf2
  (package
    (name "r-abf2")
    (version "0.7-1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abf2" version))
       (sha256
        (base32 "0d65mc1w4pbiv7xaqzdlw1bfsxf25587rv597hh41vs0j0zlfpxx"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/abf2/")
    (synopsis "Load gap-free axon @code{r-abf2} files")
    (description
     "This package loads electrophysiology data from ABF2 files, as created by
Axon Instruments/Molecular Devices software.  Only files recorded in gap-free
mode are currently supported.")
    (license license:artistic2.0)))

(define-public r-abhgenotyper
  (package
    (name "r-abhgenotyper")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABHgenotypeR" version))
       (sha256
        (base32 "08cpmnaaxsm5c5bjifnfxdlvg5inrf13biqpcl2yq5zpqjmiki0l"))))
    (properties `((upstream-name . "ABHgenotypeR")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-ggplot2 r-reshape2))
    (home-page "https://github.com/StefanReuscher/ABHgenotypeR/")
    (synopsis "Visualize and manipulate ABH genotypes")
    (description
     "The @code{r-abhgenotyper} package provides simple imputation,
error-correction and plotting capacities for genotype data.  The package is
supposed to serve as an intermediate but independent analysis tool between the
TASSEL GBS pipeline and the @code{r-qtl} package.  It provides functionalities
not found in either TASSEL or @code{r-qtl} in addition to visualization of
genotypes as \"graphical genotypes\".")
    (license license:gpl3)))

(define-public r-furrr
  (package
    (name "r-furrr")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "furrr" version))
       (sha256
        (base32
         "12z4q0fn7asxis17hisi82bvfabl5if1338lmfqmkrwv5rg7748d"))))
    (build-system r-build-system)
    (properties
     '((updater-extra-native-inputs . ("r-dplyr"))))
    (propagated-inputs
     (list r-future
           r-globals
           r-lifecycle
           r-purrr
           r-rlang
           r-vctrs))
    (native-inputs (list r-dplyr r-testthat))
    (home-page "https://github.com/DavisVaughan/furrr")
    (synopsis "Apply mapping functions in parallel using futures")
    (description
     "This package provides implementations of the family of @code{map()}
functions from the @code{purrr} package that can be resolved using any
@code{future}-supported backend, e.g. parallel on the local machine or
distributed on a compute cluster.")
    (license license:lgpl2.1+)))

(define-public r-abjutils
  (package
    (name "r-abjutils")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abjutils" version))
       (sha256
        (base32 "0lmf4va8qnzwg698i2h4fcwvd6dhsgdkqsfh41aa3wg1flimhsr7"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-dplyr
           r-magrittr
           r-purrr
           r-rlang
           r-rstudioapi
           r-stringi
           r-stringr
           r-tidyr))
    (native-inputs (list r-testthat))
    (home-page "https://github.com/abjur/abjutils/")
    (synopsis "Collection of tools for jurimetrical analysis")
    (description
     "This package implements general purpose tools, such as functions for
sampling and basic manipulation of Brazilian lawsuits identification number.
It also implements functions for text cleaning, such as accentuation
removal.")
    (license license:expat)))

(define-public r-abnormality
  (package
    (name "r-abnormality")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abnormality" version))
       (sha256
        (base32 "1fzfskl9akl06nliy8hkv2a0pznpj8pwcypg3gj5r2nzvr3kan9v"))))
    (build-system r-build-system)
    (propagated-inputs
     (list r-mass r-matrix))
    (home-page "https://cran.r-project.org/web/packages/abnormality/")
    (synopsis "Measure a subject's abnormality with respect to a reference population")
    (description
     "This package contains functions to implement the methodology and
considerations laid out by Marks et al. in the article \"Measuring abnormality
in high dimensional spaces: applications in biomechanical gait analysis\".
Using high-dimensional datasets to measure a subject's overall level of
abnormality as compared to a reference population is often needed in outcomes
research.")
    (license license:expat)))

(define-public r-abodoutlier
  (package
    (name "r-abodoutlier")
    (version "0.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "abodOutlier" version))
       (sha256
        (base32 "1pvhgxmh23br84r0fbmv7g53z2427birdja96a67vqgz18r3fdvj"))))
    (properties `((upstream-name . "abodOutlier")))
    (build-system r-build-system)
    (propagated-inputs
     (list r-cluster))
    (home-page "https://cran.r-project.org/web/packages/abodOutlier/")
    (synopsis "Angle-based outlier detection")
    (description
     "This package performs angle-based outlier detection on a given data
frame.  It offers three methods to process data:
@enumerate
@item full but slow implementation using all the data that has cubic
  complexity;
@item a fully randomized method;
@item a method using k-nearest neighbours.
@end enumerate
These algorithms are well suited for high dimensional data outlier
detection.")
    (license license:expat)))

(define-public r-abps
  (package
    (name "r-abps")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "ABPS" version))
       (sha256
        (base32 "0n3f66nmfi5v94il1mxy026mi84w01ph2aljk60vn3mrz8kwf2ll"))))
    (properties `((upstream-name . "ABPS")))
    (build-system r-build-system)
    (propagated-inputs (list r-kernlab))
    (native-inputs (list r-testthat))
    (home-page "https://cran.r-project.org/web/packages/ABPS/")
    (synopsis "Abnormal blood profile score to detect blood doping")
    (description
     "This package offers an implementation of the @dfn{Abnormal blood profile score} (ABPS).
The ABPS is a part of the Athlete biological passport program of the World
anti-doping agency, which combines several blood parameters into a single
score in order to detect blood doping.  The package also contains functions to
calculate other scores used in anti-doping programs, such as the ratio of
hemoglobin to reticulocytes (OFF-score), as well as example data.")
    (license license:gpl2+)))

(define-public r-parmigene
  (package
    (name "r-parmigene")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (cran-uri "parmigene" version))
       (sha256
        (base32
         "03n93x8qsc4cl5a3d2z3q56rm2zs7xnpn9iqli25g3plv69hp0kk"))))
    (build-system r-build-system)
    (home-page "https://cran.r-project.org/web/packages/parmigene/")
    (synopsis "Mutual information estimation for gene network reconstruction")
    (description
     "This package provides a parallel estimation of the mutual information
based on entropy estimates from k-nearest neighbors 