;;; GNU Guix --- Functional package management for GNU
;;; Copyright © 2013 Nikita Karetnikov <nikita@karetnikov.org>
;;; Copyright © 2013-2025 Ludovic Courtès <ludo@gnu.org>
;;; Copyright © 2013, 2014, 2015, 2016, 2019, 2023 Andreas Enge <andreas@enge.fr>
;;; Copyright © 2014, 2015 Mark H Weaver <mhw@netris.org>
;;; Copyright © 2014, 2017, 2021, 2022, 2024 Eric Bavier <bavier@posteo.net>
;;; Copyright © 2014, 2015 Federico Beffa <beffa@fbengineering.ch>
;;; Copyright © 2015 Omar Radwan <toxemicsquire4@gmail.com>
;;; Copyright © 2015 Pierre-Antoine Rault <par@rigelk.eu>
;;; Copyright © 2015-2025 Ricardo Wurmus <rekado@elephly.net>
;;; Copyright © 2015, 2016, 2020 Christine Lemmer-Webber <cwebber@dustycloud.org>
;;; Copyright © 2015 Eric Dvorsak <eric@dvorsak.fr>
;;; Copyright © 2015, 2016 David Thompson <davet@gnu.org>
;;; Copyright © 2015, 2016, 2017, 2019, 2022 Leo Famulari <leo@famulari.name>
;;; Copyright © 2015, 2017 Ben Woodcroft <donttrustben@gmail.com>
;;; Copyright © 2015, 2016 Erik Edrosa <erik.edrosa@gmail.com>
;;; Copyright © 2015-2025 Efraim Flashner <efraim@flashner.co.il>
;;; Copyright © 2015, 2017, 2020 Kyle Meyer <kyle@kyleam.com>
;;; Copyright © 2015, 2016 Chris Marusich <cmmarusich@gmail.com>
;;; Copyright © 2016 Danny Milosavljevic <dannym+a@scratchpost.org>
;;; Copyright © 2016 Lukas Gradl <lgradl@openmailbox.org>
;;; Copyright © 2016, 2018, 2019, 2021 Hartmut Goebel <h.goebel@crazy-compilers.com>
;;; Copyright © 2016 Daniel Pimentel <d4n1@d4n1.org>
;;; Copyright © 2016 Sou Bunnbu <iyzsong@gmail.com>
;;; Copyright © 2016, 2017 Troy Sankey <sankeytms@gmail.com>
;;; Copyright © 2016, 2017 Nikita <nikita@n0.is>
;;; Copyright © 2016 Dylan Jeffers <sapientech@sapientech@openmailbox.org>
;;; Copyright © 2016 David Craven <david@craven.ch>
;;; Copyright © 2016-2023 Marius Bakke <marius@gnu.org>
;;; Copyright © 2016, 2017, 2021, 2022 Stefan Reichör <stefan@xsteve.at>
;;; Copyright © 2016, 2017, 2019 Alex Vong <alexvong1995@gmail.com>
;;; Copyright © 2016–2018, 2021–2024 Arun Isaac <arunisaac@systemreboot.net>
;;; Copyright © 2016, 2017, 2018, 2020, 2021 Julien Lepiller <julien@lepiller.eu>
;;; Copyright © 2016–2022 Tobias Geerinckx-Rice <me@tobias.gr>
;;; Copyright © 2016, 2017 Thomas Danckaert <post@thomasdanckaert.be>
;;; Copyright © 2017 Carlo Zancanaro <carlo@zancanaro.id.au>
;;; Copyright © 2017 Frederick M. Muriithi <fredmanglis@gmail.com>
;;; Copyright © 2017, 2018 Adriano Peluso <catonano@gmail.com>
;;; Copyright © 2017 Ben Sturmfels <ben@sturm.com.au>
;;; Copyright © 2017, 2018, 2019, 2021, 2022 Mathieu Othacehe <m.othacehe@gmail.com>
;;; Copyright © 2017 José Miguel Sánchez García <jmi2k@openmailbox.org>
;;; Copyright © 2017, 2020, 2021 Roel Janssen <roel@gnu.org>
;;; Copyright © 2017, 2018, 2019 Kei Kebreau <kkebreau@posteo.net>
;;; Copyright © 2017 Rutger Helling <rhelling@mykolab.com>
;;; Copyright © 2017, 2019, 2021, 2025 Brendan Tildesley <mail@brendan.scot>
;;; Copyright © 2018 Ethan R. Jones <ethanrjones97@gmail.com
;;; Copyright © 2018 Fis Trivial <ybbs.daans@hotmail.com>
;;; Copyright © 2018 Vijayalakshmi Vedantham <vijimay12@gmail.com>
;;; Copyright © 2018 Mathieu Lirzin <mthl@gnu.org>
;;; Copyright © 2018 Adam Massmann <massmannak@gmail.com>
;;; Copyright © 2016, 2018 Tomáš Čech <sleep_walker@gnu.org>
;;; Copyright © 2018-2025 Nicolas Goaziou <mail@nicolasgoaziou.fr>
;;; Copyright © 2018 Oleg Pykhalov <go.wigust@gmail.com>
;;; Copyright © 2018, 2019, 2021, 2023 Clément Lassieur <clement@lassieur.org>
;;; Copyright © 2018-2025 Maxim Cournoyer <maxim@guixotic.coop>
;;; Copyright © 2018 Luther Thompson <lutheroto@gmail.com>
;;; Copyright © 2018 Vagrant Cascadian <vagrant@debian.org>
;;; Copyright © 2015, 2018 Pjotr Prins <pjotr.guix@thebird.nl>
;;; Copyright © 2019 tlecarrour@easter-eggs.com <tlecarrour@easter-eggs.com>
;;; Copyright © 2019, 2020 Brett Gilio <brettg@gnu.org>
;;; Copyright © 2019 Sam <smbaines8@gmail.com>
;;; Copyright © 2019, 2023 Jack Hill <jackhill@jackhill.us>
;;; Copyright © 2019-2023, Guillaume Le Vaillant <glv@posteo.net>
;;; Copyright © 2019, 2020 Alex Griffin <a@ajgrf.com>
;;; Copyright © 2019, 2020, 2021, 2022, 2023 Pierre Langlois <pierre.langlois@gmx.com>
;;; Copyright © 2019 Jacob MacDonald <jaccarmac@gmail.com>
;;; Copyright © 2019-2021, 2023, 2024 Giacomo Leidi <therewasa@fishinthecalculator.me>
;;; Copyright © 2019 Wiktor Żelazny <wzelazny@vurv.cz>
;;; Copyright © 2019, 2020, 2021, 2022 Tanguy Le Carrour <tanguy@bioneland.org>
;;; Copyright © 2019, 2021-2023 Mădălin Ionel Patrașcu <madalinionel.patrascu@mdc-berlin.de>
;;; Copyright © 2020 Riku Viitanen <riku.viitanen@protonmail.com>
;;; Copyright © 2020 Jakub Kądziołka <kuba@kadziolka.net>
;;; Copyright © 2020 sirgazil <sirgazil@zoho.com>
;;; Copyright © 2020 Sebastian Schott <sschott@mailbox.org>
;;; Copyright © 2020, 2021 Alexandros Theodotou <alex@zrythm.org>
;;; Copyright © 2020 Josh Marshall <joshua.r.marshall.1991@gmail.com>
;;; Copyright © 2020 Lars-Dominik Braun <ldb@leibniz-psychology.org>
;;; Copyright © 2020 Alex ter Weele <alex.ter.weele@gmail.com>
;;; Copyright © 2020, 2022 Matthew James Kraai <kraai@ftbfs.org>
;;; Copyright © 2020 Ryan Prior <rprior@protonmail.com>
;;; Copyright © 2020 Josh Holland <josh@inv.alid.pw>
;;; Copyright © 2020 Yuval Kogman <nothingmuch@woobling.org>
;;; Copyright © 2020, 2022 Michael Rohleder <mike@rohleder.de>
;;; Copyright © 2020, 2021, 2022, 2023, 2024, 2025 Vinicius Monego <monego@posteo.net>
;;; Copyright © 2020 Guy Fleury Iteriteka <gfleury@disroot.org>
;;; Copyright © 2020 Hendursaga <hendursaga@yahoo.com>
;;; Copyright © 2020 Malte Frank Gerdes <malte.f.gerdes@gmail.com>
;;; Copyright © 2020 Joseph LaFreniere <joseph@lafreniere.xyz>
;;; Copyright © 2020 Tim Gesthuizen <tim.gesthuizen@yahoo.de>
;;; Copyright © 2020, 2021 Bonface Munyoki Kilyungi <me@bonfacemunyoki.com>
;;; Copyright © 2020 Ekaitz Zarraga <ekaitz@elenq.tech>
;;; Copyright © 2020 Diego N. Barbato <dnbarbato@posteo.de>
;;; Copyright © 2020 Liliana Marie Prikler <liliana.prikler@gmail.com>
;;; Copyright © 2019 Kristian Trandem <kristian@devup.no>
;;; Copyright © 2020, 2021, 2024, 2025 Zheng Junjie <z572@z572.online>
;;; Copyright © 2020 EuAndreh <eu@euandre.org>
;;; Copyright © 2021, 2022 Morgan Smith <Morgan.J.Smith@outlook.com>
;;; Copyright © 2021-2025 Sharlatan Hellseher <sharlatanus@gmail.com>
;;; Copyright © 2021 Ellis Kenyő <me@elken.dev>
;;; Copyright © 2021 LibreMiami <packaging-guix@libremiami.org>
;;; Copyright © 2021 Mathieu Othacehe <othacehe@gnu.org>
;;; Copyright © 2021 Xinglu Chen <public@yoctocell.xyz>
;;; Copyright © 2021 Raghav Gururajan <rg@raghavgururajan.name>
;;; Copyright © 2021, 2023-2025 jgart <jgart@dismail.de>
;;; Copyright © 2021 Danial Behzadi <dani.behzi@ubuntu.com>
;;; Copyright © 2021 Maxime Devos <maximedevos@telenet.be>
;;; Copyright © 2021 Hugo Lecomte <hugo.lecomte@inria.fr>
;;; Copyright © 2021 Franck Pérignon <franck.perignon@univ-grenoble-alpes.fr>
;;; Copyright © 2021, 2022 Petr Hodina <phodina@protonmail.com>
;;; Copyright © 2021 Simon Streit <simon@netpanic.org>
;;; Copyright © 2021 Stefan Reichör <stefan@xsteve.at>
;;; Copyright © 2021, 2022, 2023 Daniel Meißner <daniel.meissner-i4k@ruhr-uni-bochum.de>
;;; Copyright © 2021, 2022 Pradana Aumars <paumars@courrier.dev>
;;; Copyright © 2021–2024 Felix Gruber <felgru@posteo.net>
;;; Copyright © 2021 Sébastien Lerique <sl@eauchat.org>
;;; Copyright © 2021 Raphaël Mélotte <raphael.melotte@mind.be>
;;; Copyright © 2021 ZmnSCPxj <ZmnSCPxj@protonmail.com>
;;; Copyright © 2021 Filip Lajszczak <filip@lajszczak.dev>
;;; Copyright © 2021 Greg Hogan <code@greghogan.com>
;;; Copyright © 2022, 2023 John Kehayias <john.kehayias@protonmail.com>
;;; Copyright © 2022 Aleksandr Vityazev <avityazev@posteo.org>
;;; Copyright © 2022, 2024, 2025 Evgeny Pisemsky <mail@pisemsky.site>
;;; Copyright © 2022 drozdov <drozdov@portalenergy.tech>
;;; Copyright © 2022 Peter Polidoro <peter@polidoro.io>
;;; Copyright © 2022, 2023 Wamm K. D. <jaft.r@outlook.com>
;;; Copyright © 2022 Jai Vetrivelan <jaivetrivelan@gmail.com>
;;; Copyright © 2022-2025 Artyom V. Poptsov <poptsov.artyom@gmail.com>
;;; Copyright © 2022, 2023 Paul A. Patience <paul@apatience.com>
;;; Copyright © 2022 Jean-Pierre De Jesus DIAZ <me@jeandudey.tech>
;;; Copyright © 2022 Philip McGrath <philip@philipmcgrath.com>
;;; Copyright © 2022 Marek Felšöci <marek@felsoci.sk>
;;; Copyright © 2022 Hilton Chain <hako@ultrarare.space>
;;; Copyright © 2022 Tomasz Jeneralczyk <tj@schwi.pl>
;;; Copyright © 2022 Mathieu Laparie <mlaparie@disr.it>
;;; Copyright © 2022 Garek Dyszel <garekdyszel@disroot.org>
;;; Copyright © 2022 Baptiste Strazzulla <bstrazzull@hotmail.fr>
;;; Copyright © 2022-2025 Nicolas Graves <ngraves@ngraves.fr>
;;; Copyright © 2023 Gabriel Wicki <gabriel@erlikon.ch>
;;; Copyright © 2023 Amade Nemes <nemesamade@gmail.com>
;;; Copyright © 2023 Bruno Victal <mirai@makinata.eu>
;;; Copyright © 2023 Lu Hui <luhux76@gmail.com>
;;; Copyright © 2023 Jean-Pierre De Jesus DIAZ <jean@foundationdevices.com>
;;; Copyright © 2023 Kaelyn Takata <kaelyn.alexi@protonmail.com>
;;; Copyright © 2023 dan <i@dan.games>
;;; Copyright © 2023 Dominik Delgado Steuter <d@delgado.nrw>
;;; Copyright © 2023 Ivan Vilata-i-Balaguer <ivan@selidor.net>
;;; Copyright © 2023 Ontje Lünsdorf <ontje.luensdorf@dlr.de>
;;; Copyright © 2023, 2025 gemmaro <gemmaro.dev@gmail.com>
;;; Copyright © 2023 Parnikkapore <poomklao@yahoo.com>
;;; Copyright © 2023 Foundation Devices, Inc. <hello@foundationdevices.com>
;;; Copyright © c4droid <c4droid@foxmail.com>
;;; Copyright © 2023, 2024, 2025 Janneke Nieuwenhuizen <janneke@gnu.org>
;;; Copyright © 2023 Attila Lendvai <attila@lendvai.name>
;;; Copyright © 2023, 2024 Troy Figiel <troy@troyfigiel.com>
;;; Copyright © 2023 Adam Faiz <adam.faiz@disroot.org>
;;; Copyright © 2023 Wiktor Żelazny <wz@freeshell.de>
;;; Copyright © 2024 Timothee Mathieu <timothee.mathieu@inria.fr>
;;; Copyright © 2024 Ian Eure <ian@retrospec.tv>
;;; Copyright © 2024 Adriel Dumas--Jondeau <leirda@disroot.org>
;;; Copyright © 2024 Navid Afkhami <navid.afkhami@mdc-berlin.de>
;;; Copyright © 2024 TakeV <takev@disroot.org>
;;; Copyright © 2024, 2025 David Elsing <david.elsing@posteo.net>
;;; Copyright © 2024 Rick Huijzer <ikbenrickhuyzer@gmail.com>
;;; Copyright © 2024 Peter Kannewitz <petre-vps@posteo.net>
;;; Copyright © 2024 Aaron Covrig <aaron.covrig.us@ieee.org>
;;; Copyright © 2024 Markku Korkeala <markku.korkeala@iki.fi>
;;; Copyright © 2025 Jordan Moore <lockbox@struct.foo>
;;; Copyright © 2025 Dariqq <dariqq@posteo.net>
;;; Copyright © 2025 Nguyễn Gia Phong <cnx@loang.net>
;;; Copyright © 2025, Cayetano Santos <csantosb@inventati.org>
;;; Copyright © 2025 Jake Forster <jakecameron.forster@gmail.com>
;;; Copyright © 2025 Luis Felipe López Acevedo <sirgazil@zoho.com>
;;; Copyright © 2025 Josep Bigorra <jjbigorra@gmail.com>
;;; Copyright © 2025 Matthias Riße <matrss@0px.xyz>
;;; Copyright © 2025 Ghislain Vaillant <ghislain.vaillant@inria.fr>
;;; Copyright © 2025 Allan Adair <allan@adair.no>
;;; Copyright © 2025 Hennadii Stepanov <hebasto@gmail.com>
;;; Copyright © 2025 Luca Kredel <luca.kredel@web.de>
;;; Copyright © 2025 Isidor Zeuner <guix@quidecco.pl>
;;;
;;; This file is part of GNU Guix.
;;;
;;; GNU Guix is free software; you can redistribute it and/or modify it
;;; under the terms of the GNU General Public License as published by
;;; the Free Software Foundation; either version 3 of the License, or (at
;;; your option) any later version.
;;;
;;; GNU Guix is distributed in the hope that it will be useful, but
;;; WITHOUT ANY WARRANTY; without even the implied warranty of
;;; MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
;;; GNU General Public License for more details.
;;;
;;; You should have received a copy of the GNU General Public License
;;; along with GNU Guix.  If not, see <http://www.gnu.org/licenses/>.

(define-module (gnu packages python-xyz)
  #:use-module ((guix licenses) #:prefix license:)
  #:use-module (gnu packages)
  #:use-module (gnu packages adns)
  #:use-module (gnu packages algebra)
  #:use-module (gnu packages attr)
  #:use-module (gnu packages autotools)
  #:use-module (gnu packages backup)
  #:use-module (gnu packages base)
  #:use-module (gnu packages bash)
  #:use-module (gnu packages bdw-gc)
  #:use-module (gnu packages bioinformatics)
  #:use-module (gnu packages build-tools)
  #:use-module (gnu packages nss)
  #:use-module (gnu packages check)
  #:use-module (gnu packages cmake)
  #:use-module (gnu packages compression)
  #:use-module (gnu packages cpp)
  #:use-module (gnu packages crypto)
  #:use-module (gnu packages databases)
  #:use-module (gnu packages dbm)
  #:use-module (gnu packages dictionaries)
  #:use-module (gnu packages digest)
  #:use-module (gnu packages django)
  #:use-module (gnu packages djvu)
  #:use-module (gnu packages documentation)
  #:use-module (gnu packages duckdb)
  #:use-module (gnu packages elf)
  #:use-module (gnu packages emulators)
  #:use-module (gnu packages enchant)
  #:use-module (gnu packages file)
  #:use-module (gnu packages fonts)
  #:use-module (gnu packages fontutils)
  #:use-module (gnu packages freedesktop)
  #:use-module (gnu packages gcc)
  #:use-module (gnu packages gdb)
  #:use-module (gnu packages geo)
  #:use-module (gnu packages ghostscript)
  #:use-module (gnu packages glib)
  #:use-module (gnu packages gnome)
  #:use-module (gnu packages gnupg)
  #:use-module (gnu packages graphviz)
  #:use-module (gnu packages gsasl)
  #:use-module (gnu packages gtk)
  #:use-module (gnu packages guile-xyz)
  #:use-module (gnu packages haskell-xyz)
  #:use-module (gnu packages icu4c)
  #:use-module (gnu packages image)
  #:use-module (gnu packages image-processing)
  #:use-module (gnu packages imagemagick)
  #:use-module (gnu packages inkscape)
  #:use-module (gnu packages iso-codes)
  #:use-module (gnu packages java)
  #:use-module (gnu packages javascript)
  #:use-module (gnu packages jupyter)
  #:use-module (gnu packages kerberos)
  #:use-module (gnu packages less)
  #:use-module (gnu packages libevent)
  #:use-module (gnu packages libffi)
  #:use-module (gnu packages libusb)
  #:use-module (gnu packages linux)
  #:use-module (gnu packages llvm)
  #:use-module (gnu packages machine-learning)
  #:use-module (gnu packages man)
  #:use-module (gnu packages markup)
  #:use-module (gnu packages maths)
  #:use-module (gnu packages messaging)
  #:use-module (gnu packages monitoring)
  #:use-module (gnu packages multiprecision)
  #:use-module (gnu packages ncurses)
  #:use-module (gnu packages networking)
  #:use-module (gnu packages ninja)
  #:use-module (gnu packages node)
  #:use-module (gnu packages openstack)
  #:use-module (gnu packages pcre)
  #:use-module (gnu packages pdf)
  #:use-module (gnu packages perl)
  #:use-module (gnu packages photo)
  #:use-module (gnu packages pkg-config)
  #:use-module (gnu packages protobuf)
  #:use-module (gnu packages python)
  #:use-module (gnu packages python-build)
  #:use-module (gnu packages python-check)
  #:use-module (gnu packages python-compression)
  #:use-module (gnu packages python-crypto)
  #:use-module (gnu packages python-science)
  #:use-module (gnu packages python-web)
  #:use-module (gnu packages qt)
  #:use-module (gnu packages rdf)
  #:use-module (gnu packages readline)
  #:use-module (gnu packages regex)
  #:use-module (gnu packages rpc)
  #:use-module (gnu packages rust)
  #:use-module (gnu packages rust-apps)
  #:use-module (gnu packages scanner)
  #:use-module (gnu packages search)
  #:use-module (gnu packages serialization)
  #:use-module (gnu packages shells)
  #:use-module (gnu packages sphinx)
  #:use-module (gnu packages ssh)
  #:use-module (gnu packages statistics)
  #:use-module (gnu packages tcl)
  #:use-module (gnu packages tex)
  #:use-module (gnu packages texinfo)
  #:use-module (gnu packages time)
  #:use-module (gnu packages tls)
  #:use-module (gnu packages tree-sitter)
  #:use-module (gnu packages version-control)
  #:use-module (gnu packages video)
  #:use-module (gnu packages web)
  #:use-module (gnu packages wxwidgets)
  #:use-module (gnu packages xml)
  #:use-module (gnu packages xdisorg)
  #:use-module (gnu packages xorg)
  #:use-module (guix packages)
  #:use-module (guix build-system cargo)
  #:use-module (guix build-system cmake)
  #:use-module (guix build-system copy)
  #:use-module (guix build-system gnu)
  #:use-module (guix build-system meson)
  #:use-module (guix build-system pyproject)
  #:use-module (guix build-system python)
  #:use-module (guix deprecation)
  #:use-module (guix download)
  #:use-module (guix hg-download)
  #:use-module (guix git-download)
  #:use-module (guix gexp)
  #:use-module (guix utils)
  #:use-module (ice-9 match)
  #:use-module (srfi srfi-1)
  #:use-module (srfi srfi-26))

(define-public python-anaconda-cli-base
  (package
    (name "python-anaconda-cli-base")
    (version "0.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "anaconda_cli_base" version))
       (sha256
        (base32 "01kspqfyqhzlb3hkxrvdlasch5ai87lizn6yz4g25ff4x7k5b4qx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              (substitute* "pyproject.toml"
                ((".*--cov.*") "")))))))
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-mock
           python-setuptools-scm))
    (propagated-inputs
     (list python-click
           python-packaging
           python-pydantic-settings
           python-readchar
           python-rich
           python-tomli
           python-typer))
    (home-page "https://anaconda.github.io/anaconda-cli-base/")
    (synopsis "Base CLI entrypoint Anaconda CLI plugins")
    (description
     "This package provides a base CLI entrypoint supporting Anaconda CLI plugins.")
    (license license:bsd-3)))

(define-public python-annexremote
  (package
    (name "python-annexremote")
    (version "1.6.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Lykos153/AnnexRemote")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fhd712z143mvsidlwhnq951cvkbfcpybbim3fiyn6r3l1r46a25"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/Lykos153/AnnexRemote")
    (synopsis "Helper module to easily develop git-annex special remotes")
    (description
     "This package provides a helper module to develop special remotes for
git-annex.  AnnexRemote implements the line-based external special remote
protocol of git-annex, while leaving the behavior of the remote up to the
user.")
    (license license:gpl3)))

(define-public python-archspec
  (package
    (name "python-archspec")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/archspec/archspec")
             (commit (string-append "v" version))
             (recursive? #t)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pdqdyzwy75fmcv4ncvar57r3zvfbnqgsya6dgfkzjfd0wvwby05"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-jsonschema
           python-poetry-core
           python-pytest))
    (home-page "https://github.com/archspec/archspec")
    (synopsis "Library to query system architecture")
    (description
     "Archspec offers human-readable labels for system architecture aspects.
These aspects include CPU, network fabrics, etc.  In addition, it offers
APIs to detect, query, and compare them.")
    (license license:expat)))

(define-public python-asyncclick
  (package
    (name "python-asyncclick")
    (version "8.3.0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asyncclick" version))
       (sha256
        (base32 "1i8jb2mir9gflw9pram720diq6fb2yn8pjja1m1q3arzq64zl993"))))
    (build-system pyproject-build-system)
    ;; tests: 1418 passed, 21 skipped, 1 xfailed
    (native-inputs
     (list less
           python-flit-core
           python-pytest
           python-trio))
    (propagated-inputs
     (list python-anyio))
    (home-page "https://github.com/python-trio/asyncclick")
    (synopsis "Python composable command line utility, trio-compatible version ")
    (description
     "AsyncClick is a fork of Click that works well with anyio, Trio, or
asyncio.")
    (license license:bsd-3)))

(define-public python-asyncstdlib
  (package
    (name "python-asyncstdlib")
    (version "3.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asyncstdlib" version))
       (sha256
        (base32 "0cxms50gygrvp4n4rk5xxhnl6k7nsrhhixdyk6xk70hi9ysgz9pj"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://asyncstdlib.readthedocs.io")
    (synopsis "Compatibility layer between the Python stdlib and @code{async}
callables")
    (description
     "The @code{asyncstdlib} library re-implements functions and classes of
the Python standard library to make them compatible with @code{async}
callables, iterables and context managers.  It is fully agnostic to
@code{async} event loops and seamlessly works with @code{asyncio}, third-party
libraries such as @code{trio}, as well as any custom @code{async} event
loop.")
    (license license:expat)))

(define-public python-awesomeversion
  (package
    (name "python-awesomeversion")
    (version "24.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ludeeus/awesomeversion")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1kvzhhd2ah0sadlsp5xs3qbiknixq4xwhk3yb6kmhcdl2zcbi4cn"))
       (modules '((guix build utils)))
       (snippet #~(substitute* "pyproject.toml"
                    (("version = \"0\"")
                     (format #f "version = \"~a\"" #$version))))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-pytest-snapshot))
    (home-page "https://github.com/ludeeus/awesomeversion")
    (synopsis "Create and compare version objects")
    (description
     "This package provides a way to make anything a version object, and
compare against a vast section of other version formats.")
    (license license:expat)))

(define-public python-awkward-cpp
  (package
    (name "python-awkward-cpp")
    (version "43")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "awkward_cpp" version))
       (sha256
        (base32 "1bays82mjyg0clmms0rdaf1jrdyr0pw5njq8v9kgcan8drcpbvf1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         ;; TODO: Remove this on python-team branch.
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "pyproject.toml"
               (("scikit-build-core..0.10")
                "scikit-build-core")
               (("^minimum-version =.*") "")))))))
    (propagated-inputs (list python-numpy))
    (native-inputs
     (list cmake-minimal pybind11 python-pytest python-scikit-build-core))
    (home-page "https://github.com/scikit-hep/awkward-1.0")
    (synopsis "CPU kernels and compiled extensions for Awkward Array")
    (description "Awkward CPP provides precompiled routines for the awkward
package.  It is not useful on its own, only as a dependency for awkward.")
    (license license:bsd-3)))

(define-public python-awkward
  (package
    (name "python-awkward")
    (version "2.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "awkward" version))
       (sha256
        (base32 "1bfg4pggahnfvq4n71ydkb1pwzc89plfdgp9wcv7ky4dss37y1ay"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; CUDA is and requires proprietary software.
      '(list "--ignore-glob=tests-cuda**"
             "-k"
             (string-append
              ;; BrokenProcessPool
              "not test_noop_pickler"
              " and not test_non_packing_pickler"
              ;; Regex pattern did not match.
              " and not test_malformed_pickler"))))
    (propagated-inputs (list python-awkward-cpp
                             python-fsspec
                             python-importlib-metadata
                             python-numpy
                             python-packaging
                             python-typing-extensions))
    (native-inputs
     (list python-hatch-fancy-pypi-readme
           python-hatchling
           python-pytest))
    (home-page "https://github.com/scikit-hep/awkward-1.0")
    (synopsis "Manipulate JSON-like data with NumPy-like idioms")
    (description "Awkward Array is a library for nested, variable-sized data,
including arbitrary-length lists, records, mixed types, and missing data,
using NumPy-like idioms.")
    (license license:bsd-3)))

(define-public python-backports-tarfile
  (package
    (name "python-backports-tarfile")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "backports_tarfile" version))
       (sha256
        (base32 "14d9xibla5aahjqf9y0nmpk5vs4qds5rfy628j0invkld3104pnp"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;XXX: Cycles with python-jaraco-context
    (native-inputs
     (list python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/jaraco/backports.tarfile")
    (synopsis "Backport of CPython tarfile module")
    (description "This package provides a backport of CPython tarfile module.")
    (license license:expat)))

(define-public python-bresenham
  (package
    (name "python-bresenham")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/encukou/bresenham")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07h04l50y35rhp13mqis61d1dkd7426q1gdfy5hd6rcgcfv15kxd"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/encukou/bresenham")
    (synopsis "Implementation of Bresenham's line drawing algorithm")
    (description
     "This package provides a Python implementation of
@url{https://en.wikipedia.org/wiki/Bresenham's_line_algorithm, Bresenham's
line drawing algorithm}.")
    (license license:expat)))

(define-public python-calmjs-parse
  (package
    (name "python-calmjs-parse")
    (version "1.3.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/calmjs/calmjs.parse/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08dmi4chamk5dbdpvrc0nb09iybfhj3wqwxgffiqnkj7030qhqb8"))))
    (build-system pyproject-build-system)
    ;; tests: 797 passed, 1 warning
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-ply))
    (home-page "https://github.com/calmjs/calmjs.parse/")
    (synopsis "Parsers for ECMA standards")
    (description
     "@code{Calmjs-parse} is a collection of helper libraries for
understanding ECMA script.")
    (license license:expat)))

(define-public python-chameleon
  (package
    (name "python-chameleon")
    (version "4.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Chameleon" version))
       (sha256
        (base32 "06qwg3sk26m53b1sl8b798scik7klkx53vijs7d8mwzpyqlxf34i"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://chameleon.readthedocs.io")
    (synopsis "Fast HTML/XML Template Compiler")
    (description
     "Chameleon is an HTML/XML template engine for Python.  It uses the page
templates language.")
    ;; Project is duo licensed, see: LICENSE.txt.
    (license (list license:zpl2.1
                   license:psfl))))

(define-public python-conda-content-trust
  (package
    (name "python-conda-content-trust")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/conda/conda-content-trust")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1yvfwm7i18sfvgdasibdgnghvj5w5p4hr6i37v0cspwmkczgna7z"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; XXX: Not packaged yet:
      ;; <https://github.com/secure-systems-lab/securesystemslib>.
      ;;
      ;; ImportError: The securesystemslib library is required, which appears
      ;; to be unavailable.
      #~(list #$@(map (lambda (test) (string-append "--deselect="
                                                    "tests/test_root.py::"
                                                    test))
                      (list "test_sign_root_metadata_dict_via_gpg"
                            "test_sign_root_metadata_via_gpg"
                            "test_gpg_pubkey_in_ssl_format")))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              (substitute* "setup.cfg"
                (("--cov.*") ""))))
          (add-before 'build 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-cryptography))
    (home-page "https://github.com/conda/conda-content-trust")
    (synopsis "Signing and verification tools for Conda")
    (description
     "This package implements a functionalit of signing and verification tools
for Conda.  @url{https://theupdateframework.io/, Based on The Update
Framework (TUF)}, conda-content-trust is intended to ensure that when users in
the conda ecosystem obtain a package or data about that package, they can know
whether or not it is trustworthy (e.g. originally comes from a reliable source
and has not been tampered with).  A basic library and basic CLI are included
to provide signing, verification, and trust delegation functionality.")
    (license license:bsd-3)))

(define-public python-conda-inject
  (package
    (name "python-conda-inject")
    (version "1.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/koesterlab/conda-inject")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1aig9l676wc2sjb20y7rdqf0hfcfjhh92yfiy82mf7kfnv7rp3rk"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; tests require setting up Conda
    (native-inputs
     (list python-poetry-core))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/koesterlab/conda-inject")
    (synopsis "Inject a conda environment into the current python environment")
    (description
     "This package provides helper functions for injecting a conda
environment into the current python environment (by modifying @code{sys.path},
without actually changing the current python environment).")
    (license license:expat)))

(define-public python-copydetect
  (package
    (name "python-copydetect")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/blingenf/copydetect")
              (commit version)))
       (sha256
        (base32 "0hp9994bbnzp79xxprgwsbgc0w06sb4n82nghl90w1z9zbvwn6gz"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-jinja2
                             python-matplotlib
                             python-numpy
                             python-pygments
                             python-tqdm))
    (native-inputs (list python-setuptools
                         python-pytest
                         python-wheel))
    (home-page "https://github.com/blingenf/copydetect")
    (synopsis "Code plagiarism detection tool")
    (description "Copydetect is a tool to detect likely instances of plagiarism
based on the winnowing algorithm.  It takes a list of directories as input and
generates an HTML report displaying copied slices as output.")
    (license license:expat)))

(define-public python-couleur
  (package
    (name "python-couleur")
    (version "0.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "couleur" version))
       (sha256
        (base32 "1fk175k6l8isx43jmh7n7xyzb18ysdixzr74dxqqhpyd5sbsb5hy"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;no tests in PyPI, tests depend on Nose
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/gabrielfalcao/couleur")
    (synopsis "ANSI terminal tool for Python")
    (description
     "This package provides an ANSI terminal tool for Python, colored shell
and other handy fancy features.")
    (license license:lgpl3+)))

(define-public python-crc
  (package
    (name "python-crc")
    (version "7.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Nicoretti/crc/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1b9164z6v3ng5s8564a0gjdzqws6zf5aqvk6mnzw7ysk6d5rbb9r"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-wheel))
    (home-page "https://nicoretti.github.io/crc/")
    (synopsis "Pure Python CRC library")
    (description
     "This library computes and verifies @acronym{Cyclic Redundancy Check,
CRC} checksums, using predefined and custom CRC configurations.

Configurations:
@table @asis
@item CRC8
  CCITT AUTOSAR SAEJ1850 SAEJ1850_ZERO BLUETOOTH MAXIM-DOW
@item CRC16
  XMODEM GSM PROFIBUS MODBUS IBM-3740 KERMIT
@item CRC32
  CRC32 AUTOSAR BZIP2 POSIX
@item CRC64
  CRC64
@end table")
    (license license:bsd-2)))

(define-public python-curtsies
  (package
    (name "python-curtsies")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "curtsies" version))
       (sha256
        (base32 "09c8c4vssm2zkq017xj99vhcrisfva4nkz92w8dly4jjz7xhyahh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pyte
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-blessed
           python-cwcwidth))
    (home-page "https://github.com/bpython/curtsies")
    (synopsis "Library for curses-like terminal interaction with colored strings")
    (description
     "Curtsies is a Python library for interacting with the terminal.  It
features string-like objects which carry formatting information, per-line
fullscreen terminal rendering, and keyboard input event reporting.")
    (license license:expat)))

(define-public python-darkdetect
  (package
    (name "python-darkdetect")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "darkdetect" version))
       (sha256
        (base32 "1cgqgpz36dfn7hsqc29ha9pmxmzdjlwdq9aclkgbagi6f08qwhmm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f))  ;no tests in PyPI or Git.
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/albertosottile/darkdetect")
    (synopsis "Detect OS dark mode from Python")
    (description
     "This package allows to detect if the user is using Dark Mode.")
    (license license:bsd-3)))

(define-public python-decopatch
  (package
    (name "python-decopatch")
    (version "1.4.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "decopatch" version))
       (sha256
        (base32 "082pnnc7a1d7rk40k7m72w7kw8dk7g8m3yzq4cn1hl217z4ljzwm"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;XXX: cycles with python-pytest-cases
    (native-inputs
     (list python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-makefun))
    (home-page "https://github.com/smarie/python-decopatch")
    (synopsis "Create decorators easily in Python")
    (description
     "This package provide implements a functionality to simplify writing
decorators in Python.")
    (license license:bsd-3)))

(define-public python-distance
  (let ((commit "ad7f9dc7e9b0e88a08d0cefd1442f4ab1dd1779b")
        (revision "0"))
    (package
      (name "python-distance")
      (version (git-version "0.1.3" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/doukremt/distance")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1vcn0506dy68xyjxdjsl75zzc4b8lmg2yxjgak4i35l7a97yzvwy"))))
      (build-system pyproject-build-system)
      (arguments
       (list #:test-backend #~'custom
             #:test-flags #~(list "tests/tests.py")))
      (native-inputs (list python-setuptools))
      (home-page "https://github.com/doukremt/distance")
      (synopsis "Utilities for comparing sequences")
      (description
       "This package provides helpers for computing similarities between
arbitrary sequences. Included metrics are Levenshtein, Hamming, Jaccard, and
Sorensen distance, plus some bonuses.  All distance computations are
implemented in pure Python, and most of them are also implemented in C.")
      (license license:gpl2+))))

(define-public python-domdf-python-tools
  (package
    (name "python-domdf-python-tools")
    (version "3.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "domdf_python_tools" version))
       (sha256
        (base32 "16727afn92bp6hj4hvp27scc5ldz1y27z9abbxgi9sgiyk90iqra"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-hatch-requirements-txt))
    (arguments (list #:tests? #f))      ;no tests in PyPI archive
    (propagated-inputs
     (list python-natsort
           python-typing-extensions))
    (home-page "https://github.com/domdfcoding/domdf_python_tools")
    (synopsis "Helpful functions for Python")
    (description
     "This package provide helpfull functions for Python's testing and
packaging tasks.")
    (license license:expat)))

(define-public python-envs
  (package
    (name "python-envs")
    (version "1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "envs" version))
       (sha256
        (base32 "160358zskyg6g606lndjcv7yd2nv5f7ca14y55lds72xk333b14x"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'unittest))
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/capless/envs")
    (synopsis "Easy access of environment variables from Python")
    (description
     "This package implements a functionality to access of environment
variables from Python with support for strings, booleans, list, tuples, and
dicts.")
    (license license:asl2.0)))

(define-public python-exitcode
  (package
    (name "python-exitcode")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "exitcode" version))
       (sha256
        (base32 "01yybyi4pkvvf4382p28gh4lkxrcyl5vcx2xk95nbsb8011f37mw"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; no tests in PyPI or Git
    (native-inputs
     (list python-poetry-core
           python-setuptools))
    (home-page "https://github.com/rumpelsepp/exitcode")
    (synopsis "Preferred system exit codes as defined by sysexits.h")
    (description
     "This package implements a preferred system exit codes as defined by
@url{https://man.openbsd.org/sysexits, sysexits.h}. This library is inspired by
Rust's @url{https://docs.rs/exitcode, exitcode}.")
    (license license:expat)))

(define-public python-fastnumbers
  (package
    (name "python-fastnumbers")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fastnumbers" version))
       (sha256
        (base32 "0jzsylarbckivx762rxmc9syn7a6hqq3xhp5xnpfsln0rlhs0gqq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-numpy
           python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/SethMMorton/fastnumbers")
    (synopsis "Super-fast and clean conversions to numbers")
    (description
     "This package provides provides drop-in replacements for the Python
built-in @code{int} and @code{float} that are on par or faster with the Python
equivalents.")
    (license license:expat)))

(define-public python-findpython
  (package
    (name "python-findpython")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "findpython" version))
       (sha256
        (base32 "1p3kqr00sym0yaddsbaw1gf7nslfnscnd050q6ipj9rmfry68ccb"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pdm-backend
           python-pytest))
    (propagated-inputs
     (list python-packaging
           python-platformdirs))
    (home-page "https://github.com/frostming/findpython")
    (synopsis "Find Python versions the system")
    (description
     "This package provides a utility to find Python versions on the current
system.")
    (license license:expat)))

(define-public python-flexcache
  (package
    (name "python-flexcache")
    (version "0.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flexcache" version))
       (sha256
        (base32 "0mh6c3s0ykmnnhzys72xq5ls4myzpz1y86fmz0ngw6v2l3aknx0q"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-pytest-mpl
           python-pytest-subtests
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/hgrecco/flexcache")
    (synopsis "Caching transformed versions of a source object")
    (description
     "This package implements a functionality to cache on disk the result of
expensive calculations.  It was started as part of
@url{https://github.com/hgrecco/pint, Pint}, the Python units package.")
    (license license:bsd-3)))

(define-public python-flexparser
  (package
    (name "python-flexparser")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flexparser" version))
       (sha256
        (base32 "1cpn5scxnxbd2jrnany4znzzn9im5h5gwr59bp62rglman89hv96"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-pytest-mpl
           python-pytest-subtests
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/hgrecco/flexparser")
    (synopsis "Parsing made fun ... using typing")
    (description "This project provides a typed parser.  It was started as
part of @url{https://github.com/hgrecco/pint, Pint}, the Python units
package. ")
    (license license:bsd-3)))

(define-public python-grapheme
  ;; 0.6.0 has not git tag, PyPI has no tests. use the latest commit on master
  ;; branch.
  (let ((commit "66f07ca02fc64a9ea2f9b4ad66593b226d473adb")
        (revision "0"))
    (package
      (name "python-grapheme")
      (version (git-version "0.6.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/alvinlindstam/grapheme")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0fqw6iymg7s8q1pfwijx0awcj1j55jppx7hfa5ci7y0c7x4jc8v9"))))
      (build-system pyproject-build-system)
      (native-inputs
       (list python-pytest
             python-setuptools))
      (home-page "https://github.com/alvinlindstam/grapheme")
      (synopsis "Unicode grapheme helpers")
      (description
       "This package provides a functionality for working with user perceived
characters.  More specifically, string manipulation and calculation functions
for working with grapheme cluster groups (graphemes) as defined by the
@url{http://unicode.org/reports/tr29/, Unicode Standard Annex #29}.")
      (license license:expat))))

(define-public python-halo
  (package
    (name "python-halo")
    (version "0.0.31")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "halo" version))
       (sha256
        (base32 "1mn97h370ggbc9vi6x8r6akd5q8i512y6kid2nvm67g93r9a6rvv"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))         ;no tests in PyPI archive, no tags in Git
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-colorama
           python-log-symbols
           python-six
           python-spinners
           python-termcolor))
    (home-page "https://github.com/manrajgrover/halo")
    (synopsis "Python library to display graphical spinners in the terminal")
    (description
     "Halo is a Python library to display graphical spinners in the terminal.
It also supports IPython/Jupyter.")
    (license license:expat)))

(define-public python-hatch-argparse-manpage
  (package
    (name "python-hatch-argparse-manpage")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hatch_argparse_manpage" version))
       (sha256
        (base32 "1zbbww9akz1lca3br67zik80ql774xpfg22njxdxjiw4kpz5alb6"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-hatchling))
    (propagated-inputs (list python-argparse-manpage python-rich))
    (home-page "https://github.com/damonlynch/hatch-argparse-manpage")
    (synopsis "Hatch build hook plugin to generate manual pages")
    (description
     "This package provides a build hook plugin for Hatch to automatically
 bs generate a manual page from an ArgumentParser object, using argparse-manpage
by Pavel Raiskup.")
    (license license:gpl3+)))

(define-public python-hatch-gettext
  (package
    (name "python-hatch-gettext")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hatch_gettext" version))
       (sha256
        (base32 "05sh574p1c4wdf9gky965km3f5n904hxkyils07f1b0jyswlm3nh"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-hatchling))
    (propagated-inputs (list python-rich))
    (home-page "https://github.com/damonlynch/hatch-gettext")
    (synopsis "Hatch build hook plugin for GNU gettext")
    (description
     "This package provides a build hook plugin for Hatch that compiles
 bsmulti-lingual messages with GNU gettext's tools msgfmt.")
    (license license:gpl3+)))

;; TODO: Move to ci or task-runners, see:
;; <https://codeberg.org/guix/guix/issues/3096>.
(define-public python-huey
  (package
    (name "python-huey")
    (version "2.5.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/coleifer/huey")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "189sin0k9imiddm10xa5llql3953p1jv6dqgxm78hy18qrlbkz02"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'remove-which
            (lambda _
              (substitute* "huey/tests/test_kt_huey.py"
                (("^has_ktserver = sp.call\\(\\['which', 'ktserver'\\].*$")
                 "has_ktserver = False"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (spawn "redis-server" '("redis-server"))
                (invoke "python3" "-m" "runtests" "--verbosity" "2")))))))
    (native-inputs (list python-setuptools redis tzdata-for-tests))
    (propagated-inputs (list python-redis))
    (home-page "https://huey.readthedocs.io")
    (synopsis "Lightweight task queue for Python")
    (description
     "Huey is a lightweight task queue for Python applications.  Huey
supports:
@itemize
@item Redis, SQLite, file-system, or in-memory storage
@item multi-process, multi-thread or greenlet task execution models
@item scheduling tasks to execute at a given time, or after a given delay
@item scheduling recurring tasks, like a crontab
@item automatically retrying tasks that fail
@item task prioritization
@item task result storage
@item task expiration
@item task locking
@item task pipelines and chains
@end itemize")
    (license license:expat)))

(define-public python-id
  (package
    (name "python-id")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "id" version))
       (sha256
        (base32 "07acfgq7vmbz94p5axn9d40m8qjcgfllfkr4jz7dpfxcksjbhb19"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pretend
           python-pytest))
    (propagated-inputs
     (list python-requests))
    (home-page "https://github.com/di/id")
    (synopsis "Tool for generating OIDC identities")
    (description
     "This package provides a tool for generating @code{OIDC, OpenID Connect}
identities.")
    (license license:asl2.0)))

(define-public python-iniparse
  (package
    (name "python-iniparse")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/candlepin/python-iniparse")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hh676j1yw7krwmzpaxl59bhl5g04dbbzbr84qryrw420npy2prp"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "runtests.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'disable-tests
            (lambda _
              ;; XXX: Three tests failed to compare lists.
              (substitute* "tests/test_compat.py"
                (("test_read_returns_file_list")
                 "disabled_test_read_returns_file_list")))))))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/candlepin/python-iniparse")
    (synopsis "Accessing and Modifying INI files")
    (description
     "iniparse is a INI parser for Python which is:
@itemize
@item Compatible with ConfigParser: Backward compatible implementations of
ConfigParser, RawConfigParser, and SafeConfigParser are included that are
API-compatible with the Python standard library.
@item Preserves structure of INI files: Order of sections & options,
indentation, comments, and blank lines are preserved as far as possible when
data is updated.
@item More convenient: Values can be accessed using dotted notation
(@code{cfg.user.name}), or using container syntax
(@code{cfg['user']['name']}).
@end itemize")
    (license license:expat)))

(define-public python-inotify
  (package
    (name "python-inotify")
    (version "0.2.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/dsoprea/PyInotify")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n1rqpzk70ap2i4zk2k0znz407i909y2001v65agy7y30apjzb67"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-requirements
            (lambda _
              (substitute* "inotify/resources/requirements.txt"
                (("build")
                 "")))))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/dsoprea/PyInotify")
    (synopsis "Linux filesystem activity monitor library for Python")
    (description
     "This package provides an efficient and elegant inotify (Linux filesystem
activity monitor) library for Python.")
    (license license:gpl2)))

(define-public python-intervaltree
  (package
    (name "python-intervaltree")
    (version "3.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "intervaltree" version))
       (sha256
        (base32
         "0bcm6c6r4ck9nfj9xwz4rm2swc5lrjvmw3lyl6rgj639jf41nawh"))))
    (build-system pyproject-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         ;; pytest seems to have a check to make sure the user is testing
         ;; their checked-out code and not an installed, potentially
         ;; out-of-date copy. This is harmless here, since we just installed
         ;; the package, so we disable the check to avoid skipping tests
         ;; entirely.
         (add-before 'check 'import-mismatch-error-workaround
           (lambda _
             (setenv "PY_IGNORE_IMPORTMISMATCH" "1")
             #t)))))
    (propagated-inputs
     (list python-sortedcontainers))
    (native-inputs
     (list python-setuptools python-pytest))
    (home-page "https://github.com/chaimleib/intervaltree")
    (synopsis "Editable interval tree data structure")
    (description
     "This package provides a mutable, self-balancing interval tree
implementation for Python.  Queries may be by point, by range overlap, or by
range envelopment.  This library was designed to allow tagging text and time
intervals, where the intervals include the lower bound but not the upper
bound.")
    (license license:asl2.0)))

(define-public python-jschon
  (package
    (name "python-jschon")
    (version "0.11.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/marksparkza/jschon/")
              (commit (string-append "v" version))
              (recursive? #t)))         ;required for tests
       (sha256
        (base32 "0javlbq83ffy98kinhl7i17ja00917856yg55qlbn8048lhc9sxq"))
       (file-name (git-file-name name version))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-rfc3986))
    (native-inputs
     (list python-coverage
           python-hypothesis
           python-pytest
           python-pytest-benchmark
           python-pytest-httpserver
           python-requests
           python-setuptools))
    (home-page "https://jschon.readthedocs.io/")
    (synopsis "Object-oriented JSON Schema implementation for Python")
    (description
     "This package provides a JSON toolkit for Python developers.")
    (license license:expat)))

(define-public python-jsonpath-ng
  (package
    (name "python-jsonpath-ng")
    (version "1.7.0" )
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonpath-ng" version))
       (sha256
        (base32 "0g5bpq02pl9mv7mbqixvnagq8f9v0jab6wqmbxw9rxsz9vyzgxgn"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-ply))
    (home-page "https://github.com/h2non/jsonpath-ng")
    (synopsis "JSONPath Next-Generation")
    (description
     "This package provides a final implementation of @code{JSONPath} for
Python that aims to be standard compliant, including arithmetic and binary
comparison operators, as defined in the original
@url{http://goessner.net/articles/JsonPath/, JSONPath} proposal.")
    (license license:asl2.0)))

(define-public python-json-log-formatter
  (package
    (name "python-json-log-formatter")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/marselester/json-log-formatter")
              (commit (string-append "v" version))))
       (file-name (git-file-name name  version))
       (sha256
        (base32 "04zs938mjf131h0lfrkm3c2dfh0x5f8rmaks0i29nlxb71zpg0f2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-s" "tests.py")))))))
    (native-inputs (list python-django
                         python-pytest
                         python-setuptools
                         python-simplejson
                         python-ujson
                         python-wheel))
    (home-page "https://github.com/marselester/json-log-formatter")
    (synopsis "JSON log formatter")
    (description "The library helps you to store logs in JSON format.")
    (license license:expat)))

(define-public python-keeper-secrets-manager-core
  ;; released from a monorepo with other packages following various versioning
  ;; schemes. This commit was selected because some failing tests were fixed
  ;; since the most recent release of the Python SDK packages.
  (let ((commit "2c9a63d433721dee129a3647077d59bb243b52ec")
        (revision "0"))
    (package
      (name "python-keeper-secrets-manager-core")
      (version (git-version "17.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/Keeper-Security/secrets-manager")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1mqx0xv28xyljd4s7wwi154h8v22ayi8k337afhhw0pg2c8150pp"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'chdir
              (lambda _
                (chdir "sdk/python/core"))))))
      (propagated-inputs
       (list python-cryptography
             python-importlib-metadata
             python-requests))
      (native-inputs
       (list python-pytest
             python-setuptools))
      (home-page "https://github.com/Keeper-Security/secrets-manager")
      (synopsis "Keeper Secrets Manager for Python SDK")
      (description
       "The Keeper Secrets Manager Python SDK provides access to
@url{https://www.keepersecurity.com/secrets-manager.html, Keeper Secrets
Management} services.")
      (license license:expat))))

(define-public python-keeper-secrets-manager-helper
  ;; released alongside keeper-secrets-manager-core, but with a different
  ;; versioning scheme.
  (let ((commit "2c9a63d433721dee129a3647077d59bb243b52ec")
        (revision "0"))
    (package
      (name "python-keeper-secrets-manager-helper")
      (version (git-version "1.0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/Keeper-Security/secrets-manager")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1mqx0xv28xyljd4s7wwi154h8v22ayi8k337afhhw0pg2c8150pp"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'chdir
              (lambda _
                (chdir "sdk/python/helper"))))))
      (propagated-inputs
       (list python-iso8601
             python-keeper-secrets-manager-core
             python-pyyaml))
      (native-inputs
       (list python-pytest
             python-setuptools))
      (home-page "https://github.com/Keeper-Security/secrets-manager")
      (synopsis "Keeper Secrets Manager for Python SDK helper for managing records")
      (description
       "Keeper Secrets Manager SDK helper is for creating and managing secret
records.  It is intended to be used with @code{keeper-secrets-manager-core}.")
      (license license:expat))))

(define-public python-language-data
  (package
    (name "python-language-data")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "language_data" version))
       (sha256
        (base32 "1v6pp8z2wxj3hafl62hbx8sbinpp9cr0r7y80rfi8mcmlf5fy03n"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-marisa-trie))
    (home-page "https://github.com/georgkrause/language_data")
    (synopsis "Supplementary data about languages used by the langcodes module")
    (description
     "language_data is a supplement to the langcodes module, for working with
standardized codes for human languages.  It stores the more bulky and
hard-to-index data about languages, particularly what they are named in
various languages.")
    (license license:expat)))

(define-public python-log-symbols
  (package
    (name "python-log-symbols")
    (version "0.0.14")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "log_symbols" version))
       (sha256
        (base32 "0mh5d0igw33libfmbsr1ri1p1y644p36nwaa2w6kzrd8w5pvq2yg"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))         ;no tests in PyPI archive, tests depend on Nose
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-colorama))
    (home-page "https://github.com/manrajgrover/py-log-symbols")
    (synopsis "Python library with graphical symbols for logging on the terminal")
    (description
     "This package provides a Python library with graphical symbols that can
be displayed on the terminal, with color if possible, for logging purposes.")
    (license license:expat)))

(define-public python-marisa-trie
  (package
    (name "python-marisa-trie")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "marisa_trie" version))
       (sha256
        (base32 "0nzq9yc3qdpnnvhi9zlp6vcpk6id5lx3943pm7zgir1h5z8py44p"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-cython
           python-hypothesis
           python-pytest
           python-readme-renderer
           python-setuptools))
    (home-page "https://github.com/pytries/marisa-trie")
    (synopsis "Static memory-efficient Trie-like structures for Python")
    (description
     "This package provides static memory-efficient and fast Trie-like structures
for Python.")
    (license license:expat)))

(define-public python-menuinst
  (package
    (name "python-menuinst")
    (version "2.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/conda/menuinst")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0606j3mwpcj4rqj8mifnrdqqhp8dqf802kagqkp7mmi2wffly27w"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ;tests need conda
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-setuptools
           python-setuptools-scm))
    (home-page "https://conda.github.io/menuinst/")
    (synopsis "Cross platform menu item installation")
    (description
     "This package provides cross platform menu item installation for conda
packages.")
    (license license:bsd-3)))

(define-public python-multiplex
  (package
    (name "python-multiplex")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/dankilman/multiplex")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a662liqhiya47i6vrz3q03w08viqg3wj5j3g58mz175hcdcmmmv"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-pytest-asyncio))
    (propagated-inputs
     (list python-aiofiles
           python-aiostream
           python-click
           python-easy-ansi-0.3
           python-pyte))
    (home-page "https://github.com/dankilman/multiplex")
    (synopsis "Parallel stream of outputs from multiple processes")
    (description
     "This package provides a functionality to view output of multiple
processes, in parallel, in the console, with an interactive TUI.")
    (license license:expat)))

(define-public python-num2words
  (package
    (name "python-num2words")
    (version "0.5.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/savoirfairelinux/num2words")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1h52kgh1h4q9nkkplpwix2xs6f6wwvlxq09clznr2589xv39iqlz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore" "tests/test_cli.py"))) ;Requires delegator.py.
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-docopt))
    (home-page "https://github.com/savoirfairelinux/num2words")
    (synopsis "Convert numbers to words in multiple languages")
    (description
     "@code{num2words} is a library that converts numbers like 42 to words like
forty-two.  It supports multiple languages, and can even generate ordinal
numbers like forty-second.")
    (license license:lgpl2.1)))

(define-public python-orderly-set
  (package
    (name "python-orderly-set")
    (version "5.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "orderly_set" version))
       (sha256
        (base32 "1kp64m0nabhhb0zxr4f8idrmniraahnfwq41gx7adbyqwk48awg8"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://github.com/seperman/orderly-set")
    (synopsis "Multiple implementations of Ordered Set")
    (description "Orderly Set is a package containing multiple implementations
of Ordered Set.")
    (license license:expat)))

(define-public python-pandocfilters
  (package
    (name "python-pandocfilters")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pandocfilters" version))
       (sha256
        (base32 "17lknixjja23jczlv8afgfky94m4gwl7wc36iczw1sz4brallaq0"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;require pandoc to run tests
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/jgm/pandocfilters")
    (synopsis "Python module for writing Pandoc filters")
    (description "Pandoc is a powerful utility to transform various
input formats into a wide range of output formats.  To alter the
exported output document, Pandoc allows the usage of filters, which
are pipes that read a JSON serialization of the Pandoc AST from stdin,
transform it in some way, and write it to stdout.  It allows therefore
to alter the processing of Pandoc's supported input formats, for
instance one can add new syntax elements to markdown, etc.

This package provides Python bindings.")
    (license license:bsd-3)))

(define-public python-panflute
  (package
    (name "python-panflute")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "panflute" version))
       (sha256
        (base32 "07wg5md93jcdkpiqljwr3p1xzvm6nf7vbiay0bp84fgg6hmd06sz"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;require pandoc to run tests
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-click
           python-pyyaml))
    (home-page "http://scorreia.com/software/panflute/")
    (synopsis "Pythonic Pandoc filters")
    (description
     "Panflute is a Python package that makes Pandoc filters fun to write.
It is a pythonic alternative to John MacFarlane's pandocfilters, from which it
is heavily inspired.")
    (license license:bsd-3)))

(define-public python-pastel
  (package
    (name "python-pastel")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sdispater/pastel")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1lwip9qaqfacgwnl5ykr0846y1nky228k7h7vzrgyqj1viapprsv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "pastel" "tests/")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'use-poetry-core
            (lambda _
              ;; Patch to use the core poetry API.
              (substitute* "pyproject.toml"
                (("poetry.masonry.api") "poetry.core.masonry.api")))))))
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/sdispater/pastel")
    (synopsis "Library to colorize strings in your terminal")
    (description
     "Pastel is a simple library to help you colorize strings in your
terminal.")
    (license license:expat)))

(define-public python-pathlib-abc
  (package
    (name "python-pathlib-abc")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathlib_abc" version))
       (sha256
        (base32 "1hy2rscq3msbpjs17jbhsqjs800kcnv2w1n425yh1ly609a9x726"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-hatchling))
    (home-page "https://github.com/barneygale/pathlib-abc")
    (synopsis "Python base classes for rich path objects")
    (description
     "This package is a preview of pathlib functionality planned for a future
release of Python; specifically, it provides three ABCs that can be used to
implement path classes for non-local filesystems")
    (license license:psfl)))

;; XXX: It's for python-pathy@0.11.0, remove when no longer required.
(define-public python-pathlib-abc-for-python-pathy
  (hidden-package
  (package
    (inherit python-pathlib-abc)
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathlib_abc" version))
       (sha256
        (base32 "1gjsj7r331i54kbisy0zz1h9icx1hv6n97jaj5s7f3wvj7fpnkh8")))))))

(define-public python-pbs-installer
  (package
    (name "python-pbs-installer")
    (version "2025.09.18")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/frostming/pbs-installer")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0f5gpr4xp71d46vk2ggbb31bhagj4drf1ijl1lg1jd1apimr0jkf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ;no tests provided
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-version
            (lambda _
              (setenv "PDM_BUILD_SCM_VERSION" #$version))))))
    (native-inputs
     (list python-pdm-backend
           python-pytest))
    (propagated-inputs
     (list python-httpx
           python-zstandard))
    (home-page "https://github.com/frostming/pbs-installer")
    (synopsis "Installer for Python Build Standalone")
    (description
     "This package implements an installer for
@url{https://github.com/astral-sh/python-build-standalone, Python Build
Standalone}.")
    (license license:expat)))

(define-public python-phply
  (package
    (name "python-phply")
    (version "1.2.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "phply" version))
       (sha256
        (base32 "05s9v2q6b2r0i65zfw4jf1nzb619zgw0anl08ls7ll2z516pf9qb"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-ply))
    (home-page "https://github.com/viraptor/phply")
    (synopsis "PHP parser written in Python using PLY")
    (description
     "@code{phply} is a parser for the PHP programming language written using
PLY,a Lex/YACC-style parser generator toolkit for Python.")
    (license license:bsd-3)))

(define-public python-puccinialin
  (package
    (name "python-puccinialin")
    (version "0.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "puccinialin" version))
       (sha256
        (base32 "00nnqcvvyn10zxkhgzcfn8czwvdzm0vh5z16plb0dxspccd69dmv"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;no tests in PyPI or Git
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-httpx
           python-platformdirs
           python-tqdm))
    (home-page "https://github.com/konstin/puccinialin")
    (synopsis "Helper for bootstrapping Rust-based build back-ends for Python")
    (description
     "This tool helps to install Rust into a temporary directory, allowing
support of Rust-based Python builds.  Cargo and rustc are installed into a
cache directory, to avoid modifying the host's environment, and further
activated using a set of environment variables.")
    (license (list license:expat license:asl2.0))))

(define-public python-pypydispatcher
  (package
    (name "python-pypydispatcher")
    (version "2.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyPyDispatcher" version))
       (sha256
        (base32 "1wihj7xgq5fk91li0id6a311lyrnmq7ch8rbr9dm7lprrzgwbgmn"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/scrapy/pypydispatcher")
    (synopsis "Multi-producer-multi-consumer signal dispatching mechanism")
    (description
     "This package implements a functionality of pulti-producer-multi-consumer
signal dispatching mechanism.  It's a fork of
http://pydispatcher.sourceforge.net/ with PyPy support.")
    (license license:bsd-3)))

(define-public python-pyte
  (package
    (name "python-pyte")
    (version "0.8.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/selectel/pyte")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1cdhnl6rp4kcbs3s766519k80pf5ma18mgv6cyidf4nbgysjavmv"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-wcwidth))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://pyte.readthedocs.io/")
    (synopsis "Simple VTXXX-compatible terminal emulator")
    (description "@code{pyte} is an in-memory VTxxx-compatible terminal
emulator.  @var{VTxxx} stands for a series of video terminals, developed by
DEC between 1970 and 1995.  The first and probably most famous one was the
VT100 terminal, which is now a de-facto standard for all virtual terminal
emulators.

pyte is a fork of vt102, which was an incomplete pure Python implementation
of VT100 terminal.")
    (license license:lgpl3+)))

(define-public python-pyxdameraulevenshtein
  (package
    (name "python-pyxdameraulevenshtein")
    (version "1.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/lanl/pyxDamerauLevenshtein")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qmmpgf8qxv5pfnqp328qqsj34jvyc63w8659xx18d8405agcjdr"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-cython python-pytest python-setuptools))
    (home-page "https://github.com/lanl/pyxDamerauLevenshtein")
    (synopsis "Damerau-Levenshtein edit distance algorithm")
    (description
     "@code{pyxDamerauLevenshtein} implements the Damerau-Levenshtein (DL)
edit distance algorithm for Python in Cython for high performance.")
    (license license:bsd-3)))

(define-public python-represent
  (package
    (name "python-represent")
    (version "2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Represent" version))
       (sha256
        (base32 "1b5wbnkjirscfqwcb6ik8klky0ajm4qs2yvabqxnpfp72if02b8b"))))
    (build-system pyproject-build-system)
    (native-inputs
     ;; XXX This might be too much for testing, maybe switch them off as it's
     ;; a simple middleware library.
     (list python-ipython
           python-pytest
           python-rich
           python-setuptools))
    (home-page "https://github.com/RazerM/represent")
    (synopsis "Create @code{__repr__} automatically or declaratively for Python")
    (description
     "This package implements a functionality to generate Python
@code{__repr__} methods automatically or declaratively.")
    (license license:expat)))

(define-public python-rich-argparse
  (package
    (name "python-rich-argparse")
    (version "1.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/hamdanal/rich-argparse")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0wydhy1167yv7lm07iy3aysyhxyixc24ma1wdna36c06d24wbdc0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-hatchling))
    (propagated-inputs
     (list python-rich))
    (home-page "https://github.com/hamdanal/rich-argparse")
    (synopsis "Format argparse and optparse help using rich")
    (description
     "This package improves the look and readability of argparse's help while
requiring minimal changes to the code.")
    (license license:expat)))

(define-public python-rush
  (package
    (name "python-rush")
    (version "2021.04.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/sigmavirus24/rush")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0brqjw34n14rij58giwyqlagjnp11npvsrlwrqj5pbn7rmgd2mhx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; E ValueError: Redis URL must specify one of the following schemes
      ;; (redis://, rediss://, unix://)
      #~(list "-k" (string-append "not test_valid_url[redis://]"
                                  " and not test_valid_url[rediss://]"))))
    (native-inputs
     (list python-mock
           python-redis
           python-rfc3986
           python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-attrs))
    (home-page "https://github.com/sigmavirus24/rush")
    (synopsis "Throttling and rate-limiting algorithms for Python")
    (description
     "This package provides is a small collection of algorithms that can be
reused when throttling user interactions with a resource (e.g., an API).")
    (license license:expat)))

(define-public python-safety-schemas
  (package
    (name "python-safety-schemas")
    (version "0.0.14")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "safety_schemas" version))
       (sha256
        (base32 "0smgszbd3nb7jh61cgpycqhcvfwwdyaai5amw8mmf6g9b5x3z5a9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; These tests are failing for unknown reasons.
                    ;; (AssertionError).
                    (list "not test_model[ConfigModel-ConfigModel]"
                          "test_model[MetadataModel-MetadataModel]"
                          "test_model[PolicyFileModel-PolicyFileModel]"
                          "test_model[ProjectModel-ProjectModel]"
                          "test_model[ReportModel-ReportModel]")
                    " and not "))))
    (propagated-inputs (list python-dparse
                             python-packaging
                             python-pydantic-2
                             python-ruamel.yaml
                             python-typing-extensions))
    (native-inputs (list python-deepdiff python-hatchling python-pytest))
    ;; Source code is not yet published outside of PyPI:
    ;; https://github.com/pyupio/safety/issues/494
    (home-page "https://pypi.org/project/safety-schemas/")
    (synopsis "Schemas for Safety tools")
    (description "This package contains models and schemas used by Safety.")
    (license license:expat)))

(define-public python-senf
  (package
    (name "python-senf")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "senf" version))
       (sha256
        (base32 "1lcccdb4hrfksbr8vy4nljial85six1w39l5xlw16m4qx884anch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "--deselect" "tests/test_api.py::test_getuserdir"
             "--deselect" "tests/test_api.py::test_expanduser_user")))
    (native-inputs (list python-setuptools python-wheel python-pytest))
    (home-page "https://github.com/quodlibet/senf")
    (synopsis "Text, bytes and paths conversion functions for Python")
    (description "Senf introduces a new platform native string type called
fsnative.  It adds functions to convert text, bytes and paths to and from that
new type and helper functions to integrate it nicely with the Python
stdlib.")
    (license license:expat)))

(define-public python-session-info2
  (package
    (name "python-session-info2")
    (version "0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "session_info2" version))
       (sha256
        (base32 "0xs1mcdz0hf626m3421ryv4f7b5rixz2hm8x88czx2i9196x69g9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--deselect=tests/test_synthetic.py::test_gpu"
              ;; Tests require Jupyter Client.
              "--ignore=tests/test_subprocess.py")))
    (native-inputs
     (list python-hatch-docstring-description
           python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-asyncio))
    (home-page "https://session-info2.readthedocs.io/")
    (synopsis "Print versions of imported packages")
    (description
     "This package implements a functionality to print versions of imported
Python packages.")
    (license license:mpl2.0)))

(define-public python-show-in-file-manager
  (package
    (name "python-show-in-file-manager")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "show-in-file-manager" version))
       (sha256
        (base32 "111d363i7m0lr295301q39j6h0l6nfybyn2cvn7xi3yll60a24zd"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-argparse-manpage
           python-setuptools))
    (propagated-inputs
     (list python-packaging
           ;; python-pywin32
           python-pyxdg))
    (home-page "https://github.com/damonlynch/showinfilemanager")
    (synopsis "Open the system file manager and select files in it")
    (description
     "Show in File Manager is a Python package to open the system file manager
and optionally select files in it.  The point is not to open the files, but to
select them in the file manager, thereby highlighting the files and allowing
the user to quickly do something with them.")
    (license license:expat)))

(define-public python-shxparser
  (package
    (name "python-shxparser")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shxparser" version))
       (sha256
        (base32 "0w7j5ywskandp91v74966pw1pvq9d5zrx5gkjcn84xi8wsyf8hc5"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs
     (list python-svgelements python-setuptools))
    (home-page "https://github.com/tatarize/shxparser")
    (synopsis "SHX line font parser")
    (description
     "This is a pure python parser for SHX Hershey font files that are an
AutoCad format which can encode single line fonts.  This format is used for
many CNC and laser operations.")
    (license license:expat)))

(define-public python-simplify-polyline
  (package
    (name "python-simplify-polyline")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simplify_polyline" version))
       (sha256
        (base32 "08f6bvwbg04z19pirq4ynsiq89yhbzqh9g6zbnp9fvdnmics7hgw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/ShayHill/simplify_polyline")
    (synopsis "Simplify an open or closed polyline")
    (description
     "This package implements functionality to work with plyline.
Features:
@itemize
@item Visvalingham-Whyatt - removes the smallest triangles formed by
three consecutive points in a polyline or polygon
@item Douglas-Peucker - gives a better representation of the convex hull
@end itemize")
    (license license:expat)))

(define-public python-snakesay
  (package
    (name "python-snakesay")
    (version "0.10.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pythonanywhere/snakesay")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06p776nf2v5r9643i6f7hv8z984bjiz0k6z9whzla6b2y637mk93"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: We don't have python-uv-build yet.
     (list #:build-backend "setuptools.build_meta"))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/pythonanywhere/snakesay")
    (synopsis "Like @command{cowsay} but with Python flavor")
    (description
     "This package provides a simple ASCII art pictures generator of a
Snake with a message.")
    (license license:expat)))

(define-public python-jaconv
  (package
    (name "python-jaconv")
    ;; Last release is not tagged.
    (properties '((commit . "d4273468279536adb5375ffbfcd34578c6a95b70")
                  (revision . "0")))
    (version (git-version "0.4.0"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ikegami-yukino/jaconv")
             (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00lvkr6jsm2h70658hly5w81ybkfp3x0rmgzpcn0s52d4n4m21fb"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-pynose))
    (home-page "https://github.com/ikegami-yukino/jaconv")
    (synopsis
     "Pure-Python Japanese character interconverter for Hiragana, Katakana,
Hankaku, Zenkaku")
    (description
     "jaconv (Japanese Converter) is interconverter for Hiragana, Katakana,
Hankaku (half-width character) and Zenkaku (full-width character)")
    (license license:expat)))

(define-public python-janus
  (package
    (name "python-janus")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "janus" version))
       (sha256
        (base32 "04hnrdcf03g1s0x3sr72sh9gnszz6kyfsl9dg8a4n0zvvhn6z5yz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-cov python-pytest-asyncio
           python-setuptools python-wheel))
    (propagated-inputs (list python-typing-extensions))
    (home-page "https://github.com/aio-libs/janus/")
    (synopsis
     "Sync-async queue to interoperate between asyncio tasks and classic threads")
    (description
     "Mixed sync-async queue, supposed to be used for communicating between
classic synchronous (threaded) code and asynchronous (in terms of
@url{https://docs.python.org/3/library/asyncio.html,asyncio}) one.  Like
@url{https://en.wikipedia.org/wiki/Janus,Janus god} the queue object from the
library has two faces: synchronous and asynchronous interface.  Synchronous is
fully compatible with
@url{https://docs.python.org/3/library/queue.html,standard queue},
asynchronous one follows
@url{https://docs.python.org/3/library/asyncio-queue.html,asyncio queue
design}.")
    (license license:asl2.0)))

(define-public python-concurrent-log-handler
  (package
    (name "python-concurrent-log-handler")
    (version "0.9.25")
    ;; No tests in the PyPI tarball.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Preston-Landers/concurrent-log-handler")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jp4zkm0idfdsrq3jzb52iqfkh6xzm7sacz1sa34ffnkyqdk3xzh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: Tests are broken, no new version fixing them yet.
      #:tests? #f))
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-portalocker))
    (home-page "https://github.com/Preston-Landers/concurrent-log-handler")
    (synopsis
     "Additional log handler for Python's standard @code{logging} package")
    (description
     "This package provides an additional log handler for Python's standard
@code{logging} package (PEP 282).  This handler will write log events to a log
file which is rotated when the log file reaches a certain size.  Multiple
processes can safely write to the same log file concurrently and rotated logs
can be gzipped if desired.  An optional threaded queue logging handler is
provided to perform logging in the background.")
    (license license:asl2.0)))

(define-public python-lazy
  (package
    (name "python-lazy")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lazy" version))
       (sha256
        (base32 "1sfk1v54dyjxvilcxf9vlnypc5z0mg0i2inb117k5s09qx7349vi"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/stefanholek/lazy")
    (synopsis "Lazy attributes for Python objects")
    (description "This package provides a decorator to create lazy
attributes.")
    (license license:bsd-2)))

(define-public python-logfury
  (package
    (name "python-logfury")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "logfury" version))
       (sha256
        (base32 "09kanw1iv61hgmd858xkc9kck8ia91qdyb954i4m7bdrxan5s2hk"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-testfixtures
           python-wheel))
    (home-page "https://github.com/reef-technologies/logfury/")
    (synopsis "Logging of method calls for python libraries")
    (description
     "Logfury is a tool for python library maintainers.  It allows for
responsible, low-boilerplate logging of method calls.")
    (license license:bsd-3)))

(define-public python-logzero
  (package
    (name "python-logzero")
    (version "1.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/metachris/logzero")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1i9c0kynyjws5c24ga0sbidyfww3w5fy98gs67xsyfz4nr7w84b3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/metachris/logzero")
    (synopsis "Robust and effective logging for Python")
    (description
     "@code{logzero} provides a fully configured Python logger object for
easy logging and rotating to a console or a file.")
    (license license:expat)))

(define-public python-logbook
  (package
    (name "python-logbook")
    (version "1.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "logbook" version))
       (sha256
        (base32 "0afk1nmvj9fp3igzmxa4a048fm21sa4aw1z2ix8jzvs62ry7j6bd"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-brotli
           python-cython
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/getlogbook/logbook")
    (synopsis "Logbook is a logging replacement for Python")
    (description
     "Logbook is a logging system for Python that replaces the standard
library’s logging module.  It was designed with both complex and simple
applications in mind and the idea to make logging fun.")
    (license license:bsd-3)))

(define-public python-databind-core
  (package
    (name "python-databind-core")
    (version "4.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "databind.core" version))
       (sha256
        (base32 "130hr19kbzizx9n2q7cwfzfk20ii3cqmqjrzb16psnafll303k2d"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; The problem with python-typing-extensions >= 4.7 is only
                 ;; with python-3.7.
                 (substitute* "pyproject.toml"
                   ((",<4.7.*") "\"\n"))))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'fix-name
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((sitedir (site-packages inputs outputs))
                     (dist-info
                      (string-append sitedir "/databind_core-" #$version ".dist-info")))
                (substitute* (string-append dist-info "/METADATA")
                  (("Name: databind-core")
                   "Name: databind.core"))
                (substitute* (string-append dist-info "/RECORD")
                  (("databind_core") "databind.core"))
                (rename-file dist-info
                             (string-append sitedir
                                            "/databind.core-"
                                            #$version ".dist-info"))))))))
    (propagated-inputs
     (list python-deprecated
           python-nr-date
           python-nr-stream
           python-typeapi
           python-typing-extensions))
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://niklasrosenstein.github.io/python-databind/core/")
    (synopsis
     "Library for de-/serializing Python dataclasses")
    (description
     "Databind is a library inspired by jackson-databind to de-/serialize
Python dataclasses.")
    (license license:expat)))

(define-public python-databind-json
  (package
    (name "python-databind-json")
    (version "4.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "databind.json" version))
       (sha256
        (base32 "1lm864d7arfq0pw64hyc83bwn1z94wjg7a22q1xf0qkjynqs70gg"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 ;; The problem with python-typing-extensions >= 4.7 is only
                 ;; with python-3.7.
                 (substitute* "pyproject.toml"
                   ((",<4.7.*") "\"\n"))))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'fix-name
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((sitedir (site-packages inputs outputs))
                     (dist-info
                      (string-append sitedir "/databind_json-" #$version ".dist-info")))
                (substitute* (string-append dist-info "/METADATA")
                  (("Name: databind-json")
                   "Name: databind.json"))
                (substitute* (string-append dist-info "/RECORD")
                  (("databind_json") "databind.json"))
                (rename-file dist-info
                             (string-append sitedir
                                            "/databind.json-"
                                            #$version ".dist-info"))))))))
    (propagated-inputs
     (list python-databind-core python-nr-date
           python-typeapi python-typing-extensions))
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://niklasrosenstein.github.io/python-databind/json/")
    (synopsis
     "De-/serialize Python dataclasses to or from JSON payloads")
    (description
     "The @code{databind.json} package implements the de-/serialization to or
from JSON payloads using the @code{databind.core} framework.")
    (license license:expat)))

(define-public python-dlmanager
  (package
    (name "python-dlmanager")
    (version "0.1.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/parkouss/dlmanager")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0f2j7d396z50yd5r86jx8m5bxyv2i0cw967j68xcwpcg3b216zmr"))
              (modules '((guix build utils)))
              (snippet
               #~(begin
                   (substitute* "setup.py"
                     (("pytest.main.self.pytest_args.")
                      "pytest.main(self.pytest_args.split(' '))"))))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest python-mock))
    (propagated-inputs
     (list python-requests python-six))
    (home-page "https://github.com/parkouss/dlmanager")
    (synopsis "Download manager library")
    (description
     "Dlmanager is a download manager library.  It can download files in
background and in parallel, and cancel downloads.  It stores downloads in
a given directory, avoiding re-downloading files and limits the size of this
directory, removing oldest files.")
    (license license:gpl3+)))

(define-public python-docspec
  (package
    (name "python-docspec")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docspec" version))
       (sha256
        (base32 "1zqmdrc6k8pprra8p3wpzq2ml2gph1cfjmsyg07f8b8fvizffm28"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (propagated-inputs
     (list python-databind-core
           python-databind-json
           python-deprecated))
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-docspec")
    (synopsis "Represent API documentation of programming languages")
    (description
     "Docspec is a JSON object specification for representing API
documentation of programming languages.")
    (license license:expat)))

(define-public python-docspec-python
  (package
    (name "python-docspec-python")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docspec_python" version))
       (sha256
        (base32 "0n8m52vxmlvkj7p5jmd4rfdks65rrp4q4vzak44y6kbg9l5qa6y4"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #false))  ;there are none
    (propagated-inputs (list python-docspec python-nr-util))
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/docspec/")
    (synopsis "Produce docspec data from Python source code")
    (description
     "This package provides a parser based on @code{lib2to3} producing
@code{docspec} data from Python source code.")
    (license license:expat)))

(define-public python-fqdn
  (package
    (name "python-fqdn")
    (version "1.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fqdn" version))
       (sha256
        (base32 "17yqckhymnamszhg06751c83rg3fnr5iy33a135bazvngrkx6phh"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (propagated-inputs (list python-cached-property))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/ypcrts/fqdn")
    (synopsis "Validate domain names against RFC 1123")
    (description
     "This package validates fully-qualified domain names against RFC 1123, so
that they are acceptable to modern bowsers")
    (license license:mpl2.0)))

(define-public python-fire
  (package
    (name "python-fire")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fire" version))
       (sha256
        (base32 "1pswm79gi51p596zmfvaskx0i15znbr610yws5dgdsing7q505cn"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-termcolor))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (synopsis "Library for automatically generating command line interfaces")
    (description
     "Fire is a library for automatically generating command line interfaces
from absolutely any Python object.  The following are the advantages:
@itemize
@item A simple way to create a CLI in Python.
@item A helpful tool for developing and debugging Python code.
@item Helps with exploring existing code or turning other people's code into a
command line interface.
@item Makes transitioning between Bash and Python easier.
@item Makes using a Python REPL easier by setting up the REPL with the modules
and variables you'll need already imported and created.
@end itemize")
    (home-page "https://github.com/google/python-fire")
    (license license:asl2.0)))

(define-public python-fit-nbinom
  (package
    (name "python-fit-nbinom")
    (version "1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "fit_nbinom" version))
              (sha256
               (base32
                "12v8l5i35vjbpvh5i4lw29ys6vpr3z7pysyrx33hxaq09zr015mx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'remove-invalid-syntax
           (lambda _
             (substitute* "setup.py"
               ((".\\*\"") "\"")))))))
    (propagated-inputs (list python-numpy python-scipy))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/joachimwolff/fit_nbinom")
    (synopsis "Negative binomial maximum likelihood estimator")
    (description "This package provides an implementation in Python using
scipy and numpy of negative binomial maximum likelihood estimation.")
    (license license:gpl3+)))

(define-public python-docrep
  (package
    (name "python-docrep")
    (version "0.3.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docrep" version))
              (sha256
               (base32
                "0523jrzjj29kxpdllmfhrfj9kysi9mphp2m7ippjkn5b07i1g2pd"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-six))
    (native-inputs (list python-pytest python-pytest-runner
                         python-setuptools python-wheel))
    (home-page "https://github.com/Chilipp/docrep")
    (synopsis "Python package for docstring repetition")
    (description "Docrep is the documentation repetition module.  This module
targets developers that develop complex and nested Python APIs and helps them
to create a well-documented piece of software.")
    (license license:asl2.0)))

(define-public python-dotmap
  (package
    (name "python-dotmap")
    (version "1.3.30")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dotmap" version))
       (sha256
        (base32 "0s5kb2v7jd0narz6m6jcicak3h5pw290wz21cdsv8pq77y9sf8aq"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/drgrib/dotmap")
    (synopsis "Ordered, dynamically-expandable dot-access dictionary")
    (description
     "DotMap is a dot-access dictionary subclass that has dynamic
hierarchy creation, can be initialized with keys, can be initialized from a
dictionary, can be convert to a dictionary, and is ordered by insertion.")
    (license license:expat)))

(define-public python-dotty-dict
  (package
    (name "python-dotty-dict")
    (version "1.3.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pawelzny/dotty_dict")
              (commit (string-append "v" version))))
       (sha256
        (base32 "0rs83pglkgb4sfnk09rskg8c53hvl7mkjw4vfgl5xc8z13vyi3li"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-setuptools))
    (home-page "https://github.com/pawelzny/dotty_dict")
    (synopsis "Python library for accessing dictionaries using a dot syntax")
    (description "This package provides a library that wraps the traditional
Python dictionaries and provides a syntax to access nested dictionaries values
using a dot syntax, for example: @code{dictionary['deeply.nested.key']}.")
    (license license:expat)))

(define-public python-affine
  (package
    (name "python-affine")
    (version "2.4.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "affine" version))
              (sha256
               (base32
                "1shyvajayyzbkp9dihb4mz835jnkp0kqqbyjfqci6v43da6q2kd2"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-coveralls python-flake8 python-pydocstyle
                             python-pytest python-pytest-cov))
    (native-inputs (list python-flit-core))
    (home-page "https://github.com/rasterio/affine")
    (synopsis "Matrices describing affine transformation of the plane")
    (description "This is a package for matrices describing the affine
transformation of the plane.")
    (license license:bsd-3)))

(define-public python-argopt
  (package
    (name "python-argopt")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argopt" version))
       (sha256
        (base32 "03kpzdz8ib3szq8dpbr63jv0za4rpwal9iwpr3xhyqpzyiwhcy19"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-timeout
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/casperdcl/argopt")
    (synopsis "Generate a command-line interface from a docstring")
    (description
     "This package provides tools to define a command line interface
from a docstring rather than the other way around.")
    (license license:mpl2.0)))

(define-public python-array-api-compat
  (package
    (name "python-array-api-compat")
    (version "1.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "array_api_compat" version))
       (sha256
        (base32 "0x7r1ni9zpg68yz76dfza07q3pgwxjx15h5p4jn57pjhyqawcnsq"))))
    (build-system pyproject-build-system)
    ;; Tests would require all supported array libraries, including pytorch
    (arguments (list #:tests? #false))
    (native-inputs
     (list python-setuptools))
    (home-page "https://data-apis.org/array-api-compat/")
    (synopsis "Array API compatibility wrapper for NumPy et al")
    (description
     "This package provides a wrapper around @code{NumPy} and other array
libraries to make them compatible with the Array API standard")
    (license license:expat)))

(define-public python-cachetools
  (package
    (name "python-cachetools")
    (version "6.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachetools" version))
       (sha256
        (base32 "11s5ajy31r08228nd2sbv9jdir3vs584khxawwydnj18742g9i5l"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/tkem/cachetools/")
    (synopsis "Extensible memoizing collections and decorators")
    (description "This module provides various memoizing collections and
decorators, including variants of the Python standard library's
@code{lru_cache} function decorator.")
    (license license:expat)))

(define-public python-cachetools-5
  (package
    (inherit python-cachetools)
    (version "5.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachetools" version))
       (sha256
        (base32 "1m20wqipm50zvcgs3z2xksb96qwx1xc1jbhvaxcnglkmj6m1qrhs"))))))

(define-public python-colorclass
  (package
    (name "python-colorclass")
    (version "2.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/matthewdeanmartin/colorclass")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ylj167lfh8yzms30qrkiznv6737hdxra5lk8mhijcjm3hi1cl9l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not test_piped")  ; Unclear why this test fails.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'use-poetry-core
            (lambda _
              ;; Patch to use the core poetry API.
              (substitute* "pyproject.toml"
                (("poetry.masonry.api") "poetry.core.masonry.api")))))))
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/matthewdeanmartin/colorclass")
    (synopsis "Colorful console applications with Python")
    (description
     "This package provides an ANSI color text library for Python.  It
provides automatic coloring for dark or light terminals.")
    (license license:expat)))

(define-public python-colorcet
  (package
    (name "python-colorcet")
    (version "3.1.1a1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorcet" version))
       (sha256
        (base32 "1h15wdgha1cpj5a9p2dy9d8qdqnl5j1a0ylc7wilcfhvnfzcgp08"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-nbval
                         python-packaging
                         python-pytest
                         python-pytest-mpl
                         python-setuptools
                         python-setuptools-scm))
    (home-page "https://colorcet.holoviz.org/")
    (synopsis "Collection of perceptually uniform colormaps")
    (description "Colorcet is a collection of perceptually accurate 256-color
colormaps for use with Python plotting programs like Bokeh, Matplotlib,
HoloViews, and Datashader.")
    (license license:cc-by4.0)))

(define-public python-colored
  (package
    (name "python-colored")
    (version "2.3.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://gitlab.com/dslackw/colored")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "00332xdjw5fcj5wx848693355nvlgcf8qmpwkvz3rngfg1q5bxa6"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; Tests expect ANSI escape codes for colors.
              (setenv "FORCE_COLOR" "1"))))))
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://gitlab.com/dslackw/colored")
    (synopsis "Simple library for color and formatting to terminal")
    (description "This is a very simple Python library for color and
formatting in the terminal.  It comes with a collection of color codes and
names for 256 color terminal setups.")
    (license license:expat)))

(define-public python-colored-traceback
  ;; No tags in upstream repository.
  (let ((commit "98e6dea7111f7681db823c518f18026374a832b9")
        (revision "0"))
    (package
      (name "python-colored-traceback")
      (version (git-version "0.4.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/staticshock/colored-traceback.py")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "19d5mpwk7398b8fjh6abnr96wz70vf5vb4p207r8sny748rwx451"))))
      (build-system pyproject-build-system)
      (arguments
       ;; Tests are incompatible with current python version.
       (list #:tests? #f))
      (propagated-inputs (list python-colorama python-pygments))
      (native-inputs (list python-setuptools python-wheel))
      (home-page "https://github.com/staticshock/colored-traceback.py")
      (synopsis "Automatically color uncaught exception tracebacks")
      (description "This package provides python utilities to automatically
color uncaught exception tracebacks.")
      (license license:isc))))

(define-public python-colorful
  (package
    (name "python-colorful")
    (version "0.5.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/timofurrer/colorful")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00ag7h9g4v06japcva70sqibb9k49jrxq97nq3bi16b2y16mafwz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-colorama))
    (home-page "http://github.com/timofurrer/colorful")
    (synopsis "Terminal string styling")
    (description "Colorful provides an array of text styles, that can be used
as functions or string constants to form colored terminal output.")
    (license license:expat)))

(define-public python-colorthief
  (package
    (name "python-colorthief")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorthief" version))
       (sha256
        (base32 "08bjsmmkihyksms2vgndslln02rvw56lkxz28d39qrnxbg4v1707"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;no tests in PyPI or Git
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-pillow))
    (home-page "https://github.com/fengsp/color-thief-py")
    (synopsis "Grab the color palette of an image")
    (description
     "This package provides methods to determine the dominant color
of an image, as well as constructing a representative color palette.")
    (license license:bsd-3)))

(define-public python-construct-classes
  (package
    (name "python-construct-classes")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/matejcik/construct-classes")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fmr8nfg543lyqk4164a52jb6lwpq98radicbkhhdfckq9lib2wp"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-construct))
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (home-page "https://github.com/matejcik/construct-classes")
    (synopsis "Parse binary structs into dataclasses")
    (description "This package provides a parser to parse binary structs
into dataclasses.")
    (license license:expat)))

(define-public python-contourpy
  (package
    (name "python-contourpy")
    (version "1.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "contourpy" version))
       (sha256
        (base32 "0m5by0zqycm87ip6kcixya5hnsqji2alzibz3dklq0ssf515k55n"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; Image tests require matplotlib and create a circular dependency.
         "-m" "not image"
         ;; Tests that pass but avoided for load reasons.
         "-k" "not test_filled_random_big and not test_lines_random_big")))
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list cmake-minimal
           meson-python
           pkg-config
           pybind11
           python-pytest
           python-wurlitzer))
    (home-page "https://contourpy.readthedocs.io/")
    (synopsis
     "Python library for calculating contours of 2D quadrilateral grids")
    (description
     "ContourPy is a Python library for calculating contours of 2D
quadrilateral grids.  It is written in C++11 and wrapped using pybind11.")
    (license license:bsd-3)))

(define-public python-lunr
  (package
    (name "python-lunr")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "lunr" version))
       (sha256
        (base32 "0a426nngs8h2mhqm60rwywxh2vb6snrip47w9fhpglkqjl2zav5l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" "not TestLanguageSupport"
             "--ignore-glob=tests/acceptance_tests/*")))
    (native-inputs
     (list python-hatch-fancy-pypi-readme
           python-hatchling
           python-pytest
           python-pytest-timeout))
    (propagated-inputs
     (list python-nltk))
    (home-page "https://github.com/yeraydiazdiaz/lunr.py")
    (synopsis "Full-text search library")
    (description "This package provides python library for full-text search.
It indexes documents and provides a search interface for retrieving documents
that best match text queries.")
    (license license:expat)))

(define-public python-mdit-py-plugins
  (package
    (name "python-mdit-py-plugins")
    (version "0.4.2")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/executablebooks/mdit-py-plugins")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0lyv8k3sdm9i9am47z6zx96l9bbd9g8xp06yf2alafkmp0q873b9"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-markdown-it-py
           python-attrs))
    (native-inputs
     (list python-flit-core
           python-pytest
           python-pytest-regressions))
    (home-page "https://github.com/executablebooks/mdit-py-plugins")
    (synopsis "Collection of plugins for markdown-it-py")
    (description "This package contains a collection of plugins for
@code{markdown-it-py} like:
@enumerate
@item amsmath,
@item attrs,
@item container,
@item definition list,
@item dollarmath,
@item field list,
@item footnote,
@item textmath, and
@item wordcount.
@end enumerate")
    (license license:expat)))

(define-public python-mdurl
  (package
    (name "python-mdurl")
    (version "0.1.2")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/executablebooks/mdurl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0csc777q42jzv4zgdzxmwp8xqlb92ws1jvj09m2smh4klw67q5f3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit python-pytest))
    (home-page "https://github.com/executablebooks/mdurl")
    (synopsis "Markdown URL utilities")
    (description
     "This package implements a Python port of the JavaScript @code{mdurl}.")
    (license license:expat)))

(define-public python-mkdocs
  (package
    (name "python-mkdocs")
    (version "1.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mkdocs/mkdocs")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n5rdllrxvhnxmdrddf55p3s86dakx0rq2gg6bj6pr6jg2pn932b"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags
      #~(list "discover" "-p" "*tests.py" "mkdocs" "--top-level-directory" ".")
      #:phases
      #~(modify-phases %standard-phases
          ;; Requirements refer to a specific version of dependencies,
          ;; which are too old. So we patch to refer to any later version.
          (add-after 'unpack 'patch-requirements
            (lambda _
              (substitute* "setup.py"
                (("==") ">=")))))))
    (native-inputs (list python-setuptools))
    (propagated-inputs
     (list python-babel
           python-click
           python-ghp-import
           python-importlib-metadata
           python-jinja2
           python-markdown
           python-markupsafe
           python-mdx-gh-links
           python-mergedeep
           python-packaging
           python-pyyaml
           python-pyyaml-env-tag
           python-watchdog))
    (home-page "https://www.mkdocs.org")
    (synopsis "Project documentation with Markdown")
    (description
     "MkDocs is a static site generator geared towards building project
documentation.  Documentation source files are written in Markdown, and
configured with a single YAML configuration file.")
    (license license:bsd-3)))

(define-public python-mkdocs-markdownextradata-plugin
  (package
    (name "python-mkdocs-markdownextradata-plugin")
    (version "0.2.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rosscdh/mkdocs-markdownextradata-plugin")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1a3868s9m7pzyfncpjbjsa9vw5nihssl2v47pxj7h6qa67kvlk3g"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-mkdocs python-pyyaml))
    (home-page "https://github.com/rosscdh/mkdocs-markdownextradata-plugin/")
    (synopsis "Inject extra variables into the MkDocs markdown template")
    (description
     "This package provides a MkDocs plugin that injects the mkdocs.yml extra
variables into the markdown template.")
    (license license:expat)))

(define-public python-docstring-to-markdown
  (package
    (name "python-docstring-to-markdown")
    (version "0.15")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docstring-to-markdown" version))
       (sha256
        (base32 "0gdpabnyl1kyy0cjrnph6xl4fyhgim50a1amsaqq3hahki6i2ip1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'reduce-test-coverage-since-failing
            (lambda _
              (substitute* "setup.cfg"
                (("(^.*cov.*$|^.*flake8.*$)") "")))))))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-pytest-flake8
           python-setuptools
           python-wheel))
    (home-page "https://github.com/python-lsp/docstring-to-markdown")
    (synopsis "On the fly conversion of Python docstrings to markdown")
    (description
     "This module can convert Python docstrings to Markdown.  It can recognise
reStructuredText inside docstrings and convert multiple of its features to
Markdown.  It also includes initial support for Google-formatted docstrings.")
    (license license:lgpl2.1+)))

(define-public python-mysql-connector-python
  (package
    (name "python-mysql-connector-python")
    (version "8.0.33")
    ;; The archive on PyPi does not contain a build system
    (source (origin
              (method url-fetch)
              (uri (string-append "https://cdn.mysql.com/Downloads/"
                                  "Connector-Python/mysql-connector-python-"
                                  version "-src.tar.gz"))
              (sha256
               (base32
                "00j9xgd43yzx5yiijnlmpaqpa58m5lscjglsgzg48dibhr69br0l"))))
    (build-system python-build-system)
    (arguments
     (list
      #:configure-flags
      #~(list (string-append "--with-mysql-capi="
                             #$(this-package-input "mysql"))
              (string-append "--with-protobuf-include-dir="
                             #$(this-package-input "protobuf")
                             "/include/google/protobuf")
              (string-append "--with-protobuf-lib-dir="
                             #$(this-package-input "protobuf")
                             "/lib")
              (string-append "--with-protoc="
                             #$(this-package-input "protobuf")
                             "/bin/protoc"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'compatibility
            (lambda _
              (substitute* "src/mysql_capi.c"
                (("res = mysql_options\\(&self->session, MYSQL_OPT_LOAD_DATA_LOCAL_DIR.*")
                 "res = 0;")
                (("mysql_options\\(&self->session, MYSQL_OPT_LOAD_DATA_LOCAL_DIR.*")
                 "")
                (("mysql_options\\(&self->session, MYSQL_OPT_TLS_CIPHERSUITES.*")
                 "")
                ;; The C API does not have mysql_bind_param, so we produce an
                ;; error here.
                (("status = mysql_bind_param.*") "status = 1;"))
              ;; See https://github.com/protocolbuffers/protobuf/issues/9943
              (substitute* "src/mysqlxpb/mysqlxpb.cc"
                (("google::protobuf::string") "std::string"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Some of these tests might be failing due to the build
                ;; container's restrictions, others are due to the version
                ;; mismatch.
                (substitute* "tests/cext/test_cext_api.py"
                  (("def test_change_user") "def _do_not_test_change_user")
                  (("def test_get_character_set_info")
                   "def _do_not_test_get_character_set_info"))
                (substitute* "tests/test_bugs.py"
                  (("def test_change_user") "def _do_not_test_change_user")
                  (("def test_lost_connection") "def _do_not_test_lost_connection")
                  (("def test_kill_query") "def _do_not_test_kill_query")
                  ;; These all fail because of expired certificates.
                  (("def test_cext_verify_server_certificate")
                   "def _do_not_test_cext_verify_server_certificate")
                  (("def test_pure_verify_server_certificate")
                   "def _do_not_test_pure_verify_server_certificate")
                  (("def test_verify_server_name_cext_cnx")
                   "def _do_not_test_verify_server_name_cext_cnx")
                  (("def test_verify_server_name_pure_cnx")
                   "def _do_not_test_verify_server_name_pure_cnx"))
                (substitute* "tests/test_connection.py"
                  (("def test_allow_local_infile_in_path")
                   "def _do_not_test_allow_local_infile_in_path")
                  ;; This fails because of expired certificates.
                  (("def test_connect_with_unix_socket")
                   "def _do_not_test_connect_with_unix_socket"))
                (substitute* "tests/test_mysqlx_connection.py"
                  ;; This fails because of expired certificates.
                  (("def test_ssl_connection")
                   "def _do_not_test_ssl_connection"))
                (substitute* "tests/test_constants.py"
                  (("def test_deprecated")
                   "def _do_not_test_deprecated"))
                (mkdir-p "/tmp/datadir")
                (invoke "python3" "unittests.py"
                        "--verbosity=3"
                        (string-append "--with-mysql=" #$(this-package-input "mysql"))
                        "--keep"
                        "--mysql-topdir=/tmp/datadir"
                        "--unix-socket=/tmp/datadir")))))))
    (propagated-inputs (list python-protobuf))
    (inputs (list mysql protobuf-3.20 openssl-1.1 zlib))
    (home-page "https://dev.mysql.com/doc/connector-python/en/index.html")
    (synopsis "MySQL driver written in Python")
    (description "MySQL Connector/Python enables Python programs to access
MySQL databases, using an API that is compliant with the Python Database API
Specification v2.0 (PEP 249).")
    (license license:gpl2)))

(define-public python-pdoc
  (package
    (name "python-pdoc")
    (version "13.0.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mitmproxy/pdoc")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0gxkw607nrd67ck4w8jri9vfrm5g60qvp8b134m8zkiphbxjnx0l"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-jinja2 python-pygments
                         python-setuptools python-wheel))
    (arguments
     (list
      ;; Some tests fail, presumably because of slight version mismatches of
      ;; the dependencies.
      #:test-flags
      '(list "-k" (string-append "not test_var_with_raising_repr and "
                                 "not test_smoke[mock] and "
                                 "not test_snapshots[html"))))
    (home-page "https://pdoc.dev/")
    (synopsis "API documentation for Python projects")
    (description "pdoc auto-generates API documentation that follows your
project's Python module hierarchy.  It requires no configuration, has
first-class support for type annotations, cross-links between identifiers,
comes with an integrated live-reloading web server, uses customizable HTML
templates, understands numpydoc and Google-style docstrings.")
    (license license:unlicense)))

(define-public python-py4j
  (package
    (name "python-py4j")
    (version "0.10.9.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "py4j" version))
              (sha256
               (base32
                "1fwdx92cdaiviradksfyygg05g1fpc3x2lf65bv5rnispcam6vhb"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))  ; Requires a running JVM?
    (native-inputs (list python-setuptools))
    (home-page "https://www.py4j.org/")
    (synopsis "Dynamically access arbitrary Java objects from Python")
    (description
     "This package enables Python programs to dynamically access arbitrary
Java objects.")
    (license license:bsd-3)))

(define-public python-pymdown-extensions
  (package
    (name "python-pymdown-extensions")
    (version "10.16.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/facelessuser/pymdown-extensions")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0r36nk1ppq1wrgb1lcy9asp9872xr0gbhxrjw7dpa8lp6m7nqb9k"))))
    (build-system pyproject-build-system)
    ;; XXX: A lot of HTML tests fail with negligible discrepancies.
    (arguments
     (list #:tests? #f))
    (native-inputs (list python-hatchling python-pytest python-pyyaml))
    (propagated-inputs (list python-markdown))
    (home-page "https://github.com/facelessuser/pymdown-extensions")
    (synopsis "Extension pack for Python Markdown")
    (description
     "PyMdown Extensions is a collection of extensions for Python Markdown.
All extensions are found under the module namespace of pymdownx.")
    (license license:expat)))

(define-public python-plotext
  (package
    (name "python-plotext")
    (version "5.2.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "plotext" version))
              (sha256
               (base32
                "1gpy1z2i4vq1mcrhysxahz4339pbl9rzk58rf5m5gf5ym9xji6ii"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/piccolomo/plotext")
    (synopsis "Plots in the terminal")
    (description "Plotext lets you plot directly to the terminal.")
    (license license:expat)))

(define-public python-plotille
  (package
    (name "python-plotille")
    (version "5.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/tammoippen/plotille")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ys8ivsbiv58c8rsrk2m2n3sh2rq6qqaa2mhq0hacsgrvmvv0siz"))
       (modules '((guix build utils)))
       (snippet
        #~(begin
           ;; Without deleting ./imgs setuptools complains as follows: error:
           ;; Multiple top-level packages discovered in a flat-layout:
           ;; ['imgs', 'plotille'].
           (delete-file-recursively "./imgs")))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-mock
           python-pendulum
           python-pytest-cov
           python-pytest-mock
           python-setuptools
           python-wheel))
    (home-page "https://github.com/tammoippen/plotille")
    (synopsis "Plot in the terminal using braille dots")
    (description
     "Plotille provides a figure class and graphing functions to create plots,
scatter plots, histograms and heatmaps in the terminal using braille dots.")
    (license license:expat)))

(define-public python-poetry-dynamic-versioning
  (package
    (name "python-poetry-dynamic-versioning")
    (version "1.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poetry_dynamic_versioning" version))
       (sha256
        (base32 "0j6sm60x0w31kf5003v4dhp9sdz1i5n5qsfd8r4wm8ksh7gvkryn"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_integration.py"
              "-k" (string-join
                    ;; Tests searching for VCS back end.
                    (list "not test__get_version__defaults"
                          "test__enable_in_doc__project_with_dynamic"
                          "test__enable_in_doc__project_with_version"
                          "test__get_version__format_jinja"
                          "test__get_version__format_jinja_imports_with_module_and_item"
                          "test__get_version__format_jinja_imports_with_module_only"
                          "test__get_version__format_jinja_with_enforced_style")
                    " and not "))))
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (propagated-inputs
     (list python-dunamai
           python-jinja2
           python-tomlkit))
    (home-page "https://github.com/mtkennerly/poetry-dynamic-versioning")
    (synopsis "Poetry plugin enabling VCS tags dynamic versioning")
    (description
     "This package provides a build backend that patches Poetry Core to enable
the versioning system in PEP 517 build frontends.")
    (license license:expat)))

(define-public python-poetry-plugin-export
  (package
    (name "python-poetry-plugin-export")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poetry_plugin_export" version))
       (sha256
        (base32 "0qgw6w4xaw7cz9ykw376c5hcg9v2k30lnmna6pc9b4ymhn51d9hz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ;tests cycle with poetry
    (native-inputs
     (list python-poetry-core))
    (propagated-inputs
     (list python-pendulum))
    (home-page "https://python-poetry.org/")
    (synopsis "Poetry plugin to export the dependencies to various formats")
    (description
     "Poetry plugin to export the dependencies to various formats.")
    (license license:expat)))

(define-public python-portpicker
  (package
    (name "python-portpicker")
    (version "1.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "portpicker" version))
       (sha256
        (base32 "1yiisk4h8qliwf99khz3lszrpjf6km76fbhzg01fwrbgz7b7yl5x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This fails because portserver ends up in bin, not site-packages
      '(list "--ignore=src/tests/portserver_test.py")))
    (propagated-inputs (list python-psutil))
    (native-inputs (list python-pytest python-setuptools python-wheel
                         net-tools))
    (home-page "https://github.com/google/python_portpicker")
    (synopsis "Choose unique available network ports")
    (description
     "This package provides a library to choose unique available network
ports.")
    (license license:asl2.0)))

(define-public python-mdx-gh-links
  (package
    (name "python-mdx-gh-links")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mdx_gh_links" version))
       (sha256
        (base32 "11inr9azx6c174yfikysbw0mx7mpjm03qdqr1am2a510mg1amma1"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;tests connect github
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-markdown))
    (home-page "https://github.com/Python-Markdown/github-links/")
    (synopsis "Python-Markdown extension adding support for shorthand links")
    (description "This package is an extension to Python-Markdown which adds
support for shorthand links to GitHub users, repositories, issues and
commits.")
    (license license:bsd-3)))

(define-public python-mkdocs-material
  (package
    (name "python-mkdocs-material")
    (version "7.1.3")
    (source
     (origin
       (method url-fetch)
       (uri
        (pypi-uri "mkdocs-material" version))
       (sha256
        (base32 "0ci9xiasq9nfn09v11m7p49vzazdbgslw7rpzjd6y3hsmn9vljz3"))
       (modules '((guix build utils)))
       (snippet
        ;; TODO There are still bundled assets and minified JS.
        #~(delete-file-recursively "material/assets/javascripts/lunr/min"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f                       ; No tests.
      #:phases
      #~(let ((symlink-js
               (lambda (inputs)
                 (for-each
                  (lambda (lang)
                    (let* ((filename (string-append "lunr." lang ".min.js"))
                           (file (string-append "share/javascript/" filename)))
                      (symlink (search-input-file inputs file) filename)))
                  (list "ar" "da" "de" "es" "fi" "fr" "hu" "it" "ja" "multi"
                        "nl" "no" "pt" "ro" "ru" "stemmer.support" "sv" "tr"
                        "vi")))))
          (modify-phases %standard-phases
          ;; Requirement mkdocs-material-extensions
          ;; in-turn requires mkdocs-material. This causes
          ;; circular dependency, so we remove this requirement.
          (add-after 'unpack 'patch-requirements
            (lambda _
              (substitute* "requirements.txt"
                (("mkdocs-material-extensions.*$")
                 ""))))
          (add-after 'ensure-no-mtimes-pre-1980 'inject-javascript-assets
            (lambda* (#:key inputs #:allow-other-keys)
              (mkdir-p "material/assets/javascripts/min/")
              (with-directory-excursion "material/assets/javascripts/min/"
                (symlink-js inputs))))
          (add-after 'wrap 'replace-javascript-assets
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((site (site-packages inputs outputs))
                     (js-assets (string-append site "/material/"
                                               "assets/javascripts")))
                (with-directory-excursion js-assets
                  (delete-file-recursively "min")
                  (mkdir-p "min")
                  (with-directory-excursion "min"
                    (symlink-js inputs))))))))))
    (native-inputs (list python-setuptools))
    (inputs (list js-lunr-ar
                  js-lunr-da
                  js-lunr-de
                  js-lunr-es
                  js-lunr-fi
                  js-lunr-fr
                  js-lunr-hu
                  js-lunr-it
                  js-lunr-ja
                  js-lunr-nl
                  js-lunr-no
                  js-lunr-pt
                  js-lunr-ro
                  js-lunr-ru
                  js-lunr-sv
                  js-lunr-tr
                  js-lunr-vi
                  js-lunr-multi
                  js-lunr-stemmer-support))
    (propagated-inputs
     (list python-markdown python-mkdocs python-pygments
           python-pymdown-extensions))
    (home-page "https://squidfunk.github.io/mkdocs-material/")
    (synopsis "Material Design theme for MkDocs")
    (description "This package provides a theme plugin for the static site
generator MkDocs.")
    (license license:expat)))

(define-public python-nanobind
  (package
    (name "python-nanobind")
    (version "2.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nanobind" version))
       (sha256
        (base32 "15hw9r0znv7pz8mlgcb892m8ahppaf7gx2xcna2i122qbzp2sfd0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'configure-cmake
            (lambda _
              (invoke "cmake" "-S" "." "-B" "build" "-DNB_TEST_STABLE_ABI=ON")))
          (add-after 'configure-cmake 'build-c++
            (lambda _
              (invoke "cmake" "--build" "build" "-j" "2")))
          (add-before 'check 'pre-check
            (lambda _ (chdir "build"))))))
    (inputs (list eigen))
    (native-inputs (list cmake-minimal
                         python-pytest
                         python-scikit-build-core))
    (home-page "https://github.com/wjakob/nanobind/")
    (synopsis "nanobind: tiny and efficient C++/Python bindings")
    (description "Nanobind is a small binding library that exposes C++ types
in Python and vice versa.  It is reminiscent of @code{Boost.Python} and
@code{pybind11} and uses near-identical syntax.  In contrast to these existing
tools, @code{nanobind} is more efficient: bindings compile in a shorter amount
of time, produce smaller binaries, and have better runtime performance.")
    (license license:bsd-3)))

(define-public python-nr-date
  (package
    (name "python-nr-date")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nr_date" version))
       (sha256
        (base32 "1rnjyykjp41mqz6h1vx18jblq97gi5m5x7dgasyaihnd7fhswhq6"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-nr.date")
    (synopsis "Fast, regex-based date parsing library in plain Python")
    (description "This package provides a fast, regex-based date parsing
library in pure Python.")
    (license license:expat)))

(define-public python-nr-stream
  (package
    (name "python-nr-stream")
    (version "1.1.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nr_stream" version))
       (sha256
        (base32 "0rag4vbjnalkyfcarx6yipn11ih2hmc3pfldava4c6n6pz31c0pb"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-nr.stream")
    (synopsis "Stream and Optional classes for Python")
    (description "This package provides a @code{Stream} and @code{Optional}
class.")
    (license license:expat)))

(define-public python-nr-util
  (package
    (name "python-nr-util")
    (version "0.8.12")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nr.util" version))
       (sha256
        (base32 "1x0l4811dskwrk83l2xzdcldx2iazlrx5wxkg41jz7fr6ch9qm54"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;there are none
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-build-system
            (lambda _
              (substitute* "pyproject.toml"
                (("^config =.*") "config = []\n"))))
          (add-after 'install 'fix-name
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((sitedir (site-packages inputs outputs))
                     (dist-info
                      (string-append sitedir "/nr_util-" #$version ".dist-info")))
                (substitute* (string-append dist-info "/METADATA")
                  (("Name: nr-util")
                   "Name: nr.util"))
                (substitute* (string-append dist-info "/RECORD")
                  (("nr_util") "nr.util"))
                (rename-file dist-info
                             (string-append sitedir
                                            "/nr.util-"
                                            #$version ".dist-info"))))))))
    (propagated-inputs (list python-deprecated python-typing-extensions))
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/NiklasRosenstein/python-nr.util")
    (synopsis "General purpose Python utility library")
    (description "This package provides a general purpose Python utility
library.")
    (license license:expat)))

(define-public python-slicerator
  (package
    (name "python-slicerator")
    (version "1.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "slicerator" version))
       (sha256
        (base32 "0ik0bmh18zgffd9kx53254jp3yyih6zcmd8kfb080xnqbizhl0a4"))))
    (build-system python-build-system)
    (home-page "https://github.com/soft-matter/slicerator")
    (synopsis "Lazy-loading, fancy-sliceable iterable")
    (description
     "This package provides a lazy-loading, fancy-sliceable iterable.  Think
of it like a generator that is \"reusable\" and has a length.")
    (license license:bsd-3)))

(define-public python-pytelegrambotapi
  (package
    (name "python-pytelegrambotapi")
    (version "4.22.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eternnoir/pyTelegramBotAPI")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mic9wk6xg7p2ca7b03fc19l86yc9bkciq7kp8l9xvzzzmg4rzw4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (with-directory-excursion "tests"
                  (invoke "py.test"))))))))
    (propagated-inputs
     (list python-requests))
    (native-inputs
     (list python-hatchling python-pytest))
    (home-page "https://github.com/eternnoir/pyTelegramBotAPI")
    (synopsis "Python Telegram bot api")
    (description "This package provides a simple, but extensible Python
implementation for the Telegram Bot API.")
    (license license:gpl2)))

(define-public python-pytoolconfig
  (package
    (name "python-pytoolconfig")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pytoolconfig" version))
       (sha256
        (base32 "1bnvg9yiwp2fn0lvzhp1dd2mvrymxvjnasmbdap3i0hhdwdbvrji"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-packaging
                             python-platformdirs
                             python-pydantic-2
                             python-sphinx
                             python-sphinx-autodoc-typehints
                             python-sphinx-rtd-theme
                             python-tabulate
                             python-tomli))
    (native-inputs (list python-pdm-backend python-pytest))
    (home-page "https://pypi.org/project/pytoolconfig/")
    (synopsis "Python tool configuration")
    (description "The goal of this project is to manage configuration for
Python tools, such as rope and add support for a @file{pyproject.toml}
configuration file.")
    (license license:lgpl3+)))

(define-public python-pytooling
  (package
    (name "python-pytooling")
    (version "8.7.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pyTooling/pyTooling/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n0idfiwcsssvy3kfwkgdpwx7zmvzp44mv0285d8argdy6rd48p0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Tests do not support linux-i686 system: Exception: Unknown
      ;; architecture 'linux-i686' for a native Linux.
      #:tests? (not (or (%current-target-system)
                             (target-x86-32?)))
      #:test-flags
      #~(list "tests/unit"
              "-k" (string-join
                    ;; Tests checking in /usr/bin and /usr/bin/git paths.
                    (list "not test_BinaryDirectory"
                          "test_ExecutablePath"
                          "test_VersionFlag")
                    " and not "))))
    (native-inputs
     (list git-minimal/pinned
           python-colorama
           python-pytest
           python-ruamel.yaml
           python-setuptools))
    (home-page "https://pytooling.github.io/pyTooling/")
    (synopsis "Miscellaneous Python tools")
    (description
     "pyTooling is a collection of (abstract) data models, lacking classes,
decorators, a new performance boosting meta-class, and enhanced exceptions.
It also provides lots of helper functions---e.g., to ease the handling of
package descriptions or to unify multiple existing APIs into a single API.")
    (license license:asl2.0)))

(define-public python-colorlog
  (package
    (name "python-colorlog")
    (version "6.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "colorlog" version))
       (sha256
        (base32 "1hka1kf6p53hppv05xsa5byr4gasfaaq7r2g3x7gb51vp6hm9fmz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/borntyping/python-colorlog")
    (synopsis "Log formatting with colors for python")
    (description "The @code{colorlog.ColoredFormatter} is a formatter for use
with Python's logging module that outputs records using terminal colors.")
    (license license:expat)))

(define-public python-pyprind
  (package
    (name "python-pyprind")
    (version "2.11.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyPrind" version))
       (sha256
        (base32 "1gscnlvj37m421ch3akm3kddxqkrgbg5zrpwy2ky1j59w6vclzg3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-psutil))
    (home-page "https://github.com/rasbt/pyprind")
    (synopsis "Python Progress Bar and Percent Indicator Utility")
    (description
     "The PyPrind (Python Progress Indicator) module provides a progress bar
and a percentage indicator object that let you track the progress of a loop
structure or other iterative computation.")
    (license license:bsd-3)))

(define-public python-gh-md-to-html
  (package
    (name "python-gh-md-to-html")
    (version "1.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gh_md_to_html" version))
       (sha256
        (base32 "1cnaqnckpcrpc4b8ba18s5ds05w1yfiszcp7ql7pmx0jnrj25qax"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;there are none
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-shellescape-requirement
            (lambda _
              (substitute* "src/__init__.py"
                (("import shellescape")
                 "import shlex")
                (("shellescape\\.quote")
                 "shlex.quote"))
              (substitute* "setup.py"
                (("\"shellescape\",")
                 "")))))))
    (propagated-inputs
     (list python-beautifulsoup4
           python-emoji-for-gh-md-to-html
           python-pillow
           python-requests
           python-webcolors))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/phseiff/github-flavored-markdown-to-html/")
    (synopsis "Github-flavored Markdown")
    (description
     "This package provides a feature-rich Github-flavored Markdown to HTML
Python library and command line interface.")
    (license license:expat)))

(define-public python-gfloat
  (package
    (name "python-gfloat")
    (version "0.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gfloat" version))
       (sha256
        (base32 "143424fqap9bxxybj8l48a00kqqh7vih67ycy7cmkd38kb31zcai"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         "--ignore=test/test_array_api.py" ;requires array_api_strict
         "--ignore=test/test_jax.py"    ;requires python-jax
         "--ignore=test/test_microxcaling.py" ;requires torchao
         ;; Jupyter.
         "--ignore-glob=docs/source/*.ipynb")))
    (propagated-inputs
     (list python-array-api-compat python-more-itertools python-numpy))
    (native-inputs (list python-nbval
                         python-ml-dtypes
                         python-pytest
                         python-pytorch
                         python-setuptools
                         openssl))
    (home-page "https://github.com/graphcore-research/gfloat")
    (synopsis "Generic floating point handling in Python")
    (description
     "This package provides an implementation of generic floating point encode
and decode logic in Python.  It handles various current and proposed floating
point types:

@itemize
@item IEEE 754: Binary16, Binary32
@item OCP Float8: E5M2, E4M3
@item IEEE WG P3109
@item OCP MX Formats: E2M1, M2M3, E3M2, E8M0, INT8, and the MX block formats.
@end itemize")
    (license license:expat)))

(define-public python-glymur
  (package
    (name "python-glymur")
    (version "0.14.3")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/quintusdias/glymur")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0266gj8a2p8jkbgb34lgk8dwin7ib2g38vdh04b2p6yhqx8w3xg8"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count))
              ;; Failing test due to inability of ctypes.util.find_library()
              ;; to determine library path, which is patched above.
              "--ignore=tests/test_config.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-library-locations
            (lambda* (#:key inputs #:allow-other-keys)
              ;; XXX: It's a workaround for Python inability to find the
              ;; .so libraries with ctypes.util.find_library()
              (substitute* '("glymur/config.py")
                (("path = find_library\\(libname\\)")
                 (string-append
                  "if libname == \"openjp2\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libopenjp2.so") "\"\n"
                  "    elif libname == \"tiff\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libtiff.so") "\"\n"
                  "    elif libname == \"c\":\n"
                  "        path = \""
                  (search-input-file inputs "/lib/libc.so.6") "\"\n"))))))))
    (native-inputs
     (list python-pytest
           python-pytest-xdist
           python-scikit-image
           python-setuptools))
    (inputs
     (list openjpeg  ; glymur/lib/openjp2.py
           libtiff)) ; glymur/lib/tiff.py
    (propagated-inputs
     (list python-lxml
           python-numpy
           python-pillow ))
    (home-page "https://github.com/quintusdias/glymur")
    (synopsis "Python interface to OpenJPEG and LibTIFF")
    (description
     "This package provides Python interface to the OpenJPEG library which
allows one to read and write JPEG 2000 files")
    (license license:expat)))

(define-public python-gphoto2
  (package
    (name "python-gphoto2")
    (version "2.6.1")
    (source
     (origin
       (method git-fetch)   ; no tests in PyPI
       (uri (git-reference
             (url "https://github.com/jim-easterbrook/python-gphoto2")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08zwznl3f8j329db747jl2zrpqj58ml39in5gl2gqghw82ssi3gk"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list pkg-config python-pytest python-setuptools python-wheel))
    (inputs
     (list libgphoto2))
    (home-page "https://github.com/jim-easterbrook/python-gphoto2")
    (synopsis "Python interface to libgphoto2")
    (description "@code{python-gphoto2} is a comprehensive Python interface
(or binding) to @code{libgphoto2}.  It is built using @code{SWIG} to
automatically generate the interface code.")
    (license license:lgpl3+)))

(define-public python-colour
  (package
    (name "python-colour")
    (version "0.1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/vaab/colour")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01k2n3zp6j0bws78vdy7i9d6m4lz3bm8z7d7lv1czks1d4aamnr2"))
       (patches (search-patches "python-colour-remove-d2to1.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ; No tests.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (substitute* "autogen.sh"
                (("if ! \"\\$git\".*")
                 "if false ; then\n")
                (("depends git grep")
                 "depends grep")
                (("version=\\$\\(\"\\$git\" describe --tags\\)")
                 (format #f "version=~s" #$version))))))))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/vaab/colour")
    (synopsis "Convert and manipulate various color representations")
    (description
     "This package provides a pythonic way to manipulate color representations
(HSL, RVB,web, X11, ...).")
    (license license:expat)))

(define-public python-rapidfuzz
  (package
    (name "python-rapidfuzz")
    (version "3.14.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rapidfuzz/RapidFuzz")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1kqy9paxri1ih47mwmsxwz7a222sn2si5n8qd7gxhdf1wdrpdrm7"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list cmake-minimal
           python-cython
           python-pytest
           python-scikit-build-core
           rapidfuzz-cpp
           taskflow))
    (home-page "https://github.com/rapidfuzz/RapidFuzz")
    (synopsis "Rapid fuzzy string matching")
    (description
     "RapidFuzz is a fast string matching library for Python and
C++, which is using the string similarity calculations from FuzzyWuzzy.")
    (license license:expat)))

(define-public python-easygui
  (package
    (name "python-easygui")
    (version "0.98.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robertlugg/easygui")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vwd0dvldl993sp7b24h5yn269vykq7mmp9khdssqryfchfbajx6"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: There seem to be no tests upstream, although the package itself
     ;; seems to provide a lot of demo elements.
     (list #:tests? #f))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list `(,python "tk")))
    (home-page "https://github.com/robertlugg/easygui")
    (synopsis "GUI programming module for Python")
    (description
     "EasyGUI is a module for easy GUI programming in Python.  EasyGUI is
different from other GUI generators in that EasyGUI is NOT event-driven.
Instead, all GUI interactions are invoked by simple function calls.")
    (license license:bsd-3)))

(define-public python-echo
  (package
    (name "python-echo")
    (version "0.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "echo" version))
       (sha256
        (base32 "1hr2kgjmf5gcjbg1mry03ca1dayfwy8mi8as42jfg0apsa3bfvvj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'start-xorg-server
            (lambda _
              ;; The test suite requires a running X server.
              (system "Xvfb :99 -screen 0 1024x768x24 &")
              (setenv "DISPLAY" ":99.0"))))))
    (propagated-inputs
     (list python-numpy
           python-qtpy
           python-pyqt-6))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm
           python-wheel
           xorg-server-for-tests))
    (home-page "https://github.com/glue-viz/echo")
    (synopsis "Callback Properties in Python")
    (description
     "Echo is a small library for attaching callback functions to property
state changes.")
    (license license:expat)))

(define-public python-pymd4c
  (package
    (name "python-pymd4c")
    (version "0.4.6.0b1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dominickpastore/pymd4c")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0skmdn2bxfc546djxapdgb0bjvlr3c7a3kkv7j3bpx9zw09m0rcs"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; No tests.
    (inputs (list md4c))
    (native-inputs (list pkg-config python-pkgconfig python-setuptools))
    (home-page "https://github.com/dominickpastore/pymd4c")
    (synopsis "Python bindings for MD4C")
    (description
     "PyMD4C provides Python bindings for MD4c, a C Markdown parser, compliant
to CommonMark.")
    (license license:expat)))

(define-public python-pymediainfo
  (package
    (name "python-pymediainfo")
    (version "4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymediainfo" version))
       (sha256
        (base32 "0mhpxs7vlqx8w75z93dy7nnvx89kwfdjkla03l19an15rlyqyspd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; The only failing test requires internet access.
      #:test-flags
      #~(list "-k" "not test_parse_url")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-libmediainfo
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "pymediainfo/__init__.py"
                (("libmediainfo.so.0")
                 (search-input-file inputs "/lib/libmediainfo.so.0"))))))))
    (native-inputs (list python-pytest python-setuptools))
    (inputs (list libmediainfo))
    (home-page "https://github.com/sbraz/pymediainfo")
    (synopsis "Python wrapper for the mediainfo library")
    (description
     "This package provides a Python wrapper for the mediainfo library to
access the technical and tag data for video and audio files.")
    (license license:expat)))

(define-public python-psutil
  (package
    (name "python-psutil")
    (version "7.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "psutil" version))
       (sha256
        (base32 "0mn42p9pzh0wynhk9i18iyvp8h54hbcsyczajmjcpv4blgmw7sbv"))))
    (build-system pyproject-build-system)
    (arguments
     ;; FIXME: some tests do not return and time out.  Some tests fail because
     ;; some processes survive kill().
     '(#:tests? #f))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/giampaolo/psutil")
    (synopsis "Library for retrieving information on running processes")
    (description
     "@code{psutil} (Python system and process utilities) is a library for
retrieving information on running processes and system utilization (CPU,
memory, disks, network) in Python.  It is useful mainly for system monitoring,
profiling and limiting process resources and management of running processes.
It implements many functionalities offered by command line tools such as: ps,
top, lsof, netstat, ifconfig, who, df, kill, free, nice, ionice, iostat,
iotop, uptime, pidof, tty, taskset, pmap.")
    (license license:bsd-3)))

(define-public python-scapy
  (package
    (name "python-scapy")
    (version "2.6.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "scapy" version))
              (sha256
               (base32
                "1ig6qv1kpk7z9n8xf41y5fzywfv42xzd61bf79f3x19w73idf03n"))))
    (arguments
     '(#:tests? #f)) ; There is a test directory, but apparently no
                     ; automatic testing framework.
    ;; The package has more optional dependencies such as ipython and
    ;; matplotlib. If functionality is missing, these should be added.
    ;; See
    ;; https://scapy.readthedocs.io/en/latest/installation.html#optional-dependencies
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://scapy.net")
    (synopsis "Python network packet crafting library")
    (description
     "Scapy is a Python library and executable for interactively
manipulating network packets.  It can forge or decode packets of a number
of protocols, send them on the wire, capture them, store or read them
using pcap files, match requests and replies, and so on.
It can handle tasks such as scanning, tracerouting, probing, unit tests,
attacks or network discovery.")
    (license license:gpl2)))

(define-public python-icmplib
  (package
    (name "python-icmplib")
    (version "3.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ValentinBELYN/icmplib")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04h877ryg22vsgvq35dqwpf0b1v8hvfl2gc857zxqzig4ld5qw1y"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; No tests.
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/ValentinBELYN/icmplib")
    (synopsis
     "Python implementation of the Internet Control Message Protocol (ICMP)")
    (description
     "@code{icmplib} is a supporting library for both IPv4 and IPv6 networks.
ICMP is typically used for diagnostic or control purposes - well known from
utilities such as ping(1).")
    (license license:lgpl3)))

(define-public python-iron-core
  (let ((commit "5a5f3011da09769a812c6a1c44781ef852abc19b")
        (revision "0"))
    (package
      (name "python-iron-core")
      (version (git-version "1.2.1" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://www.github.com/iron-io/iron_core_python")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "030ibimgqvc6hywh7g3k7qn147ckagi0wbdiqcpdf1c85xqrj5zq"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        ;; XXX: Tests are run, but they seem too old/not updated.
        #:tests? #f
        #:test-backend #~'unittest))
      (propagated-inputs (list python-dateutil python-requests))
      (native-inputs (list python-setuptools))
      (home-page "https://www.github.com/iron-io/iron_core_python")
      (synopsis "Universal classes and methods for Iron.io API wrappers")
      (description
       "This package provides universal classes and methods for the Iron.io
API wrappers to build on.")
      (license license:bsd-2))))

(define-public python-iron-mq
  (let ((commit "e6ff76ac0068c3184d9003e3163b94ffc839dbe8")
        (revision "0"))
    (package
      (name "python-iron-mq")
      (version (git-version "0.9" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/iron-io/iron_mq_python")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0bb8gpzb3jr2r6i367jspwcxrz5ygdf40a67nl9aj5n79hg1aq8x"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        ;; XXX: Tests are broken and require network access.
        #:tests? #f
        #:test-backend #~'unittest))
      (propagated-inputs (list python-iron-core))
      (native-inputs (list python-setuptools))
      (home-page "https://github.com/iron-io/iron_mq_python")
      (synopsis "Client library for IronMQ, a message queue in the cloud")
      (description
       "This package provides Python language bindings for IronMQ.  IronMQ is an
elastic message queue for managing data and event flow within cloud
applications and between systems.")
      (license license:bsd-2))))

(define-public python-rasterio
  (package
    (name "python-rasterio")
    (version "1.3.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rasterio" version))
              (sha256
               (base32
                "012341c1rlcdr9rkg97lbhxrwzn4sr2xah4zjfnqy2r1227wpzdb"))))
    (properties
     '((updater-ignored-native-inputs . ("gdal" "python-cython"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;test data not present
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (propagated-inputs (list python-affine
                             python-attrs
                             python-certifi
                             python-click
                             python-click-plugins
                             python-cligj
                             python-numpy
                             python-setuptools ; For pkg_resources.
                             python-snuggs))
    (native-inputs (list gdal
                         python-boto3
                         python-cython
                         python-hypothesis
                         python-packaging
                         python-pytest
                         python-pytest-cov
                         python-shapely
                         python-wheel))
    (home-page "https://github.com/rasterio/rasterio")
    (synopsis "Fast and direct raster I/O for use with Numpy and SciPy")
    (description "This package implements fast and direct raster I/O for use
with Numpy and SciPy.")
    (license license:bsd-3)))

(define-public python-rich-tables
  (package
    (name "python-rich-tables")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/snejus/rich-tables")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gkwgxcjnghn0alqw53kgb4ixf047dnb49kc0af3blvcwnmfmb5f"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; TypeError: can't subtract offset-naive and offset-aware datetimes
      #~(list "--deselect=tests/test_outputs.py::test_outputs[tests/json/album.json]")))
    (native-inputs
     (list python-freezegun
           python-poetry-core
           python-pytest
           python-pytest-cov))
    (propagated-inputs
     (list python-funcy
           python-humanize
           python-multimethod
           python-platformdirs
           python-rgbxy
           python-rich
           python-sqlparse))
    (home-page "https://github.com/snejus/rich-tables")
    (synopsis "Ready-made rich tables for various purposes")
    (description
     "This package implements rich tables for various purposes, it's JSON
human-prettifier based on the @code{rich} Python library.")
    (license license:expat)))

(define-public python-rich-toolkit
  (package
    (name "python-rich-toolkit")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rich_toolkit" version))
       (sha256
        (base32 "0h3cda068xc0v8jqcp7fyrb6d4xlhcjlxm5bfygk04408500pjzs"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-click python-rich python-typing-extensions))
    (native-inputs (list python-hatchling python-inline-snapshot python-pytest))
    (home-page "https://pypi.org/project/rich-toolkit/")
    (synopsis "Rich toolkit for building command-line applications")
    (description "This package provides the Rich toolkit for building
command-line applications.")
    (license license:expat)))

(define-public python-shapely
  (package
    (name "python-shapely")
    (version "2.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shapely" version))
       (sha256
        (base32 "0wi71vyjyb04lbw6kkl9vcsmn7n28j8002288m19dziggyb221jh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
     (list python-cython python-matplotlib python-pytest python-setuptools python-wheel))
    (inputs
     (list geos))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/shapely/shapely")
    (synopsis "Library for the manipulation and analysis of geometric objects")
    (description "Shapely is a Python package for manipulation and analysis of
planar geometric objects.  It is based on the @code{GEOS} library.")
    (license license:bsd-3)))

(define-public python-shortuuid
  (package
    (name "python-shortuuid")
    (version "1.0.13")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shortuuid" version))
       (sha256
        (base32
         "0wjygiwk07irgqmr29bv7rvq9pc71ff3jinzn620a9h6yq3wzf9v"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://github.com/skorokithakis/shortuuid")
    (synopsis "Generator library for concise, unambiguous and URL-safe UUIDs")
    (description
     "@code{shortuuid} is a Python library for generating concise, unambiguous
and URL-safe UUIDs.  UUIDs are generated using the built-in Python @code{uuid}
module and then similar looking characters are removed.")
    (license license:bsd-3)))

(define-public python-logwrap
  (package
    (name "python-logwrap")
    (version "11.1.1")
    (source
     (origin
       (method git-fetch) ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/python-useful-helpers/logwrap")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07m4c87pavpdak1lx4bvdz43y2wwzm6fc54x947cssgwqz8mw3zp"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            ;; Indicate version to setuptools-scm
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                      #$(package-version this-package)))))))
    (native-inputs (list python-pytest
                         python-setuptools
                         python-setuptools-scm
                         python-wheel))
    (home-page "https://github.com/python-useful-helpers/logwrap")
    (synopsis "Decorator for logging function arguments")
    (description "This package provides a decorator to log function arguments
and function call return values in a human-readable way.")
    (license license:asl2.0)))

(define-public python-clyent
  (package
    (name "python-clyent")
    (version "1.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/Anaconda-Platform/clyent")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vi9nkd4hnvycwwpz9xip1drc5zn7bdwff1pz3azmyvh8v4hsias"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:phases
      #~(modify-phases %standard-phases
          ;; Replace version manually because clyent uses
          ;; versioneer, which requires git metadata.
          (add-after 'unpack 'versioneer
            (lambda _
              (invoke "versioneer" "install")
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(),")
                 (string-append "version='" #$version "',"))))))))
    (native-inputs
     (list python-mock
           python-setuptools
           python-versioneer))
    (home-page "https://github.com/Anaconda-Platform/clyent")
    (synopsis "Command line client library")
    (description
     "Clyent is a Python command line utility library.  It is used by
@code{binstar}, @code{binstar-build}, and @code{chalmers}.")
    (license license:bsd-3)))

(define-public python-babel
  (package
    (name "python-babel")
    (version "2.16.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "babel" version))
       (sha256
        (base32 "05p3k0i5h8v4vqsg36s94kwl4nhgfmgwdq1x7wbzw1b6l965bwyi"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-freezegun
           python-pytest
           python-setuptools
           tzdata-for-tests))
    (propagated-inputs
     (list python-pytz))
    (home-page "https://babel.pocoo.org/")
    (synopsis
     "Tools for internationalizing Python applications")
    (description
     "Babel is composed of two major parts:
- tools to build and work with gettext message catalogs
- a Python interface to the CLDR (Common Locale Data Repository), providing
access to various locale display names, localized number and date formatting,
etc.")
    (license license:bsd-3)))

(define-public python-bidict
  (package
    (name "python-bidict")
    (version "0.23.1")
    (source
     (origin
       (method git-fetch) ; no tests in PyPI.
       (uri (git-reference
             (url "https://github.com/jab/bidict")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1qsbxjjsrks3icyq19afr5y47zdrfb0cvaadpprgcszq2ilihkaq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-benchmark
           python-pytest-xdist
           python-setuptools
           python-sortedcollections
           python-wheel))
    (home-page "https://bidict.readthedocs.io")
    (synopsis "Bidirectional mapping library")
    (description "The @code{bidict} library provides several data structures
for working with bidirectional mappings in Python.")
    (license license:mpl2.0)))

(define-public python-bip39
  (package
    (name "python-bip39")
    (version "0.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bip39" version))
       (sha256
        (base32 "18m7d3gi7vj2zi0bl1z7m0nhcj6i8j9vj4vil276siagnpkv64ry"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/de-centralized-systems/python-bip39/")
    (synopsis "Self-contained and simple BIP39 implementation in Python")
    (description
     "This package provides a self-contained and simple BIP39
implementation written in Python.  It includes a @code{bip39.py} executable.

BIP39 is a standardized mapping between binary data (the @emph{entropy}),
and a list of words that are easier to remember for humans (the
@emph{mnemonic}).")
    (license license:expat)))

(define-public python-bitarray
  (package
    (name "python-bitarray")
    (version "3.4.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bitarray" version))
              (sha256
               (base32
                "1w32bybj7qx99pkwyhb4g9c1y5mp89kc838iq30swrkb12zv5pyx"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     ;; Step out of the source directory to avoid interference.
                     (with-directory-excursion "/tmp"
                       (invoke "python" "-c"
                               "import bitarray; bitarray.test()"))))))))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/ilanschnell/bitarray")
    (synopsis "Efficient arrays of booleans")
    (description "This package provides an object type which efficiently
represents an array of booleans.  Bitarrays are sequence types and behave very
much like usual lists.  Eight bits are represented by one byte in a contiguous
block of memory.  The user can select between two representations:
little-endian and big-endian.  All of the functionality is implemented in C.
Methods for accessing the machine representation are provided.  This can be
useful when bit level access to binary files is required, such as portable
bitmap image files.  Also, when dealing with compressed data which uses
variable bit length encoding, you may find this module useful.")
    (license license:psfl)))

(define-public python-bitarray-2
  (package
    (inherit python-bitarray)
    (version "2.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bitarray" version))
              (sha256
               (base32
                "1wy80bmhg33bpzn28g1n7s8r8f4drj7pcl4m2qb5sql8bbryx376"))))))

(define-public python-boolean.py
  (package
    (name "python-boolean.py")
    (version "5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "boolean_py" version))
       (sha256
        (base32 "15cd64x2m1cbcnjasw0m2977ab1n0mam8j96schkfxbrs2xc9jv0"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/bastikr/boolean.py")
    (synopsis "Boolean algebra in one Python module")
    (description
     "This is a small Python library that implements boolean algebra.
It defines two base elements, @code{TRUE} and @code{FALSE}, and a
@code{Symbol} class that can take on one of these two values.  Calculations
are done only in terms of @code{AND}, @code{OR}, and @code{NOT}---other
compositions like @code{XOR} and @code{NAND} are emulated on top of them.
Expressions are constructed from parsed strings or directly in Python.")
    (license license:bsd-2)))

(define-public python-pyhdf
  (package
    (name "python-pyhdf")
    (version "0.11.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyhdf" version))
       (sha256
        (base32 "0nlcz7p3mcqa0s161iqnnfgwgx0np8rhz8p924g5hlcn1bfy6vcz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--pyargs" "pyhdf")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'relax-gcc-14-strictness
            (lambda _
              (setenv "CFLAGS" (string-join
                                (list "-g" "-O2"
                                      "-Wno-error=incompatible-pointer-types")
                                " "))))
          (add-after 'check 'run-example-tests
            (lambda _
              (invoke "python" "examples/runall.py"))))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm))
    (inputs
     (list hdf4
           libjpeg-turbo
           zlib))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/fhs/pyhdf")
    (synopsis "Python interface to the NCSA HDF4 library")
    (description
     "PYHDF4 is a python wrapper around the NCSA HDF version 4 library,
which implements the SD (Scientific Dataset), VS (Vdata) and V (Vgroup) API’s.
NetCDF files can also be read and modified.  It is a successor of Python-HDF4
which is a fork of @url{http://hdfeos.org/software/pyhdf.php,pyhdf}.")
    (license license:expat)))

;; Version 0.9.x was called python-hdf4 in PyPI because at that time upstream
;; didn't have access to the pyhdf package in PyPI. For version 0.10.0 and
;; onward, please install pyhdf instead of python-hdf4.
(define-deprecated-package python-hdf4
  python-pyhdf)

(define-public python-h5netcdf
  (package
    (name "python-h5netcdf")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "h5netcdf" version))
       (sha256
        (base32 "1kw3cf01kziwxmb84x0cy6vbpsmqjm0k1dm34i6b4d7bv8kw0wd1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-netcdf4
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-h5py python-packaging))
    (home-page "https://h5netcdf.org")
    (synopsis "Python interface for the netCDF4 file-format based on h5py")
    (description "This package provides a Python interface for the netCDF4
file-format that reads and writes local or remote HDF5 files directly via
@url{h5py, https://www.h5py.org/} or @url{h5pyd,
https://github.com/HDFGroup/h5pyd}, without relying on the Unidata netCDF
library.")
    (license license:bsd-3)))

(define-public python-h5py
  (package
    (name "python-h5py")
    (version "3.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "h5py" version))
       (sha256
        (base32 "1hq5f5mnkv2138xsq7k7qncf6b7zc0cmm2fhhpd2603j31jy8w0q"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-hdf5-paths
            (lambda _
              (setenv "HDF5_DIR" #$(this-package-input "hdf5"))))
          ;; The tests only work after being installed.
          (delete 'check)
          (add-after 'install 'check
            (lambda* (#:key inputs outputs tests? #:allow-other-keys)
              (when tests?
                (setenv "H5PY_TEST_CHECK_FILTERS" "1")
                (with-directory-excursion (site-packages inputs outputs)
                  (invoke "pytest" "-vv")))))
          (add-before 'build 'relax-gcc-14-strictness
            (lambda _
              (setenv
               "CFLAGS"
               (string-append
                "-g -O2"
                `" -Wno-error=incompatible-pointer-types")))))))
    (propagated-inputs (list python-six python-numpy))
    (inputs (list hdf5))
    (native-inputs
     (list pkg-config
           python-cython
           python-ipython
           python-pkgconfig
           python-pytest
           ;; Required to run tests, but the MPI tests are skipped anyway.
           python-pytest-mpi
           python-setuptools
           python-wheel))
    (home-page "https://www.h5py.org/")
    (synopsis "Read and write HDF5 files from Python")
    (description
     "The h5py package provides both a high- and low-level interface to the
HDF5 library from Python.  The low-level interface is intended to be a
complete wrapping of the HDF5 API, while the high-level component supports
access to HDF5 files, datasets and groups using established Python and NumPy
concepts.")
    (license license:bsd-3)))

(define-public python-hdf5storage
  ;; Use the latest commit containing compatability with Pytest and Python
  ;; 3.11, see <https://github.com/frejanordsiek/hdf5storage/issues/135>.
  (let ((commit "7ee2a96de134b44beaa79c3a11c559f9ac87c5a6")
        (revision "0"))
    (package
      (name "python-hdf5storage")
      (version (git-version "0.1.19" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/frejanordsiek/hdf5storage")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0xq0rg8vwk35yc3jvv2fyf7bl189viq0fywch53g57hxrahv5k02"))))
      (build-system pyproject-build-system)
      (native-inputs
       (list python-pytest
             python-setuptools
             python-wheel))
      (propagated-inputs
       (list python-h5py
             python-numpy))
      (home-page "https://github.com/frejanordsiek/hdf5storage")
      (synopsis "Read and write Python data types from and to HDF5 files")
      (description
       "This Python package provides high-level utilities to read and write a
variety of Python types from and to @acronym{HDF5, Hierarchical Data Format}
formatted files.  This package also provides support for MATLAB MAT v7.3
formatted files, which are HDF5 files with a different extension and some
extra metadata.  Because HDF5 and MAT files might need to be read from
untrusted sources, pickling is avoided in this package.")
      (license license:bsd-2))))

(define-public python-prctl
  (package
    (name "python-prctl")
    (version "1.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "python-prctl" version))
              (sha256
                (base32
                  "1kk7gv582w72spnz6agr0pz0hlpgchp3l7zxzzjarwfllwjrmjml"))))
    (build-system pyproject-build-system)
    (arguments
      (list #:test-backend ''custom
            #:test-flags ''("test_prctl.py")
            #:phases
            #~(modify-phases %standard-phases
                (add-after 'unpack 'patch-tests
                  (lambda _
                    (substitute* "test_prctl.py"
                      ;; actual suffix used in cpython build output dir name
                      (("sys.version\\[0:3\\]") "sys.implementation.cache_tag")
                      ;; test_no_new_privs assumes existance of /bin/ping, but
                      ;; can never run anyway due to it requiring setuid ping.
                      ;; just short circuit it instead.
                      (("os.stat\\('/bin/ping'\\)\\.st_mode") "0")))))))
    (inputs (list libcap))
    (native-inputs (list python-setuptools))
    (supported-systems (filter target-linux? %supported-systems))
    (home-page "https://pythonhosted.org/python-prctl")
    (synopsis "Linux capabilities library")
    (description "This package provides a Python library for controlling Linux
capabilities and attributes, similar to the prctl syscall.")
    (license license:gpl3+)))

(define-public python-pyhimitsu
  (package
    (name "python-pyhimitsu")
    (version "0.0.9")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "py_himitsu" version))
              (sha256
                (base32
                  "1kljxhjvfy945zij8fif3s6xzgcyslxz99mv460iy0anzj433pj5"))))
    (build-system pyproject-build-system)
    (arguments
      (list
        #:phases
        #~(modify-phases %standard-phases
            (replace 'check
              (lambda _
                ;; (setenv "PYTHONPATH" (getenv "GUIX_PYTHONPATH"))
                (invoke "make" "check"))))))
    (native-inputs (list python-hatchling))
    (propagated-inputs (list python-pyxdg))
    (home-page "https://git.sr.ht/~apreiml/py-himitsu")
    (synopsis "Himitsu client protocol implementation in Python")
    (description "This package provides a library for writing Himitsu client
programs in Python.")
    (license license:expat)))

(define-public python-hjson
  ;; Using commit from master branch as the PyPI version does not contain
  ;; the hjson/tests/ directory.
  (let ((revision "0")
        (commit "1687b811fcbbc54b5ac71cfbaa99f805e406fbcb"))
    (package
      (name "python-hjson")
      (version (git-version "3.1.0" revision commit))
      (source (origin
                (method git-fetch)
                (uri (git-reference
                       (url "https://github.com/hjson/hjson-py")
                       (commit commit)))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "1qfqnhvfx5mm7bdajjnnagmvns1zxyksjzh3k5la2ag6a8bp5gki"))))
      (build-system pyproject-build-system)
      (native-inputs (list python-setuptools python-wheel))
      (home-page "https://github.com/hjson/hjson-py")
      (synopsis "Python package to parse HJSON documents")
      (description "This package provides a Python library and a command-line
interface utility to parse @url{https://hjson.github.io/, HJSON}) documents.")
      (license license:expat))))

(define-public python-hnswlib
  (package
    (name "python-hnswlib")
    (version "0.5.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nmslib/hnswlib")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ixhpsqlikjf7id1zlgqakq2ihpvq5h3npxj7mqjbx09ncsjam1m"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'disable-native-optimization
            (lambda _
              (substitute* "setup.py"
                ((", '-march=native'")
                 "")))))))
    (propagated-inputs (list python-numpy))
    (native-inputs (list pybind11 python-pytest python-setuptools))
    (home-page "https://github.com/nmslib/hnswlib")
    (synopsis "Fast approximate nearest neighbor search")
    (description "Hnswlib is a header-only C++ implementation of fast
approximate nearest neighbor search with Python bindings.")
    (license license:asl2.0)))

(define-public python-pylatexenc
  (package
    (name "python-pylatexenc")
    (version "2.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pylatexenc" version))
       (sha256
        (base32 "1ls09z47b5md71gkxcj7fd87ynpvv2walgp2w6z31p26xf2gvn1x"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/phfaist/pylatexenc")
    (synopsis "LaTeX parser for Unicode/LaTeX conversion")
    (description
     "@code{python-pylatexenc} is a LaTeX parser providing LaTeX-to-Unicode and
Unicode-to-LaTeX conversion.")
    (license license:expat)))

(define-public python-lsp-black
  (package
    (name "python-lsp-black")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python-lsp/python-lsp-black")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ilh6nx15kzrp29nkrpx03vx6dw3n7wq65qwv7bg7kcnyiwacplx"))))
    (build-system pyproject-build-system)
    (arguments
     ;; The python version is too old for these tests to pass properly.
     (list #:test-flags
           `'("-k" ,(string-append
                     "not test_pylsp_format_document_syntax_error"
                     " and not test_pylsp_format_range_syntax_error"
                     " and not test_load_config_defaults"
                     " and not test_load_config_with_skip_options"))))
    (propagated-inputs
     (list python-black python-lsp-server python-tomli))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/python-lsp/python-lsp-black")
    (synopsis "Black plugin for the Python LSP Server")
    (description "This package provides a plugin with support for the
@code{python-black} formatter for the Python LSP Server.")
    (license license:expat)))

(define-public python-pylsp-mypy
  (package
    (name "python-pylsp-mypy")
    (version "0.6.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pylsp_mypy" version))
       (sha256
        (base32 "1amvqzb5lhhw2011003mwm88chb8sz5aax1jrqc3jg0jpak992fj"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-mypy python-lsp-server))
    (home-page "https://github.com/python-lsp/pylsp-mypy")
    (synopsis "Mypy linter for the Python LSP Server")
    (description
     "Mypy linter integration for use with @code{python-lsp-server}.")
    (license license:expat)))

(define-public python-sh
  (package
    (name "python-sh")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sh" version))
       (sha256
        (base32
         "0nxnkvmrl6vlan6lsvjymmxpr0gf8k0gnwr1632lwa0sqjkjfck5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; These tests are shaky.
                    (list "not test_bad_sig_raise_exception"
                          "test_doesnt_execute_directories"
                          "test_environment"
                          "test_ok_code_ignores_bad_sig_exception"
                          "test_unicode_path")
                    " and not ")
              "tests")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://github.com/amoffat/sh")
    (synopsis "Python subprocess replacement")
    (description "This package provides a replacement for Python's
@code{subprocess} feature.")
    (license license:expat)))

;; Old version just for python-dotenv-0.13.0 for docker-compose; remove once
;; that is updated.
(define-public python-sh-1
  (package
    (inherit python-sh)
    (version "1.14.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sh" version))
       (sha256
        (base32
         "03gyss1rhj4in7pgysg4q0hxp3230whinlpy1532ljs99lrx0ywx"))))
    ;(build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _
             ;; XXX: A Python 2 test fails when HOME=/homeless-shelter.
             (setenv "HOME" "/tmp")
             (invoke "python" "sh.py" "test"))))))
    (native-inputs
     (list python-setuptools))))

(define-public python-cftime
  (package
    (name "python-cftime")
    (version "1.6.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cftime" version))
       (sha256
        (base32 "07p8s5a0xacn404x6l0i04q1gz2h0h9m5azbhdvbhgxlp7bgw9c2"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'remove-unwanted-pytest-options
                 (lambda _
                   (substitute* "setup.cfg"
                     (("doctest_optionflags.*")
                      "")
                     (("--cov.*")
                      "")))))))
    (propagated-inputs
     (list python-numpy))
    (native-inputs
     (list python-cython
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://unidata.github.io/cftime/")
    (synopsis "Library for time handling")
    (description
     "This package provides time-handling functionality that used to be part
of the netcdf4 package before.")
    (license license:expat)))

(define-public python-netcdf4
  (package
    (name "python-netcdf4")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "netCDF4" version))
       (sha256
        (base32
         "0lxfykqdkpbmqma72m2mhwdz8lgl83n5vj7ydygl3252yqpv10h3"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-configure-flags
            (lambda _
              (setenv "CFLAGS" (string-join
                                (list "-Wno-error=incompatible-pointer-types"
                                      "-Wno-error=implicit-function-declaration"
                                      "-Wno-error=int-conversion")
                                " "))
              (setenv "HDF5_DIR" #$(this-package-input "hdf5"))
              (setenv "NETCDF4_DIR" #$(this-package-input "netcdf"))
              (setenv "USE_NCCONFIG" "0")))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (with-directory-excursion "test"
                  (setenv "NO_NET" "1")
                  (setenv "NO_CDL" "1")
                  (invoke "python" "run_all.py"))))))))
    (native-inputs
     (list python-cython
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy python-cftime))
    (inputs
     (list netcdf hdf5 zlib))
    (home-page "https://github.com/Unidata/netcdf4-python")
    (synopsis "Python/numpy interface to the netCDF library")
    (description "Netcdf4-python is a Python interface to the netCDF C
library.  netCDF version 4 has many features not found in earlier
versions of the library and is implemented on top of HDF5.  This module
can read and write files in both the new netCDF 4 and the old netCDF 3
format, and can create files that are readable by HDF5 clients.  The
API is modelled after @code{Scientific.IO.NetCDF}, and should be familiar
to users of that module.")
    ;; The software is mainly ISC, but includes some files covered
    ;; by the Expat license.
    (license (list license:isc license:expat))))

(define-public python-ncclient
  (package
    (name "python-ncclient")
    (version "0.6.19")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/ncclient/ncclient")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0nmyj59k9zbdfhm7qhrq9gd4x6vhjdf18q1kwfgb2gwcb3b8nd2h"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-lxml
           python-paramiko))
    (home-page "https://github.com/ncclient/ncclient")
    (synopsis "Python library for NETCONF clients")
    (description "@code{ncclient} is a Python library that facilitates
client-side scripting and application development around the NETCONF
protocol.")
    (license license:asl2.0)))

(define-public python-ncls
  (package
    (name "python-ncls")
    (version "0.0.68")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ncls" version))
              (sha256
               (base32
                "14xsnzr34xa4rwfcdjry9aqjs8i03s9fzy6jgrwj3fr3n6msbal1"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Those tests fail with warnings (not errors) for the Numpy update.
     ;; Remove it at next python-team iteration.
     (list #:test-flags ''("--ignore=examples/test_all_overlaps_both.py"
                           "--ignore=examples/test_find_overlap_list.py")))
    (native-inputs (list python-cython
                         python-pandas
                         python-pytest
                         python-setuptools
                         python-wheel))
    (propagated-inputs (list python-numpy))
    (home-page "https://github.com/endrebak/ncls")
    (synopsis "Nested containment list data structure")
    (description
     "This package provides a wrapper for the nested containment list data
structure.  It is a static interval-tree that is fast for both construction
and lookups.")
    (license license:bsd-3)))

(define-public python-license-expression
  (package
    (name "python-license-expression")
    (version "30.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "license-expression" version))
       (sha256
        (base32 "0lvshl2fhwa568d3y3vmx45hdp8gk5w9yl3b2q5d66r5vqn1sfwl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools-scm python-pytest python-setuptools python-wheel))
    (propagated-inputs
     (list python-boolean.py))
    (home-page "https://github.com/nexB/license-expression")
    (synopsis "Apply boolean logic to license expressions")
    (description
     "This Python module defines a tiny language to evaluate and compare
license expressions using boolean logic.  Logical combinations of licenses can
be tested for equality, containment, and equivalence.  They can be normalised
and simplified.  It supports SPDX license expressions as well as other naming
conventions and aliases in the same expression.")
    (license license:gpl2+)))

(define-public python-limits
  (package
    (name "python-limits")
    (version "5.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alisaifee/limits")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ykld43q1pbvds4wsb18wagh852byzjpcjqg1xwa5cldigmkc2x0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: Despite running only unit tests, pytest exits with an error code.
      #:tests? #f
      #:test-flags #~(list "-m" "unit")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'ignore-K-pytest-option
            (lambda _
              (substitute* "pytest.ini"
                (("-K") "")))))))
    (propagated-inputs (list python-deprecated python-packaging))
    (native-inputs
     (list ; python-etcd3
           python-flaky
           python-pytest
           python-pytest-asyncio
           python-pytest-benchmark
           python-pytest-cov
           python-pytest-lazy-fixtures
           python-pytest-xdist
           ;; python-pymemcache
           ;; python-pymongo
           ;; python-redis
           python-setuptools
           ;; python-valkey
           ))
    (home-page "https://limits.readthedocs.io/")
    (synopsis "Rate limiting utilities")
    (description
     "This package provides a Python library to perform rate limiting with
commonly used storage backends.")
    (license license:expat)))

(define-public python-lockfile
  (package
    (name "python-lockfile")
    (version "0.12.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lockfile" version))
       (sha256
        (base32
         "16gpx5hm73ah5n1079ng0vy381hl802v606npkx4x8nb0gg05vba"))))
    (build-system python-build-system)
    (arguments '(#:test-target "check"))
    (native-inputs
     (list python-pbr))
    (home-page "https://launchpad.net/pylockfile")
    (synopsis "Platform-independent file locking module")
    (description
     "The lockfile package exports a LockFile class which provides a simple
API for locking files.")
    (license license:expat)))

(define-public python-fb-re2
  (package
    (name "python-fb-re2")
    (version "1.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/facebook/pyre2")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0snprxdnh3m45r3b0az4v0l28h90ycmfbybzla6xg1qviwv9w1ak"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (inputs
     (list re2))
    (home-page "https://github.com/facebook/pyre2")
    (synopsis "Python wrapper for RE2")
    (description "This package provides a Python extension that wraps Google's
RE2 regular expression library.  It implements many of the features of
Python's built-in @code{re} module with compatible interfaces.")
    (license license:bsd-3)))

(define-public python-filelock
  (package
    (name "python-filelock")
    (version "3.16.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filelock" version))
       (sha256
        (base32
         "0d8ljvmsfgriiqf5dqii91gfcpj7cpjrh8fnsvifaiyvspygnjf2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Break cycle with virtualenv.
      #:test-flags #~(list "--ignore=tests/test_virtualenv.py")))
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-asyncio
           python-pytest-mock
           python-setuptools-scm))
    (home-page "https://github.com/tox-dev/py-filelock")
    (synopsis "Platform independent file lock")
    (description "@code{filelock} contains a single module implementing
a platform independent file lock in Python, which provides a simple way of
inter-process communication.")
    (license license:unlicense)))

(define-public python-filelock-next
  (package
    (inherit python-filelock)
    (name "python-filelock")
    (version "3.20.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filelock" version))
       (sha256
        (base32 "1x0k9hrk8gr91hfb6ss6cwlq4p0pvi40nsg6skhl5gn69qxr87ki"))))
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-asyncio
           python-pytest-mock
           python-pytest-timeout))))

(define-public python-seedir
  (package
    (name "python-seedir")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "seedir" version))
       (sha256
        (base32 "1ibgzji9ijm37vgwmg37s2hsqmpqd793z4q41w816x5m6nahzy76"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-natsort))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/earnestt1234/seedir")
    (synopsis
     "Package for creating, editing, and reading folder tree diagrams.")
    (description
     "This is a package for creating, editing, and reading folder tree
diagrams.")
    (license license:expat)))

(define-public python-semantic-version
  (package
    (name "python-semantic-version")
    (version "2.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "semantic_version" version))
       (sha256
        (base32 "0704smz9k6hdd6i5xh0xf0sk47kannjb77abilvvp34r6v9vdaxx"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'custom
                     #:test-flags #~(list "-m" "nose2")))
    (native-inputs
     (list python-nose2
           python-setuptools))
    (home-page "https://github.com/rbarrois/python-semanticversion")
    (synopsis "Semantic versioning module for Python")
    (description
     "The @code{semantic_version} class is a small library for handling
@uref{https://semver.org/, semantic versioning} (@dfn{SemVer}) in Python.

It can compare versions, generate a new version that represents a bump in one
of the version levels, and check whether any given string is a proper semantic
version identifier.")
    (license license:bsd-3)))

(define-public python-serpent
  (package
    (name "python-serpent")
    (version "1.41")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/irmen/Serpent")
             (commit (string-append "serpent-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "081bm13pdxp3rxis24j2mjka06fzi4kap51wmnf21q69fsikbza8"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest
                     #:test-flags #~(list "discover" "-s" "tests")))
    (native-inputs
     (list python-attrs python-pytz python-setuptools))
    (home-page "https://github.com/irmen/Serpent")
    (synopsis "Serializer for literal Python expressions")
    (description
     "Serpent provides @code{ast.literal_eval()}-compatible object tree
serialization.  It serializes an object tree into bytes (an utf-8 encoded
string) that can be decoded and then passed as-is to @code{ast.literal_eval()}
to rebuild the original object tree.

Because only safe literals are encoded, it is safe to send serpent data to
other machines, such as over the network.")
    (license license:expat)))

(define-public python-setuptools-declarative-requirements
  (package
    (name "python-setuptools-declarative-requirements")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setuptools-declarative-requirements" version))
       (sha256
        (base32 "1xwqp37ii9kql49agmkipawjbndwxg6y8sxax1wc4l6kkaxvk9ap"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;requir dated inputs
    (native-inputs
     (list python-setuptools-scm))
    (propagated-inputs
     (list python-setuptools))
    (home-page "https://github.com/s0undt3ch/setuptools-declarative-requirements")
    (synopsis "File support for setuptools declarative setup.cfg")
    (description
     "This package provides file support for setuptools declarative
@code{setup.cfg}.")
    (license license:asl2.0)))

(define-public python-humanfriendly
  (package
    (name "python-humanfriendly")
    (version "8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "humanfriendly" version))
       (sha256
        (base32
         "04ixg8b7p6xc8x8lffhi7wfl77xhszakhd0s6j0cf6a84j8yqlmz"))))
    (build-system python-build-system)
    (arguments
     `(;; XXX: Tests depend on coloredlogs, which in turn depends on humanfriendly.
       #:tests? #f))
    (home-page "https://humanfriendly.readthedocs.io")
    (synopsis "Human-friendly input and output in Python")
    (description
     "The functions and classes in @code{humanfriendly} can be used to make
text interfaces more user-friendly.  It includes tools to parse and format
numbers, file sizes, and timespans, timers for long-running operations, menus
to allow the user to choose from a list of options, and terminal interaction
helpers.")
    (license license:expat)))

;; XXX: The project might be abandoned and this package has no users in Guix,
;; consider to remove if it keeps failing.
;; See: <https://github.com/ethanfurman/aenum/issues/45>,
;;      <https://github.com/ethanfurman/aenum/issues/44>,
;;      <https://github.com/ethanfurman/aenum/issues/27>.
(define-public python-aenum
  (package
    (name "python-aenum")
    (version "3.1.15")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "aenum" version))
       (sha256
        (base32 "0ncmbdblqhqyb2mg73d5663vx3q2xb9q8hmj77zp1y64336pdgcc"))
       (modules '((guix build utils)))
       (snippet
        ;; Delete the Python 2 specific files which won't compile
        ;; in Python 3.
        '(for-each delete-file (find-files "." "_py2.py$")))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These tests are defined in "aenum/test_v3.py" and require a function
      ;; "test_pickle_dump_load" from "aenum/test.py" which is not imported
      ;; into the module's scope.
      #~(list "-k" (string-join
                    (list "not test_pickle_enum_function_with_qualname"
                          "test_class_nested_enum_and_pickle_protocol_four"
                          "test_subclasses_with_getnewargs_ex")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tests
            (lambda _
              (substitute* "aenum/test_v3.py"
                ;; tempdir variable is not defined in the module.
                (("import tempfile.*")
                 (format #f "import tempfile~%tempdir = tempfile.mkdtemp()~%"))))))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/ethanfurman/aenum")
    (synopsis "Advanced enumerations, namedtuples and constants for Python")
    (description
     "The aenum library includes an @code{Enum} base class, a metaclass-based
@code{NamedTuple} implementation and a @code{NamedConstant} class.")
    (license license:bsd-3)))

(define-public python-calver
  (package
    (name "python-calver")
    (version "2022.06.26")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/di/calver")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14l9kv9igcmp5k6d2ahnx6z4dn6zy5kykz95hkh0rkqswn8x79b1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pretend
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/di/calver")
    (synopsis "Setuptools extension for CalVer package versions")
    (description
     "The calver package is a setuptools extension for automatically defining
your Python package version as a calendar version.")
    (license license:asl2.0)))

(define-public python-can
  (package
    (name "python-can")
    (version "4.6.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/hardbyte/python-can")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0i89hzc9n1h8i63wa333ahh5j1xqxq9v4ymcx7mcsg6ygji5wllr"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; TODO: Check if it could be packed:
         ;; https://github.com/projectgus/python-canalystii
         ;;
         ;; Disable tests which require specific CAN drivers we have no
         ;; package for in Guix.
         "--ignore=test/test_interface_canalystii.py"
         ;; These tests fail with "OSError: [Errno 19] No such device".
         "-k" "not BasicTestUdpMulticastBusIPv")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs (list python-packaging python-wrapt))
    (native-inputs
     (list ;; python-canalystii ; Not packed yet
           python-future
           python-hypothesis
           python-mock
           python-parameterized
           python-pyserial
           python-pytest
           python-pytest-cov
           python-pytest-timeout
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/hardbyte/python-can")
    (synopsis "Controller Area Network (CAN) interface module for Python")
    (description
     "This package defines the @code{can} module, which provides controller
area network (CAN) support for Python developers; providing common
abstractions to different hardware devices, and a suite of utilities for
sending and receiving messages on a CAN bus.")
    (license license:lgpl3+)))

(define-public python-canmatrix
  (package
    (name "python-canmatrix")
    (version "1.2")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/ebroecker/canmatrix")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05l0hi279y1dc8ifm2223lpn7z9dx2h7kk599bkymvasb2qa1xrx"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-pytest-timeout
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-attrs
           python-canopen
           python-click
           ;; python-ldfparser
           python-lxml
           python-openpyxl
           python-pyyaml
           python-xlrd
           python-xlwt))
    (home-page "https://github.com/ebroecker/canmatrix")
    (synopsis "@acronym{CAN, Controller Area Network} matrices in Python")
    (description
     "This package implements a @acronym{CAN, Controller Area Network} matrix
object in Python which describes the CAN-communication and its needed objects
such as board units, frames, signals, and values.  It also includes two
command-line tools (@command{canconvert} and @command{cancompare}) for
converting and comparing CAN databases.")
    (license license:bsd-2)))

(define-public python-canopen
  (package
    (name "python-canopen")
    (version "2.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/canopen-python/canopen")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vw6si83m4329p0k0q4b54gn1pindfzkmx6wxqy03bixd94bxw5y"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-can))
    (home-page "https://github.com/canopen-python/canopen")
    (synopsis "CANopen stack implementation")
    (description
     "This package provides a Python implementation of the
@uref{https://www.can-cia.org/canopen/,CANopen standard} for
@acronym{CANs, controller-area networks}.  The aim of the project is to
support the most common parts of the CiA 301 standard in a simple
Pythonic interface.  It is mainly targeted for testing and automation
tasks rather than a standard compliant master implementation.")
    (license license:expat)))

(define-public python-diskcache
  (package
    (name "python-diskcache")
    (version "5.6.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/grantjenks/python-diskcache")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0mird2yj3xbh71g325admxpif9h20w0xgp9hw6ss2bdbzxsykh6m"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; Ignore flaky tests.
         ;; AssertionError: assert None == 100
         "--deselect=tests/test_core.py::test_incr_update_keyerror")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'fix-pytest-config
            (lambda _
              (substitute* "tox.ini"
                ;; no python-pytest-xdist
                ((".*-n auto.*")
                 "")
                ;; no python-pytest-cov
                ((".*--cov.*")
                 "")))))))
    (native-inputs
     (list python-django
           python-matplotlib
           python-pytest
           python-setuptools))
    (home-page "https://www.grantjenks.com/docs/diskcache/")
    (synopsis "Disk and file backed cache library")
    (description "DiskCache is a disk and file backed persistent cache.")
    (license license:asl2.0)))

(define-public python-optparse-pretty
  (package
    (name "python-optparse-pretty")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "optparse-pretty" version))
       (sha256
        (base32 "1920wbh2b7a8qn7zx2iiqbcdaax335l81a73x9pp8h11yzs2jdmh"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;There are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/gvalkov/optparse-pretty")
    (synopsis "Compact help formatter for optparse")
    (description
     "This module provides two help formatters for optparse.  They provide
terser and more customizable option formatting in comparison to the default
help formatter.")
    (license license:bsd-3)))

(define-public python-orjson
  (package
    (name "python-orjson")
    (version "3.9.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "orjson" version))
              (sha256
               (base32
                "0hh1j7akxgx1nvsnwx1p4f4h4pkgr7v9aqr99l2pwbwfyyc93qw5"))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:imported-modules `(,@%cargo-build-system-modules
                           ,@%pyproject-build-system-modules)
      #:modules '((guix build cargo-build-system)
                  ((guix build pyproject-build-system) #:prefix py:)
                  (guix build utils))
      #:phases
      (with-extensions (list (pyproject-guile-json))
      #~(modify-phases %standard-phases
          (add-after 'build 'build-python-module
            (assoc-ref py:%standard-phases 'build))
          (add-after 'build-python-module 'install-python-module
            (assoc-ref py:%standard-phases 'install))))
      #:install-source? #false))
    (inputs
     (cons maturin (cargo-inputs 'python-orjson)))
    (native-inputs
     (list python-wrapper))
    (home-page "https://github.com/ijl/orjson")
    (synopsis "Python JSON library supporting dataclasses, datetimes, and numpy")
    (description "Orjson is a fast, correct JSON library for Python.  It
benchmarks as the fastest Python library for JSON and is more correct than the
standard @code{json} library or other third-party libraries.  It serializes
dataclass, datetime, numpy, and UUID instances natively.")
    ;; Either of these licenses
    (license (list license:asl2.0 license:expat))))

(define-public python-overrides
  (package
    (name "python-overrides")
    (version "7.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "overrides" version))
       (sha256
        (base32 "02l2j5pnsxn0q5i63is5g6i3q06ri83nf7lv55swr61vv6iqy5am"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/mkorpela/overrides")
    (synopsis "Decorator to detect mismatch when overriding a method")
    (description
     "This package provides a decorator to automatically detect mismatch when
overriding a method.")
    (license license:asl2.0)))

(define-public python-argparse-addons
  (package
    (name "python-argparse-addons")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argparse_addons" version))
       (sha256
        (base32 "1bv0nh8147bhjrjdr0m2fnmhxnl6bdni68wd61v7x206szfa08k3"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://github.com/eerimoq/argparse_addons")
    (synopsis "Extensions for Python's @code{argparse} library")
    (description "This Python library provides additional types and actions
for the standard @code{argparse} library.")
    (license license:expat)))

(define-public python-bitstruct
  (package
    (name "python-bitstruct")
    (version "8.21.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bitstruct" version))
       (sha256
        (base32 "1b2836hjc2bvnbjngfk9n0995zm3lz65apq7irlgijj5iabf82zz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/eerimoq/bitstruct")
    (synopsis "Python values to and C bit field structs converter")
    (description
     "This module performs conversions between Python values and C bit field
structs represented as Python byte strings.  It is intended to have a similar
interface as the @code{struct} module from Python, but working on bits instead
of primitive data types like @code{char}, @code{int}, etc.")
    (license license:expat)))

(define-public python-cantools
  (package
    (name "python-cantools")
    (version "40.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eerimoq/cantools")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ldqdsvkvy7vmplyiqcfqqwbh8v88ha98hgdrnlm09g4qbylh5d4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      ;; TODO: Build documentation, it's failing with error:
      ;; importlib.metadata.PackageNotFoundError: No package metadata was
      ;; found for cantools.
      ;; See: https://github.com/eerimoq/cantools/issues/190.
      #~(modify-phases %standard-phases
          (add-before 'build 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-freezegun
           python-parameterized
           python-pytest
           python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-argparse-addons
           python-bitstruct
           python-can
           python-crccheck
           python-diskcache
           python-matplotlib
           python-textparser))
    (home-page "https://github.com/eerimoq/cantools")
    (synopsis "Tools for the Controller Area Network (CAN) bus protocol")
    (description
     "This package includes Controller Area Network (CAN) related tools that
can be used to:
@itemize
@item parse DBC, KCD, SYM, ARXML 4 and CDD files
@item encode and decode CAN messages
@item multiplex simple and extended signals
@item diagnose DID encoding and decoding
@item dump the CAN decoder output
@item test CAN nodes
@item generate C source code
@item monitor the CAN bus
@end itemize")
    (license license:expat)))

(define-public python-capturer
  (package
    (name "python-capturer")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "capturer" version))
       (sha256
        (base32
         "05d6ji4j8ipiq0br7bwam38qc6hd9l1djmfxlzrxx19ziyjl4089"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (propagated-inputs
     (list python-humanfriendly))
    (home-page "https://capturer.readthedocs.io")
    (synopsis "Capture stdout and stderr streams of the current process")
    (description
     "The capturer package makes it easy to capture the stdout and stderr
streams of the current process and subprocesses.  Output can be relayed
to the terminal in real time but is also available to the Python program
for additional processing.")
    (license license:expat)))

(define-public python-fastprogress
  (package
    (name "python-fastprogress")
    (version "1.0.3")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/fastai/fastprogress")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "01h8f786wgmmd3fj98wk1n5id67nsp19gs8bbgims04aciwhvj21"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f                  ;there are no tests
           #:phases #~(modify-phases %standard-phases
                        ;; XXX: Fails with: "In procedure utime: No such file
                        ;; or directory".
                        (delete 'ensure-no-mtimes-pre-1980))))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/fastai/fastprogress")
    (synopsis "Progress bar for Jupyter Notebook and console")
    (description
     "Fastprogress is a progress bar for Jupyter Notebook and console.")
    (license license:asl2.0)))

(define-public python-coloredlogs
  (package
    (name "python-coloredlogs")
    (version "10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "coloredlogs" version))
       (sha256
        (base32
         "0dkw6xp0r1dwgz4s2f58npx5nxfq51wf4l6qkm5ib27slgfs4sdq"))))
    (build-system python-build-system)
    (arguments
     `(;Tests require some updated modules
       #:tests? #f))
    (propagated-inputs
     (list python-capturer))
    (home-page "https://coloredlogs.readthedocs.io")
    (synopsis "Colored stream handler for Python's logging module")
    (description
     "The @code{coloredlogs} package enables colored terminal output for
Python's logging module.  The @code{ColoredFormatter} class inherits from
@code{logging.Formatter} and uses ANSI escape sequences to render your logging
messages in color.")
    (license license:expat)))

(define-public python-editorconfig
  (package
    (name "python-editorconfig")
    (version "0.17.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/editorconfig/editorconfig-core-py")
              (commit (string-append "v" version))
              (recursive? #t)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "107lh5pds1iwgb2q1da2k7g5vs6w0rk84679k6yi8a01agc1c0fz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda _
              (setenv "PYTHONPATH" (getenv "GUIX_PYTHONPATH"))
              (invoke "cmake" ".")
              (invoke "ctest" "."))))))
    (native-inputs (list cmake python-setuptools python-wheel))
    (home-page "https://editorconfig.org/")
    (synopsis "EditorConfig bindings for python")
    (description "The EditorConfig project consists of a file format for
defining coding styles and a collection of text editor plugins that enable
editors to read the file format and adhere to defined styles.  EditorConfig
files are easily readable and they work nicely with version control systems.")
    ;; "fnmatch.py" and "ini.py" are licensed under psfl, the rest is bsd-2.
    (license (list license:bsd-2 license:psfl))))

(define-public dosage
  (package
    (name "dosage")
    (version "3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dosage" version))
       (sha256
        (base32
         "0hi5rl17rj9gay7yw7ikrkyp5qhyw5bzp4ig1sj6ahzclsia8y1h"))))
    (build-system pyproject-build-system)
    (arguments
     ;; It requres additional modules for integration tests.
     (list #:test-flags #~(list "--ignore=tests/modules/")))
    (native-inputs
     (list python-pytest
           python-responses
           python-setuptools
           python-setuptools-scm))
    (inputs
     (list python-imagesize
           python-importlib-resources
           python-lxml
           python-platformdirs
           python-requests
           python-rich))
    (home-page "https://github.com/webcomics/dosage")
    (synopsis "Comic strip downloader and archiver")
    (description
     "Dosage is designed to keep a local copy of specific webcomics and other
picture-based content such as Picture of the Day sites.  With the
@command{dosage} command-line script you can get the latest strip of a
webcomic, catch-up to the last strip downloaded, or download a strip for a
particular date or index, if possible.")
    (license license:expat)))

(define-public python-etcd3
  (package
    (name "python-etcd3")
    (version "0.12.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/kragniz/python-etcd3")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06hw0kcl77v8px5w2hfnf2l9gjnjrspjb49kx3jqa382z7wzdkk0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: Tests require the etcd package.
      #:tests? #f
      #:test-backend #~'custom
      #:test-flags                      ; Taken from tox.ini.
      #~(list "pifpaf" "-e" "python" "run" "etcd" "--cluster" "--" "pytest")))
    (propagated-inputs (list python-grpcio python-protobuf python-tenacity))
    (native-inputs (list python-mock python-pifpaf python-pytest python-setuptools))
    (home-page "https://github.com/kragniz/python-etcd3")
    (synopsis "Python client for the etcd3 API")
    (description
     "This package provide a Python client for the @code{etcd3} API.")
    (license license:asl2.0)))

(define-public python-et-xmlfile
  (package
    (name "python-et-xmlfile")
    (version "2.0.0")
    (source
     (origin
       ;; Use a checkout because the PyPI archive does not contain tests.
       (method hg-fetch)
       (uri (hg-reference
             (url "https://foss.heptapod.net/openpyxl/et_xmlfile")
             (changeset version)))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "03pmmg6k2ajd83zhki8f0c1ndi7pq23bj9hm6f8hhd07maqksf5w"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-lxml
           python-setuptools))
    (home-page "https://bitbucket.org/openpyxl/et_xmlfile")
    (synopsis "Low memory implementation of @code{lxml.xmlfile}")
    (description "This Python library is based upon the @code{xmlfile} module
from @code{lxml}.  It aims to provide a low memory, compatible implementation
of @code{xmlfile}.")
    (license license:expat)))

(define-public python-omero-py
  (let ((omero-blitz-version "5.8.2"))
    (package
      (name "python-omero-py")
      (version "5.20.0")
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/ome/omero-py")
               (commit (string-append "v" version))))
         (file-name (git-file-name name version))
         (sha256
          (base32 "02zsw1p35n6lkqh410qpgw7c4467dkbg0hxly3gjqrwdh349j47g"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        ;; #:tests? #f
        #:test-flags
        #~(list
           "-m" "not broken" "-rf" "test" "-s"
           ;; XXX: Failing collection because of Numpy compatibility.
           "--ignore=test/unit/tablestest/test_hdfstorage.py"
           "--ignore=test/unit/tablestest/test_servants.py"
           ;; TestImport tries to download Java things; TestSessions
           ;; and TestBuildQuery require networking.
           "-k" "not TestImport and not TestSessions and not TestBuildQuery")
        #:modules '((guix build pyproject-build-system)
                    (guix build utils)
                    (ice-9 match)
                    (srfi srfi-1)
                    (srfi srfi-26))
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'find-artifacts
              (lambda* (#:key inputs #:allow-other-keys)
                (let ((zip-file
                       (match inputs
                         (((labels . files) ...)
                          (find (cut string-suffix?
                                     (string-append "omero-blitz-"
                                                    #$omero-blitz-version
                                                    "-python.zip")
                                     <>)
                                files)))))
                  (setenv "ZIP_FILE"
                          (or zip-file (error "failed to find artifact file"))))))
            ;; Some tests need this, such as TestTempFileManager
            (add-after 'build 'set-HOME
              (lambda _ (setenv "HOME" "/tmp")))
            ;; The sanity check mistakes omero_model_TypeAnnotationI.py for a
            ;; module to load.
            (delete 'sanity-check)
            ;; The argument parser is picky and interprets the "-real" part as
            ;; the first argument.
            (add-after 'wrap 'rename-executable
              (lambda _
                (with-directory-excursion (string-append #$output "/bin")
                  (rename-file ".omero-real" ".omero")
                  (substitute* "omero"
                    (("bin/.omero-real") "bin/.omero"))))))))
      (propagated-inputs
       (list python-appdirs
             python-future
             python-numpy-2
             python-pillow
             python-pyyaml
             python-requests
             python-tables
             python-zeroc-ice-3.6))
      (native-inputs
       (list python-portalocker
             python-pytest
             python-pytest-mock
             python-pytest-rerunfailures
             python-pytest-xdist
             python-setuptools
             python-wheel
             unzip
             (origin
               (method url-fetch)
               (uri (format #f "\
https://artifacts.openmicroscopy.org/artifactory/ome.releases/org/\
openmicroscopy/omero-blitz/~a/omero-blitz-~a-python.zip"
                            omero-blitz-version
                            omero-blitz-version))
               (sha256
                (base32 "1nb17xmx6n7i5vkcw661iq42yfgc3i0gmhz3x8iwcrhp8pajzm3l")))))
      (home-page "https://github.com/ome/omero-py")
      (synopsis "Python bindings to the OMERO.blitz server")
      (description "This package provides Python bindings to the OMERO.blitz
server.")
      (license license:gpl2))))

(define-public python-openpyxl
  (package
    (name "python-openpyxl")
    (version "3.1.5")
    (source
     (origin
       ;; We use the upstream repository, as the tests are not included in the
       ;; PyPI releases.
       (method hg-fetch)
       (uri (hg-reference
              (url "https://foss.heptapod.net/openpyxl/openpyxl")
              (changeset version)))
       (file-name (string-append name "-" version "-checkout"))
       (sha256
        (base32 "17z6rrvv3q1axy9r13c2hln2pazfn9n5bhkzrbjcjakgbfjl6mss"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-lxml-4.9
           python-pillow
           python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-et-xmlfile))
    (home-page "https://openpyxl.readthedocs.io")
    (synopsis "Python library to read/write Excel 2010 XLSX/XLSM files")
    (description
     "This Python library allows reading and writing to the Excel XLSX, XLSM,
XLTX and XLTM file formats that are defined by the Office Open XML (OOXML)
standard.")
    (license license:expat)))

(define-public python-sinfo
  (package
    (name "python-sinfo")
    (version "0.3.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "sinfo" version))
              (sha256
               (base32
                "0kdsp883mx0lfyykv0p12bvs203kdm3skb8bw5wf2pc7kb393sl1"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; no tests in PyPI or Git
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-stdlib-list))
    (home-page "https://gitlab.com/joelostblom/session_info")
    (synopsis "Output module version information loaded in a Python session")
    (description "This package outputs version information for modules loaded
in the current session, Python, and the OS.")
    (license license:bsd-3)))

(define-public python-six
  (package
    (name "python-six")
    (version "1.17.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "six" version))
       (sha256
        (base32 "109ajcsfhrz33lbwbb337w34crc3lb9rjnxrcpnbczlf8rfk6w7z"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest-bootstrap
           python-setuptools
           python-wheel))
    (home-page "https://pypi.org/project/six/")
    (synopsis "Python 2 and 3 compatibility utilities")
    (description
     "Six is a Python 2 and 3 compatibility library.  It provides utility
functions for smoothing over the differences between the Python versions with
the goal of writing Python code that is compatible on both Python versions.
Six supports every Python version since 2.5.  It is contained in only one
Python file, so it can be easily copied into your project.")
    (license license:x11)))

(define-public python-six-bootstrap python-six)

(define-public python-schedule
  (package
    (name "python-schedule")
    (version "1.2.2")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "schedule" version))
      (sha256
       (base32
        "1dzhwpnpbvv90z6lavx4z7whh1a2y47cq69zgxibknazzrsrrzhm"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/dbader/schedule")
    (synopsis "Schedule periodic function calls in Python")
    (description
     "Schedule is an in-process scheduler for periodic jobs that uses the
builder pattern for configuration.  Schedule lets you run Python functions (or
any other callable) periodically at pre-determined intervals using a simple,
human-friendly syntax.")
    (license license:expat)))

;; XXX: This project is unmaintained since 2020, see:
;; <https://github.com/scour-project/scour/issues/321>.
;;
;; The only user is Inkscape, see:
;; <https://gitlab.com/inkscape/inkscape-docs/documentation/-/issues/43>.
(define-public python-scour
  (package
    (name "python-scour")
    (version "0.38.2")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
          (url "https://gitlab.com/inkscape/extras/scour")
          (commit
           (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mmfvx4wqp8gkpv0kbih89zfs9njvmd3v4dxfqii62xddpxq0f1k"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'custom
           #:test-flags #~(list "test_scour.py")))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-six))
    (home-page "https://gitlab.com/inkscape/extras/scour")
    (synopsis "Scour is an SVG optimizer/cleaner written in Python")
    (description
     "The goal of Scour is to output a file that renders identically at a
fraction of the size by removing a lot of redundant information created by
most SVG editors.  Optimization options are typically lossless but can be
tweaked for more aggressive cleaning.")
    (license license:asl2.0)))

(define-public python-mechanize
  (package
    (name "python-mechanize")
    (version "0.4.10")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "mechanize" version))
      (sha256
       (base32 "1pvxjnhqi6iq7nnjksnfvyzxcibbwfjc9fzp22v0msp7kdzr9shx"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: Unclear why tests are failing.
     (list #:tests? #f
           #:phases
           #~(modify-phases %standard-phases
               (add-before 'check 'configure-tests
                 (lambda _
                   (setenv "GUIX_PYTHONPATH"
                           (string-append (getcwd) "/test-tools:"
                                          (getenv "GUIX_PYTHONPATH"))))))))
    (native-inputs
     (list python-html5-parser
           python-html5lib
           python-lxml
           python-service-identity
           python-setuptools
           python-six
           python-twisted
           python-wheel))
    (propagated-inputs
     (list python-html5lib))
    (home-page "https://github.com/python-mechanize/mechanize")
    (synopsis
     "Stateful programmatic web browsing in Python")
    (description
     "Mechanize implements stateful programmatic web browsing in Python,
after Andy Lester’s Perl module WWW::Mechanize.")
    (license license:bsd-3)))

(define-public python-mediapy
  (package
    (name "python-mediapy")
    (version "1.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/google/mediapy")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08dj0h7xkpaj552pzjln1chshxsfxbwhv29p2npsmscy907s322l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-references
           (lambda _
             (substitute* "mediapy_test.py"
               (("'/bin/bash")
                (string-append "'" (which "bash")))))))))
    (inputs (list ffmpeg-5))
    (propagated-inputs (list python-absl-py
                             python-ipython
                             python-matplotlib
                             python-numpy
                             python-pillow))
    (native-inputs
     (list python-flit-core
           python-pylint
           python-pytest
           python-pytest-xdist))
    (home-page "https://github.com/google/mediapy")
    (synopsis "Read/write/show images and videos in an IPython notebook")
    (description "This Python library makes it easy to display images and
videos in a notebook.")
    (license license:asl2.0)))

(define-public python-simpleaudio
  (package
    (name "python-simpleaudio")
    (version "1.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simpleaudio" version))
       (sha256
        (base32
         "07glihg0fpca0gvbbvqs9q815w8xhflzdvg72yvlsm23j9j8h739"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))
    (inputs
      (list alsa-lib))
    (home-page
     "https://github.com/hamiltron/py-simple-audio")
    (synopsis "Simple, asynchronous audio playback for Python 3")
    (description
     "The @code{simplaudio} package provides cross-platform, dependency-free
audio playback capability for Python 3 on OSX, Windows, and Linux.")
    (license license:expat))) ; MIT license

(define-public python-jsonalias
  (package
    (name "python-jsonalias")
    (version "0.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonalias" version))
              (sha256
               (base32
                "0k5c2132hbd9wxnj8w05vvpi286l3g3ksw350m85rd0k9958g5z3"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; no tests in PyPI or Git
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/kevinheavey/jsonalias/")
    (synopsis "JSON type alias for Python")
    (description
     "This package provides a microlibrary that defines a JSON type alias for
Python.")
    (license license:expat)))

(define-public python-jsonargparse
  (package
    (name "python-jsonargparse")
    (version "4.37.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonargparse" version))
              (sha256
               (base32
                "1b9w9j27phj5j00pmhp11lzf53yc4dnwknhxacv2bfyiiaq0af2s"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           '(list "-k" "not test_env_prefix")))
    (propagated-inputs
     (list python-pyyaml))
    (native-inputs
     (list python-attrs
           python-pypa-build
           python-pydantic
           python-pytest
           python-pytest-subtests
           python-responses
           python-setuptools
           python-wheel))
    (home-page "https://github.com/omni-us/jsonargparse/")
    (synopsis "Implement minimal boilerplate CLIs derived from type hints")
    (description
     "This package lets you implement minimal boilerplate CLIs derived from
type hints and parse from command line, config files and environment
variables.")
    (license license:expat)))

(define-public python-pymarshal
  (package
    (name "python-pymarshal")
    (version "2.2.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pymarshal" version))
              (sha256
               (base32
                "1lhb7yim60pvclbd440zd4n50xs1d2rvmnrhhvib3hyv0dxil5j3"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Test fails with this error:
     ;; "CovReportWarning: Failed to generate report: No data to report."
     (list #:tests? #f))
    (native-inputs
     (list python-pytest python-pytest-cov python-setuptools python-wheel))
    (propagated-inputs (list python-bson python-pyyaml))
    (home-page "https://gitlab.com/d3v-t00lz/pymarshal")
    (synopsis "Pythonic implementation of Golang struct (un)marshalling")
    (description "PyMarshal replicates the feature of (un)marshalling structs
in Golang.")
    (license license:bsd-2)))

(define-public python-simplejson
  (package
    (name "python-simplejson")
    (version "3.20.1")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "simplejson" version))
      (sha256
       (base32
        "0z838dqnh5c81ib6cvfqfhd82ax2apzclzgz8b0j87sgxjs3jhg6"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://simplejson.readthedocs.io/en/latest")
    (synopsis
     "Json library for Python")
    (description
     "JSON (JavaScript Object Notation) is a subset of JavaScript
syntax (ECMA-262 3rd edition) used as a lightweight data interchange
format.

Simplejson exposes an API familiar to users of the standard library marshal
and pickle modules.  It is the externally maintained version of the json
library contained in Python 2.6, but maintains compatibility with Python 2.5
and (currently) has significant performance advantages, even without using
the optional C extension for speedups.  Simplejson is also supported on
Python 3.3+.")
    (license license:x11)))

(define-public python-simple-rlp
  (package
    (name "python-simple-rlp")
    (version "0.1.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/SamuelHaidu/simple-rlp")
             ;; Upstream doesn't tag the git repo.
             (commit "342ea269d84da1ddc4a7630cdebc90159261391c")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1nv92sphpkyrncak4qgj50qmgkmj4ycl2szbnv9c7ihgl5df4div"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list
      python-pytest
      python-setuptools))
    (home-page "https://github.com/SamuelHaidu/simple-rlp")
    (synopsis
     "Python implementation of RLP (Recursive Length Prefix) encoding")
    (description
     "@code{simple-rlp} is a python implementation of RLP (Recursive Length \
Prefix) - Encode and decode data structures.")
    (license license:expat)))

(define-public python-pyicu
  (package
    (name "python-pyicu")
    (version "2.15.2")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "pyicu" version))
      (sha256
       (base32 "13srrv5lczr0s74hx2kffwdhfg6flpvi2qpj75lfqz7ivzp7f7jn"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list pkg-config
           python-pytest
           python-setuptools
           python-six))
    (inputs
     (list icu4c))
    (home-page "https://gitlab.pyicu.org/main/pyicu")
    (synopsis "Python extension wrapping the ICU C++ API")
    (description
     "PyICU is a python extension wrapping the ICU C++ API.")
    (license license:x11)))

(define-public python-dogtail
  (package
    (name "python-dogtail")
    (version "0.9.11")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://gitlab.com/dogtail/dogtail/-/raw/released/" "dogtail-"
             version ".tar.gz"))
       (sha256
        (base32 "0sr38z7b2n12bvfd4xw4b5dnnhkn5zl3h0ymmnnzavcihfqia6l0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ;TODO Launching dbus for the tests fails
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (system "Xvfb :1 &")
                (setenv "DISPLAY" ":1")
                (invoke "dbus-run-session" "--"
                        "nosetests" "-v" "tests/")))))))
    (propagated-inputs (list python-pygobject python-pycairo python-pyatspi))
    (native-inputs
     (list python-pynose
           gtk+
           xorg-server-for-tests
           dbus
           gsettings-desktop-schemas
           gobject-introspection
           python-setuptools))
    (home-page "https://gitlab.com/dogtail/dogtail/")
    (synopsis "GUI test tool and automation framework written in Python")
    (description
     "Dogtail is a GUI test tool and automation framework written in Python.
It uses Accessibility (a11y) technologies to communicate with desktop
applications. dogtail scripts are written in Python and executed like any
other Python program.")
    (license license:gpl2+)))

(define-public python-doxyqml
  (package
    (name "python-doxyqml")
    (version "0.5.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "doxyqml" version))
              (sha256
               (base32
                "0skrs5i5pvpzvihgxw766zi1c9bbp33aisdldxgj470mlchvdgyy"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'custom
           #:test-flags #~(list "tests/functional/tests.py")))
    (native-inputs
     (list python-setuptools))
    (home-page "https://agateau.com/projects/doxyqml")
    (synopsis "Doxygen input filter for QML files")
    (description
     "This package provides a Doxygen input filter for QML files.")
    (license license:bsd-3)))

(define-public python-doxypypy
  (package
    (name "python-doxypypy")
    (version "0.8.8.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "doxypypy" version))
              (sha256
               (base32
                "17nh5jjbxrg6ag0gymh8jsp75qnxwgv8fqbj4jlphywj0sxwh6k7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; Test files are not in UTF-8 format and attmet to
                    ;; substitute shebang fails, while tests fail with error:
                    ;; AssertionError: "#!/bin/env python\n# UTF-32-LE Python
                    ;; File w[387 chars]g.')" !=
                    ;; "#!/gnu/store/y5vz9h983i8cg01cxz0zdywz715fxxs[449
                    ;; chars]g.')"
                    (list "not test_utf16be_bom"
                          "test_utf16le_bom"
                          "test_utf32be_bom"
                          "test_utf32le_bom"
                          "test_utf8_bom")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          ;; compile-bytecode phases fails with error: SyntaxError: source
          ;; code string cannot contain null bytes.
          (add-after 'unpack 'fix-setup.py
            (lambda _
              (substitute* "setup.py"
                (("packages=.*") "packages=['doxypypy'],\n")))))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-chardet))
    (home-page "https://github.com/Feneric/doxypypy")
    (synopsis "Doxygen filter for Python")
    (description
     "This package provides a Doxygen filter for Python.")
    (license license:gpl2+)))

(define-public python-empy
  (package
    (name "python-empy")
    (version "3.3.3")
    (source (origin
             (method url-fetch)
             (uri (string-append "http://www.alcyone.com/software/empy/empy-"
                                 version ".tar.gz"))
             (sha256
              (base32
               "1mxfy5mgp473ga1pgz2nvm8ds6z4g3hdky8523z6jzvcs9ny6hcq"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f))                    ; python2 only
    (home-page "http://www.alcyone.com/software/empy/")
    (synopsis "Templating system for Python")
    (description
     "EmPy is a system for embedding Python expressions and statements in
template text; it takes an EmPy source file, processes it, and produces
output.  This is accomplished via expansions, which are special signals to the
EmPy system and are set off by a special prefix (by default the at sign, @@).
EmPy can expand arbitrary Python expressions and statements in this way, as
well as a variety of special forms.  Textual data not explicitly delimited in
this way is sent unaffected to the output, allowing Python to be used in
effect as a markup language.  Also supported are callbacks via hooks,
recording and playback via diversions, and dynamic, chainable filters.  The
system is highly configurable via command line options and embedded
commands.")
    (license license:lgpl2.1+)))

(define-public python-palettable
  (package
    (name "python-palettable")
    (version "3.3.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "palettable" version))
              (sha256
               (base32
                "1a4h0jpsr3wjciqg9a5kslxv65d3qqgmqgkpai4cl77wlpcxfk89"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://jiffyclub.github.io/palettable/")
    (synopsis "Color palettes for Python")
    (description "Palettable (formerly brewer2mpl) is a library of color
palettes for Python.  It’s written in pure Python with no dependencies, but it
can supply color maps for matplotlib.  You can use Palettable to customize
matplotlib plots or supply colors for a web application.")
    (license license:expat)))

(define-public python-parse-type
  (package
    (name "python-parse-type")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "parse_type" version))
       (sha256
        (base32
         "07smqnzc9km7sbvxfyx4gdm9njrx58x8grdw6gs4gva81rk3rd10"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-html
           python-setuptools
           python-wheel))
    (propagated-inputs (list python-six python-parse))
    (home-page "https://github.com/jenisys/parse_type")
    (synopsis "Extended parse module")
    (description "Parse_type extends the python parse module.")
    (license license:bsd-3)))

(define-public python-parse
  (package
    (name "python-parse")
    (version "1.18.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "parse" version))
      (sha256
       (base32
        "19063x4xdjpaf7rfxai6jpgm2k4yvkq7wha8aa8cagbjsqr60rli"))))
    (build-system python-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "python" "test_parse.py"))))))
    (home-page "https://github.com/r1chardj0n3s/parse")
    (synopsis "Parse strings")
    (description
     "Parse strings using a specification based on the Python @code{format()}
syntax.")
    (license license:x11)))

(define-public python-parsley
  (package
    (name "python-parsley")
    (version "1.3")
    (source (origin
              ;; The source distributed on PyPI is outdated.
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/pyga/parsley")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0550rw65ygqzbjc8a66hs355pzbx727kbn20dssdb6ls846gw2qs"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "ometa/test" "terml/test")))
    (native-inputs
     (list python-pytest
           python-twisted
           python-setuptools
           python-wheel))
    (home-page "https://launchpad.net/parsley")
    (synopsis "Parsing and pattern matching Python library")
    (description
     "Parsley is a parsing library using PEG algorithm, so each expression in
the grammar rules works like a Python expression.  In particular, alternatives
are evaluated in order, unlike table-driven parsers such as yacc, bison or PLY.
Parsley is an implementation of OMeta, an object-oriented pattern-matching
language.")
    (license license:expat)))

(define-public python-petl
  (package
    (name "python-petl")
    (version "1.7.16")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "petl" version))
       (sha256
        (base32 "0ll7xcc9yrvrz9p9im6m8p69cwrqwmqx91px43hlbnjrv1jflbww"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-setuptools-scm python-wheel
                         python-pytest))
    (home-page "https://github.com/petl-developers/petl")
    (synopsis "Framework for writing @acronym{ETL, Extract Transform Load} data
processing pipelines.")
    (description
     "This package provides a library for extracting, transforming and loading
tables of data.  It can read from and write to databases or files in multiple
formats, including:
@itemize @bullet
@item python objects
@item delimited files
@item pickle files
@item text/XML/JSON/HTML files
@item python I/O streams
@item Excel XLS/XLSX files
@item HDF5 files
@end itemize")
    (license license:expat)))

(define-public python-polib
  (package
    (name "python-polib")
    (version "1.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "polib" version))
               (sha256
                (base32
                  "0aikb8gcarhifn3sadrbbs5czagih9hjv250gsrgy9v1d49pvn7s"))))
    (build-system python-build-system)
    (native-inputs (list python-setuptools-67))
    (home-page "https://bitbucket.org/izi/polib/wiki/Home")
    (synopsis "Manipulate, create and modify gettext files")
    (description "Polib can manipulate any gettext format (po, pot and mo)
files.  It can be used to create po files from scratch or to modify
existing ones.")
    (license license:expat)))

(define-public python-polling2
  (package
    (name "python-polling2")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "polling2" version))
       (sha256
        (base32 "0hp3238fv6k1qk43gv4jwnv1mwlkmx33akbj560b9nvsry1dmdwh"))))
    (build-system python-build-system)
    (arguments '(#:tests? #false)) ; no tests included
    (native-inputs
     (list python-mock python-pytest python-pytest-runner))
    (home-page "https://github.com/ddmee/polling2")
    (synopsis "Polling utility with many configurable options")
    (description "Polling2 is a utility used to wait for a function to return
a certain expected condition.")
    (license license:expat)))

(define-public python-pomegranate
  (package
    (name "python-pomegranate")
    (version "0.14.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pomegranate" version))
              (sha256
               (base32
                "0gb9srkbxzlkjyfizvxkw5y0bvnfcyiaxapz0hrdaba8j096b5i2"))
              (modules '((guix build utils)))
              ;; Delete generated Cython C files.
              (snippet
               '(for-each delete-file (find-files "." "\\.c$")))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: Update to python@3.11 broke some python-nose functionality.
      ;; Tests are broken but the package itself is most likely fine.
      #:tests? #f))
    (propagated-inputs
     (list python-joblib
           python-networkx
           python-numpy
           python-pyyaml
           python-scipy))
    (native-inputs
     (list python-cython
           python-pandas
           python-setuptools
           python-wheel))
    (home-page "https://pypi.python.org/pypi/pomegranate/")
    (synopsis "Graphical models library for Python")
    (description
     "Pomegranate is a graphical models library for Python, implemented in
Cython for speed.")
    (license license:expat)))

(define-public python-daft
  (package
    (name "python-daft")
    (version "0.1.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "daft" version))
              (sha256
               (base32
                "1r8jsfavd624q2q61f863lk6has6mv5csswh39saafd5khwf0xry"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k"
             (string-append
               ;; The following tests compare matplotlib output with
               ;; previously generated images.  They fail due to minor
               ;; differences in where matplotlib places labels.
               "not test_bca[png]"
               " and not test_classic[png]"
               " and not test_deconvolution[png]"
               " and not test_exoplanets[png]"
               " and not test_fixed[png]"
               " and not test_gaia[png]"
               " and not test_galex[png]"
               " and not test_huey_p_newton[png]"
               " and not test_logo[png]"
               " and not test_no_circles[png]"
               " and not test_no_gray[png]"
               " and not test_recursive[png]"
               " and not test_thick_lines[png]"
               " and not test_weaklensing[png]"
               " and not test_wordy[png]"))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs (list python-matplotlib python-numpy))
    (home-page "https://docs.daft-pgm.org/")
    (synopsis "PGM rendering library")
    (description "Daft is a Python package that uses matplotlib to
render pixel-perfect probabilistic graphical models for publication in
a journal or on the internet.  With a short Python script and an
intuitive model-building syntax you can design directed (Bayesian
Networks, directed acyclic graphs) and undirected (Markov random fields)
models and save them in any formats that matplotlib supports (including
PDF, PNG, EPS and SVG).")
    (license license:expat)))

(define-public python-portalocker
  (package
    (name "python-portalocker")
    (version "2.7.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "portalocker" version))
              (sha256
               (base32
                "0lawjm736vs86wlnxc3qqh37l11z0yx81xq3dmrw33m86kaq2bh3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest
                         python-pytest-cov
                         python-pytest-mypy
                         python-pytest-timeout
                         python-redis
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/WoLpH/portalocker")
    (synopsis "Python library for file locking")
    (description "Portalocker is a library to provide an easy API to file
locking..")
    (license license:bsd-3)))

(define-public python-poyo
  (package
    (name "python-poyo")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "poyo" version))
       (sha256
        (base32
         "1pflivs6j22frz0v3dqxnvc8yb8fb52g11lqr88z0i8cg2m5csg2"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://github.com/hackebrot/poyo")
    (synopsis "Lightweight YAML Parser for Python")
    (description
     "This package provides a lightweight YAML Parser for Python.  It supports
only a chosen subset of the YAML format that is required to parse cookiecutter
user configuration files.  It does not have support for serializing into YAML
and is not compatible with JSON.")
    (license license:expat)))

(define-public python-expandvars
  (package
    (name "python-expandvars")
    (version "0.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "expandvars" version))
       (sha256
        (base32 "0i6q4i8dzsax85w1l2hc7saymyh3fw43vkifh5flpkr8ayjxy6kx"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling python-pytest))
    (home-page "https://pypi.org/project/expandvars/")
    (synopsis "Expand system variables Unix style")
    (description "This module is inspired by GNU bash's variable expansion
features.  It can be used as an alternative to Python's
@code{os.path.expandvars} function.  A good use case is reading config files
with the flexibility of reading values from environment variables using
advanced features like returning a default value if some variable is not
defined.")
    (license license:expat)))

(define-public python-extension-helpers
  (package
    (name "python-extension-helpers")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch) ; no tests in the PyPI tarball
       (uri (git-reference
              (url "https://github.com/astropy/extension-helpers")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ljvfv9p7jay4j31awx1h714xhyn5hbfgyhn4nm71xrkz9la113j"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--pyargs" "extension_helpers"
              "-k" (string-join
                    ;; XXX: Tests try to check various compilation options and
                    ;; fail with some incomparability or trying to download
                    ;; missing modules.
                    (list "not test_only_pyproject"
                          "test_no_setup_py"
                          "test_limited_api")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          ;; LookupError: setuptools-scm was unable to detect version for
          ;; /tmp/guix-build-python-extension-helpers-1.2.0.drv-0/source.
          (add-before 'build 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-pytest
           python-setuptools-scm))
    (propagated-inputs
     (list python-setuptools))
    (home-page "https://extension-helpers.readthedocs.io")
    (synopsis "Astropy ecosystem utilities for building and installing packages")
    (description
     "The extension-helpers package includes convenience helpers to assist
with building Python packages with compiled C/Cython extensions.  It is
developed by the Astropy project but is intended to be general and usable by
any Python package.")
    (license license:bsd-3)))

(define-public python-milc
  (package
    (name "python-milc")
    (version "1.9.1")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
              (url "https://github.com/clueboard/milc")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ms9ks0xn1ikd48352bifnbfahfnw3gh4qs1ckmmwbpiq2czca3g"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-semver
           python-setuptools))
    (propagated-inputs
     (list python-argcomplete
           python-colorama
           python-halo
           python-platformdirs
           python-spinners
           python-types-colorama))
    (home-page "https://github.com/clueboard/milc")
    (synopsis "Python library for command line interface programs")
    (description "MILC is a Python library for developing command line
interface programs.  This library provides features to parse arguments,
automatic tab-completion, color support, logging to @code{std}, etc.")
    (license license:expat)))

(define-public python-extract-dtb
  (package
    (name "python-extract-dtb")
    (version "1.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/PabloCastellano/extract-dtb/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1kkfy8sh6bhh1w5lczaw1nym278q5xp5pxjaahwrl3zfddhdm655"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))                ;no tests
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/PabloCastellano/extract-dtb/")
    (synopsis "Extract device tree blobs (DTB) from kernel images")
    (description
     "This package provides a tool to split a kernel image with appended
@acronym{DTB, Device Tree Blobs} into separated kernel and DTB files.")
    (license license:gpl3+)))

(define-public python-mimeparse
  (package
    (name "python-mimeparse")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python_mimeparse" version))
       (sha256
        (base32 "00xk5jir6dm4r3qm8dg8vh8lhq00f35zaryn3gina958gb7rv6jv"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/falconry/python-mimeparse")
    (synopsis "Python library for parsing MIME types")
    (description
     "Mimeparse provides basic functions for parsing MIME type names and
matching them against a list of media-ranges.")
    (license license:expat)))

(define-public python-miniboa
  (package
    (name "python-miniboa")
    (version "1.0.9")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/shmup/miniboa")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "05xa44x61bia2pxjdncz6rj10js8hgp2a9hf56avbfk7g58n3v5y"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/shmup/miniboa")
    (synopsis "Simple, single-threaded Telnet server")
    (description
     "Miniboa is a simple, asynchronous, single-threaded, poll-based Telnet
server.")
    (license license:asl2.0)))

(define-public python-mir-eval
  (package
    (name "python-mir-eval")
    (version "0.8.2")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/mir-evaluation/mir_eval")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0mna57q2r0cjsvgz67v6bay1c6a33wl33yna9s083wfqhjmf9bqf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'cd-tests
            (lambda _
              ;; Move to 'tests' directory because tests read data files from
              ;; a relative path.
              (chdir "tests"))))))
    (propagated-inputs (list python-decorator python-numpy python-scipy))
    (native-inputs (list python-matplotlib
                         python-pytest
                         python-pytest-cov ; used by default
                         python-pytest-mpl
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/mir-evaluation/mir_eval")
    (synopsis "Common metrics for common audio/music processing tasks")
    (description "This is a Python library for computing common heuristic
accuracy scores for various music/audio information retrieval/signal
processing tasks.")
    (license license:expat)))

(define-public python-mizani
  (package
    (name "python-mizani")
    (version "0.13.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/has2k1/mizani")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0ij0fk4w0jyyj44ij3i2j1nfa0d7dk783w9r25cpwjkpn690xqfx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            ;; The version string is usually derived via setuptools-scm, but
            ;; without the git metadata available, the version string is set to
            ;; '999'.
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs
     (list python-matplotlib python-numpy python-pandas python-scipy))
    (native-inputs
     (list python-setuptools python-setuptools-scm
           python-pytest python-pytest-cov python-wheel tzdata))
    (home-page "https://github.com/has2k1/mizani")
    (synopsis "Create data visualizations in Python")
    (description
     "Mizani is a Python package for creating data visualizations.  It
provides functions and tools to help with the creation of visually appealing
and informative visualizations, including scales, transformations and color
palettes.")
    (license license:bsd-3)))

(define-public python-miniupnpc
  (package
    (name "python-miniupnpc")
    (version "2.3.3")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
          ;; The project tags miniupnpd_ as well but with a different version,
          ;; where updater may select a wrong version.
         (url "https://github.com/miniupnp/miniupnp")
         (commit
          (string-append
           "miniupnpc_" (string-replace-substring version "." "_")))))
       (file-name
        (git-file-name name version))
       (sha256
        (base32 "0ysvx21iaq7f505fpnk3280rwnckr0aih0j5j3v82nv99a2rqigh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'subdir
            (lambda* (#:key inputs #:allow-other-keys)
              (chdir "miniupnpc")
              (setenv "CC" #$(cc-for-target))
              (substitute* "Makefile"
                (("/bin/sh") (search-input-file inputs "/bin/sh")))))
          (add-before 'subdir 'remove-kernel-version
            ;; Avoid embedding the running kernel version for reproducible builds
            (lambda _
              (substitute*
                  "miniupnpc/updateminiupnpcstrings.sh"
                (("^OS_VERSION=`uname -r`") "OS_VERSION=Guix"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "make" "check")))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (inputs (list python))              ;we are building a Python extension
    (synopsis "UPnP client for Python")
    (description "Miniupnpc is a client library for Python programs to set up
port forwards using @acronym{UPnP, Universal Plug and Play}.")
    (home-page "http://miniupnp.free.fr")
    (license license:bsd-3)))

;; NOTE: As taken from upstram: "this library is in maintenance mode and
;; should not be used in new code."
(define-public python-py
  (package
    (name "python-py")
    (version "1.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "py" version))
       (sha256
        (base32
         "06c7m7sfcn7587xd4s2bng8m6q1gsfd3j93afhplfjq74r0mrisi"))))
    (build-system pyproject-build-system)
    (arguments
     '(#:tests? #f)) ;cycle with python-pytest
    (native-inputs
     (list python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/pytest-dev/py")
    (synopsis "Python library for parsing, I/O, introspection, and logging")
    (description
     "Py is a Python library for file name parsing, .ini file parsing, I/O,
code introspection, and logging.")
    (license license:expat)))

(define-public python-pyrsistent
  (package
    (name "python-pyrsistent")
    (version "0.20.0")
    (home-page "https://github.com/tobgu/pyrsistent")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyrsistent" version))
              (sha256
               (base32
                "1935ybwdxszmzlzshwkc7m7swm1js46ls246j1knqndbca7zfj2c"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (synopsis "Persistent data structures for Python")
    (description
     "Pyrsistent is a number of persistent collections (by some referred to as
functional data structures).  Persistent in the sense that they are immutable.

All methods on a data structure that would normally mutate it instead return a
new copy of the structure containing the requested updates.  The original
structure is left untouched.")
    (license license:expat)))

(define-public python-exif-read
  (package
    (name "python-exif-read")
    (version "3.3.2")
    (source
     (origin
       (method git-fetch) ;PyPI doesn't contain the test images
       (uri (git-reference
             (url "https://github.com/ianare/exif-py")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0igvqhalrllidyccy7rlqbhx277rv7mf6bf0w6xjr0dj2dk3jw76"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/ianare/exif-py")
    (synopsis "Python library to extract EXIF data from image files")
    (description
     "ExifRead is a Python library to extract EXIF data from tiff and jpeg
files.")
    (license license:bsd-3)))

(define-public python-pyld
  (package
    (name "python-pyld")
    (version "2.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/digitalbazaar/pyld")
              ;; Not all tags have the 'v' prefix.
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12lb4vk7m5y5943fm4r8hixdvlxh6qm21pbv7aalsbpfw8cc18sw"))))
    (build-system pyproject-build-system)
    (arguments
     ;; TODO: Commit history shows next version (>2.0.4) will have pytest tests.
     (list #:tests? #f))
    (native-inputs
     (list python-lxml
           python-setuptools))
    (propagated-inputs
     (list python-aiohttp
           python-cachetools
           python-frozendict
           python-requests))
    (home-page "https://github.com/digitalbazaar/pyld")
    (synopsis "Python implementation of the JSON-LD specification")
    (description "PyLD is an implementation of the JSON-LD specification.")
    (license license:bsd-3)))

(define-public python-cli-helpers
  (package
    (name "python-cli-helpers")
    (version "2.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cli_helpers" version))
       (sha256
        (base32 "1h4b0ka9nh9qidl6s1ard1ixh9c3d0ai5ph3013grhpbvc81glb2"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-configobj
           python-tabulate))
    (home-page "https://github.com/dbcli/cli_helpers")
    (synopsis "Helpers for building command-line apps")
    (description
     "CLI Helpers is a Python package that makes it easy to perform common
tasks when building command-line apps.  It's a helper library for command-line
interfaces.")
    (license license:bsd-3)))

(define-public python-click
  (package
    (name "python-click")
    (version "8.1.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pallets/click")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wqkkim5gmhdrc62c79s5gbzz2x60l1bf9aacpakfv6rr1zjl054"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list less
           python-flit-core
           python-pytest))
    (home-page "https://palletsprojects.com/p/click/")
    (synopsis "Command line library for Python")
    (description
     "Click is a Python package for creating command line interfaces in a
composable way with as little code as necessary.  Its name stands for
\"Command Line Interface Creation Kit\".  It's highly configurable but comes
with sensible defaults out of the box.")
    (license license:bsd-3)))

(define-public python-click-7
  (package (inherit python-click)
    (name "python-click")
    (version "7.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "click" version))
       (sha256
        (base32 "06kbzd6sjfkqan3miwj9wqyddfxc2b6hi7p5s4dvqjb3gif2bdfj"))))
    (arguments (list #:tests? #f)) ;no tests in PyPI
    (native-inputs
     (list python-setuptools))))

(define-public python-clickgen
  (package
    (name "python-clickgen")
    (version "2.2.5")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                     (url "https://github.com/ful1e5/clickgen")
                     (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0gdbkdw9b52wbb0bbhs09bdfyfq979kvlv5sg5p70y3jal9j8lf8"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; XXX: See: <https://github.com/ful1e5/clickgen/issues/65>.
      '(list "-k" "not test_clickgen_raises")))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-attrs
           python-numpy
           python-pillow
           python-pyyaml
           python-toml))
    (home-page "https://github.com/ful1e5/clickgen")
    (synopsis "The hassle-free cursor building toolbox")
    (description
     "Clickgen is an API for building X11 and Windows cursors from .png files.
clickgen is using @code{anicursorgen} and @code{xcursorgen} under the hood.")
    (license license:expat)))

(define-public python-clickhouse-connect
  (package
    (name "python-clickhouse-connect")
    (version "0.6.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/ClickHouse/clickhouse-connect")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1s0lk7xdq8f351cmpbp6jidqi5zdazrdba7w7fxph0w8sd74amry"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; All these tests require docker-compose
      '(list "--ignore-glob=tests/integration_tests/*")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-pyproject
           (lambda _
             ;; Our version of pytest is confused by this field.
             (substitute* "pyproject.toml"
               (("^env_files.*") ""))))
         (add-before 'check 'build-extensions
           (lambda _
             ;; Cython extensions have to be built before running the tests.
             (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (propagated-inputs
     (list python-arrow
           python-certifi
           python-lz4
           python-numpy
           python-orjson
           python-pandas
           python-pytz
           python-setuptools ; For pkg_resources.
           python-sqlalchemy
           python-urllib3
           python-zstandard))
    (native-inputs
     (list python-cython
           python-pytest
           python-wheel))
    (home-page "https://github.com/ClickHouse/clickhouse-connect")
    (synopsis
     "ClickHouse database core driver for Python, Pandas, and Superset")
    (description
     "This package provides a high performance core database driver for
connecting ClickHouse to Python, Pandas, and Superset.")
    (license license:asl2.0)))

(define-public python-cligj
  (package
    (name "python-cligj")
    (version "0.7.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "cligj" version))
        (sha256
          (base32
            "09vbkik6kyn6yrqzl2r74vaybjk8kjykvi975hy3fsrm4gb17g54"))))
    (build-system pyproject-build-system)
    (native-inputs
      (list python-pytest
            python-setuptools))
    (propagated-inputs
      (list python-click))
    (home-page "https://github.com/mapbox/cligj")
    (synopsis "Click params for command line interfaces to GeoJSON")
    (description
      "cligj is for Python developers who create command line interfaces
for geospatial data.  cligj allows you to quickly build consistent,
well-tested and interoperable CLIs for handling GeoJSON.")
    (license license:bsd-3)))

(define-public python-cloup
  (package
    (name "python-cloup")
    (version "2.1.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cloup" version))
              (sha256
               (base32
                "05c6cjpnf9s72gyn5dckxbmd8rf2kgdzfsl7pqzrnc1lcdl13zmv"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-click))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/janLuke/cloup")
    (synopsis "Extension library for python-click")
    (description
     "Cloup enriches Click with several features that make it more expressive
and configurable such as option groups, constraints, subcommand aliases,
subcommands sections and a themeable HelpFormatter.")
    (license license:bsd-3)))

(define-public python-jsondiff
  (package
    (name "python-jsondiff")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsondiff" version))
       (sha256
        (base32
         "1zpp8l2ii9ic1sk6kdcqxk0v5q9pgdmdhg1h4vg8dfl6i8n1d3b5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-version
            (lambda _
              (substitute* "pyproject.toml"
                (("^version_file.*") "")
                (("dynamic = \\[\"version\"\\]")
                 (string-append "version = \"" #$version "\""))))))))
    (propagated-inputs (list python-pyyaml))
    (native-inputs
     (list python-hypothesis
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/fzumstein/jsondiff")
    (synopsis "Compare JSON and JSON-like structures in Python")
    (description "@code{jsondiff} is a Python library which lets you compare,
diff, and patch JSON and JSON-like structures in Python.")
    (license license:expat)))

(define-public python-ddlparse
  (package
    (name "python-ddlparse")
    (version "1.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ddlparse" version))
       (sha256
        (base32 "1nh8m6rxslwk05daxshxmgk41qfp18yynydba49b13l4m8dnh634"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools))
    (propagated-inputs (list python-pyparsing))
    (home-page "https://github.com/shinichi-takii/ddlparse")
    (synopsis "Parses and converts DDL to BigQuery JSON schema")
    (description "This package provides @code{ddlparse}, a Python library to parse
and convert DDL to BigQuery JSON schema.")
    (license license:bsd-3)))

(define-public python-jsonschema
  (package
    (name "python-jsonschema")
    (version "4.23.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema" version))
       (sha256
        (base32 "1i3b4sckkc3v8vckqa11xbrj695qzrzsfzrkclra6lb3ybz9f56p"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              (setenv "JSON_SCHEMA_TEST_SUITE" "json"))))))
    (native-inputs
     (list python-hatchling
           python-hatch-fancy-pypi-readme
           python-hatch-vcs
           ;; For <tests/test_cli.py::TestCLIIntegration::test_license>.
           python-pip
           python-pytest))
    (propagated-inputs
     (list python-attrs
           python-fqdn
           python-idna
           python-importlib-resources
           python-isoduration
           python-jsonpointer
           python-jsonschema-specifications
           python-rfc3339-validator
           python-rfc3986-validator
           python-referencing-bootstrap
           python-rpds-py
           python-uri-template
           python-webcolors))
    (home-page "https://github.com/Julian/jsonschema")
    (synopsis "Implementation of JSON Schema for Python")
    (description
     "Jsonschema is an implementation of JSON Schema for Python.")
    (license license:expat)))

;; For docker-compose 1.29.2, remove when its updated to the latest 2.x
;; version.
(define-public python-jsonschema-3
  (package
    (inherit python-jsonschema)
    (version "3.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jsonschema" version))
              (sha256
               (base32
                "0ykr61yiiizgvm3bzipa3l73rvj49wmrybbfwhvpgk3pscl5pa68"))))
    (arguments
     (substitute-keyword-arguments (package-arguments python-jsonschema)
       ((#:tests? _ #t) #f)))
    (propagated-inputs
     (list python-attrs
           python-importlib-metadata
           python-pyrsistent
           python-typing-extensions))
    (native-inputs
     (list python-setuptools-scm python-twisted
           python-setuptools python-wheel))))

(define-public python-jsonschema-path
  (package
    (name "python-jsonschema-path")
    (version "0.3.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema_path" version))
       (sha256
        (base32 "129rb8y2bj2wwps8vs3z1qav006k7wz2myx5j6dnxqs1yfmsn3ad"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false  ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "pyproject.toml"
               (("referencing = \">=0.28.0,<0.32.0\"")
                "referencing = \">=0.28.0\"")))))))
    (propagated-inputs (list python-pathable python-pyyaml python-referencing
                             python-requests))
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/p1c2u/jsonschema-path")
    (synopsis "JSONSchema Spec with object-oriented paths")
    (description "This package implements object-oriented JSONSchema.  It lets
you traverse a schema like paths and access a schema on demand with separate
dereferencing accessor layer.")
    (license license:asl2.0)))

(define-public python-jsonschema-objects
  (package
    (name "python-jsonschema-objects")
    (version "0.5.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/cwacek/python-jsonschema-objects/")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0p3m0fbj25brhfma4bl47xjq6x4ay14yx284qwrki96dwd6v46xd"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-mock
           python-setuptools))
    (propagated-inputs
     (list python-inflection
           python-jsonschema
           python-markdown))
    (home-page "http://python-jsonschema-objects.readthedocs.org/")
    (synopsis "Automatic Python binding generation from JSON schemas")
    (description
     "This package provides an automatic class-based binding to JSON
Schemas for use in python.")
    (license license:expat)))

(define-public python-jsonschema-specifications
  (package
    (name "python-jsonschema-specifications")
    (version "2024.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonschema_specifications" version))
       (sha256
        (base32 "0wp2g90jsaa48g1v0n6m43ywhh9cj1ig19q25lay334m74vbhf0g"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-importlib-resources
           python-referencing-bootstrap))
    (home-page "https://github.com/python-jsonschema/jsonschema-specifications")
    (synopsis
     "JSON Schema meta-schemas and vocabularies, exposed as a Registry")
    (description
     "This package provides JSON support files from the JSON Schema
Specifications (metaschemas, vocabularies, etc.), packaged for runtime access
from Python as a referencing-based Schema Registry.")
    (license license:expat)))

(define-public python-schema
  (package
    (name "python-schema")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "schema" version))
       (sha256
        (base32
         "01qq1amzbjm1kvjrnnhpjs8v761kwp6qihs74pf1k2lmsamm79bx"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/keleshev/schema")
    (synopsis "Simple data validation library")
    (description
     "@code{python-schema} is a library for validating Python data
structures, such as those obtained from config-files, forms, external
services or command-line parsing, converted from JSON/YAML (or
something else) to Python data-types.")
    (license license:psfl)))

;; It may be removed after 2025-11-29.
(define-deprecated/public-alias python-schema-0.5 python-schema)

(define-public python-kitchen
  (package
    (name "python-kitchen")
    (version "1.2.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kitchen" version))
       (sha256
        (base32
         "1zakh6l0yjvwic9p0nkvmbidpnkygkxbigh2skmb5gccyrhbp7xg"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-chardet))
    (home-page "https://github.com/fedora-infra/kitchen")
    (synopsis "Python API for snippets")
    (description "@code{kitchen} module provides a python API for all sorts of
little useful snippets of code that everybody ends up writing for their projects
but never seem big enough to build an independent release.  Use kitchen and stop
cutting and pasting that code over and over.")
    (license (list license:lgpl2.1+
                   ;; subprocess.py, test_subprocess.py,
                   ;; kitchen/pycompat25/defaultdict.py:
                   license:psfl))))

(define-public python-roman
  (package
    (name "python-roman")
    (version "5.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/zopefoundation/roman")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0zvg6pmv0yxm0b96dx104jzlxnsi3wy4swbj1lmc3mym5nahgp36"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/zopefoundation/roman")
    (synopsis "Integer to Roman numerals converter")
    (description
     "This package provides a small helper library to convert Arabic Numbers
to Roman Numerals.")
    (license license:zpl2.1)))

(define-public python-rollbar
  (package
    (name "python-rollbar")
    (version "1.3.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rollbar" version))
              (sha256
               (base32
                "0ydksca7glb7g026f4f8nsvpyj8qpgv74642hjj4zk4vqgm0552i"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-httpx
                         python-pytest
                         python-setuptools
                         python-webob
                         python-wheel))
    (inputs (list python-requests))
    (home-page "https://github.com/rollbar/pyrollbar")
    (synopsis "Notifier for exceptions, errors, and log messages to Rollbar")
    (description
     "Python SDK for reporting exceptions, errors, and log messages
to @url{https://rollbar.com/, Rollbar}.

Capabilities include:

@itemize @bullet
@item Sending messages and exceptions with arbitrary context
@item Getting back aggregates
@item Debugging production issues
@end itemize")
    (license license:expat)))

(define-public python-pyjwt
  (package
    (name "python-pyjwt")
    (version "2.10.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyjwt" version))
       (sha256
        (base32 "0lqr73wnrnxflbh8wr768hxp493qayhdis86mwy26280n8p7gi9w"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 286 passed, 4 skipped, 1 deselected
      ;;
      ;; jwt.exceptions.PyJWKClientConnectionError: Fail to fetch data from
      ;; the url, err: "<urlopen error [Errno -3] Temporary failure in name
      ;; resolution>"
      #:test-flags #~(list "-k" "not test_get_jwt_set_sslcontext_default")))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (if (supported-package? python-cryptography)
         (list python-cryptography)
         '()))
    (home-page "https://github.com/progrium/pyjwt")
    (synopsis "JSON Web Token implementation in Python")
    (description
     "PyJWT is a JSON Web Token implementation written in Python.")
    (license license:expat)))

(define-public python-pymsgbox
  (let ((commit "944b7cdc67058d005ce5fd011c66f2d87d25aba0")
        (revision "1"))
    (package
      (name "python-pymsgbox")
      (version (git-version "1.0.6" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/asweigart/PyMsgBox")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1bhipfvnc06l8hiadk302v74yin38nwz1r47njliwk8kz103yl3g"))))
      (build-system pyproject-build-system)
      (arguments
       ;; Circular dependency to run tests:
       ;; Tests need pyautogui, which depends on pymsgbox.
       '(#:tests? #f))
      (native-inputs (list python-setuptools python-wheel))
      (home-page "https://github.com/asweigart/PyMsgBox")
      (synopsis "Python module for JavaScript-like message boxes")
      (description
       "PyMsgBox is a simple, cross-platform, pure Python module for
JavaScript-like message boxes.  Types of dialog boxes include:
@enumerate
@item alert
@item confirm
@item prompt
@item password
@end enumerate
")
      (license license:bsd-3))))

(define-public python-pympler
  (package
    (name "python-pympler")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pympler" version))
       (sha256
        (base32 "090403k1wvqyddjwbla4843dylysrkd8yw7i62222b4rp1y8dahy"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; One test fails with error: 'function (test.muppy.test_summary.func)'
      ;; != 'function (muppy.test_summary.func)'.
      ;; See <https://github.com/pympler/pympler/issues/134>.
      #:test-flags #~(list "-k" "not test_repr_function")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://pythonhosted.org/Pympler/")
    (synopsis "Measure, monitor and analyze memory behavior")
    (description
     "Pympler is a development tool to measure, monitor and analyze
the memory behavior of Python objects in a running Python application.

By pympling a Python application, detailed insight in the size and the
lifetime of Python objects can be obtained.  Undesirable or unexpected
runtime behavior like memory bloat and other @samp{pymples} can easily
be identified.

A web profiling frontend exposes process statistics, garbage
visualisation and class tracker statistics.")
    (license license:asl2.0)))

(define-public python-itsdangerous
  (package
    (name "python-itsdangerous")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "itsdangerous" version))
       (sha256
        (base32 "0wv1bwzbfvpsh4ng5gn4d4mjwvjwpg7w0jgiz8zsbvm1gl5hq1g0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-freezegun
           python-pytest))
    (home-page "https://palletsprojects.com/p/itsdangerous/")
    (synopsis "Python library for passing data to/from untrusted environments")
    (description
     "Itsdangerous provides various helpers to pass trusted data to untrusted
environments and back.")
    (license license:bsd-3)))

;; WARNING: This package is a dependency of mesa.
(define-public python-pyyaml
  (package
    (name "python-pyyaml")
    (version "6.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyYAML" version))
       (sha256
        (base32 "0gmwggzm0j0iprx074g5hah91y2f68sfhhldq0f8crddj7ndk16m"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-cython
           python-pytest
           python-setuptools
           python-wheel))
    (inputs
     (list libyaml))
    (home-page "https://pyyaml.org")
    (synopsis "YAML parser and emitter for Python")
    (description
     "PyYAML is a YAML parser and emitter for Python.  PyYAML features a
complete YAML 1.1 parser, Unicode support, pickle support, capable extension
API, and sensible error messages.  PyYAML supports standard YAML tags and
provides Python-specific tags that represent an arbitrary Python object.")
    (license license:expat)))

(define-public python-crossenv
  (package
    (name "python-crossenv")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "crossenv" version))
       (sha256
        (base32
         "0f9x3f506pl45ip1nm3fx8gzwm1hr7w1b0bib4kg74zph7jmz72x"))))
    (build-system python-build-system)
    (arguments
     (list #:tests? #f)) ; tests not distributed on pypi
    (home-page "https://github.com/benfogle/crossenv")
    (synopsis "Cross-compiling virtualenv for Python")
    (description "This package is a tool for cross-compiling extension
modules.  It creates a special virtual environment such that @command{pip} or
@file{setup.py} will cross compile packages for you, usually with no further
work on your part.")
    (license license:expat)))

(define-public python-linkify-it-py
  (package
    (name "python-linkify-it-py")
    (version "2.0.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/tsutsu3/linkify-it-py")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0fg0a1lc8xbb62y9krxcp708ll58dxcwm8i7rrwpkd5sh2229f6x"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-uc-micro-py))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/tsutsu3/linkify-it-py")
    (synopsis "Links recognition library with full Unicode support")
    (description "This is Python port of
@url{https://github.com/markdown-it/linkify-it, linkify-it}, which is a links
recognition library with full Unicode support.  It has features like:
@itemize
@item Full unicode support, with @i{astral} characters
@item International domains support
@item Allows rules extension and custom normalizers.
@end itemize")
    (license license:expat)))

(define-public python-makefun
  (package
    (name "python-makefun")
    (version "1.15.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "makefun" version))
              (sha256
               (base32
                "19a8dga8rnmjn5gy1cy1wdi28swbkdkypwbqikbxil6ynqcg3c20"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm python-wheel))
    (home-page "https://github.com/smarie/python-makefun")
    (synopsis "Library to dynamically create python functions")
    (description "@code{makefun} helps create functions dynamically with a
given signature.  It was largely inspired by @code{python-decorator} and
@code{functools}.")
    (license license:bsd-3)))

(define-public python-markdown-it-py
  (package
    (name "python-markdown-it-py")
    (version "3.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "markdown-it-py" version))
              (sha256
               (base32
                "1swgvyiavak0nmfb31lq5zck5chwhmyf6qb6qwpcav86zaa0mxp3"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;pypi source does not contains tests
    (native-inputs (list python-flit-core))
    (propagated-inputs
     (list python-commonmark
           python-linkify-it-py
           python-markdown
           python-mdurl
           python-mistletoe
           python-mistune
           python-panflute
           python-psutil
           python-pyyaml))
    (home-page "https://github.com/executablebooks/markdown-it-py")
    (synopsis "Python port of markdown-it")
    (description
     "This is a Python port of @code{markdown-it}, and some of its associated
plugins.  The driving design philosophy of the port has been to change as
little of the fundamental code structure (file names, function name, etc) as
possible.")
    (license license:expat)))

(define-public python-markupsafe
  (package
    (name "python-markupsafe")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "markupsafe" version))
       (sha256
        (base32 "1w1b1a5pskpqhx1mb53rgpv9srplhrrkr4hsl67f8rq1z3nx6mgf"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://markupsafe.palletsprojects.com")
    (synopsis "XML/HTML/XHTML markup safe string implementation for Python")
    (description
     "Markupsafe provides an XML/HTML/XHTML markup safe string implementation
for Python.")
    (license license:bsd-3)))

(define-public python-jinja2
  (package
    (name "python-jinja2")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Jinja2" version))
       (sha256
        (base32 "0lp86yadzf8dph67f6g3yxmvnhrzzi863z58jmsrx2j059q1ld9i"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-markupsafe))
    (home-page "https://jinja.palletsprojects.com/")
    (synopsis "Python template engine")
    (description
     "Jinja2 is a small but fast and easy to use stand-alone template engine
written in pure Python.")
    (license license:bsd-3)))

(define-public python-jinja2-time
  (package
    (name "python-jinja2-time")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jinja2-time" version))
       (sha256
        (base32
         "0h0dr7cfpjnjj8bgl2vk9063a53649pn37wnlkd8hxjy656slkni"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-arrow python-jinja2))
    (home-page
     "https://github.com/hackebrot/jinja2-time")
    (synopsis "Jinja2 Extension for Dates and Times")
    (description
     "This package provides an extension for the template engine Jinja2.  It
adds a 'now' tag providing a convenient access to the arrow.now() API from
templates.  A format string can be provided to control the output.")
    (license license:expat)))

(define-public python-pypugjs
  (package
    (name "python-pypugjs")
    (version "5.12.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/kakulukia/pypugjs")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "008wxvh2p08i8mlgak8hz3z057m06m4ydrca2ickl2m593476xi4"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-django
                         python-jinja2
                         python-flask
                         python-mako
                         python-poetry-core
                         python-pytest
                         python-tornado-6))
    (propagated-inputs (list python-charset-normalizer python-six))
    (home-page "https://github.com/kakulukia/pypugjs")
    (synopsis "Convert Pug source files into different template languages")
    (description
     "PyPugJS is a high-performance port of PugJS for Python, that converts
any @file{.pug} source into different template languages: Django, Jinja2,
Mako, and Tornado.")
    (license license:expat))) ;; MIT

(define-public python-pystache
  (package
    (name "python-pystache")
    (version "0.6.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pystache" version))
              (sha256
               (base32
                "0b67fmq0wmfkgcr7qqc44vvpvh8zkdk0rh87kccds9jdda7521rp"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "http://defunkt.io/pystache/")
    (synopsis "Python logic-less template engine")
    (description
     "Pystache is a Python implementation of the framework agnostic,
logic-free templating system Mustache.")
    (license license:expat)))

(define-public python-pystitcher
  (package
    (name "python-pystitcher")
    (properties '((commit . "d8150be85d53335f7077491ab4d73fad772ef1c9")
                  (revision . "0")
                  (upstream-version . "1.0.5")))
    (version (git-version (assoc-ref properties 'upstream-version)
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/captn3m0/pystitcher")
             (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02q03smvfz6x8v45s6qcgh1r2plpcam7ra24ikgqlmq005w7nhv3"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                      #$(assoc-ref properties 'upstream-version)))))))
    (native-inputs (list python-hatchling python-hatch-vcs python-pytest))
    (inputs (list python-html5lib
                  python-importlib-metadata
                  python-markdown
                  python-pypdf
                  python-validators))
    (home-page "https://github.com/captn3m0/pystitcher")
    (synopsis "Declaratively stitch together a PDF file from multiple sources")
    (description
     "This package stitches your PDF files together, generating customizable
bookmarks using a declarative input in the form of a markdown file.")
    (license license:expat)))

(define-public python-joblib
  (package
    (name "python-joblib")
    (version "1.5.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "joblib" version))
       (sha256
        (base32 "0mbvch9pzadf0vrm666381ic0ryy5zsv5abxak506bsb0lwmraiz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (min 8 (parallel-job-count)))
              ;; Disabled to avoid having to depend on ipython/jupyter.
              "-k" "not test_parallel_call_cached_function_defined_in_jupyter")))
    (native-inputs
     (list python-pytest
           python-pytest-asyncio
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (home-page "https://joblib.readthedocs.io/")
    (synopsis "Using Python functions as pipeline jobs")
    (description
     "Joblib is a set of tools to provide lightweight pipelining in Python.
In particular, joblib offers: transparent disk-caching of the output values
and lazy re-evaluation (memoize pattern), easy simple parallel computing
logging and tracing of the execution.")
    (license license:bsd-3)))

(define-public python-daemon
  (package
    (name "python-daemon")
    (version "3.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://pagure.io/python-daemon")
              (commit (string-append "release/" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rfchh68pxg68s02idc0qcm2s9yn587hv0b83r4isy5ccb3g60y4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'discard-dynamic-metadata
            (lambda _
              (substitute* "pyproject.toml"
                (("^dynamic = " all)
                 (format #f "version = ~s~%~a" #$version all))
                (("\"(description|readme|version|maintainers)\",")
                 ""))
              (for-each delete-file
                        '("setup.py"
                          "test/test_util_metadata.py"
                          "test/test_setup.py")))))))
    (propagated-inputs (list python-lockfile))
    (native-inputs (list python-testscenarios python-setuptools))
    (home-page "https://pagure.io/python-daemon/")
    (synopsis "Python library for making a Unix daemon process")
    (description
     "Python-daemon is a library that assists a Python program to turn itself
into a well-behaved Unix daemon process, as specified in PEP 3143.

This library provides a @code{DaemonContext} class that manages the following
important tasks for becoming a daemon process:
@enumerate
@item Detach the process into its own process group.
@item Set process environment appropriate for running inside a chroot.
@item Renounce suid and sgid privileges.
@item Close all open file descriptors.
@item Change the working directory, uid, gid, and umask.
@item Set appropriate signal handlers.
@item Open new file descriptors for stdin, stdout, and stderr.
@item Manage a specified PID lock file.
@item Register cleanup functions for at-exit processing.
@end enumerate")
    ;; Only setup.py is gpl3+, everything else is apache 2.0 licensed.
    (license (list license:asl2.0 license:gpl3+))))

(define-public python-annotated-types
  (package
    (name "python-annotated-types")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "annotated_types" version))
       (sha256
        (base32 "12ff8j1l0hrmfa8dfa1pyaka5a8sbyq8b76bzj6bq21sll4prw5g"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs (list python-typing-extensions))
    (home-page "https://github.com/annotated-types/annotated-types")
    (synopsis "Reusable constraint types to use with typing.Annotated")
    (description "This package provides metadata objects which can be used to
represent common constraints such as upper and lower bounds on scalar values and
collection sizes, a Predicate marker for runtime checks, and descriptions of how
we intend these metadata to be interpreted.  In some cases, we also note
alternative representations which do not require this package.")
    (license license:expat)))

(define-public python-anytree
  (package
    (name "python-anytree")
    (version "2.13.0")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/c0fec0de/anytree")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xp13r0jrz1kdmi9h10bmgqzc7wjil3ghf6gqsi9m0lsqlj5hlwh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; Tests need to write to that direcroty.
              (mkdir-p "tests/dotexport/"))))))
    (native-inputs
     (list graphviz ;for 'dot'
           python-pdm-backend
           python-pytest
           python-pytest-cov
           python-pyyaml
           python-test2ref))
    (home-page "https://github.com/c0fec0de/anytree")
    (synopsis "Lightweight tree data library")
    (description
     "@code{anytree} is a simple, lightweight, and extensible tree data
structure for Python.")
    (license license:asl2.0)))

(define-public kalamine
  (package
    (name "kalamine")
    (version "0.38")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "kalamine" version))
       (sha256
        (base32 "0dj0v4in6jngh7f5ypvxyadjsilbiwxj3rx6yxxmh5zab6dxzyhz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'make-test-layouts
            (lambda _
              (apply invoke
                     (cons* "python" "-m" "kalamine.cli" "build"
                            (find-files "layouts" "\\.toml")))
              (invoke "python" "-m" "kalamine.cli" "new" "test.toml"))))))
    (propagated-inputs
     (list python-click
           python-livereload
           python-lxml
           python-progress
           python-pyyaml
           python-tomli))
    ;; TODO: Add python-pytest-ruff to native-inputs once it has been
    ;; packaged.
    (native-inputs
     (list python-hatchling python-mypy python-pytest))
    (home-page "https://github.com/OneDeadKey/kalamine")
    (synopsis "Keyboard layout maker")
    (description
     "Kalamine provides a CLI to create advanced keyboard layout from a
textual portable description.  It also supports layout emulation via web
browser.")
    (license license:expat)))

(define-public python-dm-tree
  (package
    (name "python-dm-tree")
    (version "0.1.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dm_tree" version))
       (sha256
        (base32 "0arlspn0122igcz5sq6lqrw6zkdhqqkgr0xkwkas599m74yxpix4"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f
           #:phases
           ;; TODO: Build against shared libraries with USE_SYSTEM_ABSEIL=true
           ;; and USE_SYSTEM_PYBIND11=true.
           #~(modify-phases %standard-phases
               (add-before 'build 'build-shared-lib
                 (lambda _
                   (let* ((pybind11   #$(this-package-input "pybind11"))
                          (python     #$(this-package-input "python"))
                          (version    (python-version python))
                          (abseil-cpp #$(this-package-input "abseil-cpp")))
                     ;; Delete default cmake build.
                     (substitute* "setup.py"
                       (("ext_modules.*") "")
                       (("cmdclass.*") ""))
                     ;; Actual build phase.
                     (mkdir-p "build/temp/tree/")
                     (invoke
                      "gcc" "-pthread" "-Wno-unused-result" "-Wsign-compare"
                      "-DNDEBUG" "-g" "-fwrapv" "-O3" "-Wall"
                      "-fno-semantic-interposition" "-fPIC"
                      "-I" (string-append pybind11
                                          "/lib/python" version
                                          "/site-packages/pybind11/include")
                      "-I" (string-append python "/include/python"
                                          version)
                      "-I" (string-append abseil-cpp "/include")
                      "-c" "tree/tree.cc"
                      "-o" "build/temp/tree/tree.o"
                      "-fvisibility=hidden" "-g0")
                     (mkdir-p "build/lib/tree")
                     (invoke
                      "g++" "-pthread" "-shared"
                      (string-append "-Wl," "-rpath=" python "/lib")
                      "-fno-semantic-interposition"
                      "build/temp/tree/tree.o"
                      "-L" (string-append python "/lib")
                      (string-append abseil-cpp "/lib/libabsl_int128.a")
                      (string-append abseil-cpp "/lib/libabsl_raw_hash_set.a")
                      (string-append abseil-cpp "/lib/libabsl_raw_logging_internal.a")
                      (string-append abseil-cpp "/lib/libabsl_strings.a")
                      (string-append abseil-cpp "/lib/libabsl_strings_internal.a")
                      (string-append abseil-cpp "/lib/libabsl_throw_delegate.a")
                      "-o" "build/lib/tree/_tree.so")))))))
    ;; We link the static abseil libraries here to avoid problems in
    ;; downstream libraries using potentially different variants of
    ;; abseil-cpp.  This is also what's done in the upstream CMake build.
    (native-inputs
     (list python-setuptools))
    (inputs
     (list pybind11
           static-abseil-cpp
           python))
    (propagated-inputs
     (list python-absl-py
           python-attrs
           python-numpy
           python-wrapt))
    (home-page "https://github.com/deepmind/tree")
    (synopsis "Work with nested data structures in Python")
    (description "Tree is a python library for working with nested data
structures.  In a way, @code{tree} generalizes the builtin @code{map} function
which only supports flat sequences, and allows you to apply a function to each
leaf preserving the overall structure.")
    (license license:asl2.0)))

(define-public python-pyment
  (package
    (name "python-pyment")
    (version "0.3.4")
    (source
       (origin
         (method git-fetch)
         (uri
          (git-reference
           (url "https://github.com/dadadel/pyment")
           (commit (string-append "v" version))))
         (file-name (git-file-name name version))
         (sha256
          (base32 "0gbx9wmqsxdx85v5sg79lv2zxmy16j5dwi8bip07i1nyvzc5gvn0"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/dadadel/pyment/")
    (synopsis "Convert Python docstrings automatically")
    (description "Pyment is a command line tool and library that can be
used to convert between several docstring styles.")
    (license license:gpl3+)))

(define-public python-docstring-parser
  (package
    (name "python-docstring-parser")
    (version "0.15")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docstring_parser" version))
              (sha256
               (base32
                "10pnbg2q0ic1h6pwbyhhqd075fv67sq07k3gjncmi1mix29w1pa8"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/rr-/docstring_parser")
    (synopsis "Parse Python docstrings in reST, Google and Numpydoc format")
    (description "This package lets you parse Python docstrings in reST,
Google and Numpydoc format.")
    (license license:expat)))

(define-public python-docutils
  (package
    (name "python-docutils")
    (version "0.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "docutils" version))
       (sha256
        (base32 "0vwqzbmzdvwx23myx4cg8s8mdkrqnfxpa9yi7jm2s66z5rrihsrs"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test/alltests.py")))
    (native-inputs
     (list python-flit-core))
    (home-page "https://docutils.sourceforge.net/")
    (synopsis "Python Documentation Utilities")
    (description
     "Docutils is a modular system for processing documentation into useful
formats, such as HTML, XML, and LaTeX.  It uses @dfn{reStructuredText}, an
easy to use markup language, for input.

This package provides tools for converting @file{.rst} files to other formats
via commands such as @command{rst2man}, as well as supporting Python code.")
    ;; Most of the source code is public domain, but some source files are
    ;; licensed under the PFSL, BSD 2-clause, and GPLv3+ licenses.
    (license (list license:public-domain license:psfl license:bsd-2 license:gpl3+))))

;; awscli refuses to be built with docutils < 0.17.
(define-public python-docutils-0.16
  (package
    (inherit python-docutils)
    (version "0.16")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "docutils" version))
              (sha256
               (base32
                "1z3qliszqca9m719q3qhdkh0ghh90g500avzdgi7pl77x5h3mpn2"))))
    ;; tests contain Python 2 syntax.
    (arguments '(#:tests? #false))
    (native-inputs
     (list python-setuptools python-wheel))))

(define-public python-docutils-0.19
  (hidden-package
   (package
     (inherit python-docutils)
     (version "0.19")
     (source (origin
               (method url-fetch)
               (uri (pypi-uri "docutils" version))
               (sha256
                (base32
                 "1rprvir116g5rz2bgzkzgyn6mv0z8582rz7bgxbpy2y3adkmm69k"))))
     (native-inputs
      (list python-setuptools python-wheel)))))

(define-public python-docx
  (package
    (name "python-docx")
    (version "1.2.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "python_docx" version))
              (sha256
               (base32
                "1ki0cbw3hbiz51ww3fi3vi770lk5r0c62889r819r756v2vxgjbv"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list behave
           python-pyparsing
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-lxml python-typing-extensions))
    (home-page "https://github.com/python-openxml/python-docx/")
    (synopsis "Python library to create and modify Microsoft Word documents")
    (description "This Python library can be used to create and update
Microsoft Word (.docx) documents.")
    (license license:expat)))

(define-public python-repoze-lru
  (package
    (name "python-repoze-lru")
    (version "0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "repoze.lru" version))
       (sha256
        (base32 "0xzz1aw2smy8hdszrq8yhnklx6w1r1mf55061kalw3iq35gafa84"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags #~(list "discover" "repoze")))
    (native-inputs
     (list python-setuptools))
    (home-page "https://www.repoze.org")
    (synopsis "Tiny LRU cache implementation and decorator")
    (description
     "This package provides a tiny LRU cache implementation and decorator.")
    (license license:bsd-4)))

(define-public python-reretry
  (package
    (name "python-reretry")
    (version "0.11.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/leshchenko1979/reretry")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15c6275mcrkrq3zs0gyx06gr3xsg9ldrpyknfy4mbypgwjy6fp38"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-asyncio python-setuptools))
    (home-page "https://github.com/leshchenko1979/reretry")
    (synopsis "Functional decorator for retrying on exceptions")
    (description
     "This package is a fork from the retry package, but with some of added
community-sourced features.  It provides an easy to use, but functional
decorator for retrying on exceptions.")
    (license license:asl2.0)))

(define-public python-restructuredtext-lint
  (package
    (name "python-restructuredtext-lint")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/twolfson/restructuredtext-lint")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "19ncbmnq2rnkqxhc9wf0q9whji34iyfv1pz6z61vnv4qhhdrn33v"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (propagated-inputs (list python-docutils))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/twolfson/restructuredtext-lint")
    (synopsis "Linter")
    (description
     "This package provides a linter for the reStructuredText format.")
    (license license:unlicense)))

(define-public python-click-repl
  (package
    (name "python-click-repl")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/click-contrib/click-repl")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08asy80wdplbrfff7q7qb9k3kkaw5jxqvy9jnkfvsqy3831zf964"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest
                         python-pytest-cov ; used by default
                         python-setuptools
                         python-wheel))
    (propagated-inputs
     (list python-click python-prompt-toolkit))
    (home-page "https://github.com/click-contrib/click-repl")
    (synopsis "REPL plugin for Click")
    (description "This package provides a REPL plugin for Click.")
    (license license:expat)))

(define-public python-pygdbmi
  (package
    (name "python-pygdbmi")
    (version "0.11.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygdbmi" version))
       (sha256
        (base32 "1c0z4snkjiyl1iq4m1k6liwg0b4pdv2as4bfyvcm0mpjzki6na3s"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ;no tests in PyPI archive
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/cs01/pygdbmi")
    (synopsis "Parse gdb machine interface output with Python")
    (description "This package provides a parse gdb machine interface output
with Python.")
    (license license:expat)))

(define-public python-pygments
  (package
    (name "python-pygments")
    (version "2.19.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygments" version))
       (sha256
        (base32
         "07qm8mx3y5r8ri6zpn0hp9zx5g02bydhi7pkv54hdp3nhlm6vhb1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; 4568 passed, 16 skipped, 597 deselected
      ;;
      ;; Ignore tests requiring "wcag_contrast_ratio"
      #~(list "--ignore=tests/contrast/test_contrasts.py"
              ;; Tests fail with not matched diff.
              "--ignore=tests/examplefiles/awk/test.awk"
              "--ignore=tests/examplefiles/bash/example.sh"
              "--ignore=tests/examplefiles/make/Makefile"
              "--ignore=tests/examplefiles/phix/example.exw"
              "--ignore=tests/examplefiles/sed/all_sorts_of_syntax.sed"
              "--ignore=tests/examplefiles/sed/count_words.sed"
              "--ignore=tests/examplefiles/sed/increment_number.sed"
              "--ignore=tests/examplefiles/sed/reverse.sed"
              "--ignore=tests/examplefiles/slurm/example.sl"
              ;; Assertion error to find example file by following symlink:
              ;; assert p.is_file(), f"Example file {p} not found"
              "--deselect=tests/test_basic_api.py::test_lexer_classes")))
    (native-inputs
     (list python-hatchling python-pytest-bootstrap))
    (home-page "https://pygments.org/")
    (synopsis "Syntax highlighting")
    (description
     "Pygments is a syntax highlighting package written in Python.")
    (license license:bsd-2)))

(define-public python-pygments-bootstrap
   (package/inherit python-pygments
     (name "python-pygments-bootstrap")
     (native-inputs
      (list python-hatchling))
     (arguments `(#:tests? #f))))

(define-public python-pygtrie
  (package
    (name "python-pygtrie")
    (version "2.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mina86/pygtrie")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00m4h2faslm242hsp98d21n6jmc8h616m69p2n6ga2rz37jqmh45"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (delete-file "version.py")
              (substitute* "setup.py"
                (("import version")
                 "")
                (("version\\.get_version\\(\\)")
                 (format #f "~s" #$version))))))))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/mina86/pygtrie")
    (synopsis "Pure Python trie data structure implementation")
    (description
     "This package provides a pure Python trie data structure implementation.")
    (license license:asl2.0)))

(define-public python-bump2version
  (package
    (name "python-bump2version")
    (properties '((commit . "1044c085ba7d32d73c9cd7ca4561a7ec624c6b19")
                  (revision . "1")))
    (version (git-version "1.0.1"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/c4urself/bump2version")
             (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1m5c5rdz9723irwdl46mg7si5syddlzna0ldkz2ps6dphkmqsv7j"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: Single flaky failing test.
     (list #:test-flags #~(list "-k" "not test_usage_string")))
    (native-inputs (list python-pytest python-setuptools python-testfixtures))
    (home-page "https://github.com/c4urself/bump2version")
    (synopsis "Version-bump your software with a single command!")
    (description
     "This package provides a small command line tool to simplify releasing
software by updating all version strings in your source code by the correct
increment.  It also creates commits and tags.")
    (license license:expat)))

(define-public python-deprecated
  (package
    (name "python-deprecated")
    (version "1.2.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tantale/deprecated")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0knjsacv0r4gyz6ngjn3ih6352yz05r63ll73y2cg162bzcak48z"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-wrapt))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/tantale/deprecated")
    (synopsis "Python decorator to deprecate classes, functions or methods")
    (description "The @code{deprecated} decorator provides a convenient way to deprecate
to deprecate classes, functions or methods.")
    (license license:expat)))

(define-public python-pygithub
  (package
    (name "python-pygithub")
    (version "2.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/PyGithub/PyGithub")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0c5qp69qfkfcp8lfmfh0a2rcb1azsrlrc525qd8blnkrmz2mmayz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs
     (list python-pyjwt
           python-pynacl
           python-requests
           python-typing-extensions
           python-urllib3))
    (native-inputs
     (list python-responses
           python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://pygithub.readthedocs.io/en/latest/")
    (synopsis "Python library for the GitHub API")
    (description "This library allows managing GitHub resources such as
repositories, user profiles, and organizations in your Python applications,
using version 3 of the GitHub application programming interface (API).")
    (license license:lgpl3+)))

(define-public python-rellu
  (package
    (name "python-rellu")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/rellu")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vbzkn4yfmc3dypgkw47fyd6n26ib7na1azrgjrvwc0vdf0qjyrw"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-invoke python-pygithub))
    (home-page "https://github.com/robotframework/rellu")
    (synopsis "Utilities to create PyPI releases")
    (description
     "This collection of utilities contains tooling and templates to assist in
creating releases on GitHub and publishing them on PyPI.  It is designed to be
used by Robot Framework and tools and libraries in its ecosystem, but can
naturally be used also by other projects.")
    (license license:asl2.0)))

(define-public python-robotframework
  (package
    (name "python-robotframework")
    (version "7.3.2")
    (source
     (origin
       (method git-fetch) ; no tests in the PyPI archive
       (uri (git-reference
             (url "https://github.com/robotframework/robotframework")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0azis3dj7lfiwrr5gr1gr78z5m05vvl8n20rw3bz93s05z94h5i7"))))
    (outputs '("out" "doc"))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:modules '((guix build pyproject-build-system)
                  (guix build utils)
                  (ice-9 ftw)
                  (ice-9 match)
                  (srfi srfi-26))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'build-and-install-doc
            (lambda* (#:key outputs #:allow-other-keys)
              (let ((doc (string-append #$output:doc
                                        "/share/doc/robotframework")))
                (invoke "invoke" "library-docs" "all")
                (invoke "doc/userguide/ug2html.py" "dist") ;user guide
                (mkdir-p doc)
                (with-directory-excursion "dist"
                  (define user-guide-dir
                    (match (scandir "." (cut string-prefix?
                                             "robotframework-userguide-" <>))
                      ((dir) dir)
                      (_ (error "could not find the user guide directory"))))
                  (copy-recursively user-guide-dir doc)))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; TODO: Some acceptance faile and took near 30min to
                ;; complete: 6765 tests, 6745 passed, 20 failed; findout how
                ;; to skip failing ones.
                (format #t "Running unit tests...~%")
                (invoke "utest/run.py")))))))
    (native-inputs
     (list python-docutils
           python-invoke
           python-jsonschema
           python-pygments
           python-rellu
           python-typing-extensions
           python-setuptools
           `(,python "tk")              ;used when building the HTML doc
           python-wheel))
    (home-page "https://robotframework.org")
    (synopsis "Generic automation framework")
    (description "Robot Framework is a generic automation framework for
acceptance testing, acceptance test driven development (ATDD), and robotic
process automation (RPA).")
    (license license:asl2.0)))

(define-public python-robotframework-datadriver
  (package
    (name "python-robotframework-datadriver")
    (version "1.11.2")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/Snooz82/robotframework-datadriver")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fq6ykbnypirw1wrgigsfzg8lv8g7j9gs46v0n814ycw8906n43x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'skip-problematic-tests
            (lambda _
              (for-each delete-file-recursively
                        (list
                            ;; The test file 'tab-csv-file-name.tsv' contains
                            ;; special characters for which there is no locale
                            ;; in the build environment, causing one test to
                            ;; fail.
                            "atest/TestCases/csv_reader_config"
                            ;; Error in file on line 6: Non-existing setting
                            ;; 'Test Tags'.
                            "atest/TestCases/DataTypes/Types_in_dicts.robot"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (with-directory-excursion "atest"
                  (invoke "sh" "run_atest.sh"))))))))
    (native-inputs
     (list python-docutils
           python-robotframework-stacktrace
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-openpyxl
           python-pandas
           python-pygments
           python-robotframework))
    (home-page "https://github.com/Snooz82/robotframework-datadriver")
    (synopsis "Data-driven test extension for Robot Framework")
    (description "DataDriver is a data-driven extension for Robot Framework.
DataDriver uses the Listener Interface of Robot Framework to create new test
cases based on a data file that contains the test data.  DataDriver supports
data files in the CSV, XLS or XLSX formats.")
    (license license:asl2.0)))

(define-public python-robotframework-lint
  ;; There is no properly tagged release; the commit below seems to correspond
  ;; to the 0.9 stable release available from PyPI.  The tests are not
  ;; included in the PyPI archive, so we fetch the sources from the upstream
  ;; Git repo.
  (let ((commit "b0619ac58a8b1be125f9c98856a664594614570f")
        (revision "0"))
    (package
      (name "python-robotframework-lint")
      (version (git-version "1.1"      ;version taken from 'rflint/version.py'
                            revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/boakley/robotframework-lint")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32
           "180npmvzqync25b2scs878gv8q4y17dsinxyjcc10bw22msfap6b"))))
      (build-system python-build-system)
      (arguments
       `(#:phases
         (modify-phases %standard-phases
           (replace 'check
             (lambda _
               (invoke "python" "-m" "robot" "-A"
                       "tests/conf/default.args" "tests"))))))
      (propagated-inputs
       (list python-robotframework))
      (home-page "https://github.com/boakley/robotframework-lint/")
      (synopsis "Static analysis tool (linter) for Robot Framework")
      (description "This package provides the @code{rflint} command-line
utility, a static analysis tool (linter) for Robot Framework source files.")
      (license license:asl2.0))))

(define-public python-robotframework-pabot
  (package
    (name "python-robotframework-pabot")
    (version "4.2.0")
    (source
     (origin
       ;; There are no tests in the PyPI archive.
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/mkorpela/pabot")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1q4vxrmkximyxk735d7payypx4w3qqdlldmg34frlnbkxrf40pxc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; XXX: Maybe it's a bad idea to skip these tests which
                    ;; failing assertions highlight incomparability issues.
                    ;;
                    ;; 93 passed, 23 deselected, 11 warnings
                    (list "not test_argumentfile_outputs"
                          "test_dependency_ok"
                          "test_longnames_in_tests"
                          "test_multiple_dependencies_ok"
                          "test_orders"
                          "test_pabotprerunmodifier"
                          "test_pabotprerunmodifier_with_prerunmodifier"
                          "test_pabotprerunmodifier_with_testlevelsplit"
                          "test_pabotprerunmodifier_with_testlevelsplit_and_"
                          "test_parallel_execution"
                          "test_parallel_execution_with_testlevelsplit"
                          "test_pre_run_with_new_name"
                          "test_pre_run_with_new_tag"
                          "test_run_dir_2_then_dir_3"
                          "test_run_dir_3_then_dir_2"
                          "test_run_root_then_suite_4_then_dir_1_then_dir_4"
                          "test_sleep_test_cases_and_group"
                          "test_stdout_should_display_passed_test"
                          "test_stdout_should_display_passed_test"
                          "test_stdout_should_display_passed_test_and_not_"
                          "test_testlevelsplit_output_task_order"
                          "test_too_big_testname"
                          "test_two_orders")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* "setup.cfg"
                ;; natsort>=8.2.0
                ((">=8.2.0") "")))))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-natsort
           python-robotframework
           python-robotframework-stacktrace))
    (home-page "https://pabot.org")
    (synopsis "Parallel test runner for Robot Framework")
    (description "Pabot is a parallel executor for Robot Framework tests.")
    (license license:asl2.0)))

(define-public python-robotframework-stacktrace
  (package
    (name "python-robotframework-stacktrace")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/MarketSquare/robotframework-stacktrace")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nkzcgc1xwbx8d5qq47aj23qa7dn1ml033bjwrgqh55x3miphlcq"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: The test suite fails (see:
     ;; https://github.com/MarketSquare/robotframework-stacktrace/issues/4).
     (list
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (substitute* "setup.py"
                (("VERSION =.*")
                 (string-append "VERSION = '" #$version "'"))))))))
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-robotframework))
    (home-page "https://github.com/MarketSquare/robotframework-stacktrace")
    (synopsis "Robot Framework listener to print a stack trace on error")
    (description "StackTrace is a Robot Framework listener that prints a stack
trace directly to the terminal to ease debugging.")
    (license license:asl2.0)))

(define-public python-robotframework-sshlibrary
  (package
    (name "python-robotframework-sshlibrary")
    (version "3.8.0")
    ;; There are no tests in the PyPI archive.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/SSHLibrary")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fn72hw7xacjjpl4dd6wynh2x63i9rk8iqhj3v640db21qpcnbkw"))
       (patches (search-patches
                 "python-robotframework-sshlibrary-rf5-compat.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'build-and-install-doc
            (lambda _
              (let ((doc (string-append #$output:doc
                          "/share/doc/robotframework-sshlibrary")))
                (invoke "chmod" "-R" "+w" "docs")
                (invoke "invoke" "kw-docs" "project-docs")
                (mkdir-p doc)
                (for-each delete-file
                          (find-files "docs" "\\.rst"))
                (copy-recursively "docs" doc))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Some tests require an SSH server; we remove them.
                (delete-file "utest/test_client_api.py")
                (delete-file "utest/test_scp.py")
                (invoke "python" "utest/run.py")))))))
    (propagated-inputs
     (list python-robotframework python-paramiko python-scp))
    (native-inputs
     (list openssh
           which
           ;; To generate the documentation
           python-docutils
           python-invoke
           python-pygments
           python-rellu
           python-setuptools))
    (outputs '("out" "doc"))
    (home-page "https://github.com/robotframework/SSHLibrary")
    (synopsis "Robot Framework library for SSH and SFTP")
    (description
     "SSHLibrary is a Robot Framework library providing support for SSH and
SFTP.  It has the following main usages:
@itemize @bullet
@item Executing commands on the remote machine, either blocking or non-blocking.
@item Writing and reading in an interactive shell.
@item Transferring files and directories over SFTP.
@item Ensuring that files and directories exist on the remote machine.
@end itemize")
    (license license:asl2.0)))

(define-public python-robotframework-pythonlibcore
  (package
    (name "python-robotframework-pythonlibcore")
    (version "4.4.1")
    (source
     (origin
       (method git-fetch)               ;no tests in pypi archive
       (uri (git-reference
             (url "https://github.com/robotframework/PythonLibCore")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hjayjq5wrgajs56nf85y5wqh76jbjfbsz40bam315l3kzmj45g5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "utest/run.py")))
    (native-inputs
     (list python-approvaltests
           python-pytest
           python-pytest-cov
           python-pytest-mockito
           python-robotframework
           python-setuptools))
    (home-page "https://github.com/robotframework/PythonLibCore")
    (synopsis "Robot Framework Python library tools")
    (description
     "PythonLibCore provides tools for creating larger test libraries for
Robot Framework using Python.  The Robot Framework hybrid and dynamic library
APIs give more flexibility for library than the static library API, but they
also set requirements for libraries which need to be implemented in the
library side.  PythonLibCore eases the problem by providing a simpler
interface and by handling all the requirements towards the Robot Framework
library APIs.")
    (license license:asl2.0)))

(define-public python-robotframework-seleniumlibrary
  (package
    (name "python-robotframework-seleniumlibrary")
    (version "6.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/robotframework/SeleniumLibrary")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "093kcmwvh72n22sj1psx4dyjj87xrzz2622ygpkavrhmd9r2a9jg"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=utest/test/keywords/test_firefox_profile_parsing.py"
              "-k" (string-join
                    (list "not test_create_firefox_with_options"
                          "test_create_headless_firefox_with_options"
                          "test_create_driver_firefox")
                    " and not "))))
    (native-inputs
     (list python-approvaltests
           python-pytest
           python-pytest-mockito
           python-setuptools))
    (propagated-inputs
     (list python-click
           python-robotframework
           python-robotframework-pythonlibcore
           python-selenium))
    (home-page "https://github.com/robotframework/SeleniumLibrary")
    (synopsis "Web testing library for Robot Framework")
    (description "SeleniumLibrary is a web testing library for Robot Framework
that utilizes the Selenium tool internally.")
    (license license:asl2.0)))

(define-public python-robotframework-seleniumscreenshots
  (package
    (name "python-robotframework-seleniumscreenshots")
    (version "0.9.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url
              "https://github.com/MarketSquare/robotframework-seleniumscreenshots")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gal4ifibk2bj1qgppcs6vmjgjvz47nq4d4gqvyd70vpyf9iw342"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: The tests require a relatively complicated setup configured in
     ;; their CI with Nix (!).
     `(#:tests? #f))
    (native-inputs (list python-setuptools))
    (propagated-inputs
     (list python-robotframework python-robotframework-seleniumlibrary))
    (home-page
     "https://github.com/MarketSquare/robotframework-seleniumscreenshots")
    (synopsis
     "Robot Framework library for annotating and cropping screenshots")
    (description
     "The SeleniumScreenshots library for Robot Framework provides keywords
for annotating and cropping screenshots taken with SeleniumLibrary.  It is
useful for scripting automatically updated screenshots for documentation or
for visual regression testing purposes.")
    (license license:bsd-3)))

(define-public python-rstr
  (package
   (name "python-rstr")
   (version "3.2.2")
   (source
    (origin
      (method git-fetch)
      (uri (git-reference
            (url "https://github.com/leapfrogonline/rstr")
            (commit version)))
      (file-name (git-file-name name version))
      (sha256
       (base32 "1z9d660jnv72jn8qzpa9hddpv5f953js8i75hfhkcw68vmdfndnr"))))
   (build-system pyproject-build-system)
   (arguments
    (list
     #:phases
     #~(modify-phases %standard-phases
         (add-before 'build 'pretend-version
           ;; The version string is usually derived via setuptools-scm, but
           ;; without the git metadata available, the version string is set to
           ;; '0.0.0'.
           (lambda _
             (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
   (native-inputs (list python-pytest
                        python-setuptools
                        python-setuptools-scm
                        python-wheel))
   (home-page "https://github.com/leapfrogonline/rstr")
   (synopsis "Generate random strings in Python")
   (description "This package provides a python module for generating
random strings of various types.  It could be useful for fuzz testing,
generating dummy data, or other applications.  It has no dependencies
outside the standard library.")
   (license license:bsd-3)))

(define-public python-scp
  (package
    (name "python-scp")
    (version "0.15.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jbardin/scp.py")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03mdkiwfxvi1xfsw9qjdjf0jgljs991jn29lia9fka68x1ngwnw9"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;tests require an SSH server
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-paramiko))
    (home-page "https://github.com/jbardin/scp.py")
    (synopsis "SCP protocol module for Python and Paramiko")
    (description
     "The scp module extends the Paramiko library to send and receive files
via the SCP1 protocol, as implemented by the OpenSSH @command{scp} program.")
    (license license:gpl2+)))

(define-public python-rst-linker
  (package
    (name "python-rst-linker")
    (version "2.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jaraco/rst.linker")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pcnhib881p0vgm0s8jj6inzzs98raz70sc2z6m6wlgrj9ivv5jj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs (list python-jaraco-context))
    (native-inputs
     (list python-path
           python-jaraco-vcs
           python-pytest
           python-pytest-subprocess
           python-setuptools-scm
           python-setuptools))
    (home-page "https://github.com/jaraco/rst.linker")
    (synopsis "Sphinx plugin to add links and timestamps")
    (description
     "rst.linker automatically replaces text by a reStructuredText external
reference or timestamps.  It's primary purpose is to augment the changelog,
but it can be used for other documents, too.")
    (license license:expat)))

(define-public python-feedgenerator
  (package
    (name "python-feedgenerator")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "feedgenerator" version))
       (sha256
        (base32
         "179bshnb0ssx7pspzbyaqvhi5w3c3hb15cingh4py8px50zz4xgh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-cov python-setuptools python-wheel))
    (propagated-inputs
     (list python-pytz))
    (home-page "https://github.com/getpelican/feedgenerator")
    (synopsis
     "Standalone version of Django's Atom/RSS feed generator")
    (description
     "Feedgenerator-py3k is a standalone version of Django's feedgenerator,
which can produce feeds in RSS 2.0, RSS 0.91, and Atom formats.")
    (license license:bsd-3)))

(define-public python-lsp-jsonrpc
  (package
    (name "python-lsp-jsonrpc")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python-lsp-jsonrpc" version))
       (sha256
        (base32
         "04n95h0cqnsrdyh1gv0abh2i5ynyrq2wfqpppx9djp7mxr9y9226"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-coverage
           python-pycodestyle
           python-pyflakes
           python-pylint
           python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-ujson))
    (home-page "https://github.com/python-lsp/python-lsp-jsonrpc")
    (synopsis "JSON RPC 2.0 server library")
    (description
     "This package provides a JSON RPC 2.0 server library for Python.")
    (license license:expat)))

(define-deprecated-package python-jsonrpc-server
  python-lsp-jsonrpc)

(define-public python-pydantic
  (package
    (name "python-pydantic")
    (version "1.10.19")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/samuelcolvin/pydantic")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0swcpfq1y0h5dcj82idls8k5la4xh4c0vz47y7jci2qass8gjffc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; One test fails with  not equal assertion.
      #~(list "--deselect=tests/test_validators.py::test_assert_raises_validation_error")))
    (native-inputs
     (list python-pytest
           python-pytest-mock
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/samuelcolvin/pydantic")
    (synopsis "Python data validation and settings management")
    (description
     "Pydantic enforces type hints at runtime, and provides user friendly
errors when data is invalid.")
    (license license:expat)))

(define-public python-pydantic-2
  (package
    (inherit python-pydantic)
    (name "python-pydantic")
    (version "2.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydantic" version))
       (sha256
        (base32 "01jg4ll2py05izm7s9hlv5xbxcsp26bvb2585gzf8vfs4fbjxwc2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_docs.py"   ; no pytest_examples
              "--ignore-glob=tests/benchmarks/*"
              ;; Unimportant difference in one test's error message.
              "--ignore=tests/test_networks.py")))
    (native-inputs
     (list tzdata-for-tests
           python-dirty-equals
           python-hatch-fancy-pypi-readme
           python-hatchling
           python-jsonschema
           python-pytest
           python-pytest-benchmark
           python-pytest-mock))
    (propagated-inputs
     (list python-annotated-types
           python-pydantic-core
           python-rich
           python-typing-extensions))))

(define-public python-pydantic-core
  (package
    (name "python-pydantic-core")
    (version "2.27.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydantic_core" version))
       (sha256
        (base32 "0fgv3xdn4n7a606sjz8b15cnzyqy3pspycvjc1r0bvhz9id6w0pb"))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:imported-modules `(,@%cargo-build-system-modules
                           ,@%pyproject-build-system-modules)
      #:modules '((guix build cargo-build-system)
                  ((guix build pyproject-build-system) #:prefix py:)
                  (guix build utils))
      #:phases
      (with-extensions (list (pyproject-guile-json))
      #~(modify-phases %standard-phases
          (add-after 'build 'build-python-module
            (assoc-ref py:%standard-phases 'build))
          (add-after 'build-python-module 'install-python-module
            (assoc-ref py:%standard-phases 'install))))
      #:install-source? #false))
    (native-inputs
     (list maturin python-typing-extensions python-wrapper))
    (propagated-inputs
     (list python-typing-extensions))
    (inputs (cargo-inputs 'python-pydantic-core))
    (home-page "https://github.com/pydantic/pydantic-core")
    (synopsis "Core validation logic for pydantic")
    (description "This package provides the core functionality for pydantic
validation and serialization.")
    (license license:expat)))

(define-public python-pydantic-cli
  (package
    (name "python-pydantic-cli")
    (version "9.1.0")
    (source
     (origin
       (method git-fetch)               ;for tests
       (uri (git-reference
             (url "https://github.com/mpkocher/pydantic-cli")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1rfffz4kasjihys8qgnvjb8cwm0dycsdj7qnggi9372b9q1ng4zg"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-pydantic-2))
    (native-inputs
     (list python-hatchling python-pytest))
    (home-page "https://github.com/mpkocher/pydantic-cli")
    (synopsis "Turn Pydantic defined data models into CLI tools")
    (description
     "@code{python-pydantic} enables specifying @acronym{CLI, Command Line
Interfaces} via data models provided in the JSON format.")
    (license license:expat)))

(define-public python-pydantic-settings
  (package
    (name "python-pydantic-settings")
    (version "2.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydantic_settings" version))
       (sha256
        (base32 "14zcbl32m53zfh054bkqk4jcjp72q1wa0w5z5wygnjz66nnwmj8h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-append
                    ;; Disable tests requiring python-ruff.
                    "not test_docs_examples[docs/index.md:24-83]"
                    " and not test_docs_examples[docs/index.md:113-137]"
                    " and not test_docs_examples[docs/index.md:148-156]"
                    " and not test_docs_examples[docs/index.md:173-183]"
                    " and not test_docs_examples[docs/index.md:193-201]"
                    " and not test_docs_examples[docs/index.md:212-243]"
                    " and not test_docs_examples[docs/index.md:286-317]"
                    " and not test_docs_examples[docs/index.md:331-372]"
                    " and not test_docs_examples[docs/index.md:430-439]"
                    " and not test_docs_examples[docs/index.md:453-459]"
                    " and not test_docs_examples[docs/index.md:514-522]"
                    " and not test_docs_examples[docs/index.md:547-549]"
                    " and not test_docs_examples[docs/index.md:553-585]"
                    " and not test_docs_examples[docs/index.md:620-645]"
                    " and not test_docs_examples[docs/index.md:654-732]"
                    " and not test_docs_examples[docs/index.md:738-772]")
              "--ignore=tests/test_docs.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* "pyproject.toml"
                ;; hatchling.build failed on this line with error:
                ;; ValueError: Unknown classifier in field
                ;; `project.classifiers`: Framework :: Pydantic :: 2
                (("'Framework :: Pydantic :: 2',") "")
                ;; python-dotenv>=0.21.0
                ((">=0.21.0") ">=0.20.0"))))
          (add-before 'check 'set-home
            (lambda _
              ;; FileNotFoundError: [Errno 2] No such file or directory:
              ;; '/homeless-shelter/
              (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-dotenv python-pydantic-2))
    (native-inputs
     (list python-hatchling
           python-pytest
           python-pytest-examples
           python-pytest-mock))
    (home-page "https://docs.pydantic.dev/latest/usage/pydantic_settings/")
    (synopsis "Settings management using Pydantic")
    (description
     "Pydantic Settings provides optional Pydantic features for loading a
settings or config class from environment variables or secrets files.")
    (license license:expat)))

(define-public python-pydoc-markdown
  (package
    (name "python-pydoc-markdown")
    (version "4.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydoc_markdown" version))
       (sha256
        (base32 "02vzlrd18r8wi0b64vq2gnbhaadysg9rnbylf9sf2v9q65z94v7v"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false ;there are none
      #:phases
      '(modify-phases %standard-phases
         ;; This is probably not a good idea, but it wants a rather old
         ;; version of docstring-parser.
         (add-after 'unpack 'relax-requirements
           (lambda _
             (substitute* "pyproject.toml"
               (("docstring-parser = .*")
                "docstring-parser = \"^0\"\n")))))))
    (propagated-inputs (list python-click
                             python-databind-core
                             python-databind-json
                             python-docspec
                             python-docspec-python
                             python-docstring-parser
                             python-jinja2
                             python-nr-util
                             python-pyyaml
                             python-requests
                             python-tomli
                             python-tomli-w
                             python-watchdog
                             python-yapf))
    (native-inputs (list python-poetry-core))
    (home-page "https://pypi.org/project/pydoc-markdown/")
    (synopsis "Create Python API documentation in Markdown format")
    (description "Pydoc-Markdown is a tool to create Python API documentation
in Markdown format.  Instead of executing your Python code like so many other
documentation tools, it parses it using docspec instead.")
    (license license:expat)))

;; XXX: The project is deprecated upstream, still in use by some packages,
;; consider to remove when nothing depends on it.
(define-public python-pydocstyle
  (package
    (name "python-pydocstyle")
    (version "6.3.0")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/PyCQA/pydocstyle")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1aabvnxmy939y5b7jpnygpnkgbi4id9j461v7bwzxwdmdffnnd1j"))
       (patches (search-patches
                 "python-pydocstyle-add-support-for-pep701.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; It tries to install with pip.
      #:test-flags #~(list "--ignore=src/tests/test_integration.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (substitute* "pyproject.toml"
                (("0.0.0-dev") #$version)))))))
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-tomli))
    (propagated-inputs
     (list python-six
           python-snowballstemmer))
    (home-page "https://github.com/PyCQA/pydocstyle/")
    (synopsis "Python docstring style checker")
    (description
     "This package provides a style checker for the Python Language
Server (PLS).")
    (license license:expat)))

(define-public python-lsp-server
  (package
    (name "python-lsp-server")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "python_lsp_server" version))
       (sha256
        (base32
         "0s8dipxkdshg27a7a2nnkgg3kmksvbkfa7g39n310k6g7sv2d3rp"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-c" "/dev/null"           ;avoid coverage
             "--ignore-glob" "**/test_autopep8_format.py"  ;avoid autopep8 dep
             "-k"
             (string-append
              "not test_concurrent_ws_requests "  ; flaky
              "and not test_pyqt_completion "  ; avoid pyqt5
              "and not test_pandas_completion"))  ; avoid pandas
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (propagated-inputs
     (list python-black
           python-docstring-to-markdown
           python-importlib-metadata
           python-jedi
           python-lsp-jsonrpc
           python-pluggy
           python-pycodestyle
           python-pydocstyle
           python-ujson
           python-whatthepatch
           python-yapf))
    (native-inputs
     (list python-flake8
           python-flaky
           python-matplotlib
           python-pylint
           python-pytest
           python-rope
           python-setuptools
           python-setuptools-scm
           python-websockets
           python-wheel))
    (home-page "https://github.com/python-lsp/python-lsp-server")
    (synopsis "Python implementation of the Language Server Protocol")
    (description
     "The Python Language Server @command{pylsp} is an implementation of the
Python 3 language specification for the Language Server Protocol (LSP).
This tool is used in text editing environments to provide a complete
and integrated feature-set for programming Python effectively.")
    (license license:expat)))

(define-deprecated-package python-language-server
  python-lsp-server)

(define-public python-black
  (package
    (name "python-black")
    (version "25.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "black" version))
       (sha256
        (base32
         "0ri6xhcrm39c7q5si4wvx1fkq98mvbl4larmj4rxfai2s5f6sj9k"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; On the build farm we run out of resources if we let the build system
      ;; autodetect the number of parallel processes.
      '(list "--numprocesses" (number->string (min (parallel-job-count) 8)))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'patch-source-shebangs 'use-absolute-file-names
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* (find-files "tests" "\\.py$")
               (("#!/usr/bin/env python3")
                (string-append
                 "#!" (search-input-file inputs "/bin/python3")))))))))
    (propagated-inputs
     (list python-aiohttp
           python-click
           python-mypy-extensions
           python-packaging
           python-pathspec
           python-platformdirs))
    (native-inputs
     (list python-pytest
           python-pytest-xdist
           python-hatch-fancy-pypi-readme
           python-hatch-vcs
           python-hatchling))
    (home-page "https://github.com/psf/black")
    (synopsis "The uncompromising code formatter")
    (description "Black is the uncompromising Python code formatter.")
    (license license:expat)))

(define-public python-black-macchiato
  (package
    (name "python-black-macchiato")
    (version "1.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/wbolster/black-macchiato")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0lc9w50nlbmlzj44krk7kxcia202fhybbnwfh77xixlc7vb4rayl"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'ignore-failing-tests
            (lambda _
              (substitute* "test_macchiato.py"
                (("\\(.*\\n'\\)," all)
                 (string-append "# " all))))))))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-black))
    (home-page "https://github.com/wbolster/black-macchiato")
    (synopsis "Partial @code{python-black} formatting")
    (description
     "This package is built on top the @code{python-black} code formatter to
enable formatting of partial files.")
    (license license:bsd-3)))

(define-public python-blinker
  (package
    (name "python-blinker")
    (version "1.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "blinker" version))
       (sha256
        (base32
         "1gs5aigi8v8k4cymm06gdgaylv5yps6yk5n8gigf9v5blxjj5kml"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pytest
           python-pytest-asyncio))
    (home-page "https://pythonhosted.org/blinker/")
    (synopsis "Fast, simple object-to-object and broadcast signaling")
    (description
     "Blinker provides a fast dispatching system that allows any number of
interested parties to subscribe to events, or \"signals\".")
    (license license:expat)))

(define-public pelican
  (package
    (name "pelican")
    (version "4.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pelican" version))
       (sha256
        (base32 "1n4b8y4vvycxhwmi3z5i96bh0d2rg1mk1hdc6cbkk3c1gd4380mr"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "-k" (string-append
                                 ;; These tests failed with AssertionError.
                                 "not test_typogrify_ignore_filters"
                                 " and not test_typogrify_ignore_tags"
                                 " and not test_error_on_warning"))))
    (native-inputs
     (list python-anyio
           python-beautifulsoup4
           python-lxml
           python-pdm-backend
           python-pytest
           python-smartypants
           python-typogrify))
    (inputs
     (list python-blinker
           python-dateutil
           ;; Ignoring `guix lint` warning as python-docutils is used to support
           ;; reStructuredText processing at runtime.
           python-docutils
           python-feedgenerator
           python-jinja2
           python-ordered-set
           python-pygments
           python-rich
           python-tzdata
           python-unidecode
           python-watchfiles))
    (home-page "https://blog.getpelican.com/")
    (synopsis "Python-based static site publishing system")
    (description
     "Pelican is a tool to generate a static blog from reStructuredText,
Markdown input files, and more.  Pelican uses Jinja2 for templating
and is very extensible.")
    (license license:agpl3+)))

(define-public python-cykhash
  (package
    (name "python-cykhash")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cykhash" version))
       (sha256
        (base32 "1xwpxff4whfvkwvcyhzhdcj5zzq89vvdjmnqy664s4a9yp4lnydl"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;no tests in PyPI, 2.0.1 is not tagged in git
    (native-inputs
     (list python-cython
           python-setuptools))
    (home-page "https://github.com/realead/cykhash")
    (synopsis "Khash-sets and maps")
    (description
     "This package is a Cython wrapper for khash-sets/maps.  It brings
functionality of
@url{https://github.com/attractivechaos/klib/blob/master/khash.h, khash} to
Python and Cython and can be used seamlessly in numpy or pandas.  Numpy's
world is lacking the concept of a (hash-)set.  This shortcoming is fixed and
efficient (memory- and speedwise compared to pandas) @code{unique} and
@code{isin} are implemented.  Python-set/dict have a big memory-footprint.
For some datatypes the overhead can be reduced by using khash by factor 4-8.")
    (license license:expat)))

(define-public python-cython
  ;; TODO: Move to python-build.
  (package
    (name "python-cython")
    (version "3.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cython" version))
       (sha256
        (base32 "108k6gsn63qkz98xhnm4440ir9ab0lxmw0gcrpz2sxm67yapmgvb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags
      #~(list "runtests.py"
              "-vv"
              "-j" (number->string (parallel-job-count))
              "-x" (string-join
                    (list "annotate_html"
                          "Debugger"
                          ;; It introduces cycle.
                          "numpy_test"
                          ;; It fails with AssertionError: Failed doctest test
                          ;; for complex_numbers_cpp.double_abs.
                          "complex_numbers_cpp"
                          ;; This test fails when running on 24 cores.
                          "cpp_stl_conversion"
                          #$@(if (not (target-64bit?))
                                 ;; XXX: On 32-bit architectures, running the
                                 ;; parallel tests fails on many-core systems.
                                 ;; See: <https://github.com/cython/cython/issues/2807>.
                                 '("run.parallel"
                                   ;; Test cpp_stl_any.cast_test fails.
                                   ;; See: <https://github.com/cython/cython/issues/5928>.
                                   "cpp_stl_any")
                                 '())
                          #$@(if (system-hurd?)
                                 '("test_class_ref"
                                   "test_compiler_directives"
                                   "test_lang_version")
                                 '()))
                    "|"))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              ;; Disable compiler optimizations to greatly reduce the running
              ;; time of the test suite.
              (setenv "CFLAGS" "-O0")
              ;; Some tests require access to "$HOME/.cython".
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list libxcrypt
           python-setuptools
           python-wheel))
    ;; we need the full python package and not just the python-wrapper
    ;; because we need libpython3.3m.so
    (inputs
     (list python))
    (home-page "https://cython.org/")
    (synopsis "C extensions for Python")
    (description "Cython is an optimising static compiler for both the Python
programming language and the extended Cython programming language.  It makes
writing C extensions for Python as easy as Python itself.")
    (license license:asl2.0)))

(define-public python-cython-0
  (package
    (inherit python-cython)
    ;; It's the latest version of 0.29. See
    ;; <https://github.com/cython/cython/blob/0.29.37/CHANGES.rst>.
    (version "0.29.37")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Cython" version))
       (sha256
        (base32 "1ysca2r23h12ai9wrym4ci0nvgwm3lfijrpj9xfyxbclvnkd84zq"))))
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags
      #~(list "runtests.py"
              "-vv"
              "-j" (number->string (parallel-job-count))
              ;; XXX: On 32-bit architectures, running the parallel tests
              ;; fails on many-core systems, see
              ;; <https://github.com/cython/cython/issues/2807>.
              #$@(if (not (target-64bit?))
                     #~("-x" "run.parallel")
                     #~())
              #$@(if (system-hurd?)
                     #~("-x" "test_class_ref"
                        "-x" "test_compiler_directives"
                        "-x" "test_lang_version")
                     #~())
              ;; This test fails when running on 24 cores.
              "-x" "cpp_stl_conversion")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            ;; some tests require access to "$HOME/.cython"
            (lambda _
              (setenv "HOME" "/tmp")
              ;; Disable compiler optimizations to greatly reduce the running
              ;; time of the test suite.
              (setenv "CFLAGS" "-O0"))))))))

;; It may be removed after 2026-01-24.
(define-deprecated/public-alias python-cython-3 python-cython)

;; NOTE: when upgrading numpy please make sure that python-numba,
;; python-pandas and python-scipy still build, as these three packages are
;; often used together.
(define-public python-numpy
  (package
    (name "python-numpy")
    ;; XXX: Starting from v1.26.0 the project includes a vendored-meson which
    ;; is needed for SIMD and BLAS/LAPACK features that are not yet available
    ;; in upstream Meson.
    ;;
    ;; See:
    ;; - URL <https://raw.githubusercontent.com/numpy/numpy>
    ;; - commit :: 2f3549c9d7c5048621568e431c86bc7530742723
    ;; - file <doc/source/building/understanding_meson.rst>
    (version "1.26.4") ;; This is the last planned release in the 1.26.x series.
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://github.com/numpy/numpy/releases/download/v"
             version "/numpy-" version ".tar.gz"))
       (sha256
        (base32
         "0410j6jfz1yzm5s0v0yrc1j0q6ih4322357and7arr0jxnlsn0ia"))
       (patches (search-patches "python-numpy-gcc-14.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:modules '((guix build utils)
                  (guix build pyproject-build-system)
                  (ice-9 format))
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: It fails with an issue "'fenv_t' has not been declared..."
          ;; when the gfortran header is used.  Remove gfortran from
          ;; CPLUS_INCLUDE_PATH as a workaround.  Taken from
          ;; <https://issues.guix.gnu.org/73439#45>.
          (add-after 'set-paths 'hide-gfortran
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((gfortran (assoc-ref inputs "gfortran")))
                (setenv "CPLUS_INCLUDE_PATH"
                        (string-join
                         (delete (string-append gfortran "/include/c++")
                                 (string-split (getenv "CPLUS_INCLUDE_PATH") #\:))
                         ":")))))
          (add-before 'build 'relax-gcc-14-strictness
            (lambda _
              (setenv "CFLAGS"
                      "-g -O2 -Wno-error=implicit-function-declaration")))
          (add-before 'build 'parallelize-build
            (lambda _
              (setenv "NPY_NUM_BUILD_JOBS"
                      (number->string (parallel-job-count)))))
          (add-before 'build 'configure-blas
            (lambda* (#:key inputs #:allow-other-keys)
              (call-with-output-file "site.cfg"
                (lambda (port)
                  (format port
                          "\
[openblas]
libraries = openblas
library_dirs = ~a/lib
include_dirs = ~:*~a/include~%"
                          (dirname (dirname
                                    (search-input-file
                                     inputs "include/openblas_config.h"))))))))
          (add-before 'build 'fix-executable-paths
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Make /gnu/store/...-bash-.../bin/sh the default shell,
              ;; instead of /bin/sh.
              (substitute* "numpy/distutils/exec_command.py"
                (("'/bin/sh'")
                 (format #f "~s" (search-input-file inputs "bin/bash"))))
              ;; Don't try to call '/bin/true' specifically.
              (substitute* "numpy/core/tests/test_cpu_features.py"
                (("/bin/true") (search-input-file inputs "bin/true")))))
          (replace 'check
            (lambda* (#:key tests? outputs inputs #:allow-other-keys)
              (when tests?
                (invoke "./runtests.py" "-vv" "--no-build" "--mode=fast"
                        "-j" (number->string (parallel-job-count))
                        ;; Contrary to scipy, the runtests.py script of numpy
                        ;; does *not* automatically provide -n when -j is used
                        ;; (see: https://github.com/numpy/numpy/issues/21359).
                        "--" "-n" (number->string (parallel-job-count))
                        ;; Disable Pytest Warnings, they are resolved in the
                        ;; latest 1.x.x: pytest.PytestRemovedIn9Warning: Marks
                        ;; applied to fixtures have no effect,
                        ;; DeprecationWarning.
                        "-p" "no:warnings"
                        "-k" (string-append
                              ;; These tests may fail on 32-bit systems (see:
                              ;; https://github.com/numpy/numpy/issues/18387).
                              "not test_float_remainder_overflow "
                              "and not test_pareto "
                              ;; The 'test_rint_big_int' test fails on older
                              ;; x86_64 CPUs such as the Core 2 Duo (see:
                              ;; https://github.com/numpy/numpy/issues/22170).
                              "and not test_rint_big_int "
                              ;; They fail to detect compiler.
                              "and not test_compile1 "
                              "and not test_compile2 "
                              ;; Due to disabled warnings
                              "and not test_getattr_warning "
                              "and not test_integer_signs "
                              "and not test_implicit_cast_float_to_int_fails "
                              "and not test_integer_signs "
                              ;; The huge_array test is too large for 32-bit (see:
                              ;; https://bugs.gentoo.org/843599 and
                              ;; https://bugs.gentoo.org/846548).
                              ;; TestKind.test_all is a Fortran type failure
                              ;; that may be toolchain or environment related.
                              #$@(if (or (target-x86?) (target-arm32?))
                                     `(" and not test_identityless_reduction_huge_array"
                                       " and not (TestKind and test_all)")
                                   '())
                              ;; This test fails with a Fortran failure (16
                              ;; expected but got -1), due to the fact that it
                              ;; requires a 64-bit system.
                              #$@(if (or (target-x86-32?) (target-arm32?))
                                     `(" and not test_int")
                                     '())
                              ;; These tests fail when building from aarch64-linux.
                              #$@(if (target-arm32?)
                                   `(" and not test_features"
                                     " and not test_unary_spurious_fpexception")
                                   '())
                              ;; These tests seem to fail on machines without
                              ;; an FPU is still under investigation upstream.
                              ;; https://github.com/numpy/numpy/issues/20635
                              #$@(if (target-riscv64?)
                                   `(" and not test_fp_noncontiguous")
                                   '())
                              ;; They also fail with gcc-14
                              " and not test_float"
                              " and not test_fpclass"

                              ;; These tests fail with gcc-14
                              " and not test_context_locality"
                              " and not test_cosh"
                              " and not test_default_policy_singleton"
                              " and not test_exp_exceptions"
                              " and not test_half_fpe"
                              " and not test_owner_is_base"
                              " and not test_policy_propagation"
                              " and not test_set_policy"
                              " and not test_sinh"
                              " and not test_square_values"
                              " and not test_sum"
                              " and not test_switch_owner"
                              " and not test_thread_locality"))))))))
    (native-inputs
     (list meson-python
           pkg-config
           python-cython
           python-hypothesis
           python-mypy
           python-pytest
           python-pytest-xdist
           python-setuptools-67 ;see: <https://github.com/numpy/numpy/issues/27531>
           python-typing-extensions
           python-wheel-0.40
           ;; XXX: Avoid to: 'fenv_t' has not been declared in '::' 58 | using ::fenv_t;
           ;; See <https://github.com/numpy/numpy/issues/21075#issuecomment-1047976197>,
           ;; <https://github.com/numpy/numpy/issues/24318>.
           gcc                    ;fevn.h c[++] include must precede fortran's
           gfortran))
    (inputs (list bash openblas))
    (home-page "https://numpy.org")
    (synopsis "Fundamental package for scientific computing with Python")
    (description "NumPy is the fundamental package for scientific computing
with Python.  It contains among other things: a powerful N-dimensional array
object, sophisticated (broadcasting) functions, tools for integrating C/C++
and Fortran code, useful linear algebra, Fourier transform, and random number
capabilities.")
    (properties
     '((upstream-name . "numpy")))
    (license license:bsd-3)))

(define-public python-numpy-2
  (package
    (inherit python-numpy)
    (name "python-numpy")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "https://github.com/numpy/numpy/releases/download/v"
             version "/numpy-" version ".tar.gz"))
       (sha256
        (base32 "0aqx8hsw54wfp7iv0h0ljlpsygvmrmi3rjic6rsa6v92lhhaxj8y"))))
    (arguments
     (list
      #:modules '((guix build utils)
                  (guix build pyproject-build-system)
                  (ice-9 format))
      #:test-flags
      #~(list "-m" "not slow"
              "--numprocesses" (number->string (min 8 (parallel-job-count)))
              ;; See: <https://github.com/numpy/numpy/issues/27531>,
              ;;      <https://github.com/numpy/numpy/issues/17685>,
              ;;      <https://github.com/numpy/numpy/issues/17635>.
              "-k" "not test_api_importable")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-executable-paths
            (lambda _
              (substitute* "numpy/distutils/exec_command.py"
                (("'/bin/sh'")
                 (format #f "~s" (which "bash"))))
              (substitute* "numpy/meson.build"
                ;; Relay on python from the PATH instead of full reference
                ;; stored in built wheel.
                (("'py.full_path\\(\\)'") "'python'"))))
          (add-before 'build 'parallelize-build
            (lambda _
              (setenv "OMP_NUM_THREAD"
                      (number->string (parallel-job-count)))
              (setenv "NPY_NUM_BUILD_JOBS"
                      (number->string (parallel-job-count)))))
          ;; XXX: It fails with an issue "'fenv_t' has not been declared..."
          ;; when the gfortran header is used.  Remove gfortran from
          ;; CPLUS_INCLUDE_PATH as a workaround.  Taken from
          ;; <https://issues.guix.gnu.org/73439#45>.
          (add-after 'set-paths 'hide-gfortran
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((gfortran (assoc-ref inputs "gfortran")))
                (setenv "CPLUS_INCLUDE_PATH"
                        (string-join
                         (delete (string-append gfortran "/include/c++")
                                 (string-split (getenv "CPLUS_INCLUDE_PATH") #\:))
                         ":")))))
          (add-before 'build 'configure-blas
            (lambda* (#:key inputs #:allow-other-keys)
              (call-with-output-file "site.cfg"
                (lambda (port)
                  (format port
                          "[openblas]
libraries = openblas
library_dirs = ~a/lib
include_dirs = ~:*~a/include~%" #$(this-package-input "openblas"))))))
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                (with-directory-excursion #$output
                  (apply invoke "pytest" test-flags))))))))
    (native-inputs
     (list gfortran
           meson-python
           ninja
           pkg-config
           python-hypothesis
           python-mypy
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-setuptools
           python-typing-extensions
           python-wheel))))

(define-public python-numpysane
  (package
    (name "python-numpysane")
    (version "0.42")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dkogan/numpysane.git")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0s38fm88bmq08j5qxfka1wyjs2r9s9arzd1c3c4ixa8k3pisnihr"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (let* ((numpy (assoc-ref inputs "python-numpy"))
                     (site (site-packages inputs `(("out" . ,numpy)))))
                (substitute* "Makefile.common.header"
                ;; numpy 2.0 has this--but we don't use numpy 2.0.
                (("pkg-config --cflags-only-I numpy")
                 (format #f "echo -I~a/numpy/core/include" site))))))
          (replace 'check
            (lambda _
              (setenv "CC"
                      #$(cc-for-target))
              (invoke "make" "check"))))))
    (propagated-inputs (list python-numpy))
    (native-inputs (list perl pkg-config python-setuptools))
    (home-page "https://github.com/dkogan/numpysane")
    (synopsis "More-reasonable core functionality for numpy")
    (description
     "This package provides more-reasonable core functionality for numpy.

A lot of numpysane functionality is inspired by PDL (Perl Data Language).

numpysane has:
@itemize
@item easier broadcasting
@item nicer array manipulation
@item array concatenation
@item manipulation of dimensions
@item broadcast-aware inner product
@item broadcast-aware outer product
@item broadcast-aware 2-norm
@item broadcast-aware matrix multiplication
@end itemize
")
    (license license:lgpl2.0+)))

(define-public python-numpy-documentation
  (package
    (inherit python-numpy)
    (name "python-numpy-documentation")
    (arguments
     (list
      #:tests? #f                     ;we're only generating the documentation
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'avoid-external-deps
            (lambda _
              ;; XXX: Avoid theme-switcher to avoid sphinx error
              ;; TemplateNotFound('theme-switcher.html')
              ;; XXX: Avoid version-switcher because it depends on the value
              ;; of external https://numpy.org/doc/_static/versions.json
              (substitute* "doc/source/conf.py"
                (("\
\"navbar_end\": \\[\"theme-switcher\", \"version-switcher\", ")
                 "\"navbar_end\": ["))))
          (add-before 'build 'add-gnu-freefont-to-texmf
            (lambda _
              ;; XXX: The Sphinx-generated tex output specifies the GNU
              ;; FreeFont font to be searched via its extension, which uses
              ;; kpathsea instead of fontconfig and fail (see:
              ;; https://github.com/sphinx-doc/sphinx/issues/10347).  Create a
              ;; symlink to GNU FreeFont and add it to the TEXMF tree via
              ;; GUIX_TEXMF.
              (mkdir-p "texmf-dist/fonts/opentype/public")
              (symlink (string-append
                        #$(this-package-native-input "font-gnu-freefont")
                        "/share/fonts/opentype")
                       (string-append
                        (getcwd) "/"
                        "texmf-dist/fonts/opentype/public/gnu-freefont"))
              (setenv "GUIX_TEXMF" (string-append (getenv "GUIX_TEXMF") ":"
                                                  (getcwd) "/texmf-dist"))))
          (replace 'build
            (lambda _
              (chdir "doc")
              (let ((sphinxopts (string-append
                                 "SPHINXOPTS=-j"
                                 (number->string (parallel-job-count)))))
                ;; Do not treat warnings as errors.
                (substitute* "Makefile"
                  ((" -WT ") " -T "))
                (setenv "HOME" "/tmp")
                ;; Build the PDF documentation.
                (invoke "make" "latex-build" sphinxopts)
                ;; FIXME: PDF build fails
                ;; (invoke "make" "-C" "build/latex" "all-pdf" sphinxopts)
                ;; Build the HTML documentation
                (invoke "make" "html" sphinxopts)
                ;; Build the Info documentation.  The issues worked around
                ;; below can be tracked at
                ;; https://github.com/numpy/numpy/issues/12278.
                (substitute* "source/conf.py"
                  ;; The root document should be "index", not "contents".
                  (("\"contents\"") "'index'")
                  ;; Disable Sphinx extensions that produce broken Texinfo.
                  ((".*'numpydoc'.*") "")
                  ((".*'sphinx.ext.autodoc'.*") "")
                  ((".*'sphinx.ext.autosummary'.*") ""))
                (invoke "make" "info" sphinxopts))))
          (replace 'install
            (lambda _
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/numpy"))
                     (html (string-append doc "/html"))
                     (info (string-append data "/info")))
                ;; Install the HTML documentation.
                (mkdir-p html)
                (copy-recursively "build/html" html)
                ;; Install the PDF reference and user manuals.
                ;; FIXME:
                ;; (install-file "build/latex/numpy-ref.pdf" doc)
                ;; (install-file "build/latex/numpy-user.pdf" doc)
                ;; Install the info manual.
                (install-file "build/texinfo/numpy.info" info)
                (symlink (string-append html "/_images")
                         (string-append info "/numpy-figures"))))))))
    (native-inputs
     (list font-gnu-freefont
           perl
           python-breathe
           python-ipython
           python-matplotlib
           python-numpy
           python-numpydoc
           python-pandas
           python-pydata-sphinx-theme
           python-scipy                 ;used by matplotlib
           python-sphinx
           python-sphinx-design
           texinfo
           (texlive-local-tree
            (list texlive-cbfonts
                  texlive-cm-super
                  texlive-cmap
                  texlive-expdlist
                  texlive-fandol
                  texlive-greek-fontenc
                  texlive-latexmk
                  texlive-polyglossia
                  texlive-xetex
                  texlive-xindy))))
    (inputs '())
    (propagated-inputs '())
    (synopsis "Documentation for the @code{python-numpy} package")
    (description "This package provides the complete NumPy documentation in
the Texinfo, and HTML formats.")))

(define-public python-numpy-stl
  (package
    (name "python-numpy-stl")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numpy_stl" version))
       (sha256
        (base32 "0kgxhghl9j5caydb2a9g2n44zvffd94gb6abday0manxkkvw682s"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-cython
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy
           python-utils))
    (home-page "https://github.com/WoLpH/numpy-stl/")
    (synopsis "Read, write and modify binary/ASCII STL files library")
    (description
     "Library to make reading, writing and modifying both binary and ascii STL
files, file format native to the stereolithography CAD software created by 3D
Systems, easy.")
    (license license:bsd-3)))

(define-public python-npx
  (package
    (name "python-npx")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)               ; no source archive in PyPI
       (uri (git-reference
             (url "https://github.com/sigma-py/npx")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0a3rb3ydl13m1r48kdvnbi31566jxm10p36argkz5kjr2ilkrx8v"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-networkx
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy))
    (home-page "https://github.com/nschloe/npx")
    (synopsis "Extensions for NumPy")
    (description "NumPy is a large library used everywhere in scientific
computing.  That's why breaking backwards-compatibility comes at a
significant cost and is almost always avoided, even if the API of some
methods is arguably lacking.  This package provides drop-in wrappers
\"fixing\" those.")
    (license license:bsd-3)))

(define-public python-munch
  (package
    (name "python-munch")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "munch" version))
       (sha256
        (base32
         "0d928bdzm0d9s9f058xa72pywps2zjdgvhrp9rm22qqj8r8v2b2l"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-astroid
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/Infinidat/munch")
    (synopsis "Dot-accessible dictionary")
    (description "Munch is a dot-accessible dictionary similar to JavaScript
objects.")
    (license license:expat)))

(define-public python-colormath2
  (package
    (name "python-colormath2")
    (version "3.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/bkmgit/python-colormath2")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xxhmmx1mzjggapjmpz8v166lj86xrkq7kak83akcirnq0pz9ihv"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-networkx python-numpy))
    (native-inputs (list python-nose2 python-setuptools))
    (home-page "https://github.com/bkmgit/python-colormath2")
    (synopsis "Color math and conversion library")
    (description
     "This is a Python library for color math and conversions.")
    (license license:bsd-3)))

(define-public python-spectra
  (package
    (name "python-spectra")
    (version "0.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "spectra" version))
       (sha256
        (base32 "0gva48a1rn5yxj6dgy76dnndqaf09k5q2l9r41h2a66b84rf6c3a"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-colormath2))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/jsvine/spectra")
    (synopsis "Color scales and color conversion")
    (description
     "This package provides a Python library intended to make color math,
color scales, and color space conversion easy.  It has support for:

@enumerate
@item Color scales
@item Color ranges
@item Color blending
@item Brightening/darkening colors
@item Saturating/desaturating colors
@item Conversion to/from multiple color spaces.
@end enumerate\n")
    (license license:expat)))

(define-public python-pyspnego
  (package
    (name "python-pyspnego")
    (version "0.8.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyspnego" version))
              (sha256
               (base32
                "1ps34laa0kvvp33az173hp5l0hnk8cr0bfqmlgw64ry5cv09qjg0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-mock python-setuptools python-wheel))
    (propagated-inputs
     (list python-cryptography python-gssapi python-krb5 python-ruamel.yaml))
    (home-page "https://github.com/jborean93/pyspnego")
    (synopsis "Python SPNEGO library")
    (description "The @code{pyspnego} Python library handles Negotiate, NTLM,
Kerberos (SPNEGO) and CredSSP authentication.  It also includes a packet
parser that can be used to decode raw NTLM/SPNEGO/Kerberos tokens into a human
readable format.")
    (license license:expat)))

(define-public python-pygit2
  (package
    (name "python-pygit2")
    (version "1.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygit2" version))
       (sha256
        (base32 "1v34xdvh6i5cn5srwicvp0i2kvv8fzsv0v9p72ng081nsczmhgvr"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-cffi libgit2))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/libgit2/pygit2")
    (synopsis "Python bindings for libgit2")
    (description "Pygit2 is a set of Python bindings to the libgit2 shared library.")
    ;; GPL2.0 only, with linking exception.
    (license license:gpl2)))

(define-public python-pygit2-1.18
  (package/inherit python-pygit2
    (name "python-pygit2")
    (version "1.18.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pygit2" version))
       (sha256
        (base32 "0m8g8s72c0xwwayykpj1hf8c1wldhmg1sj8kgxdp2rf9c837xa7c"))))
    (propagated-inputs (list python-cffi libgit2-1.9))))

(define-public python-patiencediff
  (package
    (name "python-patiencediff")
    (version "0.2.15")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "patiencediff" version))
        (sha256
         (base32
          "012jjgkkpk563l1mgj2ax4z32h0l558adhr2qa3chfrfsgpi22fh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   ;; Fails because bin/patiencediff expects two files to diff
                   (delete 'sanity-check))))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://www.breezy-vcs.org/")
    (synopsis "Python implementation of the patiencediff algorithm")
    (description
     "This package contains a Python implementation of the @code{patiencediff}
algorithm.  Patiencediff provides a good balance of performance, nice output for
humans, and implementation simplicity.")
    (license license:gpl2+)))

(define-public python-merge3
  (package
    (name "python-merge3")
    (version "0.0.15")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/breezy-team/merge3")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0p52fdzra86d03p5gwz7wmb2pgzkv0frgdhhg9wfld8qr0611wp4"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/breezy-team/merge3")
    (synopsis "Python implementation of 3-way merge")
    (description "This Python library implements 3-way merge for text.")
    (license license:gpl2+)))

(define-public python-fancycompleter
  (package
    (name "python-fancycompleter")
    (version "0.9.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pdbpp/fancycompleter")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04gbnpm2m86wgigaqf03mphacawg203gdgpljx5xzax3vhm8qnxw"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-setup.py
            (lambda _
              (substitute* "setup.py"
                ((".*setupmeta.*")
                 "")
                (("versioning=.*")
                 (string-append "version='" #$version "',"))
                ((".*pyrepl.*")         ; broken on Python 3
                 "")))))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/pdbpp/fancycompleter")
    (synopsis "TAB completion library for Python")
    (description
     "@code{fancycompleter} is a module that adds TAB completion to the
interactive prompt.  It is an extension of the @code{rlcompleter} module from
the standard Python library.")
    (license license:bsd-3)))

(define-public python-ipdb
  (package
    (name "python-ipdb")
    (version "0.13.13")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/gotcha/ipdb")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "151cw13kgfgv2is7kx10zzwp17kkvzz6658srdhgnzm6d5kjjrxk"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-ipython python-toml python-decorator))
    (home-page "https://github.com/gotcha/ipdb")
    (synopsis "IPython-enhanced Python debugger (pdb)")
    (description
     "@code{ipdb} exports functions to access the IPython debugger, which
features tab completion, syntax highlighting, better tracebacks and better
introspection than Python's standard @command{pdb} debugger, with which it
shares the same interface.")
    (license license:bsd-3)))

(define-public python-ipfsspec
  (package
    (name "python-ipfsspec")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipfsspec" version))
       (sha256
        (base32 "1y4ad9schc76j2lynm7vpwi4q4jzi9vv843zfpisbp8zqgm0rr7l"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-m not local_gw"
             ;; Require local gateway
             "--ignore=test/test_gateway.py"
             ;; Require internet
             "--ignore=test/test_async.py"
             "--ignore=test/test_ipfs.py")))
    (propagated-inputs (list python-aiohttp python-fsspec python-requests))
    (native-inputs
     (list python-pytest
           python-pytest-asyncio
           python-setuptools
           python-wheel))
    (home-page "https://github.com/fsspec/ipfsspec")
    (synopsis "Read-only implementation of fsspec for IPFS")
    (description "This package provides a read-only implementation of
@code{fsspec} for IPFS.")
    (license license:expat)))

(define-public python-pdftotext
  (package
    (name "python-pdftotext")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pdftotext" version))
       (sha256
        (base32 "1ahs7c0qh3gyafxwrg9p4gcqwcrnc7y57adzm0ama52f2lcjnrf3"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (inputs (list poppler))
    (home-page "https://github.com/jalan/pdftotext")
    (synopsis "Simple PDF text extraction")
    (description "Pdftotext is a Python library of PDF text extraction.")
    (license license:expat)))

(define-public python-pluginbase
  (package
    (name "python-pluginbase")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mitsuhiko/pluginbase")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16c089ka8z4wb4mnx6a3dbvibibgzvawm8zgkp7ppadsgb3lc357"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "make" "test")))))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/mitsuhiko/pluginbase")
    (synopsis "Simple but flexible plugin system for Python")
    (description
     "PluginBase is a library useful in the development of flexible plugin
systems in Python.")
    (license license:bsd-3)))

(define-public python-node-semver
  (package
    (name "python-node-semver")
    (version "0.8.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/podhmo/python-node-semver")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0az6v4y8awl3dhgrfyikgz2vc8p1k15qwsq6yb8azp54m1fbh5hs"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/podhmo/python-node-semver")
    (synopsis "Python port of node-semver")
    (description
     "This module provides a Python version of node-semver, a semantic version
parser for Node.js.")
    (license license:expat)))

(define-public python-norns
  (package
    (name "python-norns")
    (version "0.1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/simonvh/norns")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x488xd2dp1clnzpb3gikx416g0fh1bjs25bwi0jmsvqmd80hmb0"))
       (patches
        (search-patches "python-norns-nose.patch"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-appdirs python-pynose python-pyyaml))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/simonvh/norns")
    (synopsis "Simple YAML-based config module")
    (description "This package provides a simple YAML-based config module.")
    (license license:expat)))

(define-public python-patch-ng
  (package
    (name "python-patch-ng")
    (version "1.18.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/conan-io/python-patch-ng")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1kr3h0bkcr02zyfsmwmxfv5b4b9vf3bhsvrlwp6cwrfy3q3qnyq8"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "tests/run_tests.py" "-v")))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/conan-io/python-patch-ng")
    (synopsis "Python library to parse and apply unified diffs")
    (description
     "Patch NG (New Generation) is a command and Python library to parse and
apply unified diffs.  It has features such as:
@itemize
@item automatic correction of common patch formatting corruption
@item patch format detection (SVN, Hg, Git)
@item nice diffstat histogram.
@end itemize")
    (license license:expat)))

(define-public python-numpydoc
  (package
    (name "python-numpydoc")
    (version "1.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numpydoc" version))
       (sha256
        (base32
         "0k2z3g4s3w39h1nd293542hl9qv55j29gcr3bkia0rr3ldsppnxh"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           '(list "numpydoc/tests"
                  ;; TODO: unclear why these fail.
                  "-k" "not test_MyClass and not test_my_function")))
    (propagated-inputs (list python-jinja2 python-sphinx))
    (native-inputs
     (list python-matplotlib
           python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel))
    (home-page "https://pypi.org/project/numpydoc/")
    (synopsis "Numpy's Sphinx extensions")
    (description "Sphinx extension to support docstrings in Numpy format.")
    (license license:bsd-2)))

(define-public python-numexpr
  (package
    (name "python-numexpr")
    (version "2.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "numexpr" version))
       (sha256
        (base32 "1aslzx2mzgk1xxxpm3mrvl8ngfxj7dxlz4q2xbqx20gh1bnzlfg2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                (with-directory-excursion #$output
                  (apply invoke "pytest" "-vv" test-flags))))))))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-numpy-2))
    (home-page "https://github.com/pydata/numexpr")
    (synopsis "Fast numerical expression evaluator for NumPy")
    (description
     "Numexpr is a fast numerical expression evaluator for NumPy.  With it,
expressions that operate on arrays are accelerated and use less memory than
doing the same calculation in Python.  In addition, its multi-threaded
capabilities can make use of all your cores, which may accelerate
computations, most specially if they are not memory-bounded (e.g. those using
transcendental functions).")
    (license license:expat)))

(define-public python-cycler
  (package
    (name "python-cycler")
    (version "0.12.1")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/matplotlib/cycler")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "061b8vxd2kp016pnwik9jg6zqng8khzmg0p298wrz65z50yh1gg4"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://matplotlib.org/cycler/")
    (synopsis "Composable keyword argument iterator")
    (description
     "When using @code{matplotlib} and plotting more than one line, it is
common to want to be able to want to be able to cycle over one or more artist
styles; but the plotting logic can quickly become involved.
To address this and enable easy cycling over arbitrary @code{kwargs}, the
@code{Cycler} class was developed.")
    (license license:bsd-3)))

(define-public python-colorspacious
  (package
    (name "python-colorspacious")
    (version "1.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/njsmith/colorspacious")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0x7nkphr6g5ql5fvgss8l56rgiyjgh6fm8zzs73i94ci9wzlm63w"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; No tests.
    (propagated-inputs (list python-numpy))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/njsmith/colorspacious")
    (synopsis "Python library for colorspace conversions")
    (description
     "@code{colorspacious} is a Python library that lets you convert between
colorspaces like sRGB, XYZ, CIEL*a*b*, CIECAM02, CAM02-UCS, etc.")
    (license license:expat)))

(define-public python-propcache
  (package
    (name "python-propcache")
    (version "0.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "propcache" version))
       (sha256
        (base32 "0r4sq2j6s63wziw8fhnrx0lxlg8ch3z2i6a92ivm7jqridrcwxrz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags '(list "--ignore=tests/test_benchmarks.py")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'patch-build-system
           (lambda _
             ;; XXX: I don't know how to tell it to build the extensions in
             ;; place.
             (substitute* "packaging/pep517_backend/_backend.py"
               (("build_inplace=False") "build_inplace=True")))))))
    (native-inputs
     (list python-covdefaults
           python-cython
           python-expandvars
           python-pytest
           python-pytest-cov
           python-pytest-xdist
           python-setuptools
           python-tomli
           python-wheel))
    (home-page "https://github.com/aio-libs/propcache")
    (synopsis "Accelerated property cache")
    (description "The module provides a fast implementation of cached
properties for Python 3.9+.")
    (license license:asl2.0)))

(define-public python-proto-matcher
  (package
    (name "python-proto-matcher")
    (version "0.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dayfine/proto-matcher")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l0dqnicpk4gpfspdlng026sxnkgzy68x416aw7camwq0513mq5l"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (arguments (list #:tests? #f)) ; The test suite seems broken (missing data).
    (propagated-inputs (list python-protobuf python-pyhamcrest))
    (home-page "https://github.com/dayfine/proto-matcher")
    (synopsis "PyHamcrest test matchers for protocol buffers")
    (description
     "This package provides the following PyHamcrest test matchers, that
enable matching a protocol buffer message:
@table @code
@item equals_proto
Test the argument equals the given protobuf message.
@item approximately
Test the argument equals the given protobuf message, while comparing any float
field using approximation.
@item ignoring_field_paths
Test the argument equals the given protobuf message, while ignoring those
fields specified in the field paths.
@item ignoring_repeated_field_ordering
Test the argument equals the given protobuf message, ignoring the ordering of
any repeated field.
@item partially
Test the argument partially equals the given protobuf message, i.e. if a field
is in the argument but not in the expected message, it's ignored in the
comparison.
@end table")
    (license license:asl2.0)))

(define-public python-matplotlib
  (package
    (name "python-matplotlib")
    (version "3.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib" version))
       (sha256
        (base32 "18amhxyxa6yzy1nwky4ggdgvvxnbl3qz2lki05vfx0dqf6w7ia81"))
       (patches (search-patches "python-matplotlib-fix-legend-loc-best-test.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-m" "not network"
        "-k" (string-join
              (list
               ;; This one fails with a small difference in the upper left.
               "not test_figure_legend_outside"
               "test_warn_big_data_best_loc"
               ;; The 'test_lazy_auto_backend_selection' fails because it
               ;; would require an X server; skip it.
               "test_lazy_auto_backend_selection"
               ;; It fails with deprecation warning The register_cmap function
               ;; was deprecated in Matplotlib 3.7 and will be removed two
               ;; minor releases later.
               "test_double_register_builtin_cmap"
               ;; Failed: DID NOT WARN. No warnings of type (<class
               ;; 'UserWarning'>,) were emitted.
               "test_rcparams_update"
               "test_rcparams_init"
               ;; ResourceWarning: unclosed file <_io.BufferedWriter
               ;; name='a.pdf'>
               "test_multipage_keep_empty"
               ;; UserWarning: Glyph 8722 (\N{MINUS SIGN}) missing from
               ;; current font.
               "test_mathtext_ticks")
              " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            ;; The version string is usually derived via setuptools-scm, but
            ;; without the git metadata available, the version string is set to
            ;; '0.0.0'.
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)))
          (add-after 'unpack 'fix-and-disable-failing-tests
            ;; XXX: Disable all image comparison tests because we're using a
            ;; newer version of FreeType than matplotlib expects.  This leads
            ;; to minor differences throughout the tests.
            (lambda _
              (substitute* (append (find-files "lib/matplotlib/tests/"
                                               "test_.*\\.py$")
                                   (find-files "lib/mpl_toolkits/tests"
                                               "test_.*\\.py$"))
                (("^from matplotlib" match)
                 (string-append "import pytest\n" match))
                (("( *)@([^_]+_)*(image_comparison|check_figures_equal)" match
                  indent)
                 (string-append indent "@pytest.mark.skip(\
reason=\"unknown minor image differences\")\n" match)))
              (substitute* "lib/matplotlib/tests/test_animation.py"
                (("/bin/sh") (which "sh")))
              (for-each delete-file
                        ;; test_normal_axes, test_get_tightbbox_polar
                        '("lib/matplotlib/tests/test_axes.py"
                          "lib/matplotlib/tests/test_polar.py"
                          ;; We don't use the webagg backend and this test
                          ;; forces it.
                          "lib/matplotlib/tests/test_backend_webagg.py"
                          ;; test_outward_ticks
                          "lib/matplotlib/tests/test_tightlayout.py"
                          ;; test_hidden_axes fails with minor extent
                          ;; differences, possibly due to the use of a
                          ;; different version of FreeType.
                          "lib/matplotlib/tests/test_constrainedlayout.py"
                          ;; Fontconfig returns no fonts.
                          "lib/matplotlib/tests/test_font_manager.py"
                          ;; The images comparison test fails
                          ;; non-deterministically when run in parallel (see:
                          ;; https://github.com/matplotlib/matplotlib/issues/22992).
                          "lib/matplotlib/tests/test_compare_images.py"))))
          (add-after 'unpack 'patch-dlopen
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "src/_c_internal_utils.c"
                (("libX11.so.6")
                 (search-input-file inputs "lib/libX11.so.6")))))
          (add-before 'build 'configure-environment
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Fix rounding errors when using the x87 FPU.
              (when (string-prefix? "i686" #$(%current-system))
                (setenv "CFLAGS" "-ffloat-store"))
              (call-with-output-file "mplsetup.cfg"
                (lambda (port)
                  (format port "\
[libs]
system_freetype = true
system_qhull = true

[rc_options]
backend=TkAgg

[directories]
basedirlist = ~a,~a

[packages]
tests = True~%" #$(this-package-input "tcl") #$(this-package-input "tk"))))))
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                ;; Step out of the source directory to avoid interference.
                (with-directory-excursion "/tmp"
                  ;; Run the installed tests, which is what we want since not
                  ;; everything gets built in the source directory.
                  (apply invoke "pytest"
                         "-n" (number->string (parallel-job-count))
                         "--pyargs" "matplotlib"
                         test-flags))))))))
    (propagated-inputs
     (list python-contourpy
           python-cycler
           python-dateutil
           python-fonttools-minimal
           python-importlib-resources
           python-kiwisolver
           python-numpy
           python-packaging
           python-pillow
           python-pyparsing
           `(,python "tk")))
    (inputs
     (list cairo
           freetype
           glib
           libpng
           qhull
           tcl
           tk))
    (native-inputs
     (list pkg-config
           pybind11
           python-pytest
           python-pytest-timeout
           python-pytest-xdist
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://matplotlib.org/")
    (synopsis "2D plotting library for Python")
    (description
     "Matplotlib is a Python 2D plotting library which produces publication
quality figures in a variety of hardcopy formats and interactive environments
across platforms.  Matplotlib can be used in Python scripts, the python and
ipython shell, web application servers, and six graphical user interface
toolkits.")
    (license license:psfl)))

(define-public python-matplotlib-documentation
  (package
    (inherit python-matplotlib)
    (name "python-matplotlib-documentation")
    (arguments
     (list
      #:tests? #f                       ;we're only generating documentation
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'avoid-external-deps
            (lambda _
              ;; XXX: Avoid theme-switcher to avoid sphinx error
              ;; TemplateNotFound('theme-switcher.html')
              ;; XXX: Avoid version-switcher because it depends on an
              ;; external file, and we pack only one version anyway.
              (substitute* "doc/conf.py"
                (("\
\"navbar_end\": \\[\"theme-switcher\", \"version-switcher\", ")
                 "\"navbar_end\": ["))))
          (replace 'build
            (lambda _
              (setenv "HOME" "/tmp")
              (chdir "doc")
              (invoke "make" "html" "info"
                      ;; Don't abort on warnings; build in parallel.
                      (format #f "SPHINXOPTS=-j~a" (parallel-job-count)))))
          (replace 'install
            (lambda _
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/matplotlib"))
                     (info (string-append data "/info"))
                     (html (string-append doc "/html")))
                (mkdir-p html)
                (copy-recursively "build/html" html)
                (install-file "build/texinfo/matplotlib.info" info)
                ;; The "matplotlib-figures" directory contains are a subset of
                ;; the images produced for the html target; simply create a
                ;; symlink to it, saving about 11 MiB.
                (symlink (string-append html "/_images")
                         (string-append info "/matplotlib-figures"))))))))
    (native-inputs
     (list graphviz
           inkscape/pinned
           python-colorspacious
           python-ipython
           python-ipykernel
           python-ipywidgets
           python-mpl-sphinx-theme
           python-numpydoc
           python-scipy
           python-sphinx
           python-sphinx-copybutton
           python-sphinx-design
           python-sphinx-gallery
           python-sphinxcontrib-svg2pdfconverter
           texinfo
           texlive-dvipng-bin
           (texlive-local-tree
            (list texlive-amsfonts
                  texlive-amsmath
                  texlive-babel
                  texlive-cm-super
                  texlive-etoolbox
                  texlive-expdlist
                  texlive-fontspec
                  texlive-times
                  texlive-type1cm
                  texlive-underscore
                  texlive-unicode-math))))
    (synopsis "Documentation for the @code{python-matplotlib} package")))

(define-public python-matplotlib-inline
  (package
    (name "python-matplotlib-inline")
    (version "0.1.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib_inline" version))
       (sha256
        (base32 "145bl0ppy4cz1fii3pfixd0fi1jfmkcbsq3bw4b3vgk6qqzb48w4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Tests disabled because of a circular dependency with IPython.
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          ;; Disabled because of a circular dependency with IPython.
          (delete 'sanity-check))))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-matplotlib
           python-traitlets))
    (home-page "https://github.com/ipython/matplotlib-inline")
    (synopsis "Inline Matplotlib backend for Jupyter")
    (description
     "This package provides a Matplotlib inline back-end for IPython and
Jupyter.")
    (license license:bsd-3)))

(define-public python-matplotlib-venn
  (package
    (name "python-matplotlib-venn")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "matplotlib-venn" version))
       (sha256
        (base32 "1qrnxhi2rbz737fm9mprfr8ig7kk2r99cbzkw8nsddcv7sh0favg"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest
                         python-setuptools
                         python-shapely
                         python-wheel))
    (propagated-inputs
     (list python-matplotlib python-numpy python-scipy))
    (home-page "https://github.com/konstantint/matplotlib-venn")
    (synopsis "Plot area-proportional Venn diagrams")
    (description
     "This package provides tools for plotting area-proportional two- and
three-way Venn diagrams in @code{matplotlib}.")
    (license license:expat)))

(define-public python-matplotx
  (package
    (name "python-matplotx")
    (version "0.3.10")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nschloe/matplotx")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1j301mr7ai2jmbm5mkva0jd99fzxhyq585pqzqfmrf5pil8j4q8i"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This test fails with ValueError: not enough values to unpack.
      #~(list "--deselect" "tests/test_spy.py::test_cli"
              ;; XXX: unknown failure
              "--deselect" "tests/test_spy.py::test_png")))
    (propagated-inputs
     (list python-matplotlib
           python-numpy
           ;; optional dependencies
           python-networkx
           python-pypng
           python-scipy))
    (native-inputs (list python-imageio
                         python-meshzoo
                         python-pytest
                         python-scikit-fem
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/nschloe/matplotx")
    (synopsis "Minimal matplotlib styles")
    (description
      "This package includes some extensions for Matplotlib to create
clean plots with a minimalistic style.")
    (license license:expat)))

(define-public python-cplot
  (package
    (name "python-cplot")
    (version "0.9.3")
    (source
     (origin
       (method git-fetch)   ;for tests
       (uri (git-reference
             (url "https://github.com/nschloe/cplot")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0zk7hpq358sbympmkms7w2wjs7nw8mdfvkvdasblg2nhqayv42qz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-matplotlib
           python-matplotx
           python-npx
           python-numpy))
    (home-page "https://github.com/nschloe/cplot")
    (synopsis "Plot complex-valued functions")
    (description "@code{cplot} is a Python library for plotting
complex-valued functions.")
    (license license:gpl3+)))

(define-public python-cppheaderparser
  (package
    (name "python-cppheaderparser")
    (version "2.7.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "CppHeaderParser" version))
       (sha256
        (base32 "0hncwd9y5ayk8wa6bqhp551mcamcvh84h89ba3labc4mdm0k0arq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f))     ; no tests
    (propagated-inputs (list python-ply))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "http://senexcanis.com/open-source/cppheaderparser/")
    (synopsis
     "Parse C++ header files and generate a data structure representing the class")
    (description
     "CppHeaderParser is a pure python module that will parse C++ header files
and generate a data structure representing the class﻿.")
    (license license:bsd-3)))

(define-public python-cppy
  (package
    (name "python-cppy")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cppy" version))
       (sha256
        (base32 "0s3d7bjgr9af571y7czswjymnymnihwnyf9ml4p28kw725y31dam"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/nucleic/cppy")
    (synopsis "C++ header library for Python extension modules")
    (description "This package is a small C++ header library which makes it
easier to write Python extension modules.  The primary feature is a
@code{PyObject} smart pointer which automatically handles reference counting
and provides convenience methods for performing common object operations.")
    (license license:bsd-3)))

(define-public python-perfplot
  (package
    (name "python-perfplot")
    (version "0.10.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "perfplot" version))
              (sha256
               (base32
                "0hbyv17f9ra6l6albcrqx4rylmfv2m6z4qsnhb4bar256dralvfp"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-matplotlib
                             python-matplotx
                             python-numpy
                             python-rich))
    (native-inputs (list python-flit-core
                         python-pytest))
    (home-page "https://github.com/nschloe/perfplot")
    (synopsis "Performance plots for Python code snippets")
    (description "@code{perfplot} extends Python's timeit by testing
snippets with input parameters (e.g., the size of an array) and plotting
the results.")
    (license license:gpl3+)))

(define-public python-socksipy-branch
  (package
    (name "python-socksipy-branch")
    (version "1.01")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "SocksiPy-branch" version))
       (sha256
        (base32 "01l41v4g7fy9fzvinmjxy6zcbhgqaif8dhdqm4w90fwcw9h51a8p"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; There are no tests
    (native-inputs (list python-setuptools))
    (home-page "https://code.google.com/archive/p/socksipy-branch/")
    (synopsis "Python SOCKS module")
    (description
     "SocksiPy - A Python SOCKS client module.  It provides a socket-like
interface that supports connections to any TCP service through the use of a
SOCKS4, SOCKS5 or HTTP proxy.  The original version was developed by Dan Haim,
this is a branch created by Mario Vilas to address some open issues,as the
original project seems to have been abandoned circa 2007.")
    (license license:bsd-3)))

(define-public python-socksipychain
  (package
    (name "python-socksipychain")
    (properties '((commit . "570c75c55661db175bd733996ed1ab68fc4e3b33")
                  (revision . "0")))
    (version (git-version "2.1.3"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pagekite/PySocksipyChain")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fi82id1qgh63wm8k1gcxpkaa8ic0mwliq7x3iy9lxihaqmr0zww"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; Tests try to access the network.
    (native-inputs (list python-setuptools))
    (home-page "http://pagekite.net/wiki/Floss/PySocksipyChain/")
    (synopsis "Python SOCKS module with chained proxies support")
    (description
     "SocksiPyChain is a modified version of the SocksiPy SOCKS module, which
adds support for arbitrary chaining of proxy servers and various modes of
TLS/SSL encryption.  It was developed for use in PageKite, and also includes
a simple netcat replacement with chaining support.")
    (license license:bsd-3)))

(define-public python-pycodestyle
  (package
    (name "python-pycodestyle")
    (version "2.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycodestyle" version))
       (sha256
        (base32 "089mszv65gwnz4nq8vryxqanlqk3bh3p4maxrnngdr5wighflf38"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "-m" "pycodestyle" "--statistics" "pycodestyle.py")
      #:phases
      #~(modify-phases %standard-phases
          ;; Taken from Tox config
          ;; <https://github.com/PyCQA/pycodestyle/blob/2.11.0/tox.ini#L16>.
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                  (apply invoke "python" "-v" test-flags)))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://pycodestyle.readthedocs.io/")
    (synopsis "Python style guide checker")
    (description "@code{pycodestyle} (formerly pep8) is a tool to check
Python code against some of the style conventions in
@url{http://www.python.org/dev/peps/pep-0008/,PEP 8}.")
    (license license:expat)))

(define-public python-pycollada
  (package
    (name "python-pycollada")
    (version "0.8")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/pycollada/pycollada")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0by8b46gji9npsgnx91cvzjrfcsm7r4d23gvn7h2h9ninaxlv7zw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-numpy
           python-dateutil))
    (home-page "https://pycollada.readthedocs.io")
    (synopsis "Reading and writing collada documents library")
    (description
     "This package implements a functionality for creating, editing and
loading @url{https://www.khronos.org/collada/,COLLADA},which is a
COLLAborative Design Activity for establishing an interchange file format for
interactive 3D applications.

The library allows you to load a COLLADA file and interact with it as a python
object.  In addition, it supports creating a collada python object from
scratch, as well as in-place editing.")
    (license license:bsd-3)))

(define-public python-pyct
  (package
    (name "python-pyct")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyct" version))
       (sha256
        (base32 "1856dbrcpc0nxxhlfh3dqzz7xxn5sdi600q45hsprqyqrg2lm7yx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These tests want to download example data from the internet.
      '(list "-k" (string-append
                   "not test_examples_with_use_test_data"
                   " and not test_examples_using_test_data_and_force_with_prexisting_content_in_target"
                   " and not test_fetch_data_using_test_data_with_no_file_in_data_copies_from_stubs"
                   " and not test_fetch_data_using_test_data_and_force_with_file_in_data_over_writes"))))
    (propagated-inputs (list python-param python-pyyaml))
    (native-inputs (list python-flake8 python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/holoviz-dev/pyct")
    (synopsis "Common packaging tasks")
    (description
     "This Python package provides utilities to run common packaging tasks,
e.g. copy examples, fetch data, etc.")
    (license license:bsd-3)))

(define-public python-multidict
  (package
    (name "python-multidict")
    (version "6.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "multidict" version))
       (sha256
        (base32
         "0jlgjpclkh5g6vr1danl6alz0cza2jlzdqh3q03d4s8ckfzjxbi2"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-typing-extensions))
    (native-inputs
     (list python-pytest python-pytest-cov python-setuptools python-wheel))
    (home-page "https://github.com/aio-libs/multidict/")
    (synopsis "Multidict implementation")
    (description "Multidict is dict-like collection of key-value pairs
where key might be occurred more than once in the container.")
    (license license:asl2.0)))

(define-public python-orderedmultidict
  (package
    (name "python-orderedmultidict")
    (version "1.0.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "orderedmultidict" version))
        (sha256
          (base32 "1bc2v0yflsxjyyjx4q9wqx0j3bvzcw9z87d5pz4iqac7bsxhn1q4"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-six))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/gruns/orderedmultidict")
    (synopsis "Python Ordered Multivalue Dictionary - omdict")
    (description "This package contains a library for ordered multivalue
dictionaries.  A multivalue dictionary is a dictionary that can store
multiple values for the same key.  An ordered multivalue dictionary is a
multivalue dictionary that retains the order of insertions and deletions.")
    (license license:unlicense)))

(define-public python-autocommand
  (package
    (name "python-autocommand")
    (version "2.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autocommand" version))
       (sha256
        (base32 "0d2zjms5xm236k46la5pnl7i7hs3a12jlp12cw8lk5jm7i1fk3c7"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://github.com/Lucretiel/autocommand")
    (synopsis "Python library to build a command-line from a function")
    (description "@code{autocommand} is library to automatically generate and
run simple @code{argparse} parsers from function signatures.")
    (license license:lgpl3+)))

(define-public python-autopage
  (package
    (name "python-autopage")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "autopage" version))
              (sha256
               (base32
                "169ixll1ncm2a2pcc86665ikjv2lrzs10p6c1w4yj55p3gk3xgh1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'disable-e2e-tests
            (lambda _
              ;; These tests rely on KeyboardInterrupts which do not
              ;; work in the build container.
              (delete-file "autopage/tests/test_end_to_end.py"))))))
    (native-inputs
     (list python-pypa-build
           python-setuptools
           python-wheel
           ;; For tests.
           python-fixtures
           python-pytest
           python-testtools))
    (home-page "https://github.com/zaneb/autopage")
    (synopsis "Automatic paging for console output")
    (description
     "Autopage is a Python library to automatically display terminal output
from a program in a @dfn{pager} such as @command{less}.")
    (license license:asl2.0)))

(define-public python-dirty-equals
  (package
    (name "python-dirty-equals")
    (version "0.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/samuelcolvin/dirty-equals")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jp9jbfs90m8jkpcvi798zxxx49a94rzn8gki9fraqhbqxkv76qd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This test requires pytest-examples, which in turn requires
      ;; python-ruff, which is difficult to package because it is written in
      ;; Rust (TODO: Enable when Ruff is in Guix!).
      #~(list "--ignore=tests/test_docs.py"
              ;; Optional typing check with Pydantic.
              "--ignore=tests/test_other.py"
              ;; TODO: Some timezones are missing in PyTZ, remove constrain
              ;; when updated.
              "-k" (string-append "not test_is_datetime_zoneinfo"
                                  " and not test_is_now_tz"
                                  " and not test_tz"))))
    (native-inputs
     (list python-hatchling
           ;; python-pydantic ; introduces cycle, optinoal
           python-pytest))
    (propagated-inputs
     (list python-pytz))
    (home-page "https://dirty-equals.helpmanual.io/")
    (synopsis "Do dirty (but useful) things with equals")
    (description
     "@code{dirty-equals} is a Python library that (mis)uses the
@code{__eq__} method to make code (generally unit tests) more declarative
and therefore easier to read and write.")
    (license license:expat)))

(define-public python-distlib
  (package
    (name "python-distlib")
    (version "0.3.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "distlib" version))
       (sha256
        (base32
         "1a27f5p93j9i1l3324qgahs3g8ai91fmx783jpyyla506i5ybbwx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'no-/bin/sh
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((/bin/sh (search-input-file inputs "bin/sh")))
                (substitute* '("distlib/scripts.py" "tests/test_scripts.py")
                  (("/bin/sh") /bin/sh)))))
          (add-before 'check 'prepare-test-environment
            (lambda _
              (setenv "HOME" "/tmp")
              ;; NOTE: Any value works, the variable just has to be present.
              (setenv "SKIP_ONLINE" "1"))))))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (inputs
     (list bash-minimal))
    (home-page "https://github.com/pypa/distlib")
    (synopsis "Distribution utilities")
    (description "Distlib is a library which implements low-level functions that
relate to packaging and distribution of Python software.  It is intended to be
used as the basis for third-party packaging tools.")
    (license license:psfl)))

(define-public python-distutils-extra
  (package
    (name "python-distutils-extra")
    (version "2.38")
    (source
     (origin
      (method url-fetch)
      (uri (string-append "https://launchpad.net/python-distutils-extra/trunk/"
                          version "/+download/python-distutils-extra-"
                          version ".tar.gz"))
      (sha256
       (base32
        "0lx15kcbby9zisx33p2h5hgakgwh2bvh0ibag8z0px4j6ifhs41x"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;tests are outdated and broken
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://launchpad.net/python-distutils-extra/")
    (synopsis "Enhancements to Python's distutils")
    (description
     "The python-distutils-extra module enables you to easily integrate
gettext support, themed icons, and scrollkeeper-based documentation into
Python's distutils.")
    (license license:gpl2)))

(define-public python-olefile
  (package
    (name "python-olefile")
    (version "0.47")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/decalage2/olefile")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ardfp32jgijha6vk7znvnpwgi710c6gj02lk4drv45xj4mw71hv"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://www.decalage.info/python/olefileio")
    (synopsis "Read and write Microsoft OLE2 files")
    (description
     "@code{olefile} can parse, read and write Microsoft OLE2 files (Structured
Storage or Compound Document, Microsoft Office).  It is an improved version of
the OleFileIO module from PIL, the Python Image Library.")
    (license license:bsd-3)))

(define-public python-property-cached
  (package
    (name "python-property-cached")
    (version "1.6.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "property-cached" version ".zip"))
       (sha256
        (base32 "0wxv5sdx1p7ils36j6j6hfscz8v2vzbq212i8y8r0lrnxpqlx71y"))
       (patches
        (search-patches "python-property-cached-asyncio-3_11.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; AssertionError.
      #:test-flags #~(list "-k" "not test_threads_ttl_expiry")))
    (native-inputs (list python-freezegun python-pytest unzip
                         python-setuptools python-wheel))
    (home-page "https://github.com/althonos/property-cached/")
    (synopsis "Decorator for caching properties in classes")
    (description "This package provides a decorator for caching properties in
classes.  It is forked from @code{cached-property}.")
    (license license:bsd-3)))

(define-public python-pdf2image
  (package
    (name "python-pdf2image")
    (version "1.17.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Belval/pdf2image")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xd8q939zqa8flfcdhbgyadiwqb8sgnd42cbr6n1l2jl9fnix45v"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; The following excluded tests assume hardcoded binary paths to
      ;; /usr/bin/pdftoppm and /usr/bin/pdftocairo.
      #:test-flags
      #~(list "--exclude=^test_use_poppler_path$"
              "--exclude=^test_use_poppler_path_with_trailing_slash$")))
    (propagated-inputs (list python-pillow))
    (inputs (list poppler))
    (native-inputs (list python-pynose which python-setuptools))
    (home-page "https://github.com/Belval/pdf2image")
    (synopsis
     "Python wrapper around @command{pdftoppm} and @command{pdftocairo}")
    (description
     "This package provides a Python API wrapping the @command{pdftoppm} and
@command{pdftocairo} command line tools.  It can convert @file{PDF} files to a
Python list with elements of type @code{PIL.Image} (from the
@code{python-pillow} library).")
    (license license:expat)))

(define-public python-pikepdf
  (package
    (name "python-pikepdf")
    (version "8.15.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pikepdf/pikepdf")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hpnb63xp8yaflah3i1z5azh6mg36rz0liy27km47417w2q72v0c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list pybind11
           python-attrs
           python-hypothesis
           python-setuptools-scm
           python-psutil
           python-pytest
           python-pytest-timeout
           python-pytest-xdist
           python-dateutil
           python-xmp-toolkit
           python-tomli
           python-setuptools))
    (inputs
     (list qpdf))
    (propagated-inputs
     (list python-deprecated python-lxml python-packaging python-pillow))
    (home-page "https://github.com/pikepdf/pikepdf")
    (synopsis "Read and write PDFs with Python")
    (description
     "pikepdf is a Python library for reading and writing PDF files.")
    (license license:mpl2.0)))

(define-public python-pillow
  (package
    (name "python-pillow")
    (version "11.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pillow" version))
       (sha256
        (base32 "081abgpz7g013cgzz7pjhmf8m7q626ngza4hnfs76vdk104ag39n"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-ldconfig
            (lambda _
              (substitute* "setup.py"
                (("\\['/sbin/ldconfig', '-p'\\]") "['true']"))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "HOME" (getcwd))
                (invoke "python" "selftest.py" "--installed")
                (invoke "python" "-m" "pytest" "-vv")))))))
    (native-inputs (list python-defusedxml
                         python-markdown2
                         python-olefile
                         python-pytest
                         python-setuptools
                         python-trove-classifiers))
    (inputs (list freetype
                  lcms
                  libjpeg-turbo
                  libtiff
                  libwebp
                  openjpeg
                  zlib))
    (home-page "https://python-pillow.org")
    (synopsis "Fork of the Python Imaging Library")
    (description
     "The Python Imaging Library adds image processing capabilities to your
Python interpreter.  This library provides extensive file format support, an
efficient internal representation, and fairly powerful image processing
capabilities.  The core image library is designed for fast access to data
stored in a few basic pixel formats.  It should provide a solid foundation for
a general image processing tool.")
    (properties `((cpe-name . "pillow")))
    (license (license:x11-style
              "http://www.pythonware.com/products/pil/license.htm"
              "The PIL Software License"))))

(define-public python-pillow-heif
  (package
    (name "python-pillow-heif")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pillow_heif" version))
       (sha256
        (base32 "1pkbkg88jg6f24xvbg95aq8dm8fa8ffz7zy4rq262m98i658q3pn"))))
    (build-system pyproject-build-system)
    (inputs (list libheif))
    (propagated-inputs (list python-pillow))
    (native-inputs (list opencv         ; for opencv-python
                         python-defusedxml
                         python-numpy
                         python-packaging
                         python-pympler
                         python-pytest
                         python-setuptools))
    (home-page "https://github.com/bigcat88/pillow_heif")
    (synopsis "Python interface for libheif library")
    (description "This package provides Python bindings for the libheif library
and a plugin for Pillow.")
    (license license:bsd-3)))

(define-public python-pillow-heif-0.22
  (package
    (inherit python-pillow-heif)
    (version "0.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pillow_heif" version))
       (sha256
        (base32 "16mkap63d14f69105b3bm8pi64fvpdznncgn48vhgls0jf977m31"))))))

(define-public python-pixelmatch
  (package
    (name "python-pixelmatch")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/whtsky/pixelmatch-py")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0d4579hh5rwdh9djq5j9lf448x68c1iz80wavxiq7sxpmwm1j23a"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: PIL.UnidentifiedImageError despite images being present.
     (list #:tests? #f))
    (native-inputs
     (list python-poetry-core
           python-pillow
           python-pytest
           python-pytest-benchmark))
    (home-page "https://github.com/whtsky/pixelmatch-py")
    (synopsis "Pixel-level image comparison library")
    (description
     "This package provides a pixel-level image comparison library for Python,
originally created to compare screenshots in tests.  Its features include
accurate anti-aliased pixels detection and perceptual color difference
metrics.")
    (license license:isc)))

(define-public python-imagecodecs
  (package
    (name "python-imagecodecs")
    (version "2025.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imagecodecs" version))
       (sha256
        (base32 "0v7yglk100fnk0m9m5bnfph2vm1jpnxzrzz2lwk06dqcr6m75wia"))
       (modules '((guix build utils)))
       (snippet #~(for-each delete-file
                            ;; Delete pre-generated Cython files.
                            (find-files "imagecodecs" "_.*\\.c$")))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Some of those tests are flaky.
      #~(list "-k" "not test_cms_identity_transforms")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'create-configuration
            (lambda _
              ;; By default everything is enabled. We can selectively disable
              ;; extensions (and thus dependencies) by deleting them from the
              ;; EXTENSIONS dictionary.  This is upstream’s preferred way.
              (call-with-output-file "imagecodecs_distributor_setup.py"
                (lambda (port)
                  (format port "\
def customize_build(EXTENSIONS, OPTIONS):
~{    del EXTENSIONS[~s]~%~}~%"
                          (list "apng" "lzo" "tiff" ; FIXME Wrong version?
                                ;; Those rely on unpackaged inputs.
                                "aec" "avif" "bitshuffle" "brunsli" "deflate"
                                "jetraw" "jpeg2k" "jpegls" "jpegxl" "jpegxr"
                                "jpegxs" "lerc" "ljpeg" "lzf" "lzham" "mozjpeg"
                                "pcodec" "sperr" "sz3" "szip" "ultrahdr" "zfp"
                                "zlibng" "zopfli"))))))
          (add-after 'unpack 'fix-sanity-check
            (lambda _
              ;; XXX: Don't exit twice. The generated script already does that.
              (substitute* "imagecodecs/__main__.py"
                (("sys\\.exit\\(main\\(\\)\\)")
                 ""))))
          (add-before 'check 'configure-tests
            (lambda _
              (setenv "HOME" (getcwd)))))))
    (inputs
     (list c-blosc
           giflib
           brotli
           lcms
           libheif
           libjpeg-turbo
           libpng
           libtiff
           libwebp
           lz4
           lzfse
           python-blosc2
           snappy
           xz
           zlib
           `(,zstd "lib")))
    (propagated-inputs
     (list python-numpy python-matplotlib python-tifffile))
    (native-inputs
     (list python-cython python-pytest python-setuptools))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Image transformation, compression, and decompression codecs")
    (description
     "Imagecodecs is a Python library that provides block-oriented, in-memory
buffer transformation, compression, and decompression functions for use in the
tifffile, czifile, and other scientific image input/output modules.")
    (license license:bsd-3)))

(define-public python-property-manager
  (package
    (name "python-property-manager")
    (version "3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xolox/python-property-manager")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1v7hjm7qxpgk92i477fjhpcnjgp072xgr8jrgmbrxfbsv4cvl486"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs
     (list python-verboselogs
           python-humanfriendly
           python-coloredlogs))
    (home-page "https://github.com/xolox/python-property-manager")
    (synopsis "Useful property variants for Python programming")
    (description
     "The @code{property-manager} package defines several custom property
variants for Python programming including required properties,writable
properties, cached properties, etc.")
    (license license:expat)))

(define-public python-executing
  (package
    (name "python-executing")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "executing" version))
       (sha256
        (base32 "0mb74ajjfhzscvwxr9qazjs2q7il2fvyicm7s58jbzh8h418q42x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Test needs IPython
      #~(list "-k" "not test_two_statement_lookups")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tests
            (lambda _
              ;; See: <https://github.com/alexmojaki/executing/issues/99>.
              (substitute* "pyproject.toml"
                (("ignore_missing_imports = true.*")
                 "ignore_missing_imports = true

[tool.pytest.ini_options]
python_functions = \"test_\"\n")))))))
    (native-inputs
     (list python-asttokens
           python-littleutils
           python-pytest
           python-rich
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/alexmojaki/executing")
    (synopsis "Get information about what a Python frame is currently doing")
    (description "This package lets you get information about what a frame is
currently doing, particularly the AST node being executed.")
    (license license:expat)))

(define-public python-executor
  (package
    (name "python-executor")
    (version "23.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xolox/python-executor")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mr0662c5l5zx0wjapcprp8p2xawfd0im3616df5sgv79fqzwfqs"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;TODO: tests require root/sudo
    (native-inputs (list python-mock python-pytest python-setuptools))
    (propagated-inputs
     (list python-six
           python-property-manager
           python-fasteners
           python-virtualenv))
    (home-page "https://github.com/xolox/python-executor")
    (synopsis "Programmer friendly subprocess wrapper")
    (description
     "The @code{executor} package is a simple wrapper for Python’s subprocess
module that makes it very easy to handle subprocesses on UNIX systems with
proper escaping of arguments and error checking currently doing, particularly
the AST node being executed.")
    (license license:expat)))

(define-public python-roifile
  (package
    (name "python-roifile")
    (version "2025.5.10")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "roifile" version))
        (sha256
          (base32 "1kiwylcmxckzrqj3xn5ljcjfyx6y2s8bnqjd5psmkb4mjrwiypcf"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ; There are none.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-numpy))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Read and write ImageJ ROI format")
    (description "Roifile is a Python library to read, write, create, and plot
ImageJ ROIs, an undocumented and ImageJ application specific format to store
regions of interest, geometric shapes, paths, text, etc for image overlays.")
    (license license:bsd-3)))

(define-public python-lfdfiles
  (package
    (name "python-lfdfiles")
    (version "2025.9.17")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lfdfiles" version))
       (sha256
        (base32 "0b363vv146icsn86gxc04grq2d5r7xzzabr03xsc7aq9wybgvgqp"))
       (modules '((guix build utils)))
       (snippet
        ;; Delete pre-generated Cython files.
        #~(for-each delete-file (find-files "lfdfiles" "_.*\\.c$")))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; No tests, despite a test dependency on pytest.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-click python-numpy python-tifffile))
    (home-page "https://www.lfd.uci.edu/~gohlke/")
    (synopsis "Work with LFD data files")
    (description
     "Lfdfiles is a Python library and console script for reading, writing,
converting, and viewing many of the proprietary file formats used to store
experimental data and metadata at the Laboratory for Fluorescence Dynamics.")
    (license license:bsd-3)))

;; ~8Mo of test files.
(define python-av-testdata
  (file-union
   "python-av-testdata"
   (cons*
    (let ((file "pexels/time-lapse-video-of-night-sky-857195.mp4"))
      `(,(string-append "pyav-curated/" file)
        ,(origin
           (method url-fetch)
           (uri (string-append "https://pyav.org/datasets/" file))
           (sha256
            (base32 "10fjs2gyha88gzv7pv3njv0fimv61ihz39p1556qazm90xbknzgb")))))
    (map
     (match-lambda
       ((file . hash)
        (list (string-append "fate-suite/" file)
              (origin
                (method url-fetch)
                (uri (string-append "http://fate.ffmpeg.org/fate-suite/" file))
                (sha256 (base32 hash))))))
     '(("aac/latm_stereo_to_51.ts" .
        "05h8389i944gb7f2y9c7848vqn8xz1mnm602fwala85npj4z8p4m")
       ("h264/extradata-reload-multi-stsd.mov" .
        "1rwlkl9vxp925vzh13cq5dfr983jxbkng0w6ivaymqqwvi7bvg5m")
       ("amv/MTV_high_res_320x240_sample_Penguin_Joke_MTV_from_WMV.amv" .
        "1hiifhdmd0ygzny5mplqdxl3dh9g95384ilkr4ccwv5l9y7hrmiv")
       ("audio-reference/chorusnoise_2ch_44kHz_s16.wav" .
        "06xybcnv7max9mmj6f1fw8rwz2aawhcyx2wgj1gmn1142kk431ra")
       ("h264/interlaced_crop.mp4" .
        "04bcmwd6scqn63y6p8i5srbjh9jq1sc95q6vy7srwfhzwxl9cma9")
       ("hap/HAPQA_NoSnappy_127x1.mov" .
        "1kvf8xs5v29sjqk2p07arl2hlp9z7hb1lb4202v4iqiwva1jmiaq")
       ("mkv/codec_delay_opus.mkv" .
        "0ll3qnmxnkhqxbh6s2a3clbkbhw5bsbfw6mh6kxdsa463iyyka8r")
       ("mov/displaymatrix.mov" .
        "1d4jp93hdyfhasxhqmx8lliwsa2w1kv2jj1qh6fqs74aqb6kzb82")
       ("mov/mov-1elist-ends-last-bframe.mov" .
        "04lyjsm8zncw9aac7vmkc2h45dcyb6y8643s3pg3rgzgcgqkq3nn")
       ("mov/white_zombie_scrunch-part.mov" .
        "07wg7mxa799z8dcvnbbrr9f0b5l6r42bd7d414isk3kc3jw0z6ka")
       ("mpeg2/mpeg2_field_encoding.ts" .
        "1f3waj8jhp6v655hnqpxi2bx3b36976vdjmr74hjr7jv2hx3724n")
       ("vorbis/vorbis_chapter_extension_demo.ogg" .
        "1prhhwi44psk9xji2mvk7rnvk899h5rx9wi3dmzkgwaz11r0cjdk")
       ("mxf/track_01_v02.mxf" .
        "04gpbma4kxvhn4dr1sh2k4pq2kbpmnmk2s2bdhq081jzap2983q1")
       ("png1/55c99e750a5fd6_50314226.png" .
        "05rha9vdix0wfibrhpaknh9fzj0cv84q6d2ypxq1wc0y328fc068")
       ("qtrle/aletrek-rle.mov" .
        "1n6ksjrqrb7gnbvzhj58y5z5jx6bmpgg7lxwzvnbfg9f9ib2yxdr")
       ("sub/MovText_capability_tester.mp4" .
        "07znmm4bhnp5f40yksnpf7ws94yflsbv169ydkga6rdby6ys2sv3")
       ("sub/vobsub.sub" .
        "12rwhnv1k7mngvyq026f2xd9dpd9mxmwg82sa9p5r8z54hrw8sjz"))))))

(define-public python-av
  (package
    (name "python-av")
    (version "16.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "av" version))
       (sha256
        (base32 "1gqxzwbgwj164x211lsjgqj8xx9rpjxhzq6rls4mhpqbz9wyfb6x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Upstream is not great in responding to open issues or change requests.
      ;; See:
      ;; - <https://github.com/PyAV-Org/PyAV/issues/1942>
      ;; - <https://github.com/PyAV-Org/PyAV/issues/1946>
      ;; - <https://github.com/PyAV-Org/PyAV/pull/1944>
      #:test-flags
      ;; Writing to custom IO requires network access.
      #~(list "-k" "not test_writing_to_custom_io_dash")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; This would otherwise interfere with finding the installed
              ;; av when running tests.
              (delete-file-recursively "av")
              (setenv "PYAV_TESTDATA_DIR" #+python-av-testdata)
              (substitute* "tests/common.py"
                (("^os\\.environ\\[\"PYAV_TESTDATA_DIR\"\\] = asset\\(\\)")
                 "os.environ.setdefault(\"PYAV_TESTDATA_DIR\", asset())")))))))
    (native-inputs
     (list pkg-config
           python-cython
           python-numpy
           python-pillow
           python-pytest
           python-setuptools))
    (inputs (list ffmpeg))
    (home-page "https://github.com/PyAV-Org/PyAV")
    (synopsis "Pythonic bindings for FFmpeg's libraries")
    (description
     "PyAV is a Python library that allows for direct and precise manipulation
of media through containers, streams, packets, codecs, and frames.  It provides
access to the powerful FFmpeg libraries while managing the complex details as
much as possible.
PyAV also facilitates data transformation and integration with
other packages such as Numpy and Pillow.  However, working with media is a
challenging task and PyAV cannot abstract it away or make all the best decisions
for you.  If you can accomplish your tasks with the ffmpeg command, PyAV may not
be necessary.  Nonetheless, PyAV is an essential tool when working with media
that requires its specific capabilities.")
    (license license:bsd-3)))

(define-public python-ffmpeg-python
  ;; The latest release (0.2.0) is old and its test suite crashs on Python 3.10.
  (package
    (name "python-ffmpeg-python")
    (properties '((commit . "df129c7ba30aaa9ffffb81a48f53aa7253b0b4e6")
                  (revision . "0")))
    (version (git-version "0.2.0"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/kkroening/ffmpeg-python.git")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1zj4ac37n4igfj21zy405mdlvbpv6jyb12wfpszf8zkhhj2qby4c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not test_pipe and not test__probe")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'hardcode-ffmpeg
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((ffmpeg (search-input-file inputs "bin/ffmpeg")))
                (substitute* "ffmpeg/_run.py"
                  (("cmd='ffmpeg'")
                   (string-append "cmd='" ffmpeg "'")))
                (substitute* "ffmpeg/tests/test_ffmpeg.py"
                  (("out_file.compile\\(\\) == \\['ffmpeg'")
                   (format #f "out_file.compile() == [~s" ffmpeg)))))))))
    (inputs (list ffmpeg))
    (propagated-inputs (list python-future))
    (native-inputs (list python-future
                         python-numpy
                         python-pytest
                         python-pytest-mock
                         python-setuptools))
    (home-page "https://github.com/kkroening/ffmpeg-python")
    (synopsis "Python bindings for FFmpeg with complex filtering support")
    (description
     "ffmpeg-python allows you to write FFmpeg filtergraphs in familiar
Python terms, taking care of running ffmpeg with the correct command-line
arguments.  It handles arbitrarily large (directed-acyclic) signal graphs.")
    (license license:asl2.0)))

(define-public python-imageio-ffmpeg
  (package
    (name "python-imageio-ffmpeg")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imageio_ffmpeg" version))
       (sha256
        (base32 "0m8ppa4ap5vnic3jb25hsrq2gn0283x7mfr5z6ln8m80ivnnnmg2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f       ;XXX: tests requrie network access to get FFmpeg data
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'hardcode-ffmpeg
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "imageio_ffmpeg/_utils.py"
                (("os\\.getenv\\(\"IMAGEIO_FFMPEG_EXE\".*\\)" all)
                 (string-append "(" all " or \""
                                (search-input-file inputs "bin/ffmpeg")
                                "\")"))))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (inputs
     (list ffmpeg))
    (home-page "https://github.com/imageio/imageio-ffmpeg")
    (synopsis "FFMPEG wrapper for Python")
    (description
     "This package provides an FFMPEG wrapper for working with video files.
It implements generator functions for reading and writing data to and from
FFMPEG, reliably terminating the process when done.")
    (license license:bsd-2)))

(define-public python-imageio-freeimage
  (package
    (name "python-imageio-freeimage")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imageio_freeimage" version))
       (sha256
        (base32 "1la0iv3617m52dnidhhrdaz9dpnlfqs7b83550d3jkjavv30md72"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ; tests need internet and are not distributed in PyPI
      #:phases
      #~(modify-phases %standard-phases
          ;; imageio_freeimage expects a copy of the library in its source
          ;; tree.  Changing this would require hacky substitutions.
          (add-after 'install 'freeimage-path
            (lambda* (#:key inputs #:allow-other-keys)
              (let* ((pylib (string-append #$output "/lib/python"
                                           #$(version-major+minor
                                              (package-version python))
                                           "/site-packages"))
                     (iofi (string-append pylib "/imageio_freeimage")))
                (mkdir-p (string-append iofi "/_lib"))
                (symlink (search-input-file inputs "lib/libfreeimage.so")
                         (string-append iofi "/_lib/libfreeimage.so"))))))))
    (native-inputs (list python-poetry-core python-requests python-setuptools
                         python-wheel))
    (inputs (list freeimage))
    (propagated-inputs (list python-imageio))
    (home-page "https://github.com/imageio/imageio-freeimage")
    (synopsis "Plugin for ImageIO that wraps the FreeImage library")
    (description
     "This package provides a plugin for @code{ImageIO} that wraps the
@code{FreeImage} library.")
    ;; As a derivative work of FreeImage, imageio_freeimage is licensed under
    ;; GPLv2 or GPLv3, and the FreeImage Public License (FIPL).
    ;; For more information, see the LICENSE file.
    (license
     (list license:gpl2 license:gpl3
           (license:non-copyleft "https://spdx.org/licenses/FreeImage.html")))))

(define-public python-imageio
  (package
    (name "python-imageio")
    (version "2.36.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imageio" version))
       (sha256
        (base32
         "0qmy8qbnycas6v2a43qw9pxmd23fm3hpq3qb20b9x6kzyhqx5qg4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "-m" "not needs_internet"
                           ;; This attempts to load libGL.so (provided by mesa)
                           ;; at the Python store path (sys.base_prefix?).
                           "-k" "not test_findlib2"
                           "--ignore" "tests/test_freeimage.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-source
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "imageio/core/util.py"
                (("\"/var/tmp\"")
                 "os.getenv(\"TMPDIR\", \"/tmp\")")))))))
    (propagated-inputs
     (list python-imageio-ffmpeg python-numpy python-pillow python-tifffile))
    (native-inputs
     (list python-fsspec
           python-pytest
           python-setuptools))
    (home-page "https://imageio.github.io/")
    (synopsis "Library for reading and writing a wide range of image data")
    (description
     "Imageio is a Python library that provides an easy interface to read and
write a wide range of image data, including animated images, video, volumetric
data, and scientific formats.")
    (license license:bsd-2)))

(define-public python-pyvips
  (package
    (name "python-pyvips")
    (version "3.0.0")
    (source
     (origin
       (method git-fetch) ; PyPI does not include test helpers
       (uri (git-reference
             (url "https://github.com/libvips/pyvips")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "017x7i8ssghsdpncjfhk5shdq31784hb5xjalrxl918s86rjwakp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list pkg-config
           python-pytest
           python-setuptools
           python-wheel))
    (inputs
     (list glib vips))
    (propagated-inputs
     (list python-cffi python-pkgconfig))
    (home-page "https://github.com/libvips/pyvips")
    (synopsis "Python bindings for VIPS")
    (description "The @code{pyvips} package provides Python bindings for VIPS,
a multithreaded image-processing system with low memory needs.")
    (license license:expat)))

;; WARNING: This package is a dependency of mesa.
;; There are no users in python-xyz for this package, consider to adopt closer
;; to Mesa.
(define-public python-pycparser
  (package
    (name "python-pycparser")
    (version "2.22")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pycparser" version))
       (sha256
        (base32
         "1xhhxjg460f70ldki4prxmb7zl1bfl3mnjplbc7kkxa0q3lqn729"))))
    (outputs '("out" "doc"))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'install-doc
            (lambda _
              (let* ((data (string-append #$output:doc "/share"))
                     (doc (string-append data "/doc/" #$name "-" #$version))
                     (examples (string-append doc "/examples")))
                (mkdir-p examples)
                (for-each (lambda (file)
                            (copy-file (string-append "." file)
                                       (string-append doc file)))
                          '("/README.rst" "/CHANGES" "/LICENSE"))
                (copy-recursively "examples" examples)))))))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/eliben/pycparser")
    (synopsis "C parser in Python")
    (description
     "Pycparser is a complete parser of the C language, written in pure Python
using the PLY parsing library.  It parses C code into an AST and can serve as
a front-end for C compilers or analysis tools.")
    (license license:bsd-3)))

(define-public python-pywavelets
  (package
    (name "python-pywavelets")
    (version "1.8.0")
    (home-page "https://github.com/PyWavelets/pywt")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pywavelets" version))
              (sha256
               (base32
                "1aimbjxvflmx4qrl17bfzy64pz5ql4s9bhnb8g0ssh28fm2h507k"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags '(list "--pyargs" "pywt")
      #:phases
      #~(modify-phases %standard-phases
          ;; The compiled libraries are only in the output at this point,
          ;; but they are needed to run tests.
          ;; FIXME: This should be handled by the pyargs pytest argument,
          ;; but is not for some reason.
          (add-before 'check 'pre-check
            (lambda _ (chdir #$output))))))
    (native-inputs
     (list meson
           ninja
           pkg-config
           python-cython
           python-meson-python
           python-numpy
           python-pytest))
    (propagated-inputs
     (list python-numpy python-scipy))
    (synopsis "Wavelet transforms in Python")
    (description
     "PyWavelets is a library for wavelet transforms in Python.  Wavelets are
mathematical basis functions that are localized in both time and frequency.
Wavelet transforms are time-frequency transforms employing wavelets.  They are
similar to Fourier transforms, the difference being that Fourier transforms are
localized only in frequency instead of in time and frequency.")
    (license license:expat)))

(define-public python-pywal
  (package
    (name "python-pywal")
    (version "3.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dylanaraps/pywal")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "039m7dch479hlwddynacdrr0klz6a5bdly5swqbs94hfimficiyf"))))
    (build-system pyproject-build-system)
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-before 'check 'fix-home-directory
           (lambda _
             ;; Tests fail with "Permission denied: '/homeless-shelter'".
             (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (inputs
     (list imagemagick))
    (home-page "https://github.com/dylanaraps/pywal")
    (synopsis "Color palette generator and applicator")
    (description
     "Pywal is a tool that generates a color palette from the dominant colors
in an image.  It then applies the colors system-wide and on-the-fly in all of
your favourite programs.")
    (license license:expat)))

(define-public python-pywal16
  (package
    (name "python-pywal16")
    (version "3.8.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pywal16" version))
       (sha256
        (base32 "0836ya6zw0dglh0yldd9apsfvh5f9cxvmy8nc7aw2w8s491yancf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
        (add-before 'check 'set-HOME
          (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list imagemagick
           python-pytest
           python-setuptools))
    (home-page "https://github.com/eylles/pywal16")
    (synopsis "16 colors fork of pywal")
    (description
     "Pywal16 is a tool that generates a color palette from the dominant
colors in an image.  It then applies the colors system-wide and on-the-fly in
all of your favorite programs.")
    (license license:expat)))

(define-public python-click-didyoumean
  (package
    (name "python-click-didyoumean")
    (version "0.3.1")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/click-contrib/click-didyoumean")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1byfqs3m87zfpvssm1al9dvq94gjd0iddpwrzk6205n18wjsphqb"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core python-pytest))
    (propagated-inputs
     (list python-click))
    (home-page "https://github.com/timofurrer/click-didyoumean")
    (synopsis "Git-like did-you-mean feature in Click")
    (description
     "This plugin enables git-like did-you-mean feature in Click.")
    (license license:expat)))

(define-public python-pywinrm
  (package
    (name "python-pywinrm")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/diyan/pywinrm/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jp7rps6zg5b6n98lfkwbhv72982sxxnqc4v4i6hjlq1ycjmmb8r"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-requests python-requests-ntlm python-xmltodict))
    (native-inputs
     (list python-mock python-pytest python-setuptools))
    (home-page "https://github.com/diyan/pywinrm/")
    (synopsis "Python library for Windows Remote Management (WinRM)")
    (description
     "pywinrm is a Python client for the Windows Remote Management (WinRM)
service.  It allows you to invoke commands on target Windows machines from
any machine that can run Python.")
    (license license:expat)))

(define-public python-manimpango
  (package
    (name "python-manimpango")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch) ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/ManimCommunity/ManimPango")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "00mrvswk8yly0m13jq0f432pr19sy3j6w37lrv78ah1j6jz9n50h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'build-extensions
            (lambda _
              (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
      (list pkg-config
            python-cython
            python-pytest
            python-pytest-cov
            python-setuptools
            python-wheel))
    (inputs
     (list pango))
    (home-page "https://manimpango.manim.community/")
    (synopsis "Bindings for Pango for using with Manim")
    (description
     "Python bindings for ManimPango which is a C binding for Pango,
using Cython.

ManimPango is internally used in Manim to render (non-LaTeX) text.")
    (license license:expat)))

(define-public python-cairocffi
  (package
    (name "python-cairocffi")
    (version "1.6.1")
    (source
     (origin
       ;; The PyPI archive does not include the documentation, so use Git.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Kozea/cairocffi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "161z2bsp0ai4311mz9n0h6vmz80690jbijxx2gqkknygwm2ynjgd"))))
    (build-system pyproject-build-system)
    (outputs '("out" "doc"))
    (inputs
     (list glib gtk+ gdk-pixbuf cairo))
    (native-inputs
     (list python-flit-core
           python-numpy
           python-pikepdf
           python-pytest
           python-pytest-cov
           python-pytest-runner
           python-sphinx
           python-sphinx-rtd-theme))
    (propagated-inputs
     (list python-xcffib)) ; used at run time
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (add-after 'unpack 'patch-paths
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* "cairocffi/__init__.py"
               ;; Hack the dynamic library loading mechanism.
               (("find_library\\(library_name\\)")
                "\"found\"")
               (("filenames = \\(library_filename,\\) \\+ filenames")
                "pass")
               (("libcairo.so.2")
                (search-input-file inputs "/lib/libcairo.so.2")))
             (substitute* "cairocffi/pixbuf.py"
               (("libgdk_pixbuf-2.0.so.0")
                (search-input-file inputs "/lib/libgdk_pixbuf-2.0.so.0"))
               (("libgobject-2.0.so.0")
                (search-input-file inputs "/lib/libgobject-2.0.so.0"))
               (("libglib-2.0.so.0")
                (search-input-file inputs "/lib/libglib-2.0.so.0"))
               (("libgdk-3.so.0")
                (search-input-file inputs "/lib/libgdk-3.so.0")))))
         (add-after 'install 'install-doc
           (lambda* (#:key inputs outputs #:allow-other-keys)
             (let* ((data (string-append (assoc-ref outputs "doc") "/share"))
                    (doc (string-append data "/doc/" ,name "-" ,version))
                    (html (string-append doc "/html")))
               (setenv "LD_LIBRARY_PATH"
                       (string-append (assoc-ref inputs "cairo") "/lib" ":"
                                      (assoc-ref inputs "gdk-pixbuf") "/lib"))
               (setenv "LANG" "en_US.UTF-8")
               (mkdir-p html)
               (for-each (lambda (file)
                           (copy-file (string-append "." file)
                                      (string-append doc file)))
                         '("/README.rst" "/NEWS.rst"))
               (system* "python" "setup.py" "build_sphinx")
               (copy-recursively "docs/_build/html" html)
               #t))))))
    (home-page "https://github.com/Kozea/cairocffi")
    (synopsis "Python bindings and object-oriented API for Cairo")
    (description
     "Cairocffi is a CFFI-based drop-in replacement for Pycairo, a set of
Python bindings and object-oriented API for cairo.  Cairo is a 2D vector
graphics library with support for multiple backends including image buffers,
PNG, PostScript, PDF, and SVG file output.")
    (license license:bsd-3)))

(define-public python-decorator
  (package
    (name "python-decorator")
    (version "5.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "decorator" version))
       (sha256
        (base32 "0q03vavcj2hxnv6006wiqnw7bbqq8rpw90yclyq39xsj6wa6dwk5"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'custom
           #:test-flags #~(list "tests/test.py")))
    (native-inputs
     (list python-setuptools))
    (home-page "https://pypi.org/project/decorator/")
    (synopsis "Python module to simplify usage of decorators")
    (description
     "The aim of the decorator module is to simplify the usage of decorators
for the average programmer, and to popularize decorators usage giving examples
of useful decorators, such as memoize, tracing, redirecting_stdout, locked,
etc.  The core of this module is a decorator factory.")
    (license license:expat)))

(define-public python-drmaa
  (package
    (name "python-drmaa")
    (version "0.7.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "drmaa" version))
       (sha256
        (base32 "0xzqriqyvk5b8hszbavsyxd29wm3sxirm8zvvdm73rs2iq7w4hkx"))))
    (build-system pyproject-build-system)
    ;; The test suite requires libdrmaa which is provided by the cluster
    ;; environment.  At runtime the environment variable DRMAA_LIBRARY_PATH
    ;; should be set to the path of the libdrmaa library.
    (arguments
     (list
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          ;; Loading the library fails because DRMAA_LIBRARY_PATH
          ;; is not configured.
          (delete 'sanity-check))))
    (native-inputs (list python-setuptools))
    (home-page "https://pypi.org/project/drmaa/")
    (synopsis "Python bindings for the DRMAA library")
    (description
      "A Python package for Distributed Resource Management (DRM) job
submission and control.  This package is an implementation of the DRMAA 1.0
Python language binding specification.")
    (license license:bsd-3)))

(define-public python-grako
  (package
    (name "python-grako")
    (version "3.99.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "grako" version ".zip"))
       (sha256
        (base32 "0r63i68wcnv63rfjkasq1ah81frz61a6mzbcnaxhrkdpx84p7hzw"))
       (snippet
        #~(begin (use-modules (guix build utils))
                 (substitute* "grako/grammars.py"
                   (("from collections import defaultdict, Mapping")
                    (string-append "from collections import defaultdict\n"
                                   "from collections.abc import Mapping")))
                 (substitute* '("grako/util.py"
                                "grako/walkers.py")
                   (("collections\\.Mapping") "collections.abc.Mapping"))))))
    (build-system pyproject-build-system)
     ;; XXX: Test file 'grako.ebnf' is missing from archive.
    (arguments (list #:tests? #f))
    (native-inputs (list unzip python-pytest python-setuptools))
    (home-page "https://pypi.org/project/grako")
    (synopsis "EBNF parser generator")
    (description
     "Grako takes a grammar in a variation of EBNF as input, and outputs a
memoizing PEG/Packrat parser in Python.")
    (license license:bsd-3)))

(define-public python-grandalf
  (package
    (name "python-grandalf")
    ;; `guix refresh` will try to upgrade to v0.55555, but that is older.
    (version "0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bdcht/grandalf")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "199f86hz3g4p237ma4j27rzwmska3bxzsbgq20i4l4pczf9v7ax0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'patch-requirements
            (lambda _
              (substitute* "setup.py"
                (("install_requires=\\['pyparsing'],") "")))))))
    (native-inputs
     (list python-setuptools python-pytest))
    (propagated-inputs
     (list python-numpy python-ply))
    (home-page "https://github.com/bdcht/grandalf")
    (synopsis "Graph and drawing algorithms framework")
    (description
     "Grandalf is a Python package made for experimentations with graphs
drawing algorithms.  It is written in pure Python, and currently implements
two layouts: the Sugiyama hierarchical layout and the force-driven or energy
minimization approach.  While not as fast or featured as graphviz or other
libraries like OGDF (C++), it provides a way to walk and draw graphs no larger
than thousands of nodes, while keeping the source code simple enough to tweak
and hack any part of it for experimental purpose.  With a total of about 1500
lines of Python, the code involved in drawing the Sugiyama (dot) layout fits
in less than 600 lines.  The energy minimization approach is comprised of only
250 lines!

Grandalf does only 2 not-so-simple things:
@itemize
@item computing the nodes (x,y) coordinates (based on provided nodes
dimensions, and a chosen layout)
@item routing the edges with lines or nurbs
@end itemize

It doesn’t depend on any GTK/Qt/whatever graphics toolkit.  This means that it
will help you find where to draw things like nodes and edges, but it’s up to
you to actually draw things with your favorite toolkit.")
    ;; The user can choose either license.
    (license (list license:gpl2 license:epl1.0))))

(define-public python-gridmap
  (package
    (name "python-gridmap")
    (version "0.15.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pygridtools/gridmap")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0w1sxvhv5ldbzkx70q7036yvny0zsylc4zj7nzmp3nhjdl8whlrm"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f ;XXX: freezes or timeout
           #:test-backend #~'nose))
    (native-inputs
     (list ;; python-pynose
           python-setuptools))
    (propagated-inputs
     (list python-cherrypy
           python-cloudpickle
           python-psutil
           python-drmaa
           python-pyzmq))
    (home-page "https://github.com/pygridtools/gridmap")
    (synopsis "Create jobs on a cluster directly from Python")
    (description
      "Gridmap is a Python package to allow you to easily create jobs on the
cluster directly from Python.  You can directly map Python functions onto the
cluster without needing to write any wrapper code yourself.")
    (license license:gpl3+)))

(define-public python-honcho
  (package
    (name "python-honcho")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/nickstenning/honcho")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hdp4cr6imxrlyg9x9xj5r6qdmgi63ffvmqjrr1kjs3qapan6s4l"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Tests below fail with the error
     ;; ValueError: The 'honcho.export.xxx' package was not installed
     ;; in a way that PackageLoader understands.
     ;; Probably safe because it's testing for different init systems.
     (list #:test-flags #~(list "--ignore" "tests/integration/test_export.py"
                                "--ignore" "tests/test_export_runit.py"
                                "--ignore" "tests/test_export_supervisord.py"
                                "--ignore" "tests/test_export_systemd.py"
                                "--ignore" "tests/test_export_upstart.py")))
    (native-inputs
     (list python-jinja2 python-mock python-pytest python-setuptools python-wheel))
    (propagated-inputs
     (list python-colorama))
    (home-page "https://github.com/nickstenning/honcho")
    (synopsis "Manage Procfile-based applications")
    (description
      "A Procfile is a file which describes how to run an application
consisting of several processes. honcho starts all listed processes.
The output of all running processes is collected by honcho and
displayed.")
    (license license:expat)))

(define-public python-hsluv
  (package
    (name "python-hsluv")
    (version "5.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "hsluv" version))
       (sha256
        (base32 "0bmpd7qxcvin8szblilxmw50v7mygf6a6i180h82123s893gk092"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://www.hsluv.org")
    (synopsis "Human-friendly HSL colour space implemented in Python")
    (description
     "Human-friendly @acronym{Hue Saturation Lightness,HSL}.  HSLuv extends
@url{http://en.wikipedia.org/wiki/CIELUV,CIELUV} with a new saturation
component that allows you to span all the available chroma as a neat
percentage.")
    (license license:expat)))

(define-public python-pebble
  (package
    (name "python-pebble")
    (version "4.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pebble" version))
       (sha256
        (base32 "16siqc3brbk7dp4d9sg48bjl6a8wyy24aib3il1hf4y2624draxh"))))
    (build-system python-build-system)
    (native-inputs
     (list python-pytest))
    (arguments
     `(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda _ (invoke "python" "-m" "pytest" "-sv"))))))
    (home-page "https://github.com/noxdafox/pebble")
    (synopsis "Threading and multiprocessing for Python")
    (description
     "Pebble aims to help manage threads and processes in an easier way.  It
wraps Python's standard library threading and multiprocessing objects.")
    (license license:lgpl3+)))

(define-public python-pexpect
  (package
    (name "python-pexpect")
    (version "4.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pexpect" version))
       (sha256
        (base32 "03ykxacc64ijldbpa31v5lxw93an0z0xmhm21q2i369w7w942zgf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    (list
                     ;; Disable failing test, see
                     ;; <https://github.com/pexpect/pexpect/issues/568>.
                     "not test_bash"
                     ;; Fails with attempt to find OpenSSL.
                     "test_large_stdout_stream"
                     ;; Tests fail while trying to find
                     ;; tmp-pexpect-xxxxxxxxxxxx directories.
                     "test_run_uses_env"
                     "test_run_uses_env_path"
                     "test_run_uses_env_path_over_path"
                     "test_spawn_uses_env"
                     ;; Fails with assertion error: assert 0 == 500
                     "test_before_across_chunks"
                     ;; Bash is enough for tests.
                     "test_zsh")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'prepare-tests
            (lambda _
              (substitute* (find-files "tests")
                (("/bin/bash") (which "bash"))
                (("/bin/echo") (which "echo"))
                (("/bin/ls") (which "ls"))
                (("/bin/which") (which "which"))
                ;; Many tests try to use the /bin directory which is not
                ;; present in the build environment.  Use one that's non-empty
                ;; and unlikely to change.
                (("/bin'") "/dev'")))))))
    (native-inputs
     (list bash    ;full Bash for 'test_replwrap.py'
           man-db
           python-pytest
           python-setuptools
           python-wheel
           which))
    (propagated-inputs
     (list python-ptyprocess))
    (home-page "https://pexpect.readthedocs.org/")
    (synopsis "Controlling interactive console applications")
    (description
     "Pexpect is a pure Python module for spawning child applications;
controlling them; and responding to expected patterns in their output. Pexpect
works like Don Libes’ Expect.  Pexpect allows your script to spawn a child
application and control it as if a human were typing commands.")
    (license license:isc)))

(define-public python-sexpdata
  (package
    (name "python-sexpdata")
    (version "1.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sexpdata" version))
       (sha256
        (base32
         "02f1v96wzqf3jgwbp1fvankszkzvyff53fa4ks7nyxpnc41ppdlj"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; no tests
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/jd-boyd/sexpdata")
    (synopsis "S-expression parser for Python")
    (description
     "Sexpdata is an S-expression parser/serializer.  It has load and dump
functions like pickle, json or PyYAML module.")
    (license license:bsd-3)))

(define-public python-pathable
  (package
    (name "python-pathable")
    (version "0.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pathable" version))
       (sha256
        (base32 "1ayw9jzlw0qrz51rcfbba00xqq0c7vs3lgwrib67c1z5bcqrv1jw"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-poetry-core))
    (home-page "https://github.com/p1c2u/pathable")
    (synopsis "Object-oriented paths")
    (description "With this package you can traverse resources like paths and
access resources on demand with separate accessor layer.")
    (license license:asl2.0)))

(define-public python-importlib-resources
  (package
    (name "python-importlib-resources")
    (version "6.5.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "importlib_resources" version))
              (sha256
               (base32
                "0b7dizkjyjpwqm2dsmb40fy7iskwl3xv93yr9622ik2vxynqfpqq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-jaraco-test
           python-jaraco-collections
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-zipp))
    (home-page "https://importlib-resources.readthedocs.io/")
    (synopsis "Read resources from Python packages")
    (description
     "@code{importlib_resources} is a backport of Python 3's standard library
@code{importlib.resources} module for Python 2.7, and Python 3.")
    (license license:asl2.0)))

(define-public python-importlib-metadata
  (package
    (name "python-importlib-metadata")
    (version "8.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "importlib_metadata" version))
       (sha256
        (base32
         "004h71gl22rg57wxd0hgy72pdksn62ng4waldjhhm29v4anq2fyi"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags #~(list "tests")))
    (native-inputs
     (list python-jaraco-test
           python-packaging-bootstrap
           python-pyfakefs
           python-pytest-bootstrap
           python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-zipp))
    (home-page "https://importlib-metadata.readthedocs.io/")
    (synopsis "Read metadata from Python packages")
    (description
     "@code{importlib_metadata} is a library which provides an API for
accessing an installed Python package's metadata, such as its entry points or
its top-level name.  This functionality intends to replace most uses of
@code{pkg_resources} entry point API and metadata API.  Along with
@code{importlib.resources} in Python 3.7 and newer, this can eliminate the
need to use the older and less efficient @code{pkg_resources} package.")
    (license license:asl2.0)))

(define-public python-importmagic
  (package
    (name "python-importmagic")
    (version "0.1.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alecthomas/importmagic")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1asijinpirq9ips9drsibyg2bj6qbpryz27n91akhvmzn78pbz7s"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/alecthomas/importmagic")
    (synopsis "Library for adding, removing and managing Python imports")
    (description
     "Importmagic is a Python library for automatically managing imports by
finding unresolved symbols in Python code and their corresponding imports.")
    (license license:bsd-3)))

(define-public python-inotify-simple
  (package
    (name "python-inotify-simple")
    (version "1.3.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/chrisjbillington/inotify_simple")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dv9svrcz31acyq9smjlnw75xv3x5wpn5h6s8j8h0vrqyl3d7l05"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "example.py")))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/chrisjbillington/inotify_simple")
    (synopsis "Simple wrapper around inotify library")
    (description
     "@code{inotify-simple} is a simple wrapper around inotify library.")
    (license license:bsd-3)))

(define-public python-interface-meta
  (package
    (name "python-interface-meta")
    (version "1.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "interface_meta" version))
       (sha256
        (base32 "18brkmz2ssjikkrkb23cwccp683yi6y1alfdbmjvjgxpppw96i4a"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/matthewwardrop/interface_meta")
    (synopsis
     "API for enforced method signatures and consistent documentation")
    (description
     "This package provides a convenient way to expose an extensible API with
enforced method signatures and consistent documentation.")
    (license license:expat)))

(define-public python-jaraco-classes
  (package
    (name "python-jaraco-classes")
    (version "3.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco.classes" version))
       (sha256
        (base32 "1k9s7wxhsy15730qab8bry7kpgl4yk3wch45ikfw0f823nsj9827"))))
    (build-system pyproject-build-system)
    (arguments
     (list  ; Do not test the myproject.toml build as it pulls dependencies.
      #:test-flags '(list "-k" "not project")))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-more-itertools))
    (home-page "https://github.com/jaraco/jaraco.classes")
    (synopsis "Utility functions for Python class constructs")
    (description "This Python library contains utility functions for Python
class constructs.")
    (license license:expat)))

(define-public python-jaraco-collections
  (package
    (name "python-jaraco-collections")
    (version "5.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco_collections" version))
       (sha256
        (base32 "1v8qza70spm4d822bm7wq3j2cyd33nqg2i87n99spw6np9q1kf6s"))))
    (build-system pyproject-build-system)
    ;; Do not test pyproject.toml with python-pytest-checkdocs as it tries to
    ;; download dependencies.
    (arguments
     '(#:test-flags '("-k" "not project")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-jaraco-text))
    (home-page "https://github.com/jaraco/jaraco.collections")
    (synopsis "Provides various collection objects")
    (description
     "This package provides models and classes to supplement the
standard library @code{collections} module.  Examples include
@itemize
@item
RangeMap: A mapping that accepts a range of values for keys.
@item
Projection: A subset over an existing mapping.
@item
KeyTransformingDict: Generalized mapping with keys transformed by a function.
@item
FoldedCaseKeyedDict: A dict whose string keys are case-insensitive.
@item
BijectiveMap: A map where keys map to values and values back to their keys.
@item
ItemsAsAttributes: A mapping mix-in exposing items as attributes.
@item
IdentityOverrideMap: A map whose keys map by default to themselves unless overridden.
@item
FrozenDict: A hashable, immutable map.
@item
Enumeration: An object whose keys are enumerated.
@item
Everything: A container that contains all things.
@item
Least, Greatest: Objects that are always less than or greater than any other.
@item
pop_all: Return all items from the mutable sequence and remove them from that sequence.
@item
DictStack: A stack of dicts, great for sharing scopes.
@item
WeightedLookup: A specialized RangeMap for selecting an item by weights.
@end itemize")
    (license license:expat)))

(define-public python-jaraco-context
  (package
    (name "python-jaraco-context")
    (version "6.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco_context" version))
       (sha256
        (base32 "1cyija3n4481r1ykxdx342m07lrfyg4ygbn0in9i82yganjlxblv"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;no tests in PyPI archive and Git checkout
    (native-inputs
     (list python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-backports-tarfile))
    (home-page "https://github.com/jaraco/jaraco.context")
    (synopsis "Context managers Python library")
    (description "This Python library provides context managers-related
procedures.")
    (license license:expat)))

(define-public python-jaraco-functools
  (package
    (name "python-jaraco-functools")
    (version "4.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco_functools" version))
       (sha256
        (base32 "0lvk12qbl5zd1ikr6xzflj1jcs3vwgmwgy2k63x5dkmbrjzllqxy"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? (not (%current-target-system))
           ;; Do not test the myproject.toml build as it pulls dependencies.
           ;; Do not run a test that tries to emulate a broken proprietary
           ;; CI set-up, fails to do so correctly, and then throws an error.
           #:test-flags
           '(list "-k" "not project and not test_function_throttled")))
    (native-inputs
     (list python-jaraco-classes
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs (list python-more-itertools))
    (home-page "https://github.com/jaraco/jaraco.functools")
    (synopsis "Python library extending Python's @code{functools}")
    (description "This library extends the standard @code{functools} Python
module with a few extra procedures.")
    (license license:expat)))

(define-public python-jaraco-packaging
  (package
    (name "python-jaraco-packaging")
    (version "9.4.0") ;the latest version compatible with python-pypa-build@0.9.0
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jaraco.packaging" version))
        (sha256
          (base32
            "1djpwmw2gmb6i9by1bc4lh4qlkvifgsqfj5alb9xz7pa80fcm416"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))         ;no tests in PyPI archive
    (native-inputs
     (list python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-pypa-build
           python-virtualenv
           python-domdf-python-tools
           python-jaraco-context
           python-sphinx))
    (home-page "https://github.com/jaraco/jaraco.packaging")
    (synopsis "Tools to supplement packaging Python releases")
    (description
     "This package provides various tools to supplement packaging Python
releases.")
    (license license:expat)))

(define-public python-jaraco-path
  (package
    (name "python-jaraco-path")
    (version "3.7.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jaraco/jaraco.path")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12bj9za1yp0yn0ppya6a4kwgmh7hvmw64x7ivp4y0sbv20r0vfdq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm))
    (home-page "https://github.com/jaraco/jaraco.path")
    (synopsis "Miscellaneous path functions")
    (description
     "This package provides miscellaneous path functions for Python.")
    (license license:expat)))

(define-public python-jaraco-test
  (package
    (name "python-jaraco-test")
    (version "5.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco_test" version))
       (sha256
        (base32 "0xfkly5w4i4npi4pq1g32y8q8iijkq4pfcfs8wcjhfn4amj6212c"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags '(list "-k" "http")))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-jaraco-collections
           python-jaraco-context
           python-jaraco-functools))
    (home-page "https://github.com/jaraco/jaraco.test")
    (synopsis "Testing support by jaraco")
    (description "This package provides testing support by jaraco.")
    (license license:expat)))

(define-public python-jaraco-text
  (package
    (name "python-jaraco-text")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jaraco_text" version))
       (sha256
        (base32 "1c0dy5jvhigcyryi2h8n1m87dnhyxr7w01n9shwzkdlslv7gwwav"))))
    (build-system pyproject-build-system)
    ;; Do not test pyproject.toml with python-pytest-checkdocs as it tries to
    ;; download dependencies.
    (arguments
     '(#:test-flags '("-k" "not project")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-autocommand
           python-inflect
           python-jaraco-context
           python-jaraco-functools
           python-more-itertools))
    (home-page "https://github.com/jaraco/jaraco.text")
    (synopsis "Provides various routines for text manipulation")
    (description
     "This package provides handy routines for dealing with text,
such as wrapping, substitution, trimming, stripping, prefix and suffix
removal, line continuation, indentation, comment processing, identifier
processing, values parsing, case insensitive comparison, and more.")
    (license license:expat)))

(define-public python-jaraco-vcs
  (package
    (name "python-jaraco-vcs")
    (version "2.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url "https://github.com/jaraco/jaraco.vcs")
                           (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256 (base32 "1n9f0l4zp8dbbq2ha93bd9z6gb9y7gsmbd4jkl5gcm51qpsq4vpm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Ignore doctests.
      #~(list "--ignore-glob=jaraco/vcs/*.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs (list python-jaraco-classes
                             python-jaraco-path
                             python-jaraco-versioning
                             python-more-itertools
                             python-packaging
                             python-dateutil
                             python-tempora))
    (native-inputs (list python-pygments
                         python-pytest
                         python-pytest-home
                         python-setuptools
                         python-setuptools-scm))
    (home-page "https://github.com/jaraco/jaraco.vcs")
    (synopsis "Utilities for working with VCS repositories")
    (description
     "This package provides facilities for working with VCS repositories in
Python.")
    (license license:expat)))

(define-public python-jaraco-versioning
  (package
    (name "python-jaraco-versioning")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/jaraco/jaraco.versioning")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12svnpa5sl3r5lci9bybzy5gb8pd4clfkl65x5hsap00ada2w91r"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (propagated-inputs (list python-packaging))
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm))
    (home-page "https://github.com/jaraco/jaraco.versioning")
    (synopsis "Version manipulation utils")
    (description
     "This package builds upon @code{python-packaging} to provide more
sophisticated version manipulation.")
    (license license:expat)))

(define-public python-pypytools
  (package
    (name "python-pypytools")
    (version "0.6.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/antocuni/pypytools/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nmq4gsw3hcayj2d96n8n166h0wnmp7n28fqswcn562hx57mlh05"))
       (patches (search-patches "python-pypytools-python-3-fixes.patch"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; These tests are using deprecated py.code module.
      #:test-flags
      #~(list
         "--deselect=pypytools/testing/test_codegen.py::test_def__default_args"
         "--deselect=pypytools/testing/test_codegen.py::test_def_"
         "--deselect=pypytools/testing/test_codegen.py::test_compile"
         "--ignore=pypytools/testing/test_unroll.py"
         ;; clone_func returns an object of the wrong type.
         "--deselect=pypytools/testing/test_util.py::test_clonefunc")))
    (native-inputs
     (list python-freezegun
           python-numpy
           python-pytest
           python-setuptools))
    (propagated-inputs (list python-py))
    (home-page "https://github.com/antocuni/pypytools/")
    (synopsis "Tools to use PyPy-specific features, with CPython fallbacks")
    (description
     "This package provides a collection of useful tools to use PyPy-specific
features, with CPython fallbacks.")
    (license license:x11)))

(define-public python-simplegeneric
  (package
    (name "python-simplegeneric")
    (version "0.8.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "simplegeneric" version ".zip"))
       (sha256
        (base32 "0wwi1c6md4vkbcsfsf8dklf3vr4mcdj4mpxkanwgb6jb1432x5yw"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "-m" "simplegeneric")))
    (native-inputs
     (list unzip python-setuptools))
    (home-page "https://cheeseshop.python.org/pypi/simplegeneric")
    (synopsis "Python module for simple generic functions")
    (description
     "The simplegeneric module lets you define simple single-dispatch generic
functions, akin to Python’s built-in generic functions like @code{len()},
@code{iter()} and so on.  However, instead of using specially-named methods,
these generic functions use simple lookup tables, akin to those used by
e.g. @code{pickle.dump()} and other generic functions found in the Python
standard library.")
    (license license:zpl2.1)))

(define-public python-ipython-genutils
  ;; TODO: This package is retired, check if can be removed, see description.
  (package
    (name "python-ipython-genutils")
    (version "0.1.0")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "ipython_genutils" version))
      (sha256
       (base32 "19l2pp1c64ansr89l3cqh19jdi2ixhssdzx0vz4n6r52a6i281is"))))
    (build-system pyproject-build-system)
    (arguments `(#:tests? #f)) ; no tests
    (native-inputs
     (list python-setuptools))
    (home-page "https://ipython.org")
    (synopsis "Vestigial utilities from IPython")
    (description
     "This package provides retired utilities from IPython.  No packages
outside IPython/Jupyter should depend on it.

This package shouldn't exist.  It contains some common utilities shared by
Jupyter and IPython projects during The Big Split.  As soon as possible, those
packages will remove their dependency on this, and this package will go
away.")
    (license license:bsd-3)))

;;; Variant used to break a cycle with python-ipykernel.
(define-public python-ipyparallel-bootstrap
  (hidden-package
   (package
     (name "python-ipyparallel-bootstrap")
     (version "9.0.1")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ipyparallel" version))
        (sha256
         (base32 "177jk2g8srsddgyb4djbyci93v766vzrnqzzpd7ski804anjqn9f"))))
     (build-system pyproject-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases #~(modify-phases %standard-phases
                    ;; The python-ipykernel is normally propagated but is
                    ;; removed from this package to break the cycle.
                    (delete 'sanity-check))))
     (native-inputs
      (list python-hatchling))
     (propagated-inputs
      (list python-dateutil
            python-decorator
            python-entrypoints
            python-ipython
            ;; python-ipykernel is omitted here to break a cycle.
            python-jupyter-client-bootstrap
            python-psutil
            python-pyzmq
            python-tornado-6
            python-tqdm
            python-traitlets))
     (home-page "https://ipython.org/")
     (synopsis "Interactive Parallel Computing with IPython")
     (description
      "@code{ipyparallel} is a Python package and collection of CLI scripts
for controlling clusters for Jupyter.  @code{ipyparallel} contains the
following CLI scripts:
@enumerate
@item ipcluster - start/stop a cluster
@item ipcontroller - start a scheduler
@item ipengine - start an engine
@end enumerate")
     (license license:bsd-3))))

(define-public python-ipyparallel
  (package
    (inherit python-ipyparallel-bootstrap)
    (name "python-ipyparallel")
    (arguments
     (list #:test-flags #~(list "--pyargs" "ipyparallel")))
    (native-inputs
     (modify-inputs (package-native-inputs python-ipyparallel-bootstrap)
       (append python-ipython
               python-pytest
               python-pytest-asyncio
               python-pytest-tornado
               python-testpath)))
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-ipyparallel-bootstrap)
       (replace "python-jupyter-client-bootstrap" python-jupyter-client)
       (append python-ipykernel)))
    (properties (alist-delete 'hidden? (package-properties
                                        python-ipyparallel-bootstrap)))))

;; TODO: Package python-jupysql which is the maintained fork of this one.
(define-public python-ipython-sql
  (package
    (name "python-ipython-sql")
    (properties '((commit . "e21bc64e172270311d9103602e1c2ec1bcdd5aa8")
                  (revision . "0")))
    (version (git-version "0.5.0"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/catherinedevlin/ipython-sql")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0palwgr7lnar8ykifzhf1qach206bf1xa1zkji2adk9pr9ajsiix"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f                  ;Fail because of prettytable.
           #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (setenv "HOME" (getcwd))
                   (if tests?
                       (invoke "ipython" "-c"
                               "import pytest; pytest.main(['.'])")
                       (format #t "test suite not run.~%")))))))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs
     (list python-ipython
           python-ipython-genutils
           python-prettytable
           python-sqlalchemy-2
           python-sqlparse))
    (home-page "https://github.com/catherinedevlin/ipython-sql")
    (synopsis "RDBMS access via IPython")
    (description "This library connects to a database, using SQLAlchemy URL
connect strings, then issue SQL commands within IPython or IPython Notebook.")
    (license license:expat)))

(define-public python-optree
  (package
    (name "python-optree")
    (version "0.14.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/metaopt/optree")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "17zph1jgzk0zaanj7057qj8x5cml8j66ip0xmlbwmq4396hmdlbs"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These tests fails due to a circular import
      '`("-k" ,(string-append "not test_treespec_pickle_missing_registration"
                              " and not test_import_no_warnings"))))
    (propagated-inputs (list python-typing-extensions))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel
           cmake-minimal
           pybind11))
    (home-page "https://github.com/metaopt/optree")
    (synopsis "Optimized PyTree Utilities")
    (description "This package contains operations on PyTrees (a tree made of
container data structures in Python).")
    (license license:asl2.0)))

(define-public python-jupyter-core
  (package
    (name "python-jupyter-core")
    (version "5.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (string-append (pypi-uri "jupyter_core" version)))
       (sha256
        (base32
         "1n9nyp1skljbbkqp4j7mnihnyp83j9rxm5h4hfn33d7npcr8spxa"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; XXX: These tests fail with "ModuleNotFoundError: No
                    ;; module named 'jupyter_core'".
                    (list "not test_argv0"
                          "test_path_priority "
                          "test_not_on_path"
                          ;; These fail with: An incompatible sibling of
                          ;; 'AsyncTornadoApp' is already instantiated as
                          ;; singleton: SyncTornadoApp
                          "test_async_app"
                          "test_async_tornado_app"
                          ;; Fails with a deprecation warning
                          "test_sync_tornado_run"
                          ;; Expecting pip in the PATH.
                          "test_troubleshoot")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          ;;  Some tests write to $HOME.
          (add-before 'check 'pre-check
            (lambda _ (setenv "HOME" "/tmp")))
          ;; Migration is running whenever etc/jupyter exists, but the
          ;; Guix-managed directory will never contain any migratable IPython
          ;; config files and cannot be written to anyway, so just pretend we
          ;; already did that.
          (add-after 'install 'disable-migration
            (lambda _
              (mkdir-p (string-append #$output "/etc/jupyter"))
              (invoke "touch" (string-append #$output "/etc/jupyter/migrated")))))))
    (native-inputs
     (list python-hatchling
           python-pytest
           python-pytest-timeout))
    (propagated-inputs
     (list python-platformdirs
           python-traitlets))
    ;; This package provides the `jupyter` binary and thus also exports the
    ;; search paths.
    (native-search-paths
     (list (search-path-specification
             (variable "JUPYTER_CONFIG_PATH")
             (files '("etc/jupyter")))
           (search-path-specification
             (variable "JUPYTER_PATH")
             (files '("share/jupyter")))))
    (home-page "https://jupyter.org/")
    (synopsis "Jupyter base package")
    (description
     "Jupyter core is the base package on which Jupyter projects rely.")
    (license license:bsd-3)))

;; Bootstrap variant of jupyter-client, which breaks the loop between ipykernel
;; and jupyter-client by removing the former from its native-inputs and
;; disabling tests.
(define-public python-jupyter-client-bootstrap
  (hidden-package
   (package
     (name "python-jupyter-client-bootstrap")
     (version "7.4.4")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "jupyter_client" version))
        (sha256
         (base32
          "0ck8fb0d582r8izkcn7087zmbmmqf9jkv2abd8p44867k9hdn5jn"))))
     (build-system pyproject-build-system)
     (arguments
      (list
       #:tests? #f
       #:phases
       #~(modify-phases %standard-phases
           ;; The deprecation warnings break the tests.
           (add-after 'unpack 'hide-zmq-deprecation-warnings
             (lambda _
               (substitute* "pyproject.toml"
                 (("\"ignore:There is no current event loop:DeprecationWarning:zmq\"," m)
                  (string-append m "
\"ignore:zmq.eventloop.ioloop.*:DeprecationWarning\",
\"ignore:zmq.tests.BaseZMQTestCase.*:DeprecationWarning\"")))))
           (add-after 'unpack 'set-tool-file-names
             (lambda* (#:key inputs #:allow-other-keys)
               (substitute* "jupyter_client/localinterfaces.py"
                 (("'ip'")
                  (format #f "'~a'" (search-input-file inputs "sbin/ip"))))))
           ;; Hatchling seems to generate entry scripts with invalid imports.
           (add-after 'check 'fix-syntax-error
             (lambda _
               (substitute* (string-append #$output "/bin/.jupyter-kernelspec-real")
                 (("import KernelSpecApp.launch_instance") "import KernelSpecApp")))))))
     (inputs (list iproute))
     (propagated-inputs
      (list python-dateutil
            python-entrypoints
            python-jupyter-core
            python-nest-asyncio
            python-pyzmq
            python-tornado-6
            python-traitlets))
     (native-inputs
      (list python-hatchling))
     (home-page "https://jupyter.org/")
     (synopsis "Jupyter protocol implementation and client libraries")
     (description
      "The @code{jupyter_client} package contains the reference implementation
of the Jupyter protocol.  It also provides client and kernel management APIs
for working with kernels, and the @code{jupyter kernelspec} entrypoint for
installing @code{kernelspec}s for use with Jupyter frontends.")
     (license license:bsd-3))))

(define-public python-jupyter-client
  (let ((base python-jupyter-client-bootstrap))
    (package
      (inherit base)
      (name "python-jupyter-client")
      (arguments
       (substitute-keyword-arguments (package-arguments base)
         ((#:tests? _ #f)
          (not (%current-target-system)))
         ((#:phases phases #~%standard-phases)
          #~(modify-phases #$phases
              (replace 'check
                (lambda* (#:key tests? #:allow-other-keys)
                  (when tests?
                    ;; Some tests try to write to $HOME.
                    (setenv "HOME" "/tmp")
                    ;; jupyter-core demands this be set.
                    (setenv "JUPYTER_PLATFORM_DIRS" "1")
                    (invoke "pytest" "-vv" "-Wignore::DeprecationWarning"
                            "-k"
                            ;; XXX "RuntimeError: Kernel died before replying
                            ;; to kernel_info", but there's no more
                            ;; information.
                            "not test_start_parallel_process_kernels"))))))))
      (native-inputs
       (list python-hatchling
             python-pytest
             python-pytest-asyncio
             python-pytest-timeout
             python-async-generator
             python-ipython
             python-ipykernel-bootstrap))
      (properties (alist-delete 'hidden? (package-properties base))))))

(define-public python-backcall
  (package
    (name "python-backcall")
    (version "0.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/takluyver/backcall/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0br41zib1zph2jazanyjfl03rrb7frplk639fb10wvdqkrzgm6cd"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://github.com/takluyver/backcall/")
    (synopsis "Specifications for callback functions passed in to an API")
    (description
     "If your code lets other people supply callback functions, it's important
to specify the function signature you expect, and check that functions support
that.  Adding extra parameters later would break other peoples code unless
you're careful.  The @code{backcall} package provides a way of specifying the
callback signature using a prototype function.")
    (license license:bsd-3)))

(define-public python-pubmed-parser
  (package
    (name "python-pubmed-parser")
    (version "0.3.1")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/titipata/pubmed_parser")
                    (commit version)))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "195cmjjg7xdwjj5455h78q7jnxnccia07a19xwndhlkxv7vk9v60"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-lxml
           python-numpy
           python-requests
           python-six
           python-unidecode))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools
           python-wheel))
    (home-page "https://github.com/titipata/pubmed_parser")
    (synopsis "Parser for Pubmed Open-Access Subset and MEDLINE XML repository")
    (description
     "This package provides a Python parser for Pubmed Open-Access Subset and
MEDLINE XML repository.")
    (license license:expat)))

(define-public python-pure-eval
  (package
    (name "python-pure-eval")
    (version "0.2.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pure_eval" version))
       (sha256
        (base32 "0hmg1qcv1h5k0dyj7sfp54ibnmjrvf4awdc6gin5fk2n80zrhkjz"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/alexmojaki/pure_eval")
    (synopsis "Python library to evaluate abstract syntax tree nodes")
    (description "The @code{pure_eval} Python library can safely evaluate
abstract syntax tree (AST) nodes without side effects.")
    (license license:expat)))

(define-public python-puremagic
  (package
    (name "python-puremagic")
    (version "1.28")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
             (url "https://github.com/cdgriffith/puremagic")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0sffrjjqh37ijwnggyvs2rfm4iwaz2m395wqg0x727wv8i0x3f3b"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/cdgriffith/puremagic")
    (synopsis "Pure Python implementation of magic file detection")
    (description
     "This package implements a functionality that will identify a file based
off it's magic numbers.")
    (license license:expat)))

(define-public python-ast-decompiler
  (package
    (name "python-ast-decompiler")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ast_decompiler" version))
       (sha256
        (base32 "0dw3fck4ajilphqw4hdpa8pmqxg3jfk2xkmjnk3kx5pqwl3sbhzg"))
       ;; We need to manually create an __init__.py file under the tests/
       ;; directory, since it is not included in the distributed
       ;; version. (See:
       ;; https://github.com/JelleZijlstra/ast_decompiler/issues/52).
       (modules '((guix build utils)))
       (snippet '(call-with-output-file "tests/__init__.py"
                   (const #t)))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://github.com/JelleZijlstra/ast_decompiler")
    (synopsis
     "Decompile an @acronym{AST, Abstract Syntax Tree} to Python code")
    (description
     "This library provides functionality to decompile @acronym{AST, Abstract
Syntax Tree} objects, as generated by the standard library @code{ast} module,
to Python code.")
    (license license:asl2.0)))

(define-public python-asttokens
  (package
    (name "python-asttokens")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asttokens" version))
       (sha256
        (base32 "1ixv6n8cg08n9h6rwyhd3lkzyjiwpbfv56dk338w3c32inm8pk8d"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-astroid
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/gristlabs/asttokens")
    (synopsis "Python library to annotate abstract syntax trees")
    (description "The @code{asttokens} module annotates Python abstract syntax
trees (ASTs) with the positions of tokens and text in the source code that
generated them.  It makes it possible for tools that work with logical AST
nodes to find the particular text that resulted in those nodes, for example
for automated refactoring or highlighting.")
    (license license:asl2.0)))

(define-public python-littleutils
  (package
    (name "python-littleutils")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "littleutils" version))
       (sha256
        (base32 "069xlm6vp1rprgrl4gsg3fd2vg0nzdw7v2qij7i45v8c080mp0y7"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ;no tests in PyPIi archive or Git checkout
    (native-inputs
     (list python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/alexmojaki/littleutils")
    (synopsis "Python utility function collection")
    (description "@code{littleutils} is a small collection of Python utility
functions, useful in the context of writing unit tests among other uses.")
    (license license:expat)))

(define-public python-ipython
  (package
    (name "python-ipython")
    (version "8.37.0")   ;it's the latest version in 8.*.* series
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ipython/ipython")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "02jrmqalcbj0vg887ssavlk6hqyiqkkk4y0cha8vcfbzwibp7lhc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; 1523 passed, 90 skipped, 5 deselected, 3 xfailed, 722 warnings
      #:test-flags
      #~(list "-k" (string-join
                    ;; These need git.
                    (list "not test_json_getsysinfo"
                          "IPython.utils.sysinfo.sys_info"
                          ;; Failed: DID NOT RAISE
                          "test_timeit_raise_on_interrupt"
                          "test_script_raise_on_interrupt"
                          "test_time_raise_on_interrupt")
                    " and not "))
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'make-docs-reproducible
           (lambda _
             (substitute* "IPython/sphinxext/ipython_directive.py"
               ((".*import datetime") "")
               ((".*datetime.datetime.now\\(\\)") "")
               (("%timeit") "# %timeit"))))
         (replace 'check
           (lambda* (#:key tests? test-flags #:allow-other-keys)
             (when tests?
               (setenv "HOME" "/tmp/")  ;required by some tests
               (apply invoke "python" "-m" "pytest" "-vv"
                      test-flags)))))))
    (inputs (list readline which))
    (propagated-inputs
     (list python-colorama
           python-decorator
           python-exceptiongroup
           python-jedi
           python-matplotlib-inline
           python-pexpect
           python-prompt-toolkit
           python-pygments
           python-stack-data
           python-traitlets
           python-typing-extensions))
    (native-inputs
     (list python-curio
           python-matplotlib
           python-nbformat
           python-numpy
           python-pandas
           python-pickleshare
           python-pytest
           python-pytest-asyncio-0.21
           python-setuptools
           python-testpath
           python-wheel))
    (home-page "https://ipython.org")
    (synopsis "IPython is a tool for interactive computing in Python")
    (description
     "IPython provides a rich architecture for interactive computing with:
Powerful interactive shells, a browser-based notebook, support for interactive
data visualization, embeddable interpreters and tools for parallel
computing.")
    (properties '((cpe-name . "ipython")))
    (license license:bsd-3)))

(define-public python-ipython-documentation
  (package
    (inherit python-ipython)
    (name "python-ipython-documentation")
    (version (package-version python-ipython))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-pythonpath
            (lambda _
              ;; Ensure this fixed (via the
              ;; "python-ipython-documentation-chars.patch" patch) copy of
              ;; IPython gets used.
              (setenv "PYTHONPATH" (string-append (getcwd)))))
          (add-before 'build 'configure-sphinx-for-xelatex
            (lambda _
              ;; Use XeLaTeX instead of PDFLaTeX, as it can
              ;; cope with the Unicode characters present in the
              ;; contributors page, for example.
              (substitute* "docs/source/conf.py"
                (("project = 'IPython'.*" all)
                 (string-append all "latex_engine = 'xelatex'\n")))
              ;; XXX: The Sphinx-generated ipython.tex specifies the GNU
              ;; FreeFont font to be searched via its extension, which uses
              ;; kpathsea instead of fontconfig and fail (see:
              ;; https://github.com/sphinx-doc/sphinx/issues/10347).  Create a
              ;; symlink to GNU FreeFont and add it to the TEXMF tree via
              ;; GUIX_TEXMF.
              (mkdir-p "texmf-dist/fonts/opentype/public")
              (symlink (string-append
                        #$(this-package-native-input "font-gnu-freefont")
                        "/share/fonts/opentype")
                       (string-append
                        (getcwd) "/"
                        "texmf-dist/fonts/opentype/public/gnu-freefont"))
              (setenv "GUIX_TEXMF" (string-append (getenv "GUIX_TEXMF") ":"
                                                  (getcwd) "/texmf-dist"))))
          (delete 'build)
          (delete 'check)
          (replace 'install
            (lambda* (#:key outputs #:allow-other-keys)
              (let* ((data (string-append #$output "/share"))
                     (doc (string-append data "/doc/" #$name "-" #$version))
                     (html (string-append doc "/html"))
                     (info (string-append data "/info")))
                (invoke "make" "-C" "docs" "info" "html" "pdf"
                        (string-append "SPHINXOPTS=-j"
                                       (number->string (parallel-job-count))))
                (install-file "COPYING.rst" doc)
                (copy-recursively "examples" (string-append doc "/examples"))
                ;; Install HTML documentation.
                (copy-recursively "docs/build/html" html)
                ;; Likewise for the PDF.
                (install-file "docs/build/latex/ipython.pdf" doc)
                ;; Likewise for the info manual.
                (install-file "docs/build/texinfo/ipython.info" info)
                (symlink (string-append html "/_images")
                         (string-append info "/ipython-figures"))))))))
    (native-inputs
     (list fontconfig                   ;for XDG_DATA_DIRS to locate fonts
           font-gnu-freefont
           graphviz
           python-docrepr
           python-ipykernel
           python-sphinx
           python-sphinx-rtd-theme
           texinfo
           (texlive-local-tree
            (list texlive-latexmk
                  texlive-polyglossia
                  texlive-xetex
                  texlive-xindy))))))

(define-public python-ipython-pygments-lexers
  (package
    (name "python-ipython-pygments-lexers")
    (version "1.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ipython/ipython-pygments-lexers/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "154vbpp9mkblsk1d0w8x8mybwgn5gz6mjgg77nqyn75ky0banrd7"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-pygments))
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://github.com/ipython/ipython-pygments-lexers/")
    (synopsis "Plugin for IPython code sessions")
    (description
     "This package defines a variety of Pygments lexers for highlighting IPython
code.")
    (license license:bsd-3)))

(define-public python-pydbus
  (package
    (name "python-pydbus")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pydbus" version))
       (sha256
        (base32 "0b0gipvz7vcfa9ddmwq2jrx16d4apb0hdnl5q4i3h8jlzwp1c1s2"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f ; no tests in PyPI, git tests require running DBus
           #:phases
           #~(modify-phases %standard-phases
               (add-after 'unpack 'fix-comparability-with-pygobject
                 (lambda _
                   (substitute* "pydbus/_inspect3.py"
                     (("getargspec")
                      "getfullargspec")))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-pygobject))
    (home-page "https://github.com/LEW21/pydbus")
    (synopsis "Pythonic D-Bus library")
    (description
     "Pydbus provides a pythonic interface to the D-Bus message bus system.
Pydbus can be used to access remote objects and also for object publication.
It is based on PyGI, the Python GObject Introspection bindings, which is the
recommended way to use GLib from Python.")
    (license license:lgpl2.1+)))

(define-public python-dbus
  (package
    (name "python-dbus")
    (version "1.2.18")
    (source
     (origin
       (method url-fetch)
       (uri (string-append "https://dbus.freedesktop.org/releases/dbus-python/"
                           "dbus-python-" version ".tar.gz"))
       (sha256
        (base32 "0q3jrw515z98mqdk9x822nd95rky455zz9876f1nqna5igkd3gcj"))))
    (build-system gnu-build-system)
    (native-inputs
     (list pkg-config))
    (inputs
     `(("python" ,python-wrapper)
       ("dbus-glib" ,dbus-glib)))
    (synopsis "Python bindings for D-bus")
    (description "python-dbus provides bindings for libdbus, the reference
implementation of D-Bus.")
    (home-page "https://www.freedesktop.org/wiki/Software/DBusBindings/")
    (properties `((python2-variant . ,(delay python2-dbus))))
    (license license:expat)))

(define-public python-notify2
  (package
    (name "python-notify2")
    (version "0.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "notify2" version))
       (sha256
        (base32
         "0z8rrv9rsg1r2qgh2dxj3dfj5xnki98kgi3w839kqby4a26i1yik"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))                    ; tests depend on system state
    (propagated-inputs
     (list python-dbus))
    (home-page "https://bitbucket.org/takluyver/pynotify2")
    (synopsis "Python interface to D-Bus notifications")
    (description
     "Pynotify2 provides a Python interface for sending D-Bus notifications.
It is a reimplementation of pynotify in pure Python, and an alternative to
the GObject Introspection bindings to libnotify for non-GTK applications.")
    (license (list license:bsd-2
                   license:lgpl2.1+))))

;; beautifulsoup4 has a totally different namespace than 3.x,
;; and pypi seems to put it under its own name, so I guess we should too
(define-public python-beautifulsoup4
  (package
    (name "python-beautifulsoup4")
    (version "4.14.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beautifulsoup4" version))
       (sha256
        (base32
         "11pvlxgxxn8bcgfsbbfrb9b9jw3ma7qggycycsx6ndbd332v34k2"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-soupsieve
           python-typing-extensions
           ;; [optional]
           python-cchardet
           python-chardet
           python-charset-normalizer
           python-html5lib
           python-lxml))
    (home-page "https://www.crummy.com/software/BeautifulSoup/bs4/")
    (synopsis "Python screen-scraping library")
    (description
     "Beautiful Soup is a Python library designed for rapidly setting up
screen-scraping projects.  It offers Pythonic idioms for navigating,
searching, and modifying a parse tree, providing a toolkit for
dissecting a document and extracting what you need.  It automatically
converts incoming documents to Unicode and outgoing documents to UTF-8.")
    (license license:expat)))

(define-public python-beautifulsoup4-bootstrap
  (hidden-package
   (package/inherit python-beautifulsoup4
     (arguments
      (list #:tests? #f))
     (native-inputs
      (list python-hatchling))
     (propagated-inputs '()))))

(define-public python-soupsieve
  (package
    (name "python-soupsieve")
    (version "2.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "soupsieve" version))
       (sha256
        (base32 "0shjmvk8yz2ljc16pmizg16bqhk1i8n5al27mlp6sa16d6djya5d"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-beautifulsoup4-bootstrap
           python-hatchling
           python-pytest))
    (home-page "https://github.com/facelessuser/soupsieve")
    (synopsis "CSS selector library")
    (description
     "Soup Sieve is a CSS selector library designed to be used with Beautiful
Soup 4.  It aims to provide selecting, matching, and filtering using modern
CSS selectors.  Soup Sieve currently provides selectors from the CSS level 1
specifications up through the latest CSS level 4 drafts and beyond (though
some are not yet implemented).")
    (license license:expat)))


(define-public python-netifaces
  (package
    (name "python-netifaces")
    (version "0.11.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "netifaces" version))
        (sha256
          (base32 "0cnajf5rl4w1sa72j921scbigr6zndig56cq8ggpx45jdqa7jfh4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test.py")))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/al45tair/netifaces")
    (synopsis "Python module for portable network interface information")
    (description
      "Netifaces is a Python module providing information on network
interfaces in an easy and portable manner.")
    (license license:expat)))

(define-public python-networkx
  (package
    (name "python-networkx")
    (version "3.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "networkx" version))
       (sha256
        (base32 "1qaks3c3h5qlw25z949q3plw8iwgm9h152kwnam64lwc89lkcz1h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count)))))
    (native-inputs
     (list python-pytest
           python-pytest-xdist
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-decorator))
    (home-page "https://networkx.github.io/")
    (synopsis "Python module for creating and manipulating graphs and networks")
    (description
     "NetworkX is a Python package for the creation, manipulation, and study
of the structure, dynamics, and functions of complex networks.")
    (license license:bsd-3)))

(define-public python-datrie
  (package
    (name "python-datrie")
    (version "0.8.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/kmike/datrie")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1jfyhzfjgin370l6chd0cjg521ql3y53db194n94ff6cdbdbg7cg"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'ensure-no-mtimes-pre-1980 'inject-libdatrie
            (lambda* (#:key inputs #:allow-other-keys)
              (let* ((headers (search-input-directory inputs
                                                      "include/datrie"))
                     (base (dirname (dirname headers))))
                (symlink headers "libdatrie/datrie")
                (setenv "LDFLAGS" (string-append "-L" base "/lib")))))
          (add-before 'build 'relax-gcc-14-strictness
            (lambda _
              (setenv "CFLAGS"
                      "-g -O2 -Wno-error=incompatible-pointer-types"))))))
    (native-inputs
     (list python-cython python-hypothesis python-pytest python-setuptools))
    (inputs (list libdatrie))
    (home-page "https://github.com/kmike/datrie")
    (synopsis "Fast, efficiently stored trie for Python")
    (description
     "This package provides a fast, efficiently stored trie implementation for
Python.")
    (license license:lgpl2.1+)))

(define-public python-amply
  (package
    (name "python-amply")
    (version "0.1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "amply" version))
       (sha256
        (base32 "195fg1n5nsl722hk33f6a7ak3n0hfs8yfpqi2xkhdqgqrh1i2hk1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-docutils
           python-pyparsing))
    (home-page "https://github.com/willu47/amply")
    (synopsis "Load and manipulate AMPL/GLPK data as Python data structures")
    (description
     "Amply allows you to load and manipulate AMPL/GLPK data as Python data
structures.")
    (license license:epl1.0)))

(define-public python-pulp
  ;; When updating, check snakemake@N builds still fine, see:
  ;; <https://codeberg.org/guix/guix/issues/4782>.
  (package
    (name "python-pulp")
    (version "2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PuLP" version))
       (sha256
        (base32
         "1dammrg0f1v0r028i3rpxbf2bsyxmjq0q6ihb4x2wsdki44z3bxj"))))
    (build-system pyproject-build-system)
    (arguments
     ;; TODO: They need a special setup, see:
     ;; <https://codeberg.org/guix/guix/pulls/4908>.
     (list #:tests? #f))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-amply))
    (home-page "https://github.com/coin-or/pulp")
    (synopsis "Linear Programming modeler")
    (description
     "PuLP is a Linear Programming modeler written in Python.  PuLP can
generate MPS or LP files and call GLPK, COIN CLP/CBC, CPLEX, and GUROBI to
solve linear problems.")
    (license license:expat)))

(define-public python-py-partiql-parser
  (package
    (name "python-py-partiql-parser")
    (version "0.6.1")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/getmoto/py-partiql-parser")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "008vj0f09gzk6pijwvxs6m860rmszm85is7wgjwifc8y38sqd86s"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest))
    (home-page "https://pypi.org/project/py-partiql-parser/")
    (synopsis "Pure Python PartiQL Parser")
    (description
     "This package provides a tokenizer/parser/executor for the PartiQL
language, in Python.")
    (license license:expat)))

(define-public python-py-tes
  (package
    (name "python-py-tes")
    (version "0.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ohsu-comp-bio/py-tes")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nacmw7whmbfqa6y728l6f646wpgaanfa0v4p5mggag2044v55qx"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-requests-mock python-setuptools))
    (propagated-inputs
     (list python-attrs python-dateutil python-future python-requests))
    (home-page "https://github.com/ohsu-comp-bio/py-tes")
    (synopsis "Library for communicating with the GA4GH Task Execution API")
    (description "This package provides a library for communicating with the
GA4GH Task Execution API.")
    (license license:expat)))

(define-public python-altgraph
  (package
    (name "python-altgraph")
    (version "0.17.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "altgraph" version))
       (sha256
        (base32 "01j48np3g50g6insjkszsz0vifwlm6gspria5vdwlkbciywznnhv"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://altgraph.readthedocs.io")
    (synopsis "Python graph network package")
    (description
"This package provides tools for constructing graphs, BFS and DFS
traversals, topological sort, shortest paths, and more with graphviz
output.")
    (license license:expat)))

(define-public python-pyqrcode
  (package
    (name "python-pyqrcode")
    (properties '((commit . "674a77b5eaf850d063f518bd90c243ee34ad6b5d")
                  (revision . "0")))
    (version (git-version "1.2.1"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/mnooner256/pyqrcode")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ks4sqwcwsnb5r65z6zdfbir34f35sfv3agnlmcq1w36fya2y62m"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'nose))
    (native-inputs (list python-pynose python-pypng python-setuptools))
    (home-page "https://github.com/mnooner256/pyqrcode")
    (synopsis "QR code generator")
    (description
     "Pyqrcode is a QR code generator written purely in Python with SVG, EPS,
PNG and terminal output.")
    (license license:bsd-3)))

(define-public python-seaborn
  (package
    (name "python-seaborn")
    (version "0.13.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "seaborn" version))
              (sha256
               (base32
                "1xzzxrbxsmmk39647vcx7avzdbzxw9vz8pc8yklnakcgk100mrlk"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; 2358 passed, 16 skipped, 6 xfailed, 17 warnings
      #:test-flags
      #~(list "--numprocesses" (number->string (parallel-job-count)) )))
    (native-inputs
     (list python-flit-core
           python-pytest
           python-pytest-xdist))
    (propagated-inputs
     (list python-matplotlib
           python-numpy
           python-pandas
           python-scipy
           python-statsmodels))
    (home-page "https://seaborn.pydata.org/")
    (synopsis "Statistical data visualization")
    (description
     "Seaborn is a library for making attractive and informative statistical
graphics in Python.  It is built on top of matplotlib and tightly integrated
with the PyData stack, including support for numpy and pandas data structures
and statistical routines from scipy and statsmodels.")
    (license license:bsd-3)))

(define-public python-session-info
  (package
    (name "python-session-info")
    (version "1.0.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/joelostblom/session_info")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0w6y764qci5w9925c75xdr8jizgf8189mzzaz4zk5lw1f182yqy4"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; No tests.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-stdlib-list))
    (home-page "https://gitlab.com/joelostblom/session_info")
    (synopsis "Output version information for modules currently loaded")
    (description
     "This package outputs version information for modules loaded in the current
session, Python, and the OS.")
    (license license:bsd-3)))

(define-public python-mpmath
  (package
    (name "python-mpmath")
    (version "1.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/fredrik-johansson/mpmath")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "058ahp0z0gn0z1hwvggrmiir1xag6rzgrfgfg138kjnk5ml9q4gl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://mpmath.org")
    (synopsis "Arbitrary-precision floating-point arithmetic in python")
    (description
     "@code{mpmath} can be used as an arbitrary-precision substitute for
Python's float/complex types and math/cmath modules, but also does much
more advanced mathematics.")
    (license license:bsd-3)))

(define-public python-bigfloat
  (package
    (name "python-bigfloat")
    (version "0.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bigfloat" version))
       (sha256
        (base32 "1f0c1hdr39bbl5rds5r1waa1papjmjiyp0ixs64mkjiahzg6pfaq"))
       (snippet '(delete-file "mpfr.c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; This one fails with AssertionError: 0 != 8796082524191.  Not good,
      ;; but I don't know what to do about it.
      '(list "-k" "not test_hash")
      #:phases
      '(modify-phases %standard-phases
         (add-before 'build 'cythonize
           (lambda _ (invoke "cython" "mpfr.pyx"))))))
    (inputs (list mpfr))
    (native-inputs
     (list python-cython python-pytest python-setuptools python-wheel))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/mdickinson/bigfloat")
    (synopsis "Arbitrary precision floating-point arithmetic for Python")
    (description
     "This package provides a Python interface to the MPFR library for
multiprecision arithmetic.")
    (license license:lgpl3+)))

(define-public python-plac
  (package
    (name "python-plac")
    (version "1.3.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ialbert/plac")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1n0cbil1snbn0diw8zjm7qs77zpbgmf2k76mc2jknhk1hbnksyak"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tkinter
            (lambda _
              (substitute* "plac_tk.py"
                (("from Tkinter import Tk")
                 "from tkinter import Tk")
                (("from ScrolledText import ScrolledText")
                 "from tkinter.scrolledtext import ScrolledText")))))))
    (native-inputs
     (list (list python "tk") python-pytest python-setuptools))
    (home-page "https://github.com/ialbert/plac")
    (synopsis "Command line arguments parser")
    (description
     "This package can generate command line parameters from function
signatures.")
    (license license:bsd-3)))

(define-public python-q
  (package
    (name "python-q")
    (properties '((commit . "cbad74095e20017f33d3ab75aa8375aa046ee697")
                  (revision . "0")))
    (version (git-version "2.7"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/zestyping/q")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17bzi4xma4313waxanz5lly0cf0k6h33qrpy24sra2frh7gp0j0j"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Deduced from the makefile.
      #:test-backend #~'custom
      #:test-flags #~(list "test/test_basic.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'configure-tests
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "TMPDIR" "/tmp")))))))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/zestyping/q")
    (synopsis "Quick-and-dirty debugging output for tired programmers")
    (description
     "q is a Python module for \"print\" style of debugging Python code.  It
provides convenient short API for print out of values, tracebacks, and
falling into the Python interpreter.")
    (license license:asl2.0)))

(define-public python-qnorm
  (package
    (name "python-qnorm")
    (version "0.9.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Maarten-vd-Sande/qnorm")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bgqxmqq8d3il0gnbvlb5sik50f6z8myx7p652lpv4llj9hrl2w8"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-numba python-numpy python-pandas
           ;; XXX: pandas optional dependencies.
           python-tables python-pyarrow python-fastparquet))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/Maarten-vd-Sande/qnorm")
    (synopsis "Quantile normalization")
    (description
     "This tool implements quantile normalization.  It properly resolves rank
ties, which is important when ties happen frequently, such as when working
with discrete numbers (integers) in count tables.  This implementation should
be relatively fast, and can use multiple cores to sort the columns and
tie-resolvement is accelerated by numba.")
    (license license:expat)))

(define-public python-quantlaw
  (package
    (name "python-quantlaw")
    (version "0.0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Quantlaw/quantlaw")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ps0hcw2x2w9g0gipflka98zf1zsadgs161r6pgp7nh0sq8kpkrh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k"
              ;; test expects network access
              "not test_load_statue_names")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              (substitute* "setup.cfg"
                (("--cov.*")
                 "")))))))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-beautifulsoup4 python-networkx
                             python-pandas python-regex python-requests))
    (home-page "https://quantlaw.readthedocs.io/")
    (synopsis "Coding utilities for quantitative legal studies")
    (description
     "This package provides coding utilities for quantitative legal studies.")
    (license license:bsd-3)))

(define-public python-singledispatch
  (package
    (name "python-singledispatch")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "singledispatch" version))
       (sha256
        (base32
         "1z5qbbvvjvh3cwcjv57p7vzhayx0j1ysnvjq0d5py6k5d2ljghzk"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-six ; required for conversion, not at run-time
           python-wheel))
    (home-page
     "https://docs.python.org/3/library/functools.html#functools.singledispatch")
    (synopsis "Backport of singledispatch feature from Python 3.4")
    (description
     "This library brings functools.singledispatch from Python 3.4 to Python
2.6-3.3.")
    (license license:expat)))

(define-public python-pyzmq
  (package
    (name "python-pyzmq")
    (version "27.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyzmq" version))
       (sha256
        (base32 "0jznvl7v41241pbbvwzjxi028mrfy1n5ymfjzy2783n29ch4kia5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'configure
            (lambda _
              ;; Our zeromq package is built with '--enable-drafts'; also
              ;; enable draft support for pyzmq so the draft test passes.
              (setenv "ZMQ_DRAFT_API" "1")
              ;; Make sure to prevent building bundled libzmq.
              (setenv "PYZMQ_NO_BUNDLE" "1")))
          (add-before 'check 'delete-source
            ;; To prevent loading it and skip build extensions one more times.
            (lambda _
              (delete-file-recursively "zmq"))))))
    (native-inputs
     (list cmake-minimal
           ;; python-cffi ; for PyPy
           python-cython
           python-packaging
           python-pytest
           python-pytest-asyncio
           python-scikit-build-core
           python-tornado))
    (inputs
     (list libsodium
           zeromq))
    (home-page "https://github.com/zeromq/pyzmq")
    (synopsis "Python bindings for 0MQ")
    (description
     "PyZMQ is the official Python binding for the ZeroMQ messaging library.")
    (license license:bsd-4)))

(define-public python-immutabledict
  (package
    (name "python-immutabledict")
    (version "4.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "immutabledict" version))
       (sha256
        (base32 "0pvwfasa5l78pi32zk55x5ihpdzkdh4f3xwbfmd7ldyjma0zs0z0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://github.com/corenting/immutabledict")
    (synopsis "Immutable wrapper around dictionaries")
    (description
     "@dfn{immutabledict} is an immutable wrapper around dictionaries.
It implements the complete mapping interface and can be used as a drop-in
replacement for dictionaries where immutability is desired.")
    (license license:expat)))

(define-public python-emoji
  (package
    (name "python-emoji")
    (version "2.12.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "emoji" version))
       (sha256
        (base32 "1svk94pad8gcvjwd329zmfrw09wakwh6qjvnhf6sa6k92y44i82a"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-typing-extensions))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/carpedm20/emoji/")
    (synopsis "Emoji terminal output for Python")
    (description
     "This package provides Emoji terminal output for Python.  The
entire set of Emoji codes as defined by the Unicode Consortium is supported in
addition to a bunch of aliases.")
    (license license:bsd-3)))

;; TODO: Remove this package when upgrading python-gh-md-to-html to the
;; latest version. The latest gh-md-to-html does not build successfully from
;; the PyPI distribution. Let's resolve #72102 while keeping gh-md-to-html at
;; version 1.21.2 from failing.
;; https://issues.guix.gnu.org/72102
;; https://github.com/phseiff/github-flavored-markdown-to-html/issues/73
(define-public python-emoji-for-gh-md-to-html
  (package
    (inherit python-emoji)
    (version "1.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "emoji" version))
       (sha256
        (base32 "0923mpixwq6hdpkgvi4r46alfvf608iq975rb8lnqpq29j71mmjk"))))))

(define-public python-sarge
  (package
    (name "python-sarge")
    (version "0.1.7.post1") ; post release only to correct errors in metadata
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sarge" version))
       (sha256
        (base32 "0g9a53mfnp96877n1yq2jdk1mcv3xm0d93iisvgcn2prdsp45zv4"))))
    (build-system python-build-system)
    (home-page "https://docs.red-dove.com/sarge/")
    (synopsis "Subprocess wrapper with command pipeline functionality")
    (description "@code{sarge} is a wrapper for subprocess which provides
command pipeline functionality.")
    (license license:bsd-3)))

(define-public python-sentry-sdk
  (package
    (name "python-sentry-sdk")
    (version "1.5.5")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/getsentry/sentry-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dygfaapvznpj2j7cfjb0vlwhsn5qa5kf0kq488xbhjg06n8rrc4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; See <https://github.com/pytest-dev/pytest-forked/issues/88>.
      ;; AttributeError: module 'py' has no attribute 'process'
      '(list "--ignore=tests/integrations/django/test_basic.py"
             "--ignore=tests/utils/test_contextvars.py"
             ;; These try to use pip to install packages.
             "--ignore=tests/integrations/gcp/test_gcp.py"
             "-k"
             (string-append
              ;; This test requires extra dependencies.
              "not test_auto_enabling_integrations"
              ;; AttributeError: module 'py' has no attribute 'process'
              " and not test_threading"
              " and not test_transport"
              ;; Tests below require network.
              " and not test_crumb_capture"
              " and not test_crumb_capture_hint"
              " and not test_httplib_misuse"
              ;; Unclear assert error
              " and not test_auto_session_tracking_with_aggregates"
              ;; Fails with IndexError.
              " and not test_session_mode_defaults_to"
              "_request_mode_in_wsgi_handler"))
       #:phases
       '(modify-phases %standard-phases
          (add-before 'check 'fix-test
            ;; See https://github.com/getsentry/sentry-python/pull/2712
            (lambda _
              (substitute* "tests/__init__.py"
                (("import pytest")
                 "import warnings")
                (("pytest.warns\\(None\\)")
                 "warnings.catch_warnings(record=True)"))))
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (when tests?
                (apply invoke "python" "-m" "pytest" test-flags)))))))
    (native-inputs
     (list nss-certs-for-test
           python-django
           python-executing
           python-gevent
           python-jsonschema
           python-mock
           python-pyrsistent
           python-pytest
           python-pytest-cov
           python-pytest-django
           python-pytest-localserver
           python-setuptools
           python-werkzeug
           python-wheel))
    (propagated-inputs
     (list python-certifi python-urllib3))
    (home-page "https://github.com/getsentry/sentry-python")
    (synopsis "Python SDK for Sentry")
    (description "This package provides a Python SDK for the Sentry
application monitoring and error tracking software.")
    (license license:bsd-2)))

(define-public python-pep440
  (package
    (name "python-pep440")
    (version "0.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pep440" version))
       (sha256
        (base32 "0kfhysbyci4f2sxvv991yvn22kbhncn0jg1arbhzw4rbri375csq"))))
    (build-system pyproject-build-system)
    (arguments
     ;; This checks for "pep440" in the output, but we actually print
     ;; ".pep440-real" due to wrapping.
     (list #:test-flags '(list "-k" "not test_cli_help")))
    (propagated-inputs (list python-check-manifest python-mypy python-pytest
                             python-pytest-console-scripts python-pytest-cov))
    (native-inputs (list python-flit-core))
    (home-page "https://pypi.org/project/pep440/")
    (synopsis "Utils to check whether versions number match PEP 440")
    (description
     "This package provides a simple package with utils to check whether
versions number match PEP 440.")
    (license license:expat)))

(define-public python-pep517
  (package
    (inherit python-pep517-bootstrap)
    (name "python-pep517")
    (arguments
     '(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (delete-file "pytest.ini")
                      (delete-file "tests/test_meta.py")
                      (if tests?
                          (invoke "pytest") #t))))))
    (native-inputs (list python-mock python-pytest python-testpath))))

(define-public python-pyproject-metadata
  (package
    (name "python-pyproject-metadata")
    (version "0.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/FFY00/python-pyproject-metadata")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0yvs59ymz5gdix34a95wxlxvk9bnvjgrzsnmnc3ws7whpfv3yasm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Two tests fail because the error message slightly changed, so the
      ;; tests' regular expressions no longer match.
      '(list "--ignore=tests/test_standard_metadata.py")))
    (propagated-inputs (list python-packaging))
    (native-inputs (list python-pypa-build python-pytest python-setuptools
                         python-tomli python-wheel))
    (home-page "https://github.com/FFY00/python-pyproject-metadata")
    (synopsis "Dataclass for PEP 621 metadata")
    (description "This project does not implement the parsing of
@file{pyproject.toml} containing PEP 621 metadata.  Instead, given a Python
data structure representing PEP 621 metadata (already parsed), it will
validate this input and generate a PEP 643-compliant metadata
file (e.g. @file{PKG-INFO}).")
    (license license:expat)))

;; pep621 was renamed to pyproject-metadata.
(define-deprecated-package python-pep621
  python-pyproject-metadata)

(define-public python-meson-python
  (package
    (name "python-meson-python")
    (version "0.15.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "meson_python" version))
       (sha256
        (base32 "0vyjhjabvm41hqijifk33idbdl62i76kfyf884f9rs29rpp77nzx"))))
    (build-system meson-build-system)
    (propagated-inputs (list python-pyproject-metadata python-tomli))
    (home-page "https://github.com/mesonbuild/meson-python")
    (synopsis "Meson Python build backend (PEP 517)")
    (description "This package provides a PEP 517 build backend that makes
use of the Meson build system.")
    (license license:expat)))

(define-public python-mccabe
  (package
    (name "python-mccabe")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mccabe" version))
       (sha256
        (base32 "09b34c7jj2a0yya7fp3x7lncna4zj7pr4caj9vgvnq1vqd0053il"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Test fixtures are not released yet, see
      ;; <https://github.com/PyCQA/mccabe/issues/93>
      #:tests? #f))
    (native-inputs
     (list python-toml
           python-setuptools
           python-wheel))
    (home-page "https://github.com/PyCQA/mccabe")
    (synopsis "McCabe checker, plugin for flake8")
    (description
     "This package provides a Flake8 plug-in to compute the McCabe cyclomatic
complexity of Python source code.")
    (license license:expat)))

(define-public python-autoflake8
  (package
    (name "python-autoflake8")
    (version "0.4.0")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/fsouza/autoflake8")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0jx7bkslbhr24yvq60pl39faz2r6g93f1zm1gygswl0rzr5zmgnh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-aiofiles
           python-poetry-core
           python-pytest
           python-pytest-xdist))
    (propagated-inputs (list python-pyflakes))
    (home-page "https://github.com/fsouza/autoflake8")
    (synopsis "Automatically fix issues reported by flake8")
    (description "Tool to automatically fix some issues reported by
@command{flake8}.")
    (license license:expat)))

(define-public python-flake8
  (package
    (name "python-flake8")
    (version "7.1.1")
    (source
     (origin
       (method git-fetch)   ; no tests data in PyPi package
       (uri (git-reference
             (url "https://github.com/pycqa/flake8")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qbj2m1ljyvpnncnkbm1cscy726c1if4n2c9ysfpmd2zm88rj87a"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-mccabe
           python-pycodestyle
           python-pyflakes))
    (home-page "https://flake8.pycqa.org/en/latest/")
    (synopsis "The modular source code checker: pep8, pyflakes and co")
    (description
     "Flake8 is a wrapper around PyFlakes, pep8 and python-mccabe.")
    (license license:expat)))

(define-public python-flake8-blind-except
  (package
    (name "python-flake8-blind-except")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/elijahandrews/flake8-blind-except")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "09zrfrm0896miysrpb7fhxzqjn6pm8y0b638nncswm2wvw9by72q"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ;no tests
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-pycodestyle))
    (home-page "https://github.com/elijahandrews/flake8-blind-except")
    (synopsis "Check for blind @code{except:} statements")
    (description
     "This package provides a flake8 extension that checks for blind
@code{except:} statements.")
    (license license:expat)))

(define-public python-flake8-bugbear
  (package
    (name "python-flake8-bugbear")
    (version "24.10.31")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_bugbear" version))
       (sha256
        (base32 "1nrrwhfmk49riflmng26qqjzvfang5lij14ripzqwzxjf8f56ns3"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hypothesmith
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-attrs
           python-flake8))
    (home-page "https://github.com/PyCQA/flake8-bugbear")
    (synopsis "Flake8 plugin for finding likely bugs and design problems in your program")
    (description
     "This package contains a plugin for Flake8 finding likely bugs and design
problems in your program.  It contains warnings that don't belong in pyflakes
and pycodestyle.")
    (license license:expat)))

(define-public python-flake8-continuation
  (package
    (name "python-flake8-continuation")
    (version "1.0.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/planetlabs/flake8-continuation")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04fsd361x03mgyydsdm9vr28ikr2mdip13c805i2wzxc45qsc9x7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'remove-python-six-dependency
            (lambda _
              (substitute* "flake8_continuation.py"
                (("import six|six\\.moves\\.")
                 ""))
              (substitute* "setup.py"
                ((", \"six\"")
                 "")))))))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-flake8 python-pycodestyle))
    (home-page "https://github.com/planetlabs/flake8-continuation")
    (synopsis "Flake8 Line Continuation Plugin")
    (description
     "A Flake8 plugin that checks for the line continuation style to be in the
preferred method according to PEP-8, specifically:
@quotation
The preferred way of wrapping long lines is by using Python's implied line
continuation inside parentheses, brackets and braces.  Long lines can be
broken over multiple lines by wrapping expressions in parentheses.  These
should be used in preference to using a backslash for line continuation.
@end quotation")
    (license license:asl2.0)))

(define-public python-flake8-debugger
  (package
    (name "python-flake8-debugger")
    (version "4.1.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jbkahn/flake8-debugger")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1nmqs238a02ypld32lwbagbk1jppm3pddrjdrrngc1xpbzb9nyl0"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-pytest python-setuptools))
    (propagated-inputs (list python-flake8 python-pycodestyle))
    (home-page "https://github.com/jbkahn/flake8-debugger")
    (synopsis "@code{ipdb} and @code{pdb} statement checker plugin for flake8")
    (description
     "This package provides a Flake8 plugin that checks for @code{ipdb} and
@code{pdb} imports and set traces, as well as @code{from
IPython.terminal.embed}, @code{import InteractiveShellEmbed} and
@code{InteractiveShellEmbed()()}.")
    (license license:expat)))

(define-public python-flake8-implicit-str-concat
  (package
    (name "python-flake8-implicit-str-concat")
    (version "0.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_implicit_str_concat" version))
       (sha256
        (base32 "1s59w4x053j4794n6h9c7hafa8jjjymx6aar5q23pjw4vrdis7hh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PiPY or git checkout
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-attrs
           python-more-itertools))
    (home-page "https://github.com/keisheiled/flake8-implicit-str-concat")
    (synopsis "Flake8 plugin to encourage correct string literal concatenation")
    (description
     "This is a plugin for the Python code checking tool Flake8 to encourage
correct string literal concatenation.

It looks for style problems like implicitly concatenated string literals on
the same line (which can be introduced by the code formatting tool Black), or
unnecessary plus operators for explicit string literal concatenation.")
    (license license:expat)))

(define-public python-flake8-print
  (package
    (name "python-flake8-print")
    (version "5.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-print" version))
       (sha256
        (base32 "1ydx92xck090ajp8vk2378fm0f4wj3mikhinjs3w1hcw70m5m4bn"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PiPY or git checkout
    (native-inputs
     (list python-poetry-core))
    (propagated-inputs
     (list python-flake8
           python-pycodestyle))
    (home-page "https://github.com/jbkahn/flake8-print")
    (synopsis "Print statement checker plugin for Flake8")
    (description
     "This plugin for Flake8 checks for @code{print} statements in Python
files.")
    (license license:expat)))

(define-public python-flake8-pyi
  (package
    (name "python-flake8-pyi")
    (version "24.9.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8_pyi" version))
       (sha256
        (base32 "1n8cqbqq9cfyn952kwqqs4s7lcyycgr829ymxnplg0cm49877yv4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Prevent full threads utilization.
              (substitute* "pyproject.toml"
                (("-nauto") "")))))))
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs
     (list python-attrs
           python-flake8
           python-pyflakes))
    (home-page "https://github.com/ambv/flake8-pyi")
    (synopsis "Flake8 plugin that provides specializations for type hinting stub files")
    (description
     "This package contains a plugin that provides specializations for type
hinting stub files, especially interesting for linting typeshed.  It adds the
@file{.pyi} extension to the default value of the @code{--filename}
command-line argument to Flake8.  This means stubs are linted by default with
this plugin enabled, without needing to explicitly list every file.  It
modifies PyFlakes runs for @file{.pyi} files to defer checking type annotation
expressions after the entire file has been read.  This enables support for
first-class forward references that stub files use.")
    (license license:expat)))

(define-public python-flake8-quotes
  (package
    (name "python-flake8-quotes")
    (version "3.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "flake8-quotes" version))
       (sha256
        (base32 "0v1762x0819xqha7w4l4hh66bpi82imgiib8pvmd78hhnwplkn5a"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-flake8))
    (home-page "https://github.com/zheller/flake8-quotes/")
    (synopsis "Flake8 lint for quotes")
    (description "This package provides a Flake8 lint for quotes.")
    (license license:expat)))

(define-public python-flake8-todo
  (package
    (name "python-flake8-todo")
    (version "0.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/schlamar/flake8-todo")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bx4bs9l6cvqk5v21my4dn0zmkrr0sajsw6f3x1dj4fpg3dp5d8s"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; No tests.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-pycodestyle))
    (home-page "https://github.com/schlamar/flake8-todo")
    (synopsis "TODO notes checker, plugin for flake8")
    (description
     "This package provides the @code{flake8-todo} Python module, a
TODO notes checker plugin for flake8.")
    (license license:expat)))

(define-public python-flake8-isort
  (package
    (name "python-flake8-isort")
    (version "6.1.1")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "flake8_isort" version))
        (sha256
          (base32 "1cvh0d18scgq36gqa2vqbifjarln1r3axgq93lzc303ay0y2zy61"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PiPY or git checkout
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-flake8
           python-isort))
    (home-page "https://github.com/gforcada/flake8-isort")
    (synopsis "Flake8 plugin integrating isort")
    (description
     "This package provides a flake8 plugin that integrates isort,
extending flake8 so that it can warn about badly sorted Python import
directives.")
    (license license:gpl2+)))

(define-public python-autoflake
  (package
    (name "python-autoflake")
    (version "2.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "autoflake" version))
       (sha256
        (base32 "17lhrmz6h7pz2nald90p8gn3hhzbqwmd78819yf4b1habgf7b2y9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda _
              (invoke "python" "test_autoflake.py"))))))
    (native-inputs
     (list python-hatchling))
    (propagated-inputs
     (list python-pyflakes))
    (home-page "https://github.com/myint/autoflake")
    (synopsis "Removes unused imports and unused variables")
    (description
     "@code{autoflake} removes unused imports and unused variables from Python
code as reported by @code{pyflakes}.

By default, it only removes unused imports for modules that are part of the
standard library.  Removal of unused variables is also disabled by default.
It also removes useless @code{pass} statements.")
    (license license:expat)))

(define-public python-mistune
  (package
    (name "python-mistune")
    (version "3.1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mistune" version))
       (sha256
        (base32 "1802kx9hdbqmbd9acxx4dx6wn77q7mfz5y32psvfqarbg0hmq0x7"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/lepture/mistune")
    (synopsis "Markdown parser in pure Python")
    (description "This package provides a fast markdown parser in pure
Python.")
    (license license:bsd-3)))

(define-public python-markdown
  (package
    (name "python-markdown")
    (version "3.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "markdown" version))
       (sha256
        (base32
         "03lcnvr39pmfiids6jdr1iwwr0hg62m0zf7g5arvdcm4597js1ip"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pyyaml
           python-setuptools))
    (home-page "https://python-markdown.github.io/")
    (synopsis "Python implementation of Markdown")
    (description
     "This package provides a Python implementation of John Gruber's
Markdown.  The library features international input, various Markdown
extensions, and several HTML output formats.  A command line wrapper
markdown_py is also provided to convert Markdown files to HTML.")
    (license license:bsd-3)))

(define-public python-markdown2
  (package
    (name "python-markdown2")
    (version "2.5.3")
    (source
     (origin
       (method git-fetch) ; no tests data in PyPi package
       (uri (git-reference
              (url "https://github.com/trentm/python-markdown2")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "136lwfhrbgdy3ci7qrkvcm5qx5c4xv4zwbnn57yfqg37pymflima"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test.py" "--" "-knownfailure")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              (chdir "test"))))))
    (native-inputs
     (list ;; python-pygments      ;optinal, tests fail when added
           ;; python-wavedrom      ;optinal, not packaged
           ;; python-latex2mathml  ;optinal, not packaged
           python-setuptools))
    (home-page "https://github.com/trentm/python-markdown2")
    (synopsis "Fast and complete Python implementation of Markdown")
    (description
     "This package provides a fast and complete Python implementation of
Markdown.  It was written to closely match the behaviour of the original
Perl-implemented Markdown.pl.  It also comes with a number of
extensions (called @code{extras}) for things like syntax coloring, tables,
header-ids.")
    (license license:expat)))

(define-public python-mdx-include
  (package
    (name "python-mdx-include")
    (version "1.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/neurobin/mdx_include")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01fk4y7hkl8a06qfd4a258l8rgcx7z7j4dzb80gk9md48l6p516a"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:phases
      (let* ((django-hello-url "\
https://gist.github.com/drgarcia1986/3cce1d134c3c3eeb01bd/raw/\
73951574d6b62a18b4c342235006ff89d299f879/django_hello.py")
             (django-hello
              (origin
                (method url-fetch)
                (uri django-hello-url)
                (sha256 (base32 "\
13bqmfqwypnv3apxs9akpk3fqsk0yzys5slxfllj285npnka550r")))))
        #~(modify-phases %standard-phases
            (add-before 'check 'disable-test-requiring-network
              (lambda _
                (substitute* "mdx_include/test/test.py"
                  (("(\\s+def )test_(config|non_existent)\\(" _ pre post)
                   (string-append pre "__off__test_" post "("))
                  (((string-join (string-split #$django-hello-url #\.) "\\."))
                   #+django-hello))))))))
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-cyclic python-markdown python-rcslice))
    (home-page "https://github.com/neurobin/mdx_include")
    (synopsis "Python Markdown extension to include local or remote files")
    (description "Include extension for Python Markdown.  It lets you include
local or remote (downloadable) files into your markdown at arbitrary
positions.

This project is motivated by markdown-include and provides the same
functionalities with some extras.")
    (license license:bsd-3)))

(define-public python-ptyprocess
  (package
    (name "python-ptyprocess")
    (version "0.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ptyprocess" version))
       (sha256
        (base32
         "081j893x6c9qrfszp8swfqlpvk8agh1jc32y9140pvnf90xhlpaw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pytest))
    (home-page "https://github.com/pexpect/ptyprocess")
    (synopsis "Run a subprocess in a pseudo terminal")
    (description
     "This package provides a Python library used to launch a subprocess in a
pseudo terminal (pty), and interact with both the process and its pty.")
    (license license:isc)))

(define-public python-configshell-fb
  (package
    (name "python-configshell-fb")
    (version "1.1.30")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "configshell-fb" version))
       ;; XXX: Snippet below is required because on v1.1.30 the source code
       ;; has configshell_fb as softlink to configshell and guix
       ;; pyproject-build-system doesn't work with symlinks very well.
       ;;
       ;; This package is only used in spdk for now and it's crucial to keep
       ;; it locked on version and keep the snipped for spdk to build
       ;; successfully.
       (snippet #~(begin
                    (use-modules (guix build utils))
                    (delete-file "setup.py")
                    (delete-file-recursively "configshell_fb")
                    (rename-file "configshell" "configshell_fb")))
       (sha256
        (base32 "1zkhf62qsfcbxwzlc62r6qx37wwyscppc469rlm45zy9lzmbgxj1"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;; this package has no tests
    (native-inputs
     (list python-setuptools
           python-six
           python-wheel))
    (propagated-inputs
     (list python-pyparsing))
    (home-page "https://github.com/open-iscsi/configshell-fb")
    (synopsis "Framework to implement simple but nice CLIs")
    (description
     "This package provides a framework to implement simple but nice CLIs.")
    (license license:asl2.0)))

(define-public python-crccheck
  (package
    (name "python-crccheck")
    (version "1.3.0")
    (source
     (origin
       (method git-fetch) ; no tests in PyPI
       (uri (git-reference
             (url "https://github.com/MartinScharrer/crccheck")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1sagpmsh95si77nhqmxx6mbal2jbxpl4a3mqjfnz19mf2pfyvs4y"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/MartinScharrer/crccheck")
    (synopsis "Calculation library for CRCs and checksums")
    (description "@code{crccheck} is a calculation library for CRCs and
checksums.  It implement more than a hundred checksum routines.")
    (license license:gpl3+)))

(define-public python-crashtest
  (package
    (name "python-crashtest")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sdispater/crashtest")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "180xrr1iw1614z7yrrnsigy0211q9985f9pbzjsj6rvrs6w7fm2d"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core python-pytest))
    (home-page "https://github.com/sdispater/crashtest")
    (synopsis "Manage Python errors with ease")
    (description
     "Python library that makes exceptions handling and inspection easier.")
    (license license:expat)))

(define-public python-pysendfile
  (package
    (name "python-pysendfile")
    (version "2.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/giampaolo/pysendfile")
              (commit (string-append "release-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1d2pcqad57l5ilc2icabybzzjgsg46djklhvyf17fgbkb0x3yc7c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "HOME" "/tmp")
                (invoke "make" "test")))))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/giampaolo/pysendfile")
    (synopsis "Python interface to sendfile(2)")
    (description "The @code{pysendfile} Python library provides an interface to
the @code{sendfile(2)} system call.")
    (license license:expat)))

(define-public python-pyftpdlib
  (package
    (name "python-pyftpdlib")
    (version "1.5.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyftpdlib" version))
       (sha256
        (base32 "0vk5gcx4svjrpm014ykwxmijqihgb4ha17kb3yphk0nv6x0wx8vy"))))
    (build-system pyproject-build-system)
    ;; Using Pytest instead of the Makefile causes the command line tests to
    ;; fail on unknown Pytest arguments.
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not TestCommandLineParser"
              #$@(if (target-aarch64?)
                     ;; TimeoutError: timed out
                     '((string-append "--deselect=pyftpdlib/test/test_functional.py"
                                      "::TestTimeouts::test_idle_data_timeout2"))
                     '()))))
    (native-inputs
     (list python-psutil
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-pyopenssl
           python-pysendfile))
    (home-page "https://github.com/giampaolo/pyftpdlib/")
    (synopsis "Asynchronous and scalable Python FTP server library")
    (description "The Python FTP server library provides a high-level
interface to write efficient, scalable and asynchronous FTP servers with
Python.  It is the most complete @url{http://www.faqs.org/rfcs/rfc959.html,
RFC-959} FTP server implementation available for Python, and has the following
traits:
@itemize
@item
It is lightweight, fast and scalable.
@item
It uses the @code{sendfile(2)} system call for uploads.
@item
It uses @code{epoll}, @code{kqueue} and @code{select} to handle concurrency
asynchronously.
@item
It supports FTPS (@url{http://tools.ietf.org/html/rfc4217, RFC-4217}),
IPv6 (RFC-2428), Unicode file names (@url{http://tools.ietf.org/html/rfc2640,
RFC-2640}) and MLSD/MLST commands (RFC-3659).
@item
It has a flexible system of @samp{authorizers} able to manage both
@samp{virtual} and @samp{real} users.
@end itemize")
    (license license:expat)))

(define-public python-fs
  (package
    (name "python-fs")
    (version "2.4.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/PyFilesystem/pyfilesystem2/")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wrkhsv57kv4jcadn7w330mgbjjsimgzfvicni8cka6y1a8chbjs"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 1995 passed, 21 skipped, 411 deselected, 14 warnings
      #:test-flags #~(list "-m" "not slow")
      #:tests? (and (not (%current-target-system))
                    (->bool (this-package-native-input "python-pytest")))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (append
      (list python-setuptools)
      ;; 'python-pyftpdlib' is needed for tests but it indirectly depends Rust,
      ;; which is currently unavailable on aarch64-linux.  Remove all the test
      ;; dependencies in that case.
      (if (and (not (%current-target-system))
               (supported-package? python-pyftpdlib))
          (list python-mock
                python-parameterized
                python-pyftpdlib
                python-pytest)
          '())))
    (propagated-inputs
     (list python-appdirs
           python-pytz
           python-six))         ;still hard itegrated
    (home-page "https://github.com/PyFilesystem/pyfilesystem2/")
    (synopsis "File system abstraction layer for Python")
    (description
     "PyFilesystem's @code{FS} object is a file system abstraction sharing
similarities with Python's own @code{file} object for single files.  It allows
opening all the files under a given directory recursively, as a single
@code{FS} object.  This enables, for example, counting the combined number of
lines in the contained files easily.")
    (license license:expat)))

;;; Tests are left out in the main package to avoid cycles.
;; XXX: When updating, solve comment in python-cu2qu.
(define-public python-fonttools-minimal
  (hidden-package
   (package
     (name "python-fonttools-minimal")
     (version "4.59.2")
     (source (origin
               (method url-fetch)
               (uri (pypi-uri "fonttools" version ".tar.gz"))
               (sha256
                (base32
                 "08pgq9nrj3r81gzb6gbf5mcak0xyqrj26cw0rc5za4v1n14hfb77"))))
     (build-system python-build-system)
     (arguments '(#:tests? #f))
     (home-page "https://github.com/fonttools/fonttools")
     (synopsis "Tools to manipulate font files")
     (description
      "FontTools/TTX is a library to manipulate font files from Python.  It
supports reading and writing of TrueType/OpenType fonts, reading and writing
of AFM files, reading (and partially writing) of PS Type 1 fonts.  The package
also contains a tool called “TTX” which converts TrueType/OpenType fonts to and
from an XML-based format.")
     (license license:expat))))

(define-public python-fonttools
  (let ((base python-fonttools-minimal))
    (package/inherit base
      (name "python-fonttools")
      (arguments
       (substitute-keyword-arguments (package-arguments base)
         ((#:tests? _ #f)
          (not (%current-target-system)))
         ((#:phases phases '%standard-phases)
          `(modify-phases ,phases
             (replace 'check
               (lambda* (#:key tests? #:allow-other-keys)
                 (when tests?
                   (invoke "pytest" "-vv"
                           "-k"
                           ;; XXX: These tests need data files that are not
                           ;; shipped with the PyPI release.
                           (format #f "not ~a"
                                   (string-join
                                    '("test_cli_vtp"
                                      "test_group_order"
                                      "test_read_fontdimens_mathsy"
                                      "test_read_fontdimens_mathex"
                                      "test_read_fontdimens_vanilla"
                                      "test_read_boundary_char"
                                      "test_reading_supplement_encoding"
                                      "fontTools.tfmLib"
                                      ;; The MtiTest tests fail for unknown
                                      ;; reasons (see:
                                      ;; https://github.com/fonttools/
                                      ;; fonttools/issues/3078)
                                      "MtiTest")
                                    " and not "))))))))))
      (native-inputs
       (modify-inputs (package-native-inputs base)
         (append python-pytest)))
      (propagated-inputs
       (list python-brotli
             python-fs
             python-lxml
             python-lz4
             python-scipy
             python-unicodedata2
             python-zopfli))
      (properties (alist-delete 'hidden? (package-properties base))))))

(define-public python-ly
  (package
    (name "python-ly")
    (version "0.9.9")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/frescobaldi/python-ly")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1q9jdvc4mrv3xkp7jm4g4kisq1k1d05b5d3wfvhpd85a9yqjrhq8"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      (let ((namespace-url "http://www.w3.org/2001/03/xml.xsd")
            (xlink-url "http://www.w3.org/XML/2008/06/xlink.xsd"))
        #~(modify-phases %standard-phases
            (add-after 'unpack 'inject-data
              (lambda _
                (substitute* "tests/musicxml.xsd"
                  (((string-join (string-split #$namespace-url #\.) "\\."))
                   #$(origin
                       (method url-fetch)
                       (uri namespace-url)
                       (sha256 (base32 "\
1j6h0sp0pcqi5dv9m6sxwr8brrb59fyx091ld1x6wlh28js4vn8f"))))
                  (((string-join (string-split #$xlink-url #\.) "\\."))
                   #$(origin
                       (method url-fetch)
                       (uri xlink-url)
                       (sha256 (base32 "\
0jpjha5iiq4rf4hx3qfnmyya9cf17ysxz0rbhsffn5nwgxnghgf8")))))))))))
    (native-inputs (list python-hatchling python-lxml python-pytest))
    (synopsis "Tool and library for manipulating LilyPond files")
    (description
     "This package provides a Python library to parse, manipulate or create
documents in LilyPond format.  A command line program ly is also provided that
can be used to do various manipulations with LilyPond files.")
    (home-page "https://pypi.org/project/python-ly/")
    (license license:gpl2+)))

(define-public python-appdirs
  (package
    (name "python-appdirs")
    (version "1.4.4")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "appdirs" version))
        (sha256
         (base32 "0hfzmwknxqhg20aj83fx80vna74xfimg8sk18wb85fmin9kh2pbx"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/ActiveState/appdirs")
    (synopsis "Determine platform-specific dirs, e.g. a \"user data dir\"")
    (description
      "This module provides a portable way of finding out where user data
should be stored on various operating systems.")
    (license license:expat)))

(define-public python-google-pasta
  (package
    (name "python-google-pasta")
    (version "0.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "google-pasta" version))
       (sha256
        (base32 "0vm1r1jlaiagj0l9yf7j6zn9w3733dr2169911c0svgrr3gwiwn9"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-six))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/google/pasta")
    (synopsis "AST-based Python refactoring library")
    (description "This package provides \"pasta\", an AST-based Python
refactoring library.")
    (license license:asl2.0)))

(define-public python-gorilla
  (package
    (name "python-gorilla")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/christophercrouzet/gorilla")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hm5ynswhz6i763s6cjlh8lv5ai0f3x17mjvlihqs8idlk4vbrn0"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/christophercrouzet/gorilla")
    (synopsis "Convenient monkey patching with Python")
    (description
     "Gorilla is a Python library that provides a convenient approach to
monkey patching.  Monkey patching is the process of modifying module and
class attributes at runtime with the purpose of replacing or extending
third-party code.")
    (license license:expat)))

(define-public python-llfuse
  (package
    (name "python-llfuse")
    (version "1.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/python-llfuse/python-llfuse")
             (commit (string-append "release-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16wsrg1py4gvcxfgsfkll73lfq62psc0hcqvs73az7s4b1pvyy62"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not test_listdir")  ; requires /usr/bin access.
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'build-cython
            (lambda _
              (invoke "python" "setup.py" "build_cython"))))))
    (inputs (list fuse-2 attr))
    (native-inputs
     (list pkg-config python-cython python-pytest python-setuptools))
    (synopsis "Python bindings for FUSE")
    (description
     "Python-LLFUSE is a set of Python bindings for the low level FUSE API.")
    (home-page "https://github.com/python-llfuse/python-llfuse")
    (license license:lgpl2.0+)))

(define-public python-msgpack
  (package
    (name "python-msgpack")
    (version "1.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "msgpack" version))
       (sha256
        (base32 "1k84s6w17i1ylrcm39wi1djjv832vn08w3299xcv5nib9birrdvp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (synopsis "MessagePack (de)serializer")
    (description "MessagePack is a fast, compact binary serialization format,
suitable for similar data to JSON.  This package provides CPython bindings for
reading and writing MessagePack data.")
    (home-page "https://pypi.org/project/msgpack/")
    (license license:asl2.0)))

(define-public python-msgpack-for-borg
  (hidden-package
   (package
     (inherit python-msgpack)
     (version "1.0.4")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "msgpack" version))
        (sha256
         (base32 "0pqzy1zclyhd42gfibhkcqymbspy5a6v421g87mh40h3iz0nkn7m")))))))

(define-public python-openstep-plist
  (package
    (name "python-openstep-plist")
    (version "0.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fonttools/openstep-plist")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1rxjgzh0p069ncsr2986rn32vhdqyq35irbqg2559jh18456mkca"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'pretend-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                      #$(package-version this-package)))))))
    (native-inputs (list python-cython-0 python-pytest python-setuptools-scm
                         python-setuptools))
    (home-page "https://github.com/fonttools/openstep-plist")
    (synopsis "OpenStep plist parser and writer")
    (description
     "This package provides a parser for the \"old style\" OpenStep property
list format (also known as ASCII plist), written in Cython.")
    (license license:expat)))

(define-public python-resolvelib
  (package
    (name "python-resolvelib")
    (version "1.1.0")
    (source
     (origin
       ;; Tests are missing from the PyPI release.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sarugaku/resolvelib")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pw99897mm2y7pa2g35z0f7vcmgh42xglz5szbrvigczvwa605sh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-packaging
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/sarugaku/resolvelib")
    (synopsis "Abstract dependencies resolver")
    (description
     "The ResolveLib library provides a @code{Resolver} class that includes
dependency resolution logic.")
    (license license:isc)))

;; XXX: Deprecated package: this project was archived by the owner on Mar 26,
;; 2022. It is now read-only.
(define-public python-commonmark
  (package
    (name "python-commonmark")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "commonmark" version))
       (sha256
        (base32 "0q7d39lm8kcingpmykk5r959hrwwj6v2icyw3mihczxyb749sbs5"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/readthedocs/commonmark.py")
    (synopsis "Python parser for the CommonMark Markdown spec")
    (description
     "This module is a pure Python port of jgm's @code{commonmark.js}, a
Markdown parser and renderer for the CommonMark specification, using only
native modules.")
    (license license:bsd-3)))

(define-public python-immutables
  (package
    (name "python-immutables")
    (version "0.21")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "immutables" version))
       (sha256
        (base32 "0jpw9nr2mbzqykigjhqa3a095bx7krwsnmjcxcpj944p8kqglpxm"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-mypy python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/MagicStack/immutables")
    (synopsis "High-performance immutable mapping type for Python")
    (description
     "An immutable mapping type for Python.  The underlying datastructure is a
Hash Array Mapped Trie (HAMT) used in Clojure, Scala, Haskell, and other
functional languages.")
    (license license:asl2.0)))

(define-public python-prettytable
  (package
    (name "python-prettytable")
    (version "3.12.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "prettytable" version))
       (sha256
        (base32 "0168xqdr0i9r4p3a3hjd4n7f133lp4xkxhvfx63aqisplcdkwjzh"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-hatch-vcs
           python-pytest
           python-pytest-cov
           python-pytest-lazy-fixtures
           python-setuptools-scm))
    (propagated-inputs
     (list python-wcwidth))
    (home-page "https://github.com/jazzband/prettytable")
    (synopsis "Display tabular data in an ASCII table format")
    (description
      "A library designed to represent tabular data in visually appealing ASCII
tables.  PrettyTable allows for selection of which columns are to be printed,
independent alignment of columns (left or right justified or centred) and
printing of sub-tables by specifying a row range.")
    (license license:bsd-3)))

(define-public python-rtf-tokenize
  (package
    (name "python-rtf-tokenize")
    (version "1.0.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "rtf_tokenize" version))
              (sha256
               (base32
                "1ljs0dcg2p1iad4zrxgn1pbrrcjcrswhjxrbprhdxd822n0al84h"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/benoit-pierre/rtf_tokenize")
    (synopsis "Simple RTF tokenizer")
    (description "This package is a simple RTF tokenizer.")
    (license license:gpl2+)))

(define-public python-curio
  (package
    (name "python-curio")
    (version "1.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "curio" version))
       (sha256
        (base32 "0isj3jl5mx6m25nr1f7r91hfaydhkvmks9p85dyvl5h2n9nmhajn"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list ;; AttributeError: 'NoneType' object has no attribute
              ;; 'terminate'
              "--deselect=tests/test_workers.py::test_exception"
              ;; Tries to open an outgoing connection.
              "--deselect=tests/test_network.py::test_ssl_outgoing"
              ;; This test fails since Python 3.9.9, see
              ;; <https://github.com/dabeaz/curio/issues/347>.
              ;; AttributeError: 'NoneType' object has no attribute
              ;; 'terminate'
              "--deselect=tests/test_workers.py::test_worker_timeout"
              ;; AttributeError: 'NoneType' object has no attribute
              ;; 'terminate'
              "--deselect=tests/test_workers.py::test_bad_cpu"
              "--deselect=tests/test_workers.py::test_cpu"
              "--deselect=tests/test_workers.py::test_worker_cancel")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/dabeaz/curio")
    (synopsis "Coroutine-based library for concurrent Python")
    (description
     "Curio is a coroutine-based library for concurrent Python systems
programming.  It provides standard programming abstractions such as as
tasks, sockets, files, locks, and queues.")
    (license license:bsd-3)))

(define-public python-sniffio
  (package
    (name "python-sniffio")
    (version "1.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sniffio" version))
       (sha256
        (base32 "1p496yran6zwg47m7w26r8y89nrsbkrrbf4119slj3qaczf4wcpl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-curio python-pytest python-setuptools))
    (home-page "https://github.com/python-trio/sniffio")
    (synopsis "Detect which async library a program is running under")
    (description
     "This package detects which async library a program is running under.  It
supports multiple async I/O packages, like Trio, and asyncio.")
    ;; Either license applies.
    (license (list license:expat license:asl2.0))))

(define-public python-snuggs
  (package
    (name "python-snuggs")
    (version "1.4.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "snuggs" version))
              (sha256
               (base32
                "0yv1wayrw9g6k0c2f721kha7wsv0s1fdlxpf5x7f34iqzq9z272h"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-numpy python-pyparsing))
    (native-inputs (list python-hypothesis python-pytest python-setuptools
                         python-wheel))
    (home-page "https://github.com/mapbox/snuggs")
    (synopsis "Snuggs are S-expressions for Numpy")
    (description "Snuggs are S-expressions for Numpy.")
    (license license:expat)))

(define-public python-geojson
  (package
    (name "python-geojson")
    (version "3.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "geojson" version))
       (sha256
        (base32 "00s9h22vs4ppncwg3a0gh90czb2dd6d99qznypw72vwc3sxblq5q"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/jazzband/geojson")
    (synopsis "Python bindings and utilities for GeoJSON")
    (description
     "This package provides Python bindings and utilities for
@uref{http://geojson.org/, GeoJSON}, a format for encoding geographic data
structures.")
    (license license:bsd-3)))

;; pyowm only accepts a version less than version 3.
(define-public python-geojson-for-pyowm
  (package
    (inherit python-geojson)
    (version "2.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "geojson" version))
       (sha256
        (base32 "12k5bzqskvq3gqzkryarhdjl0df47y5k9cf8r3clasi2wjnbfjvf"))))
    (arguments
     ;; https://github.com/jazzband/geojson/issues/175
     (list #:tests? #f))))

(define-public python-gpxpy
  (package
    (name "python-gpxpy")
    (version "1.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "gpxpy" version))
       (sha256
        (base32 "1bh1dkrbmcqb46r7j4fazzq7j6zfr2f04frm6h4bhhpcjx5lhb57"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'unittest))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/tkrajina/gpxpy")
    (synopsis "Python GPX parser")
    (description "GPX file parser and GPS track manipulation library.")
    (license license:asl2.0)))

(define-public python-get-version
  (package
    (name "python-get-version")
    (version "3.5.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "get_version" version))
       (sha256
        (base32
         "01afv4fkgrm8v9hiww3qymmx201b6z3f8lc4g6nzq7djappn581x"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: No tests in PyPI and building from GitHub fails because of the
     ;; lack of git metadata in the checkout.
     (list #:tests? #f))
    (native-inputs (list python-flit-core))
    (propagated-inputs (list python-dunamai))
    (home-page "https://github.com/flying-sheep/get_version")
    (synopsis "Version helper in the spirit of versioneer")
    (description
     "This package provides a version helper that lets you automatically use
the latest @code{vX.X.X} Git tag as the version in your Python package.  It
also supports getting the version from Python source distributions or, once
your package is installed, via @code{pkg_resources} (part of
@code{setuptools}).")
    (license license:gpl3+)))

(define-public python-filetype
  (package
    (name "python-filetype")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "filetype" version))
       (sha256
        (base32 "1nxa91szfbhhbhvdwj06jz8zghzwgb9lf0v6aj61vx2b8zb6rdb6"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest
                         python-pytest-benchmark
                         python-setuptools
                         python-wheel))
    (home-page "https://github.com/h2non/filetype.py")
    (synopsis "Infer file type and MIME type of any file/buffer")
    (description "@code{filetype} is a small and dependency free Python
package to infer file type and MIME type checking the magic numbers
signature of a file or buffer.")
    (license license:expat)))

(define-public python-cachelib
  (package
    (name "python-cachelib")
    (version "0.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachelib" version))
       (sha256
        (base32 "0j0s5vyhgka6g16a7n9g1fcc8wqxdl8rgzvlwaz9axf5wfb8k790"))))
    (build-system pyproject-build-system)
    (arguments
     ;; These tests use a remote connection.
     (list #:test-flags #~(list "--ignore" "tests/test_dynamodb_cache.py"
                                "--ignore" "tests/test_mongodb_cache.py")))
    (native-inputs
     (list python-pytest python-pytest-xprocess python-setuptools python-wheel))
    (home-page "https://github.com/pallets-eco/cachelib")
    (synopsis "Collection of cache libraries")
    (description "Cachelib is a library extracted from @code{werkzeug} which
provides a collection of cache libraries in the same API interface.")
    (license license:bsd-3)))

(define-public python-pylru
  (package
    (name "python-pylru")
    (version "1.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jlhutch/pylru")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0sqai530d7fpjzny476f3zqq9mv05xqbyw500jmbhrpj9yy1l9xp"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test.py")))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/jlhutch/pylru")
    (synopsis "Least recently used (LRU) cache implementation")
    (description
     "Pylru implements a true LRU cache along with several support classes.
Pylru provides a cache class with a simple dict interface.  It also provides
classes to wrap any object that has a dict interface with a cache.  Both
write-through and write-back semantics are supported.  Pylru also provides
classes to wrap functions in a similar way, including a function decorator.")
    (license license:gpl2+)))

(define-public python-legacy-api-wrap
  (package
    (name "python-legacy-api-wrap")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "legacy_api_wrap" version))
       (sha256
        (base32
         "1d5jyd8d2wxm6y0s39wwqw87gdm4zqlbyz78cf3yqbrim1xdch4w"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pytest))
    (home-page "https://github.com/flying-sheep/legacy-api-wrap")
    (synopsis "Legacy API wrapper")
    (description "This module defines a decorator to wrap legacy APIs.  The
primary use case is APIs defined before keyword-only parameters existed.")
    (license license:gpl3+)))

(define-public python-langdetect
  (package
    (name "python-langdetect")
    (version "1.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "langdetect" version))
       (sha256
        (base32 "1805svvb7xjm4sf1j7b6nc3409x37pd1xmabfwwjf1ldkzwgxhfb"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-six))
    (home-page "https://github.com/Mimino666/langdetect")
    (synopsis "Language detection library")
    (description
     "This library is a port of Nakatani Shuyo's language-detection library
(version from 03/03/2014) to Python.")
    (license license:expat)))

(define-public python-pyasn1
  (package
    (name "python-pyasn1")
    (version "0.6.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyasn1" version))
       (sha256
        (base32
         "0d5h500ig8sp72pabd1wcyglc4951xalbkqahf056dl4vlmhsn3g"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'unittest
           #:test-flags #~(list "discover" "tests")))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/pyasn1/pyasn1")
    (synopsis "ASN.1 types and codecs")
    (description
     "This is an implementation of ASN.1 types and codecs in Python.  It is
suitable for a wide range of protocols based on the ASN.1 specification.")
    (license license:bsd-2)))

(define-public python-pyasn1-modules
  (package
    (name "python-pyasn1-modules")
    (version "0.4.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyasn1_modules" version))
        (sha256
         (base32
          "1rj1x4333b20chwslljsihngllj6yls63jmi8klam00ahzg92w37"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'unittest
           #:test-flags #~(list "discover" "tests")))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-pyasn1))
    (home-page "https://github.com/pyasn1/pyasn1-modules")
    (synopsis "ASN.1 codec implementations")
    (description
     "Pyasn1-modules is a collection of Python modules providing ASN.1 types and
implementations of ASN.1-based codecs and protocols.")
    (license license:bsd-3)))

(define-public python-asn1tools
  (package
    (name "python-asn1tools")
    (version "0.167.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asn1tools" version))
       (sha256
        (base32 "1cpm6m3znagc553bc5l0rhwg2fccrl0k8m1pbvn6x2kqdmpkzmfa"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" (string-join
                    ;; Tests fail with error: IndexError: string index out of
                    ;; range.  It may be some incompatability wit pyparsing,
                    ;; see <https://github.com/eerimoq/asn1tools/issues/167>.
                    (list "not test_c_source"
                          "test_command_line_generate_c_source_oer"
                          "test_command_line_generate_c_source_uper"
                          "test_command_line_generate_rust_source_uper"
                          "test_missing_parameterized_value"
                          "test_c_source"
                          "test_parse_parameterization")
                    " and not "))))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-bitstruct
           python-diskcache
           python-prompt-toolkit
           python-pyparsing))
    (home-page "https://github.com/eerimoq/asn1tools")
    (synopsis  "ASN.1 parsing, encoding and decoding")
    (description "This package provides ASN.1 parsing, encoding and decoding
for Python, including constraints checking.  It supports several
codecs (e.g. BER, PER, UPER, XER) as well as limited C source code generating
for OER and UPER.")
    (license license:expat)))

(define-public python-idna
  (package
    (name "python-idna")
    (version "3.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "idna" version))
       (sha256
        (base32
         "1a9yn40rph0amwq61j7j3nqm472baz6673ng6pfadg8a8ydmrxhj"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core))
    (home-page "https://github.com/kjd/idna")
    (synopsis "Internationalized domain names in applications")
    (description
     "This is a library to support the Internationalised Domain Names in
Applications (IDNA) protocol as specified in RFC 5891.  This version of the
protocol is often referred to as “IDNA2008” and can produce different results
from the earlier standard from 2003.  The library is also intended to act as a
suitable drop-in replacement for the “encodings.idna” module that comes with
the Python standard library but currently only supports the older 2003
specification.")
    (license license:bsd-4)))

(define-public python-libsass
  (package
    (name "python-libsass")
    (version "0.23.0")
    (source
     (origin
       ;; PyPI tarball is missing some test files.
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sass/libsass-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04jpk4y15k69chdnd64ks85bfn82071mbfiv2d1hl3y4zpvsn90a"))))
    (build-system pyproject-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         ;; Use Guix package of libsass instead of compiling from a checkout.
         (add-before 'build 'set-libsass
           (lambda _ (setenv "SYSTEM_SASS" "indeed")))
         ;; XXX: Silent 2 failing tests, reported to upstream (closed), see
         ;; https://github.com/sass/libsass-python/issues/440.  It passed with
         ;; libsass@3.6.5 which requires rebuild the world (1200+ packages),
         ;; remove when v3.6.5 is available.
         (add-before 'check 'silent-failing-tests
           (lambda _
             (substitute* "sasstests.py"
               (("def test_build_one")
                "def __off_test_build_one")
               (("def test_stack_trace_formatting")
                "def __off_test_stack_trace_formatting"))))
         (replace 'check
           (lambda* (#:key tests? #:allow-other-keys)
             (when tests?
               (invoke "pytest" "sasstests.py"))))
         (add-after 'install 'delete-test
           (lambda* (#:key inputs outputs #:allow-other-keys)
             ;; Delete sasstests.py because it attempts to open a file
             ;; that is not installed when loaded, which breaks the sanity
             ;; check.
             (delete-file (string-append
                           (assoc-ref outputs "out")
                           "/lib/python"
                           (python-version
                            (dirname (dirname
                                      (search-input-file inputs "bin/python"))))
                           "/site-packages/sasstests.py")))))))
    (native-inputs
     (list python-pytest python-setuptools python-werkzeug python-wheel))
    (inputs
     (list libsass))
    (home-page "https://sass.github.io/libsass-python/")
    (synopsis "Straightforward binding of libsass for Python")
    (description
     "This package provides a simple Python extension module @code{sass} which
is binding LibSass.")
    (license license:expat)))

(define-public python-idna-ssl
  (package
    (name "python-idna-ssl")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/aio-libs/idna-ssl")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fj4zkcnx3mk7kbnf4d6pjgv331n17wzpphpwdnmr498ghbsph9k"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))  ;circular dependency with python-aiohttp
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-idna))
    (home-page "https://github.com/aio-libs/idna-ssl")
    (synopsis "Support Unicode(idna) domains for Python's @code{ssl} module")
    (description
     "This package provides Unicode(idna) domains support for Python's
@code{ssl} module.  It patches @code{ssl.match_hostname} for that purpose.")
    (license license:expat)))

(define-public python-path
  (package
    (name "python-path")
    (version "17.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "path" version))
       (sha256
        (base32 "1scqbwgcbisx8mb28hw789a7np953851wg6z0bbzdm519znha7nl"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? (not (%current-target-system))
      #:test-flags
      #~(list "-k"
              (string-append
               ;; Do not test the myproject.toml build as it tries
               ;; to pull dependencies from the Internet.
               "not project "
               ;; This tests assumes a root user exists.
               "and not test_get_owner"))))
    (native-inputs
     (list python-appdirs
           python-more-itertools
           python-packaging
           python-pygments
           python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/jaraco/path")
    (synopsis "Object-oriented file system path manipulation library")
    (description "@code{path} (formerly @code{path.py}) implements path
objects as first-class entities, allowing common operations on files to be
invoked on those path objects directly.")
    (license license:expat)))

;; It may be removed after 2026-01-24.
(define-deprecated/public-alias python-path-bootstrap python-path)
(define-deprecated/public-alias python-pathpy python-path)

(define-public python-pretend
  (package
    (name "python-pretend")
    (version "1.0.9")
    (source
     (origin
       (method git-fetch)       ;no tests in PyPI archive
       (uri (git-reference
              (url "https://github.com/alex/pretend")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "156l685r9mg7i4xyrk9ql3sxk088irxlg8x7md5i0d05hdw1z8rs"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/alex/pretend")
    (synopsis "Library for stubbing in Python")
    (description
     "Pretend is a library to make stubbing with Python easier.  Stubbing is a
technique for writing tests.  You may hear the term mixed up with mocks,fakes,
or doubles.  Basically, a stub is an object that returns pre-canned responses,
rather than doing any computation.")
    (license license:bsd-3)))

(define-public python-pip-run
  (package
    (name "python-pip-run")
    (version "8.8.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/jaraco/pip-run")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ycrjj3jgqcr9c2k7y8vprq65iblg0q0hvwz8zwi13gmb0ffds0c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? (not (%current-target-system))
      #:test-flags
      #~(list "-k" (string-append
                    ;; Do not test the myproject.toml build as it tries
                    ;; to pull dependencies from the internet.
                    "not project "
                    ;; These tests attempt to install dependencies from
                    ;; the network and fail.
                    "and not test_pkg_imported "
                    "and not test_pkg_loaded_from_alternate_index "
                    "and not test_pkg_loaded_from_url "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-nbformat
           python-pygments
           python-pytest
           python-setuptools
           python-setuptools-scm))
    (propagated-inputs
     (list python-autocommand
           python-packaging
           python-path
           python-pip))
    (home-page "https://github.com/jaraco/pip-run")
    (synopsis "Dynamic dependency loader for Python")
    (description "The @command{pip-run} command provides on-demand temporary
package installation for a single interpreter run.  It replaces this series of
commands:
@example
$ virtualenv --python pythonX.X --system-site-packages /tmp/env
$ /tmp/env/bin/pip install pkg1 pkg2 -r reqs.txt
$ /tmp/env/bin/python ...
$ rm -rf /tmp/env
@end example")
    (license license:expat)))

;; It may be removed after 2026-01-24.
(define-deprecated/public-alias python-pip-run-bootstrap python-pip-run)

(define-public python-libarchive-c
  (package
    (name "python-libarchive-c")
    (version "5.2")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "libarchive_c" version))
              (sha256
               (base32
                "05vl0pjpv5wqy9xybzixjv9anvih9yjx361c4rw6xbq9hpiahi7x"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'reference-libarchive
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Retain the absolute file name of libarchive.so.
              (substitute* "libarchive/ffi.py"
                (("find_library\\('archive'\\)")
                 (string-append
                  "'"
                  (search-input-file inputs "/lib/libarchive.so")
                  "'"))))))))
    (native-inputs
     (list python-setuptools python-wheel python-pytest))
    (inputs
     (list libarchive))
    (home-page "https://github.com/Changaco/python-libarchive-c")
    (synopsis "Python interface to libarchive")
    (description
     "This package provides Python bindings to libarchive, a C library to
access possibly compressed archives in many different formats.  It uses
Python's @code{ctypes} foreign function interface (FFI).")
    (license license:lgpl2.0+)))

(define-public python-file
  (package/inherit file
    (name "python-file")
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f                                ;no tests
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'change-directory
            (lambda _
              (chdir "python")))
          (add-before 'build 'set-library-file-name
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "magic.py"
                (("find_library\\('magic'\\)")
                 (format #f "~s" (search-input-file inputs
                                                    "lib/libmagic.so")))))))))
    (inputs (list file))
    (native-inputs (cons* python-setuptools
                          (if (%current-target-system)
                              (list this-package)
                              '())))
    (synopsis "Python bindings to the libmagic file type guesser")
    (description "This package provides Python bindings to the libmagic file
type guesser.

Note that this module and the @code{python-magic} module both provide a
@file{magic.py} file; these two modules, which are different and were
developed separately, both serve the same purpose: provide Python bindings for
libmagic.")))

(define-public python-pydevd
  (package
    (name "python-pydevd")
    (version "3.2.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fabioz/PyDev.Debugger")
             (commit (string-append
                      "pydev_debugger_"
                      (string-join (string-split version #\.) "_")))))
       (modules '((guix build utils)))
       (snippet '(begin
                   ;; Delete pre-built binaries.
                   (for-each delete-file (find-files "." "\\.(so|dylib|dll)"))
                   ;; This source is generated via Cython.
                   (delete-file "_pydevd_bundle/pydevd_cython.c")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0a40574f0rx23gissxmrpjq9cimhjxqsq9wbv5l7620h3blb5510"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-n" (number->string (parallel-job-count))
              "-m" "not flaky"
              "-k"
              (string-join
               (list
                ;; The two "break_01" tests have been failing on
                ;; Python 3.10:
                ;; <https://github.com/fabioz/PyDev.Debugger/issues/222>.
                "not test_set_pydevd_break_01 "
                ;; the GUI event loop requires an X server.
                "test_gui_event_loop_custom"
                ;; This test validates that 'pydevd' is not in the
                ;; exception message, but it is due to being part
                ;; of the build file name present in the message.
                "test_evaluate_exception_trace"
                ;; This test fail with TimeoutError, no message on stderr.
                "test_soft_terminate"
                "test_debugger_case_deadlock_interrupt_thread"
                ;; subprocess.CalledProcessError
                ;; Python 3.11/3.12 specific issue:
                ;; <https://github.com/fabioz/PyDev.Debugger/issues/284>.
                "test_find_main_thread_id")
               " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tests
            (lambda _
              (substitute* "tests_python/test_convert_utilities.py"
                ;; Add missing trailing '/'.
                (("\"\\\\\\\\usr\\\\\\\\bin\\\\\\\\\") == \"/usr/bin" all)
                 (string-append all "/")))))
          (add-after 'unpack 'patch-command-paths
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "_pydevd_bundle/pydevd_api.py"
                (("'kill'")
                 (format #f "~s" (search-input-file inputs "bin/kill")))
                (("'pgrep'")
                 (format #f "~s" (search-input-file inputs "bin/pgrep"))))))
          (add-after 'unpack 'generate-sources
            (lambda _
              (setenv "PYTHONPATH" (getcwd))
              (invoke "python" "build_tools/build.py")))
          (add-after 'unpack 'adjust-attach-binary-name
            (lambda _
              (substitute*
                  '("pydevd_tracing.py"
                    "pydevd_attach_to_process/add_code_to_python_process.py")
                (("def get_(target|python_helper_lib)_filename.*" all)
                 (format #f "~a    return ~s~%" all
                         (string-append #$output "/lib/attach.so"))))))
          (add-after 'unpack 'patch-gdb
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute*
                  "pydevd_attach_to_process/add_code_to_python_process.py"
                (("'gdb',")
                 (format #f "~s," (search-input-file inputs "bin/gdb"))))))
          (add-after 'build 'build-attach-linux-binary
            (lambda _
              (invoke #+(cxx-for-target) "-shared" "-o" "attach.so"
                      "-fPIC" "-nostartfiles"
                      "pydevd_attach_to_process/linux_and_mac/attach.cpp")))
          (add-before 'check 'pre-check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "PYDEVD_USE_CYTHON" "YES"))))
          (add-after 'install 'install-attach-binary
            (lambda _
              (install-file "attach.so"
                            (string-append #$output "/lib"))))
          ;; Some modules aren't designed to be loadable by themselves, such
          ;; as 'pydev_app_engine_debug_startup' and fail.
          (delete 'sanity-check))))
    (native-inputs
     (list python-cython
           python-numpy
           python-psutil
           python-pytest
           python-pytest-xdist
           python-setuptools
           python-trio
           python-untangle
           python-wheel))
    (inputs (list coreutils gdb/pinned procps))
    (home-page "https://github.com/fabioz/PyDev.Debugger/")
    (synopsis "Python debugger")
    (description "PyDev.Debugger is a capable Python debugger used in PyDev
and other @acronym{IDEs, Integrated Development Environments}.")
    (license license:epl1.0)))

(define-public python-debugpy
  (package
    (name "python-debugpy")
    (version "1.8.17")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference              ;no tests in PyPI archive
             (url "https://github.com/microsoft/debugpy")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (modules '((guix build utils)))
       ;; Remove the bundled PyDev-Debugger copy, including its pre-built
       ;; attach binary.
       (snippet '(delete-file-recursively "src/debugpy/_vendored"))
       (patches (search-patches "python-debugpy-unbundle-pydevd.patch"))
       (sha256
        (base32
         "12yhmayc21zcq16dv5hrp4n896d9v3b88hh1biqvj8gnrmsxvcwb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ;FIXME: Fail on systems with YAMA LSM’s ptrace scope > 0.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-sh-in-tests
            (lambda _
              (substitute* "tests/debugpy/test_run.py"
                (("#!/bin/sh")
                 (string-append "#!" (which "sh"))))))
          (add-after 'unpack 'fix-version
            ;; Versioneer is useless when there is no git metadata.
            (lambda _
              (substitute* "setup.py"
                (("version=versioneer.get_version\\(),")
                 (format #f "version=~s," #$version)))))
          (add-before 'build 'configure
            (lambda _
              ;; This adjusts the behavior of debugpy to load pydevd from
              ;; Python site packages.
              (setenv "DEBUGPY_BUNDLING_DISABLED" "1"))))))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-pydevd))
    (home-page "https://aka.ms/debugpy")
    (synopsis "Debug Adapter Protocol Python implementation")
    (description "An implementation of the Debug Adapter Protocol for
Python.")
    (license license:expat)))

(define-public python-debian
  (package
    (name "python-debian")
    (home-page "https://salsa.debian.org/python-debian-team/python-debian")
    (version "0.1.49")
    (source
     (origin
       ;; Use git-fetch, as pypi doesn't include test suite.
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "190vy2ns0650icpwvv4qp6kr3c3i9jszy1vkdwpigxb96fs1bqf3"))
       (modules '((guix build utils)))
       (snippet
        #~(begin
            ;; python-apt, apt and dpkg are not yet available in guix,
            ;; and these tests heavily depend on them.
            (for-each delete-file
                      '("lib/debian/tests/test_deb822.py"
                        "lib/debian/tests/test_debfile.py"))

            ;; for reproducible builds, otherwise python-debian
            ;; generates a _version.py including the date
            (copy-file "lib/debian/_version.py.in" "lib/debian/_version.py")
            (substitute* "lib/debian/_version.py"
              (("__CHANGELOG_VERSION__") #$version))))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (propagated-inputs
     (list python-six python-chardet))
    (synopsis "Debian package related modules")
    (description
     "This package provides Python modules that abstract many formats of
Debian-related files, such as:
@itemize
@item Debtags information;
@item @file{debian/changelog} files;
@item packages files, pdiffs;
@item control files of single or multiple RFC822-style paragraphs---e.g.
   @file{debian/control}, @file{.changes}, @file{.dsc};
@item Raw @file{.deb} and @file{.ar} files, with (read-only) access to
   contained files and meta-information.
@end itemize")
    ;; Modules are either GPLv2+ or GPLv3+.
    (license license:gpl3+)))

(define-public python-json-spec
  (package
    (name "python-json-spec")
    (version "0.12.0")
    (source
     (origin
       (method git-fetch)               ;no tests in PyPI archive
       (uri (git-reference
              (url "https://github.com/johnnoone/json-spec")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14lzvpfi8vpwn2hsizljcyiiywfc1fssj0hh079jxw4xwjkm9328"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-poetry-core))
    (propagated-inputs
     (list python-termcolor)) ;for the CLI
    (home-page "https://json-spec.readthedocs.io/")
    (synopsis "JSON Schema, JSON Pointer and JSON Reference for Python")
    (description
     "This Python library implements several JSON specs, like JSON Schema,
JSON Reference and JSON Pointer.")
    (license license:bsd-3)))

(define-public python-fastbencode
  (package
    (name "python-fastbencode")
    (version "0.3.2")   ;the last non Rust version
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "fastbencode" version))
       (modules '((guix build utils)))
       ;; Delete pre-generated Cython C files.
       (snippet '(for-each delete-file (find-files "." "\\.c$")))
       (sha256
        (base32 "1daal7xgsl2sjxq8pcilcas9wd9j9796wd4rlkhrvv5h0k2k4k53"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags #~(list "fastbencode.tests.test_suite")))
    (native-inputs
     (list python-cython
           python-setuptools))
    (home-page "https://github.com/breezy-team/fastbencode")
    (synopsis "Python Bencode (de)serializer with optional fast C extensions")
    (description
     "The fastbencode Python package implements the bencode serialization
format for storing and transmitting loosely structured data, originally used
by BitTorrent.

The format can encode four different types of values: byte strings, integers,
lists, and dictionaries (associative arrays).  It's simple and unaffected by
endianness,

This package includes both a pure-Python version and an optional C extension
based on Cython.  Both provide the same functionality, but the C version has
significantly better performance.")
    (license (list license:expat        ; _bencode_py.py
                   license:gpl2+))))    ; __init__.py

(define-public python-fastjsonschema
  (package
    (name "python-fastjsonschema")
    (version "2.21.1")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/horejsek/python-fastjsonschema")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1j7dc8hlvrlhzkiv0vqzd6shhjaf14g9v3zlfn7x17j04c1g3iz7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--ignore=tests/benchmarks/test_benchmark.py")))
    (native-inputs
     (list python-json-spec
           python-jsonschema
           python-pytest
           python-pytest-benchmark
           python-setuptools))
    (home-page "https://github.com/horejsek/python-fastjsonschema")
    (synopsis "Fast Python implementation of JSON schema")
    (description
     "This library implements validation of JSON documents by JSON schema for
drafts 04, 06 and 07.")
    (license license:bsd-3)))

(define-public python-nbformat
  (package
    (name "python-nbformat")
    (version "5.10.4")
    ;; The PyPi release tarball lacks some test cases and test data.
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jupyter/nbformat")
                    (commit (string-append "v" version))))
              (sha256
               (base32
                "0abd1d8iq21dwh17m72na2f3kr6a5p6ji1gnykf06jshikalj2x3"))
              (file-name (git-file-name name version))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; We don't want to use hatch-nodejs just to get a version string.
          (add-after 'unpack 'patch-pyproject
            (lambda _
              (substitute* "pyproject.toml"
                ((", \"hatch-nodejs-version\"") "")
                (("dynamic = \\[\"version\"\\]")
                 (string-append "version = \"" #$version "\""))))))))
    (propagated-inputs
     (list python-fastjsonschema python-jsonschema python-jupyter-core
           python-traitlets))
    (native-inputs
     (list python-hatchling
           python-pep440
           python-pytest
           python-testpath))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter Notebook format")
    (description "This package provides the reference implementation of the
Jupyter Notebook format and Python APIs for working with notebooks.")
    (license license:bsd-3)))

(define-public python-nb-clean
  (package
    (name "python-nb-clean")
    (version "4.0.1")
    (source
      (origin
        (method git-fetch) ; no tests in PyPI
        (uri (git-reference
               (url "https://github.com/srstevenson/nb-clean")
               (commit version)))
        (file-name (git-file-name name version))
        (sha256
          (base32 "1pa4m1qn7gx77lg3vy7y7vlyl45cg9ai9z93ds9ax108mbnrbdw7"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-poetry-core
                         python-pytest
                         python-pytest-cov ; runs by default
                         python-pytest-mock))
    (propagated-inputs (list python-nbformat))
    (home-page "https://github.com/srstevenson/nb-clean")
    (synopsis "Clean Jupyter notebooks for versioning")
    (description "This package cleans Jupyter notebooks of cell execution
counts, metadata, outputs, and empty cells, preparing them for committing to
version control.  It provides a Git filter to automatically clean notebooks
before they're staged, and can also be used with other version control
systems, as a command line tool, and as a Python library.")
    (license license:isc)))

(define-public python-bleach
  (package
    (name "python-bleach")
    (version "6.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bleach" version))
       (sha256
        (base32 "07wrbzlmd6x63dz7lcdih9c4xkn79inimv6kh3yrk9dq310qjghj"))
       (snippet
        #~(begin
            (use-modules (guix build utils))
            (substitute* (find-files "." "\\.py$")
              (("bleach\\._vendor\\.html5lib") "html5lib"))
            (delete-file-recursively "bleach/_vendor/html5lib")))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-html5lib
           python-webencodings))
    (home-page "https://github.com/mozilla/bleach")
    (synopsis "Whitelist-based HTML-sanitizing tool")
    (description "Bleach is an easy whitelist-based HTML-sanitizing tool.")
    (license license:asl2.0)))

(define-public python-entrypoints
  (package
    (name "python-entrypoints")
    (version "0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "entrypoints" version))
       (sha256
        (base32 "1m5crkagmbvlgdwqv7nan64pbcjvy0c6idb7rpmik2i1m7dfs1mp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pytest))
    (home-page "https://github.com/takluyver/entrypoints")
    (synopsis "Discover and load entry points from installed Python packages")
    (description "Entry points are a way for Python packages to advertise
objects with some common interface.  The most common examples are
@code{console_scripts} entry points, which define shell commands by
identifying a Python function to run.  The @code{entrypoints} module contains
functions to find and load entry points.")
    (license license:expat)))

(define-public python-epc
  (package
    (name "python-epc")
    (properties '((commit . "f3673ae5c35f20a0f71546ab34c28e3dde3595c1")
                  (revision . "0")))
    (version (git-version "0.0.5"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tkf/python-epc")
             (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0q27bj49yan2qg6i8m5czs5b5jv26ff42yz7j4r5652s7j3f42mm"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'nose))
    (propagated-inputs (list python-sexpdata))
    (native-inputs (list python-pynose python-setuptools))
    (home-page "https://github.com/tkf/python-epc")
    (synopsis "Remote procedure call (RPC) stack for Emacs Lisp and Python")
    (description
     "Python-EPC can call elisp functions from Python and Python functions
from elisp.")
    (license license:gpl3)))

(define-public python-forex-python
  (package
    (name "python-forex-python")
    (version "1.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/MicroPyramid/forex-python")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0pl5sfd0wkv1a2y324l518h6sing7wkadrbr5xcf6hjykn2mbi5h"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; Tests require online data.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-requests python-simplejson))
    (home-page "https://github.com/MicroPyramid/forex-python")
    (synopsis "Foreign exchange rates and currency conversion")
    (description
     "@code{python-forex-python} can be used to manipulate foreign
exchange rates and to operate currency conversions.

Features:
@itemize
@item List all currency rates.
@item BitCoin price for all currencies.
@item Converting amount to BitCoins.
@item Get historical rates for any day since 1999.
@item Conversion rate for one currency(ex; USD to INR).
@item Convert amount from one currency to other.('USD 10$' to INR).
@item Currency symbols.
@item Currency names.
@end itemize")
    (license license:expat)))

(define-public python-simpleeval
  (package
    (name "python-simpleeval")
    (version "0.9.12")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/danthedeckie/simpleeval")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0khgl729q5133fgc00d550f4r77707rkkn7r56az4v8bvx0q8xp4"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/danthedeckie/simpleeval")
    (synopsis "Simple, safe single expression evaluator library")
    (description
     "This package provides a quick single file library for easily adding
evaluatable expressions into python projects.  Say you want to allow a user
to set an alarm volume, which could depend on the time of day, alarm level,
how many previous alarms had gone off, and if there is music playing at the
time.")
    (license license:expat)))

(define-public python-nbconvert
  (package
    (name "python-nbconvert")
    (version "7.16.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nbconvert" version))
       (sha256
        (base32
         "10pmq31p2srwcdrc7k71dj0l6hl42xnadvsy8swaf3a8qqvpwsjp"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k"
             (string-append
              ;; These tests require pyppeteer, not yet
              ;; available in Guix.
              "not test_webpdf_with_chromium"
              " and not test_webpdf.py"
              ;; These tests require ipywidgets, which would
              ;; introduce a dependency cycle.
              " and not test_execute_widgets_from_nbconvert"
              " and not test_execute_multiple_notebooks"

              ;; This test calls nbconvert itself via "sys.executable -m
              ;; nbconvert".  It's probably harmless.
              " and not test_default_config"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-paths
            (lambda* (#:key inputs #:allow-other-keys)
              ;; Use pandoc binary from input.
              (substitute* "nbconvert/utils/pandoc.py"
                (("'pandoc'")
                 (format #f "~s" (search-input-file inputs "bin/pandoc"))))
              ;; Same for LaTeX.
              (substitute* "nbconvert/exporters/pdf.py"
                (("\"xelatex\"")
                 (format #f "~s" (search-input-file inputs "bin/xelatex")))
                (("\"bibtex\"")
                 (format #f "~s" (search-input-file inputs "bin/bibtex"))))
              ;; Likewise for Inkscape.
              (substitute* "nbconvert/preprocessors/svg2pdf.py"
                (("inkscape_path = which\\(\"inkscape\")")
                 (format #f "inkscape_path = ~s"
                         (search-input-file inputs "bin/inkscape"))))))
          (add-after 'unpack 'ignore-deprecation-warnings
            (lambda _
              (substitute* "pyproject.toml"
                (("\"ignore:nbconvert.utils" m)
                 (string-append "\"ignore:zmq.eventloop.ioloop is deprecated:DeprecationWarning\",\n"
                                m)))))
          (add-before 'check 'pre-check
            (lambda _
              ;; Tests depend on templates installed to output.
              (setenv "JUPYTER_PATH"
                      (string-append #$output "/share/jupyter:"
                                     (getenv "JUPYTER_PATH")))
              ;; jupyter-core demands this
              (setenv "JUPYTER_PLATFORM_DIRS" "1")
              ;; Tests need writable HOME and TEXMFVAR.
              (setenv "HOME" "/tmp")
              (setenv "TEXMFVAR" "/tmp"))))))
    (inputs
     (list inkscape/pinned pandoc))
    (native-inputs
     (list python-flaky
           python-hatchling
           python-ipykernel
           ;; Adding ipywidgets would create a cycle.
           ;;python-ipywidgets
           python-pytest
           (texlive-local-tree
            (list texlive-adjustbox
                  texlive-booktabs
                  texlive-caption
                  texlive-enumitem
                  texlive-eurosym
                  texlive-fancyvrb
                  texlive-float
                  texlive-fontspec
                  texlive-grffile
                  texlive-jknapltx
                  texlive-parskip
                  texlive-pdfcol
                  texlive-rsfs
                  texlive-soul
                  texlive-tcolorbox
                  texlive-titling
                  texlive-ulem
                  texlive-unicode-math
                  texlive-upquote
                  texlive-xetex))))
    (propagated-inputs
     (list python-beautifulsoup4
           python-bleach
           python-defusedxml
           python-importlib-metadata
           python-jinja2
           python-jupyter-core
           python-jupyterlab-pygments
           python-markupsafe
           python-mistune
           python-nbclient
           python-nbformat
           python-packaging
           python-pandocfilters
           python-pygments
           python-tinycss2
           python-traitlets
           ;; Required, even if [serve] is not used.
           python-tornado-6
           ;; Required at runtime for `jupyter nbconvert --to=pdf`.
           texlive-adjustbox
           texlive-amsmath
           texlive-booktabs
           texlive-caption
           texlive-collection-basic
           texlive-enumitem
           texlive-environ
           texlive-etoolbox
           texlive-eurosym
           texlive-etoolbox
           texlive-fancyvrb
           texlive-float
           texlive-fontspec
           texlive-geometry
           texlive-grffile
           texlive-hyperref
           texlive-infwarerr
           texlive-jknapltx
           texlive-kvoptions
           texlive-lm
           texlive-lm-math
           texlive-mathpazo
           texlive-parskip
           texlive-pdfcol
           texlive-pgf
           texlive-rsfs
           texlive-soul
           texlive-stringenc
           texlive-tcolorbox
           texlive-titling
           texlive-tools
           texlive-trimspaces
           texlive-ucs
           texlive-ulem
           texlive-unicode-math
           texlive-upquote
           texlive-xcolor
           texlive-xetex
           texlive-zapfding))
    (home-page "https://jupyter.org")
    (synopsis "Converting Jupyter Notebooks")
    (description "The @code{nbconvert} tool, @code{jupyter nbconvert}, converts
notebooks to various other formats via Jinja templates.  It allows you to
convert an @code{.ipynb} notebook file into various static formats including:

@enumerate
@item HTML
@item LaTeX
@item PDF
@item Reveal JS
@item Markdown (md)
@item ReStructured Text (rst)
@item executable script
@end enumerate\n")
    (license license:bsd-3)))

(define-public python-ipywidgets
  (package
    (name "python-ipywidgets")
    (version "8.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ipywidgets" version))
       (sha256
        (base32
         "1ja2xibll6v40va3s7wz5dfp95q01yds64z6csl2dsds94gb9ffh"))))
    (build-system python-build-system)
    (propagated-inputs
     (list python-comm python-ipython python-jupyterlab-widgets
           python-traitlets python-widgetsnbextension))
    (native-inputs
     (list python-ipykernel python-jsonschema python-pytest python-pytest-cov
           python-pytz python-setuptools-67))
    (home-page "https://ipython.org")
    (synopsis "IPython HTML widgets for Jupyter")
    (description "Ipywidgets are interactive HTML widgets for Jupyter
notebooks and the IPython kernel.  Notebooks come alive when interactive
widgets are used.  Users gain control of their data and can visualize changes
in the data.")
    (license license:bsd-3)))

(define-public python-jupyter-console
  (package
    (name "python-jupyter-console")
    (version "6.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jupyter_console" version))
       (sha256
        (base32
         "1iqrxhd8hvlyf8cqbc731ssnwm61wrycnbiczy5wsfahd3hlh8i4"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs
     (list python-ipykernel python-jupyter-client python-prompt-toolkit
           python-pygments))
    (home-page "https://jupyter.org")
    (synopsis "Jupyter terminal console")
    (description "This package provides a terminal-based console frontend for
Jupyter kernels.  It also allows for console-based interaction with non-Python
Jupyter kernels such as IJulia and IRKernel.")
    (license license:bsd-3)))

;; The python-ipython and python-jupyter-console require each other. To get
;; the functionality in both packages working, strip down the
;; python-jupyter-console package when using it as an input to python-ipython.
(define python-jupyter-console-minimal
  (package/inherit python-jupyter-console
    (name "python-jupyter-console-minimal")
    (arguments
     (substitute-keyword-arguments
         (package-arguments python-jupyter-console)
       ((#:phases phases)
        `(modify-phases ,phases
           (add-after 'install 'delete-bin
             (lambda* (#:key outputs #:allow-other-keys)
               ;; Delete the bin files, to avoid conflicts in profiles
               ;; where python-ipython and python-jupyter-console are
               ;; both present.
               (delete-file-recursively
                (string-append
                 (assoc-ref outputs "out") "/bin"))))))))
    ;; Remove the python-ipython propagated input, to avoid the cycle
    (propagated-inputs
     (modify-inputs (package-propagated-inputs python-jupyter-console)
       (delete "python-ipython")))))

(define-public python-jsbeautifier
  (package
    (name "python-jsbeautifier")
    (version "1.15.3")
    (home-page "https://github.com/beautify-web/js-beautify")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url home-page)
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1zl1g6w5zn2hxk5qq83j52cxa1ig75ryjwsjxv9wiwkar4qq88zg"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'chdir
            (lambda _
              (chdir "python")
              (rename-file "setup-js.py" "setup.py"))))))
    (propagated-inputs (list python-editorconfig python-six))
    (native-inputs (list python-pytest python-setuptools))
    (synopsis "JavaScript unobfuscator and beautifier")
    (description
     "This packages provides tooling to beautify, unpack or deobfuscate
JavaScript, leveraging popular online obfuscators.")
    (license license:expat)))

(define-public python-chardet
  (package
    (name "python-chardet")
    (version "5.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "chardet" version))
       (sha256
        (base32
         "1xqwkjijq2fxn8rhcvfddl14lp39jllqbh527yy19i58g7s6yfqv"))))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           ;; Disable test that fails sporadically:
           ;; https://github.com/chardet/chardet/issues/256
           #~'("-k" "not test_detect_all_and_detect_one_should_agree")
           #:phases
           #~(modify-phases %standard-phases
               ;; This package provides a 'chardetect' executable that only
               ;; depends on Python, so customize the wrap phase to avoid
               ;; adding pytest and friends in order to save size.
               ;; (See also <https://bugs.gnu.org/25235>.)
               (replace 'wrap
                 (lambda* (#:key inputs outputs #:allow-other-keys)
                   (let* ((sitedir (site-packages inputs outputs))
                          (python (dirname (dirname
                                            (search-input-file
                                             inputs "bin/python"))))
                          (python-sitedir
                           (string-append python "/lib/python"
                                          (python-version python)
                                          "/site-packages")))
                     (wrap-program (string-append #$output "/bin/chardetect")
                       `("GUIX_PYTHONPATH" ":" suffix
                         ,(list sitedir python-sitedir)))))))))
    (home-page "https://github.com/chardet/chardet")
    (synopsis "Universal encoding detector for Python 2 and 3")
    (description
     "This package provides @code{chardet}, a Python module that can
automatically detect a wide range of file encodings.")
    (license license:lgpl2.1+)))

(define-public python-charset-normalizer
  (package
    (name "python-charset-normalizer")
    (version "3.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "charset_normalizer" version))
       (sha256
        (base32 "0qqfk84ka3d9hh0yf7n8y0qa0yn08ncdacjjckzix8ybkv5cxbjv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          ;; https://github.com/jawah/charset_normalizer/issues/625
          ;; https://github.com/jawah/charset_normalizer/pull/626
          (add-after 'unpack 'fix-scripts
            (lambda _
              (substitute* "pyproject.toml"
                (("charset_normalizer:cli.cli_detect")
                 "charset_normalizer.cli:cli_detect")))))))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/ousret/charset_normalizer")
    (synopsis "Universal Charset Detector, alternative to Chardet")
    (description "This library helps you read text from an unknown charset
encoding.  Motivated by @code{chardet}, it tries to resolve the issue by
taking a new approach.  All IANA character set names for which the Python core
library provides codecs are supported.")
    (license license:expat)))

(define-deprecated/public-alias python-charset-normalizer-3
  python-charset-normalizer)           ;may be removed after 2025-12-01

(define-public python-docopt
  (package
    (name "python-docopt")
    (version "0.6.2")
    (source
     (origin
       (method git-fetch)       ;no tests in PyPI archive
       (uri (git-reference
              (url "https://github.com/docopt/docopt")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0aad9gbswnnhssin2q0m5lmpm0ahyf80ahs2zjigbn5y7fvljnd0"))
       (patches (search-patches "python-docopt-pytest6-compat.patch"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "http://docopt.org")
    (synopsis "Command-line interface description language for Python")
    (description
     "This library allows the user to define a command-line interface from a
program's help message rather than specifying it programmatically with
command-line parsers like @code{getopt} and @code{argparse}.")
    (license license:expat)))

(define-public python-pythonanywhere
  (package
    (name "python-pythonanywhere")
    (version "0.17.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pythonanywhere/helper_scripts")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hsxrw1inqqnxbfvjk0j218ijx5xv4lkfh1qzvay7pzk9ifc0sfz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_django_project.py" ;depedns on submodule
              "-k" (string-join
                    ;; Network access is required to clone external
                    ;; repositories.
                    (list "not test_actually_creates_django_project_in_vir"
                          "test_actually_downloads_repo"
                          "test_actually_installing_a_real_package"
                          "test_actually_works_against_example_repo"
                          "test_autoconfigure_actually_works_against_example_repo"
                          "test_exits_because_boolean_not_satisfied"
                          "test_gets_version"
                          "test_nuke_option_lets_you_run_twice"
                          "test_nuke_option_lets_you_run_twice"
                          "test_start_actually_creates_django_project_in_vir")
                    " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'change-home
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-psutil
           python-pytest
           python-pytest-mock
           python-responses
           python-setuptools))
    (propagated-inputs
     (list python-dateutil
           python-docopt
           python-packaging
           python-pythonanywhere-core
           python-requests
           python-schema
           python-snakesay
           python-tabulate
           python-typer))
    (home-page "https://github.com/pythonanywhere/helper_scripts/")
    (synopsis "PythonAnywhere helper tools for users")
    (description
     "PythonAnywhere provides a command-line interface and an application
programming interface that allows managing files Web apps, scheduled
tasks and students.  It includes single-command deployment for the Django Girls
tutorial.")
    (license license:expat)))

(define-public python-pythonanywhere-core
  (package
    (name "python-pythonanywhere-core")
    (version "0.2.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/pythonanywhere/pythonanywhere-core")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1p9zlq3is0jvbni9ydiv6f0fw89lm44hkgbj6nari2a3gb3qw856"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-poetry-core
           python-pytest
           python-pytest-mock
           python-responses))
    (propagated-inputs
     (list python-dateutil
           python-requests
           python-snakesay
           python-typing-extensions))
    (home-page "https://github.com/pythonanywhere/pythonanywhere-core")
    (synopsis "API wrapper for PythonAnywhere services")
    (description
     "This package provides an API wrapper for programmatic management of
@code{PythonAnywhere} services.")
    (license license:expat)))

(define-public python-dialog
  (package
    (name "python-dialog")
    (version "3.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pythondialog" version))
       (sha256
        (base32 "08v3flvbhpc0p20drniiaalc3ijghlxk9ka5vz5mqqm6y254m8xj"))
       (modules '((guix build utils)))
       (snippet #~(delete-file-recursively "doc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: There are no tests, but some examples.  However, they need to
      ;; be run on a terminal.
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-path
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "dialog.py"
                (("_path_to_executable\\(dialog\\)")
                 (format #f "os.path.realpath(~s)"
                         (search-input-file inputs "bin/dialog")))))))))
    (native-inputs (list python-setuptools))
    (inputs (list dialog))
    (home-page "https://pythondialog.sourceforge.net/")
    (synopsis "Python interface to the UNIX dialog utility")
    (description
     "A Python wrapper for the dialog utility.  Its purpose is to provide an
easy to use, pythonic and comprehensive Python interface to dialog.  This
allows one to make simple text-mode user interfaces on Unix-like systems")
    (license license:lgpl2.1)))

(define-public python-pythondialog
  (deprecated-package "python-pythondialog" python-dialog))

(define-public python-confection
  (package
    (name "python-confection")
    (version "0.1.5")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "confection" version))
              (sha256
               (base32
                "03hgb6601mx6iip4nr8i0is8x5vmh85z286j7j8lhkxxlqydswlf"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-pydantic-2 python-srsly))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/explosion/confection")
    (synopsis "Config system for Python")
    (description "Confection is a lightweight library that offers a
configuration system letting you conveniently describe arbitrary trees of
objects.")
    (license license:expat)))

(define-public python-configobj
  (package
    (name "python-configobj")
    (version "5.0.9")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "configobj" version))
       (sha256
        (base32 "0j3872id3ngxkaapz9bv8as4lg4rfmch0dxqy767p81syaxq3j03"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/DiffSK/configobj")
    (synopsis "Config file reading, writing and validation")
    (description
     "ConfigObj is a simple but powerful config file reader and writer: an
 ini file round tripper.  Its main feature is that it is very easy to use,
with a straightforward programmer’s interface and a simple syntax for config
files.")
    (license license:bsd-3)))

(define-public python-omegaconf
  (let ((commit "117f7de07285e4d1324b9229eaf873de15279457")
        (revision "0"))
    (package
      (name "python-omegaconf")
      (version (git-version "2.3.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/omry/omegaconf")
                (commit commit)))
         (file-name (git-file-name name version))
         (modules '((guix build utils)))
         (snippet
          #~(begin
              (delete-file-recursively "build_helpers/bin")
              (substitute* "build_helpers/build_helpers.py"
                (("java") "antlr4")
                (("\"-jar\",") "")
                (("str\\(build_dir / \"bin\" / \"antlr.*\"\\),") ""))))
         (sha256
          (base32 "0f922dar5dwyyfk1bwsbs9gws0vyj1w2h9n3148hcfa8c4hg2ysv"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        #:test-flags
        ;; XXX: Those tests currently fail collection.
        #~(list "--ignore=tests/structured_conf/test_structured_config.py"
                "--ignore=tests/test_basic_ops_list.py"
                "--ignore=tests/test_merge.py"
                "--ignore=tests/test_select.py")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'loosen-requirements
              (lambda _
                (substitute* "requirements/base.txt"
                  (("antlr4-python3-runtime==.*")
                   "antlr4-python3-runtime >=4.9\n"))
                ;; Ignore deprecation warnings.
                (substitute* "pyproject.toml"
                  (("-Werror") "")))))))
      (native-inputs
       (list icedtea
             antlr4
             python-pytest
             python-pytest-mock
             python-setuptools
             python-wheel))
      (propagated-inputs
       (list java-antlr4-runtime-python
             python-pydevd
             python-pyyaml))
      (home-page "https://github.com/omry/omegaconf")
      (synopsis "Flexible configuration system")
      (description
       "OmegaConf is a hierarchical configuration system and supports merging
configurations from multiple sources.  It provides a consistent API regardless
of how the configuration was created.")
      (license license:bsd-3))))

(define-public python-configargparse
  (package
    (name "python-configargparse")
    (version "1.7")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "ConfigArgParse" version))
              (sha256
               (base32
                "1l866g1dcf2ljf8fl7ggpxk1rggry0lya4d5b264gradi1qp81p7"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-pyyaml))
    (native-inputs
     (list python-mock python-pytest python-setuptools python-wheel))
    (synopsis "Replacement for argparse")
    (description "A drop-in replacement for argparse that allows options to also
be set via config files and/or environment variables.")
    (home-page "https://github.com/bw2/ConfigArgParse")
    (license license:expat)))

(define-public python-connection-pool
  (package
    (name "python-connection-pool")
    (version "0.0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/zhouyl/ConnectionPool")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1c6676vga0p4xxa3f0jpbwgp3n69mxjisnfcwibd9x23iyxf3sr2"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; No tests.
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/zhouyl/ConnectionPool")
    (synopsis "Thread-safe connection pool")
    (description
     "This package provides a library implementing a thread-safe connection
pool.")
    (license license:expat)))

(define-public python-argparse-dataclass
  (package
    (name "python-argparse-dataclass")
    (version "2.0.0")
    (source
     (origin
       (method git-fetch)       ;no tests in PyPI archive
       (uri (git-reference
              (url "https://github.com/mivade/argparse_dataclass")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fbxs2a4jk5bvy42jlnqw4l02zs1s6mmfn4sr8rknyc4ngl4y9q1"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/mivade/argparse_dataclass")
    (synopsis "Declarative command-line interfaces using argparse and dataclasses")
    (description
     "This package provides declarative command-line interfaces using argparse
and dataclasses.")
    (license license:expat)))

(define-public python-argparse-manpage
  (package
    (name "python-argparse-manpage")
    (version "4.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argparse_manpage" version))
       (sha256
        (base32 "0clb20scp408gxac675v731vnj89pk9d5fb7pcy7bj1a45mvgshx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Tests require PIP.
      #~(list "--ignore=tests/test_examples.py")))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/praiskup/argparse-manpage")
    (synopsis "Build manual page from Python's ArgumentParser object")
    (description
     "This package provides tools to build manual pages from Python's
@code{ArgumentParser} object.")
    (license license:asl2.0)))

(define-public python-atomicwrites
  (package
    (name "python-atomicwrites")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/untitaker/python-atomicwrites")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1f21l5fyh8qmsacbsknwwgnd1b9x4i0aw0zpczr05wklkkbvd58y"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (synopsis "Atomic file writes in Python")
    (description
     "Library for atomic file writes using platform dependent tools
for atomic file system operations.")
    (home-page "https://github.com/untitaker/python-atomicwrites")
    (license license:expat)))

(define-public python-qstylizer
  (package
    (name "python-qstylizer")
    (version "0.2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/blambright/qstylizer")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0413msw23kv87fgs14ajp9wb2qxkcw6ydvwjzabz7xcp8iif9kr2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-pbr-version
            (lambda _
              (setenv "PBR_VERSION" "3.0.1"))))))
    (native-inputs
     (list python-pbr
           python-pytest
           python-pytest-mock
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-inflection
           python-tinycss2))
    (home-page "https://github.com/blambright/qstylizer")
    (synopsis "Qt stylesheet generation utility for PyQt/PySide")
    (description "@code{qstylizer} is a Python package designed to help with
the construction of PyQt/PySide stylesheets.")
    (license license:expat)))

(define-public python-click-threading
  (package
    (name "python-click-threading")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/click-contrib/click-threading")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "185pzw12ap7wrjpyxhsyrkhh7i1l5qclaa3zlpn8qvm39fz0kjni"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-click))
    (synopsis "Utilities for multithreading in Click")
    (description
     "This package provides utilities for multithreading in Click
applications.")
    (home-page "https://github.com/click-contrib/click-threading")
    (license license:expat)))

(define-public python-click-log
  (package
    (name "python-click-log")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/click-contrib/click-log")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01zpjyqnyzrx6xi7cii2180bqdcg2a6b1sdbjijri8jv755r7ray"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-click))
    (synopsis "Logging for click applications")
    (description
     "This package provides a Python library for logging Click applications.")
    (home-page "https://github.com/click-contrib/click-log")
    (license license:expat)))

(define-public python-click-default-group
  (package
    (name "python-click-default-group")
    (version "1.2.4")
    (source
     (origin
       (method git-fetch)               ; no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/click-contrib/click-default-group")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06h12qwg0lhvxlgfm9768afibwp8j6r3r440v630a30bv0nkhngm"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-click))
    (native-inputs
     (list python-flit-core python-pytest))
    (synopsis "Extends click.Group")
    (description "This package extends click.Group to invoke a command without
explicit subcommand name.")
    (home-page "https://github.com/click-contrib/click-default-group")
    (license license:bsd-3)))

(define-public python-apipkg
  (package
    (name "python-apipkg")
    (version "3.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "apipkg" version))
       (sha256
        (base32 "03ay7j57mfh4sa8vh9qwid1ggwdc0lasyw3ycsmgv5r6z2j63an7"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ;no tests in PyPI archvie
    (native-inputs
     (list python-hatch-vcs
           python-hatchling))
    (home-page "https://github.com/pytest-dev/apipkg")
    (synopsis "Namespace control and lazy-import mechanism")
    (description "With apipkg you can control the exported namespace of a Python
package and greatly reduce the number of imports for your users.  It is a small
pure Python module that works on virtually all Python versions.")
    (license license:expat)))

(define-public python-essentials
  (package
    (name "python-essentials")
    (version "1.1.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Neoteroi/essentials")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1k8ybgxh0xvwxjc22pkmyvdhm0jgmj77rlg656r81iiibc0l7zj8"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pydantic
           python-pytest-asyncio))
    (home-page "https://github.com/Neoteroi/essentials/wiki")
    (synopsis
     "Utility functions, exceptions, and classes for Python applications")
    (description
     "Essentials is a collection of functions, exceptions, and classes for Python
applications.  Examples of utilities are exceptions for common scenarios,
friendly JSON encoder, decorators for retries and logging.")
    (license license:expat)))

(define-public python-execnet
    (package
      (name "python-execnet")
      (version "2.1.1")
      (source (origin
                (method git-fetch)
                (uri (git-reference
                      (url "https://github.com/pytest-dev/execnet")
                      (commit (string-append "v" version))))
                (file-name (git-file-name name version))
                (sha256
                 (base32
                  "0xlfd0h9sjl0jpc2fc689a497chwbagali7qr364k75hdyax3jfq"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        ;; ;; This test hasn't been updated for the latest Pytest yet:
        ;; #:test-flags #~(list "--ignore" "testing/test_rsync.py")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'adjust-for-pytest-7.2+
              (lambda _
                ;; This test fails with an error because @py.test has been
                ;; deprecated for @pytest in recent Pytest.
                (substitute* "testing/test_rsync.py"
                  (("@py.test")
                   "@pytest"))))
            (add-before 'build 'pretend-version
              ;; The version string is usually derived via setuptools-scm, but
              ;; without the git metadata available this fails.
              (lambda _
                ;; hatch-vcs uses setuptools under the hood.
                (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                        ;; Massage the version string to a PEP-0440 compatible
                        ;; one.
                        #$(car (string-split version #\-)))))
            (add-before 'check 'prepare-for-tests
              (lambda _
                ;; Unset PYTHONDONTWRITEBYTECODE to match the
                ;; expectations of a test in
                ;; 'testing/test_gateway.py'.
                (unsetenv "PYTHONDONTWRITEBYTECODE"))))))
      (native-inputs
       (list python-hatchling
             python-hatch-vcs
             python-pytest-bootstrap))
      (synopsis "Rapid multi-Python deployment")
      (description "Execnet provides a share-nothing model with
channel-send/receive communication for distributing execution across many
Python interpreters across version, platform and network barriers.  It has a
minimal and fast API targeting the following uses:
@enumerate
@item distribute tasks to (many) local or remote CPUs
@item write and deploy hybrid multi-process applications
@item write scripts to administer multiple environments
@end enumerate")
      (home-page "https://codespeak.net/execnet/")
      (license license:expat)))

(define-public python-icalendar
  (package
    (name "python-icalendar")
    (version "5.0.13")
    (source (origin
             (method url-fetch)
             (uri (pypi-uri "icalendar" version))
             (sha256
              (base32
               "01lp0advx60z8wgng8aga1p1668ydn1r6d9qm3d622yfikg9yycj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "pytest" "-vv" "src/icalendar/tests")))))))
    (propagated-inputs
     (list python-dateutil python-pytz python-tzdata))
    (native-inputs
     (list python-pytest python-pytz python-setuptools python-wheel))
    (synopsis "Python library for parsing and generating iCalendar files")
    (description
     "@code{icalendar} is a Python library for parsing and generating iCalendar files.")
    (home-page "https://github.com/collective/icalendar")
    (license license:bsd-2)))

(define-public python-args
  (let ((commit "9460f1a35eb3055e9e4de1f0a6932e0883c72d65")
        (revision "0"))
    (package
      (name "python-args")
      (version (git-version "0.1.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://github.com/kennethreitz-archive/args")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1zfxpbp9vldqdrjmd0c6y3wisl35mx5v8zlyp3nhwpy1730wrc9j"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        #:tests? #f ; XXX: python-nose is deprecated.
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'patch-args.py
              (lambda _
                (substitute* "args.py"
                  (("basestring")
                   "str")))))))
      (native-inputs (list python-setuptools python-wheel))
      (home-page "https://github.com/kennethreitz-archive/args")
      (synopsis "Command-line argument parser")
      (description
       "This library provides a Python module to parse command-line arguments.")
      (license license:bsd-3))))

(define-public python-clint
  (package
    (name "python-clint")
    (version "0.5.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "clint" version))
              (sha256
               (base32
                "1an5lkkqk1zha47198p42ji3m94xmzx1a03dn7866m87n4r4q8h5"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (propagated-inputs
     (list python-args))
    (home-page "https://github.com/kennethreitz/clint")
    (synopsis "Command-line interface tools")
    (description
     "Clint is a Python module filled with a set of tools for developing
command-line applications, including tools for colored and indented
output, progress bar display, and pipes.")
    (license license:isc)))

(define-public python-rply
  (package
    (name "python-rply")
    (version "0.7.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/alex/rply")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kn8vikyf95mr8l9g3324b7gk4cgxlvvy1abqpl1h803idqg1vwq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--ignore=tests/test_ztranslation.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'fix-pytest-use
            (lambda _
              (substitute* (find-files "tests" "\\.py$")
                (("import py")
                 "import pytest")
                (("py\\.test")
                 "pytest"))
              (setenv "HOME" (getcwd)))))))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-appdirs))
    (home-page "https://github.com/alex/rply")
    (synopsis "Parser generator for Python")
    (description
     "This package provides a pure Python based parser generator, that also
works with RPython.  It is a more-or-less direct port of David Bazzley's PLY,
with a new public API, and RPython support.")
    (license license:bsd-3)))

(define-public python-hy
  (package
    (name "python-hy")
    (version "1.1.0")
    (source
     (origin
       (method git-fetch) ;no tests in PyPI release
       (uri (git-reference
             (url "https://github.com/hylang/hy")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1g7h7c9zwbcvsi1l3mydhv27bjkiz5wawmdklmryjnv6qkvdx96d"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; This test expects the hy executable to be called 'hy', but in Guix
      ;; it's .hy-real.
      #:test-flags #~(list "-k" "not test_sys_executable")))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-funcparserlib))
    (home-page "https://docs.hylang.org/en/stable/")
    (synopsis "Lisp frontend to Python")
    (description
     "Hy is a dialect of Lisp that's embedded in Python.  Since Hy transforms
its Lisp code into the Python Abstract Syntax Tree, you have the whole world of
Python at your fingertips, in Lisp form.")
    (license license:expat)))

(define-public python-hissp
  (package
    (name "python-hissp")
    (version "0.5.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/gilch/hissp")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "03lxna935c0qs3lppb2xrvvgh0dkwz8lh5pmgqrmpddin1kxyjri"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-hypothesis python-setuptools))
    (home-page "https://github.com/gilch/hissp")
    (synopsis "It's Python with a Lissp")
    (description
     "Hissp is a modular Lisp implementation that compiles to a functional
subset of Python—Syntactic macro metaprogramming with full access to the
Python ecosystem.")
    (license license:asl2.0)))

(define-public python-promise
  (package
    (name "python-promise")
    (version "2.3.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/syrusakbary/promise")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "17mq1bm78xfl0x1g50ng502m5ldq6421rzz35hlqafsj0cq8dkp6"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_benchmark.py"
              ;;  Issues with pytest-asyncio
              "--ignore=tests/test_awaitable.py"
              "-k" (string-join
                    (list "not test_issue_9_safe"
                          ;; Stacktrace issues.
                          "test_thrown_exceptions_have_stacktrace"
                          "test_thrown_exceptions_preserve_stacktrace")
                    " and not "))))
    (native-inputs
     (list python-mock
           python-pytest
           python-pytest-asyncio
           python-setuptools))
    (propagated-inputs (list python-six))
    (home-page "https://github.com/syrusakbary/promise")
    (synopsis "Promises/A+ implementation for Python")
    (description
     "This package provides an implementation of Promises in Python. It is a
super set of Promises/A+ designed to have readable, performant code and to
provide just the extensions that are absolutely necessary for using promises
in Python.")
    (license license:expat)))

(define-public python-progress
  (package
    (name "python-progress")
    (version "1.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/verigak/progress/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qz5b9d3cvfdy2f1gb4r20f1qgcsihhmbc2bm2jgbvryxylp0f5k"))
       (snippet #~(delete-file "demo.gif"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test_progress.py")))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/verigak/progress/")
    (synopsis "Progress reporting bars for Python")
    (description
     "This Python package provides progress reporting for visual of progress
of long running operations.  There are multiple choices of progress bars and
spinners, with customizable options, such as width, fill character, and
suffix.")
    (license license:isc)))

(define-public python-progressbar2
  (package
    (name "python-progressbar2")
    (version "4.5.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "progressbar2" version))
       (sha256
        (base32 "1yw8j3sz9y3nw2x1ffiqqzml8l9vb0kixxnsjkmk3vc691icnqk6"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--pyargs" "progressbar" "tests")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Drop test coverage requirements.
              (substitute* "pytest.ini"
                ((".*-cov.*") "")))))))
    (native-inputs
     (list python-dill
           python-pytest
           python-freezegun
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (propagated-inputs
     (list python-utils))
    (home-page "https://github.com/WoLpH/python-progressbar")
    (synopsis "Text progress bar library for Python")
    (description
     "This package provides a Python progressbar library to provide
visual (yet text based) progress to long running operations.")
    (license license:bsd-3)))

(define-public python-progressbar33
  (package
    (name "python-progressbar33")
    (version "2.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/germangh/python-progressbar")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vyn2l6i7fgqskqfx3nfs1dibc5v1cxydg3v3422xf41pkba282c"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "examples.py")))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/germangh/python-progressbar")
    (synopsis "Text progress bar library for Python")
    (description
     "This package provides a text progress bar library for Python.  This
version only differs from the original @code{progressbar} package in that it
uses relative package imports instead of absolute imports, which is necessary
for the module to work under Python 3.3.")
    ;; Either or both of these licenses may be selected.
    (license (list license:lgpl2.1+ license:bsd-3))))

(define-public python-colorama
  (package
   (name "python-colorama")
   (version "0.4.6")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "colorama" version))
     (sha256
      (base32 "0i3fpq0w5mbfdpy3z9p5raw4fg17jxr6jwh5l8qhavpdnxf5ys88"))))
   (build-system pyproject-build-system)
   (native-inputs (list python-hatchling python-pytest))
   (home-page "https://pypi.org/project/colorama/")
   (synopsis "Colored terminal text rendering for Python")
   (description "Colorama is a Python library for rendering colored terminal
text.")
   (license license:bsd-3)))

;; XXX: Not maintained since 2012.
(define-public python-monthdelta
  (package
    (name "python-monthdelta")
    (version "0.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "MonthDelta" version))
       (sha256
        (base32 "0iwcsk7ryjw5h1wp10ykwd01f3am8gdlga6461q1v1njsk0rxh41"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "http://packages.python.org/MonthDelta")
    (synopsis "Date computations with months")
    (description
     "MonthDelta provides functionality to do date computations with months.")
    (license license:expat)))

(define-public python-moto
  (package
    (name "python-moto")
    (version "5.1.5")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "moto" version))
              (sha256
               (base32 "0kpqdn96gw9h2bq05bp943q85f4lq89c4nk1gf71w60nkbm65cs2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 10158 passed, 41 skipped, 143 deselected, 2 xfailed, 4 warnings
      #:test-flags
      #~(list "-m" "not network and not requires_docker"
              ;; Not all of the tests are thread save, see:
              ;; <https://github.com/getmoto/moto/issues/7786>.
              ;; "--numprocesses" (number->string (min 8 (parallel-job-count)))
              "-k" (string-join
                    ;; Outbound access to AWS servcies is required to reach
                    ;; endpoint URLs:
                    ;; "https://s3.amazonaws.com/"
                    ;; "https://realbucket.s3.amazonaws.com/"
                    ;; "https://s3.amazonaws.com/companyname_prod"
                    (list "not test_passthrough_calls_for_entire_service"
                          "test_passthrough_calls_for_specific_url"
                          "test_passthrough_calls_for_wildcard_urls"
                          ;; TypeError: Got unexpected keyword argument
                          ;; 'account_id_endpoint_mode'
                          "test_dynamodb_with_account_id_routing[disabled]"
                          "test_dynamodb_with_account_id_routing[preferred]"
                          "test_dynamodb_with_account_id_routing[required]"
                          ;; botocore.exceptions.ParamValidationError:
                          ;; Parameter validation failed: Missing required
                          ;; parameter in input: "VpcId"; Missing required
                          ;; parameter in input: "SubnetMappings"
                          "test_create_firewall"
                          "test_describe_logging_configuration"
                          "test_list_firewalls"
                          "test_update_logging_configuration"
                          ;; RuntimeError: Firehose PutRecord(Batch) to HTTP
                          ;; destination failed
                          "test_put_record_http_destination"
                          "test_put_record_batch_http_destination"
                          ;; Timed out to connect to foo.localhost:5001
                          "test_with_custom_request_header"
                          ;; Timed out to connect to testcors.localhost:6789
                          "test_s3_server_post_cors_multiple_origins"
                          ;; AttributeError: 'TimestreamInfluxDB' object has
                          ;; no attribute 'list_db_clusters'
                          "test_list_db_clusters"
                          "test_get_db_cluster"
                          "test_create_db_cluster"
                          ;; Checksum error
                          "test_upload_file_with_checksum_algorithm"
                          "test_list_objects_v2_checksum_algo"
                          ;; Assertion is not equal
                          "test_create_describe_update_and_delete_ledger"
                          "test_s3tables_get_table"
                          "test_tag_resource_and_list_tags_for_resource"

                          ;; XXX: Probably will be resolved in the next
                          ;; release, as botocore's refresh pace is fast.
                          ;;
                          ;; botocore.exceptions.UnknownServiceError: Unknown
                          ;; service: <...>
                          "test_create_app_response"
                          "test_describe_apps"
                          "test_create_instance"
                          "test_describe_instances"
                          "test_ec2_integration"
                          "test_create_layer_response"
                          "test_describe_layers"
                          "test_create_stack_response"
                          "test_describe_stacks"
                          "test_robot_application"
                          "test_create_describe_update_and_delete_ledger"
                          "test_tag_resource_and_list_tags_for_resource"
                          ;; botocore.exceptions.ClientError: An error
                          ;; occurred (404) when calling <...>
                          "test_create_event_source_mapping"
                          "test_delete_event_source_mapping"
                          "test_delete_table_deletes_underlying_table_storage"
                          "test_event_source_mapping_create_from_cloudformation_json"
                          "test_event_source_mapping_delete_from_cloudformation_json"
                          "test_event_source_mapping_delete_stack"
                          "test_event_source_mapping_update_from_cloudformation_json"
                          "test_get_event_source_mapping"
                          "test_get_table"
                          "test_invoke_fake_function_from_sqs_queue"
                          "test_list_event_source_mappings"
                          "test_rename_table"
                          "test_underlying_table_storage_does_not_support_delete_object"
                          "test_underlying_table_storage_does_not_support_list_objects"
                          "test_update_event_source_mapping"
                          "test_update_table_metadata_location"
                          "test_write_metadata_to_table"
                          ;; botocore.exceptions.ParamValidationError:
                          ;; Parameter validation failed <...>
                          "test_create_db_proxy"
                          "test_create_db_proxy_duplicate_name"
                          "test_create_db_proxy_invalid_subnet"
                          "test_describe_db_proxies"
                          "test_list_tags_db_proxy")
                    " and not ")
              "tests")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-hardcoded-executable-names
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((bash-exec (search-input-file inputs "/bin/sh")))
                (substitute* "moto/batch/models.py"
                  (("/bin/sh") bash-exec))
                (substitute* (find-files "tests" "\\.py$")
                  (("#!/bin/bash") (string-append "#!" bash-exec))))))
          (add-before 'check 'pre-check
            (lambda _
              (setenv "AWS_ACCESS_KEY_ID" "guix-access-key-id")
              (setenv "AWS_SECRET_ACCESS_KEY" "guix-secret-access-key")
              (setenv "TESTS_SKIP_REQUIRES_DOCKER" "true"))))))
    (native-inputs
     (list python-flask
           python-flask-cors
           python-freezegun
           python-pycognito
           python-pyotp
           python-pytest
           python-setuptools))
    (inputs
     (list bash-minimal))
    (propagated-inputs
     (list java-antlr4-runtime-python
           python-aws-xray-sdk
           python-boto3
           python-botocore
           python-cfn-lint
           python-cryptography
           python-dateutil
           python-graphql-core
           python-jinja2
           python-joserfc
           python-jsonpath-ng
           python-multipart
           python-openapi-spec-validator
           python-py-partiql-parser
           python-pyparsing
           python-requests
           python-responses
           python-werkzeug
           python-xmltodict))
    (home-page "https://github.com/spulec/moto")
    (synopsis "Mock out the boto library")
    (description
     "@code{moto} is a library designed to easily mock out the
@code{boto} library.")
    (license license:asl2.0)))

(define-public python-plumbum
  (package
    (name "python-plumbum")
    (version "1.7.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/tomerfiliba/plumbum")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1vlaiz4bwgrcay51knj6a20lh3lwihjqxhxhdk6nqkn9ijg0hc81"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_remote.py"
              "--ignore=tests/test_putty.py"
              "--ignore=tests/test_sudo.py"
              "-k"
              (string-join (list "not test_home"
                                 "test_iter_lines_error"
                                 "test_quoting"
                                 "test_copy_move_delete")
                           " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list procps
           python-psutil
           python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://plumbum.readthedocs.io")
    (synopsis "Python shell combinators library")
    (description
     "Plumbum is a library of tools for replacing shell scripts with Python
code.")
    (license license:expat)))

(define-public python-deprecation
  (package
    (name "python-deprecation")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "deprecation" version))
       (sha256
        (base32
         "1zqqjlgmhgkpzg9ss5ki8wamxl83xn51fs6gn2a8cxsx9vkbvcvj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'drop-unittest2
            ;; See: <https://github.com/briancurtin/deprecation/issues/54>.
            (lambda _
              (substitute* "tests/test_deprecation.py"
                (("import unittest2")
                 "import unittest as unittest2")))))))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-packaging))
    (home-page "https://deprecation.readthedocs.io/")
    (synopsis "Python library to handle automated deprecations")
    (description
     "This is a library that enables automated deprecations.  It offers the
@code{deprecated()} decorator to wrap functions, providing proper warnings
both in documentation and via Python’s warnings system, as well as the
@code{deprecation.fail_if_not_removed()} decorator for test methods to ensure
that deprecated code is eventually removed.")
    (license license:asl2.0)))

(define-public python-jmespath
  (package
   (name "python-jmespath")
   (version "1.0.1")
   (source
    (origin
     (method url-fetch)
     (uri (pypi-uri "jmespath" version))
     (sha256
      (base32
       "1gpdc1f0q5c9scmbw1l9g40jjfk3pxwg91ayvn7xbvvddlh1n9lh"))))
   (build-system python-build-system)
   (native-inputs
    (list python-pytest python-setuptools-67))
   (synopsis "JSON Matching Expressions")
   (description "JMESPath (pronounced “james path”) is a Python library that
allows one to declaratively specify how to extract elements from a JSON
document.")
   (home-page "https://github.com/jmespath/jmespath.py")
   (license license:expat)))

(define-public python-asteval
  (package
    (name "python-asteval")
    (version "1.0.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asteval" version))
       (sha256
        (base32 "17x1qk07cixj1nn59pp5dzjc9jna92v6kljdss81l5rf9cqfga0s"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/newville/asteval")
    (synopsis "Minimalistic evaluator of Python expressions")
    (description
     "This package provides a minimalistic evaluator of Python expression
using the @code{ast} module.")
    (license license:expat)))

(define-public python-lmfit
  (package
    (name "python-lmfit")
    (version "1.3.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lmfit" version))
       (sha256
        (base32
         "15z4zcyc4crfdw22qnbaq8wrf552jgl83gd3nk2zc5zp8f6c48iw"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Costly tests that may fail with multiprocessing.context.TimeoutError.
      #~(list "--ignore=tests/test_jacobian_pickling.py")
      #:phases
      #~(modify-phases %standard-phases
          ;; XXX: Unclear why, but the phase seems broken.
          ;; asteval>=1.0 is not understood correctly.
          (delete 'sanity-check))))
    (propagated-inputs
     (list python-asteval python-dill python-numpy python-scipy
           python-uncertainties))
    (native-inputs
     (list python-pytest python-pytest-cov python-setuptools))
    (home-page "https://lmfit.github.io/lmfit-py/")
    (synopsis "Least-Squares minimization with bounds and constraints")
    (description
     "Lmfit provides a high-level interface to non-linear optimization and
curve fitting problems for Python.  It builds on and extends many of the
optimization methods of @code{scipy.optimize}.  Initially inspired by (and
named for) extending the Levenberg-Marquardt method from
@code{scipy.optimize.leastsq}, lmfit now provides a number of useful
enhancements to optimization and data fitting problems.")
    (license license:bsd-3)))

(define-public python-bokeh
  (package
    (name "python-bokeh")
    (version "3.7.3")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "bokeh" version))
              (sha256
               (base32
                "0argn4fadyswnz86x6fsy1f13nmd8iwzn5ddwrg3s43vg6grma3h"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; FIXME: Most of the tests do not work, figure out how to enable some
      ;; portion.
      #:tests? #f
      #:test-flags
      '(list
        ;; These require selenium.
        "--ignore=tests/unit/bokeh/io/test_export.py"
        "--ignore=tests/unit/bokeh/io/test_webdriver.py"
        "--ignore=tests/unit/bokeh/embed/test_standalone.py"

        ;; Doesn't find ManagedServerLoop fixture
        "--ignore=tests/unit/bokeh/test_client_server.py"

        ;; This fails because of the Guix wrapper around pytest
        "--ignore=tests/unit/bokeh/io/test_util__io.py"

        ;; Fixture ipython not found.
        "--ignore=tests/unit/bokeh/application/handlers/test_notebook__handlers.py"
        "--ignore=tests/unit/bokeh/command/subcommands/test_info.py"

        ;; pd fixture not found.
        "--ignore=tests/unit/bokeh/models/test_mappers.py"
        "--ignore=tests/unit/bokeh/models/util/test_structure.py"
        "--ignore=tests/unit/bokeh/plotting/test__plot.py"
        "--ignore=tests/unit/bokeh/plotting/test__graph.py"
        "--ignore=tests/unit/bokeh/plotting/test_figure.py"
        "--ignore=tests/unit/bokeh/core/test_json_encoder.py"
        "--ignore=tests/unit/bokeh/core/property/test_bases.py"
        "--ignore=tests/unit/bokeh/core/property/test_container.py"
        "--ignore=tests/unit/bokeh/core/property/test_dataspec.py"
        "--ignore=tests/unit/bokeh/core/property/test_datetime.py"
        "--ignore=tests/unit/bokeh/core/property/test_pandas.py"

        ;; nx fixture not found.
        "--ignore=tests/unit/bokeh/plotting/test_graph.py"
        "--ignore=tests/unit/bokeh/models/test_graphs.py"
        "--ignore=tests/unit/bokeh/io/test_showing.py"
        "--ignore=tests/unit/bokeh/document/test_events__document.py"

        ;; These tests need external sample data
        "--ignore-glob=tests/unit/bokeh/sampledata/*"

        ;; Attempts to install something via npm.
        "--ignore=tests/unit/bokeh/test_ext.py"

        ;; More failures due to set up problems.
        "--ignore=tests/unit/bokeh/server/test_server__server.py"
        "--ignore=tests/unit/bokeh/server/test_tornado__server.py"
        "--ignore=tests/unit/bokeh/util/test_serialization.py"
        "--ignore=tests/unit/bokeh/util/test_hex.py"
        "--ignore=tests/unit/bokeh/models/test_sources.py"
        "--ignore=tests/unit/bokeh/embed/test_bundle.py"

        "-k"
        (string-append
         ;; Fails with: 'called_once_with' is not a valid assertion. [...]
         ;; Did you mean: 'assert_called_once_with'?
         "not test_set_from_json"

         ;; XXX: This one test transforms a gif of a red box.  It transforms
         ;; it all right but the base64 doesn't look as expected, probably
         ;; because of a change in pillow.
         " and not test_transform_PIL"))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'set-version
            (lambda _
              (substitute* "pyproject.toml"
                ((", \"setuptools-git-versioning\"") "")
                (("dynamic = \\[\"version\"\\]")
                 (string-append "version = '" #$version "'"))))))))
    (propagated-inputs
     (list node-lts
           python-contourpy
           python-jinja2
           python-narwhals
           python-numpy
           python-packaging
           python-pandas
           python-pillow
           python-pyyaml
           python-tornado-6
           python-xyzservices))
    (native-inputs
     (list python-beautifulsoup4
           python-dateutil
           python-flaky
           python-mock
           python-nbconvert
           python-pandas
           python-pytest
           python-pytz
           python-requests
           python-setuptools
           python-wheel))
    (home-page "https://github.com/bokeh/bokeh")
    (synopsis "Interactive plots and applications in the browser from Python")
    (description
     "This package provides tools for interactive plots and applications in the
browser from Python.")
    (license license:bsd-3)))

(define-public python-botocore
  ;; Note: When updating botocore, also make sure that boto3 and awscli
  ;; are compatible.
  (package
    (name "python-botocore")
    (version "1.40.61")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "botocore" version))
       (sha256
        (base32
         "1kajxzrh4nq4hx7rgbam0sffx06d45q7rw2csv69q3q9kgb7lj52"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 4491 passed, 72 skipped
      #:test-flags
      #~(list "--numprocesses" (number->string (min (parallel-job-count) 8))
              ;; The full test suite is huge, run some of it's portion.
              "--ignore=tests/integration"
              "--ignore=tests/functional")))
    (native-inputs
     (list python-jsonschema
           python-pytest
           python-pytest-xdist
           python-setuptools))
    (propagated-inputs
     (list python-dateutil
           python-jmespath
           python-urllib3))
    (home-page "https://github.com/boto/botocore")
    (synopsis "Low-level interface to AWS")
    (description
     "Botocore is a Python library that provides a low-level interface to the
Amazon Web Services (AWS) API.")
    (license license:asl2.0)))

(define-public python-boto3
  (package
    (name "python-boto3")
    (version "1.40.61")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/boto/boto3")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0rjcs9grnrcak6w4l5plqcbwvknmg1k3q0xzg11kpp0sfiszbdph"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 1415 passed, 17 skipped, 1 warning
      #:test-flags
      #~(list "--numprocesses" (number->string (min 8 (parallel-job-count)))
              ;; Integration tests are trying to connect to AWS.
              "--ignore=tests/integration")))
    (native-inputs
     (list python-mock
           python-pytest
           python-pytest-xdist
           python-setuptools))
    (propagated-inputs
     (list python-botocore
           python-jmespath
           python-s3transfer))
    (home-page "https://github.com/boto/boto3")
    (synopsis "AWS SDK for Python")
    (description
     "Boto3 is a Python library for writing programs that interact with
@acronym{AWS,Amazon Web Services}.")
    (license license:asl2.0)))

(define-public python-pyfiglet
  (package
    (name "python-pyfiglet")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pwaller/pyfiglet")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1r1fyphz99jar2xfk761cl740zxk4b0gygajgjfx6i1kf0dxdv40"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fallback-on-default-build
            (lambda _
              ;; This pyproject has little value and fails because of the
              ;; :__legacy__ suffix.  Removing it to rely on defaults.
              (delete-file "pyproject.toml"))))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/pwaller/pyfiglet")
    (synopsis "Draw ASCII art big letters in Python")
    (description
     "This module lets you draw large letter from ordinary characters in pure
 Python.")
    (license license:expat)))

(define-public python-mako
  (package
    (name "python-mako")
    (version "1.3.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mako" version))
       (sha256
        (base32 "0a7ala6k7kn094k3g02b85xfkr20yk0w6a0acgjsfgsq75prlmwr"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-markupsafe))
    (home-page "https://www.makotemplates.org/")
    (synopsis "Templating language for Python")
    (description "Mako is a templating language for Python that compiles
templates into Python modules.")
    (license license:expat)))

(define-public python-cookiecutter
  (package
    (name "python-cookiecutter")
    (version "2.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cookiecutter" version))
       (sha256
        (base32 "0762882zrvf3sslr9r7v8wkdwjckhm2clj4d831gvx54kqbgh8fv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases #~(modify-phases %standard-phases
                   (add-before 'check 'pre-check
                     (lambda _
                       ;; test_get_user_config.py requires a writable home
                       ;; directory.
                       (setenv "HOME"
                               (getcwd))
                       ;; test_hooks.py dynamically creates shell scripts
                       ;; with a /bin/bash shebang. We have to patch these.
                       (substitute* "tests/test_hooks.py"
                         (("/bin/bash")
                          (string-append #$(this-package-native-input
                                            "bash-minimal") "/bin/bash"))))))))
    (native-inputs (list bash-minimal
                         git-minimal
                         python-freezegun
                         python-pytest
                         python-pytest-cov
                         python-pytest-mock
                         python-setuptools
                         python-wheel))
    (propagated-inputs (list python-arrow
                             python-binaryornot
                             python-click
                             python-jinja2
                             python-pyyaml
                             python-requests
                             python-rich
                             python-slugify))
    (home-page "https://github.com/cookiecutter/cookiecutter")
    (synopsis
     "Command-line utility that creates projects from project templates")
    (description
     "This package provides a command-line utility that creates projects from
project templates, e.g. creating a Python package project from a Python package
project template.")
    (license license:bsd-3)))

(define-public python-pyquery
  (package
    (name "python-pyquery")
    (version "2.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyquery" version))
       (sha256
        (base32
         "1brg6aawb9m5mdfmc6g7v5r6pczbx67r4l9cn5yh6bdi0qkvp501"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list #$@(map (lambda (test) (string-append
                                      "--deselect=tests/test_pyquery.py::"
                                      test))
                      (list
                       ;; AssertionError: 'REQUEST_METHOD: POST' not found in ''
                       "TestWebScrapping::test_post"
                       ;; AssertionError: 'HTTP_X_FOO: bar' not found in ''
                       "TestWebScrapping::test_session"
                       ;; Assertion is not equal.
                       "TestManipulating::test_val_for_textarea"
                       "TestHTMLParser::test_replaceWith"
                       "TestHTMLParser::test_replaceWith_with_function"
                       ;; Network access is required.
                       "TestWebScrapping::test_get"
                       "TestWebScrappingEncoding::test_get")))))
    (native-inputs
     (list python-pytest
           python-pytest-cov
           python-requests
           python-setuptools
           python-webob
           python-webtest
           python-wheel))
    (propagated-inputs
     (list python-cssselect python-lxml))
    (home-page "https://github.com/gawel/pyquery")
    (synopsis "Make jQuery-like queries on xml documents")
    (description "pyquery allows you to make jQuery queries on xml documents.
The API is as much as possible the similar to jQuery.  pyquery uses lxml for
fast xml and html manipulation.")
    (license license:bsd-3)))

(define-public python-amqp
  (package
    (name "python-amqp")
    (version "5.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "amqp" version))
       (sha256
        (base32 "1qmmffiy48nady7is8529vxcyqbq88v5zgawqr3fk4q8rkz166rc"))))
    (build-system pyproject-build-system)
    (arguments
     (list  ; Integration tests require network connectivity.
      #:test-flags '(list "--ignore=t/integration/test_rmq.py")))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (propagated-inputs (list python-vine))
    (home-page "https://github.com/celery/py-amqp")
    (synopsis "Low-level AMQP client for Python (fork of amqplib)")
    (description
     "This is a fork of amqplib which was originally written by Barry Pederson.
It is maintained by the Celery project, and used by kombu as a pure python
alternative when librabbitmq is not available.")
    (license license:lgpl2.1+)))

(define-public python-benchmark-4dn
  (package
    (name "python-benchmark-4dn")
    (version "0.5.24")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "benchmark_4dn" version))
              (sha256
               (base32
                "1cjin99p8mrh4nkbr4hsdfks9c22dfw3gk5ad80b4rxngs8mwj0s"))))
    (properties '(("upstream-name" . "benchmark_4dn")))
    (build-system pyproject-build-system)
    ;; There are none.
    (arguments (list #:tests? #false))
    (native-inputs
     (list python-poetry-core))
    (home-page "https://github.com/SooLee/Benchmark/")
    (synopsis "Benchmark functions for CWL workflows")
    (description
     "This package provides benchmark functions that return total space, memory,
CPUs required per given input size, and parameters for CWL workflows.")
    (license license:expat)))

(define-public python-beniget
  (package
    (name "python-beniget")
    (version "0.4.2.post1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "beniget" version))
       (sha256
        (base32 "1bjjl12pqbz4amnn8wvcpd4zjrx6cpw04s586gn18zjywqvqa9d0"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-gast))
    (home-page "https://github.com/serge-sans-paille/beniget")
    (synopsis "Extract semantic information about static Python code")
    (description
     "Beniget is a collection of analyzers for Python @acronym{AST,
Abstract Syntax Tree}.  It is a building block for writing a static analyzer
or compiler for Python.")
    (license license:bsd-3)))

(define-public python-kombu
  (package
    (name "python-kombu")
    (version "5.5.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/celery/kombu")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1fzpnwr3rhyf4fis1xmbdwlz40j9c09zpzzrchwxcvwsc6r45mcj"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; TODO: Package azure-identity (required for this file)
         "--ignore=t/unit/transport/test_azurestoragequeues.py"
         ;; XXX: Requires google-cloud-pubsub.
         "--ignore=t/unit/transport/test_gcpubsub.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* "requirements/default.txt"
                (("^tzdata.*")
                 "tzdata\n")))))))
    (native-inputs
     (list python-botocore
           python-pyro4
           python-pytest
           python-pytest-sugar
           python-setuptools
           python-tzdata))
    (propagated-inputs
     (list python-amqp python-typing-extensions python-vine))
    (home-page "https://kombu.readthedocs.io")
    (synopsis "Message passing library for Python")
    (description
     "The aim of Kombu is to make messaging in Python as easy as possible by
providing an idiomatic high-level interface for the AMQ protocol, and also
provide proven and tested solutions to common messaging problems.  AMQP is the
Advanced Message Queuing Protocol, an open standard protocol for message
orientation, queuing, routing, reliability and security, for which the
RabbitMQ messaging server is the most popular implementation.")
    (license license:bsd-3)))

(define-public python-billiard
  (package
    (name "python-billiard")
    (version "4.2.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/celery/billiard")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1p08w9msiajhg23ifcgnkv8jlbnh3ip3qhxahl5q0338sk4kah19"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'remove-win-files
            (lambda _
              (for-each delete-file-recursively
                        '("billiard/popen_spawn_win32.py"
                          "billiard/_win.py")))))))
    (native-inputs (list python-psutil python-pytest python-setuptools))
    (home-page "https://github.com/celery/billiard")
    (synopsis "Python multiprocessing fork with improvements and bugfixes")
    (description
     "Billiard is a fork of the Python 2.7 multiprocessing package.  The
multiprocessing package itself is a renamed and updated version of R Oudkerk's
pyprocessing package.  This standalone variant is intended to be compatible with
Python 2.4 and 2.5, and will draw its fixes/improvements from python-trunk.")
    (license license:bsd-3)))

(define-public python-celery
  (package
    (name "python-celery")
    (version "5.5.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "celery" version))
       (sha256
        (base32 "198hdgy2mk2h6nzhg78jqlhps0w4z6iw60bz4a0m4awcjvkjm5vc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; The MongoDB backend test appears to expect an older version of
      ;; MongoDB which provided its own bson module, fails with "
      ;; AttributeError: module 'bson' has no attribute 'encode'".
      #~(list "--ignore=t/unit/backends/test_mongodb.py"
              ;; XXX: Requires google-cloud-firestore
              "--ignore=t/unit/backends/test_gcs.py"
              ;; AssertionError.
              "-k" "not test_check_privileges_no_fchown")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* "requirements/default.txt"
                (("^tzdata.*")
                 "tzdata\n")))))))
    (native-inputs
     (list python-azure-core
           python-dnspython
           python-flaky
           python-gevent
           python-google-cloud-storage
           python-iniconfig
           python-moto
           python-msgpack
           python-pymongo
           python-pytest
           python-pytest-celery
           python-pytest-click
           python-pytest-subtests
           python-pytest-timeout
           python-redis
           python-setuptools))
    (propagated-inputs
     (list python-billiard
           python-click
           python-click-didyoumean
           python-click-plugins-1
           python-click-repl
           python-dateutil
           python-kombu
           python-tzdata
           python-vine))
    (home-page "https://celeryproject.org")
    (synopsis "Distributed Task Queue")
    (description
     "Celery is an asynchronous task queue/job queue based on distributed
message passing.  It is focused on real-time operation, but supports
scheduling as well.  The execution units, called tasks, are executed
concurrently on a single or more worker servers using multiprocessing,
Eventlet, or gevent.  Tasks can execute asynchronously (in the background) or
synchronously (wait until ready).")
    (license license:bsd-3)))

(define-public python-anyqt
  (package
    (name "python-anyqt")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ales-erjavec/anyqt")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0dci4sx53icd3jxv5gm22yr5g4dcyqbyvkkwliqpmbkxxjxj0dc8"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: Qt tests require Qt modules, see test/test_import.py.
      ;; TODO Add/configure the right Qt inputs.
      #:test-flags
      #~(list "--ignore-glob=tests/test_q*.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'delete-files
            ;; Delete files related to other operating systems.
            (lambda _
              (delete-file "AnyQt/QtMacExtras.py")
              (delete-file "AnyQt/QtWinExtras.py"))))))
    (native-inputs
     (list python-pyqt-6
           python-pytest
           python-pytest-qt
           python-setuptools))
    (home-page "https://github.com/ales-erjavec/anyqt")
    (synopsis "PyQt compatibility layer")
    (description
     "This package provides a PyQt/PySide compatibility layer. More precisely,
it provides compatibility for the following modules: PyQt4, PyQt5, PyQt6,
PySide, PySide2.")
    (license license:gpl3)))

(define-public python-qasync
  (package
    (name "python-qasync")
    (version "0.28.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/CabbageDevelopment/qasync/")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13i5riq7ig4csxlx61fzb8xl12ny0dkwj4h8f8r95xz5rii7a0kr"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:build-backend "poetry.core.masonry.api" ;XXX: python-uv-build is required
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'set-qpa
            (lambda _
              (setenv "QT_QPA_PLATFORM" "offscreen"))))))
    (native-inputs
     (list python-poetry-core python-pytest))
    (propagated-inputs
     (list python-pyqt-6))
    (home-page "https://github.com/CabbageDevelopment/qasync")
    (synopsis "Implementation of the PEP 3156 Event-Loop with Qt")
    (description
     "@code{qasync} allows coroutines to be used in PyQt/PySide applications
by providing an implementation of the PEP 3156 event-loop.")
    (license license:bsd-2)))

(define-public python-editor
  (package
    (name "python-editor")
    (version "1.0.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/fmoo/python-editor")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0hm5gcz5117dsq39bqfxpwazk4khqd272ran0n12x0x84mnqvfxa"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;XXX: needs a TTY and an editor
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/fmoo/python-editor")
    (synopsis "Programmatically open an editor, capture the result")
    (description
     "This package provides the editor module for programmatically interfacing
with your system's $EDITOR.")
    (license license:asl2.0)))

(define-public python-multiprocessing-logging
  (package
    (name "python-multiprocessing-logging")
    (version "0.3.4")
    (home-page "https://github.com/jruere/multiprocessing-logging")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url home-page)
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0ib1plsyi4g68n0crc2cqhk54fccsmcijzh66g89fd3lgababgxd"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (synopsis "Manage logs from multiple processes")
    (description
     "This Python module implements a multiprocessing-aware @code{Handler}
that, when set on the root @code{Logger}, will tunnel log records to the
main process so that they are handled correctly.")
    (license license:lgpl3+)))

(define-public python-munkres
  (package
    (name "python-munkres")
    (version "1.1.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "munkres" version))
       (sha256
        (base32 "00yvj8bxmhhhhd74v7j0x673is7vizmxwgb3dd5xmnkr74ybyi7w"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; See https://github.com/bmc/munkres/issues/40
      #:test-flags
      (if (member (%current-system) %32bit-supported-systems)
          #~(list "-k" "not test_profit_float")
          #~(list))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://software.clapper.org/munkres/")
    (synopsis "Implementation of the Munkres algorithm")
    (description
     "The Munkres module provides an implementation of the Munkres algorithm
(also called the Hungarian algorithm or the Kuhn-Munkres algorithm), useful
for solving the Assignment Problem.")
    (license license:bsd-3)))

(define-public python-codespell
  (package
    (name "python-codespell")
    (version "2.3.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "codespell" version))
        (sha256
          (base32 "07s72zfxkznigqdc23k7jp9saq0hgq0gf2kjmmxzcrayyw87s31n"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Drop test coverage requirements.
              (substitute* "pyproject.toml"
                (("\"--cov=codespell_lib\",") "")
                (("\"--cov-report=\",") "")))))))
    (native-inputs
      (list python-pygments
            python-pytest
            python-pytest-dependency
            python-tomli
            python-setuptools
            python-wheel))
    (propagated-inputs
      (list python-chardet))
    (home-page "https://github.com/codespell-project/codespell/")
    (synopsis "Spellchecker for code")
    (description
     "Codespell fixes common misspellings in text files.  It's designed
primarily for checking misspelled words in source code, but it can be used
with other files as well.  It does not check for word membership in a complete
dictionary, but instead looks for a set of common misspellings. Therefore it
should catch errors like \"adn\", but it will not catch \"adnasdfasdf\".  This
also means it shouldn't generate false-positives when you use a niche term it
doesn't know about.")
    (license
      (list
        ; for codespell and codespell_lib
        license:gpl2
        ; for dictionary*.txt
        license:cc-by-sa3.0))))

(define-public python-jellyfish
  (package
    (name "python-jellyfish")
    (version "0.8.8")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "jellyfish" version))
              (sha256
               (base32
                "0p2s6b30sfffx8sya2i8kz0i0riw9fq1fi0k89s8kdgrmjf0h1h5"))))
    (build-system python-build-system)
    (arguments
     `(#:tests? #f ; XXX: Tests cannot find C coded version.
       #:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key inputs outputs tests? #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "pytest" "-vv" "jellyfish/test.py")))))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/jamesturk/jellyfish")
    (synopsis "Approximate and phonetic matching of strings")
    (description "Jellyfish uses a variety of string comparison and phonetic
encoding algorithms to do fuzzy string matching.")
    (license license:bsd-2)))

(define-public python-pdfminer-six
  (package
    (name "python-pdfminer-six")
    (version "20240706")
    ;; There are no tests in the PyPI tarball.
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pdfminer/pdfminer.six")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vdwps38q2414lwjz266rabxrcw2a5s1pgxyjsffiifi010cd3k9"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               ;; Tests write to the source tree.
               (add-after 'unpack 'make-git-checkout-writable
                 (lambda _
                   (for-each make-file-writable (find-files ".")))))))
    (propagated-inputs
     (list python-charset-normalizer python-cryptography))
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/pdfminer/pdfminer.six")
    (synopsis "PDF parser and analyzer")
    (description "@code{pdfminer.six} is a community maintained fork of
the original PDFMiner.  It is a tool for extracting information from PDF
documents.  It focuses on getting and analyzing text data.  Pdfminer.six
extracts the text from a page directly from the sourcecode of the PDF.  It
can also be used to get the exact location, font or color of the text.")
    (license license:expat)))

(define-public python-rarfile
  (package
    (name "python-rarfile")
    (version "4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/markokr/rarfile")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1lm4vz4w0hrnzln7w10ijhdiwxy7gz45m44zw4fz7rdnn7c06b36"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ;The bsdtar utility is very limited and most tests fail.
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "rarfile.py"
                ;; Disable unrar and unar, which are unavailable on Guix.
                (("(unrar|unar)=True" all tool)
                 (string-append tool "=False"))
                ;; Hardcode path to bsdtar
                (("\"bsdtar\"")
                 (format #f "~s"
                         (search-input-file inputs "bin/bsdtar")))))))))
    (native-inputs (list python-pytest python-setuptools))
    (inputs (list libarchive))
    (home-page "https://github.com/markokr/rarfile")
    (synopsis "RAR archive reader for Python")
    (description
     "This is Python module for RAR archive reading.  The interface is made as
zipfile like as possible.")
    (license license:isc)))

(define-public python-slugid
  (package
    (name "python-slugid")
    (version "2.0.0")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/taskcluster/slugid.py")
              (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32 "1h64p2jlqv6lsmw8h2j203kx3bhv72cwzpk5gdhsaamw30cp3h1i"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'nose))
    (native-inputs (list python-pynose python-setuptools))
    (home-page "http://taskcluster.github.io/slugid.py")
    (synopsis "Module for Base64 encoded UUID v4 slugs")
    (description
     "This package provides a module for generating v4 UUIDs and encoding them
into 22 character URL-safe base64 slug representation.")
    (license license:mpl2.0)))

(define-public python-rich
  (package
    (name "python-rich")
    (version "13.7.1")
    (source
      (origin
        ;; There are no tests in the PyPI tarball.
        (method git-fetch)
        (uri (git-reference
              (url "https://github.com/willmcgugan/rich")
              (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0jvkcp473c0icbb8md3grc3285j2cy0z0swxgk2g67d9n0zfdfzc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; These fail for unknown reasons, but the results look identical.
      ;; Perhaps only the terminal escape sequences are superficially
      ;; different?
      '(list "-k" (string-append "not test_card_render"
                                 " and not test_markdown_render"
                                 " and not test_python_render"
                                 " and not test_python_render_simple"
                                 " and not test_python_render_simple_passing_lexer_instance"
                                 " and not test_python_render_indent_guides"
                                 " and not test_option_no_wrap"
                                 " and not test_syntax_highlight_ranges"
                                 " and not test_inline_code"
                                 " and not test_blank_lines"))))
    (propagated-inputs
     (list python-markdown-it-py python-pygments))
    (native-inputs
     (list python-poetry-core python-pytest))
    (home-page "https://github.com/willmcgugan/rich")
    (synopsis "Render rich text and more to the terminal")
    (description
     "This is a Python package for rendering rich text, tables, progress bars,
syntax highlighting, markdown and more to the terminal.")
    (license license:expat)))

(define-public python-rich-next
  (package
    (inherit python-rich)
    (name "python-rich")
    (version "14.2.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/willmcgugan/rich")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0zwjry4ylqncqvxrywp0km96jng4f288dgz8kz5vymk7nr2z21m1"))))
    (native-inputs (modify-inputs (package-native-inputs python-rich)
                     (append which)))))

(define-public python-rich-click
  (package
    (name "python-rich-click")
    (version "1.8.9")
     (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://github.com/ewels/rich-click")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32 "0kc2wcb5dpgxhdcz8fy6gfhl7vra03xwgwfg7h0qxxibr8yzhmmq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-click
           python-rich
           python-typing-extensions))
    (home-page "https://github.com/ewels/rich-click")
    (synopsis "Format click help output nicely with rich")
    (description "Click is a \"Python package for creating beautiful command
line interfaces\".  Rich is a \"Python library for rich text and beautiful
formatting in the terminal\".  The intention of rich-click is to provide
attractive help output from click, formatted with rich, with minimal
customization required.")
    (license license:expat)))

(define-public python-magic
  (package
    (name "python-magic")
    (version "0.4.27")
    (home-page "https://github.com/ahupp/python-magic")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference (url home-page) (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x11kfn4g244fia9a7y4ly8dqv5zsxfg3l5azc54dl6gkp2bk7vx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test/libmagic_test.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-tests
            (lambda _
              ;; Adjust expected output for file@5.45.
              (substitute* "test/libmagic_test.py"
                (("PDF document, version 1\\.2, 2 pages")
                 "PDF document, version 1.2, 2 page(s)"))))
          ;; Replace a specific method call with a hard-coded path to the
          ;; necessary libmagic.so file in the store.
          (add-before 'build 'hard-code-path-to-libmagic
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "magic/loader.py"
                (("find_library\\('magic'\\)")
                 (format #f "~s"
                         (search-input-file inputs "lib/libmagic.so")))))))))
    (native-inputs (list which python-setuptools))
    (inputs
     ;; python-magic needs to be able to find libmagic.so.
     (list file))
    (synopsis "File type identification using libmagic")
    (description
     "This module uses ctypes to access the libmagic file type identification
library.  It makes use of the local magic database and supports both textual
and MIME-type output.  Note that this module and the python-file module both
provide a \"magic.py\" file; these two modules, which are different and were
developed separately, both serve the same purpose: to provide Python bindings
for libmagic.")
    (license license:expat)))

(define-public python-securetar
  (package
    (name "python-securetar")
    (version "2025.1.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pvizeli/securetar")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1b9m29j4mjiv7925wrbiyj6vyx7m9qmdz40zqd4vgxhz4pq6x3xw"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel python-pytest))
    (propagated-inputs (list python-cryptography))
    (home-page "https://github.com/pvizeli/securetar")
    (synopsis "Python module to handle tarfile backups")
    (description
     "This library provides a streaming wrapper around python tarfile and allow
secure handling files and support encryption.")
    (license license:asl2.0)))

(define-public python-pkgconfig
  (package
    (name "python-pkgconfig")
    (version "1.5.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pkgconfig" version))
        (sha256
          (base32
            "16dqm2g7b2c6s09vf6wv62s629s63xf51n92v0hbax8zy4z1dd6y"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #false                   ;there are none
      #:phases
      '(modify-phases %standard-phases
         (add-before 'build 'patch
           ;; Hard-code the path to pkg-config.
           (lambda _
             (substitute* "pkgconfig/pkgconfig.py"
               (("'pkg-config'")
                (string-append "'" (which "pkg-config") "'"))))))))
    (native-inputs (list python-poetry-core))
    (inputs (list pkg-config))
    (home-page "https://github.com/matze/pkgconfig")
    (synopsis "Python interface for pkg-config")
    (description "This module provides a Python interface to pkg-config.  It
can be used to find all pkg-config packages, check if a package exists,
check if a package meets certain version requirements, query CFLAGS and
LDFLAGS and parse the output to build extensions with setup.py.")
    (license license:expat)))

;; This package is unmaintained since 2014, but still used in `khmer'.
(define-public python-bz2file
  (package
    (name "python-bz2file")
    (version "0.98")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bz2file" version))
       (sha256
        (base32 "126s53fkpx04f33a829yqqk8fj4png3qwg4m66cvlmhmwc8zihb4"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; Tests use deprecated python modules.
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/nvawda/bz2file")
    (synopsis "Read and write bzip2-compressed files")
    (description
     "Bz2file is a Python library for reading and writing bzip2-compressed
files.  It contains a drop-in replacement for the I/O interface in the
standard library's @code{bz2} module, including features from the latest
development version of CPython that are not available in older releases.")
    (license license:asl2.0)))

(define-public python-future
  (package
    (name "python-future")
    (version "1.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "future" version))
       (sha256
        (base32 "01bvq2a5vgxffq8555rvwhxw161m9y54z2j5w7d1x1h7jcq6hadx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Self tests failed.
      #~(list "--ignore=tests/test_future/test_futurize.py"
              "-k" (string-join
                    ;; Self tests failed.
                    (list "not test_division"
                          "test_functions_unchanged"
                          "test_mixed_annotations"
                          "test_multiple_param_annotations"
                          "test_print"
                          "test_range_slice"
                          ;; Network access is required.
                          "test_ftp"
                          "test_main"
                          "test_moves_urllib_request_http"
                          "test_urllib_request_http")
                    " and not "))))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://python-future.org")
    (synopsis "Single-source support for Python 3 and 2")
    (description
     "@code{python-future} is the missing compatibility layer between Python 2
and Python 3.  It allows you to use a single, clean Python 3.x-compatible
codebase to support both Python 2 and Python 3 with minimal overhead.")
    (license license:expat)))

(define-public python-cysignals
  (package
    (name "python-cysignals")
    (version "1.12.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cysignals" version))
       (sha256
        (base32 "1syixz6xlmy1pjcr03ij7hcvaklgjy4mmwggssrmmnr9pxnn5xw9"))))
    (build-system pyproject-build-system)
    (native-inputs (list meson-python
                         pkg-config
                         python-cython
                         python-pytest
                         python-sphinx))
    (home-page "https://github.com/sagemath/cysignals")
    (synopsis "Handling of interrupts and signals for Cython")
    (description
     "The cysignals package provides mechanisms to handle interrupts (and
other signals and errors) in Cython code, using two related approaches,
for mixed Cython/Python code or external C libraries and pure Cython code,
respectively.")
    (license license:lgpl3+)))

(define-public python-rope
  (package
    (name "python-rope")
    (version "1.13.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rope" version))
       (sha256
        (base32
         "1078mkzivz45my8x2y5gxisr0vba630xj7yxx7anr068xhnpshsi"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "test_version_hash_varies_on_get_file_content")))
    (propagated-inputs (list python-pytoolconfig))
    (native-inputs
     (list python-pytest python-pytest-timeout python-setuptools))
    (home-page "https://github.com/python-rope/rope")
    (synopsis "Refactoring library for Python")
    (description
     "Rope is a refactoring library for Python.  It facilitates the renaming,
moving and extracting of attributes, functions, modules, fields and parameters
in Python source code.  These refactorings can also be applied to occurrences
in strings and comments.")
    (license license:lgpl3+)))

(define-public python-py3status
  (package
    (name "python-py3status")
    (version "3.62")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ultrabug/py3status")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13ggwr35w5isylrg1n7akhycm18r03bxin95hdpcmqg7fvqyfppz"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'hardcode-file-path
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "py3status/parse_config.py"
                (("\\[\"file\", \"-b\"")
                 (format #f "[~s, \"-b\""
                         (search-input-file inputs "bin/file")))))))))
    (native-inputs (list python-hatchling python-pytest))
    (inputs (list file))
    (home-page "https://github.com/ultrabug/py3status")
    (synopsis "Extensible i3status wrapper written in Python")
    (description
     "py3status is an i3status wrapper which extends i3status functionality in
a modular way, allowing you to extend your panel with your own code,
responding to click events and updating clock every second.")
    (license license:bsd-3)))

(define-public python-greenlet
  (package
    (name "python-greenlet")
    (version "3.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "greenlet" version))
       (sha256
        (base32 "0rsla5f2vgc6g450fziprjy98vf2fwbz6zjx8x37kpvavdnarqsc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; AssertionError: 'Exception' not found in ''
      #:test-flags
      #~(list (string-join
               (list "--deselect=src/greenlet/tests/test_greenlet.py"
                     "TestGreenlet"
                     "test_dealloc_catches_GreenletExit_throws_other")
               "::"))
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'build-extensions
            (lambda _
              (invoke "python" "setup.py" "build_ext" "--inplace"))))))
    (native-inputs
     (list python-objgraph
           python-pytest
           python-psutil
           python-setuptools
           python-wheel))
    (home-page "https://greenlet.readthedocs.io/")
    (synopsis "Lightweight in-process concurrent programming")
    (description
     "Greenlet package is a spin-off of Stackless, a version of CPython
that supports micro-threads called \"tasklets\".  Tasklets run
pseudo-concurrently (typically in a single or a few OS-level threads) and
are synchronized with data exchanges on \"channels\".")
    (license (list license:psfl license:expat))))

(define-public python-greenlet-2
  (hidden-package
   (package
     (inherit python-greenlet)
     (version "2.0.2")
     (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "greenlet" version))
        (sha256
         (base32 "1h1l1mll5s4y1b09asf2jps0m7wyshnis1aassz9gc3xmw9xrj77")))))))

(define-public python-objgraph
  (package
    (name "python-objgraph")
    (version "3.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "objgraph" version))
       (sha256
        (base32 "1n0swlq11w36r2p6x7b4y0zz10dgzpdc8qasyk3y68kl1zsg5f80"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "tests.py"
              ;; AssertionError: [0, 1, 2] not found in [[], [], [], [], [],
              ;; [], [], [], [], [], [], [], ...
              "-k" "not test_at_addrs")))
    (native-inputs
     (list graphviz
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-graphviz))
    (home-page "https://mg.pov.lt/objgraph/")
    (synopsis "Draw Python object reference graphs with graphviz")
    (description
     "This package provides tools to draw Python object reference graphs with
graphviz.")
    (license license:expat)))

(define-public python-gevent
  (package
    (name "python-gevent")
    (version "24.11.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gevent" version))
              (sha256
               (base32
                "1jhs1k49nfhv59c0li6bcpvkr6pzmxkdgfm56gns7r792j8l3lcb"))
              (modules '((guix build utils)))
              (snippet
               '(begin
                  ;; unbunding libev and c-ares
                  (delete-file-recursively "deps")
                  ;; Remove cythonized files.
                  (with-directory-excursion "src/gevent"
                    (for-each delete-file
                              (append (list "resolver/cares.c"
                                            "queue.c"
                                            "local.c"
                                            "libev/corecext.h"
                                            "libev/corecext.c"
                                            "greenlet.c"
                                            "event.c"
                                            "_waiter.c"
                                            "_tracer.c"
                                            "_semaphore.c"
                                            "_imap.c"
                                            "_ident.c"
                                            "_hub_primitives.c"
                                            "_hub_local.c"
                                            "_greenlet_primitives.c"
                                            "_abstract_linkable.c")
                                      (find-files "." "\\.html$"))))))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list
        ;; These tests relies on networking which is
        ;; not available in the build container.
        "test__getaddrinfo_import.py"
        ;; These tests rely on KeyboardInterrupts which do not
        ;; work inside the build container for some reason
        ;; (lack of controlling terminal?).
        "test__issues461_471.py"
        ;; TODO: Patch out the tests that use getprotobyname, etc
        ;; instead of disabling all the tests from these files.
        "test__resolver_dnspython.py"
        ;; This test contains 'test_unlink', which
        ;; fails on i686 (see: https://github.com/gevent/gevent/issues/1558).
        "test__core_stat.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'patch-source-shebangs 'patch-hard-coded-paths
            (lambda _
              (substitute* "src/gevent/subprocess.py"
                (("/bin/sh") (which "sh")))
              (for-each (lambda (file)
                          (substitute* file
                            (("/bin/sh") (which "sh"))
                            (("/bin/true") (which "true"))))
                        (find-files "src/greentest" "\\.py$"))))
          (add-before 'build 'do-not-use-bundled-sources
            (lambda _
              (setenv "GEVENTSETUP_EMBED" "0")

              ;; Prevent building bundled libev.
              (substitute* "setup.py"
                (("run_make=_BUILDING")
                 "run_make=False"))))
          (add-before 'build 'augment-C_INCLUDE_PATH
            (lambda* (#:key inputs #:allow-other-keys)
              (let* ((python (dirname (dirname
                                       (search-input-file
                                        inputs "bin/python"))))
                     (version (python-version python))
                     (greenlet (string-append
                                #$(this-package-input "python-greenlet")
                                "/include/python" version)))
                (setenv "C_INCLUDE_PATH"
                        (string-append greenlet "/:"
                                       (or (getenv "C_INCLUDE_PATH")
                                           ""))))))
          (add-before 'check 'pretend-to-be-CI
            (lambda _
              ;; A few tests are skipped due to network constraints or
              ;; get longer timeouts when running in a CI environment.
              ;; Piggy-back on that, as we need the same adjustments.
              (setenv "TRAVIS" "1")
              (setenv "APPVEYOR" "1")))
          (add-before 'check 'adjust-tests
            (lambda*  (#:key test-flags #:allow-other-keys)
              (call-with-output-file "skipped_tests.txt"
                (lambda (port)
                  (format port "~a~%" (string-join test-flags "\n"))))))
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Use the build daemons configured number of workers.
                (setenv "NWORKERS" (number->string (parallel-job-count)))
                (invoke "python" "-m" "gevent.tests" "-unone" "--config"
                        "known_failures.py" "--ignore" "skipped_tests.txt")))))))
    (propagated-inputs
     (list python-greenlet python-zope-event python-zope-interface))
    (native-inputs
     (list python-cffi
           python-cython
           python-dnspython
           python-idna
           python-objgraph
           python-psutil
           python-requests
           python-setuptools))
    (inputs
     (list c-ares libev libuv))
    (home-page "https://www.gevent.org/")
    (synopsis "Coroutine-based network library")
    (description
     "@code{gevent} is a coroutine-based Python networking library that uses
@code{greenlet} to provide a high-level synchronous API on top of the
@code{libev} event loop.")
    (license license:expat)))

(define-public python-fastimport
  (package
    (name "python-fastimport")
    (version "0.9.16")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jelmer/python-fastimport")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pbnp9ffjs09ngva9qcizpscxl9s47rmd4dhxl62f5iwl6c46798"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/jelmer/python-fastimport")
    (synopsis "VCS fastimport parser and generator in Python")
    (description
     "This package provides a parser for and generator of the Git
@url{https://www.kernel.org/pub/software/scm/git/docs/git-fast-import.html,fastimport}
format.")
    (license license:gpl2+)))

(define-public python-pika
  (package
    (name "python-pika")
    (version "1.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pika/pika")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0bmp79lds26y2976xrpf53r3acqzpf3wpkprhlh3asqpfv5pwipb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; XXX: These test most likely require a running RabbitMQ server.
      #~(list "--ignore=tests/acceptance/blocking_adapter_test.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'configure-tests
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "PYTHONPATH" (getcwd))))))))
    (native-inputs (list python-pytest
                         python-gevent
                         python-tornado
                         python-twisted
                         python-setuptools))
    (home-page "https://pika.readthedocs.org")
    (synopsis "Pure Python AMQP Client Library")
    (description
     "Pika is a pure-Python implementation of the AMQP (Advanced Message Queuing
Protocol) 0-9-1 protocol that tries to stay fairly independent of the underlying
network support library.")
    (license license:bsd-3)))

;; WARNING: This package is a dependency of mesa.
(define-public python-ply
  (package
    (name "python-ply")
    (version "3.11")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "ply" version))
        (sha256
          (base32 "18qx113g9bi1ac4indd5phma82zcdq601lxncp3vjn43m2mc3iq0"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ;XXX: not tests in PyPI archvie, there are in Git
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "http://www.dabeaz.com/ply/")
    (synopsis "Python Lex & Yacc")
    (description "PLY is a @code{lex}/@code{yacc} implemented purely in Python.
It uses LR parsing and does extensive error checking.")
    (license license:bsd-3)))

(define-public python-kazoo
  (package
    (name "python-kazoo")
    (version "2.10.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/python-zk/kazoo")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ic1ky4v64jw59in02hqmyxskd98v32msd46pmsp39l7iighjrn2"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ; XXX: needs zookeeper
    (native-inputs (list python-setuptools))
    (home-page "https://kazoo.readthedocs.org")
    (synopsis "High-level Zookeeper client library")
    (description
     "Kazoo is a Python client library for the Apache Zookeeper distributed
application service.  It is designed to be easy to use and to avoid common
programming errors.")
    (license license:asl2.0)))

(define-public python-columnize
  (package
    (name "python-columnize")
    (version "0.3.11")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "columnize" version))
       (sha256
        (base32 "1clb3lfw694crq8m767q0yjaazkplcrbzdr9fr2w39hhndivhcd6"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/rocky/pycolumnize")
    (synopsis "Format a simple (i.e. not nested) list into aligned columns.")
    (description
     "This package provides a way to format a simple (i.e. not nested) list
into aligned columns.")
    (license license:expat)))

(define-public python-chai
  (package
    (name "python-chai")
    (version "1.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "chai" version))
       (sha256
        (base32 "1k6n6zbgrrs83crp6mr3yqj9zlv40b8rpisyrliwsq7naml2p3gz"))
       (patches (search-patches "python-chai-drop-python2.patch"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/agoragames/chai")
    (synopsis "Mocking framework for Python")
    (description
     "Chai provides an api for mocking, stubbing and spying your python
objects, patterned after the Mocha library for Ruby.")
    (license license:bsd-3)))

(define-public python-pysol-cards
  (package
    (name "python-pysol-cards")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pysol_cards" version))
       (sha256
        (base32 "0jsd7mqp0ak8zidg540b9hjncgx8diy9lv85zj6mi88sm0nlk1d9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key test-flags tests? #:allow-other-keys)
              (when tests?
                (apply invoke
                       "python"
                       "-m"
                       "unittest"
                       "discover"
                       "tests"
                       test-flags)))))))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/shlomif/pysol_cards")
    (synopsis "Deal PySol FC Cards")
    (description
     "The pysol-cards python modules provide code to generate the initial deals of
some PySol games.")
    (license license:expat)))

(define-public python-freecell-solver
  (package
    (name "python-freecell-solver")
    (version "0.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "freecell_solver" version))
       (sha256
        (base32 "0cq77dmq21laqk8fhl61m33lbckymzk312r263x2mv93mccf8jrm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key test-flags tests? #:allow-other-keys)
              (when tests?
                (apply invoke
                       "python"
                       "-m"
                       "unittest"
                       "discover"
                       "tests"
                       test-flags)))))))
    (propagated-inputs (list python-cffi))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://pypi.org/project/freecell-solver/")
    (synopsis "Freecell Solver bindings")
    (description
     "This package provides Python bindings for the freecell-solver
package.  Freecell Solver is a program that automatically solves layouts of
Freecell and similar variants of Card Solitaire such as Eight Off, Forecell,
and Seahaven Towers, as well as Simple Simon boards.")
    (license license:expat)))

(define-public python-inflect
  (package
    (name "python-inflect")
    (version "7.5.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "inflect" version))
              (sha256
               (base32
                "07spmlkmskwhxc0j5j4ms3w0f6pyv3h8iqwcbahdabklqc0riwgs"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-more-itertools python-typeguard
                             python-typing-extensions))
    (native-inputs (list python-pygments python-pytest python-setuptools
                         python-setuptools-scm python-wheel))
    (home-page "https://github.com/jaraco/inflect")
    (synopsis "Correctly generate plurals, singular nouns, ordinals, indefinite articles")
    (description
     "This Python module lets you correctly generate plurals, singular nouns,
ordinals, indefinite articles; it also can convert numbers to words.")
    (license license:expat)))

(define-public python-inflection
  (package
    (name "python-inflection")
    (version "0.5.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jpvanhal/inflection")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0mvs6wgpi963k7mqrwzdkh32m29zcm772q0fy7pwszlcsh3l50kg"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/jpvanhal/inflection")
    (synopsis "Python string transformation library")
    (description
     "Inflection is a string transformation library.  It singularizes
and pluralizes English words, and transforms strings from CamelCase to
underscored string.")
    (license license:expat)))

(define-public python-krb5
  (package
    (name "python-krb5")
    (version "0.5.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "krb5" version))
       (sha256
        (base32 "1jivws8dsscsmyqngbc71r4qw8qmn98pqmhylz01r5dd1ljfw9bi"))))
    (build-system pyproject-build-system)
    (inputs (list mit-krb5))
    (native-inputs (list python-cython python-k5test python-pytest
                         python-setuptools python-wheel))
    (home-page "https://github.com/jborean93/pykrb5")
    (synopsis "Kerberos API bindings for Python")
    (description "This library provides Python functions that wraps the
Kerberos 5 C API.")
    (license license:expat)))

(define-public python-pylev
  (package
    (name "python-pylev")
    (version "1.4.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/toastdriven/pylev")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0fgxjdnvnvavnxmxxd0fl5jyr2f31g3a26bwyxcpy56mgpd095c1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "tests.py")))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/toastdriven/pylev")
    (synopsis "Levenshtein distance implementation in Python")
    (description
     "Pure Python Levenshtein implementation, based off the Wikipedia code
samples at @url{http://en.wikipedia.org/wiki/Levenshtein_distance}.")
    (license license:bsd-3)))

(define-public python-cleo
  (package
    (name "python-cleo")
    (version "2.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "cleo" version))
              (sha256
               (base32
                "08ym7xaalxzka3k9wp7i05n6j9xmmjs1y02ilrz0lrhkbl5qhb0b"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-mock
           python-pytest-mock
           python-pytest))
    (propagated-inputs
     (list python-crashtest python-rapidfuzz))
    (home-page "https://github.com/sdispater/cleo")
    (synopsis "Command-line arguments library for Python")
    (description
     "Cleo allows you to create command-line commands with signature in
docstring and colored output.")
    (license license:expat)))

(define-public python-shellingham
  (package
    (name "python-shellingham")
    (version "1.5.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "shellingham" version))
       (sha256
        (base32 "1ph46hv920ha9clwxgrllbrphh0ww4v4pjmkbb9mnzj8kmrs1g4d"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-pytest-mock python-setuptools python-wheel))
    (home-page "https://github.com/sarugaku/shellingham")
    (synopsis "Tool to detect surrounding shell")
    (description
     "Shellingham detects what shell the current Python executable is
running in.")
    (license license:isc)))

(define-public python-shshsh
  (package
    (name "python-shshsh")
    (version "1.0.5")
    (source
     (origin
       (method git-fetch)
       (uri
        (git-reference
         (url "https://github.com/zqqqqz2000/shshsh")
         (commit
          "fd21c8696aebaae04507760c16cb45979291fef5")))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1wzqyj1a6jj6cyv5ymzy834qm2lyq80yy1kfz0q0zayq9gm1cj7f"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (home-page "https://github.com/zqqqqz2000/shshsh")
    (synopsis "Write Shell commands simply and safely within Python")
    (description "This package provides a way to write Shell commands from
within Python.  Python functions can be chained together to process input
Bash control characters are escapted so that parameters can be passed
without worrying about command injection.")
    (license license:expat)))

(define-public python-memcached
  (package
    (name "python-memcached")
    (version "1.62")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/linsomniac/python-memcached")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1chw36v1g4zz32s2qc2ql1hzrd1ys8d4abjdjnjgg8anpx13hjj2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f  ;Requires a connection to a socket.
      #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/linsomniac/python-memcached")
    (synopsis "Pure python memcached client")
    (description
     "This software is a pure Python interface to the memcached memory cache
daemon.  It is the client side software which allows storing values in one or
more, possibly remote, memcached servers.")
    (license license:psfl)))

(define-public python-mergedeep
  (package
    (name "python-mergedeep")
    (version "1.3.4")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/clarketm/mergedeep")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1msvvdzk33sxzgyvs4fs8dlsrsi7fjj038z83s0yw5h8m8d78469"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/clarketm/mergedeep")
    (synopsis "Deep merge function for Python")
    (description
     "This package provides a deep merge function for Python, useful to
combine multiple data objects as one.")
    (license license:expat)))

(define-public python-clikit
  (package
    (name "python-clikit")
    (version "0.6.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sdispater/clikit")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1l11iriqc61m30fp17yxwkgl5900kiw8x8vw2i93n1jh2lv182y4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* "pyproject.toml"
                (("^crashtest.*")
                 (format #f "crashtest=~s"
                         #$(package-version
                            (this-package-input "python-crashtest"))))))))))
    (native-inputs (list python-poetry-core python-pytest python-pytest-mock))
    (propagated-inputs (list python-crashtest python-pastel python-pylev))
    (home-page "https://github.com/sdispater/clikit")
    (synopsis "Group of utilities to build command line interfaces")
    (description
     "CliKit is a group of utilities to build testable command line
interfaces.")
    (license license:expat)))

(define-public python-cattrs
  (package
    (name "python-cattrs")
    (version "24.1.2")
    (source (origin
              (method git-fetch)        ;for tests
              (uri (git-reference
                    (url "https://github.com/python-attrs/cattrs")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0l806xs0insnvnd1c2l6f6bcaa7wgfrpvbbcyhhsvf2xy9mzq8rd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "--numprocesses" (number->string (parallel-job-count))
              ;; Skip all benchmark tests.
              "--ignore=bench/test_attrs_collections.py"
              "--ignore=bench/test_attrs_nested.py"
              "--ignore=bench/test_attrs_primitives.py"
              "--ignore=bench/test_primitives.py"
              "-k"
              (string-join
               ;; XXX: Tests fail with error: AssertionError: assert ...,
               ;; check why.
               (list "not test_msgspec_json_converter"
                     "test_structure_simple_from_dict_default"
                     "test_310_optional_field_roundtrip"
                     "test_310_union_field_roundtrip"
                     "test_individual_overrides"
                     "test_nested_roundtrip"
                     "test_nested_roundtrip_tuple"
                     "test_omit_default_roundtrip"
                     "test_optional_field_roundtrip"
                     "test_renaming"
                     ;; 'utf-8' codec can't encode character '\ud800' in
                     ;; position 0: surrogates not allowed
                     "test_simple_classes"
                     ;; This test fails with an assertion error on the build
                     ;; farm, but not on my laptop.
                     "test_nodefs_generated_unstructuring_cl"
                     ;; See https://github.com/python-attrs/cattrs/issues/575
                     "test_simple_roundtrip"
                     "test_simple_roundtrip_defaults"
                     "test_simple_roundtrip_defaults_tuple"
                     "test_simple_roundtrip_tuple"
                     "test_simple_roundtrip_with_extra_keys_forbidden"
                     "test_structure_simple_from_dict_default"
                     "test_union_field_roundtrip"
                     "test_unmodified_generated_structuring")
               " and not "))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-pyproject
            (lambda _
              (substitute* "pyproject.toml"
                ;; Fix version string
                (("dynamic = \\[\"version\"\\]")
                 (string-append "version = \"" #$version "\""))
                ;; Just run pytest with no frills
                (("addopts = \"-l.*") ""))))
          ;; XXX Our python-hypothesis package is too old.
          (add-after 'unpack 'compatibility
            (lambda _
              (substitute* "tests/typed.py"
                (("characters\\(codec=codec\\)")
                 "characters()")))))))
    (native-inputs
     (list python-hatchling
           python-hatch-vcs
           python-hypothesis
           python-immutables
           python-msgpack
           python-msgspec
           python-poetry-core
           python-pymongo               ;for the bson module
           python-pytest
           python-pytest-benchmark
           python-pytest-xdist))
    (propagated-inputs
     (list python-attrs
           python-cbor2
           python-exceptiongroup
           python-orjson
           python-pyyaml
           python-tomlkit
           python-typing-extensions
           python-ujson))
    (home-page "https://github.com/python-attrs/cattrs")
    (synopsis "Python library for structuring and unstructuring data")
    (description "@code{cattrs} is an Python library for structuring and
unstructuring data.  @code{cattrs} works best with @code{attrs} classes,
@code{dataclasses} and the usual Python collections, but other kinds of
classes can also be supported by manually registering converters.")
    (license license:expat)))

(define-public python-cachy
  (package
    (name "python-cachy")
    (version "0.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "cachy" version))
       (sha256
        (base32 "1cb9naly8ampzlky7h74n5wj628l7jkpsh0c0jz0namlrvs82r8q"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Make it compatible with python-flexmock 0.12.
                (substitute* (find-files "tests" "\\.py$")
                  (("from flexmock import flexmock, flexmock_teardown")
                   (string-append "from flexmock import flexmock\n"
                                  "from flexmock._api import flexmock_teardown")))
                (invoke "pifpaf" "run" "memcached" "--port" "11211" "--"
                        "pytest")))))))
    (native-inputs
     (list memcached
           python-fakeredis
           python-flexmock
           python-pifpaf
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-memcached
           python-msgpack
           python-redis))
    (home-page "https://github.com/sdispater/cachy")
    (synopsis "Simple yet effective caching library")
    (description
     "Cachy provides a simple yet effective caching library.  A simple but
powerful API: thread-safety; decorator syntax; support for memcached, redis,
database, file, dict stores.  Cachy supports python versions 2.7+ and 3.2+.")
    (license license:expat)))

(define-public python-pyproject-api
  (package
    (name "python-pyproject-api")
    (version "1.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyproject_api" version))
       (sha256
        (base32 "15l4fx1v4dqhhysxd2mcm1vn4qvrwbqmf6y2zkp36pgb5ygh9f3p"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      '(list "-k" (string-append
                   ;; This fails because of extraneous parentheses
                   "not test_setuptools_prepare_metadata_for_build_wheel"
                   ;; This fails because wheel shows up in requirements
                   " and not test_setuptools_get_requires_for_build_wheel"))))
    (native-inputs
     (list python-covdefaults
           python-hatch-vcs
           python-hatchling
           python-pytest
           python-pytest-cov
           python-pytest-mock
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-packaging python-tomli))
    (home-page "https://pyproject-api.readthedocs.io/latest/")
    (synopsis "API to interact with the Python pyproject.toml based projects")
    (description
     "@code{pyproject-api} aims to abstract away interaction with
@code{pyproject.toml} style projects in a flexible way.")
    (license license:expat)))

(define-public python-pyproject-hooks
  (package
    (name "python-pyproject-hooks")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyproject_hooks" version))
       (sha256
        (base32 "1y511nblr0lslz1d5s46844f5raryjnp3n1dci499bhgqkarp18y"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-pytest
           python-testpath))
    (home-page "https://github.com/pypa/pyproject-hooks")
    (synopsis "Low-level library for calling @file{pyproject.toml} backends")
    (description
     "@code{pyproject-hooks} is a low-level library for calling build backends
in @file{pyproject.toml}-based projects.  It provides basic functionality to
write tooling that generates distribution files from Python projects.")
    (license license:expat)))

(define-public python-lark
  (package
    (name "python-lark")
    (version "1.2.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lark" version))
       (sha256
        (base32 "107d1w24b3ln4zwsw4yvkfhff6bk5n3cpvlgbbqww5ndc80pv06a"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/lark-parser/lark")
    (synopsis "Multi-language parser for Python")
    (description
     "Lark is a parser built with a focus on ergonomics, performance and
resilience.  Lark can parse all context-free languages.  That means it is
capable of parsing almost any programming language out there, and to
some degree most natural languages too.")
    (license license:expat)))

(define-public python-find-libpython
  (package
    (name "python-find-libpython")
    (version "0.4.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ktbarrett/find_libpython")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "173qxif277vc23kgidwbkxx7z7b7676f8lv5kxy9pd82228m8m79"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-setuptools python-wheel
                         ;; tests
                         python-pytest))
    (home-page "https://github.com/ktbarrett/find_libpython")
    (synopsis "Find the path to the @code{libpython} dynamic library")
    (description
     "@code{find_libpython} helps find the path to the
@code{libpython} dynamic library for the current Python environment.  It is
both a script and a Python package.")
    (license license:expat)))

(define-public python-libcst
  (package
    (name "python-libcst")
    (version "1.6.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "libcst" version))
              (sha256
               (base32
                "1nzhvg52whpmfv8fkrnv7rlrmgc5m43hpyp8ra9kffx47yzcs3p8"))
              (snippet
               #~(begin (use-modules (guix build utils))
                        ;; This is mostly to keep the cargo-build-system happy
                        (with-output-to-file "Cargo.toml"
                          (lambda ()
                            (format #t "\
[workspace]

members = [
    \"native\",]")))))))
    (build-system cargo-build-system)
    (arguments
     (list
      #:install-source? #false
      #:cargo-test-flags
      ;; According to .github/workflows/ci.yml
      '(list "--manifest-path=native/Cargo.toml"
             "--release"
             "--no-default-features")
      #:imported-modules `(,@%pyproject-build-system-modules
                           ,@%cargo-build-system-modules)
      #:modules `((guix build cargo-build-system)
                  ((guix build pyproject-build-system) #:prefix py:)
                  (guix build utils))
      #:phases
      (with-extensions (list (pyproject-guile-json))
      #~(modify-phases %standard-phases
          (add-after 'unpack 'prepare-source
            (lambda _
              (delete-file "native/Cargo.lock")))
          (replace 'build
            (assoc-ref py:%standard-phases 'build))
          (add-after 'install 'wrap
            (lambda _
              ;; Collection of python- and pyproject-build-system phases
              ;; between 'install and 'check.
              (assoc-ref py:%standard-phases 'add-install-to-pythonpath)
              (assoc-ref py:%standard-phases 'add-install-to-path)
              (assoc-ref py:%standard-phases 'wrap)
              (assoc-ref py:%standard-phases 'create-entrypoints)
              (assoc-ref py:%standard-phases 'compile-bytecode)))
          ;; We are not the only ones who cannot load libcst.native
          ;; during the 'check phase
          ;; https://github.com/Instagram/LibCST/issues/1176
          ;; (add-after 'wrap 'python-check
          ;;  (lambda args
          ;;    (apply (assoc-ref py:%standard-phases 'check)
          ;;           #:test-flags '()
          ;;           args)))
          (replace 'install
            (assoc-ref py:%standard-phases 'install))))))
    (native-inputs
     (list python-minimal-wrapper
           python-hypothesmith
           python-pytest
           python-setuptools
           python-setuptools-rust
           python-setuptools-scm
           python-wheel))
    (inputs (cons maturin (cargo-inputs 'python-libcst)))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/Instagram/LibCST")
    (synopsis "Concrete Syntax Tree (CST) parser and serializer library for Python")
    (description
     "LibCST parses Python source code as a CST tree that keeps all
formatting details (comments, whitespaces, parentheses, etc).  It's useful
for building automated refactoring (codemod) applications and linters.
LibCST creates a compromise between an Abstract Syntax Tree (AST) and
a traditional Concrete Syntax Tree (CST).  By carefully reorganizing and
naming node types and fields, LibCST creates a lossless CST that looks and
feels like an AST.")
    (license (list license:expat
                   ;; Some files unde libcst/_parser/ are under Python Software
                   ;; Foundation license (see LICENSE file for details)
                   license:psfl
                   ;; libcst/_add_slots.py
                   license:asl2.0))))

(define-public python-libcst-minimal
  (hidden-package
   (package
     (inherit python-libcst)
     (name "python-libcst-minimal")
     (arguments
      (substitute-keyword-arguments (package-arguments python-libcst)
        ((#:tests? _ #t) #f)))
    (native-inputs
     (list python-minimal-wrapper
           python-setuptools
           python-setuptools-rust
           python-setuptools-scm
           python-wheel)))))

(define-public python-lazy-loader
  (package
    (name "python-lazy-loader")
    (version "0.4")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "lazy_loader" version))
              (sha256
               (base32
                "1lacaz292qxpgw6kxiirkx6sv9c5883nq4ssm3hs94cvb2153is7"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-numpy python-pytest python-setuptools))
    (propagated-inputs
     (list python-flit-core
           python-setuptools
           python-wheel))
    (home-page "https://scientific-python.org/specs/spec-0001/")
    (synopsis "Load subpackages and functions on demand")
    (description "@code{python-lazy-loader} makes it easy to load subpackages
and functions on demand.  Its main features are:

@itemize
@item Allow subpackages to be made visible to users without incurring import
costs.
@item Allow external libraries to be imported only when used, improving import
times.
@end itemize")
    (license license:bsd-3)))

(define-public python-lazy-object-proxy
  (package
    (name "python-lazy-object-proxy")
    (version "1.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "lazy_object_proxy" version))
       (sha256
        (base32 "174fswfrsqr7yj72f8fyry34qxgagbfw37vzljxbp7schq8l91qq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-benchmark
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/ionelmc/python-lazy-object-proxy")
    (synopsis "Lazy object proxy for Python")
    (description
     "Lazy object proxy is an object that wraps a callable but defers the call
until the object is actually required, and caches the result of said call.")
    (license license:bsd-2)))

(define-public python-dnspython
  (package
    (name "python-dnspython")
    (version "2.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dnspython" version))
       (sha256
        (base32 "1wgsbiz90npdi47cilmwdccm29hl9qddzkm533v1rj8dv8p4776f"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list
         ;; AssertionError: assert False
         "--deselect=tests/test_features.py::test_have"
         ;; dns.exception.SyntaxError: protocol not found
         "--deselect=tests/test_rdata.py::RdataTestCase::test_misc_good_WKS_text"
         ;; ECDSA with deterministic signature (RFC 6979) is not supported by
         ;; this version of OpenSSL.
         "-k" (string-append "not testDeterministicSignatureECDSAP256SHA256"
                             " and not testSignatureECDSAP256SHA256"
                             " and not testSignatureECDSAP384SHA384"
                             " and not test_ecdsa"))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-getprotobyname-calls
            ;; These calls are problematic in the build environment as there is
            ;; no /etc/protocols.  This breaks the sanity-check phase of any
            ;; package depending on this one.
            (lambda _
              (substitute* "dns/rdtypes/IN/WKS.py"
                (("socket.getprotobyname\\('tcp'\\)")
                 "6")
                (("socket.getprotobyname\\('udp'\\)")
                 "17")))))))
    (native-inputs
     (list python-hatchling
           python-pytest))
    (propagated-inputs
     (append
       (if (supported-package? python-cryptography)
           (list ;; DNSSEC
                 python-cryptography
                 ;; DNS over Quic
                 python-aioquic
                 ;; DNS over HTTPS
                 python-h2
                 python-httpcore
                 python-httpx)
           '())
       (list python-idna
             python-trio)))
    (home-page "https://www.dnspython.org")
    (synopsis "DNS toolkit for Python")
    (description
     "dnspython is a DNS toolkit for Python.  It supports almost all record
types.  It can be used for queries, zone transfers, and dynamic updates.
It supports TSIG authenticated messages and EDNS0.")
    (license license:expat)))

(define-public python-dnspython-1.16
  (package
    (inherit python-dnspython)
    (version "1.16.0")
    (source (origin
              (method url-fetch)
              (uri (string-append "http://www.dnspython.org/kits/"
                                  version "/dnspython-" version ".tar.gz"))
              (sha256
               (base32
                "1yaw7irazy42n0kdhlk7wyg8ki34rxcnc5xbc1wfwy245b0wbxab"))))
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'compatibility
            (lambda _
              (substitute* "dns/namedict.py"
                (("collections.MutableMapping")
                 "collections.abc.MutableMapping"))))
          (add-after 'unpack 'patch-getprotobyname-calls
            ;; These calls are problematic in the build environment as there is
            ;; no /etc/protocols.  This breaks the sanity-check phase of any
            ;; package depending on this one.
            (lambda _
              (substitute* "dns/rdtypes/IN/WKS.py"
                (("socket.getprotobyname\\('tcp'\\)")
                 "6")
                (("socket.getprotobyname\\('udp'\\)")
                 "17")))))))
    (native-inputs (list python-pytest python-setuptools python-wheel))))

(define-public python-py3dns
  (package
    (name "python-py3dns")
    (version "4.0.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "py3dns" version))
        (sha256
         (base32 "0fcac412kh34r3gxvn7dc1srmjii2qs6n3lgyxh3q57cxj02wrcq"))))
    (build-system pyproject-build-system)
    (arguments
     ;; This package wants to read /etc/resolv.conf. We can't patch it without
     ;; removing functionality so we don't run tests.
     (list #:tests? #f))
    (native-inputs (list python-flit-core))
    (home-page "https://launchpad.net/py3dns")
    (synopsis "Python 3 DNS library")
    (description
     "This Python 3 module provides a DNS API for looking up DNS entries from
within Python 3 modules and applications.  This module is a simple,
lightweight implementation.")
    (license license:psfl)))

(define-public python-email-validator
  (package
    (name "python-email-validator")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "email_validator" version))
       (sha256
        (base32 "1dw28lv9lpsw2s7dylhih93fn72s8iqyfsp6497p2yk19hs0ysfb"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; dns.resolver.NoResolverConfiguration: cannot open /etc/resolv.conf
      #~(list "-k" "not test_caching_dns_resolver")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-dnspython
           python-idna))
    (home-page "https://github.com/JoshData/python-email-validator")
    (synopsis "Email address validation library for Python")
    (description
     "This library validates email address syntax and deliverability.")
    (license license:cc0)))

(define-public python-faker
  (package
    (name "python-faker")
    (version "37.4.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "faker" version))
       (sha256
        (base32 "02kbql0mgjh98ilz5crxlkrsl9qdqlfa5gmqjn46br9hxax1na4f"))))
    (build-system pyproject-build-system)
    ;; tests: 2104 passed, 12 skipped, 2 warnings
    (native-inputs
     (list python-freezegun
           python-pytest
           python-setuptools
           python-ukpostcodeparser
           python-validators))
    (propagated-inputs
     (list python-tzdata))
    (home-page "https://github.com/joke2k/faker")
    (synopsis "Python package that generates fake data")
    (description
     "Faker is a Python package that generates fake data such as names,
addresses, and phone numbers.")
    (license license:expat)))

(define-public python-pyaml
  (package
    (name "python-pyaml")
    (version "25.7.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyaml" version))
       (sha256
        (base32 "16yrflm7iyz82igpzlba16cbvwfwny2fnarf14mvz0b8q57ac4z1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-pyyaml))
    (home-page "https://github.com/mk-fg/pretty-yaml")
    (synopsis "YAML pretty-print library for Python")
    (description
     "pyaml is a PyYAML based python module to produce pretty and readable
YAML-serialized data.")
    (license license:wtfpl2)))

(define-public python-pyyaml-env-tag
  (package
    (name "python-pyyaml-env-tag")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/waylan/pyyaml-env-tag")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16zkwmnlzzsdlxs9ww3b51mcarni2ykmi0v7752l7j4najxw875n"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-pyyaml))
    (home-page "https://github.com/waylan/pyyaml-env-tag")
    (synopsis "Custom YAML tag for environment variables")
    (description
     "This package provides a custom YAML tag for referencing environment
variables in YAML files.")
    (license license:expat)))

(define-public python-prompt-toolkit
  (package
    (name "python-prompt-toolkit")
    (version "3.0.51")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "prompt_toolkit" version))
       (sha256
        (base32 "1valgcf324yy0sf7rrbm2ivc4a65n8gvnj0vdz491z177cp1c6lk"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'pre-check
            (lambda _
              ;; HOME is needed for the test
              ;; "test_pathcompleter_can_expanduser".
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-wcwidth))
    (home-page "https://github.com/prompt-toolkit/python-prompt-toolkit")
    (synopsis "Library for building command line interfaces in Python")
    (description
     "Prompt-Toolkit is a library for building interactive command line
interfaces in Python.  It's like GNU Readline but it also features syntax
highlighting while typing, out-of-the-box multi-line input editing, advanced
code completion, incremental search, support for Chinese double-width
characters, mouse support, and auto suggestions.")
    (license license:bsd-3)))

(define-public python-proselint
  (package
    (name "python-proselint")
    (version "0.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "proselint" version))
       (sha256
        (base32 "11hfd207bhsvb0iznlnbr0w7jxihvn3ismpjbmz7c57a5ckn8jb2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-home-directory
            (lambda _
              (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (propagated-inputs
     (list python-click))
    (home-page "http://proselint.com/")
    (synopsis "Linter for prose")
    (description "@code{python-proselint} is a linter for English prose, that
scans through a file and detects issues.")
    (license license:bsd-3)))

(define-public python-jedi
  (package
    (name "python-jedi")
    (version "0.19.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/davidhalter/jedi")
             (commit (string-append "v" version))
             (recursive? #true)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "0w8rrw6s4bzr5csds8bhasrmzh9q77zh5dzisjysl8cb5qjx0w6s"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'set-HOME
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs
     (list python-docopt
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-parso))
    (home-page "https://github.com/davidhalter/jedi")
    (synopsis "Autocompletion and static analysis library for Python")
    (description
     "Jedi is a static analysis tool for Python that can be used in Integrated
Development Environments (@dfn{IDE}s) and text editors.  It understands Python
on a deeper level than many other static analysis frameworks for Python.

Jedi understands docstrings and you can use Jedi autocompletion in your REPL
as well.")
    (license license:expat)))

(define-public ptpython
  (package
    (name "ptpython")
    (version "3.0.20")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jonathanslenders/ptpython")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qbj7d4qkzl8l05kpmm19953lmqk379i17ab8g3sfnmfpsy3ji5m"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; XXX: There is a tests/run_tests.py file but all it does is a
      ;; sanity check.
      #:tests? #f))
    (native-inputs (list python-setuptools))
    (propagated-inputs
     (list python-appdirs python-jedi python-prompt-toolkit python-pygments))
    (home-page "https://github.com/jonathanslenders/ptpython")
    (synopsis "Python Read-Eval-Print-Loop with nice IDE-like features")
    (description
     "ptpython is a Python read-eval-print loop with IDE-like features.
It supports syntax highlighting, multiline editing, autocompletion, mouse,
color schemes, bracketed paste, Vi and Emacs keybindings, Chinese characters
etc.")
    (license license:bsd-3)))

(define-public python-easyprocess
  (package
    (name "python-easyprocess")
    (version "1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ponty/easyprocess")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1dysr0z2mijhxl4z86wxf4w94sszdm4i2w3id0a6qwyid6xqjksp"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Tests require pyvirtualdisplay, which requires this package.
     (list #:tests? #f))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/ponty/easyprocess")
    (synopsis "Python subprocess interface")
    (description
     "@code{easyprocess} is an easy to use Python subprocess interface.")
    (license license:bsd-3)))

(define-public python-entrypoint2
  (package
    (name "python-entrypoint2")
    (version "0.2.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "entrypoint2" version))
       (sha256
        (base32 "1qyxq54r2fbh09ab5sffbxajy8arbk6czxz5lq3ccr9qrypw6w27"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-easyprocess python-pytest python-pytest-runner
                         python-setuptools python-wheel))
    (home-page "https://github.com/ponty/entrypoint2")
    (synopsis "Command-line interface for Python modules")
    (description
     "@code{entrypoint2} is an easy to use command-line interface for Python
     modules based on @code{argparse}.  It translates function signature and
     documentation to argparse configuration.")
    (license license:bsd-3)))

(define-public python-pyvirtualdisplay
  (package
    (name "python-pyvirtualdisplay")
    (version "3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PyVirtualDisplay" version))
       (sha256
        (base32 "0nb1s7nilakrkcm0vq08pz9mh8rzyhjm9jkyn1gp5sxnrv1mnx89"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 27 passed, 8 deselected
      #:test-flags
      ;; TODO: Add libxcb to python-pillow on the next python-team cycle.
      ;; OSError: Pillow was built without XCB support
      #~(list #$@(map (lambda (test) (string-append "--deselect="
                                                    "tests/"
                                                    test))
                      (list "test_smart.py::test_slowshot"
                            "test_smart.py::test_slowshot_with"
                            "test_smart.py::test_slowshot_nocrop"
                            "test_smart.py::test_slowshot_timeout"
                            "test_smart.py::test_slowshot_timeout_nocrop"
                            "test_smart2.py::test_double"
                            "test_smart_thread.py::test_smart"
                            "test_examples.py::test_screenshot")))))
    (native-inputs
     (list python-easyprocess
           python-entrypoint2
           python-psutil
           python-pytest
           python-setuptools
           python-vncdotool-bootstrap
           xmessage
           xorg-server-for-tests))
    (home-page "https://github.com/ponty/pyvirtualdisplay")
    (synopsis "Python wrapper for Xvfb, Xephyr and Xvnc")
    (description
     "@code{pyvirtualdisplay} is a Python wrapper for Xvfb, Xephyr and Xvnc.")
    (license license:bsd-3)))

(define-public python-pyserial
  (package
    (name "python-pyserial")
    (version "3.5")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "pyserial" version))
        (sha256
          (base32
            "1nyd4m4mnrz8scbfqn4zpq8gnbl4x42w5zz62vcgpzqd2waf0xrw"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/pyserial/pyserial")
    (synopsis "Python Serial Port Bindings")
    (description
     "@code{pyserial} provide serial port bindings for Python.  It supports
different byte sizes, stop bits, parity and flow control with RTS/CTS and/or
Xon/Xoff.  The port is accessed in RAW mode.")
    (license license:bsd-3)))

(define-public python-pyserial-asyncio
  (package
    (name "python-pyserial-asyncio")
    (version "0.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/pyserial/pyserial-asyncio")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0c8kzy2a4awsh580qrniwq0vyydlsvicjw79r270sqflxmjlns6n"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-pyserial))
    (home-page "https://github.com/pyserial/pyserial-asyncio")
    (synopsis "Pyserial asynchronous I/O extension")
    (description
     "This package extends Pyserial with asynchronous I/O support.")
    (license license:bsd-3)))

(define-public python-pymemcache
  (package
    (name "python-pymemcache")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymemcache" version))
       (sha256
        (base32 "157z9blr8pjg9x84jph5hm0z2l6yaq6n421jcf1hzqn1pg8rpgr7"))))
    (build-system pyproject-build-system)
    (arguments
     ;; We don't have the zstd module.
     (list
      #:test-flags
      '(list "--ignore=pymemcache/test/test_compression.py")))
    (native-inputs
     (list python-faker python-pytest python-pytest-cov python-setuptools
           python-wheel))
    (home-page "https://github.com/pinterest/pymemcache")
    (synopsis "Comprehensive, fast, pure Python memcached client")
    (description
     "This package provides a comprehensive, fast, pure Python memcached
client.")
    (license license:asl2.0)))

(define-public python-pymodbus
  (package
    (name "python-pymodbus")
    (version "3.8.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/riptideio/pymodbus")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1sncllh01c6vqq4fh9k3yg9fchmmw661rcp0066l7fis6sp4yw82"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore"
              "test/server/test_simulator_api.py"
              ;; These tests require the presence of a certificate.
              "--ignore-glob"
              "test/examples/*"
              "--ignore"
              "test/client/test_client.py")))
    (native-inputs (list python-mock
                         python-pytest
                         python-pytest-asyncio
                         python-pytest-cov
                         python-pytest-xdist
                         python-redis
                         python-setuptools
                         python-sqlalchemy
                         python-tornado
                         python-twisted
                         python-wheel))
    (propagated-inputs (list python-pyserial
                             python-six
                             ;; For the REPL.
                             python-aiohttp
                             python-click
                             python-prompt-toolkit
                             python-pygments
                             python-pyserial-asyncio))
    (home-page "https://github.com/riptideio/pymodbus/")
    (synopsis "Modbus protocol stack in Python")
    (description
     "Pymodbus is a full Modbus protocol implementation using
     @code{asyncio}, @code{tornado} or @code{twisted} for its asynchronous
     communications core.  It includes the following @emph{client} features:
     @itemize
     @item full read/write protocol on discrete and register
     @item most of the extended protocol (diagnostic/file/pipe/setting/information)
     @item TCP, UDP, Serial ASCII, Serial RTU, and Serial Binary
     @item asynchronous and synchronous versions
     @item payload builder/decoder utilities
     @item pymodbus read eval print loop (REPL).
     @end itemize
     It also includes the following @emph{server} features:
     @itemize
     @item can function as a fully implemented Modbus server
     @item TCP, UDP, Serial ASCII, Serial RTU, and Serial Binary
     @item asynchronous and synchronous versions
     @item full server control context (device information, counters, etc)
     @item a number of backing contexts (database, redis, sqlite, a slave device).
     @end itemize")
    (license license:bsd-3)))

(define-public python-exodriver
  (package
    (name "python-exodriver")
    (version "2.6.0")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/labjack/exodriver")
                    (commit (string-append "v" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "1ikjz8147p14s814yabdq821y691klnr2yg54zgsymcc97kvwp2q"))))
    (outputs (list "out"
                   "doc"))              ;544 KiB of examples
    (build-system gnu-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:make-flags #~(list (string-append "CC=" #$(cc-for-target))
                           (string-append "PREFIX=" #$output)
                           "RUN_LDCONFIG=0"
                           "LINK_SO=1")
      #:phases
      #~(modify-phases %standard-phases
          (delete 'configure)
          (replace 'build
            (lambda* (#:key make-flags #:allow-other-keys #:rest args)
              (with-directory-excursion "liblabjackusb"
                (apply (assoc-ref %standard-phases 'build)
                       `(,@args #:make-flags ,make-flags)))))
          (replace 'install
            (lambda* (#:key make-flags #:allow-other-keys #:rest args)
              (with-directory-excursion "liblabjackusb"
                (apply (assoc-ref %standard-phases 'install)
                       `(,@args #:make-flags ,make-flags)))
              ;; Install udev rules.
              (install-file "90-labjack.rules"
                            (string-append #$output "/lib/udev/rules.d"))
              ;; Install examples.
              (let ((doc (string-append #$output:doc "/share/doc/" #$name)))
                (mkdir-p doc)
                (copy-recursively "examples"
                                  (string-append doc "/examples"))))))))
    (inputs (list libusb))
    (home-page "https://github.com/labjack/exodriver")
    (synopsis "USB driver for LabJack data acquisition instruments")
    (description "This package provides @code{liblabjackusb}, a USB library for low-level
communication with the U3, U6, UE9, Digit, T4 and T7 LabJack data acquisition
instruments.  A udev rule is also included to allow unprivileged users to
communicate with the instruments via USB.")
    (license license:expat)))           ;see README

(define-public python-labjack
  (package
    (name "python-labjack")
    (version "2.1.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "LabJackPython" version))
              (sha256
               (base32
                "0q516y0gzxlk298whiaw0qdi4jcmx7l5y3mp5g5lj68nrvhqzyy4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f                       ;no test suite
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-liblabjackusb.so
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* (find-files "." "\\.py$")
                (("ctypes.CDLL\\(\"liblabjackusb.so\"")
                 (format #f "ctypes.CDLL(~s"
                         (search-input-file inputs
                                            "lib/liblabjackusb.so")))))))))
    (native-inputs (list python-setuptools))
    ;; exodriver is provided as a regular input, as only its shared object is
    ;; used, not its Python API.
    (inputs (list python-exodriver))
    (home-page "https://labjack.com/support/software/examples/ud/labjackpython")
    (synopsis "Python library for LabJack U3, U6, UE9 and U12")
    (description
     "This Python library allows communicating with the U3, U6, UE9 and U12
LabJack data acquisition (DAQ) modules.")
    (license license:expat)))          ;see setup.py

(define-public python-kivy-garden
  (package
    (name "python-kivy-garden")
    (version "0.1.5")
    (source
     (origin
       (method git-fetch)  ; source was removed from PyPI
       (uri (git-reference
             (url "https://github.com/kivy-garden/garden")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1pvjblaljrcmjkq6hsa89zkh9ggdval58d2lwzd69vlma8y03qy4"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests in PyPI or Git distributions
    (native-inputs
     (list python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-requests))
    (home-page "https://github.com/kivy-garden/garden")
    (synopsis "Garden tool for Kivy flowers")
    (description
     "This package provides the @command{garden} command to install packages
for Kivy, the multitouch application platform.")
    (license license:expat)))

(define-public python-async-lru
  (package
    (name "python-async-lru")
    (version "2.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "async-lru" version))
       (sha256
        (base32 "09sn3bc3gc2flijm9k8kn4hmbnlkaddhqahb49izy188yrfrm9dq"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-pytest-asyncio
           python-pytest-cov
           python-pytest-timeout
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-typing-extensions))
    (home-page "https://github.com/aio-libs/async-lru")
    (synopsis "Simple LRU cache for asyncio")
    (description
     "This package is a port of Python's built-in @code{functools.lru_cache}
function for @code{asyncio}.  To better handle async behaviour, it also
ensures multiple concurrent calls will only result in 1 call to the wrapped
function, with all awaits receiving the result of that call when it
completes.")
    (license license:expat)))

(define-public python-asyncinject
  (package
    (name "python-asyncinject")
    (version "0.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "asyncinject" version))
       (sha256
        (base32 "0x57idiy19lzyn32klgm06r223z8gr2aqqk91gysbshq7jg8g3pf"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-pytest-asyncio
                         python-setuptools python-wheel))
    (home-page "https://github.com/simonw/asyncinject")
    (synopsis
     "Run async workflows using pytest-fixtures-style dependency injection")
    (description
     "This package lets you run asynchronous workflows using
pytest-fixtures-style dependency injection.")
    (license license:asl2.0)))

(define-public python-binaryornot
  (package
    (name "python-binaryornot")
    (version "0.4.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "binaryornot" version))
       (sha256
        (base32 "0qc006986rb6bcbmiymwgcl1mns2jphr1j7sr7nk41nlr7gh359m"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags #~(list "discover" "tests")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-tests
            (lambda _
              ;; TypeError: binary() got an unexpected keyword argument
              ;; 'average_size'.
              (substitute* "tests/test_check.py"
                (("average_size=512") "")))))))
    (native-inputs
     (list python-hypothesis
           python-setuptools))
    (propagated-inputs
     (list python-chardet))
    (home-page "https://github.com/audreyr/binaryornot")
    (synopsis "Package to check if a file is binary or text")
    (description "Ultra-lightweight pure Python package to check if a file is
     binary or text.")
    (license license:bsd-3)))

(define-public python-bson
  (package
    (name "python-bson")
    (version "0.5.10")
    (source
     (origin
       (method git-fetch)               ;for tests
       (uri (git-reference
             (url "https://github.com/py-bson/bson")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32
         "1vpy4rsvm3hhawvbg9rbw4j36ck8qylkhm8cjy0q6imvinkd2als"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-dateutil
           python-six))
    (home-page "https://github.com/py-bson/bson")
    (synopsis "BSON (Binary JSON) codec for Python")
    (description "@code{bson} is a Python library implementing a BSON (Binary
JSON) codec.")
    (license license:asl2.0)))

(define-public python-nltk
  (package
    (name "python-nltk")
    (version "3.9.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "nltk" version))
       (sha256
        (base32 "0s78gayd45vl1wvpa0a44ydij6ybb7xfar8jz2j8kgg47nyjglc7"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Tests require some extra resources to be downloaded.
     ;; TODO Try packaging these resources.
     '(#:tests? #f))
    (propagated-inputs (list python-click python-joblib python-regex
                             python-tqdm))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://www.nltk.org/")
    (synopsis "Natural Language Toolkit")
    (description
     "NLTK provides interfaces to over 50 corpora and lexical resources such as
WordNet, along with a suite of text processing libraries for classification,
tokenization, stemming, tagging, parsing, and semantic reasoning, wrappers for
natural language processing libraries.")
    (license license:asl2.0)))

(define-public python-pymongo
  (package
    (name "python-pymongo")
    (version "4.14.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pymongo" version))
       (sha256
        (base32 "1ld18zyh4f6zxwswsc018d48lq7imf85zrf49w9wyy6fvlzlwrqm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; tests: 1274 passed, 6231 skipped, 1441 deselected, 2 warnings
      #:test-flags
      ;; Tests need access to /etc/resolve.conf.
      #~(list "--ignore=test/asynchronous/test_srv_polling.py"
              "--ignore=test/test_srv_polling.py"
              "-k" (string-join
                    ;; Tests need access to /etc/resolve.conf
                    (list "not test_connection_timeout_ms_propagates_to_DNS_resolver"
                          "test_detected_environment_warning"
                          ;; XXX: Tests fail with assertion is not equal.
                          "test_test_uri_options_srv-options_SRV_URI_with_custom_srvServiceName"
                          "test_test_uri_options_srv-options_SRV_URI_with_invalid_type_for_srvMaxHosts"
                          "test_test_uri_options_srv-options_SRV_URI_with_negative_integer_for_srvMaxHosts"
                          "test_test_uri_options_srv-options_SRV_URI_with_positive_srvMaxHosts_and_loadBalanced"
                          "test_test_uri_options_srv-options_SRV_URI_with_srvMaxHosts")
                    " and not "))))
    (native-inputs
     (list python-hatch-requirements-txt
           python-hatchling
           python-pytest
           python-pytest-asyncio
           python-setuptools))
    (propagated-inputs
     (list python-certifi
           python-dnspython))
    (home-page "https://github.com/mongodb/mongo-python-driver")
    (synopsis "Python driver for MongoDB")
    (description "Python driver for MongoDB.")
    (license license:asl2.0)))

(define-public python-py-consul
  (package
    (name "python-py-consul")
    (version "1.6.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              ;; Fork from https://github.com/cablehead/python-consul
              (url "https://github.com/criteo/py-consul")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0jx0sx572akir5ks30d1hvxwmy2apc51idm5k73dfp9biyjhbllh"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))  ; Tests require docker.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-requests))
    (home-page "https://github.com/criteo/py-consul")
    (synopsis "Python client for Consul")
    (description
     "Python client for @url{http://www.consul.io/,Consul}, a tool for service
discovery, monitoring and configuration.")
    (license license:expat)))

(define-deprecated-package python-consul python-py-consul)

(define-public python-schematics
  (package
    (name "python-schematics")
    (version "2.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/schematics/schematics")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0nf14wy422f08zzxx4jv8kbym3asgfpjm7b2p51b8hgqgxqlmjcd"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-dateutil python-mock python-pytest python-setuptools))
    (home-page "https://github.com/schematics/schematics")
    (synopsis "Python Data Structures for Humans")
    (description
     "Schematics is a Python library to combine types into structures,
validate them, and transform the shapes of your data based on simple
descriptions.

The internals are similar to ORM type systems, but there is no database layer
in Schematics.  Instead, building a database layer is easily made when
Schematics handles everything except for writing the query.  Schematics can be
used for tasks where having a database involved is unusual.")
    (license license:bsd-3)))

(define-public python-odfpy
  (package
    (name "python-odfpy")
    (version "1.4.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eea/odfpy")
             (commit (string-append "release-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "15y0fvkk8akgx30dxld7mdqhdrrkwr16jy1q0znkzvwcgmpywrf4"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-defusedxml))
    (home-page "https://github.com/eea/odfpy")
    (synopsis "Python API and tools to manipulate OpenDocument files")
    (description
     "Collection of libraries and utility programs written in Python to
manipulate OpenDocument 1.2 files.")
    (license
     ;; The software is mainly dual GPL2+ and ASL2.0, but includes a
     ;; number of files with other licenses.
     (list license:gpl2+ license:asl2.0 license:lgpl2.1+ license:cc-by-sa3.0))))

(define-public python-namex
  (package
    (name "python-namex")
    (version "0.0.7")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "namex" version))
       (sha256
        (base32 "16ynrq245c3nywv476izrc4bcacm9gxjzgr67ng91g929ny6bfl4"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false))  ;there are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/fchollet/namex")
    (synopsis
     "Separate implementation and public API surface of Python packages")
    (description
     "This package provides a simple utility to separate the
implementation of your Python package and its public API surface.")
    (license license:asl2.0)))

(define-public python-natsort
  (package
    (name "python-natsort")
    (version "8.4.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "natsort" version))
       (sha256
        (base32 "10d53q50zn2s8iiszv01nr9r4imimc2dvplkl4ymj1sm1r52qca5"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list glibc-utf8-locales ;; Tests want en_US.UTF-8
           python-pytest
           python-pytest-mock
           python-setuptools))
    (propagated-inputs
     (list python-fastnumbers
           python-pyicu))
    (home-page "https://github.com/SethMMorton/natsort")
    (synopsis "Natural sorting for python and shell")
    (description
     "Natsort lets you apply natural sorting on lists instead of
lexicographical.  If you use the built-in @code{sorted} method in python on a
list such as @code{[@code{a20}, @code{a9}, @code{a1}, @code{a4}, @code{a10}]},
it would be returned as @code{[@code{a1}, @code{a10}, @code{a20}, @code{a4},
@code{a9}]}.  Natsort provides a function @code{natsorted} that identifies
numbers and sorts them separately from strings.  It can also sort version
numbers, real numbers, mixed types and more, and comes with a shell command
@command{natsort} that exposes this functionality in the command line.")
    (license license:expat)))

(define-public python-graphql-core
  (package
    (name "python-graphql-core")
    (version "3.1.2")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "graphql-core" version))
        (sha256
         (base32
          "0fjv5w2wvgdr8gb27v241bavliipyir9fdz48rsgc3xapm644mn0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'use-poetry-core
           (lambda _
             ;; Patch to use the core poetry API.
             (substitute* "pyproject.toml"
               (("poetry.masonry.api")
                "poetry.core.masonry.api")
               ;; Poetry does not like line breaks.
               (("description = \"\"\"")
                "description = \"GraphQL-core is a Python port of GraphQL.js.\"\n")
               (("^GraphQL-core is a Python.*") "")
               (("^ the JavaScript reference.*") ""))))
         (add-after 'unpack 'patch-setup.py
           (lambda _
             (substitute* "setup.py"
               ;; Relax hardcoded version
               (("'gevent==1.1rc1'") "'gevent'")
               ;; Poetry complains about this line break.
               (("a port of GraphQL.js,\"")
                (string-append "a port of GraphQL.js, "
                               "the JavaScript reference implementation for GraphQL."))
               (("    \" the JavaScript reference.*") "")))))))
    (native-inputs
     (list python-gevent
           python-mock
           python-poetry-core
           python-pytest
           python-pytest-benchmark
           python-pytest-mock))
    (propagated-inputs
     (list python-promise python-six))
    (home-page "https://github.com/graphql-python/graphql-core")
    (synopsis "GraphQL implementation for Python")
    (description
     "GraphQL implementation for Python.  GraphQL is a data query language and
     runtime designed and used to request and deliver data to mobile and web apps.
     This library is a port of @url{https://github.com/graphql/graphql-js,graphql-js}
     to Python.")
    (license license:expat)))

(define-public python-graphql-relay
  (package
    (name "python-graphql-relay")
    (version "3.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/graphql-python/graphql-relay-py")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "06ybi4bwqdffa5kn8xnns06wh3l0zj3qlzrxk1wpxqq320hyzx9x"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-flags #~(list "tests")))
    (native-inputs
     (list python-pytest python-pytest-asyncio python-poetry-core))
    (propagated-inputs (list python-graphql-core))
    (home-page "https://github.com/graphql-python/graphql-relay-py")
    (synopsis "Relay implementation for Python")
    (description
     "This is a library to allow the easy creation of Relay-compliant servers
using the GraphQL Python reference implementation of a GraphQL server.  It
should be noted that the code is a exact port of the original
@url{https://github.com/graphql/graphql-relay-js,graphql-relay js
implementation} from Facebook.")
    (license license:expat)))

(define-public python-graphene
  (package
    (name "python-graphene")
    (version "3.4.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "graphene" version))
       (sha256
        (base32 "1aha3bnrafxd823q4swdmlvbprfb17v3fga4g3hffpz7ija8cdra"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;XXX: tests fail to load
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-dateutil
           python-graphql-core
           python-graphql-relay
           python-typing-extensions))
    (home-page "https://graphene-python.org/")
    (synopsis "GraphQL Framework for Python")
    (description
     "Graphene is a Python library for building GraphQL schemas/types.  A
GraphQL schema describes your data model, and provides a GraphQL server with
an associated set of resolve methods that know how to fetch data.")
    (license license:expat)))

(define-public python-rodi
  (package
    (name "python-rodi")
    (version "2.0.8")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Neoteroi/rodi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kf98yjllrq7vqcp07r2gmkqcviqglsnai3sdigdsrwrfc0b44yp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatchling
           python-pytest
           python-pytest-asyncio))
    (home-page "https://github.com/Neoteroi/rodi")
    (synopsis "Dependency injection framework for Python")
    (description
     "Rodi is a dependency injection framework for Python applications.

Its features include

@itemize
@item Type resolution by signature types annotations.
@item Type resolution by class annotations.
@item Type resolution by names and aliases.
@item Build graph of objects without the need for source code changes.
@item Minimum overhead to obtain services, once the objects graph is built.
@item Support for singleton, transient, and scoped services.
@end itemize")
    (license license:expat)))

;; XXX: The last time updated in 2015, consider to remove it when nothing is
;; depend on it.
(define-public python-snowballstemmer
  (package
    (name "python-snowballstemmer")
    (version "2.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "snowballstemmer" version))
       (sha256
        (base32 "1ccwy75i0f5yi1vy6fyvr1gf43ydhjani45mswm43ls7hpmnvc89"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f)) ; no tests
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/shibukawa/snowball_py")
    (synopsis "Snowball stemming library collection for Python")
    (description
     "This package provides 16 word stemmer algorithms generated from Snowball
algorithms.  It includes the 15 original ones plus the Poerter English
stemmer.")
    (license license:bsd-3)))

(define-public python-setproctitle
  (package
    (name "python-setproctitle")
    (version "1.3.7")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/dvarrazzo/py-setproctitle")
             (commit (string-append "version-" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0k51ypmr2p2c55dyl2pq3dclih9jk2zx7dxm8010li4pyfsrvwvm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'configure-tests
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (setenv "PYTHON"
                        (or (which "python3")
                            (which "python")))
                (setenv "PYCONFIG"
                        (if (which "python3-config")
                            "python3-config --embed"
                            "python-config"))
                (substitute* "tests/conftest.py"
                  (("cc") "gcc"))))))))
    (native-inputs (list procps python-pytest python-setuptools)) ;required for tests
    (home-page "https://github.com/dvarrazzo/py-setproctitle")
    (synopsis
     "Setproctitle implementation for Python to customize the process title")
    (description
     "The library allows a process to change its title (as displayed by system
tools such as @code{ps} and @code{top}).

Changing the title is mostly useful in multi-process systems, for example when a
master process is forked: changing the children's title allows identifying the
task each process is busy with.  The technique is used by PostgreSQL and the
OpenSSH Server for example.")
    (license license:bsd-3)))

(define-public python-pyelftools
  (package
    (name "python-pyelftools")
    (version "0.32")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/eliben/pyelftools")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wx18rj5hcra45ck407vfvg46rs1qcj3qjhfkprf6264zs6z1i77"))
       (snippet
        #~(begin
            ;; Delete bundled readelf and llvm-dwardump executables.  Project
            ;; also ships quite a lot binary files mainly for tests, check
            ;; with:
            ;;
            ;; find . -type f ! -size 0 -exec grep -IL . "{}" \;
            ;;
            (delete-file "test/external_tools/readelf")
            (delete-file "test/external_tools/llvm-dwarfdump")))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                ;; Run just basic unit and example tests, dwarfdump and
                ;; readelf tests are not selected as they are fragile and
                ;; arch-specific.
                (invoke "python" "test/run_all_unittests.py")
                (invoke "python" "test/run_examples_test.py")))))))
    (home-page "https://github.com/eliben/pyelftools")
    (native-inputs
     (list python-setuptools
           python-wheel))
    (synopsis "Analyze binary and library file information")
    (description
     "This Python library provides interfaces for parsing and analyzing two
binary and library file formats ; the Executable and Linking Format (ELF), and
debugging information in the Debugging With Attributed Record
Format (DWARF).")
    (license license:public-domain)))

(define-public python-pefile
  (package
    (name "python-pefile")
    (version "2024.8.26")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/erocarrera/pefile")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14bh23b7jipf2pxjivyn2khifal6fmk0pjsddrd3h1gd9n0wl9zd"))
       (snippet #~(delete-file "tests/test_data.tar.bz2.enc"))))
    (build-system pyproject-build-system)
    (arguments
     ;; XXX: Taken from tox.ini. Unclear why devs don't supply test data.
     ;; It seems clear however that test_data.tar.bz2.enc needs to be
     ;; decrypted and unpacked before we can run them.
     (list #:test-flags #~(list "--ignore=tests/pefile_test.py")))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-future))
    (home-page "https://github.com/erocarrera/pefile")
    (synopsis "Portable Executable (PE) file parser")
    (description
     "This python library provides interfaces for parsing and working with
Portable Executable (PE) files.  It makes to most information from the header,
as well as section details and data available.")
    (license license:expat)))

(define-public python-pyemd
  (package
    (name "python-pyemd")
    (version "1.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyemd" version))
              (sha256
               (base32
                "1zh0v47lxa33xg04jyvblzl1g4m3k2khx0b3xr6isnyinbkmlaxl"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-numpy))
    (native-inputs
     (list python-cython
           python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/wmayner/pyemd")
    (synopsis
     "Wrapper for Pele and Werman's implementation of the Earth Mover's Distance")
    (description
     "This package provides a Python wrapper for Ofir Pele and Michael
Werman's implementation of the Earth Mover's Distance.")
    (license license:expat)))

(define-public python-imagesize
  (package
    (name "python-imagesize")
    (version "1.4.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "imagesize" version))
       (sha256
        (base32 "0jndjx26p8qibrx997p3kb6vfbqbdxkv74jsrkav177vmx2085b9"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/shibukawa/imagesize_py")
    (synopsis "Gets image size of files in various formats in Python")
    (description
     "This package allows determination of image size from PNG, JPEG,
JPEG2000 and GIF files in pure Python.")
    (license license:expat)))

(define-public python-argcomplete
  (package
    (name "python-argcomplete")
    (version "3.6.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "argcomplete" version))
       (sha256
        (base32
         "1pvavik22prqdyqid5s40zqab93kp85ash9wf7sg9xb7r0drnlfh"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test/test.py" "-v")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'disable-pip-tests
            (lambda _
              ;; pip: command not found
              (substitute* "test/test.py"
                (("def test_console_script")
                 "def __disable_test_console_script")))))))
    (native-inputs
     (list python-hatch-vcs
           python-hatchling
           python-pexpect
           tcsh
           fish
           bash  ;full Bash for 'test_file_completion'
           zsh))
    (home-page "https://github.com/kislyuk/argcomplete")
    (synopsis "Shell tab completion for Python argparse")
    (description "argcomplete provides extensible command line tab completion
of arguments and options for Python scripts using @code{argparse}.  It's
particularly useful for programs with many options or sub-parsers that can
dynamically suggest completions ; for example, when browsing resources over
the network.")
    (license license:asl2.0)))

(define-public python-csscompressor
  (package
    (name "python-csscompressor")
    (version "0.9.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/sprymix/csscompressor")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1gzzb474lgs8l539z2vyyvcvm1j7nxxnb5jk79ys63ysbg4jwmz8"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://github.com/sprymix/csscompressor")
    (synopsis "Python port of YUI CSS Compressor")
    (description "This package provides a python port of YUI CSS Compressor.")
    (license license:bsd-3)))

(define-public python-rcssmin
  (package
    (name "python-rcssmin")
    (version "1.2.0")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "rcssmin" version))
        (sha256
         (base32
          "0k68sw163vc36nb3nck0kwwal4vb4hi6634rzx7z19ng28j8fdpl"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "http://opensource.perlig.de/rcssmin/")
    (synopsis "CSS Minifier")
    (description "The minifier is based on the semantics of the YUI compressor,
     which itself is based on the rule list by Isaac Schlueter.")
    (license license:asl2.0)))

(define-public python-rjsmin
  (package
    (name "python-rjsmin")
    (version "1.2.3")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "rjsmin" version))
        (sha256
         (base32
          "1ihcff58vz4xrv1180v46wy5m80z61y7ab8ajyy4zh54jcjbb20k"))
        (modules '((guix build utils)))
        (snippet
         '(for-each delete-file (find-files "bench" "\\.js$")))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools python-wheel))
    (home-page "http://opensource.perlig.de/rjsmin/")
    (synopsis "Javascript Minifier")
    (description "@code{rJSmin} is a javascript minifier written in Python.
The minifier is based on the semantics of jsmin.c by Douglas Crockford.  The
module is a re-implementation aiming for speed, so it can be used at
runtime (rather than during a preprocessing step).")
    (license license:asl2.0)))

(define-public python-cheetah
  (package
    (name "python-cheetah")
    (version "3.3.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "CT3" version))
       (sha256
        (base32 "1j36vampqip18jx0jzngb9rnkhhhl8hqnscg117y0d6cgrgm57qw"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "Cheetah/Tests/Test.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'use-absolute-python
            (lambda _
              (substitute* "Cheetah/CheetahWrapper.py"
                (("#!/usr/bin/env python")
                 (string-append "#!" (which "python"))))))
          (add-before 'check 'configure-tests
            (lambda* (#:key tests? #:allow-other-keys)
              (substitute* "Cheetah/Tests/ImportHooks.py"
                (("os.path.dirname\\(__file__\\)")
                 (string-append "'" (getcwd) "/Cheetah/Tests'")))
              (substitute* "Cheetah/Tests/Test.py"
                (("unittest.TextTestRunner\\(\\)")
                 "unittest.TextTestRunner(verbosity=2)"))
              (setenv "TMPDIR" "/tmp"))))))
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-markdown)) ;optional
    (home-page "https://cheetahtemplate.org/")
    (synopsis "Template engine")
    (description
     "Cheetah is a text-based template engine and Python code generator.

     Cheetah can be used as a standalone templating utility or referenced as a
library from other Python applications.  It has many potential uses, but web
developers looking for a viable alternative to ASP, JSP, PHP and PSP are
expected to be its principle user group.

Features:
@enumerate
@item Generates HTML, SGML, XML, SQL, Postscript, form email, LaTeX, or any
other text-based format.
@item Cleanly separates content, graphic design, and program code.
@item Blends the power and flexibility of Python with a simple template
language that non-programmers can understand.
@item Gives template writers full access to any Python data structure, module,
function, object, or method in their templates.
@item Makes code reuse easy by providing an object-orientated interface to
templates that is accessible from Python code or other Cheetah templates.  One
template can subclass another and selectively reimplement sections of it.
@item Provides a simple, yet powerful, caching mechanism that can dramatically
improve the performance of a dynamic website.
@item Compiles templates into optimized, yet readable, Python code.
@end enumerate")
    (license (license:x11-style "file://LICENSE"))))

(define-public python-chevron
  (package
    (name "python-chevron")
    (version "0.14.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "chevron" version))
              (sha256
               (base32
                "1gqfh00ics2k1sm5g46l3bi8cl5fc5d1cwzh1ylvcxvdvypklqc7"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #false)) ;there are none
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/noahmorrison/chevron")
    (synopsis "Mustache templating language renderer")
    (description "This package provides a Python implementation of the
Mustache templating language renderer.")
    (license license:expat)))

(define-public python-dulwich
  (package
    (name "python-dulwich")
    (version "0.21.7")
    (source
     (origin
       (method url-fetch)
       (uri (list (string-append "https://www.dulwich.io/releases/"
                                 "dulwich-" version ".tar.gz")
                  (pypi-uri "dulwich" version)))
       (sha256
        (base32
         "0s79c3g19m052jbxm66amxv5v60ijx5px4hjmk1q19ff6dlcdsd9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; DULWICH_SWIFT_CFG is not set.
      '(list "--ignore=dulwich/contrib/test_swift_smoke.py"
             "-k"
             ;; 'HTTPClient' object has no attribute 'get_base_url'
             "not test_init_connector")
      #:phases
      '(modify-phases %standard-phases
         (add-after 'unpack 'fix-tests
           (lambda* (#:key inputs #:allow-other-keys)
             (substitute* '("dulwich/tests/test_repository.py"
                            "dulwich/tests/test_porcelain.py"
                            "dulwich/tests/test_hooks.py")
               (("/bin/sh") (search-input-file inputs "/bin/sh")))))
         (add-before 'check 'pre-check
           (lambda _ (setenv "PYTHONHASHSEED" "random"))))))
    (propagated-inputs
     (list python-fastimport python-urllib3))
    (native-inputs
     (list gnupg
           git-minimal/pinned
           python-geventhttpclient
           python-mypy
           python-paramiko
           python-pytest
           python-requests
           python-setuptools
           python-wheel))
    (home-page "https://www.dulwich.io/")
    (synopsis "Git implementation in Python")
    (description "Dulwich is an implementation of the Git file formats and
protocols written in pure Python.")
    ;; Can be used with either license.
    (license (list license:asl2.0 license:gpl2+))))

(define-public python-dulwich-0.24
  (package/inherit python-dulwich
    (name "python-dulwich")
    (version "0.24.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dulwich" version))
       (sha256
        (base32 "0n3p8jyxl4zwc63la10v8llc58fc5pcnfqdq9f1vn0hgy5jdi7z1"))))
    (build-system pyproject-build-system)
    (native-inputs
     (modify-inputs (package-native-inputs python-dulwich)
       (prepend python-setuptools-rust)))
    (arguments
     (list
      #:test-flags
      ;; DULWICH_SWIFT_CFG is not set.
      '(list "--ignore=tests/contrib/test_swift_smoke.py"
             ;; AttributeError: 'SwiftPackData' object has no attribute '_file'
             "--ignore=tests/contrib/test_swift.py"
             ;; No git repository was found at .
             "--ignore=tests/test_cli.py"
             ;; 'HTTPClient' object has no attribute 'get_base_url'
             ;; 'NoneType' object has no attribute 'Merge3'
             "--ignore=tests/test_cli_merge.py"
             "--ignore=tests/test_merge_drivers.py"
             "--ignore=tests/test_porcelain_cherry_pick.py"
             "--ignore=tests/test_porcelain_merge.py"
             "--ignore=tests/test_rebase.py"
             "--ignore=tests/test_repository.py"
             "--ignore=tests/test_worktree.py"
             "--ignore=tests/test_porcelain.py"
             "--ignore=tests/test_porcelain_filters.py"
             ;; False is not true (interesting capitalization?)
             "--ignore=tests/test_hooks.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-pyproject
            (lambda _
              ;; setuptools cannot handle both license and license-files
              (substitute* "pyproject.toml"
                (("^license = .*") "license = {text = \"Apache-2.0\"}\n")
                (("^license-files = .*") ""))))
          (add-before 'check 'pre-check
            (lambda* (#:key tests?  #:allow-other-keys)
              (when tests?
                (setenv "HOME" "/tmp")))))))))

(define-public python-dunamai
  (package
    (name "python-dunamai")
    (version "1.21.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "dunamai" version))
       (sha256
        (base32 "1i35i8ym6n8mpgrq31hivrvfciy12gv26jwlzimmkx9jy2spz0h5"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "-k" "not test__version__from_git__shallow")
      #:phases
      #~(modify-phases %standard-phases
          ;; These steps are taked from NixOS package definition:
          ;; nixpkgs/pkgs/development/python-modules/dunamai/default.nix
          (add-before 'check 'pre-check
            (lambda _
              (setenv "PATH" (string-append #$output "/bin:" (getenv "PATH")))
              (setenv "HOME" "/tmp")
              (invoke "git" "config" "--global" "user.email" "nobody@example.com")
              (invoke "git" "config" "--global" "user.name" "Nobody"))))))
    (propagated-inputs
     (list python-packaging))
    (native-inputs
     (list git-minimal
           python-poetry-core
           python-pytest))
    (home-page "https://github.com/mtkennerly/dunamai")
    (synopsis "Dynamic version generation")
    (description
     "Dunamai is Python library and command line tool for producing dynamic,
standards-compliant version strings, derived from tags in your version control
system.  This facilitates uniquely identifying nightly or per-commit builds in
continuous integration and releasing new versions of your software simply by
creating a tag.")
    (license license:expat)))

(define-public python-pbkdf2
  (package
    (name "python-pbkdf2")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pbkdf2" version))
       (sha256
        (base32 "0yb99rl2mbsaamj571s1mf6vgniqh23v98k4632150hjkwv9fqxc"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "test/test_pbkdf2.py")))
    (native-inputs (list python-setuptools))
    (home-page "https://www.dlitz.net/software/python-pbkdf2/")
    (synopsis "Password-based key derivation")
    (description
     "This module implements the password-based key derivation function,
PBKDF2, specified in RSA PKCS#5 v2.0.

PKCS#5 v2.0 Password-Based Key Derivation is a key derivation function which
is part of the RSA Public Key Cryptography Standards series.  The provided
implementation takes a password or a passphrase and a salt value (and
optionally a iteration count, a digest module, and a MAC module) and provides
a file-like object from which an arbitrarily-sized key can be read.")
    (license license:expat)))

(define-public python-qrcode
  (package
    (name "python-qrcode")
    (version "8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "qrcode" version))
       (sha256
        (base32 "0v2h8vs1b80qhkc293w5dzvd439600ffzcznp5m16crb2yjg5hrm"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-poetry-core
           python-pytest))
    (home-page "https://github.com/lincolnloop/python-qrcode")
    (synopsis "QR Code image generator")
    (description
     "This package provides a pure Python QR Code generator module.  It uses
the Python Imaging Library (PIL) to allow for the generation of QR Codes.

In addition this package provides a command line tool to generate QR codes and
either write these QR codes to a file or do the output as ascii art at the
console.")
    (license license:bsd-3)))

(define-public python-rst2ansi
  (package
    (name "python-rst2ansi")
    (properties '((commit . "c6f390b45be689a5760060c990e3fe10f502e671")
                  (revision . "0")))
    (version (git-version "0.1.5"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/Snaipe/python-rst-to-ansi")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0vsn1jjhm1hx0q5i954lyhny2yvn619am1di03aypfl0wm1mh7qd"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f  ; 2 tests fail with additional line characters
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "cram" "test" "-v")))))))
    (native-inputs (list python-cram python-setuptools))
    (propagated-inputs (list python-docutils))
    (home-page "https://github.com/Snaipe/python-rst-to-ansi")
    (synopsis "Convert RST to ANSI-decorated console output")
    (description
     "Python module dedicated to rendering RST (reStructuredText) documents to
ansi-escaped strings suitable for display in a terminal.")
    (license license:expat)))

(define-public python-ansi2html
  (package
    (name "python-ansi2html")
    (version "1.9.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "ansi2html" version))
       (sha256
        (base32 "19f0ap4w66b35csmx4k97pnb9fkdfnmgliajn0kvhdsxaf3vylrl"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-mock
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/ralphbean/ansi2html")
    (synopsis "Convert ANSI-decorated console output to HTML")
    (description
     "@command{ansi2html} is a Python library and command line utility for
converting text with ANSI color codes to HTML or LaTeX.")
    (license license:gpl3+)))

(define-public python-easy-ansi
  (package
    (name "python-easy-ansi")
    (version "2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://gitlab.com/joeysbytes/easy-ansi")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "16zk4vyrr3hhb6aijmqchjlz181mgk7mi9zyyjd8i53h9rr00wkx"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'install 'remove-extra
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (with-directory-excursion (site-packages inputs outputs)
                (delete-file-recursively "tests")
                (delete-file "setup.py")))))))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://gitlab.com/joeysbytes/easy-ansi")
    (synopsis "Terminal framework API")
    (description
     "Easy ANSI is a terminal framework API to give you an easy way to use
colors, cursor control movements, and line/box drawing.  It is not meant as a
replacement to more full-featured frameworks (such as curses or urwid), but as
a tool to quickly create nice-looking screens in your terminal window.  You
can even create animations with the cursor controls.")
    (license license:expat)))

(define-public python-easy-ansi-0.3
  (package
    (inherit python-easy-ansi)
    (name "python-easy-ansi")
    (version "0.3")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://gitlab.com/joeysbytes/easy-ansi")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0albh55ynzs98qy9pln4qaxw5qhhh3lk09jy9bx19gycrp1c3lc3"))))
    (arguments '())))

(define-public python-pycosat
  (package
    (name "python-pycosat")
    (version "0.6.6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/ContinuumIO/pycosat")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1p62d7fqny4ayr218lshrp35g75ljaxlgza9yr2hm44aqggvmqbw"))))
    ;; TODO: Unundle picosat. http://fmv.jku.at/picosat/
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list unzip python-setuptools))
    (home-page "https://github.com/ContinuumIO/pycosat")
    (synopsis "Bindings to picosat (a SAT solver)")
    (description
     "This package provides efficient Python bindings to @code{picosat} on the
C level.  When importing pycosat, the @code{picosat} solver becomes part of
the Python process itself.  @code{picosat} is a @dfn{Boolean Satisfiability
Problem} (SAT) solver.")
    (license license:expat)))

(define-public python-pypeg2
  (package
    (name "python-pypeg2")
    (version "2.15.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyPEG2" version))
       (sha256
        (base32
         "0v8ziaam2r637v94ra4dbjw6jzxz99gs5x4i585kgag1v204yb9b"))))
    (build-system python-build-system)
    (propagated-inputs (list python-lxml))
    (arguments
     ;;https://bitbucket.org/fdik/pypeg/issues/36/test-failures-on-py35
     '(#:tests? #f))
    (home-page "https://fdik.org/pyPEG/")
    (synopsis "Parsing Expression Grammars in Python")
    (description "PyPEG is an intrinsic parser interpreter framework for
     Python.  It is based on Parsing Expression Grammars, PEG.  With pyPEG you can
     parse many formal languages.")
    (license license:gpl2)))

(define-public python-pyformlang
  (package
    (name "python-pyformlang")
    (version "1.0.10")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pyformlang" version))
       (sha256
        (base32 "0szgy4pqfixmswjs37qgma4qa3bsadpp3l1xflrpfi10aa8hh2sp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-networkx
           python-numpy
           python-pydot))
    (home-page "https://github.com/Aunsiels/pyformlang")
    (synopsis "Framework for interacting with formal grammars")
    (description
     "This package provides a framework for working with formal
language grammars.  The library was originally developed for educational
purposes and therefore implements many textbook algorithms regarding the
manipulation and interaction with formal grammars.")
    (license license:expat)))

(define-public python-incremental
  (package
    (name "python-incremental")
    (version "24.7.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "incremental" version))
       (sha256
        (base32
         "1jb4skmy8awix345jk2pnar0sxmrf1gvn3kg9xyyivv0xr3iskzv"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Tests require twisted, which needs this package.
     (list #:tests? #false
           #:build-backend "setuptools.build_meta"))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/hawkowl/incremental")
    (synopsis "Library for versioning Python projects")
    (description "Incremental is a small library that versions your Python
     projects.")
    (license license:expat)))

(define-public python-invoke
  (package
    (name "python-invoke")
    (version "2.2.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "invoke" version))
       (sha256
        (base32 "01z73gmbmf5q3ynr3yfz894rrwr2v9406n94n1wjp4s89adz8nsi"))))
    ;; TODO: invoke/vendor contains:
    ;; - fluidity -> https://github.com/nsi-iff/fluidity   (14y old)
    ;; - lexicon  -> https://github.com/bitprophet/lexicon (2y old)
    ;; - yaml     -> https://github.com/yaml/pyyaml        (2y old)
    (build-system pyproject-build-system)
    (arguments
     (list
     ;; XXX: Requires many dependencies that are not yet in Guix.
      #:tests? #f
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-bash-path
            (lambda _
              (let ((bash #$(this-package-input "bash-minimal")))
                (substitute* "invoke/config.py"
                  (("shell = \"/bin/bash\"")
                   (string-append "shell = \"" bash "/bin/bash\""))))))
          (add-after 'wrap 'fix-entry-points
            ;; TODO: Remove after https://codeberg.org/guix/guix/issues/4509
            ;; is fixed.
            (lambda _
              (substitute* (list (string-append #$output "/bin/.invoke-real")
                                 (string-append #$output "/bin/.inv-real"))
                (("from invoke.main import program.run")
                 "from invoke.main import program")))))))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (inputs
     (list bash-minimal))
    (home-page "https://www.pyinvoke.org/")
    (synopsis "Pythonic task execution")
    (description
     "Invoke is a Python task execution tool and library, drawing inspiration
from various sources to arrive at a powerful and clean feature set.  It is
evolved from the Fabric project, but focuses on local and abstract concerns
instead of servers and network commands.")
    (license license:bsd-3)))

(define-public python-automat
  (package
    (name "python-automat")
    (version "24.8.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "Automat" version))
              (sha256
               (base32
                "123d63k8wg9pfv9j7hr0kd1kw23m0rwdx7irsa55ncpncg7jfhmk"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? test-flags #:allow-other-keys)
              (with-directory-excursion #$output
                (apply invoke "pytest" "-vv" test-flags))))
          ;; Remove script, because it depends on python-twisted.
          (add-after 'unpack 'remove-entrypoint
            (lambda _
              (substitute* "pyproject.toml"
                (("automat-visualize = \"automat._visualize:tool\"") "")))))))
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm python-wheel))
    (propagated-inputs
     (list python-graphviz python-typing-extensions))
    (home-page "https://github.com/glyph/Automat")
    (synopsis "Self-service finite-state machines")
    (description "Automat is a library for concise, idiomatic Python
     expression of finite-state automata (particularly deterministic finite-state
                                                       transducers).")
    (license license:expat)))

(define-public python-constantly
  (package
    (name "python-constantly")
    (version "23.10.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "constantly" version))
       (sha256
        (base32 "1gbw3izhn1gx1rgc61jbfr4dr535fxhynifp7jrhpb726c5bg4ma"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;cycles with python-twisted
    (native-inputs
     (list python-setuptools
           python-versioneer))
    (home-page "https://github.com/twisted/constantly")
    (synopsis "Symbolic constants in Python")
    (description "Constantly is a Python library that provides symbolic
     constant support.  It includes collections and constants with text, numeric,
     and bit flag values.")
    (license license:expat)))

(define-public python-attrs
  (package
    (name "python-attrs")
    (version "25.3.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "attrs" version))
       (sha256
        (base32 "06xgyhxzsc0h3l0pqlkk168f072a9lnl9d415ixp8xmmgzycxmvm"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-hatch-fancy-pypi-readme
           python-hatch-vcs
           python-hatchling
           python-hypothesis
           python-pytest))
    (home-page "https://github.com/python-attrs/attrs/")
    (synopsis "Attributes without boilerplate")
    (description "@code{attrs} is a Python package with class decorators that
     ease the chores of implementing the most common attribute-related object
     protocols.")
    (license license:expat)))

(define-public python-attrs-bootstrap
  (package
    (inherit python-attrs)
    (name "python-attrs-bootstrap")
    (native-inputs (list python-hatchling
                         python-hatch-fancy-pypi-readme
                         python-hatch-vcs))
    (arguments `(#:tests? #f))))

(define-public python-cliapp
  (package
    (name "python-cliapp")
    (version "1.20180812.1")
    (source
     (origin
       (method url-fetch)
       (uri (string-append
             "http://git.liw.fi/cgi-bin/cgit/cgit.cgi/cliapp/snapshot/cliapp-"
             version ".tar.gz"))
       (sha256
        (base32
         "1c1jlblbns8qhiaqjpg4xi6lip8xwfc5w643p43rg543havaj45x"))))
    (build-system python-build-system)
    (arguments
     `(;; XXX: The tests only do style and coverage checks, which
       ;; fails due to deprecation warnings, etc.
       #:tests? #f))
    (native-inputs
     (list python-coverage-test-runner))
    (propagated-inputs
     (list python-pyaml))
    (home-page "https://liw.fi/cliapp/")
    (synopsis "Python framework for command line programs")
    (description "@code{cliapp} is a Python framework for command line
     programs.  It contains the typical stuff such programs need to do, such
     as parsing the command line for options, and iterating over input files.")
    (license license:gpl2+)))

(define-public python-astroid
  (package
    (name "python-astroid")
    (version "3.3.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/PyCQA/astroid")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1x5903kmi47pc87r949lym2cwl0xg885xyy730adxv0g6r083zwn"))))
    (build-system pyproject-build-system)
    (arguments
     ;; UserWarning: pkg_resources is deprecated as an API. See
     ;; https://setuptools.pypa.io/en/latest/pkg_resources.html. The
     ;; pkg_resources package is slated for removal as early as
     ;; 2025-11-30. Refrain from using this package or pin to Setuptools<81.
     (list #:test-flags
           #~(list "-k" "not test_identify_old_namespace_package_protocol")))
    (native-inputs
     (list python-mypy-minimal
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-lazy-object-proxy
           python-typing-extensions
           python-wrapt))
    (home-page "https://github.com/PyCQA/astroid")
    (synopsis "Python source code base representation")
    (description "@code{python-astroid} provides a common base representation
of Python source code for projects such as pychecker, pyreverse, pylint, etc.
It provides a compatible representation which comes from the _ast module.  It
rebuilds the tree generated by the builtin _ast module by recursively walking
down the AST and building an extended ast.  The new node classes have
additional methods and attributes for different usages.  They include some
support for static inference and local name scopes.  Furthermore, astroid
builds partial trees by inspecting living objects.")
    (license license:lgpl2.1+)))

(define-public python-isbnlib
  (package
    (name "python-isbnlib")
    (version "3.10.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/xlcnd/isbnlib")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "07vpq8y0mn16489d1pl4zxgczgl1s2ydli4lci7f73z4zv179akp"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "-m" "not network")))
    (native-inputs (list python-pytest python-pytest-cov python-setuptools))
    (home-page "https://github.com/xlcnd/isbnlib")
    (synopsis "Python library to work with ISBN strings")
    (description
     "@code{python-isbnlib} is a (pure) python library that provides several
useful methods and functions to validate, clean, transform, hyphenate and get
metadata for ISBN strings.  Its origin was as the core of isbntools.  This
short version, is suitable to be include as a dependency in other projects.")
    (license license:lgpl3+)))

(define-public python-isoduration
  (package
    (name "python-isoduration")
    (version "20.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "isoduration" version))
       (sha256
        (base32 "1n8vpa9fckhc5934kp7m83wq81dhkvw987v7mjg2fdbr2car0bxc"))))
    (build-system pyproject-build-system)
    (arguments '(#:tests? #f))          ;no tests in PyPI archive
    (propagated-inputs (list python-arrow))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/bolsote/isoduration")
    (synopsis "Operations with ISO 8601 durations")
    (description "ISO 8601 is most commonly known as a way to exchange
datetimes in textual format.  A lesser known aspect of the standard is the
representation of durations.  The state of the art of ISO 8601 duration
handling in Python is more or less limited to what's offered by isodate. This
package attempts to address the shortcomings of @code{isodate}.")
    (license license:isc)))

(define-public python-isort
  (package
    (name "python-isort")
    (version "6.0.1")
    (source
     (origin
       (method git-fetch)       ;no tests in PyPI archive
       (uri (git-reference
              (url "https://github.com/timothycrosley/isort")
              (commit version)))
       (file-name (git-file-name name version))
       (modules '((guix build utils)))
       (snippet '(for-each delete-file (find-files "." "\\.whl$")))
       (sha256
        (base32 "1fcwv1dlq0d3is9s6scp6vy7yw4l845kk51ihxac8419n8hrpvpq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Ignore benchmark and integration to reduce closure size.
      #~(list "--ignore=tests/benchmark/"
              "--ignore=tests/integration/"
              "--ignore=tests/unit/profiles/test_black.py"
              "-k" (string-join
                    (list "not test_gitignore"
                          "test_isort_supports_shared_profiles_issue_970"
                          "test_requirements_dir"
                          "test_requirements_finder"
                          "test_sort_configurable_sort_issue_1732"
                          "test_sort_imports_error_handling")
                    " and not "))
      ;; TODO: Package example plugins separately, available in PyPI:
      ;; - example_isort_formatting_plugin
      ;; - example_isort_sorting_plugin
      ;; - example_shared_isort_profile
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'build 'pretend-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version))))))
    (native-inputs
     (list python-colorama
           python-hatch-vcs
           python-hatchling
           python-hypothesis
           python-pylama
           python-pytest))
    (home-page "https://github.com/PyCQA/isort")
    (synopsis "Python utility/library to sort python imports")
    (description
     "@code{python-isort} is a python utility/library to sort imports
alphabetically, and automatically separated into sections.  It provides a
command line utility, a python library and plugins for various editors.")
    (license license:expat)))

(define-public python-configparser
  (package
    (name "python-configparser")
    (version "7.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "configparser" version))
       (sha256
        (base32 "0w3vichm4igwvh7r560rw58xi4s1yf9x1cyi6syszqqnx65cqadn"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-setuptools-scm
           python-wheel))
    (home-page "https://github.com/jaraco/configparser/")
    (synopsis "Backport of configparser from python 3.5")
    (description "@code{python-configparser} is a backport of
     @code{configparser} from Python 3.5 so that it can be used directly
     in other versions.")
    (license license:expat)))

(define-public python-iniconfig
  (package
    (name "python-iniconfig")
    (version "2.1.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "iniconfig" version))
       (sha256
        (base32 "1iz1fg3n6pv4q8jzv1q0izl5001diwqggizrg3p3ywrn1gix5frs"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))      ;no tests in PyPI, tests introduce cycle with pytest
    (native-inputs
     (list python-hatch-vcs
           python-hatchling))
    (home-page "https://github.com/RonnyPfannschmidt/iniconfig")
    (synopsis "Simple INI-file parser")
    (description "The @code{iniconfig} package provides a small and simple
     INI-file parser module having a unique set of features ; @code{iniconfig}
     @itemize
     @item maintains the order of sections and entries              ;
     @item supports multi-line values with or without line-continuations ;
     @item supports \"#\" comments everywhere                            ;
     @item raises errors with proper line-numbers                        ;
     @item raises an error when two sections have the same name.
     @end itemize")
    (license license:expat)))

(define-public python-mando
  (package
    (name "python-mando")
    (version "0.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "mando" version))
       (sha256
        (base32 "1ddn4h1fvc9f8z2p8l88jyazxnp0h7rmh711i2hwkipxlbcmk5jk"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://mando.readthedocs.org/")
    (synopsis "Wrapper around argparse, allowing creation of complete CLI applications")
    (description
     "This package is a wrapper around argparse, allowing you to write complete CLI
applications in seconds while maintaining all the flexibility.")
    (license license:expat)))

(define-public python-mwclient
  (package
    (name "python-mwclient")
    (version "0.11.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/mwclient/mwclient")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14kg353vzrwh7zks7zsza4hfb2n5vxprh9hnw4rjsimm8509axda"))))
    (build-system pyproject-build-system)
    (propagated-inputs
     (list python-requests-oauthlib))
    (native-inputs
     (list python-mock
           python-pytest
           python-pytest-cov
           python-responses
           python-setuptools))
    (home-page "https://github.com/btongminh/mwclient")
    (synopsis "MediaWiki API client")
    (description "This package provides a MediaWiki API client.")
    (license license:expat)))

(define-public python-kneed
  (package
    (name "python-kneed")
    (version "0.8.5")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/arvkevi/kneed")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0kcglaql1nqvjv5q62myybznii1n1akln5yacp63rg8xv7l0zad1"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--ignore=tests/test_no_matplotlib.py")))
    (native-inputs (list python-hatchling python-pytest python-pytest-cov))
    (propagated-inputs (list python-matplotlib python-numpy python-scipy))
    (home-page "https://github.com/arvkevi/kneed")
    (synopsis "Knee-point detection in Python")
    (description
     "This package implements the kneedle algorithm.  Given a set of x and y
values, kneed will return the knee point of the function.  The knee point is
the point of maximum curvature.")
    (license license:bsd-3)))

(define-public python-diff-cover
  (package
    (name "python-diff-cover")
    (version "9.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "diff_cover" version))
       (sha256
        (base32 "0j1m8rfs080zsil516pvr0hy3x24dny4c77ilzfjgp5pcjy7hfx0"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Dropp check of flake8 in tests.
      #~(list "-k" "not test_file_does_not_exist")))
    (native-inputs
     (list python-pycodestyle
           python-poetry-core
           python-pyflakes
           python-pylint
           python-pytest
           python-pytest-datadir
           python-pytest-mock))
    (propagated-inputs
     (list python-chardet
           python-jinja2
           python-pluggy
           python-pygments
           python-setuptools ; For pkg_resources.
           python-tomli))
    (home-page "https://github.com/Bachmann1234/diff_cover")
    (synopsis "Run coverage and linting reports on diffs")
    (description
     "Automatically find diff lines that need test coverage.  It also finds
diff lines that have violations (according to tools such as pycodestyle,
pyflakes, flake8, or pylint).  This is used as a code quality metric during
code reviews.")
    (license license:asl2.0)))

(define-public python-diff-match-patch
  (package
    (name "python-diff-match-patch")
    (version "20241021")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "diff_match_patch" version))
        (sha256
         (base32
          "0wshhdnxvb7l45pjrj1fhrhvh7b6p1l2kvim559q9054kylmgbmy"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-flit-core python-pytest))
    (home-page "https://github.com/diff-match-patch-python/diff-match-patch")
    (synopsis "Synchronize plain text")
    (description "Diff Match and Patch libraries offer robust algorithms to
     perform the operations required for synchronizing plain text.")
    (license license:asl2.0)))

(define-public python-icdiff
  (package
    (name "python-icdiff")
    (version "2.0.7")
    (source (origin
              (method git-fetch)
              (uri (git-reference
                    (url "https://github.com/jeffkaufman/icdiff")
                    (commit (string-append "release-" version))))
              (file-name (git-file-name name version))
              (sha256
               (base32
                "0kwgglbnpvsv5qb59yl0pvihr1ca5m8l6cq8hjski5y62g33zv2w"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ; there are no test scripts
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://www.jefftk.com/icdiff")
    (synopsis "Improved colored diff")
    (description "This package provides colored diff functions that highlight
parts of the lines that were modified.")
    (license license:psfl)))

(define-public python-dirsync
  (package
    (name "python-dirsync")
    (version "2.2.6")
    (source
      (origin
        (method url-fetch)
        (uri (pypi-uri "dirsync" version))
        (sha256
         (base32
          "1g3h0lva0mgmm4i5z62h8jkv9y1mp5xlvl2w2nfa3galbgn5gdak"))))
    (build-system pyproject-build-system)
    (arguments
     ;; No tests in PyPI release and GitHub repository does not have the
     ;; latest release tag.
     (list #:tests? #f))
    (native-inputs (list python-setuptools python-wheel))
    (home-page "https://github.com/tkhyn/dirsync")
    (synopsis "Advanced directory tree synchronisation tool")
    (description
     "Dirsync is an advanced directory tree synchronisation tool.")
    (license license:expat)))

(define-public python-levenshtein
  (package
    (name "python-levenshtein")
    (version "0.27.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rapidfuzz/Levenshtein")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1khr1vjmrwakjfdsb22k508h3g8awjp0yb398ca8n1xanwzk4l8h"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-rapidfuzz))
    (native-inputs
     (list cmake-minimal
           python-cython
           python-pytest
           python-scikit-build-core
           python-setuptools
           rapidfuzz-cpp))
    (home-page "https://github.com/rapidfuzz/Levenshtein")
    (synopsis "Fast computation of Levenshtein distance and string similarity")
    (description
     "The Levenshtein Python C extension module contains functions for fast computation of
@enumerate
@item Levenshtein (edit) distance, and edit operations
@item string similarity
@item approximate median strings, and generally string averaging
@item string sequence and set similarity
@end enumerate
It supports both normal and Unicode strings.")
    (license license:gpl2+)))

(define-public python-factory-boy
  (package
    (name "python-factory-boy")
    (version "3.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "factory_boy" version))
       (sha256
        (base32 "00rx3v5y5l03vlkq6xqj4r7zbnlrx23h45mlyb3zm38j4v964s46"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Tests are not included in the tarball.
     `(#:tests? #f))
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-faker))
    (home-page "https://github.com/FactoryBoy/factory_boy")
    (synopsis "Versatile test fixtures replacement")
    (description "Factory_boy is a fixtures replacement based on thoughtbot’s
factory_girl.  As a fixtures replacement tool, it aims to replace static, hard
to maintain fixtures with easy-to-use factories for complex object.  Instead
of building an exhaustive test setup with every possible combination of corner
cases, factory_boy allows you to use objects customized for the current test,
while only declaring the test-specific fields.")
    (license license:expat)))

(define-public python-gtts
  (package
    (name "python-gtts")
    (version "2.3.1")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "gTTS" version))
              (sha256
               (base32
                "1jsg1prpzr7gj5sn385mkv2v1i8xfc83ycm87hvsi2j0y366plps"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Disable tests that require internet.
     (list #:test-flags '(list "-k" "not net")))
    (native-inputs
     (list python-pytest python-testfixtures python-click python-requests
           python-setuptools python-wheel))
    (home-page "https://github.com/pndurette/gTTS")
    (synopsis "Google Translate text-to-speech interface")
    (description
     "Google Text-to-Speech (gTTS) is a Python library and CLI tool to
interface with the Google Translate text-to-speech API.  It lets you write
spoken MP3 data to a file, a file-like object (bytestring) for further audio
manipulation, or @code{stdout}.")
    (license license:expat)))

(define-public python-packaging
  (package/inherit python-packaging-bootstrap
    (name "python-packaging")
    (arguments
     `(#:phases (modify-phases %standard-phases
                  (replace 'check
                    (lambda* (#:key tests? #:allow-other-keys)
                      (if tests?
                          (invoke "pytest" "-vv")
                          (format #t "test suite not run~%")))))))
    (native-inputs
     (list python-flit-core
           python-pretend python-pytest))
    (propagated-inputs (list python-pyparsing python-six))
    (home-page "https://github.com/pypa/packaging")
    (synopsis "Core utilities for Python packages")
    (description "Packaging is a Python module for dealing with Python packages.
     It offers an interface for working with package versions, names, and dependency
     information.")
    ;; From 'LICENSE': This software is made available under the terms of
    ;; *either* of the licenses found in LICENSE.APACHE or LICENSE.BSD.
    ;; Contributions to this software is made under the terms of *both* these
    ;; licenses.
    (license (list license:asl2.0 license:bsd-2))))

(define-public python-packaging-legacy
  (package
    (name "python-packaging-legacy")
    (version "23.0.post0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "packaging_legacy" version))
       (sha256
        (base32 "1nyryxlc7fd4c0jmfp99az1s61vfv5xbi6017wqi4wd7j4ia8x69"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-packaging))
    (native-inputs
     (list python-pretend
           python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://pypi.org/project/packaging-legacy/")
    (synopsis "Core utilities for legacy Python packages")
    (description "This library provides support for legacy Python Packaging
functionality removed from @code{packaging}.")
    (license license:asl2.0)))

(define-public python-relatorio
  (package
    (name "python-relatorio")
    (version "0.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "relatorio" version))
       (sha256
        (base32 "0qa8f9xvvc60i41vpf386jqx65379dnn9xpjwp8zaibba5raz83v"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-genshi
           python-lxml
           python-magic))
    (home-page "https://relatorio.tryton.org/")
    (synopsis "Templating library able to output ODT and PDF files")
    (description
     "Relatorio is a templating library which provides a way to easily output
ODT, ODS, PNG, SVG and several other kinds of files.  Support for more
filetypes can be easily added by creating plugins for them.")
    (license license:gpl3+)))

(define-public python-radon
  (package
    (name "python-radon")
    (version "6.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/rubik/radon")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "01n3idnrglgbjgwvvgs7yg9amjda3zs2659sp2zqpllp9gva73y9"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'relax-requirements
            (lambda _
              (substitute* (list "pyproject.toml" "requirements.txt")
                (("(mando.*>=0\\.6),<0\\.8" _ mando-lower-bound)
                 mando-lower-bound)))))))
    (propagated-inputs (list python-colorama python-mando))
    (native-inputs (list python-poetry-core python-pytest python-pytest-mock
                         python-setuptools))
    (home-page "https://radon.readthedocs.org/")
    (synopsis "Code Metrics in Python")
    (description
     "Radon is a Python tool which computes various code metrics. Supported
metrics are:
@itemize @bullet
@item raw metrics: SLOC, comment lines, blank lines, &c.
@item Cyclomatic Complexity (i.e., McCabe’s Complexity)
@item Halstead metrics (all of them)
@item the Maintainability Index (a Visual Studio metric)
@end itemize")
    (license license:expat)))

(define-public python-rgbxy
  (package
    (name "python-rgbxy")
    (version "0.5")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rgbxy" version))
       (sha256
        (base32 "0c3dgm1rf7ih79pgkj7adffn8hlyqh5qah8rbzlq436kz3srk83q"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f)) ;no tests in PyPI or Git
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/benknight/hue-python-rgb-converter")
    (synopsis "RGB conversion tool in Python")
    (description
     "This package implements functionality of RGB/CIE1931 'xy' gammuts
conversion: Gamut A, B, and C.")
    (license license:expat)))

(define-public python-jsonpointer
  (package
    (name "python-jsonpointer")
    (version "3.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "jsonpointer" version))
       (sha256
        (base32 "1vsrmwrbix3bnxf71g1zyil0pxkh33hq47xkqdhjslli42gp4b9b"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs
     (list python-setuptools
           python-wheel))
    (home-page "https://github.com/stefankoegl/python-json-pointer")
    (synopsis "Identify specific nodes in a JSON document")
    (description "@code{jsonpointer} allows you to access specific nodes
     by path in a JSON document (see RFC 6901).")
    (license license:bsd-3)))

(define-public python-jsonpatch
  (package
    (name "python-jsonpatch")
    (version "1.33")
    (source
     (origin
       (method git-fetch)
       ;; pypi version lacks tests.js
       (uri (git-reference
              (url "https://github.com/stefankoegl/python-json-patch")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0qidj3vrklygsid40y6qgxclssd85hbxnic1av833iy4hbml2w14"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'custom
           #:test-flags #~(list "tests.py")))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-jsonpointer))
    (home-page "https://github.com/stefankoegl/python-json-patch")
    (synopsis "Applying JSON Patches in Python 2.6+ and 3.x")
    (description "@code{jsonpatch} is a library and program that allows
     applying JSON Patches according to RFC 6902.")
    (license license:bsd-3)))

(define-public python-rfc3986
  (package
    (name "python-rfc3986")
    (version "2.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rfc3986" version))
       (sha256
        (base32 "0716rg74cpmhi9f77ypnwcdsyfjplsgk1rnnmadq5zabpnfwzalp"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-setuptools))
    (home-page "https://rfc3986.readthedocs.io/")
    (synopsis "Parse and validate URI references")
    (description
     "@code{rfc3986} is a Python implementation of RFC@tie{}3986 including
validation and authority parsing.  This module also supports RFC@tie{}6874
which adds support for zone identifiers to IPv6 addresses.")
    (license license:asl2.0)))

(define-public python-rfc3986-validator
  (package
    (name "python-rfc3986-validator")
    (version "0.1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rfc3986_validator" version))
       (sha256
        (base32 "0mfh82r37ma5n54n8ibnqvmwr3j3f2ixqfjfmv1rwfqvjbkvsi1x"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-rfc3987
           python-setuptools))
    (home-page "https://github.com/naimetti/rfc3986-validator")
    (synopsis "Pure python rfc3986 validator")
    (description "This package implements a URI validator according to RFC3986
in pure Python.")
    (license license:expat)))

(define-public python-rfc3987
  (package
    (name "python-rfc3987")
    (version "1.3.8")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "rfc3987" version))
      (sha256
       (base32
        "0cx7bhyjaylwnf9armxrkb3r0s37vf0vqf3bhbll9mb0lmbx5i6k"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'custom
           #:test-flags #~(list "-m" "doctest" "rfc3987.py")))
    (native-inputs
     (list python-setuptools))
    ;; Source: <https://codeberg.org/atufi/rfc3987>.
    (home-page "https://pypi.org/project/rfc3987/")
    (synopsis "Parsing and validation of URIs (RFC 3986) and IRIs (RFC 3987)")
    (description "@code{rfc3987} provides routines for parsing and
     validation of URIs (see RFC 3986) and IRIs (see RFC 3987).")
    (license license:gpl3+)))

;; The latest commit contains fixes for building with both python3 and python2.
(define-public python-rfc6555
  (package
    (name "python-rfc6555")
    (version "0.1.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/sethmlarson/rfc6555")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0cynzrs3l6ywmkpcpx9m36604dav64sk3rk1s12hj49qqyx20v1f"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      ;; Other tests require network access.
      #:test-flags #~(list "tests/test_ipv6.py")))
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://pypi.org/project/rfc6555/")
    (synopsis "Python implementation of RFC 6555")
    (description
     "Python implementation of the Happy Eyeballs Algorithm described in RFC
6555.  Provided with a single file and dead-simple API to allow easy vendoring
and integration into other projects.")
    (license license:asl2.0)))

(define-public python-sacn
  (package
    (name "python-sacn")
    (version "1.11.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "sacn" version))
       (sha256
        (base32 "1sp0jmrjsd9g62kgi177fw4hi56h21s2p9khia3idmixgz53k2ql"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/Hundemeier/sacn")
    (synopsis "Python library for sending and receiving sACN data")
    (description
     "This package provides a Python library for sending and receiving
     sACN (Streaming Architecture for Control Networks) data, a standard
     protocol used for controlling lighting and other devices over
     a network.")
    (license license:expat)))

(define-public python-bagit
  (package
    (name "python-bagit")
    (version "1.9.0")
    (source
      (origin
        (method git-fetch) ; no tests in PyPI
        (uri (git-reference
               (url "https://github.com/LibraryOfCongress/bagit-python")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "12qfqha70vhc8pclq0kzv7xk0i44ramnlkphybv7419vdl4aay40"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           #~(modify-phases %standard-phases
               (add-before 'build 'pretend-version
                 (lambda _
                   (setenv "SETUPTOOLS_SCM_PRETEND_VERSION"
                           #$(package-version this-package))))
               (replace 'check
                 (lambda* (#:key tests? #:allow-other-keys)
                   (when tests?
                     (invoke "pytest" "-vv" "test.py")))))))
    (native-inputs
     (list python-pytest python-setuptools python-setuptools-scm python-wheel))
    (home-page "https://libraryofcongress.github.io/bagit-python/")
    (synopsis "Create and validate BagIt packages")
    (description "Bagit is a Python library and command line utility for working
     with BagIt style packages.  BagIt is a minimalist packaging format for digital
     preservation.")
    (license license:cc0)))

(define-public python-prov
  (package
    (name "python-prov")
    (version "2.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/trungdong/prov")
              (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "14y58x4gqc4lyhgy6iamzxamwj02sqf2bkma6p5ddiqsnilc4wx7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags #~(list "discover" "-s" "src")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'disable-tests
            (lambda _
              ;; prov.model.ProvException: The provided identifier
              ;; "http://www.example.org/bundle" is not valid
              (substitute* "src/prov/tests/qnames.py"
                (("test_namespace_inheritance")
                 "disabled_test_namespace_inheritance")
                (("test_default_namespace_inheritance")
                 "disabled_test_default_namespace_inheritance")))))))
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list graphviz
           python-dateutil
           python-networkx
           python-pydot
           ;; optional dependencies, also needed for tests
           python-lxml
           python-rdflib))
    (home-page "https://github.com/trungdong/prov")
    (synopsis
     "W3C Provenance Data Model supporting PROV-JSON, PROV-XML and PROV-O (RDF)")
    (description
     "This package provides a library for W3C Provenance Data Model supporting
     PROV-O (RDF), PROV-XML, PROV-JSON import/export.")
    (license license:expat)))

(define-public python-arcp
  (package
    (name "python-arcp")
    (version "0.2.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/stain/arcp-py")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1wjygci60nmcdrgrhb0vwqmhspzdv3g69x2b92vjxq709ifrpgqp"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://arcp.readthedocs.io/")
    (synopsis "Archive and Package URI parser and generator")
    (description
     "@acronym{arcp, Archive and Package} provides functions for creating
@code{arcp_} URIs, which can be used for identifying or parsing hypermedia
files packaged in an archive or package, like a ZIP file.  arcp URIs can be
used to consume or reference hypermedia resources bundled inside a file
archive or an application package, as well as to resolve URIs for archive
resources within a programmatic framework.  This URI scheme provides
mechanisms to generate a unique base URI to represent the root of the archive,
so that relative URI references in a bundled resource can be resolved within
the archive without having to extract the archive content on the local file
system.  An arcp URI can be used for purposes of isolation (e.g. when
consuming multiple archives), security constraints (avoiding \"climb out\"
from the archive), or for externally identiyfing sub-resources referenced by
hypermedia formats.")
    (license license:asl2.0)))

(define-public python-shellescape
  (package
    (name "python-shellescape")
    (version "3.8.1")
    (source
      (origin
        (method git-fetch)
        (uri (git-reference
               (url "https://github.com/chrissimpkins/shellescape")
               (commit (string-append "v" version))))
        (file-name (git-file-name name version))
        (sha256
         (base32
          "0wzccxk139qx1lb2g70f5b2yh9zq15nr2mgvqdbfabg5zm0vf1qw"))))
    (build-system python-build-system)
    (arguments
     '(#:phases
       (modify-phases %standard-phases
         (replace 'check
           (lambda* (#:key tests? inputs outputs #:allow-other-keys)
             (when tests?
               (add-installed-pythonpath inputs outputs)
               (invoke "python" "tests/test_shellescape.py"))
             #t)))))
    (native-inputs
     (list python-pytest))
    (home-page "https://github.com/chrissimpkins/shellescape")
    (synopsis
     "Shell escape a string to safely use it as a token in a shell command")
    (description
     "The shellescape Python module defines the @code{shellescape.quote()}
     function that returns a shell-escaped version of a Python string.  This is a
     backport of the @code{shlex.quote()} function from Python 3.8 that makes it
     accessible to users of Python 3 versions < 3.3 and all Python 2.x versions.")
    (license license:expat)))

;; XXX: Project has no updates since 2019, consider to remove when nothing
;; depends on it in the next refresh cycle.
;; See: <https://github.com/pipermerriam/flex/issues/237>.
(define-public python-flex
  (package
    (name "python-flex")
    (version "6.14.1")
    (source
     (origin
      (method url-fetch)
      (uri (pypi-uri "flex" version))
      (sha256
       (base32
        "1sr91f5sqywj4040jm3cq4333fp8hbmmr7v6v05a3h0sgyixcbi9"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f)) ;no tests in PyPI archive
    (native-inputs
     (list python-setuptools))
    (propagated-inputs
     (list python-click
           python-jsonpointer
           python-pyyaml
           python-requests
           python-rfc3987
           python-six
           python-strict-rfc3339
           python-validate-email))
    (home-page "https://github.com/pipermerriam/flex")
    (synopsis "Validates Swagger schemata")
    (description "@code{flex} can be used to validate Swagger schemata.")
    (license license:bsd-3)))

(define-public python-marshmallow
  (package
    (name "python-marshmallow")
    (version "4.0.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "marshmallow" version))
       (sha256
        (base32 "0mcd5aqs33hijapnj2a3g580pfaghp8h3vcpzdf979wrqam80viv"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'set-check-environment
            (lambda* (#:key inputs #:allow-other-keys)
              (setenv "TZ" "UTC")
              (setenv "TZDIR"
                      (search-input-directory inputs
                                              "share/zoneinfo")))))))
    (native-inputs
     (list python-flit-core
           python-pytest
           python-simplejson
           tzdata-for-tests))
    (home-page "https://github.com/marshmallow-code/marshmallow")
    (synopsis "Convert complex datatypes to and from native Python datatypes")
    (description
     "@code{marshmallow} provides a library for converting complex datatypes
to and from native Python datatypes.")
    (license license:expat)))

(define-public python-marshmallow-3
  (package
    (inherit python-marshmallow)
    (version "3.22.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "marshmallow" version))
       (sha256
        (base32 "0gl2qmq5sqf1b3f84zd7yzkznaknr6j5lnbxcfw0n8ja20lzawj9"))))
    (arguments '())
    (native-inputs
     (list python-pytest
           python-pytz
           python-simplejson
           python-flit-core))
    (propagated-inputs
     (list python-packaging))))


;; XXX: Deprecated upstream: This repository has been archived by the owner on
;; Jun 6, 2024. It is now read-only.
;; Consider to remove when nothing is depend on it.
(define-public python-marshmallow-jsonapi
  (package
    (name "python-marshmallow-jsonapi")
    (version "0.24.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "marshmallow-jsonapi" version))
       (sha256
        (base32 "1d9pxcgmln4gls99vwj1h24qv0lz7fb2jqmqrsiv1pid1snc125x"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-faker
           python-flask
           python-pytest
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-marshmallow))
    (home-page "https://github.com/marshmallow-code/marshmallow-jsonapi")
    (synopsis "JSON:API 1.0 formatting with Marshmallow")
    (description
     "The marshmallow-jsonapi package provides a simple way to produce
@uref{https://jsonapi.org, JSON:API}-compliant data in any Python Web
framework.  It includes optional utilities to integrate with Flask.")
    (license license:expat)))

(define-public python-apispec
  (package
    (name "python-apispec")
    (version "6.8.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "apispec" version))
       (sha256
        (base32 "09lza66036a3i1blwrc6qpvw48pzflmabhd0dfshq9ghzjwnjnyf"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-flit-core
           python-openapi-spec-validator
           python-pytest))
    (propagated-inputs
     (list python-marshmallow
           python-packaging
           python-pyyaml))
    (home-page "https://github.com/marshmallow-code/apispec")
    (synopsis "Swagger/OpenAPI specification generator")
    (description
     "@code{python-apispec} is a pluggable API specification generator.  It
currently supports the OpenAPI specification, formerly known as Swagger.")
    (license license:expat)))

(define-public python-apispec-webframeworks
  (package
    (name "python-apispec-webframeworks")
    (version "1.2.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "apispec_webframeworks" version))
       (sha256
        (base32 "10gxjwmk8w67b7vcivcky4hrpv1gx8acrshnyp1169va4s62i2an"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-aiohttp
           python-flit-core
           python-bottle
           python-flask
           python-pytest
           python-pyyaml
           python-tornado
           python-wheel))
    (propagated-inputs
     (list python-apispec))
    (home-page "https://github.com/marshmallow-code/apispec-webframeworks")
    (synopsis "Web framework plugins for apispec")
    (description "This package provides plugins for using @code{apispec} with
web frameworks.")
    (license license:expat)))

(define-public python-flasgger
  (package
    (name "python-flasgger")
    (version "0.9.7.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/rochacbruno/flasgger")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "08dnn19swfa5lsscj38hil41b3xnqvwgwnx9q2vg9kv26bs1zcah"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore=tests/test_examples.py"
              "-k" "not test_swag")))
    (propagated-inputs
     (list python-flask
           python-pyyaml
           python-jsonschema
           python-mistune
           python-six))
    (native-inputs
     (list python-pytest
           python-setuptools))
    (home-page "https://github.com/rochacbruno/flasgger/")
    (synopsis "Extract Swagger specs from your Flask project")
    (description "@code{python-flasgger} allows extracting Swagger specs
     from your Flask project.  It is a fork of Flask-Swagger.")
    (license license:expat)))

(define-public python-apache-libcloud
  (package
    (name "python-apache-libcloud")
    (version "3.8.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "apache-libcloud" version))
       (sha256
        (base32 "14bc4z246ka0h6kywpxqdfgb2c5y6lfclpx99ki2bhiv285lrgvm"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f ; XXX: all tests fail requiring additional credentials
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'patch-ssh
            (lambda* (#:key inputs #:allow-other-keys)
              (substitute* "libcloud/compute/ssh.py"
                (("'ssh'")
                 (format #f "~s" (search-input-file inputs "/bin/ssh"))))))
          (add-after 'unpack 'patch-tests
            (lambda _
              (substitute* "libcloud/test/compute/test_ssh_client.py"
                (("^class ShellOutSSHClientTests")
                 "@unittest.skip(\"Guix container doesn't have ssh service\")
class ShellOutSSHClientTests"))))
          (add-before 'check 'copy-secret
            (lambda _
              (copy-file "libcloud/test/secrets.py-dist"
                         "libcloud/test/secrets.py"))))))
    (inputs
     (list openssh))
    (propagated-inputs
     (list python-requests))
    (native-inputs
     (list python-pytest python-requests-mock python-setuptools))
    (home-page "https://libcloud.apache.org/")
    (synopsis "Unified Cloud API")
    (description
     "@code{libcloud} is a Python library for interacting with many of the
popular cloud service providers using a unified API.")
    (license license:asl2.0)))

(define-public python-smmap
  (package
    (name "python-smmap")
    (version "5.0.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "smmap" version))
       (sha256
        (base32 "1mcai5vf9bgz389y4sqgj6w22wn7zmc7m33y3j50ryjq76h6bsi6"))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://github.com/Byron/smmap")
    (synopsis "Python sliding window memory map manager")
    (description "@code{smmap} is a pure Python implementation of a sliding
     window memory map manager.")
    (license license:bsd-3)))

(define-public python-regex
  (package
    (name "python-regex")
    (version "2024.11.6")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "regex" version))
       (sha256
        (base32 "06amb1sxhbab03cy73q7wcp131bsingngr44r0rh6an5cfq5kcbs"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-backend #~'unittest))
    (native-inputs
     (list python-setuptools))
    (home-page "https://bitbucket.org/mrabarnett/mrab-regex")
    (synopsis "Alternative regular expression module")
    (description
     "This regular expression implementation is backwards-compatible with the
standard @code{re} module, but offers additional functionality like full
case-folding for case-insensitive matches in Unicode.")
    (license license:psfl)))

(define-public python-pysocks
  (package
    (name "python-pysocks")
    (version "1.7.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "PySocks" version))
       (sha256
        (base32
         "184sg65mbmih6ljblfsxcmq5js5l7dj3gpn618w9q5dy3rbh921z"))))
    (build-system pyproject-build-system)
    (arguments `(#:tests? #f))
    (native-inputs
     (list python-setuptools))
    (home-page "https://github.com/Anorov/PySocks")
    (synopsis "SOCKS client module")
    (description "@code{pysocks} is an updated and semi-actively maintained
version of @code{SocksiPy} with bug fixes and extra features.")
    (license license:bsd-3)))

(define-public python-pydub
  (package
    (name "python-pydub")
    (version "0.25.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/jiaaro/pydub")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0xskllq66wqndjfmvp58k26cv3w480sqsil6ifwp4gghir7hqc8m"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend ''unittest
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-ffmpeg-path
            (lambda* (#:key inputs #:allow-other-keys)
              (let ((bin (dirname (search-input-file inputs "bin/ffmpeg"))))
                (substitute* "pydub/utils.py"
                  (("return \"ffmpeg\"")
                   (string-append "return \"" bin "/ffmpeg\""))
                  (("return \"ffplay\"")
                   (string-append "return \"" bin "/ffplay\""))
                  (("return \"ffprobe\"")
                   (string-append "return \"" bin "/ffprobe\""))
                  (("warn\\(\"Couldn't find ff")
                   "# warn\\(\"Couldn't find ff"))))))))
    (native-inputs (list python-setuptools))
    (home-page "https://pydub.com")
    (inputs (list ffmpeg))
    (propagated-inputs (list python-scipy))
    (synopsis "Manipulate audio with a high level interface in Python")
    (description
     "@code{pydub} makes it easy to manipulate audio in Python.  It relies on
@code{ffmpeg} to open various audio formats.")
    (license license:expat))) ; MIT license

(define-public python-pkginfo
  (package
    (name "python-pkginfo")
    (version "1.12.1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pkginfo" version))
       (sha256
        (base32
          "0ysbl0rhy8chvx58zi5qb61jli76dcyblklnc0118vy39a15gnaw"))))
    (build-system pyproject-build-system)
    (arguments
     ;; Wheel metatda version mismatched: AssertionError: assert '2.4' == '2.3'
     (list #:test-flags #~(list "-k" "not test_installed_ctor_w_dist_info")))
    (native-inputs
     (list python-pytest
           python-setuptools
           python-wheel))
    (home-page "https://code.launchpad.net/~tseaver/pkginfo/trunk")
    (synopsis "Query metadatdata from sdists, bdists, and installed packages")
    (description
     "API to query the distutils metadata written in @file{PKG-INFO} inside a
source distriubtion (an sdist) or a binary distribution (e.g., created by
running bdist_egg).  It can also query the EGG-INFO directory of an installed
distribution, and the *.egg-info stored in a \"development checkout\" (e.g,
created by running @code{python setup.py develop}).")
    (license license:expat)))

;; XXX: This project was archived by the owner on Oct 4, 2023. It is now
;; read-only.  Consider to remvoe when nothing depends on it.
(define-public python-ratelimiter
  ;; From https://github.com/RazerM/ratelimiter/pull/11
  (let ((commit "59a0827c434706d62b89e16a220e4ae12e618858")
        (revision "0"))
  (package
    (name "python-ratelimiter")
    (version (git-version "1.2.0.post1" revision commit))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/RazerM/ratelimiter")
             (commit commit)))
       (sha256
        (base32
         "1v34w12f41j0l2gy9ji9ip01kj4idjfjx7a97wrlr1ibxi7hg3bs"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:phases
           '(modify-phases %standard-phases
              (add-after 'unpack 'pytest-compatibility
                (lambda _
                  (substitute* "tests/conftest.py"
                    (("pytest.collect.File") "pytest.File")))))))
    (native-inputs
     (list python-pytest
           python-pytest-asyncio-0.26
           python-setuptools))
    (home-page "https://github.com/RazerM/ratelimiter")
    (synopsis "Simple rate limiting object")
    (description
     "The @code{ratelimiter} module ensures that an operation will not be
executed more than a given number of times during a given period.")
    (license license:asl2.0))))

(define-public python-rbfly
  (package
    (name "python-rbfly")
    (version "0.10.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "rbfly" version))
       (sha256
        (base32 "019fs94qzbxb43vahcm0va53m5d4nxrib5pkl29m4hx9adcccpf6"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags #~(list "--pyargs" "rbfly")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'fix-pytest-config
            (lambda _
              ;; Drop test coverage requirements.
              (substitute* "pyproject.toml"
                ((".*addopts.*") "")))))))
    (native-inputs
     (list python-cython
           python-pytest
           python-pytest-asyncio
           python-pytest-timeout
           python-setuptools
           python-wheel))
    (home-page "https://wrobell.dcmod.org/rbfly/")
    (synopsis "Work with RabbitMQ Streams in Python")
    (description
     "This package implements a functionality to deal with
@url{https://www.rabbitmq.com/streams.html, RabbitMQ Streams} using
@url{https://docs.python.org/3/library/asyncio.html, @code{asyncio}}.

It is designed and implemented with the following qualities in mind:
@itemize
@item asynchronous Pythonic API with type annotations
@item use of
@url{https://en.wikipedia.org/wiki/Advanced_Message_Queuing_Protocol, AMQP}
1.0 message format to enable interoperability between RabbitMQ Stream. clients
@item auto reconnection to RabbitMQ broker with lazily created connection
objects
@end itemize

Support of many RabbitMQ Streams broker features:
@itemize
@item publishing single messages, or in batches, with confirmation
@item subscribing to a stream at a specific point in time, from a specific
offset, or using offset reference
@item stream message filtering
@item writing stream offset reference
@item message deduplication
@item integration with AMQP 1.0 ecosystem at message format level
@end itemize")
    (license license:gpl3+)))

(define-public python-jsonrpclib-pelix
  (package
    (name "python-jsonrpclib-pelix")
    (version "0.3.2")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/tcalmant/jsonrpclib")
              (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1mhnqmgcplsxc4zygxy4hm99si7p2rpyl4bpmilzqc51k2r3khzl"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags #~(list "-k" "not test_multicall_success")))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/tcalmant/jsonrpclib")
    (synopsis "JSON-RPC 2.0 client library for Python")
    (description
     "This library implements the JSON-RPC v2.0 specification
(backwards-compatible) as a client library for Python.  This version is a fork
of jsonrpclib by Josh Marshall, usable with Pelix remote services.")
    (license license:asl2.0)))

(define-public python-setuptools-git
  ;; XXX: The project is abandoned since 2018, consider to remove in the next
  ;; refresh cycle.
  (package
    (name "python-setuptools-git")
    (version "1.2")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setuptools-git" version))
       (sha256
        (base32 "0i84qjwp5m0l9qagdjww2frdh63r37km1c48mrvbmaqsl1ni6r7z"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:tests? #f       ;no tests in PyPI
      #:phases
      #~(modify-phases %standard-phases
          ;; This is needed for tests.
          (add-after 'unpack 'configure-git
            (lambda _
              (setenv "HOME" "/tmp")
              (invoke "git" "config" "--global" "user.email" "guix")
              (invoke "git" "config" "--global" "user.name" "guix"))))))
    (native-inputs
     (list git-minimal/pinned python-setuptools python-wheel))
    (home-page "https://github.com/msabramo/setuptools-git")
    (synopsis "Setuptools revision control system plugin for Git")
    (description
     "This package provides a plugin for Setuptools for revision control with
Git.")
    (license license:bsd-3)))

(define-public python-setuptools-rust
  (package
    (name "python-setuptools-rust")
    (version "1.11.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "setuptools_rust" version))
       (sha256
        (base32 "1h3nbg1nlshzrqy7vz4q4g9wbz85dqkn6385p0ad7kjj48ww9avx"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;tests rquire Cargo
    (propagated-inputs
     (list python-semantic-version
           python-setuptools))
    (home-page "https://github.com/PyO3/setuptools-rust")
    (synopsis "Setuptools plugin for Rust extensions")
    (description
     "@code{setuptools-rust} is a plugin for @code{setuptools} to build
Rust Python extensions implemented with @code{PyO3} or @code{rust-cpython}.")
    (license license:expat)))

(define-public python-setuptools-gettext
  (package
    (name "python-setuptools-gettext")
    (version "0.1.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/breezy-team/setuptools-gettext")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1m6a3qjwvqbvlzwqap7050rqsxb7nwibl38iklnqz8363iclm76k"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-tomli python-setuptools))
    (home-page "https://github.com/breezy-team/setuptools-gettext")
    (synopsis "Setuptools plugin for gettext")
    (description "This package provides a plugin for Setuptools for gettext.")
    (license license:gpl2+)))

(define-public python-pyclibrary
  ;; XXX: https://github.com/MatthieuDartiailh/pyclibrary/issues/82
  (let ((commit "4e1e243a0bdfefa188d93ebdf3b60c6861244855")
        (revision "0"))
    (package
      (name "python-pyclibrary")
      (version (git-version "0.2.2" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
                (url "https://github.com/MatthieuDartiailh/pyclibrary")
                (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "1sza6n2fg8zml0v1s5zwzrlsb79s2abn1n4pr1l8r15al4g9z0c6"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'set-version
              (lambda _
                (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" "0.2.2"))))))
      (native-inputs
       (list python-pytest
             python-setuptools
             python-setuptools-scm))
      (propagated-inputs
       (list python-pyparsing))
      (home-page "https://github.com/MatthieuDartiailh/pyclibrary")
      (synopsis "Wrap dynamic libraries in Python")
      (description
       "This package helps wrapping dynamic libraries in Python.  It includes
a pure-Python C parser and an automation library that uses C header file
definitions to simplify the use of C bindings.")
      (license license:expat))))

(define-public python-pyclipper
  (package
    (name "python-pyclipper")
    (version "1.3.0.post6")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/greginvm/pyclipper")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1ijr7sx3203b3ppvsn1zyy8nfz93nbi60l8dxj2hdd6sj25g8q5k"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'set-version
            (lambda _
              (setenv "SETUPTOOLS_SCM_PRETEND_VERSION" #$version)))
          (add-before 'build 'cythonize-sources
            (lambda _
              (with-directory-excursion "src/pyclipper"
                (invoke "cython" "--cplus" "_pyclipper.pyx")))))))
    (native-inputs
     (list python-cython
           python-pytest
           python-setuptools
           python-setuptools-scm))
    (home-page "https://github.com/greginvm/pyclipper")
    (synopsis "Wrapper for Angus Johnson's Clipper library")
    (description
     "Pyclipper is a Cython wrapper for the C++ translation of the
Angus Johnson's polygon clipping Clipper library (ver. 6.4.2).")
    (license license:expat)))

(define-public python-semver
  (package
    (name "python-semver")
    (version "3.0.4")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "semver" version))
       (sha256
        (base32 "00lnb1mpppgq041kwcbg405rqsi2mzl8dw1s0c8hmvd5hk2xiixg"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-pytest-cov python-setuptools
                         python-wheel))
    (home-page "https://github.com/k-bx/python-semver")
    (synopsis "Python helper for Semantic Versioning")
    (description
     "This package provides a Python library for @url{Semantic Versioning,
http://semver.org/}.")
    (license license:bsd-3)))

(define-public python-pyro4
  (package
    (name "python-pyro4")
    (version "4.82")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "Pyro4" version))
       (sha256
        (base32 "1yr1rv2afmq55wb14sx9qplzkqw7fya9rprsqdyxfbg90h45n7si"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:test-flags
           #~(list "-k"
                   (string-join
                    ;; Those tests require network.
                    (list "testBCstart"
                          "testAutoClean"
                          "testDaemonPyroObj"
                          "testLookupAndRegister"
                          "testLookupInvalidHmac"
                          "testLookupUnixsockParsing"
                          "testMulti"
                          "testRefuseDottedNames"
                          "testResolve"
                          "testBCLookup0000"
                          "testPyroname"
                          "testResolveAsymmetricHmacUsage"
                          "testResolveWrongHmac"
                          "testStartNSfunc"
                          "testCustomDictClass"
                          "testDictClassFail"
                          "testBroadcast"
                          "testGetIP"
                          ;; XXX: Unclear why this test fails.
                          "testCustomClassFail")
                    " and not "))
           #:phases
           #~(modify-phases %standard-phases
               (replace 'check
                 (lambda* (#:key tests? test-flags #:allow-other-keys)
                   (if tests?
                       (apply invoke "python" "-m" "unittest" test-flags)
                       (format #t "test suite not run.~%")))))))
    (native-inputs
     (list python-cloudpickle
           python-dill
           python-msgpack
           python-setuptools
           python-wheel))
    (propagated-inputs
     (list python-serpent))
    (home-page "https://pyro4.readthedocs.io")
    (synopsis "Distributed object middleware for Python")
    (description
     "Pyro enables you to build applications in which objects can talk to each
other over the network.  You can just use normal Python method calls to call
objects on other machines, also known as remote procedure calls (RPC).")
    (license license:expat)))

(define-public python-phonenumbers
  (package
    (name "python-phonenumbers")
    (version "8.13.37")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/daviddrysdale/python-phonenumbers")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "1bgab6s7l2bqg671sns138c9qr9f8ndvjr4ig8l3ik9q054l9k9n"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags #~(list "-m" "testwrapper")
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'unpack 'chdir
            (lambda _
              (chdir "python"))))))
    (propagated-inputs (list python-protobuf))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/daviddrysdale/python-phonenumbers")
    (synopsis "Python library for dealing with international phone numbers")
    (description
     "This package provides a Python port of Google's libphonenumber library.")
    (license license:asl2.0)))

(define-public python-heapdict
  (package
    (name "python-heapdict")
    (version "1.0.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "HeapDict" version))
       (sha256
        (base32
         "1dnd7v9adqd21bf4ih2wzn9a7b41m0nccb0vbxny9n037rxzb5c4"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "http://stutzbachenterprises.com/")
    (synopsis "Heap with decrease-key and increase-key operations")
    (description
     "heapdict implements the MutableMapping ABC, meaning it works pretty much
like a regular Python @code{dict}.  It’s designed to be used as a priority
queue.")
    (license license:bsd-3)))

(define-public python-send2trash
  (package
    (name "python-send2trash")
    (version "1.8.2")
    (source
     (origin (method git-fetch)
             ;; Source tarball on PyPI doesn't include tests.
             (uri (git-reference
                   (url "https://github.com/arsenetar/send2trash")
                   (commit version)))
             (file-name (git-file-name name version))
             (sha256
              (base32
               "0dl9nv3h3kkcavwiswzg76pksqczq448gbdvlbz88bm71zvdshx7"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      '(modify-phases %standard-phases
         (add-before 'check 'pre-check
           (lambda _ (setenv "HOME" "/tmp"))))))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/arsenetar/send2trash")
    (synopsis "Send files to the user's @file{~/Trash} directory")
    (description "This package provides a Python library to send files to the
user's @file{~/Trash} directory.")
    (license license:bsd-3)))

(define-public python-pyfavicon
  (package
    (name "python-pyfavicon")
    (version "0.1.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/bilelmoussaoui/pyfavicon")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "04mx8vbi6j9l8daqa18sv0kkcyqv4wbc9z4ma77w68baq6ss0jzf"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'unittest
      #:test-flags
      #~(list "-k" (string-join (list
                                 ;; Socket name resolution fails.
                                 "not test_url_icon_link_type"
                                 "test_icon_sizes"
                                 ;; Tuples differ.
                                 "test_largest_icon")
                                " and not "))))
    (native-inputs (list python-setuptools))
    (propagated-inputs
     (list python-aiohttp python-beautifulsoup4 python-pillow))
    (home-page "https://github.com/bilelmoussaoui/pyfavicon")
    (synopsis "Async favicon fetcher")
    (description
     "@code{pyfavicon} is an async favicon fetcher.")
    (license license:expat)))

(define-public python-gyp
  ;; Google does not release versions.
  (let ((commit "1615ec326858f8c2bd8f30b3a86ea71830409ce4")
        (revision "2"))
    (package
      (name "python-gyp")
      (version (git-version "0.0.0" revision commit))
      (source
       (origin
         (method git-fetch)
         (uri (git-reference
               (url "https://chromium.googlesource.com/external/gyp")
               (commit commit)))
         (file-name (git-file-name name version))
         (sha256
          (base32 "02rnmw7k2r33x5nbb5xb8kk170hk0s1wmwfqpsx4cij1wbi4bqhk"))))
      (build-system pyproject-build-system)
      (arguments
       (list
        #:test-flags
        #~(list "--ignore-glob=test/win/**/*.py")
        #:phases
        #~(modify-phases %standard-phases
            (add-after 'unpack 'remove-six-requirements
              (lambda _
                (substitute* "pylib/gyp/generator/ninja.py"
                  (("six\\.ensure_binary\\(outputs\\[0\\]\\)")
                   "outputs[0].encode('utf-8')")
                  (("import six")
                   ""))
                (substitute* '("pylib/gyp/common.py"
                               "pylib/gyp/msvs_emulation.py"
                               "test/lib/TestGyp.py")
                  (("from six\\.moves import collections_abc")
                   "import collections")
                  (("collections_abc")
                   "collections.abc"))))
            (add-before 'check 'configure-tests
              (lambda _
                (setenv "PYTHONPATH"
                        (string-append (getcwd) "/test/lib:"
                                       (getenv "GUIX_PYTHONPATH"))))))))
      (native-inputs (list python-pytest python-setuptools))
      (home-page "https://gyp.gsrc.io/")
      (synopsis "GYP is a Meta-Build system")
      (description
       "GYP builds build systems for large, cross platform applications.
It can be used to generate XCode projects, Visual Studio projects, Ninja build
files, and Makefiles.")
      (license license:bsd-3))))

(define-public python-funcy
  (package
    (name "python-funcy")
    (version "1.11")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/Suor/funcy")
             (commit version)))
       (sha256
        (base32 "1s98vkjnq3zq71737hn8xa15kssvmy1sfzsll3vrlv53902418mw"))
       (file-name (git-file-name name version))))
    (build-system pyproject-build-system)
    (native-inputs
     (list python-pytest python-whatever python-setuptools python-wheel))
    (home-page "https://github.com/Suor/funcy")
    (synopsis "Functional tools")
    (description "@code{funcy} is a library that provides functional tools.
Examples are:
@enumerate
@item merge - Merges collections of the same type
@item walk - Type-preserving map
@item select - Selects a part of a collection
@item take - Takes the first n items of a collection
@item first - Takes the first item of a collection
@item remove - Predicated-removes items of a collection
@item concat - Concatenates two collections
@item flatten - Flattens a collection with subcollections
@item distinct - Returns only distinct items
@item split - Predicated-splits a collection
@item split_at - Splits a collection at a given item
@item group_by - Groups items by group
@item pairwise - Pairs off adjacent items
@item partial - Partially-applies a function
@item curry - Curries a function
@item compose - Composes functions
@item complement - Complements a predicate
@item all_fn - \"all\" with predicate
@end enumerate")
    (license license:bsd-3)))

(define-public python-funcy-1.14
  (package/inherit python-funcy
    (name "python-funcy")
    (version "1.14")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/Suor/funcy")
              (commit version)))
       (sha256
        (base32 "1chgi60z3c97m9l23vf5cpyp0nidkqlpxc55q5k5pz41ms3d0440"))
       (file-name (git-file-name name version))))))

(define-public python-isoweek
  (package
    (name "python-isoweek")
    (version "1.3.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "isoweek" version))
       (sha256
        (base32 "1s7zsf0pab0l9gn6456qadnz5i5h90hafcjwnhx5mq23qjxggwvk"))))
    (build-system pyproject-build-system)
    (arguments (list #:test-backend #~'unittest))
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/gisle/isoweek")
    (synopsis "Objects representing a week")
    (description "The @code{isoweek} module provide the class Week that
implements the week definition of ISO 8601.  This standard also defines
a notation for identifying weeks; yyyyWww (where the W is a literal).
Week instances stringify to this form.")
    (license license:bsd-3)))

(define-public bpython
  (package
    (name "bpython")
    (version "0.25")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "bpython" version))
       (sha256
        (base32 "0ny6cqhpil7z36djc4ixakri65kb1rdn3d4ckmpc5p7nks8gqin2"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      ;; Tests can't import curtsies, pygments and urwid.
      #~(list "-k" (string-join
                    (list "not test_issue108"
                          "test_issue133")
                    " and not " ))
      #:phases
      #~(modify-phases %standard-phases
          (add-after 'wrap 'add-aliases
            ;; For symmetry to bpython2, add symlinks bypthon3, bpdb3, etc.
            (lambda _
              (for-each
               (lambda (old new)
                 (symlink old (string-append #$output "/bin/" new)))
               '("bpython" "bpython-urwid" "bpdb")
               '("bpython3" "bpython3-urwid" "bpdb3")))))))
    (native-inputs
     (list python-mock
           python-pytest
           python-setuptools))
    (propagated-inputs
     (list python-curtsies
           python-cwcwidth
           python-greenlet
           python-pygments
           python-pyxdg
           python-requests
           ;; [optional]
           python-pyperclip
           python-jedi
           python-urwid-2
           python-watchdog))
    (home-page "https://bpython-interpreter.org/")
    (synopsis "Fancy interface to the Python interpreter")
    (description "Bpython is a fancy interface to the Python
interpreter. bpython's main features are

@enumerate
@item in-line syntax highlighting,
@item readline-like autocomplete with suggestions displayed as you type,
@item expected parameter list for any Python function,
@item \"rewind\" function to pop the last line of code from memory and
      re-evaluate,
@item send the code you've entered off to a pastebin,
@item save the code you've entered to a file, and
@item auto-indentation.
@end enumerate")
    (license license:expat)))

(define-public python-pyinotify
  (package
    (name "python-pyinotify")
    (version "0.9.6")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pyinotify" version))
              (sha256
               (base32
                "1x3i9wmzw33fpkis203alygfnrkcmq9w1aydcm887jh6frfqm6cw"))))
    (build-system python-build-system)
    (arguments `(#:tests? #f))          ;no tests
    (home-page "https://github.com/seb-m/pyinotify")
    (synopsis "Python library for monitoring inotify events")
    (description
     "@code{pyinotify} provides a Python interface for monitoring
file system events on Linux.")
    (license license:expat)))

(define-public python-more-itertools
  (package
    (name "python-more-itertools")
    (version "10.6.0")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "more-itertools" version))
       (sha256
        (base32
         "0fzfnfga0jdx217kff57lx3pam76162i0dd0nsgwqccw038zmmrc"))
       (snippet
        ;; distutils.errors.DistutilsOptionError: No configuration found for
        ;; dynamic 'description'. Some dynamic fields need to be specified via
        ;; `tool.setuptools.dynamic`others must be specified via the equivalent
        ;; attribute in `setup.py`.
        '(delete-file "setup.py"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:phases
      #~(modify-phases %standard-phases
          (replace 'check
            (lambda* (#:key tests? #:allow-other-keys)
              (when tests?
                (invoke "python" "-m" "unittest")))))))
    (native-inputs
     (list python-flit-core))
    (home-page "https://github.com/erikrose/more-itertools")
    (synopsis "More routines for operating on iterables, beyond itertools")
    (description "Python's built-in @code{itertools} module implements a
number of iterator building blocks inspired by constructs from APL, Haskell,
and SML.  @code{more-itertools} includes additional building blocks for
working with iterables.")
    (license license:expat)))

(define-public python-latexcodec
  (package
    (name "python-latexcodec")
    (version "3.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/mcmtroffaes/latexcodec/")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0j4hkn161h0hsx3ixs85dqnsaya27ck9c2ri1lv8cayc5a9kqvcp"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (home-page "https://readthedocs.org/projects/latexcodec/")
    (synopsis "Work with LaTeX code in Python")
    (description "Lexer and codec to work with LaTeX code in Python.")
    (license license:expat)))

(define-public python-pybloom-live
  (package
    (name "python-pybloom-live")
    (version "4.0.0")
    (source (origin
              (method url-fetch)
              (uri (pypi-uri "pybloom_live" version))
              (sha256
               (base32
                "040i6bjqvl33j30v865shsk30s3h7f16pqwiaj5kig857dfmqm4r"))))
    (build-system pyproject-build-system)
    (propagated-inputs (list python-bitarray python-xxhash))
    (native-inputs (list python-pytest python-setuptools python-wheel))
    (home-page "https://github.com/joseph-fox/python-bloomfilter")
    (synopsis "Bloom filter")
    (description "This package provides a scalable Bloom filter implemented in
Python.")
    (license license:expat)))

;; XXX: Not maintained since 2020.
(define-public python-pybktree
  (package
    (name "python-pybktree")
    (version "1.1")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pybktree" version))
       (sha256
        (base32 "0asd2lw9c5l5wi4z24k7gkhlprpdkcvs8d94szk56x9xvmy07h7f"))))
    (build-system pyproject-build-system)
    (arguments
     (list #:tests? #f))        ;no tests provided
    (native-inputs (list python-setuptools))
    (home-page "https://github.com/Jetsetter/pybktree")
    (synopsis "Pythonic BK-tree data structure")
    (description
     "This package provides a BK-tree data structure to allow fast querying of
close matches in Python.")
    (license license:expat)))

(define-public python-pybtex
  (package
    (name "python-pybtex")
    (version "0.25.0")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://codeberg.org/pybtex/pybtex")
             (commit version)))
       (file-name (git-file-name name version))
       (sha256
        (base32 "12rixrciizlvdxxja7qm6c02yzyslzd0jcv07niaii1ly0dg1fq4"))))
    (build-system pyproject-build-system)
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs (list python-latexcodec python-pyyaml))
    (home-page "https://pybtex.org/")
    (synopsis "BibTeX-compatible bibliography processor")
    (description
     "Pybtex is a BibTeX-compatible bibliography processor written in Python.
You can simply type pybtex instead of bibtex.")
    (license license:expat)))

(define-public python-pybtex-apa-style
  (package
    (name "python-pybtex-apa-style")
    (version "1.3")
    (source
     (origin
       (method url-fetch)
       (uri (pypi-uri "pybtex-apa-style" version))
       (sha256
        (base32 "1cmgcpcvs9jcw4yxhiy217hdngp9p9nlp5x6s2qmkwj0iwgd39iq"))))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-backend #~'custom
      #:test-flags
      #~(list "-c" (string-append "import sys, pybtex.plugin;"
                                  " sys.exit('apa' not"
                                  " in pybtex.plugin.enumerate_plugin_names"
                                  "('pybtex.style.labels'))"))))
    (native-inputs (list python-pybtex python-setuptools))
    (home-page "https://github.com/naeka/pybtex-apa-style")
    (synopsis "APA style for pybtex")
    (description
     "This package provides support for the APA style within pybtex.")
    (license license:expat)))

(define-public python-onetimepass
  (package
    (name "python-onetimepass")
    (version "1.0.1")
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
             (url "https://github.com/tadeck/onetimepass/")
             (commit (string-append "v" version))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "0wmv62l3r8r4428gdzyj80lhgadfqvj220khz1wnm9alyzg60wkh"))))
    (build-system pyproject-build-system)
    (arguments (list #:tests? #f))  ; Requires unpackaged timecop.
    (native-inputs (list python-setuptools))
    (propagated-inputs (list python-six))
    (home-page "https://github.com/tadeck/onetimepass/")
    (synopsis "One-time password library")
    (description
     "Python one-time password library for HMAC-based (HOTP) and time-based
(TOTP) passwords.")
    (license license:expat)))

(define-public python-online-judge-api-client
  (package
    (name "python-online-judge-api-client")
    (properties '((commit . "615c345f169e2603e0b907287559a4535fc3c6f9")
                  (revision . "0")))
    (version (git-version "10.10.1"
                          (assoc-ref properties 'revision)
                          (assoc-ref properties 'commit)))
    (source
     (origin
       (method git-fetch)
       (uri (git-reference
              (url "https://github.com/online-judge-tools/api-client")
              (commit (assoc-ref properties 'commit))))
       (file-name (git-file-name name version))
       (sha256
        (base32 "13m3cxv6bd3igj6649149xb27ljmzqzpli6hpfrywvgbm238hbws"))
       (patches
        (search-patches "python-online-judge-api-client-tests.patch"))
       ))
    (build-system pyproject-build-system)
    (arguments
     (list
      #:test-flags
      #~(list "--ignore-glob=tests/get_contest_*.py"
              "--ignore-glob=tests/get_problem_*.py")
      #:phases
      #~(modify-phases %standard-phases
          (add-before 'check 'configure-tests
            (lambda* (#:key inputs outputs #:allow-other-keys)
              (delete-file-recursively
               (string-append (site-packages inputs outputs)
                              "/tests"))
              (call-with-output-file "pytest.ini"
                (lambda (port)
                  (format port "\
[pytest]
python_files = tests/*.py"))))))))
    (native-inputs (list python-pytest python-setuptools))
    (propagated-inputs
     (list python-appdirs
           python-beautifulsoup4
           python-colorlog
           python-lxml
           python-requests
           python-toml
           python-jsonschema))
    (home-page "https://github.com/online-judge-tools/api-client")
    (synopsis "API client for vari